package com.ejie.y41a.model;

import java.math.BigDecimal;
import java.util.Date;

import javax.validation.constraints.NotNull;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

import com.ejie.y41a.control.Y41aJsonDateSerializer;
import com.ejie.y41a.control.Y41aJsonDateDeserializer;

/**
 * * ActuacionDetalle generated by UDA, 22-mar-2012 16:48:03.
 * 
 *  
 */

public class VisitaDetalle implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// Campaña
	private String tipo;
	private String codigo;
	private String descripcion;

	// Visita
	private String accodigo;
	private String accoor;
	@NotEmpty(message = "required.numeroOrdenActa")
	@Length(max = 12, message = "length.numOrdenActa")
	private String acnror;
	private BigDecimal acnran;
	@NotNull(message = "required.fechaVisita")
	private Date acfele;
	private Date acfere;
	private String accoinun;
	private String accoindo;

	// Tipo documento acta
	@NotEmpty(message = "required.tipoDocumento")
	private String tdcodigo;
	private String tdnombre;

	// Compareciente Visita
	private String acnoco;
	private String acape1co;
	private String acape2co;
	private String acdnico;
	private String accoco;
	private String acdirco;
	private String accoloco;
	private String acnrcpco;
	private String acnrtfco;
	private String acnoraPaisId;
	private String acnoraPaisNombre;
	private String acnoraProvinciaId;
	private String acnombreProvincia;
	private String acnoraMunicipioId;
	private String acnombreMunicipio;
	private String acnoraLocalidadId;
	private String acnombreLocalidad;
	private String acnoraCalleId;
	private String acnombreCalle;
	private String acnoraCpId;
	private String acnombreCp;
	private String acnoraPortalId;
	private String acnombrePortal;
	private String acnombrePiso;
	private String acdireccion_nocapv;
	private String dirAntiguaCompletaCompareciente;

	// Establecimiento Visita
	@NotEmpty(message = "required.establecimientovisitado")
	private String escodigoVisita;
	private String esnombreVisita;
	private String esnifVisita;
	private String esnocoVisita;
	private String esnodirVisita;
	private String escoloVisita;
	private String esnrcopoVisita;
	private String esnrtelVisita;
	private String esnrfaxVisita;
	private String escopaVisita;
	private String esinadarVisita;
	private Date esfeadarVisita;
	private String escoemVisita;
	private String esnrtel2Visita;
	private Date esfebaVisita;
	private String esnoloVisita;
	private String escomapvVisita;
	private String escocaVisita;
	private String esnomuVisita;
	private String esteurlVisita;
	private String esnoraPaisIdVisita;
	private String esnoraPaisNombreVisita;
	private String provinciaIdVisita;
	private String esnombreProvinciaVisita;
	private String municipioIdVisita;
	private String esnombreMunicipioVisita;
	private String localidadIdVisita;
	private String esnombreLocalidadVisita;
	private String calleIdVisita;
	private String calleId_labelVisita;
	private String cpIdVisita;
	private String esnombreCpVisita;
	private String portalIdVisita;
	private String esnombrePortalVisita;
	private String esnombrePisoVisita;
	private String esdireccion_nocapvVisita;
	private String eacodigoVisita;
	private String avcodigoVisita;
	private String avnombreVisita;
	private String avnombreeVisita;
	private String secodigoVisita;
	private String senombreVisita;
	private String senombreeVisita;
	private String eainprseVisita;
	private String direccionAntiguaCompletaVisita;

	// Actuacion
	private String atcodigo;
	private BigDecimal atnror;

	// CampahnaRecib
	private String s4codigo;
	// AlertaRecib
	private String s5codigo;
	// DenunciaRecib
	private String s6codigo;

	/**
	 * 
	 */
	public VisitaDetalle() {
	}

	/**
	 * @param tipo
	 * @param codigo
	 * @param descripcion
	 * @param accodigo
	 * @param accoor
	 * @param acnror
	 * @param acnran
	 * @param acfele
	 * @param acfere
	 * @param accoinun
	 * @param accoindo
	 * @param tdcodigo
	 * @param tdnombre
	 * @param acnoco
	 * @param acape1co
	 * @param acape2co
	 * @param acdnico
	 * @param accoco
	 * @param acdirco
	 * @param accoloco
	 * @param acnrcpco
	 * @param acnrtfco
	 * @param acnoraPaisId
	 * @param acnoraPaisNombre
	 * @param acnoraProvinciaId
	 * @param acnombreProvincia
	 * @param acnoraMunicipioId
	 * @param acnombreMunicipio
	 * @param acnoraLocalidadId
	 * @param acnombreLocalidad
	 * @param acnoraCalleId
	 * @param acnombreCalle
	 * @param acnoraCpId
	 * @param acnombreCp
	 * @param acnoraPortalId
	 * @param acnombrePortal
	 * @param acnombrePiso
	 * @param acdireccion_nocapv
	 * @param dirAntiguaCompletaCompareciente
	 * @param escodigoVisita
	 * @param esnombreVisita
	 * @param esnifVisita
	 * @param esnocoVisita
	 * @param esnodirVisita
	 * @param escoloVisita
	 * @param esnrcopoVisita
	 * @param esnrtelVisita
	 * @param esnrfaxVisita
	 * @param escopaVisita
	 * @param esinadarVisita
	 * @param esfeadarVisita
	 * @param escoemVisita
	 * @param esnrtel2Visita
	 * @param esfebaVisita
	 * @param esnoloVisita
	 * @param escomapvVisita
	 * @param escocaVisita
	 * @param esnomuVisita
	 * @param esteurlVisita
	 * @param esnoraPaisIdVisita
	 * @param esnoraPaisNombreVisita
	 * @param provinciaIdVisita
	 * @param esnombreProvinciaVisita
	 * @param municipioIdVisita
	 * @param esnombreMunicipioVisita
	 * @param localidadIdVisita
	 * @param esnombreLocalidadVisita
	 * @param calleIdVisita
	 * @param calleId_labelVisita
	 * @param cpIdVisita
	 * @param esnombreCpVisita
	 * @param portalIdVisita
	 * @param esnombrePortalVisita
	 * @param esnombrePisoVisita
	 * @param esdireccion_nocapvVisita
	 * @param eacodigoVisita
	 * @param avcodigoVisita
	 * @param avnombreVisita
	 * @param avnombreeVisita
	 * @param secodigoVisita
	 * @param senombreVisita
	 * @param senombreeVisita
	 * @param eainprseVisita
	 * @param direccionAntiguaCompletaVisita
	 * @param atcodigo
	 * @param atnror
	 * @param s4codigo
	 * @param s5codigo
	 * @param s6codigo
	 */
	public VisitaDetalle(String tipo, String codigo, String descripcion,
			String accodigo, String accoor, String acnror, BigDecimal acnran,
			Date acfele, Date acfere, String accoinun, String accoindo,
			String tdcodigo, String tdnombre, String acnoco, String acape1co,
			String acape2co, String acdnico, String accoco, String acdirco,
			String accoloco, String acnrcpco, String acnrtfco,
			String acnoraPaisId, String acnoraPaisNombre,
			String acnoraProvinciaId, String acnombreProvincia,
			String acnoraMunicipioId, String acnombreMunicipio,
			String acnoraLocalidadId, String acnombreLocalidad,
			String acnoraCalleId, String acnombreCalle, String acnoraCpId,
			String acnombreCp, String acnoraPortalId, String acnombrePortal,
			String acnombrePiso, String acdireccion_nocapv,
			String dirAntiguaCompletaCompareciente, String escodigoVisita,
			String esnombreVisita, String esnifVisita, String esnocoVisita,
			String esnodirVisita, String escoloVisita, String esnrcopoVisita,
			String esnrtelVisita, String esnrfaxVisita, String escopaVisita,
			String esinadarVisita, Date esfeadarVisita, String escoemVisita,
			String esnrtel2Visita, Date esfebaVisita, String esnoloVisita,
			String escomapvVisita, String escocaVisita, String esnomuVisita,
			String esteurlVisita, String esnoraPaisIdVisita,
			String esnoraPaisNombreVisita, String provinciaIdVisita,
			String esnombreProvinciaVisita, String municipioIdVisita,
			String esnombreMunicipioVisita, String localidadIdVisita,
			String esnombreLocalidadVisita, String calleIdVisita,
			String calleId_labelVisita, String cpIdVisita,
			String esnombreCpVisita, String portalIdVisita,
			String esnombrePortalVisita, String esnombrePisoVisita,
			String esdireccion_nocapvVisita, String eacodigoVisita,
			String avcodigoVisita, String avnombreVisita,
			String avnombreeVisita, String secodigoVisita,
			String senombreVisita, String senombreeVisita,
			String eainprseVisita, String direccionAntiguaCompletaVisita,
			String atcodigo, BigDecimal atnror, String s4codigo,
			String s5codigo, String s6codigo) {
		this.tipo = tipo;
		this.codigo = codigo;
		this.descripcion = descripcion;
		this.accodigo = accodigo;
		this.accoor = accoor;
		this.acnror = acnror;
		this.acnran = acnran;
		this.acfele = acfele;
		this.acfere = acfere;
		this.accoinun = accoinun;
		this.accoindo = accoindo;
		this.tdcodigo = tdcodigo;
		this.tdnombre = tdnombre;
		this.acnoco = acnoco;
		this.acape1co = acape1co;
		this.acape2co = acape2co;
		this.acdnico = acdnico;
		this.accoco = accoco;
		this.acdirco = acdirco;
		this.accoloco = accoloco;
		this.acnrcpco = acnrcpco;
		this.acnrtfco = acnrtfco;
		this.acnoraPaisId = acnoraPaisId;
		this.acnoraPaisNombre = acnoraPaisNombre;
		this.acnoraProvinciaId = acnoraProvinciaId;
		this.acnombreProvincia = acnombreProvincia;
		this.acnoraMunicipioId = acnoraMunicipioId;
		this.acnombreMunicipio = acnombreMunicipio;
		this.acnoraLocalidadId = acnoraLocalidadId;
		this.acnombreLocalidad = acnombreLocalidad;
		this.acnoraCalleId = acnoraCalleId;
		this.acnombreCalle = acnombreCalle;
		this.acnoraCpId = acnoraCpId;
		this.acnombreCp = acnombreCp;
		this.acnoraPortalId = acnoraPortalId;
		this.acnombrePortal = acnombrePortal;
		this.acnombrePiso = acnombrePiso;
		this.acdireccion_nocapv = acdireccion_nocapv;
		this.dirAntiguaCompletaCompareciente = dirAntiguaCompletaCompareciente;
		this.escodigoVisita = escodigoVisita;
		this.esnombreVisita = esnombreVisita;
		this.esnifVisita = esnifVisita;
		this.esnocoVisita = esnocoVisita;
		this.esnodirVisita = esnodirVisita;
		this.escoloVisita = escoloVisita;
		this.esnrcopoVisita = esnrcopoVisita;
		this.esnrtelVisita = esnrtelVisita;
		this.esnrfaxVisita = esnrfaxVisita;
		this.escopaVisita = escopaVisita;
		this.esinadarVisita = esinadarVisita;
		this.esfeadarVisita = esfeadarVisita;
		this.escoemVisita = escoemVisita;
		this.esnrtel2Visita = esnrtel2Visita;
		this.esfebaVisita = esfebaVisita;
		this.esnoloVisita = esnoloVisita;
		this.escomapvVisita = escomapvVisita;
		this.escocaVisita = escocaVisita;
		this.esnomuVisita = esnomuVisita;
		this.esteurlVisita = esteurlVisita;
		this.esnoraPaisIdVisita = esnoraPaisIdVisita;
		this.esnoraPaisNombreVisita = esnoraPaisNombreVisita;
		this.provinciaIdVisita = provinciaIdVisita;
		this.esnombreProvinciaVisita = esnombreProvinciaVisita;
		this.municipioIdVisita = municipioIdVisita;
		this.esnombreMunicipioVisita = esnombreMunicipioVisita;
		this.localidadIdVisita = localidadIdVisita;
		this.esnombreLocalidadVisita = esnombreLocalidadVisita;
		this.calleIdVisita = calleIdVisita;
		this.calleId_labelVisita = calleId_labelVisita;
		this.cpIdVisita = cpIdVisita;
		this.esnombreCpVisita = esnombreCpVisita;
		this.portalIdVisita = portalIdVisita;
		this.esnombrePortalVisita = esnombrePortalVisita;
		this.esnombrePisoVisita = esnombrePisoVisita;
		this.esdireccion_nocapvVisita = esdireccion_nocapvVisita;
		this.eacodigoVisita = eacodigoVisita;
		this.avcodigoVisita = avcodigoVisita;
		this.avnombreVisita = avnombreVisita;
		this.avnombreeVisita = avnombreeVisita;
		this.secodigoVisita = secodigoVisita;
		this.senombreVisita = senombreVisita;
		this.senombreeVisita = senombreeVisita;
		this.eainprseVisita = eainprseVisita;
		this.direccionAntiguaCompletaVisita = direccionAntiguaCompletaVisita;
		this.atcodigo = atcodigo;
		this.atnror = atnror;
		this.s4codigo = s4codigo;
		this.s5codigo = s5codigo;
		this.s6codigo = s6codigo;
	}

	/**
	 * @return the atcodigo
	 */
	public String getAtcodigo() {
		return atcodigo;
	}

	/**
	 * @param atcodigo
	 *            the atcodigo to set
	 */
	public void setAtcodigo(String atcodigo) {
		this.atcodigo = atcodigo;
	}

	/**
	 * @return the atnror
	 */
	public BigDecimal getAtnror() {
		return atnror;
	}

	/**
	 * @param atnror
	 *            the atnror to set
	 */
	public void setAtnror(BigDecimal atnror) {
		this.atnror = atnror;
	}

	/**
	 * @return the tipo
	 */
	public String getTipo() {
		return tipo;
	}

	/**
	 * @param tipo
	 *            the tipo to set
	 */
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}

	/**
	 * @return the codigo
	 */
	public String getCodigo() {
		return codigo;
	}

	/**
	 * @param codigo
	 *            the codigo to set
	 */
	public void setCodigo(String codigo) {
		this.codigo = codigo;
	}

	/**
	 * @return the descripcion
	 */
	public String getDescripcion() {
		return descripcion;
	}

	/**
	 * @param descripcion
	 *            the descripcion to set
	 */
	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}

	/**
	 * @return the accodigo
	 */
	public String getAccodigo() {
		return accodigo;
	}

	/**
	 * @param accodigo
	 *            the accodigo to set
	 */
	public void setAccodigo(String accodigo) {
		this.accodigo = accodigo;
	}

	/**
	 * @return the accoor
	 */
	public String getAccoor() {
		return accoor;
	}

	/**
	 * @param accoor
	 *            the accoor to set
	 */
	public void setAccoor(String accoor) {
		this.accoor = accoor;
	}

	/**
	 * @return the acnror
	 */
	public String getAcnror() {
		return acnror;
	}

	/**
	 * @param acnror
	 *            the acnror to set
	 */
	public void setAcnror(String acnror) {
		this.acnror = acnror;
	}

	/**
	 * @return the acnran
	 */
	public BigDecimal getAcnran() {
		return acnran;
	}

	/**
	 * @param acnran
	 *            the acnran to set
	 */
	public void setAcnran(BigDecimal acnran) {
		this.acnran = acnran;
	}

	/**
	 * @return the acfele
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getAcfele() {
		return acfele;
	}

	/**
	 * @param acfele
	 *            the acfele to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setAcfele(Date acfele) {
		this.acfele = acfele;
	}

	/**
	 * @return the acfere
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getAcfere() {
		return acfere;
	}

	/**
	 * @param acfere
	 *            the acfere to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setAcfere(Date acfere) {
		this.acfere = acfere;
	}

	/**
	 * @return the accoinun
	 */
	public String getAccoinun() {
		return accoinun;
	}

	/**
	 * @param accoinun
	 *            the accoinun to set
	 */
	public void setAccoinun(String accoinun) {
		this.accoinun = accoinun;
	}

	/**
	 * @return the accoindo
	 */
	public String getAccoindo() {
		return accoindo;
	}

	/**
	 * @param accoindo
	 *            the accoindo to set
	 */
	public void setAccoindo(String accoindo) {
		this.accoindo = accoindo;
	}

	/**
	 * @return the tdcodigo
	 */
	public String getTdcodigo() {
		return tdcodigo;
	}

	/**
	 * @param tdcodigo
	 *            the tdcodigo to set
	 */
	public void setTdcodigo(String tdcodigo) {
		this.tdcodigo = tdcodigo;
	}

	/**
	 * @return the tdnombre
	 */
	public String getTdnombre() {
		return tdnombre;
	}

	/**
	 * @param tdnombre
	 *            the tdnombre to set
	 */
	public void setTdnombre(String tdnombre) {
		this.tdnombre = tdnombre;
	}

	/**
	 * @return the acnoco
	 */
	public String getAcnoco() {
		return acnoco;
	}

	/**
	 * @param acnoco
	 *            the acnoco to set
	 */
	public void setAcnoco(String acnoco) {
		this.acnoco = acnoco;
	}

	/**
	 * @return the acape1co
	 */
	public String getAcape1co() {
		return acape1co;
	}

	/**
	 * @param acape1co
	 *            the acape1co to set
	 */
	public void setAcape1co(String acape1co) {
		this.acape1co = acape1co;
	}

	/**
	 * @return the acape2co
	 */
	public String getAcape2co() {
		return acape2co;
	}

	/**
	 * @param acape2co
	 *            the acape2co to set
	 */
	public void setAcape2co(String acape2co) {
		this.acape2co = acape2co;
	}

	/**
	 * @return the acdnico
	 */
	public String getAcdnico() {
		return acdnico;
	}

	/**
	 * @param acdnico
	 *            the acdnico to set
	 */
	public void setAcdnico(String acdnico) {
		this.acdnico = acdnico;
	}

	/**
	 * @return the accoco
	 */
	public String getAccoco() {
		return accoco;
	}

	/**
	 * @param accoco
	 *            the accoco to set
	 */
	public void setAccoco(String accoco) {
		this.accoco = accoco;
	}

	/**
	 * @return the acdirco
	 */
	public String getAcdirco() {
		return acdirco;
	}

	/**
	 * @param acdirco
	 *            the acdirco to set
	 */
	public void setAcdirco(String acdirco) {
		this.acdirco = acdirco;
	}

	/**
	 * @return the accoloco
	 */
	public String getAccoloco() {
		return accoloco;
	}

	/**
	 * @param accoloco
	 *            the accoloco to set
	 */
	public void setAccoloco(String accoloco) {
		this.accoloco = accoloco;
	}

	/**
	 * @return the acnrcpco
	 */
	public String getAcnrcpco() {
		return acnrcpco;
	}

	/**
	 * @param acnrcpco
	 *            the acnrcpco to set
	 */
	public void setAcnrcpco(String acnrcpco) {
		this.acnrcpco = acnrcpco;
	}

	/**
	 * @return the acnrtfco
	 */
	public String getAcnrtfco() {
		return acnrtfco;
	}

	/**
	 * @param acnrtfco
	 *            the acnrtfco to set
	 */
	public void setAcnrtfco(String acnrtfco) {
		this.acnrtfco = acnrtfco;
	}

	/**
	 * @return the acnoraPaisId
	 */
	public String getAcnoraPaisId() {
		return acnoraPaisId;
	}

	/**
	 * @param acnoraPaisId
	 *            the acnoraPaisId to set
	 */
	public void setAcnoraPaisId(String acnoraPaisId) {
		this.acnoraPaisId = acnoraPaisId;
	}

	/**
	 * @return the acnoraPaisNombre
	 */
	public String getAcnoraPaisNombre() {
		return acnoraPaisNombre;
	}

	/**
	 * @param acnoraPaisNombre
	 *            the acnoraPaisNombre to set
	 */
	public void setAcnoraPaisNombre(String acnoraPaisNombre) {
		this.acnoraPaisNombre = acnoraPaisNombre;
	}

	/**
	 * @return the acnoraProvinciaId
	 */
	public String getAcnoraProvinciaId() {
		return acnoraProvinciaId;
	}

	/**
	 * @param acnoraProvinciaId
	 *            the acnoraProvinciaId to set
	 */
	public void setAcnoraProvinciaId(String acnoraProvinciaId) {
		this.acnoraProvinciaId = acnoraProvinciaId;
	}

	/**
	 * @return the acnombreProvincia
	 */
	public String getAcnombreProvincia() {
		return acnombreProvincia;
	}

	/**
	 * @param acnombreProvincia
	 *            the acnombreProvincia to set
	 */
	public void setAcnombreProvincia(String acnombreProvincia) {
		this.acnombreProvincia = acnombreProvincia;
	}

	/**
	 * @return the acnoraMunicipioId
	 */
	public String getAcnoraMunicipioId() {
		return acnoraMunicipioId;
	}

	/**
	 * @param acnoraMunicipioId
	 *            the acnoraMunicipioId to set
	 */
	public void setAcnoraMunicipioId(String acnoraMunicipioId) {
		this.acnoraMunicipioId = acnoraMunicipioId;
	}

	/**
	 * @return the acnombreMunicipio
	 */
	public String getAcnombreMunicipio() {
		return acnombreMunicipio;
	}

	/**
	 * @param acnombreMunicipio
	 *            the acnombreMunicipio to set
	 */
	public void setAcnombreMunicipio(String acnombreMunicipio) {
		this.acnombreMunicipio = acnombreMunicipio;
	}

	/**
	 * @return the acnoraLocalidadId
	 */
	public String getAcnoraLocalidadId() {
		return acnoraLocalidadId;
	}

	/**
	 * @param acnoraLocalidadId
	 *            the acnoraLocalidadId to set
	 */
	public void setAcnoraLocalidadId(String acnoraLocalidadId) {
		this.acnoraLocalidadId = acnoraLocalidadId;
	}

	/**
	 * @return the acnombreLocalidad
	 */
	public String getAcnombreLocalidad() {
		return acnombreLocalidad;
	}

	/**
	 * @param acnombreLocalidad
	 *            the acnombreLocalidad to set
	 */
	public void setAcnombreLocalidad(String acnombreLocalidad) {
		this.acnombreLocalidad = acnombreLocalidad;
	}

	/**
	 * @return the acnoraCalleId
	 */
	public String getAcnoraCalleId() {
		return acnoraCalleId;
	}

	/**
	 * @param acnoraCalleId
	 *            the acnoraCalleId to set
	 */
	public void setAcnoraCalleId(String acnoraCalleId) {
		this.acnoraCalleId = acnoraCalleId;
	}

	/**
	 * @return the acnombreCalle
	 */
	public String getAcnombreCalle() {
		return acnombreCalle;
	}

	/**
	 * @param acnombreCalle
	 *            the acnombreCalle to set
	 */
	public void setAcnombreCalle(String acnombreCalle) {
		this.acnombreCalle = acnombreCalle;
	}

	/**
	 * @return the acnoraCpId
	 */
	public String getAcnoraCpId() {
		return acnoraCpId;
	}

	/**
	 * @param acnoraCpId
	 *            the acnoraCpId to set
	 */
	public void setAcnoraCpId(String acnoraCpId) {
		this.acnoraCpId = acnoraCpId;
	}

	/**
	 * @return the acnombreCp
	 */
	public String getAcnombreCp() {
		return acnombreCp;
	}

	/**
	 * @param acnombreCp
	 *            the acnombreCp to set
	 */
	public void setAcnombreCp(String acnombreCp) {
		this.acnombreCp = acnombreCp;
	}

	/**
	 * @return the acnoraPortalId
	 */
	public String getAcnoraPortalId() {
		return acnoraPortalId;
	}

	/**
	 * @param acnoraPortalId
	 *            the acnoraPortalId to set
	 */
	public void setAcnoraPortalId(String acnoraPortalId) {
		this.acnoraPortalId = acnoraPortalId;
	}

	/**
	 * @return the acnombrePortal
	 */
	public String getAcnombrePortal() {
		return acnombrePortal;
	}

	/**
	 * @param acnombrePortal
	 *            the acnombrePortal to set
	 */
	public void setAcnombrePortal(String acnombrePortal) {
		this.acnombrePortal = acnombrePortal;
	}

	/**
	 * @return the acnombrePiso
	 */
	public String getAcnombrePiso() {
		return acnombrePiso;
	}

	/**
	 * @param acnombrePiso
	 *            the acnombrePiso to set
	 */
	public void setAcnombrePiso(String acnombrePiso) {
		this.acnombrePiso = acnombrePiso;
	}

	/**
	 * @return the dirAntiguaCompletaCompareciente
	 */
	public String getDirAntiguaCompletaCompareciente() {
		return dirAntiguaCompletaCompareciente;
	}

	/**
	 * @param dirAntiguaCompletaCompareciente
	 *            the dirAntiguaCompletaCompareciente to set
	 */
	public void setDirAntiguaCompletaCompareciente(
			String dirAntiguaCompletaCompareciente) {
		this.dirAntiguaCompletaCompareciente = dirAntiguaCompletaCompareciente;
	}

	/**
	 * @return the escodigoVisita
	 */
	public String getEscodigoVisita() {
		return escodigoVisita;
	}

	/**
	 * @param escodigoVisita
	 *            the escodigoVisita to set
	 */
	public void setEscodigoVisita(String escodigoVisita) {
		this.escodigoVisita = escodigoVisita;
	}

	/**
	 * @return the esnombreVisita
	 */
	public String getEsnombreVisita() {
		return esnombreVisita;
	}

	/**
	 * @param esnombreVisita
	 *            the esnombreVisita to set
	 */
	public void setEsnombreVisita(String esnombreVisita) {
		this.esnombreVisita = esnombreVisita;
	}

	/**
	 * @return the esnifVisita
	 */
	public String getEsnifVisita() {
		return esnifVisita;
	}

	/**
	 * @param esnifVisita
	 *            the esnifVisita to set
	 */
	public void setEsnifVisita(String esnifVisita) {
		this.esnifVisita = esnifVisita;
	}

	/**
	 * @return the esnocoVisita
	 */
	public String getEsnocoVisita() {
		return esnocoVisita;
	}

	/**
	 * @param esnocoVisita
	 *            the esnocoVisita to set
	 */
	public void setEsnocoVisita(String esnocoVisita) {
		this.esnocoVisita = esnocoVisita;
	}

	/**
	 * @return the esnodirVisita
	 */
	public String getEsnodirVisita() {
		return esnodirVisita;
	}

	/**
	 * @param esnodirVisita
	 *            the esnodirVisita to set
	 */
	public void setEsnodirVisita(String esnodirVisita) {
		this.esnodirVisita = esnodirVisita;
	}

	/**
	 * @return the escoloVisita
	 */
	public String getEscoloVisita() {
		return escoloVisita;
	}

	/**
	 * @param escoloVisita
	 *            the escoloVisita to set
	 */
	public void setEscoloVisita(String escoloVisita) {
		this.escoloVisita = escoloVisita;
	}

	/**
	 * @return the esnrcopoVisita
	 */
	public String getEsnrcopoVisita() {
		return esnrcopoVisita;
	}

	/**
	 * @param esnrcopoVisita
	 *            the esnrcopoVisita to set
	 */
	public void setEsnrcopoVisita(String esnrcopoVisita) {
		this.esnrcopoVisita = esnrcopoVisita;
	}

	/**
	 * @return the esnrtelVisita
	 */
	public String getEsnrtelVisita() {
		return esnrtelVisita;
	}

	/**
	 * @param esnrtelVisita
	 *            the esnrtelVisita to set
	 */
	public void setEsnrtelVisita(String esnrtelVisita) {
		this.esnrtelVisita = esnrtelVisita;
	}

	/**
	 * @return the esnrfaxVisita
	 */
	public String getEsnrfaxVisita() {
		return esnrfaxVisita;
	}

	/**
	 * @param esnrfaxVisita
	 *            the esnrfaxVisita to set
	 */
	public void setEsnrfaxVisita(String esnrfaxVisita) {
		this.esnrfaxVisita = esnrfaxVisita;
	}

	/**
	 * @return the escopaVisita
	 */
	public String getEscopaVisita() {
		return escopaVisita;
	}

	/**
	 * @param escopaVisita
	 *            the escopaVisita to set
	 */
	public void setEscopaVisita(String escopaVisita) {
		this.escopaVisita = escopaVisita;
	}

	/**
	 * @return the esinadarVisita
	 */
	public String getEsinadarVisita() {
		return esinadarVisita;
	}

	/**
	 * @param esinadarVisita
	 *            the esinadarVisita to set
	 */
	public void setEsinadarVisita(String esinadarVisita) {
		this.esinadarVisita = esinadarVisita;
	}

	/**
	 * @return the esfeadarVisita
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getEsfeadarVisita() {
		return esfeadarVisita;
	}

	/**
	 * @param esfeadarVisita
	 *            the esfeadarVisita to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setEsfeadarVisita(Date esfeadarVisita) {
		this.esfeadarVisita = esfeadarVisita;
	}

	/**
	 * @return the escoemVisita
	 */
	public String getEscoemVisita() {
		return escoemVisita;
	}

	/**
	 * @param escoemVisita
	 *            the escoemVisita to set
	 */
	public void setEscoemVisita(String escoemVisita) {
		this.escoemVisita = escoemVisita;
	}

	/**
	 * @return the esnrtel2Visita
	 */
	public String getEsnrtel2Visita() {
		return esnrtel2Visita;
	}

	/**
	 * @param esnrtel2Visita
	 *            the esnrtel2Visita to set
	 */
	public void setEsnrtel2Visita(String esnrtel2Visita) {
		this.esnrtel2Visita = esnrtel2Visita;
	}

	/**
	 * @return the esfebaVisita
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getEsfebaVisita() {
		return esfebaVisita;
	}

	/**
	 * @param esfebaVisita
	 *            the esfebaVisita to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setEsfebaVisita(Date esfebaVisita) {
		this.esfebaVisita = esfebaVisita;
	}

	/**
	 * @return the esnoloVisita
	 */
	public String getEsnoloVisita() {
		return esnoloVisita;
	}

	/**
	 * @param esnoloVisita
	 *            the esnoloVisita to set
	 */
	public void setEsnoloVisita(String esnoloVisita) {
		this.esnoloVisita = esnoloVisita;
	}

	/**
	 * @return the escomapvVisita
	 */
	public String getEscomapvVisita() {
		return escomapvVisita;
	}

	/**
	 * @param escomapvVisita
	 *            the escomapvVisita to set
	 */
	public void setEscomapvVisita(String escomapvVisita) {
		this.escomapvVisita = escomapvVisita;
	}

	/**
	 * @return the escocaVisita
	 */
	public String getEscocaVisita() {
		return escocaVisita;
	}

	/**
	 * @param escocaVisita
	 *            the escocaVisita to set
	 */
	public void setEscocaVisita(String escocaVisita) {
		this.escocaVisita = escocaVisita;
	}

	/**
	 * @return the esnomuVisita
	 */
	public String getEsnomuVisita() {
		return esnomuVisita;
	}

	/**
	 * @param esnomuVisita
	 *            the esnomuVisita to set
	 */
	public void setEsnomuVisita(String esnomuVisita) {
		this.esnomuVisita = esnomuVisita;
	}

	/**
	 * @return the esteurlVisita
	 */
	public String getEsteurlVisita() {
		return esteurlVisita;
	}

	/**
	 * @param esteurlVisita
	 *            the esteurlVisita to set
	 */
	public void setEsteurlVisita(String esteurlVisita) {
		this.esteurlVisita = esteurlVisita;
	}

	/**
	 * @return the esnoraPaisIdVisita
	 */
	public String getEsnoraPaisIdVisita() {
		return esnoraPaisIdVisita;
	}

	/**
	 * @param esnoraPaisIdVisita
	 *            the esnoraPaisIdVisita to set
	 */
	public void setEsnoraPaisIdVisita(String esnoraPaisIdVisita) {
		this.esnoraPaisIdVisita = esnoraPaisIdVisita;
	}

	/**
	 * @return the esnoraPaisNombreVisita
	 */
	public String getEsnoraPaisNombreVisita() {
		return esnoraPaisNombreVisita;
	}

	/**
	 * @param esnoraPaisNombreVisita
	 *            the esnoraPaisNombreVisita to set
	 */
	public void setEsnoraPaisNombreVisita(String esnoraPaisNombreVisita) {
		this.esnoraPaisNombreVisita = esnoraPaisNombreVisita;
	}

	/**
	 * @return the provinciaIdVisita
	 */
	public String getProvinciaIdVisita() {
		return provinciaIdVisita;
	}

	/**
	 * @param provinciaIdVisita
	 *            the provinciaIdVisita to set
	 */
	public void setProvinciaIdVisita(String provinciaIdVisita) {
		this.provinciaIdVisita = provinciaIdVisita;
	}

	/**
	 * @return the esnombreProvinciaVisita
	 */
	public String getEsnombreProvinciaVisita() {
		return esnombreProvinciaVisita;
	}

	/**
	 * @param esnombreProvinciaVisita
	 *            the esnombreProvinciaVisita to set
	 */
	public void setEsnombreProvinciaVisita(String esnombreProvinciaVisita) {
		this.esnombreProvinciaVisita = esnombreProvinciaVisita;
	}

	/**
	 * @return the municipioIdVisita
	 */
	public String getMunicipioIdVisita() {
		return municipioIdVisita;
	}

	/**
	 * @param municipioIdVisita
	 *            the municipioIdVisita to set
	 */
	public void setMunicipioIdVisita(String municipioIdVisita) {
		this.municipioIdVisita = municipioIdVisita;
	}

	/**
	 * @return the esnombreMunicipioVisita
	 */
	public String getEsnombreMunicipioVisita() {
		return esnombreMunicipioVisita;
	}

	/**
	 * @param esnombreMunicipioVisita
	 *            the esnombreMunicipioVisita to set
	 */
	public void setEsnombreMunicipioVisita(String esnombreMunicipioVisita) {
		this.esnombreMunicipioVisita = esnombreMunicipioVisita;
	}

	/**
	 * @return the localidadIdVisita
	 */
	public String getLocalidadIdVisita() {
		return localidadIdVisita;
	}

	/**
	 * @param localidadIdVisita
	 *            the localidadIdVisita to set
	 */
	public void setLocalidadIdVisita(String localidadIdVisita) {
		this.localidadIdVisita = localidadIdVisita;
	}

	/**
	 * @return the esnombreLocalidadVisita
	 */
	public String getEsnombreLocalidadVisita() {
		return esnombreLocalidadVisita;
	}

	/**
	 * @param esnombreLocalidadVisita
	 *            the esnombreLocalidadVisita to set
	 */
	public void setEsnombreLocalidadVisita(String esnombreLocalidadVisita) {
		this.esnombreLocalidadVisita = esnombreLocalidadVisita;
	}

	/**
	 * @return the calleIdVisita
	 */
	public String getCalleIdVisita() {
		return calleIdVisita;
	}

	/**
	 * @param calleIdVisita
	 *            the calleIdVisita to set
	 */
	public void setCalleIdVisita(String calleIdVisita) {
		this.calleIdVisita = calleIdVisita;
	}

	/**
	 * @return the calleId_labelVisita
	 */
	public String getCalleId_labelVisita() {
		return calleId_labelVisita;
	}

	/**
	 * @param calleId_labelVisita
	 *            the calleId_labelVisita to set
	 */
	public void setCalleId_labelVisita(String calleId_labelVisita) {
		this.calleId_labelVisita = calleId_labelVisita;
	}

	/**
	 * @return the cpIdVisita
	 */
	public String getCpIdVisita() {
		return cpIdVisita;
	}

	/**
	 * @param cpIdVisita
	 *            the cpIdVisita to set
	 */
	public void setCpIdVisita(String cpIdVisita) {
		this.cpIdVisita = cpIdVisita;
	}

	/**
	 * @return the esnombreCpVisita
	 */
	public String getEsnombreCpVisita() {
		return esnombreCpVisita;
	}

	/**
	 * @param esnombreCpVisita
	 *            the esnombreCpVisita to set
	 */
	public void setEsnombreCpVisita(String esnombreCpVisita) {
		this.esnombreCpVisita = esnombreCpVisita;
	}

	/**
	 * @return the portalIdVisita
	 */
	public String getPortalIdVisita() {
		return portalIdVisita;
	}

	/**
	 * @param portalIdVisita
	 *            the portalIdVisita to set
	 */
	public void setPortalIdVisita(String portalIdVisita) {
		this.portalIdVisita = portalIdVisita;
	}

	/**
	 * @return the esnombrePortalVisita
	 */
	public String getEsnombrePortalVisita() {
		return esnombrePortalVisita;
	}

	/**
	 * @param esnombrePortalVisita
	 *            the esnombrePortalVisita to set
	 */
	public void setEsnombrePortalVisita(String esnombrePortalVisita) {
		this.esnombrePortalVisita = esnombrePortalVisita;
	}

	/**
	 * @return the esnombrePisoVisita
	 */
	public String getEsnombrePisoVisita() {
		return esnombrePisoVisita;
	}

	/**
	 * @param esnombrePisoVisita
	 *            the esnombrePisoVisita to set
	 */
	public void setEsnombrePisoVisita(String esnombrePisoVisita) {
		this.esnombrePisoVisita = esnombrePisoVisita;
	}

	/**
	 * @return the eacodigoVisita
	 */
	public String getEacodigoVisita() {
		return eacodigoVisita;
	}

	/**
	 * @param eacodigoVisita
	 *            the eacodigoVisita to set
	 */
	public void setEacodigoVisita(String eacodigoVisita) {
		this.eacodigoVisita = eacodigoVisita;
	}

	/**
	 * @return the avcodigoVisita
	 */
	public String getAvcodigoVisita() {
		return avcodigoVisita;
	}

	/**
	 * @param avcodigoVisita
	 *            the avcodigoVisita to set
	 */
	public void setAvcodigoVisita(String avcodigoVisita) {
		this.avcodigoVisita = avcodigoVisita;
	}

	/**
	 * @return the avnombreVisita
	 */
	public String getAvnombreVisita() {
		return avnombreVisita;
	}

	/**
	 * @param avnombreVisita
	 *            the avnombreVisita to set
	 */
	public void setAvnombreVisita(String avnombreVisita) {
		this.avnombreVisita = avnombreVisita;
	}

	/**
	 * @return the avnombreeVisita
	 */
	public String getAvnombreeVisita() {
		return avnombreeVisita;
	}

	/**
	 * @param avnombreeVisita
	 *            the avnombreeVisita to set
	 */
	public void setAvnombreeVisita(String avnombreeVisita) {
		this.avnombreeVisita = avnombreeVisita;
	}

	/**
	 * @return the secodigoVisita
	 */
	public String getSecodigoVisita() {
		return secodigoVisita;
	}

	/**
	 * @param secodigoVisita
	 *            the secodigoVisita to set
	 */
	public void setSecodigoVisita(String secodigoVisita) {
		this.secodigoVisita = secodigoVisita;
	}

	/**
	 * @return the senombreVisita
	 */
	public String getSenombreVisita() {
		return senombreVisita;
	}

	/**
	 * @param senombreVisita
	 *            the senombreVisita to set
	 */
	public void setSenombreVisita(String senombreVisita) {
		this.senombreVisita = senombreVisita;
	}

	/**
	 * @return the senombreeVisita
	 */
	public String getSenombreeVisita() {
		return senombreeVisita;
	}

	/**
	 * @param senombreeVisita
	 *            the senombreeVisita to set
	 */
	public void setSenombreeVisita(String senombreeVisita) {
		this.senombreeVisita = senombreeVisita;
	}

	/**
	 * @return the eainprseVisita
	 */
	public String getEainprseVisita() {
		return eainprseVisita;
	}

	/**
	 * @param eainprseVisita
	 *            the eainprseVisita to set
	 */
	public void setEainprseVisita(String eainprseVisita) {
		this.eainprseVisita = eainprseVisita;
	}

	/**
	 * @return the direccionAntiguaCompletaVisita
	 */
	public String getDireccionAntiguaCompletaVisita() {
		return direccionAntiguaCompletaVisita;
	}

	/**
	 * @param direccionAntiguaCompletaVisita
	 *            the direccionAntiguaCompletaVisita to set
	 */
	public void setDireccionAntiguaCompletaVisita(
			String direccionAntiguaCompletaVisita) {
		this.direccionAntiguaCompletaVisita = direccionAntiguaCompletaVisita;
	}

	/**
	 * @return the s4codigo
	 */
	public String getS4codigo() {
		return s4codigo;
	}

	/**
	 * @param s4codigo
	 *            the s4codigo to set
	 */
	public void setS4codigo(String s4codigo) {
		this.s4codigo = s4codigo;
	}

	/**
	 * @return the s5codigo
	 */
	public String getS5codigo() {
		return s5codigo;
	}

	/**
	 * @param s5codigo
	 *            the s5codigo to set
	 */
	public void setS5codigo(String s5codigo) {
		this.s5codigo = s5codigo;
	}

	/**
	 * @return the s6codigo
	 */
	public String getS6codigo() {
		return s6codigo;
	}

	/**
	 * @param s6codigo
	 *            the s6codigo to set
	 */
	public void setS6codigo(String s6codigo) {
		this.s6codigo = s6codigo;
	}

	/**
	 * @return the acdireccion_nocapv
	 */
	public String getAcdireccion_nocapv() {
		return acdireccion_nocapv;
	}

	/**
	 * @param acdireccion_nocapv
	 *            the acdireccion_nocapv to set
	 */
	public void setAcdireccion_nocapv(String acdireccion_nocapv) {
		this.acdireccion_nocapv = acdireccion_nocapv;
	}

	/**
	 * @return the esdireccion_nocapvVisita
	 */
	public String getEsdireccion_nocapvVisita() {
		return esdireccion_nocapvVisita;
	}

	/**
	 * @param esdireccion_nocapvVisita
	 *            the esdireccion_nocapvVisita to set
	 */
	public void setEsdireccion_nocapvVisita(String esdireccion_nocapvVisita) {
		this.esdireccion_nocapvVisita = esdireccion_nocapvVisita;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "VisitaDetalle [tipo=" + tipo + ", codigo=" + codigo
				+ ", descripcion=" + descripcion + ", accodigo=" + accodigo
				+ ", accoor=" + accoor + ", acnror=" + acnror + ", acnran="
				+ acnran + ", acfele=" + acfele + ", acfere=" + acfere
				+ ", accoinun=" + accoinun + ", accoindo=" + accoindo
				+ ", tdcodigo=" + tdcodigo + ", tdnombre=" + tdnombre
				+ ", acnoco=" + acnoco + ", acape1co=" + acape1co
				+ ", acape2co=" + acape2co + ", acdnico=" + acdnico
				+ ", accoco=" + accoco + ", acdirco=" + acdirco + ", accoloco="
				+ accoloco + ", acnrcpco=" + acnrcpco + ", acnrtfco="
				+ acnrtfco + ", acnoraPaisId=" + acnoraPaisId
				+ ", acnoraPaisNombre=" + acnoraPaisNombre
				+ ", acnoraProvinciaId=" + acnoraProvinciaId
				+ ", acnombreProvincia=" + acnombreProvincia
				+ ", acnoraMunicipioId=" + acnoraMunicipioId
				+ ", acnombreMunicipio=" + acnombreMunicipio
				+ ", acnoraLocalidadId=" + acnoraLocalidadId
				+ ", acnombreLocalidad=" + acnombreLocalidad
				+ ", acnoraCalleId=" + acnoraCalleId + ", acnombreCalle="
				+ acnombreCalle + ", acnoraCpId=" + acnoraCpId
				+ ", acnombreCp=" + acnombreCp + ", acnoraPortalId="
				+ acnoraPortalId + ", acnombrePortal=" + acnombrePortal
				+ ", acnombrePiso=" + acnombrePiso + ", acdireccion_nocapv="
				+ acdireccion_nocapv + ", dirAntiguaCompletaCompareciente="
				+ dirAntiguaCompletaCompareciente + ", escodigoVisita="
				+ escodigoVisita + ", esnombreVisita=" + esnombreVisita
				+ ", esnifVisita=" + esnifVisita + ", esnocoVisita="
				+ esnocoVisita + ", esnodirVisita=" + esnodirVisita
				+ ", escoloVisita=" + escoloVisita + ", esnrcopoVisita="
				+ esnrcopoVisita + ", esnrtelVisita=" + esnrtelVisita
				+ ", esnrfaxVisita=" + esnrfaxVisita + ", escopaVisita="
				+ escopaVisita + ", esinadarVisita=" + esinadarVisita
				+ ", esfeadarVisita=" + esfeadarVisita + ", escoemVisita="
				+ escoemVisita + ", esnrtel2Visita=" + esnrtel2Visita
				+ ", esfebaVisita=" + esfebaVisita + ", esnoloVisita="
				+ esnoloVisita + ", escomapvVisita=" + escomapvVisita
				+ ", escocaVisita=" + escocaVisita + ", esnomuVisita="
				+ esnomuVisita + ", esteurlVisita=" + esteurlVisita
				+ ", esnoraPaisIdVisita=" + esnoraPaisIdVisita
				+ ", esnoraPaisNombreVisita=" + esnoraPaisNombreVisita
				+ ", provinciaIdVisita=" + provinciaIdVisita
				+ ", esnombreProvinciaVisita=" + esnombreProvinciaVisita
				+ ", municipioIdVisita=" + municipioIdVisita
				+ ", esnombreMunicipioVisita=" + esnombreMunicipioVisita
				+ ", localidadIdVisita=" + localidadIdVisita
				+ ", esnombreLocalidadVisita=" + esnombreLocalidadVisita
				+ ", calleIdVisita=" + calleIdVisita + ", calleId_labelVisita="
				+ calleId_labelVisita + ", cpIdVisita=" + cpIdVisita
				+ ", esnombreCpVisita=" + esnombreCpVisita
				+ ", portalIdVisita=" + portalIdVisita
				+ ", esnombrePortalVisita=" + esnombrePortalVisita
				+ ", esnombrePisoVisita=" + esnombrePisoVisita
				+ ", esdireccion_nocapvVisita=" + esdireccion_nocapvVisita
				+ ", eacodigoVisita=" + eacodigoVisita + ", avcodigoVisita="
				+ avcodigoVisita + ", avnombreVisita=" + avnombreVisita
				+ ", avnombreeVisita=" + avnombreeVisita + ", secodigoVisita="
				+ secodigoVisita + ", senombreVisita=" + senombreVisita
				+ ", senombreeVisita=" + senombreeVisita + ", eainprseVisita="
				+ eainprseVisita + ", direccionAntiguaCompletaVisita="
				+ direccionAntiguaCompletaVisita + ", atcodigo=" + atcodigo
				+ ", atnror=" + atnror + ", s4codigo=" + s4codigo
				+ ", s5codigo=" + s5codigo + ", s6codigo=" + s6codigo + "]";
	}

}
