package com.ejie.y41a.model;

import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;
import java.math.BigDecimal;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * * TramiteHecho generated by UDA, 22-feb-2012 17:30:25.
 * 
 *  
 */

public class TramiteHecho implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String ehcodigo;
	private Tramite tramite;
	private CensoMonitor censoMonitor;
	private HechoDenunciado hechoDenunciado;
	private Date ehfecha;
	private String ehhora;
	private String ehcodpor;
	private String ehcodpde;
	private String ehtexto;
	private String ehcozs;
	private BigDecimal ehcivihe;
	private Date ehacuse;
	private String ehenviomail;
	private String ehdiremail;
	private String codOrgTraslado;
	/**
	 * Resultado de la tramitación de traspaso.
	 */
	private String ehrespuestatraspaso;

	private Clob ehsiguientestramites;
	private Clob ehtextoacuerdo;
	private Clob ehinstrucinspecc;
	private Clob ehmotivorechazo;
	private Clob ehmotivorecurso;
	private Clob ehresumenalegacion;
	private Clob ehresumenmediacion;
	private Clob ehtextocomunicacion;
	private Clob ehintervinientes;
	private Clob ehjustificacioninfraccion;

	private List<DocumentoHecho> documentoHechosForQ5tramite = new ArrayList<DocumentoHecho>();
	private List<DocumentoHecho> documentoHechosForQ5trmail = new ArrayList<DocumentoHecho>();

	/**
	 * Method 'TramiteHecho'.
	 * 
	 */
	public TramiteHecho() {
	}

	/**
	 * Method 'TramiteHecho'.
	 * 
	 * @param ehcodigo
	 *            String
	 * @param ehfecha
	 *            Date
	 * @param ehhora
	 *            String
	 * @param ehcodpor
	 *            String
	 * @param ehcodpde
	 *            String
	 * @param ehtexto
	 *            String
	 * @param ehcozs
	 *            String
	 * @param ehcivihe
	 *            BigDecimal
	 * @param ehacuse
	 *            Date
	 * @param ehenviomail
	 *            String
	 * @param ehdiremail
	 *            String
	 * @param codOrgTraslado
	 *            String
	 * @param ehrespuestatraspaso
	 *            String resultado de la ejecución de traspaso
	 * @param tramite
	 *            Tramite
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param hechoDenunciado
	 *            HechoDenunciado
	 */
	public TramiteHecho(String ehcodigo, Date ehfecha, String ehhora,
			String ehcodpor, String ehcodpde, String ehtexto, String ehcozs,
			BigDecimal ehcivihe, Date ehacuse, String ehenviomail,
			String ehdiremail, String codOrgTraslado,
			String ehrespuestatraspaso, Tramite tramite,
			CensoMonitor censoMonitor, HechoDenunciado hechoDenunciado) {
		this.ehcodigo = ehcodigo;
		this.tramite = tramite;
		this.censoMonitor = censoMonitor;
		this.hechoDenunciado = hechoDenunciado;
		this.ehfecha = ehfecha;
		this.ehhora = ehhora;
		this.ehcodpor = ehcodpor;
		this.ehcodpde = ehcodpde;
		this.ehtexto = ehtexto;
		this.ehcozs = ehcozs;
		this.ehcivihe = ehcivihe;
		this.ehacuse = ehacuse;
		this.ehenviomail = ehenviomail;
		this.ehdiremail = ehdiremail;
		this.codOrgTraslado = codOrgTraslado;
		this.ehrespuestatraspaso = ehrespuestatraspaso;
	}

	/**
	 * Method 'TramiteHecho'.
	 * 
	 * @param ehcodigo
	 *            String
	 * @param ehfecha
	 *            Date
	 * @param ehhora
	 *            String
	 * @param ehcodpor
	 *            String
	 * @param ehcodpde
	 *            String
	 * @param ehtexto
	 *            String
	 * @param ehcozs
	 *            String
	 * @param ehcivihe
	 *            BigDecimal
	 * @param ehacuse
	 *            Date
	 * @param ehenviomail
	 *            String
	 * @param ehdiremail
	 *            String
	 * @param tramite
	 *            Tramite
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param hechoDenunciado
	 *            HechoDenunciado
	 * @param documentoHechosForQ5tramite
	 *            List<DocumentoHecho>
	 * @param documentoHechosForQ5trmail
	 *            List<DocumentoHecho>
	 */
	public TramiteHecho(String ehcodigo, Date ehfecha, String ehhora,
			String ehcodpor, String ehcodpde, String ehtexto, String ehcozs,
			BigDecimal ehcivihe, Date ehacuse, String ehenviomail,
			String ehdiremail, Tramite tramite, CensoMonitor censoMonitor,
			HechoDenunciado hechoDenunciado,
			List<DocumentoHecho> documentoHechosForQ5tramite,
			List<DocumentoHecho> documentoHechosForQ5trmail) {

		this.ehcodigo = ehcodigo;
		this.tramite = tramite;
		this.censoMonitor = censoMonitor;
		this.hechoDenunciado = hechoDenunciado;
		this.ehfecha = ehfecha;
		this.ehhora = ehhora;
		this.ehcodpor = ehcodpor;
		this.ehcodpde = ehcodpde;
		this.ehtexto = ehtexto;
		this.ehcozs = ehcozs;
		this.ehcivihe = ehcivihe;
		this.ehacuse = ehacuse;
		this.ehenviomail = ehenviomail;
		this.ehdiremail = ehdiremail;
		this.documentoHechosForQ5tramite = documentoHechosForQ5tramite;
		this.documentoHechosForQ5trmail = documentoHechosForQ5trmail;
	}

	/**
	 * @param ehcodigo
	 * @param ehsiguientestramites
	 * @param ehtextoacuerdo
	 * @param ehinstrucinspecc
	 * @param ehmotivorechazo
	 * @param ehmotivorecurso
	 * @param ehresumenalegacion
	 * @param ehresumenmediacion
	 * @param ehtextocomunicacion
	 * @param ehintervinientes
	 * @param ehjustificacioninfraccion
	 * 
	 */
	public TramiteHecho(String ehcodigo, Clob ehsiguientestramites,
			Clob ehtextoacuerdo, Clob ehinstrucinspecc, Clob ehmotivorechazo,
			Clob ehmotivorecurso, Clob ehresumenalegacion,
			Clob ehresumenmediacion, Clob ehtextocomunicacion,
			Clob ehintervinientes, Clob ehjustificacioninfraccion) {
		super();
		this.ehcodigo = ehcodigo;
		this.ehsiguientestramites = ehsiguientestramites;
		this.ehtextoacuerdo = ehtextoacuerdo;
		this.ehinstrucinspecc = ehinstrucinspecc;
		this.ehmotivorechazo = ehmotivorechazo;
		this.ehmotivorecurso = ehmotivorecurso;
		this.ehresumenalegacion = ehresumenalegacion;
		this.ehresumenmediacion = ehresumenmediacion;
		this.ehtextocomunicacion = ehtextocomunicacion;
		this.ehintervinientes = ehintervinientes;
		this.ehjustificacioninfraccion = ehjustificacioninfraccion;
	}

	/**
	 * Method 'getEhcodigo'.
	 * 
	 * @return String
	 */

	public String getEhcodigo() {
		return this.ehcodigo;
	}

	/**
	 * Method 'setEhcodigo'.
	 * 
	 * @param ehcodigo
	 *            String
	 * @return
	 */

	public void setEhcodigo(String ehcodigo) {
		this.ehcodigo = ehcodigo;
	}

	/**
	 * Method 'getTramite'.
	 * 
	 * @return Tramite
	 */
	@JsonIgnore
	public Tramite getTramite() {
		return this.tramite;
	}

	/**
	 * Method 'setTramite'.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return
	 */

	public void setTramite(Tramite tramite) {
		this.tramite = tramite;
	}

	/**
	 * Method 'getCensoMonitor'.
	 * 
	 * @return CensoMonitor
	 */
	@JsonIgnore
	public CensoMonitor getCensoMonitor() {
		return this.censoMonitor;
	}

	/**
	 * Method 'setCensoMonitor'.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return
	 */

	public void setCensoMonitor(CensoMonitor censoMonitor) {
		this.censoMonitor = censoMonitor;
	}

	/**
	 * @return <ul>
	 *         <li>A: Aceptado</li>
	 *         <li>R: Rechazado</li>
	 *         </ul>
	 */
	public String getEhrespuestatraspaso() {
		return ehrespuestatraspaso;
	}

	/**
	 * @param ehrespuestatraspaso
	 *            <ul>
	 *            <li>A: Aceptado</li>
	 *            <li>R: Rechazado</li>
	 *            </ul>
	 */
	public void setEhrespuestatraspaso(String ehrespuestatraspaso) {
		this.ehrespuestatraspaso = ehrespuestatraspaso;
	}

	/**
	 * Method 'getHechoDenunciado'.
	 * 
	 * @return HechoDenunciado
	 */
	@JsonIgnore
	public HechoDenunciado getHechoDenunciado() {
		return this.hechoDenunciado;
	}

	/**
	 * Method 'setHechoDenunciado'.
	 * 
	 * @param hechoDenunciado
	 *            HechoDenunciado
	 * @return
	 */

	public void setHechoDenunciado(HechoDenunciado hechoDenunciado) {
		this.hechoDenunciado = hechoDenunciado;
	}

	/**
	 * Method 'getEhfecha'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getEhfecha() {
		return this.ehfecha;
	}

	/**
	 * Method 'setEhfecha'.
	 * 
	 * @param ehfecha
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setEhfecha(Date ehfecha) {
		this.ehfecha = ehfecha;
	}

	/**
	 * Method 'getEhhora'.
	 * 
	 * @return String
	 */

	public String getEhhora() {
		return this.ehhora;
	}

	/**
	 * Method 'setEhhora'.
	 * 
	 * @param ehhora
	 *            String
	 * @return
	 */

	public void setEhhora(String ehhora) {
		this.ehhora = ehhora;
	}

	/**
	 * Method 'getEhcodpor'.
	 * 
	 * @return String
	 */

	public String getEhcodpor() {
		return this.ehcodpor;
	}

	/**
	 * Method 'setEhcodpor'.
	 * 
	 * @param ehcodpor
	 *            String
	 * @return
	 */

	public void setEhcodpor(String ehcodpor) {
		this.ehcodpor = ehcodpor;
	}

	/**
	 * Method 'getEhcodpde'.
	 * 
	 * @return String
	 */

	public String getEhcodpde() {
		return this.ehcodpde;
	}

	/**
	 * Method 'setEhcodpde'.
	 * 
	 * @param ehcodpde
	 *            String
	 * @return
	 */

	public void setEhcodpde(String ehcodpde) {
		this.ehcodpde = ehcodpde;
	}

	/**
	 * Method 'getEhtexto'.
	 * 
	 * @return String
	 */

	public String getEhtexto() {
		return this.ehtexto;
	}

	/**
	 * Method 'setEhtexto'.
	 * 
	 * @param ehtexto
	 *            String
	 * @return
	 */

	public void setEhtexto(String ehtexto) {
		this.ehtexto = ehtexto;
	}

	/**
	 * Method 'getEhcozs'.
	 * 
	 * @return String
	 */

	public String getEhcozs() {
		return this.ehcozs;
	}

	/**
	 * Method 'setEhcozs'.
	 * 
	 * @param ehcozs
	 *            String
	 * @return
	 */

	public void setEhcozs(String ehcozs) {
		this.ehcozs = ehcozs;
	}

	/**
	 * Method 'getEhcivihe'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getEhcivihe() {
		return this.ehcivihe;
	}

	/**
	 * Method 'setEhcivihe'.
	 * 
	 * @param ehcivihe
	 *            BigDecimal
	 * @return
	 */

	public void setEhcivihe(BigDecimal ehcivihe) {
		this.ehcivihe = ehcivihe;
	}

	/**
	 * Method 'getEhacuse'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getEhacuse() {
		return this.ehacuse;
	}

	/**
	 * Method 'setEhacuse'.
	 * 
	 * @param ehacuse
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setEhacuse(Date ehacuse) {
		this.ehacuse = ehacuse;
	}

	/**
	 * Method 'getEhenviomail'.
	 * 
	 * @return String
	 */

	public String getEhenviomail() {
		return this.ehenviomail;
	}

	/**
	 * Method 'setEhenviomail'.
	 * 
	 * @param ehenviomail
	 *            String
	 * @return
	 */

	public void setEhenviomail(String ehenviomail) {
		this.ehenviomail = ehenviomail;
	}

	/**
	 * Method 'getEhdiremail'.
	 * 
	 * @return String
	 */

	public String getEhdiremail() {
		return this.ehdiremail;
	}

	/**
	 * Method 'setEhdiremail'.
	 * 
	 * @param ehdiremail
	 *            String
	 * @return
	 */

	public void setEhdiremail(String ehdiremail) {
		this.ehdiremail = ehdiremail;
	}

	/**
	 * Method 'getDocumentoHechosForQ5tramite'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<DocumentoHecho> getDocumentoHechosForQ5tramite() {
		return this.documentoHechosForQ5tramite;
	}

	/**
	 * Method 'setDocumentoHechosForQ5tramite'.
	 * 
	 * @param documentoHechosForQ5tramite
	 *            List
	 * @return
	 */
	public void setDocumentoHechosForQ5tramite(
			List<DocumentoHecho> documentoHechosForQ5tramite) {
		this.documentoHechosForQ5tramite = documentoHechosForQ5tramite;
	}

	/**
	 * Method 'getDocumentoHechosForQ5trmail'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<DocumentoHecho> getDocumentoHechosForQ5trmail() {
		return this.documentoHechosForQ5trmail;
	}

	/**
	 * Method 'setDocumentoHechosForQ5trmail'.
	 * 
	 * @param documentoHechosForQ5trmail
	 *            List
	 * @return
	 */
	public void setDocumentoHechosForQ5trmail(
			List<DocumentoHecho> documentoHechosForQ5trmail) {
		this.documentoHechosForQ5trmail = documentoHechosForQ5trmail;
	}

	/**
	 * @return the codOrgTraslado
	 */
	public String getCodOrgTraslado() {
		return codOrgTraslado;
	}

	/**
	 * @param codOrgTraslado
	 *            the codOrgTraslado to set
	 */
	public void setCodOrgTraslado(String codOrgTraslado) {
		this.codOrgTraslado = codOrgTraslado;
	}

	/**
	 * @return the ehsiguientestramites
	 */
	public Clob getEhsiguientestramites() {
		return ehsiguientestramites;
	}

	/**
	 * @param ehsiguientestramites
	 *            the ehsiguientestramites to set
	 */
	public void setEhsiguientestramites(Clob ehsiguientestramites) {
		this.ehsiguientestramites = ehsiguientestramites;
	}

	/**
	 * @return the ehtextoacuerdo
	 */
	public Clob getEhtextoacuerdo() {
		return ehtextoacuerdo;
	}

	/**
	 * @param ehtextoacuerdo
	 *            the ehtextoacuerdo to set
	 */
	public void setEhtextoacuerdo(Clob ehtextoacuerdo) {
		this.ehtextoacuerdo = ehtextoacuerdo;
	}

	/**
	 * @return the ehinstrucinspecc
	 */
	public Clob getEhinstrucinspecc() {
		return ehinstrucinspecc;
	}

	/**
	 * @param ehinstrucinspecc
	 *            the ehinstrucinspecc to set
	 */
	public void setEhinstrucinspecc(Clob ehinstrucinspecc) {
		this.ehinstrucinspecc = ehinstrucinspecc;
	}

	/**
	 * @return the ehmotivorechazo
	 */
	public Clob getEhmotivorechazo() {
		return ehmotivorechazo;
	}

	/**
	 * @param ehmotivorechazo
	 *            the ehmotivorechazo to set
	 */
	public void setEhmotivorechazo(Clob ehmotivorechazo) {
		this.ehmotivorechazo = ehmotivorechazo;
	}

	/**
	 * @return the ehmotivorecurso
	 */
	public Clob getEhmotivorecurso() {
		return ehmotivorecurso;
	}

	/**
	 * @param ehmotivorecurso
	 *            the ehmotivorecurso to set
	 */
	public void setEhmotivorecurso(Clob ehmotivorecurso) {
		this.ehmotivorecurso = ehmotivorecurso;
	}

	/**
	 * @return the ehresumenalegacion
	 */
	public Clob getEhresumenalegacion() {
		return ehresumenalegacion;
	}

	/**
	 * @param ehresumenalegacion
	 *            the ehresumenalegacion to set
	 */
	public void setEhresumenalegacion(Clob ehresumenalegacion) {
		this.ehresumenalegacion = ehresumenalegacion;
	}

	/**
	 * @return the ehresumenmediacion
	 */
	public Clob getEhresumenmediacion() {
		return ehresumenmediacion;
	}

	/**
	 * @param ehresumenmediacion
	 *            the ehresumenmediacion to set
	 */
	public void setEhresumenmediacion(Clob ehresumenmediacion) {
		this.ehresumenmediacion = ehresumenmediacion;
	}

	/**
	 * @return the ehtextocomunicacion
	 */
	public Clob getEhtextocomunicacion() {
		return ehtextocomunicacion;
	}

	/**
	 * @param ehtextocomunicacion
	 *            the ehtextocomunicacion to set
	 */
	public void setEhtextocomunicacion(Clob ehtextocomunicacion) {
		this.ehtextocomunicacion = ehtextocomunicacion;
	}

	/**
	 * @return the ehintervinientes
	 */
	public Clob getEhintervinientes() {
		return ehintervinientes;
	}

	/**
	 * @param ehintervinientes
	 *            the ehintervinientes to set
	 */
	public void setEhintervinientes(Clob ehintervinientes) {
		this.ehintervinientes = ehintervinientes;
	}

	/**
	 * @return the ehjustificacioninfraccion
	 */
	public Clob getEhjustificacioninfraccion() {
		return ehjustificacioninfraccion;
	}

	/**
	 * @param ehjustificacioninfraccion
	 *            the ehjustificacioninfraccion to set
	 */
	public void setEhjustificacioninfraccion(Clob ehjustificacioninfraccion) {
		this.ehjustificacioninfraccion = ehjustificacioninfraccion;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ ehcodigo: ").append(this.ehcodigo).append(" ]");
		result.append(", [ ehfecha: ").append(this.ehfecha).append(" ]");
		result.append(", [ ehhora: ").append(this.ehhora).append(" ]");
		result.append(", [ ehcodpor: ").append(this.ehcodpor).append(" ]");
		result.append(", [ ehcodpde: ").append(this.ehcodpde).append(" ]");
		result.append(", [ ehtexto: ").append(this.ehtexto).append(" ]");
		result.append(", [ ehcozs: ").append(this.ehcozs).append(" ]");
		result.append(", [ ehcivihe: ").append(this.ehcivihe).append(" ]");
		result.append(", [ ehacuse: ").append(this.ehacuse).append(" ]");
		result.append(", [ ehenviomail: ").append(this.ehenviomail)
				.append(" ]");
		result.append(", [ ehdiremail: ").append(this.ehdiremail).append(" ]");
		result.append(", [ ehrespuestatraspaso: ")
				.append(this.ehrespuestatraspaso).append(" ]");
		result.append("}");
		return result.toString();
	}

}
