package com.ejie.y41a.model;

import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;
import javax.validation.constraints.NotNull;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * * Tramite generated by UDA, 05-mar-2012 9:11:42.
 * 
 *  
 */

public class Tramite implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String trcodigo;
	@NotEmpty(message = "required.tramite")
	@NotNull()
	@Length(max = 50, message = "lenght.tramite")
	private String trnombre;
	@NotEmpty(message = "required.tramitee")
	@NotNull()
	@Length(max = 50, message = "lenght.tramite")
	private String trnombree;
	private Date trbaja;
	private List<PlantillaTramite> plantillaTramites = new ArrayList<PlantillaTramite>();

	/**
	 * Method 'Tramite'.
	 * 
	 */
	public Tramite() {
	}

	/**
	 * Method 'Tramite'.
	 * 
	 * @param trcodigo
	 *            String
	 * @param trnombre
	 *            String
	 * @param trnombree
	 *            String
	 * @param trbaja
	 *            Date
	 */
	public Tramite(String trcodigo, String trnombre, String trnombree,
			Date trbaja) {
		this.trcodigo = trcodigo;
		this.trnombre = trnombre;
		this.trnombree = trnombree;
		this.trbaja = trbaja;
	}

	/**
	 * Method 'Tramite'.
	 * 
	 * @param trcodigo
	 *            String
	 * @param trnombre
	 *            String
	 * @param trnombree
	 *            String
	 * @param trbaja
	 *            Date
	 * @param plantillaTramites
	 *            List<PlantillaTramite>
	 */
	public Tramite(String trcodigo, String trnombre, String trnombree,
			Date trbaja, List<PlantillaTramite> plantillaTramites) {

		this.trcodigo = trcodigo;
		this.trnombre = trnombre;
		this.trnombree = trnombree;
		this.trbaja = trbaja;
		this.plantillaTramites = plantillaTramites;
	}

	/**
	 * Method 'getTrcodigo'.
	 * 
	 * @return String
	 */

	public String getTrcodigo() {
		return this.trcodigo;
	}

	/**
	 * Method 'setTrcodigo'.
	 * 
	 * @param trcodigo
	 *            String
	 * @return
	 */

	public void setTrcodigo(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	/**
	 * Method 'getTrnombre'.
	 * 
	 * @return String
	 */

	public String getTrnombre() {
		return this.trnombre;
	}

	/**
	 * Method 'setTrnombre'.
	 * 
	 * @param trnombre
	 *            String
	 * @return
	 */

	public void setTrnombre(String trnombre) {
		this.trnombre = trnombre;
	}

	/**
	 * Method 'getTrnombree'.
	 * 
	 * @return String
	 */

	public String getTrnombree() {
		return this.trnombree;
	}

	/**
	 * Method 'setTrnombree'.
	 * 
	 * @param trnombree
	 *            String
	 * @return
	 */

	public void setTrnombree(String trnombree) {
		this.trnombree = trnombree;
	}

	/**
	 * Method 'getTrbaja'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrbaja() {
		return this.trbaja;
	}

	/**
	 * Method 'setTrbaja'.
	 * 
	 * @param trbaja
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrbaja(Date trbaja) {
		this.trbaja = trbaja;
	}

	/**
	 * Method 'getPlantillaTramites'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<PlantillaTramite> getPlantillaTramites() {
		return this.plantillaTramites;
	}

	/**
	 * Method 'setPlantillaTramites'.
	 * 
	 * @param plantillaTramites
	 *            List
	 * @return
	 */
	public void setPlantillaTramites(List<PlantillaTramite> plantillaTramites) {
		this.plantillaTramites = plantillaTramites;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ trcodigo: ").append(this.trcodigo).append(" ]");
		result.append(", [ trnombre: ").append(this.trnombre).append(" ]");
		result.append(", [ trnombree: ").append(this.trnombree).append(" ]");
		result.append(", [ trbaja: ").append(this.trbaja).append(" ]");
		result.append("}");
		return result.toString();
	}

}
