package com.ejie.y41a.model;

import java.math.BigDecimal;
import java.util.Date;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.format.annotation.NumberFormat;
import org.springframework.format.annotation.NumberFormat.Style;

import com.ejie.y41a.control.Y41aJsonDateDeserializer;
import com.ejie.y41a.control.Y41aJsonDateSerializer;

/**
 * * SolicitudBusqueda generated by UDA, 22-feb-2012 17:30:25.
 * 
 *  
 */

public class SolicitudDetalle implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	// Denuncia
	private String decodigo;
	@Length(max = 6, message = "error01.length.decoor")
	private String decoor;
	@Digits(integer = 4, fraction = 0, message = "error02.length.denran")
	@NumberFormat(style = NumberFormat.Style.NUMBER)
	private Integer denran;
	@Digits(integer = 11, fraction = 0, message = "error04.length.denror")
	@NumberFormat(style = NumberFormat.Style.NUMBER)
	private Long denror;
	@NotNull(message = "error06.required.defede")
	private Date defede;
	@NotNull(message = "error07.required.defere")
	private Date defere;

	private String dehojareclamacion;

	// Forma Presentacion
	@NotEmpty(message = "error08.required.tfpcodigo")
	@NotNull()
	@Length(max = 1, message = "error08.lenght.tfpcodigo")
	private String tfpcodigo;
	@Length(max = 30, message = "error09.lenght.tfpnombre")
	private String tfpnombre;
	@Length(max = 30, message = "error09.lenght.tfpnombree")
	private String tfpnombree;

	// Codigo expediente origen
	private String hdcodexpedienteorigen;

	// Consumidor

	@NotEmpty(message = "error10.required.dtcodigo")
	@NotNull()
	@Length(max = 20, message = "error10.lenght.dtcodigo")
	private String dtcodigo;
	private String dtnombre;
	private String dtapellido1;
	private String dtapellido2;
	private String dtnif;
	private String dttecoem;
	private String dtnrtel;
	private String dtnombreProvincia;
	private String dtnombreMunicipio;
	private String dtnombreLocalidad;
	private String dtextranjero;
	private String dtnoraPaisNombre;
	private String dtdireccion_nocapv;

	// Establecimiento
	@NotEmpty(message = "error11.required.escodigo")
	@NotNull()
	@Length(max = 20, message = "error11.lenght.escodigo")
	private String escodigo;
	private String esnombre;
	private String esnif;
	private String esnoco;
	private String escoem;
	private String esinadar;
	private String esnombreProvincia;
	private String esnombreMunicipio;
	private String esnombreLocalidad;
	private String esextranjero;
	private String esnoraPaisNombre;
	private String esdireccion_nocapv;

	// Sector
	private String secodigo;
	private String senombre;
	private String senombree;

	// Hecho denuncia
	private String hdcodigo;
	@NotNull(message = "error12.required.hdfehd")
	private Date hdfehd;
	@NotEmpty(message = "error13.required.hdte")
	// @Length(max = 4000, message = "error13.lenght.hdte")
	private String hdte;
	@Digits(integer = 11, fraction = 0, message = "error20.length.hdnror")
	@NumberFormat(style = Style.NUMBER)
	private Long hdnror;
	private String hdinsoma;
	@Digits(integer = 8, fraction = 2, message = "error21.lenght.hdcaptso")
	// @NumberFormat(style = NumberFormat.Style.NUMBER)
	private BigDecimal hdcaptso;
	// @Length(max = 255, message = "error16.lenght.hdteso")
	private String hdteso;

	@NotEmpty(message = "error05.required.hdcosc")
	@NotNull()
	@Length(max = 1, message = "error05.lenght.hdcosc")
	private String hdcosc;

	// Monitor
	@NotEmpty(message = "error22.required.mocodigo")
	@NotNull()
	@Length(max = 3, message = "error22.lenght.mocodigo")
	private String mocodigo;
	private String monombre;

	// Producto
	@Length(max = 20, message = "error14.lenght.pscodigo")
	@NotEmpty(message = "error14.required.pscodigo")
	@NotNull()
	private String pscodigo;
	@Length(max = 110, message = "error15.lenght.psnombre")
	private String psnombre;
	@Length(max = 110, message = "error15.lenght.psnombree")
	private String psnombree;

	// Motivo
	@Length(max = 20, message = "error16.lenght.tircodigo")
	@NotEmpty(message = "error16.required.tircodigo")
	@NotNull()
	private String tircodigo;
	@Length(max = 100, message = "error17.lenght.tirnombre")
	private String tirnombre;

	// Formas Venta
	@Length(max = 40, message = "error23.lenght.fvcodigo")
	@NotEmpty(message = "error23.required.fvcodigo")
	@NotNull()
	private String fvcodigo;
	@Length(max = 255, message = "error24.lenght.fvnombre")
	private String fvnombre;
	@Length(max = 255, message = "error24.lenght.fvrnombree")
	private String fvnombree;

	// Tipo reclamacion
	// @Length(max = 2, message = "error18.lenght.tsrcodigo")
	// @NotEmpty(message = "error18.required.tsrcodigo")
	// @NotNull()
	// private String tsrcodigo;
	// @Length(max = 30, message = "error19.lenght.tsrnombre")
	// private String tsrnombre;
	// @Length(max = 30, message = "error19.lenght.tsrnombree")
	// private String tsrnombree;

	@Length(max = 2, message = "error25.lenght.tsrcodigo")
	@NotEmpty(message = "error25.required.tsrcodigo")
	@NotNull()
	private String tsrcodigo;
	@Length(max = 30, message = "error26.lenght.tsrnombre")
	private String tsrnombre;
	@Length(max = 30, message = "error26.lenght.tsrnombree")
	private String tsrnombree;

	private String estado;
	private String numExpediente;
	private String codOrgConectado;
	private String hccoor;
	private Date hcfede;
	private String ihcoordt;
	private Date ihfereen;
	private String orgiskontsumonet;

	private String hdidioma;

	public SolicitudDetalle() {
	}

	/**
	 * @param hdcodigo
	 * @param hdte
	 */
	public SolicitudDetalle(String hdcodigo, String hdte) {
		super();
		this.hdcodigo = hdcodigo;
		this.hdte = hdte;
	}

	/**
	 * @param decodigo
	 * @param decoor
	 * @param denran
	 * @param denror
	 * @param defede
	 * @param defere
	 * @param tfpcodigo
	 * @param tfpnombre
	 * @param tfpnombree
	 * @param hdcodexpedienteorigen
	 * @param dtcodigo
	 * @param dtnombre
	 * @param dtapellido1
	 * @param dtapellido2
	 * @param dtnif
	 * @param dttecoem
	 * @param dtnrtel
	 * @param dtnombreProvincia
	 * @param dtnombreMunicipio
	 * @param dtnombreLocalidad
	 * @param dtextranjero
	 * @param dtnoraPaisNombre
	 * @param dtdireccion_nocapv
	 * @param escodigo
	 * @param esnombre
	 * @param esnif
	 * @param esnoco
	 * @param escoem
	 * @param esinadar
	 * @param esnombreProvincia
	 * @param esnombreMunicipio
	 * @param esnombreLocalidad
	 * @param esextranjero
	 * @param esnoraPaisNombre
	 * @param esdireccion_nocapv
	 * @param secodigo
	 * @param senombre
	 * @param senombree
	 * @param hdcodigo
	 * @param hdfehd
	 * @param hdte
	 * @param hdnror
	 * @param hdinsoma
	 * @param hdcaptso
	 * @param hdteso
	 * @param hdcosc
	 * @param mocodigo
	 * @param monombre
	 * @param pscodigo
	 * @param psnombre
	 * @param psnombree
	 * @param tircodigo
	 * @param tirnombre
	 * @param fvcodigo
	 * @param fvnombre
	 * @param fvnombree
	 * @param tsrcodigo
	 * @param tsrnombre
	 * @param tsrnombree
	 * @param estado
	 * @param numExpediente
	 * @param codOrgConectado
	 * @param hccoor
	 * @param hcfede
	 * @param ihcoordt
	 * @param ihfereen
	 * @param orgiskontsumonet
	 * @param hdidioma
	 * @param dehojareclamacion
	 */
	public SolicitudDetalle(String decodigo, String decoor, Integer denran,
			Long denror, Date defede, Date defere, String tfpcodigo,
			String tfpnombre, String tfpnombree, String hdcodexpedienteorigen,
			String dtcodigo, String dtnombre, String dtapellido1,
			String dtapellido2, String dtnif, String dttecoem, String dtnrtel,
			String dtnombreProvincia, String dtnombreMunicipio,
			String dtnombreLocalidad, String dtextranjero,
			String dtnoraPaisNombre, String dtdireccion_nocapv,
			String escodigo, String esnombre, String esnif, String esnoco,
			String escoem, String esinadar, String esnombreProvincia,
			String esnombreMunicipio, String esnombreLocalidad,
			String esextranjero, String esnoraPaisNombre,
			String esdireccion_nocapv, String secodigo, String senombre,
			String senombree, String hdcodigo, Date hdfehd, String hdte,
			Long hdnror, String hdinsoma, BigDecimal hdcaptso, String hdteso,
			String hdcosc, String mocodigo, String monombre, String pscodigo,
			String psnombre, String psnombree, String tircodigo,
			String tirnombre, String fvcodigo, String fvnombre,
			String fvnombree, String tsrcodigo, String tsrnombre,
			String tsrnombree, String estado, String numExpediente,
			String codOrgConectado, String hccoor, Date hcfede,
			String ihcoordt, Date ihfereen, String orgiskontsumonet,
			String hdidioma, String dehojareclamacion) {
		this.decodigo = decodigo;
		this.decoor = decoor;
		this.denran = denran;
		this.denror = denror;
		this.defede = defede;
		this.defere = defere;
		this.tfpcodigo = tfpcodigo;
		this.tfpnombre = tfpnombre;
		this.tfpnombree = tfpnombree;
		this.hdcodexpedienteorigen = hdcodexpedienteorigen;
		this.dtcodigo = dtcodigo;
		this.dtnombre = dtnombre;
		this.dtapellido1 = dtapellido1;
		this.dtapellido2 = dtapellido2;
		this.dtnif = dtnif;
		this.dttecoem = dttecoem;
		this.dtnrtel = dtnrtel;
		this.dtnombreProvincia = dtnombreProvincia;
		this.dtnombreMunicipio = dtnombreMunicipio;
		this.dtnombreLocalidad = dtnombreLocalidad;
		this.dtextranjero = dtextranjero;
		this.dtnoraPaisNombre = dtnoraPaisNombre;
		this.dtdireccion_nocapv = dtdireccion_nocapv;
		this.escodigo = escodigo;
		this.esnombre = esnombre;
		this.esnif = esnif;
		this.esnoco = esnoco;
		this.escoem = escoem;
		this.esinadar = esinadar;
		this.esnombreProvincia = esnombreProvincia;
		this.esnombreMunicipio = esnombreMunicipio;
		this.esnombreLocalidad = esnombreLocalidad;
		this.esextranjero = esextranjero;
		this.esnoraPaisNombre = esnoraPaisNombre;
		this.esdireccion_nocapv = esdireccion_nocapv;
		this.secodigo = secodigo;
		this.senombre = senombre;
		this.senombree = senombree;
		this.hdcodigo = hdcodigo;
		this.hdfehd = hdfehd;
		this.hdte = hdte;
		this.hdnror = hdnror;
		this.hdinsoma = hdinsoma;
		this.hdcaptso = hdcaptso;
		this.hdteso = hdteso;
		this.hdcosc = hdcosc;
		this.mocodigo = mocodigo;
		this.monombre = monombre;
		this.pscodigo = pscodigo;
		this.psnombre = psnombre;
		this.psnombree = psnombree;
		this.tircodigo = tircodigo;
		this.tirnombre = tirnombre;
		this.fvcodigo = fvcodigo;
		this.fvnombre = fvnombre;
		this.fvnombree = fvnombree;
		this.tsrcodigo = tsrcodigo;
		this.tsrnombre = tsrnombre;
		this.tsrnombree = tsrnombree;
		this.estado = estado;
		this.numExpediente = numExpediente;
		this.codOrgConectado = codOrgConectado;
		this.hccoor = hccoor;
		this.hcfede = hcfede;
		this.ihcoordt = ihcoordt;
		this.ihfereen = ihfereen;
		this.orgiskontsumonet = orgiskontsumonet;
		this.hdidioma = hdidioma;
		this.dehojareclamacion = dehojareclamacion;
	}

	/**
	 * @return the decodigo
	 */
	public String getDecodigo() {
		return decodigo;
	}

	/**
	 * @param decodigo
	 *            the decodigo to set
	 */
	public void setDecodigo(String decodigo) {
		this.decodigo = decodigo;
	}

	/**
	 * @return the decoor
	 */
	public String getDecoor() {
		return decoor;
	}

	/**
	 * @param decoor
	 *            the decoor to set
	 */
	public void setDecoor(String decoor) {
		this.decoor = decoor;
	}

	/**
	 * @return the defede
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getDefede() {
		return defede;
	}

	/**
	 * @param defede
	 *            the defede to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setDefede(Date defede) {
		this.defede = defede;
	}

	/**
	 * @return the defere
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getDefere() {
		return defere;
	}

	/**
	 * @param defere
	 *            the defere to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setDefere(Date defere) {
		this.defere = defere;
	}

	/**
	 * @return the tfpcodigo
	 */
	public String getTfpcodigo() {
		return tfpcodigo;
	}

	/**
	 * @param tfpcodigo
	 *            the tfpcodigo to set
	 */
	public void setTfpcodigo(String tfpcodigo) {
		this.tfpcodigo = tfpcodigo;
	}

	/**
	 * @return the tfpnombre
	 */
	public String getTfpnombre() {
		return tfpnombre;
	}

	/**
	 * @param tfpnombre
	 *            the tfpnombre to set
	 */
	public void setTfpnombre(String tfpnombre) {
		this.tfpnombre = tfpnombre;
	}

	/**
	 * @return the tfpnombree
	 */
	public String getTfpnombree() {
		return tfpnombree;
	}

	/**
	 * @param tfpnombree
	 *            the tfpnombree to set
	 */
	public void setTfpnombree(String tfpnombree) {
		this.tfpnombree = tfpnombree;
	}

	/**
	 * @return the dtcodigo
	 */
	public String getDtcodigo() {
		return dtcodigo;
	}

	/**
	 * @param dtcodigo
	 *            the dtcodigo to set
	 */
	public void setDtcodigo(String dtcodigo) {
		this.dtcodigo = dtcodigo;
	}

	/**
	 * @return the dtnombre
	 */
	public String getDtnombre() {
		return dtnombre;
	}

	/**
	 * @param dtnombre
	 *            the dtnombre to set
	 */
	public void setDtnombre(String dtnombre) {
		this.dtnombre = dtnombre;
	}

	/**
	 * @return the dtapellido1
	 */
	public String getDtapellido1() {
		return dtapellido1;
	}

	/**
	 * @param dtapellido1
	 *            the dtapellido1 to set
	 */
	public void setDtapellido1(String dtapellido1) {
		this.dtapellido1 = dtapellido1;
	}

	/**
	 * @return the dtapellido2
	 */
	public String getDtapellido2() {
		return dtapellido2;
	}

	/**
	 * @param dtapellido2
	 *            the dtapellido2 to set
	 */
	public void setDtapellido2(String dtapellido2) {
		this.dtapellido2 = dtapellido2;
	}

	/**
	 * @return the dtnif
	 */
	public String getDtnif() {
		return dtnif;
	}

	/**
	 * @param dtnif
	 *            the dtnif to set
	 */
	public void setDtnif(String dtnif) {
		this.dtnif = dtnif;
	}

	/**
	 * @return the dttecoem
	 */
	public String getDttecoem() {
		return dttecoem;
	}

	/**
	 * @param dttecoem
	 *            the dttecoem to set
	 */
	public void setDttecoem(String dttecoem) {
		this.dttecoem = dttecoem;
	}

	/**
	 * @return the dtnrtel
	 */
	public String getDtnrtel() {
		return dtnrtel;
	}

	/**
	 * @param dtnrtel
	 *            the dtnrtel to set
	 */
	public void setDtnrtel(String dtnrtel) {
		this.dtnrtel = dtnrtel;
	}

	/**
	 * @return the escodigo
	 */
	public String getEscodigo() {
		return escodigo;
	}

	/**
	 * @param escodigo
	 *            the escodigo to set
	 */
	public void setEscodigo(String escodigo) {
		this.escodigo = escodigo;
	}

	/**
	 * @return the esnombre
	 */
	public String getEsnombre() {
		return esnombre;
	}

	/**
	 * @param esnombre
	 *            the esnombre to set
	 */
	public void setEsnombre(String esnombre) {
		this.esnombre = esnombre;
	}

	/**
	 * @return the esnif
	 */
	public String getEsnif() {
		return esnif;
	}

	/**
	 * @param esnif
	 *            the esnif to set
	 */
	public void setEsnif(String esnif) {
		this.esnif = esnif;
	}

	/**
	 * @return the esnoco
	 */
	public String getEsnoco() {
		return esnoco;
	}

	/**
	 * @param esnoco
	 *            the esnoco to set
	 */
	public void setEsnoco(String esnoco) {
		this.esnoco = esnoco;
	}

	/**
	 * @return the esinadar
	 */
	public String getEsinadar() {
		return esinadar;
	}

	/**
	 * @param esinadar
	 *            the esinadar to set
	 */
	public void setEsinadar(String esinadar) {
		this.esinadar = esinadar;
	}

	/**
	 * @return the secodigo
	 */
	public String getSecodigo() {
		return secodigo;
	}

	/**
	 * @param secodigo
	 *            the secodigo to set
	 */
	public void setSecodigo(String secodigo) {
		this.secodigo = secodigo;
	}

	/**
	 * @return the senombre
	 */
	public String getSenombre() {
		return senombre;
	}

	/**
	 * @param senombre
	 *            the senombre to set
	 */
	public void setSenombre(String senombre) {
		this.senombre = senombre;
	}

	/**
	 * @return the senombree
	 */
	public String getSenombree() {
		return senombree;
	}

	/**
	 * @param senombree
	 *            the senombree to set
	 */
	public void setSenombree(String senombree) {
		this.senombree = senombree;
	}

	/**
	 * @return the hdcodigo
	 */
	public String getHdcodigo() {
		return hdcodigo;
	}

	/**
	 * @param hdcodigo
	 *            the hdcodigo to set
	 */
	public void setHdcodigo(String hdcodigo) {
		this.hdcodigo = hdcodigo;
	}

	/**
	 * @return the hdfehd
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getHdfehd() {
		return hdfehd;
	}

	/**
	 * @param hdfehd
	 *            the hdfehd to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setHdfehd(Date hdfehd) {
		this.hdfehd = hdfehd;
	}

	/**
	 * @return the hdte
	 */
	public String getHdte() {
		return hdte;
	}

	/**
	 * @param hdte
	 *            the hdte to set
	 */
	public void setHdte(String hdte) {
		this.hdte = hdte;
	}

	/**
	 * @return the hdinsoma
	 */
	public String getHdinsoma() {
		return hdinsoma;
	}

	/**
	 * @param hdinsoma
	 *            the hdinsoma to set
	 */
	public void setHdinsoma(String hdinsoma) {
		this.hdinsoma = hdinsoma;
	}

	/**
	 * @return the hdteso
	 */
	public String getHdteso() {
		return hdteso;
	}

	/**
	 * @param hdteso
	 *            the hdteso to set
	 */
	public void setHdteso(String hdteso) {
		this.hdteso = hdteso;
	}

	/**
	 * @return the hdcosc
	 */
	public String getHdcosc() {
		return hdcosc;
	}

	/**
	 * @param hdcosc
	 *            the hdcosc to set
	 */
	public void setHdcosc(String hdcosc) {
		this.hdcosc = hdcosc;
	}

	/**
	 * @return the mocodigo
	 */
	public String getMocodigo() {
		return mocodigo;
	}

	/**
	 * @param mocodigo
	 *            the mocodigo to set
	 */
	public void setMocodigo(String mocodigo) {
		this.mocodigo = mocodigo;
	}

	/**
	 * @return the monombre
	 */
	public String getMonombre() {
		return monombre;
	}

	/**
	 * @param monombre
	 *            the monombre to set
	 */
	public void setMonombre(String monombre) {
		this.monombre = monombre;
	}

	/**
	 * @return the pscodigo
	 */
	public String getPscodigo() {
		return pscodigo;
	}

	/**
	 * @param pscodigo
	 *            the pscodigo to set
	 */
	public void setPscodigo(String pscodigo) {
		this.pscodigo = pscodigo;
	}

	/**
	 * @return the psnombre
	 */
	public String getPsnombre() {
		return psnombre;
	}

	/**
	 * @param psnombre
	 *            the psnombre to set
	 */
	public void setPsnombre(String psnombre) {
		this.psnombre = psnombre;
	}

	/**
	 * @return the psnombree
	 */
	public String getPsnombree() {
		return psnombree;
	}

	/**
	 * @param psnombree
	 *            the psnombree to set
	 */
	public void setPsnombree(String psnombree) {
		this.psnombree = psnombree;
	}

	/**
	 * @return the tircodigo
	 */
	public String getTircodigo() {
		return tircodigo;
	}

	/**
	 * @param tircodigo
	 *            the tircodigo to set
	 */
	public void setTircodigo(String tircodigo) {
		this.tircodigo = tircodigo;
	}

	/**
	 * @return the tirnombre
	 */
	public String getTirnombre() {
		return tirnombre;
	}

	/**
	 * @param tirnombre
	 *            the tirnombre to set
	 */
	public void setTirnombre(String tirnombre) {
		this.tirnombre = tirnombre;
	}

	/**
	 * @return the tsrcodigo
	 */
	public String getTsrcodigo() {
		return tsrcodigo;
	}

	/**
	 * @param tsrcodigo
	 *            the tsrcodigo to set
	 */
	public void setTsrcodigo(String tsrcodigo) {
		this.tsrcodigo = tsrcodigo;
	}

	/**
	 * @return the tsrnombre
	 */
	public String getTsrnombre() {
		return tsrnombre;
	}

	/**
	 * @param tsrnombre
	 *            the tsrnombre to set
	 */
	public void setTsrnombre(String tsrnombre) {
		this.tsrnombre = tsrnombre;
	}

	/**
	 * @return the tsrnombree
	 */
	public String getTsrnombree() {
		return tsrnombree;
	}

	/**
	 * @param tsrnombree
	 *            the tsrnombree to set
	 */
	public void setTsrnombree(String tsrnombree) {
		this.tsrnombree = tsrnombree;
	}

	/**
	 * @return the estado
	 */
	public String getEstado() {
		return estado;
	}

	/**
	 * @param estado
	 *            the estado to set
	 */
	public void setEstado(String estado) {
		this.estado = estado;
	}

	/**
	 * @return the numExpediente
	 */
	public String getNumExpediente() {
		return numExpediente;
	}

	/**
	 * @param numExpediente
	 *            the numExpediente to set
	 */
	public void setNumExpediente(String numExpediente) {
		this.numExpediente = numExpediente;
	}

	/**
	 * @return the codOrgConectado
	 */
	public String getCodOrgConectado() {
		return codOrgConectado;
	}

	/**
	 * @param codOrgConectado
	 *            the codOrgConectado to set
	 */
	public void setCodOrgConectado(String codOrgConectado) {
		this.codOrgConectado = codOrgConectado;
	}

	/**
	 * @return the hccoor
	 */
	public String getHccoor() {
		return hccoor;
	}

	/**
	 * @param hccoor
	 *            the hccoor to set
	 */
	public void setHccoor(String hccoor) {
		this.hccoor = hccoor;
	}

	/**
	 * @return the ihcoordt
	 */
	public String getIhcoordt() {
		return ihcoordt;
	}

	/**
	 * @param ihcoordt
	 *            the ihcoordt to set
	 */
	public void setIhcoordt(String ihcoordt) {
		this.ihcoordt = ihcoordt;
	}

	/**
	 * @return the ihfereen
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getIhfereen() {
		return ihfereen;
	}

	/**
	 * @param ihfereen
	 *            the ihfereen to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setIhfereen(Date ihfereen) {
		this.ihfereen = ihfereen;
	}

	/**
	 * @return the orgiskontsumonet
	 */
	public String getOrgiskontsumonet() {
		return orgiskontsumonet;
	}

	/**
	 * @param orgiskontsumonet
	 *            the orgiskontsumonet to set
	 */
	public void setOrgiskontsumonet(String orgiskontsumonet) {
		this.orgiskontsumonet = orgiskontsumonet;
	}

	/**
	 * @return the hdidioma
	 */
	public String getHdidioma() {
		return hdidioma;
	}

	/**
	 * @param hdidioma
	 *            the hdidioma to set
	 */
	public void setHdidioma(String hdidioma) {
		this.hdidioma = hdidioma;
	}

	/**
	 * @return the dehojareclamacion
	 */
	public String getDehojareclamacion() {
		return dehojareclamacion;
	}

	/**
	 * @param dehojareclamacion
	 *            the dehojareclamacion to set
	 */
	public void setDehojareclamacion(String dehojareclamacion) {
		this.dehojareclamacion = dehojareclamacion;
	}

	/**
	 * @return the escoem
	 */
	public String getEscoem() {
		return escoem;
	}

	/**
	 * @param escoem
	 *            the escoem to set
	 */
	public void setEscoem(String escoem) {
		this.escoem = escoem;
	}

	/**
	 * @return the denran
	 */
	public Integer getDenran() {
		return denran;
	}

	/**
	 * @param denran
	 *            the denran to set
	 */
	public void setDenran(Integer denran) {
		this.denran = denran;
	}

	/**
	 * @return the denror
	 */
	public Long getDenror() {
		return denror;
	}

	/**
	 * @param denror
	 *            the denror to set
	 */
	public void setDenror(Long denror) {
		this.denror = denror;
	}

	/**
	 * @return the hdnror
	 */
	public Long getHdnror() {
		return hdnror;
	}

	/**
	 * @param hdnror
	 *            the hdnror to set
	 */
	public void setHdnror(Long hdnror) {
		this.hdnror = hdnror;
	}

	/**
	 * @return the hdcaptso
	 */
	public BigDecimal getHdcaptso() {
		return hdcaptso;
	}

	/**
	 * @param hdcaptso
	 *            the hdcaptso to set
	 */
	public void setHdcaptso(BigDecimal hdcaptso) {
		this.hdcaptso = hdcaptso;
	}

	/**
	 * @return the hcfede
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getHcfede() {
		return hcfede;
	}

	/**
	 * @param hcfede
	 *            the hcfede to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setHcfede(Date hcfede) {
		this.hcfede = hcfede;
	}

	/**
	 * @return the dtnombreMunicipio
	 */
	public String getDtnombreMunicipio() {
		return dtnombreMunicipio;
	}

	/**
	 * @param dtnombreMunicipio
	 *            the dtnombreMunicipio to set
	 */
	public void setDtnombreMunicipio(String dtnombreMunicipio) {
		this.dtnombreMunicipio = dtnombreMunicipio;
	}

	/**
	 * @return the esnombreMunicipio
	 */
	public String getEsnombreMunicipio() {
		return esnombreMunicipio;
	}

	/**
	 * @param esnombreMunicipio
	 *            the esnombreMunicipio to set
	 */
	public void setEsnombreMunicipio(String esnombreMunicipio) {
		this.esnombreMunicipio = esnombreMunicipio;
	}

	public String getDtnombreProvincia() {
		return dtnombreProvincia;
	}

	public void setDtnombreProvincia(String dtnombreProvincia) {
		this.dtnombreProvincia = dtnombreProvincia;
	}

	public String getDtnombreLocalidad() {
		return dtnombreLocalidad;
	}

	public void setDtnombreLocalidad(String dtnombreLocalidad) {
		this.dtnombreLocalidad = dtnombreLocalidad;
	}

	public String getDtextranjero() {
		return dtextranjero;
	}

	public void setDtextranjero(String dtextranjero) {
		this.dtextranjero = dtextranjero;
	}

	public String getDtnoraPaisNombre() {
		return dtnoraPaisNombre;
	}

	public void setDtnoraPaisNombre(String dtnoraPaisNombre) {
		this.dtnoraPaisNombre = dtnoraPaisNombre;
	}

	public String getDtdireccion_nocapv() {
		return dtdireccion_nocapv;
	}

	public void setDtdireccion_nocapv(String dtdireccion_nocapv) {
		this.dtdireccion_nocapv = dtdireccion_nocapv;
	}

	public String getEsnombreProvincia() {
		return esnombreProvincia;
	}

	public void setEsnombreProvincia(String esnombreProvincia) {
		this.esnombreProvincia = esnombreProvincia;
	}

	public String getEsnombreLocalidad() {
		return esnombreLocalidad;
	}

	public void setEsnombreLocalidad(String esnombreLocalidad) {
		this.esnombreLocalidad = esnombreLocalidad;
	}

	public String getEsextranjero() {
		return esextranjero;
	}

	public void setEsextranjero(String esextranjero) {
		this.esextranjero = esextranjero;
	}

	public String getEsnoraPaisNombre() {
		return esnoraPaisNombre;
	}

	public void setEsnoraPaisNombre(String esnoraPaisNombre) {
		this.esnoraPaisNombre = esnoraPaisNombre;
	}

	public String getEsdireccion_nocapv() {
		return esdireccion_nocapv;
	}

	public void setEsdireccion_nocapv(String esdireccion_nocapv) {
		this.esdireccion_nocapv = esdireccion_nocapv;
	}

	/**
	 * @return the hdcodexpedienteorigen
	 */
	public String getHdcodexpedienteorigen() {
		return hdcodexpedienteorigen;
	}

	/**
	 * @param hdcodexpedienteorigen
	 *            the hdcodexpedienteorigen to set
	 */
	public void setHdcodexpedienteorigen(String hdcodexpedienteorigen) {
		this.hdcodexpedienteorigen = hdcodexpedienteorigen;
	}

	/**
	 * @return the fvcodigo
	 */
	public String getFvcodigo() {
		return fvcodigo;
	}

	/**
	 * @param fvcodigo
	 *            the fvcodigo to set
	 */
	public void setFvcodigo(String fvcodigo) {
		this.fvcodigo = fvcodigo;
	}

	/**
	 * @return the fvnombre
	 */
	public String getFvnombre() {
		return fvnombre;
	}

	/**
	 * @param fvnombre
	 *            the fvnombre to set
	 */
	public void setFvnombre(String fvnombre) {
		this.fvnombre = fvnombre;
	}

	/**
	 * @return the fvnombree
	 */
	public String getFvnombree() {
		return fvnombree;
	}

	/**
	 * @param fvnombree
	 *            the fvnombree to set
	 */
	public void setFvnombree(String fvnombree) {
		this.fvnombree = fvnombree;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "SolicitudDetalle [decodigo=" + decodigo + ", decoor=" + decoor
				+ ", denran=" + denran + ", denror=" + denror + ", defede="
				+ defede + ", defere=" + defere + ", tfpcodigo=" + tfpcodigo
				+ ", tfpnombre=" + tfpnombre + ", tfpnombree=" + tfpnombree
				+ ", hdcodexpedienteorigen=" + hdcodexpedienteorigen
				+ ", dtcodigo=" + dtcodigo + ", dtnombre=" + dtnombre
				+ ", dtapellido1=" + dtapellido1 + ", dtapellido2="
				+ dtapellido2 + ", dtnif=" + dtnif + ", dttecoem=" + dttecoem
				+ ", dtnrtel=" + dtnrtel + ",dtnombreProvincia="
				+ dtnombreProvincia + ", dtnombreMunicipio="
				+ dtnombreMunicipio + ", dtnombreLocalidad="
				+ dtnombreLocalidad + ", dtextranjero=" + dtextranjero
				+ ", dtnoraPaisNombre=" + dtnoraPaisNombre
				+ ", dtdireccion_nocapv=" + dtdireccion_nocapv + ",escodigo="
				+ escodigo + ", esnombre=" + esnombre + ", esnif=" + esnif
				+ ", esnoco=" + esnoco + ", escoem=" + escoem + ", esinadar="
				+ esinadar + ", esnombreProvincia=" + esnombreProvincia
				+ ", esnombreMunicipio=" + esnombreMunicipio
				+ ", esnombreLocalidad=" + esnombreLocalidad
				+ ", esextranjero=" + esextranjero + ", esnoraPaisNombre="
				+ esnoraPaisNombre + ", esdireccion_nocapv="
				+ esdireccion_nocapv + ", secodigo=" + secodigo + ", senombre="
				+ senombre + ", senombree=" + senombree + ", hdcodigo="
				+ hdcodigo + ", hdfehd=" + hdfehd + ", hdte=" + hdte
				+ ", hdnror=" + hdnror + ", hdinsoma=" + hdinsoma
				+ ", hdcaptso=" + hdcaptso + ", hdteso=" + hdteso + ", hdcosc="
				+ hdcosc + ", mocodigo=" + mocodigo + ", monombre=" + monombre
				+ ", pscodigo=" + pscodigo + ", psnombre=" + psnombre
				+ ", psnombree=" + psnombree + ", tircodigo=" + tircodigo
				+ ", tirnombre=" + tirnombre + ", fvcodigo=" + fvcodigo
				+ ", fvnombre=" + fvnombre + ", fvnombree=" + fvnombree
				+ ", tsrcodigo=" + tsrcodigo + ", tsrnombre=" + tsrnombre
				+ ", tsrnombree=" + tsrnombree + ", estado=" + estado
				+ ", numExpediente=" + numExpediente + ", codOrgConectado="
				+ codOrgConectado + ", hccoor=" + hccoor + ", hcfede=" + hcfede
				+ ", ihcoordt=" + ihcoordt + ", ihfereen=" + ihfereen
				+ ", orgiskontsumonet=" + orgiskontsumonet + ", hdidioma="
				+ hdidioma + ", dehojareclamacion=" + dehojareclamacion + "]";

	}

}
