package com.ejie.y41a.model;

import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;
import javax.validation.constraints.NotNull;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * * Inspecciones generated by UDA, 22-mar-2012 16:48:03.
 * 
 *  
 */

public class Inspecciones implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String inscodcarta;
	@NotEmpty(message = "required.inspeccion")
	@NotNull()
	@Length(max = 50, message = "lenght.inspeccion")
	private String insnombre;
	@NotEmpty(message = "required.inspeccione")
	@NotNull()
	@Length(max = 50, message = "lenght.inspeccion")
	private String insnombree;
	private Date insbaja;
	private List<PlantillaIns> plantillaInses = new ArrayList<PlantillaIns>();

	/**
	 * Method 'Inspecciones'.
	 * 
	 */
	public Inspecciones() {
	}

	/**
	 * Method 'Inspecciones'.
	 * 
	 * @param inscodcarta
	 *            String
	 * @param insnombre
	 *            String
	 * @param insnombree
	 *            String
	 * @param insbaja
	 *            Date
	 */
	public Inspecciones(String inscodcarta, String insnombre,
			String insnombree, Date insbaja) {
		this.inscodcarta = inscodcarta;
		this.insnombre = insnombre;
		this.insnombree = insnombree;
		this.insbaja = insbaja;
	}

	/**
	 * Method 'Inspecciones'.
	 * 
	 * @param inscodcarta
	 *            String
	 * @param insnombre
	 *            String
	 * @param insnombree
	 *            String
	 * @param insbaja
	 *            Date
	 * @param plantillaInses
	 *            List<PlantillaIns>
	 */
	public Inspecciones(String inscodcarta, String insnombre,
			String insnombree, Date insbaja, List<PlantillaIns> plantillaInses) {

		this.inscodcarta = inscodcarta;
		this.insnombre = insnombre;
		this.insnombree = insnombree;
		this.insbaja = insbaja;
		this.plantillaInses = plantillaInses;
	}

	/**
	 * Method 'getInscodcarta'.
	 * 
	 * @return String
	 */

	public String getInscodcarta() {
		return this.inscodcarta;
	}

	/**
	 * Method 'setInscodcarta'.
	 * 
	 * @param inscodcarta
	 *            String
	 * @return
	 */

	public void setInscodcarta(String inscodcarta) {
		this.inscodcarta = inscodcarta;
	}

	/**
	 * Method 'getInsnombre'.
	 * 
	 * @return String
	 */

	public String getInsnombre() {
		return this.insnombre;
	}

	/**
	 * Method 'setInsnombre'.
	 * 
	 * @param insnombre
	 *            String
	 * @return
	 */

	public void setInsnombre(String insnombre) {
		this.insnombre = insnombre;
	}

	/**
	 * Method 'getInsnombree'.
	 * 
	 * @return String
	 */

	public String getInsnombree() {
		return this.insnombree;
	}

	/**
	 * Method 'setInsnombree'.
	 * 
	 * @param insnombree
	 *            String
	 * @return
	 */

	public void setInsnombree(String insnombree) {
		this.insnombree = insnombree;
	}

	/**
	 * Method 'getInsbaja'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getInsbaja() {
		return this.insbaja;
	}

	/**
	 * Method 'setInsbaja'.
	 * 
	 * @param insbaja
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setInsbaja(Date insbaja) {
		this.insbaja = insbaja;
	}

	/**
	 * Method 'getPlantillaInses'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<PlantillaIns> getPlantillaInses() {
		return this.plantillaInses;
	}

	/**
	 * Method 'setPlantillaInses'.
	 * 
	 * @param plantillaInses
	 *            List
	 * @return
	 */
	public void setPlantillaInses(List<PlantillaIns> plantillaInses) {
		this.plantillaInses = plantillaInses;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ inscodcarta: ").append(this.inscodcarta).append(" ]");
		result.append(", [ insnombre: ").append(this.insnombre).append(" ]");
		result.append(", [ insnombree: ").append(this.insnombree).append(" ]");
		result.append(", [ insbaja: ").append(this.insbaja).append(" ]");
		result.append("}");
		return result.toString();
	}

}
