package com.ejie.y41a.model;

import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.URL;
import org.springframework.format.annotation.NumberFormat;
import org.springframework.format.annotation.NumberFormat.Style;

import com.ejie.y41a.control.Y41aJsonDateDeserializer;
import com.ejie.y41a.control.Y41aJsonDateSerializer;
import com.ejie.y41a.validation.Y41aNifNieCif;

//import com.ejie.y41a.validation.Y41aTelefono;

/**
 * * Establecimiento generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

public class EstablecimientoDetalle implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String escodigo;
	private String mocodigo;
	private String monombre;
	private String mousu;
	@Length(max = 50, message = "error01.lenght.esrazonsocial")
	// @NotEmpty(message = "error01.required.esrazonsocial")
	private String esnombre;
	@Y41aNifNieCif(message = "error03.required.cif")
	private String esnif;
	private String esnoan;
	@Length(max = 50, message = "error02.lenght.esnombre")
	@NotEmpty(message = "error02.required.esnombre")
	private String esnoco;
	private String esnodir;
	private String escolo;
	private String esnrcopo;
	// @Y41aTelefono(message = "error07.validacion.telefono1")
	private String esnrtel;
	private String esnrfax;
	private String escopa;
	private String esincapr;
	private String esindemp;
	@NumberFormat(style = Style.NUMBER)
	@Length(max = 1000, message = "error06.lenght.esteco")
	private String esteco;
	private String esinadar;
	private Date esfeadar;
	@Email(message = "error10.required.email")
	private String escoem;
	private String esinempr;
	// @Y41aTelefono(message = "error08.validacion.telefono2")
	private String esnrtel2;
	private String esinfeba;
	private Date esfeba;
	private String esnoap1;
	private String esnoap2;
	private String esnolo;
	private String escomapv;
	private String escoca;
	@Length(max = 50, message = "error09.lenght.esnopeco")
	private String esnopeco;
	private String escoidco;
	private String esinreco;
	private String esfemod;
	private String esinesco;
	private String esnomu;
	private String esnorep;
	@Y41aNifNieCif(message = "error10.required.esnifrep")
	private String esnifrep;
	private String dtteemr;
	private String escarep;
	@URL(protocol = "http", message = "error04.required.web")
	private String esteurl;
	private String escooe;
	private String oenombre;
	private String esnodeco;
	private String esintiar;
	private Date esfeplad;
	private String esindeme;
	private String esnoraPaisId;
	private String esnoraPaisNombre;
	private String provinciaId;
	private String esnombreProvincia;
	private String municipioId;
	private String esnombreMunicipio;
	private String localidadId;
	private String esnombreLocalidad;
	private String calleId;
	private String calleId_label;
	private String cpId;
	private String esnombreCp;
	private String portalId;
	private String esnombrePortal;
	private String esnombrePiso;
	private String esdireccion_nocapv;
	private String esdireccionCompleta;
	private String esexpedientesAbiertos;
	private String eacodigo;
	private String avcodigo;
	private String avnombre;
	private String avnombree;
	@NotEmpty(message = "error05.required.secodigo")
	@Length(max = 7, message = "error05.lenght.secodigo")
	private String secodigo;
	private String senombre;
	private String senombree;
	private String eainprse;
	private String esnumReclamaciones;
	private String direccionAntiguaCompleta;
	private String esextranjero;

	// Arbitraje
	private Date ahfeba;
	private String ahtelimi;

	/**
	 * Method 'Establecimiento'.
	 * 
	 */
	public EstablecimientoDetalle() {
	}

	/**
	 * @param escodigo
	 * @param mocodigo
	 * @param monombre
	 * @param mousu
	 * @param esnombre
	 * @param esnif
	 * @param esnoan
	 * @param esnoco
	 * @param esnodir
	 * @param escolo
	 * @param esnrcopo
	 * @param esnrtel
	 * @param esnrfax
	 * @param escopa
	 * @param esincapr
	 * @param esindemp
	 * @param esteco
	 * @param esinadar
	 * @param esfeadar
	 * @param escoem
	 * @param esinempr
	 * @param esnrtel2
	 * @param esinfeba
	 * @param esfeba
	 * @param esnoap1
	 * @param esnoap2
	 * @param esnolo
	 * @param escomapv
	 * @param escoca
	 * @param esnopeco
	 * @param escoidco
	 * @param esinreco
	 * @param esfemod
	 * @param esinesco
	 * @param esnomu
	 * @param esnorep
	 * @param esnifrep
	 * @param dtteemr
	 * @param escarep
	 * @param esteurl
	 * @param escooe
	 * @param esnodeco
	 * @param esintiar
	 * @param esfeplad
	 * @param esindeme
	 * @param esnoraPaisId
	 * @param esnoraPaisNombre
	 * @param provinciaId
	 * @param esnombreProvincia
	 * @param municipioId
	 * @param esnombreMunicipio
	 * @param localidadId
	 * @param esnombreLocalidad
	 * @param calleId
	 * @param calleId_label
	 * @param cpId
	 * @param esnombreCp
	 * @param portalId
	 * @param esnombrePortal
	 * @param esnombrePiso
	 * @param esdireccion_nocapv
	 * @param esdireccionCompleta
	 * @param esexpedientesAbiertos
	 * @param eacodigo
	 * @param avcodigo
	 * @param avnombre
	 * @param avnombree
	 * @param secodigo
	 * @param senombre
	 * @param senombree
	 * @param eainprse
	 */
	public EstablecimientoDetalle(String escodigo, String mocodigo,
			String monombre, String mousu, String esnombre, String esnif,
			String esnoan, String esnoco, String esnodir, String escolo,
			String esnrcopo, String esnrtel, String esnrfax, String escopa,
			String esincapr, String esindemp, String esteco, String esinadar,
			Date esfeadar, String escoem, String esinempr, String esnrtel2,
			String esinfeba, Date esfeba, String esnoap1, String esnoap2,
			String esnolo, String escomapv, String escoca, String esnopeco,
			String escoidco, String esinreco, String esfemod, String esinesco,
			String esnomu, String esnorep, String esnifrep, String dtteemr,
			String escarep, String esteurl, String escooe, String esnodeco,
			String esintiar, Date esfeplad, String esindeme,
			String esnoraPaisId, String esnoraPaisNombre, String provinciaId,
			String esnombreProvincia, String municipioId,
			String esnombreMunicipio, String localidadId,
			String esnombreLocalidad, String calleId, String calleId_label,
			String cpId, String esnombreCp, String portalId,
			String esnombrePortal, String esnombrePiso,
			String esdireccion_nocapv, String esdireccionCompleta,
			String esexpedientesAbiertos, String eacodigo, String avcodigo,
			String avnombre, String avnombree, String secodigo,
			String senombre, String senombree, String eainprse,
			String esextranjero) {
		super();
		this.escodigo = escodigo;
		this.mocodigo = mocodigo;
		this.monombre = monombre;
		this.mousu = mousu;
		this.esnombre = esnombre;
		this.esnif = esnif;
		this.esnoan = esnoan;
		this.esnoco = esnoco;
		this.esnodir = esnodir;
		this.escolo = escolo;
		this.esnrcopo = esnrcopo;
		this.esnrtel = esnrtel;
		this.esnrfax = esnrfax;
		this.escopa = escopa;
		this.esincapr = esincapr;
		this.esindemp = esindemp;
		this.esteco = esteco;
		this.esinadar = esinadar;
		this.esfeadar = esfeadar;
		this.escoem = escoem;
		this.esinempr = esinempr;
		this.esnrtel2 = esnrtel2;
		this.esinfeba = esinfeba;
		this.esfeba = esfeba;
		this.esnoap1 = esnoap1;
		this.esnoap2 = esnoap2;
		this.esnolo = esnolo;
		this.escomapv = escomapv;
		this.escoca = escoca;
		this.esnopeco = esnopeco;
		this.escoidco = escoidco;
		this.esinreco = esinreco;
		this.esfemod = esfemod;
		this.esinesco = esinesco;
		this.esnomu = esnomu;
		this.esnorep = esnorep;
		this.esnifrep = esnifrep;
		this.dtteemr = dtteemr;
		this.escarep = escarep;
		this.esteurl = esteurl;
		this.escooe = escooe;
		this.esnodeco = esnodeco;
		this.esintiar = esintiar;
		this.esfeplad = esfeplad;
		this.esindeme = esindeme;
		this.esnoraPaisId = esnoraPaisId;
		this.esnoraPaisNombre = esnoraPaisNombre;
		this.provinciaId = provinciaId;
		this.esnombreProvincia = esnombreProvincia;
		this.municipioId = municipioId;
		this.esnombreMunicipio = esnombreMunicipio;
		this.localidadId = localidadId;
		this.esnombreLocalidad = esnombreLocalidad;
		this.calleId = calleId;
		this.calleId_label = calleId_label;
		this.cpId = cpId;
		this.esnombreCp = esnombreCp;
		this.portalId = portalId;
		this.esnombrePortal = esnombrePortal;
		this.esnombrePiso = esnombrePiso;
		this.esdireccion_nocapv = esdireccion_nocapv;
		this.esdireccionCompleta = esdireccionCompleta;
		this.esexpedientesAbiertos = esexpedientesAbiertos;
		this.eacodigo = eacodigo;
		this.avcodigo = avcodigo;
		this.avnombre = avnombre;
		this.avnombree = avnombree;
		this.secodigo = secodigo;
		this.senombre = senombre;
		this.senombree = senombree;
		this.eainprse = eainprse;
		this.esextranjero = esextranjero;
	}

	/**
	 * Method 'getEscodigo'.
	 * 
	 * @return String
	 */

	public String getEscodigo() {
		return this.escodigo;
	}

	/**
	 * Method 'setEscodigo'.
	 * 
	 * @param escodigo
	 *            String
	 * @return
	 */

	public void setEscodigo(String escodigo) {
		this.escodigo = escodigo;
	}

	/**
	 * Method 'getEsnombre'.
	 * 
	 * @return String
	 */

	public String getEsnombre() {
		return this.esnombre;
	}

	/**
	 * Method 'setEsnombre'.
	 * 
	 * @param esnombre
	 *            String
	 * @return
	 */

	public void setEsnombre(String esnombre) {
		this.esnombre = esnombre;
	}

	/**
	 * Method 'getEsnif'.
	 * 
	 * @return String
	 */

	public String getEsnif() {
		return this.esnif;
	}

	/**
	 * Method 'setEsnif'.
	 * 
	 * @param esnif
	 *            String
	 * @return
	 */

	public void setEsnif(String esnif) {
		this.esnif = esnif;
	}

	/**
	 * Method 'getEsnoan'.
	 * 
	 * @return String
	 */

	public String getEsnoan() {
		return this.esnoan;
	}

	/**
	 * Method 'setEsnoan'.
	 * 
	 * @param esnoan
	 *            String
	 * @return
	 */

	public void setEsnoan(String esnoan) {
		this.esnoan = esnoan;
	}

	/**
	 * Method 'getEsnoco'.
	 * 
	 * @return String
	 */

	public String getEsnoco() {
		return this.esnoco;
	}

	/**
	 * Method 'setEsnoco'.
	 * 
	 * @param esnoco
	 *            String
	 * @return
	 */

	public void setEsnoco(String esnoco) {
		this.esnoco = esnoco;
	}

	/**
	 * Method 'getEsnodir'.
	 * 
	 * @return String
	 */

	public String getEsnodir() {
		return this.esnodir;
	}

	/**
	 * Method 'setEsnodir'.
	 * 
	 * @param esnodir
	 *            String
	 * @return
	 */

	public void setEsnodir(String esnodir) {
		this.esnodir = esnodir;
	}

	/**
	 * Method 'getEscolo'.
	 * 
	 * @return String
	 */

	public String getEscolo() {
		return this.escolo;
	}

	/**
	 * Method 'setEscolo'.
	 * 
	 * @param escolo
	 *            String
	 * @return
	 */

	public void setEscolo(String escolo) {
		this.escolo = escolo;
	}

	/**
	 * Method 'getEsnrcopo'.
	 * 
	 * @return String
	 */

	public String getEsnrcopo() {
		return this.esnrcopo;
	}

	/**
	 * Method 'setEsnrcopo'.
	 * 
	 * @param esnrcopo
	 *            String
	 * @return
	 */

	public void setEsnrcopo(String esnrcopo) {
		this.esnrcopo = esnrcopo;
	}

	/**
	 * Method 'getEsnrtel'.
	 * 
	 * @return String
	 */

	public String getEsnrtel() {
		return this.esnrtel;
	}

	/**
	 * Method 'setEsnrtel'.
	 * 
	 * @param esnrtel
	 *            String
	 * @return
	 */

	public void setEsnrtel(String esnrtel) {
		this.esnrtel = esnrtel;
	}

	/**
	 * Method 'getEsnrfax'.
	 * 
	 * @return String
	 */

	public String getEsnrfax() {
		return this.esnrfax;
	}

	/**
	 * Method 'setEsnrfax'.
	 * 
	 * @param esnrfax
	 *            String
	 * @return
	 */

	public void setEsnrfax(String esnrfax) {
		this.esnrfax = esnrfax;
	}

	/**
	 * Method 'getEscopa'.
	 * 
	 * @return String
	 */

	public String getEscopa() {
		return this.escopa;
	}

	/**
	 * Method 'setEscopa'.
	 * 
	 * @param escopa
	 *            String
	 * @return
	 */

	public void setEscopa(String escopa) {
		this.escopa = escopa;
	}

	/**
	 * Method 'getEsincapr'.
	 * 
	 * @return String
	 */

	public String getEsincapr() {
		return this.esincapr;
	}

	/**
	 * Method 'setEsincapr'.
	 * 
	 * @param esincapr
	 *            String
	 * @return
	 */

	public void setEsincapr(String esincapr) {
		this.esincapr = esincapr;
	}

	/**
	 * Method 'getEsindemp'.
	 * 
	 * @return String
	 */

	public String getEsindemp() {
		return this.esindemp;
	}

	/**
	 * Method 'setEsindemp'.
	 * 
	 * @param esindemp
	 *            String
	 * @return
	 */

	public void setEsindemp(String esindemp) {
		this.esindemp = esindemp;
	}

	/**
	 * Method 'getEsteco'.
	 * 
	 * @return String
	 */

	public String getEsteco() {
		return this.esteco;
	}

	/**
	 * Method 'setEsteco'.
	 * 
	 * @param esteco
	 *            String
	 * @return
	 */

	public void setEsteco(String esteco) {
		this.esteco = esteco;
	}

	/**
	 * Method 'getEsinadar'.
	 * 
	 * @return String
	 */

	public String getEsinadar() {
		return this.esinadar;
	}

	/**
	 * Method 'setEsinadar'.
	 * 
	 * @param esinadar
	 *            String
	 * @return
	 */

	public void setEsinadar(String esinadar) {
		this.esinadar = esinadar;
	}

	/**
	 * Method 'getEsfeadar'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getEsfeadar() {
		return this.esfeadar;
	}

	/**
	 * Method 'setEsfeadar'.
	 * 
	 * @param esfeadar
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setEsfeadar(Date esfeadar) {
		this.esfeadar = esfeadar;
	}

	/**
	 * Method 'getEscoem'.
	 * 
	 * @return String
	 */

	public String getEscoem() {
		return this.escoem;
	}

	/**
	 * Method 'setEscoem'.
	 * 
	 * @param escoem
	 *            String
	 * @return
	 */

	public void setEscoem(String escoem) {
		this.escoem = escoem;
	}

	/**
	 * Method 'getEsinempr'.
	 * 
	 * @return String
	 */

	public String getEsinempr() {
		return this.esinempr;
	}

	/**
	 * Method 'setEsinempr'.
	 * 
	 * @param esinempr
	 *            String
	 * @return
	 */

	public void setEsinempr(String esinempr) {
		this.esinempr = esinempr;
	}

	/**
	 * Method 'getEsnrtel2'.
	 * 
	 * @return String
	 */

	public String getEsnrtel2() {
		return this.esnrtel2;
	}

	/**
	 * Method 'setEsnrtel2'.
	 * 
	 * @param esnrtel2
	 *            String
	 * @return
	 */

	public void setEsnrtel2(String esnrtel2) {
		this.esnrtel2 = esnrtel2;
	}

	/**
	 * Method 'getEsfeba'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getEsfeba() {
		return this.esfeba;
	}

	/**
	 * Method 'setEsfeba'.
	 * 
	 * @param esfeba
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setEsfeba(Date esfeba) {
		this.esfeba = esfeba;
	}

	/**
	 * Method 'getEsnoap1'.
	 * 
	 * @return String
	 */

	public String getEsnoap1() {
		return this.esnoap1;
	}

	/**
	 * Method 'setEsnoap1'.
	 * 
	 * @param esnoap1
	 *            String
	 * @return
	 */

	public void setEsnoap1(String esnoap1) {
		this.esnoap1 = esnoap1;
	}

	/**
	 * Method 'getEsnoap2'.
	 * 
	 * @return String
	 */

	public String getEsnoap2() {
		return this.esnoap2;
	}

	/**
	 * Method 'setEsnoap2'.
	 * 
	 * @param esnoap2
	 *            String
	 * @return
	 */

	public void setEsnoap2(String esnoap2) {
		this.esnoap2 = esnoap2;
	}

	/**
	 * Method 'getEsnolo'.
	 * 
	 * @return String
	 */

	public String getEsnolo() {
		return this.esnolo;
	}

	/**
	 * Method 'setEsnolo'.
	 * 
	 * @param esnolo
	 *            String
	 * @return
	 */

	public void setEsnolo(String esnolo) {
		this.esnolo = esnolo;
	}

	/**
	 * Method 'getEscomapv'.
	 * 
	 * @return String
	 */

	public String getEscomapv() {
		return this.escomapv;
	}

	/**
	 * Method 'setEscomapv'.
	 * 
	 * @param escomapv
	 *            String
	 * @return
	 */

	public void setEscomapv(String escomapv) {
		this.escomapv = escomapv;
	}

	/**
	 * Method 'getEscoca'.
	 * 
	 * @return String
	 */

	public String getEscoca() {
		return this.escoca;
	}

	/**
	 * Method 'setEscoca'.
	 * 
	 * @param escoca
	 *            String
	 * @return
	 */

	public void setEscoca(String escoca) {
		this.escoca = escoca;
	}

	/**
	 * Method 'getEsnopeco'.
	 * 
	 * @return String
	 */

	public String getEsnopeco() {
		return this.esnopeco;
	}

	/**
	 * Method 'setEsnopeco'.
	 * 
	 * @param esnopeco
	 *            String
	 * @return
	 */

	public void setEsnopeco(String esnopeco) {
		this.esnopeco = esnopeco;
	}

	/**
	 * Method 'getEscoidco'.
	 * 
	 * @return String
	 */

	public String getEscoidco() {
		return this.escoidco;
	}

	/**
	 * Method 'setEscoidco'.
	 * 
	 * @param escoidco
	 *            String
	 * @return
	 */

	public void setEscoidco(String escoidco) {
		this.escoidco = escoidco;
	}

	/**
	 * Method 'getEsinreco'.
	 * 
	 * @return String
	 */

	public String getEsinreco() {
		return this.esinreco;
	}

	/**
	 * Method 'setEsinreco'.
	 * 
	 * @param esinreco
	 *            String
	 * @return
	 */

	public void setEsinreco(String esinreco) {
		this.esinreco = esinreco;
	}

	/**
	 * Method 'getEsfemod'.
	 * 
	 * @return String
	 */

	public String getEsfemod() {
		return this.esfemod;
	}

	/**
	 * Method 'setEsfemod'.
	 * 
	 * @param esfemod
	 *            String
	 * @return
	 */

	public void setEsfemod(String esfemod) {
		this.esfemod = esfemod;
	}

	/**
	 * Method 'getEsinesco'.
	 * 
	 * @return String
	 */

	public String getEsinesco() {
		return this.esinesco;
	}

	/**
	 * Method 'setEsinesco'.
	 * 
	 * @param esinesco
	 *            String
	 * @return
	 */

	public void setEsinesco(String esinesco) {
		this.esinesco = esinesco;
	}

	/**
	 * Method 'getEsnomu'.
	 * 
	 * @return String
	 */

	public String getEsnomu() {
		return this.esnomu;
	}

	/**
	 * Method 'setEsnomu'.
	 * 
	 * @param esnomu
	 *            String
	 * @return
	 */

	public void setEsnomu(String esnomu) {
		this.esnomu = esnomu;
	}

	/**
	 * Method 'getEsnorep'.
	 * 
	 * @return String
	 */

	public String getEsnorep() {
		return this.esnorep;
	}

	/**
	 * Method 'setEsnorep'.
	 * 
	 * @param esnorep
	 *            String
	 * @return
	 */

	public void setEsnorep(String esnorep) {
		this.esnorep = esnorep;
	}

	/**
	 * Method 'getEsnifrep'.
	 * 
	 * @return String
	 */

	public String getEsnifrep() {
		return this.esnifrep;
	}

	/**
	 * Method 'setEsnifrep'.
	 * 
	 * @param esnifrep
	 *            String
	 * @return
	 */

	public void setEsnifrep(String esnifrep) {
		this.esnifrep = esnifrep;
	}

	/**
	 * Method 'getDtteemr'.
	 * 
	 * @return String
	 */

	public String getDtteemr() {
		return this.dtteemr;
	}

	/**
	 * Method 'setDtteemr'.
	 * 
	 * @param dtteemr
	 *            String
	 * @return
	 */

	public void setDtteemr(String dtteemr) {
		this.dtteemr = dtteemr;
	}

	/**
	 * Method 'getEscarep'.
	 * 
	 * @return String
	 */

	public String getEscarep() {
		return this.escarep;
	}

	/**
	 * Method 'setEscarep'.
	 * 
	 * @param escarep
	 *            String
	 * @return
	 */

	public void setEscarep(String escarep) {
		this.escarep = escarep;
	}

	/**
	 * Method 'getEsteurl'.
	 * 
	 * @return String
	 */

	public String getEsteurl() {
		return this.esteurl;
	}

	/**
	 * Method 'setEsteurl'.
	 * 
	 * @param esteurl
	 *            String
	 * @return
	 */

	public void setEsteurl(String esteurl) {
		this.esteurl = esteurl;
	}

	/**
	 * Method 'getEscooe'.
	 * 
	 * @return String
	 */

	public String getEscooe() {
		return this.escooe;
	}

	/**
	 * Method 'setEscooe'.
	 * 
	 * @param escooe
	 *            String
	 * @return
	 */

	public void setEscooe(String escooe) {
		this.escooe = escooe;
	}

	/**
	 * Method 'getEsnodeco'.
	 * 
	 * @return String
	 */

	public String getEsnodeco() {
		return this.esnodeco;
	}

	/**
	 * Method 'setEsnodeco'.
	 * 
	 * @param esnodeco
	 *            String
	 * @return
	 */

	public void setEsnodeco(String esnodeco) {
		this.esnodeco = esnodeco;
	}

	/**
	 * Method 'getEsintiar'.
	 * 
	 * @return String
	 */

	public String getEsintiar() {
		return this.esintiar;
	}

	/**
	 * Method 'setEsintiar'.
	 * 
	 * @param esintiar
	 *            String
	 * @return
	 */

	public void setEsintiar(String esintiar) {
		this.esintiar = esintiar;
	}

	/**
	 * Method 'getEsfeplad'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getEsfeplad() {
		return this.esfeplad;
	}

	/**
	 * Method 'setEsfeplad'.
	 * 
	 * @param esfeplad
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setEsfeplad(Date esfeplad) {
		this.esfeplad = esfeplad;
	}

	/**
	 * Method 'getEsindeme'.
	 * 
	 * @return String
	 */

	public String getEsindeme() {
		return this.esindeme;
	}

	/**
	 * Method 'setEsindeme'.
	 * 
	 * @param esindeme
	 *            String
	 * @return
	 */

	public void setEsindeme(String esindeme) {
		this.esindeme = esindeme;
	}

	/**
	 * Method 'getEsnoraPaisId'.
	 * 
	 * @return String
	 */

	public String getEsnoraPaisId() {
		return this.esnoraPaisId;
	}

	/**
	 * Method 'setEsnoraPaisId'.
	 * 
	 * @param esnoraPaisId
	 *            String
	 * @return
	 */

	public void setEsnoraPaisId(String esnoraPaisId) {
		this.esnoraPaisId = esnoraPaisId;
	}

	/**
	 * Method 'getEsnoraPaisNombre'.
	 * 
	 * @return String
	 */

	public String getEsnoraPaisNombre() {
		return this.esnoraPaisNombre;
	}

	/**
	 * Method 'setEsnoraPaisNombre'.
	 * 
	 * @param esnoraPaisNombre
	 *            String
	 * @return
	 */

	public void setEsnoraPaisNombre(String esnoraPaisNombre) {
		this.esnoraPaisNombre = esnoraPaisNombre;
	}

	/**
	 * @return the provinciaId
	 */
	public String getProvinciaId() {
		return provinciaId;
	}

	/**
	 * @param provinciaId
	 *            the provinciaId to set
	 */
	public void setProvinciaId(String provinciaId) {
		this.provinciaId = provinciaId;
	}

	/**
	 * @return the esnombreProvincia
	 */
	public String getEsnombreProvincia() {
		return esnombreProvincia;
	}

	/**
	 * @param esnombreProvincia
	 *            the esnombreProvincia to set
	 */
	public void setEsnombreProvincia(String esnombreProvincia) {
		this.esnombreProvincia = esnombreProvincia;
	}

	/**
	 * @return the municipioId
	 */
	public String getMunicipioId() {
		return municipioId;
	}

	/**
	 * @param municipioId
	 *            the municipioId to set
	 */
	public void setMunicipioId(String municipioId) {
		this.municipioId = municipioId;
	}

	/**
	 * @return the esnombreMunicipio
	 */
	public String getEsnombreMunicipio() {
		return esnombreMunicipio;
	}

	/**
	 * @param esnombreMunicipio
	 *            the esnombreMunicipio to set
	 */
	public void setEsnombreMunicipio(String esnombreMunicipio) {
		this.esnombreMunicipio = esnombreMunicipio;
	}

	/**
	 * @return the localidadId
	 */
	public String getLocalidadId() {
		return localidadId;
	}

	/**
	 * @param localidadId
	 *            the localidadId to set
	 */
	public void setLocalidadId(String localidadId) {
		this.localidadId = localidadId;
	}

	/**
	 * @return the esnombreLocalidad
	 */
	public String getEsnombreLocalidad() {
		return esnombreLocalidad;
	}

	/**
	 * @param esnombreLocalidad
	 *            the esnombreLocalidad to set
	 */
	public void setEsnombreLocalidad(String esnombreLocalidad) {
		this.esnombreLocalidad = esnombreLocalidad;
	}

	/**
	 * @return the calleId
	 */
	public String getCalleId() {
		return calleId;
	}

	/**
	 * @param calleId
	 *            the calleId to set
	 */
	public void setCalleId(String calleId) {
		this.calleId = calleId;
	}

	/**
	 * @return the calleId_label
	 */
	public String getCalleId_label() {
		return calleId_label;
	}

	/**
	 * @param calleId_label
	 *            the calleId_label to set
	 */
	public void setCalleId_label(String calleId_label) {
		this.calleId_label = calleId_label;
	}

	/**
	 * @return the cpId
	 */
	public String getCpId() {
		return cpId;
	}

	/**
	 * @param cpId
	 *            the cpId to set
	 */
	public void setCpId(String cpId) {
		this.cpId = cpId;
	}

	/**
	 * @return the esnombreCp
	 */
	public String getEsnombreCp() {
		return esnombreCp;
	}

	/**
	 * @param esnombreCp
	 *            the esnombreCp to set
	 */
	public void setEsnombreCp(String esnombreCp) {
		this.esnombreCp = esnombreCp;
	}

	/**
	 * @return the portalId
	 */
	public String getPortalId() {
		return portalId;
	}

	/**
	 * @param portalId
	 *            the portalId to set
	 */
	public void setPortalId(String portalId) {
		this.portalId = portalId;
	}

	/**
	 * Method 'getEsnombrePortal'.
	 * 
	 * @return String
	 */

	public String getEsnombrePortal() {
		return this.esnombrePortal;
	}

	/**
	 * Method 'setEsnombrePortal'.
	 * 
	 * @param esnombrePortal
	 *            String
	 * @return
	 */

	public void setEsnombrePortal(String esnombrePortal) {
		this.esnombrePortal = esnombrePortal;
	}

	/**
	 * @return the esinfeba
	 */
	public String getEsinfeba() {
		return esinfeba;
	}

	/**
	 * @param esinfeba
	 *            the esinfeba to set
	 */
	public void setEsinfeba(String esinfeba) {
		this.esinfeba = esinfeba;
	}

	/**
	 * @return the esnombrePiso
	 */
	public String getEsnombrePiso() {
		return esnombrePiso;
	}

	/**
	 * @param esnombrePiso
	 *            the esnombrePiso to set
	 */
	public void setEsnombrePiso(String esnombrePiso) {
		this.esnombrePiso = esnombrePiso;
	}

	/**
	 * @return the esdireccionCompleta
	 */
	public String getEsdireccionCompleta() {
		return esdireccionCompleta;
	}

	/**
	 * @param esdireccionCompleta
	 *            the esdireccionCompleta to set
	 */
	public void setEsdireccionCompleta(String esdireccionCompleta) {
		this.esdireccionCompleta = esdireccionCompleta;
	}

	/**
	 * @return the esexpedientesAbiertos
	 */
	public String getEsexpedientesAbiertos() {
		return esexpedientesAbiertos;
	}

	/**
	 * @param esexpedientesAbiertos
	 *            the esexpedientesAbiertos to set
	 */
	public void setEsexpedientesAbiertos(String esexpedientesAbiertos) {
		this.esexpedientesAbiertos = esexpedientesAbiertos;
	}

	/**
	 * @return the mocodigo
	 */
	public String getMocodigo() {
		return mocodigo;
	}

	/**
	 * @param mocodigo
	 *            the mocodigo to set
	 */
	public void setMocodigo(String mocodigo) {
		this.mocodigo = mocodigo;
	}

	/**
	 * @return the monombre
	 */
	public String getMonombre() {
		return monombre;
	}

	/**
	 * @param monombre
	 *            the monombre to set
	 */
	public void setMonombre(String monombre) {
		this.monombre = monombre;
	}

	/**
	 * @return the mousu
	 */
	public String getMousu() {
		return mousu;
	}

	/**
	 * @param mousu
	 *            the mousu to set
	 */
	public void setMousu(String mousu) {
		this.mousu = mousu;
	}

	/**
	 * @return the eacodigo
	 */
	public String getEacodigo() {
		return eacodigo;
	}

	/**
	 * @param eacodigo
	 *            the eacodigo to set
	 */
	public void setEacodigo(String eacodigo) {
		this.eacodigo = eacodigo;
	}

	/**
	 * @return the avcodigo
	 */
	public String getAvcodigo() {
		return avcodigo;
	}

	/**
	 * @param avcodigo
	 *            the avcodigo to set
	 */
	public void setAvcodigo(String avcodigo) {
		this.avcodigo = avcodigo;
	}

	/**
	 * @return the avnombre
	 */
	public String getAvnombre() {
		return avnombre;
	}

	/**
	 * @param avnombre
	 *            the avnombre to set
	 */
	public void setAvnombre(String avnombre) {
		this.avnombre = avnombre;
	}

	/**
	 * @return the avnombree
	 */
	public String getAvnombree() {
		return avnombree;
	}

	/**
	 * @param avnombree
	 *            the avnombree to set
	 */
	public void setAvnombree(String avnombree) {
		this.avnombree = avnombree;
	}

	/**
	 * @return the secodigo
	 */
	public String getSecodigo() {
		return secodigo;
	}

	/**
	 * @param secodigo
	 *            the secodigo to set
	 */
	public void setSecodigo(String secodigo) {
		this.secodigo = secodigo;
	}

	/**
	 * @return the senombre
	 */
	public String getSenombre() {
		return senombre;
	}

	/**
	 * @param senombre
	 *            the senombre to set
	 */
	public void setSenombre(String senombre) {
		this.senombre = senombre;
	}

	/**
	 * @return the senombree
	 */
	public String getSenombree() {
		return senombree;
	}

	/**
	 * @param senombree
	 *            the senombree to set
	 */
	public void setSenombree(String senombree) {
		this.senombree = senombree;
	}

	/**
	 * @return the eainprse
	 */
	public String getEainprse() {
		return eainprse;
	}

	/**
	 * @param eainprse
	 *            the eainprse to set
	 */
	public void setEainprse(String eainprse) {
		this.eainprse = eainprse;
	}

	/**
	 * @return the esnumReclamaciones
	 */
	public String getEsnumReclamaciones() {
		return esnumReclamaciones;
	}

	/**
	 * @param esnumReclamaciones
	 *            the esnumReclamaciones to set
	 */
	public void setEsnumReclamaciones(String esnumReclamaciones) {
		this.esnumReclamaciones = esnumReclamaciones;
	}

	/**
	 * @return the direccionAntiguaCompleta
	 */
	public String getDireccionAntiguaCompleta() {
		return direccionAntiguaCompleta;
	}

	/**
	 * @param direccionAntiguaCompleta
	 *            the direccionAntiguaCompleta to set
	 */
	public void setDireccionAntiguaCompleta(String direccionAntiguaCompleta) {
		this.direccionAntiguaCompleta = direccionAntiguaCompleta;
	}

	/**
	 * @return the esextranjero
	 */
	public String getEsextranjero() {
		return esextranjero;
	}

	/**
	 * @param esextranjero
	 *            the esextranjero to set
	 */
	public void setEsextranjero(String esextranjero) {
		this.esextranjero = esextranjero;
	}

	/**
	 * @return the esdireccion_nocapv
	 */
	public String getEsdireccion_nocapv() {
		return esdireccion_nocapv;
	}

	/**
	 * @param esdireccion_nocapv
	 *            the esdireccion_nocapv to set
	 */
	public void setEsdireccion_nocapv(String esdireccion_nocapv) {
		this.esdireccion_nocapv = esdireccion_nocapv;
	}

	/**
	 * @return the ahfeba
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getAhfeba() {
		return ahfeba;
	}

	/**
	 * @param ahfeba
	 *            the ahfeba to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setAhfeba(Date ahfeba) {
		this.ahfeba = ahfeba;
	}

	/**
	 * @return the ahtelimi
	 */
	public String getAhtelimi() {
		return ahtelimi;
	}

	/**
	 * @param ahtelimi
	 *            the ahtelimi to set
	 */
	public void setAhtelimi(String ahtelimi) {
		this.ahtelimi = ahtelimi;
	}

	/**
	 * @return the oenombre
	 */
	public String getOenombre() {
		return oenombre;
	}

	/**
	 * @param oenombre
	 *            the oenombre to set
	 */
	public void setOenombre(String oenombre) {
		this.oenombre = oenombre;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "EstablecimientoDetalle [escodigo=" + escodigo + ", mocodigo="
				+ mocodigo + ", monombre=" + monombre + ", mousu=" + mousu
				+ ", esnombre=" + esnombre + ", esnif=" + esnif + ", esnoan="
				+ esnoan + ", esnoco=" + esnoco + ", esnodir=" + esnodir
				+ ", escolo=" + escolo + ", esnrcopo=" + esnrcopo
				+ ", esnrtel=" + esnrtel + ", esnrfax=" + esnrfax + ", escopa="
				+ escopa + ", esincapr=" + esincapr + ", esindemp=" + esindemp
				+ ", esteco=" + esteco + ", esinadar=" + esinadar
				+ ", esfeadar=" + esfeadar + ", escoem=" + escoem
				+ ", esinempr=" + esinempr + ", esnrtel2=" + esnrtel2
				+ ", esinfeba=" + esinfeba + ", esfeba=" + esfeba
				+ ", esnoap1=" + esnoap1 + ", esnoap2=" + esnoap2 + ", esnolo="
				+ esnolo + ", escomapv=" + escomapv + ", escoca=" + escoca
				+ ", esnopeco=" + esnopeco + ", escoidco=" + escoidco
				+ ", esinreco=" + esinreco + ", esfemod=" + esfemod
				+ ", esinesco=" + esinesco + ", esnomu=" + esnomu
				+ ", esnorep=" + esnorep + ", esnifrep=" + esnifrep
				+ ", dtteemr=" + dtteemr + ", escarep=" + escarep
				+ ", esteurl=" + esteurl + ", escooe=" + escooe + ", esnodeco="
				+ esnodeco + ", esintiar=" + esintiar + ", esfeplad="
				+ esfeplad + ", esindeme=" + esindeme + ", esnoraPaisId="
				+ esnoraPaisId + ", esnoraPaisNombre=" + esnoraPaisNombre
				+ ", provinciaId=" + provinciaId + ", esnombreProvincia="
				+ esnombreProvincia + ", municipioId=" + municipioId
				+ ", esnombreMunicipio=" + esnombreMunicipio + ", localidadId="
				+ localidadId + ", esnombreLocalidad=" + esnombreLocalidad
				+ ", calleId=" + calleId + ", calleId_label=" + calleId_label
				+ ", cpId=" + cpId + ", esnombreCp=" + esnombreCp
				+ ", portalId=" + portalId + ", esnombrePortal="
				+ esnombrePortal + ", esnombrePiso=" + esnombrePiso
				+ ", esdireccion_nocapv=" + esdireccion_nocapv
				+ ", esdireccionCompleta=" + esdireccionCompleta
				+ ", esexpedientesAbiertos=" + esexpedientesAbiertos
				+ ", eacodigo=" + eacodigo + ", avcodigo=" + avcodigo
				+ ", avnombre=" + avnombre + ", avnombree=" + avnombree
				+ ", secodigo=" + secodigo + ", senombre=" + senombre
				+ ", senombree=" + senombree + ", eainprse=" + eainprse
				+ ", esnumReclamaciones=" + esnumReclamaciones
				+ ", direccionAntiguaCompleta=" + direccionAntiguaCompleta
				+ "]";
	}

}
