package com.ejie.y41a.model;

import java.sql.Blob;
import java.util.Date;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y41a.control.Y41aJsonDateDeserializer;
import com.ejie.y41a.control.Y41aJsonDateSerializer;

/**
 * * DecisionHechoDetalle generated by UDA, 22-feb-2012 17:30:25.
 * 
 *  
 */

public class DecisionHechoDetalle implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String hccodigo;
	private String hccoor;
	private Date hcfede;
	private Date hcfecode;
	private String hccoorprop;

	// Hecho Denunciado

	private String hdcodigo;

	// Decision
	// @NotEmpty(message = "required.decodigo")
	// @Length(max = 20, message = "lenght.decodigo")
	private String decodigo;
	private String denombre;
	private String denombree;
	private Date debaja;
	private String hccoortrasinhibi;
	private String orgtrasinhibi_nombre;
	private String orgtrasinhibi_nombree;

	// Documento
	private Integer q5codocumento;
	private String q5nofile;
	private Blob q5datafile;
	private Integer q5sizefile;
	private String q5tedesfile;
	private String q5origen;
	private Date q5fecha;
	private String q5indmail;
	private String q5contenttypefile;

	// Monitor
	private String mocodigo;
	private String monombre;
	private String codOrg;

	public DecisionHechoDetalle() {
	}

	/**
	 * @param hccodigo
	 * @param hccoor
	 * @param hcfede
	 * @param hcfecode
	 * @param hccoorprop
	 * @param hccoortrasinhibi
	 * @param hdcodigo
	 * @param decodigo
	 * @param denombre
	 * @param denombree
	 * @param debaja
	 * @param q5codocumento
	 * @param q5nofile
	 * @param q5datafile
	 * @param q5sizefile
	 * @param q5tedesfile
	 * @param q5origen
	 * @param q5fecha
	 * @param q5indmail
	 * @param q5contenttypefile
	 * @param mocodigo
	 * @param monombre
	 */
	public DecisionHechoDetalle(String hccodigo, String hccoor, Date hcfede,
			Date hcfecode, String hccoorprop, String hccoortrasinhibi,
			String orgtrasinhibi_nombre, String orgtrasinhibi_nombree,
			String hdcodigo, String decodigo, String denombre,
			String denombree, Date debaja, Integer q5codocumento,
			String q5nofile, Blob q5datafile, Integer q5sizefile,
			String q5tedesfile, String q5origen, Date q5fecha,
			String q5indmail, String q5contenttypefile, String mocodigo,
			String monombre) {
		this.hccodigo = hccodigo;
		this.hccoor = hccoor;
		this.hcfede = hcfede;
		this.hcfecode = hcfecode;
		this.hccoorprop = hccoorprop;
		this.hdcodigo = hdcodigo;
		this.decodigo = decodigo;
		this.denombre = denombre;
		this.denombree = denombree;
		this.debaja = debaja;
		this.hccoortrasinhibi = hccoortrasinhibi;
		this.orgtrasinhibi_nombre = orgtrasinhibi_nombre;
		this.orgtrasinhibi_nombree = orgtrasinhibi_nombree;
		this.q5codocumento = q5codocumento;
		this.q5nofile = q5nofile;
		this.q5datafile = q5datafile;
		this.q5sizefile = q5sizefile;
		this.q5tedesfile = q5tedesfile;
		this.q5origen = q5origen;
		this.q5fecha = q5fecha;
		this.q5indmail = q5indmail;
		this.q5contenttypefile = q5contenttypefile;
		this.mocodigo = mocodigo;
		this.monombre = monombre;
	}

	/**
	 * @return the hccodigo
	 */
	public String getHccodigo() {
		return hccodigo;
	}

	/**
	 * @param hccodigo
	 *            the hccodigo to set
	 */
	public void setHccodigo(String hccodigo) {
		this.hccodigo = hccodigo;
	}

	/**
	 * @return the hccoor
	 */
	public String getHccoor() {
		return hccoor;
	}

	/**
	 * @param hccoor
	 *            the hccoor to set
	 */
	public void setHccoor(String hccoor) {
		this.hccoor = hccoor;
	}

	/**
	 * @return the hcfede
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getHcfede() {
		return hcfede;
	}

	/**
	 * @param hcfede
	 *            the hcfede to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setHcfede(Date hcfede) {
		this.hcfede = hcfede;
	}

	/**
	 * @return the hcfecode
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getHcfecode() {
		return hcfecode;
	}

	/**
	 * @param hcfecode
	 *            the hcfecode to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setHcfecode(Date hcfecode) {
		this.hcfecode = hcfecode;
	}

	/**
	 * @return the hccoorprop
	 */
	public String getHccoorprop() {
		return hccoorprop;
	}

	/**
	 * @param hccoorprop
	 *            the hccoorprop to set
	 */
	public void setHccoorprop(String hccoorprop) {
		this.hccoorprop = hccoorprop;
	}

	/**
	 * @return the hdcodigo
	 */
	public String getHdcodigo() {
		return hdcodigo;
	}

	/**
	 * @param hdcodigo
	 *            the hdcodigo to set
	 */
	public void setHdcodigo(String hdcodigo) {
		this.hdcodigo = hdcodigo;
	}

	/**
	 * @return the decodigo
	 */
	public String getDecodigo() {
		return decodigo;
	}

	/**
	 * @param decodigo
	 *            the decodigo to set
	 */
	public void setDecodigo(String decodigo) {
		this.decodigo = decodigo;
	}

	/**
	 * @return the denombre
	 */
	public String getDenombre() {
		return denombre;
	}

	/**
	 * @param denombre
	 *            the denombre to set
	 */
	public void setDenombre(String denombre) {
		this.denombre = denombre;
	}

	/**
	 * @return the denombree
	 */
	public String getDenombree() {
		return denombree;
	}

	/**
	 * @param denombree
	 *            the denombree to set
	 */
	public void setDenombree(String denombree) {
		this.denombree = denombree;
	}

	/**
	 * @return the debaja
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getDebaja() {
		return debaja;
	}

	/**
	 * @param debaja
	 *            the debaja to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setDebaja(Date debaja) {
		this.debaja = debaja;
	}

	/**
	 * @return the q5codocumento
	 */
	public Integer getQ5codocumento() {
		return q5codocumento;
	}

	/**
	 * @param q5codocumento
	 *            the q5codocumento to set
	 */
	public void setQ5codocumento(Integer q5codocumento) {
		this.q5codocumento = q5codocumento;
	}

	/**
	 * @return the q5nofile
	 */
	public String getQ5nofile() {
		return q5nofile;
	}

	/**
	 * @param q5nofile
	 *            the q5nofile to set
	 */
	public void setQ5nofile(String q5nofile) {
		this.q5nofile = q5nofile;
	}

	/**
	 * @return the q5datafile
	 */
	@JsonIgnore
	public Blob getQ5datafile() {
		return q5datafile;
	}

	/**
	 * @param q5datafile
	 *            the q5datafile to set
	 */
	public void setQ5datafile(Blob q5datafile) {
		this.q5datafile = q5datafile;
	}

	/**
	 * @return the q5sizefile
	 */
	public Integer getQ5sizefile() {
		return q5sizefile;
	}

	/**
	 * @param q5sizefile
	 *            the q5sizefile to set
	 */
	public void setQ5sizefile(Integer q5sizefile) {
		this.q5sizefile = q5sizefile;
	}

	/**
	 * @return the q5tedesfile
	 */
	public String getQ5tedesfile() {
		return q5tedesfile;
	}

	/**
	 * @param q5tedesfile
	 *            the q5tedesfile to set
	 */
	public void setQ5tedesfile(String q5tedesfile) {
		this.q5tedesfile = q5tedesfile;
	}

	/**
	 * @return the q5origen
	 */
	public String getQ5origen() {
		return q5origen;
	}

	/**
	 * @param q5origen
	 *            the q5origen to set
	 */
	public void setQ5origen(String q5origen) {
		this.q5origen = q5origen;
	}

	/**
	 * @return the q5fecha
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getQ5fecha() {
		return q5fecha;
	}

	/**
	 * @param q5fecha
	 *            the q5fecha to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setQ5fecha(Date q5fecha) {
		this.q5fecha = q5fecha;
	}

	/**
	 * @return the q5indmail
	 */
	public String getQ5indmail() {
		return q5indmail;
	}

	/**
	 * @param q5indmail
	 *            the q5indmail to set
	 */
	public void setQ5indmail(String q5indmail) {
		this.q5indmail = q5indmail;
	}

	/**
	 * @return the q5contenttypefile
	 */
	public String getQ5contenttypefile() {
		return q5contenttypefile;
	}

	/**
	 * @param q5contenttypefile
	 *            the q5contenttypefile to set
	 */
	public void setQ5contenttypefile(String q5contenttypefile) {
		this.q5contenttypefile = q5contenttypefile;
	}

	/**
	 * @return the mocodigo
	 */
	public String getMocodigo() {
		return mocodigo;
	}

	/**
	 * @param mocodigo
	 *            the mocodigo to set
	 */
	public void setMocodigo(String mocodigo) {
		this.mocodigo = mocodigo;
	}

	/**
	 * @return the monombre
	 */
	public String getMonombre() {
		return monombre;
	}

	/**
	 * @param monombre
	 *            the monombre to set
	 */
	public void setMonombre(String monombre) {
		this.monombre = monombre;
	}

	/**
	 * @return the codOrg
	 */
	public String getCodOrg() {
		return codOrg;
	}

	/**
	 * @param codOrg
	 *            the codOrg to set
	 * 
	 */
	public void setCodOrg(String codOrg) {
		this.codOrg = codOrg;
	}

	/**
	 * @return the hccoortrasinhibi código de organismo destino del
	 *         traslado/inhibición
	 */
	public String getHccoortrasinhibi() {
		return hccoortrasinhibi;
	}

	/**
	 * @param hccoortrasinhibi
	 *            código de organismo destino del traslado/inhibición
	 */
	public void setHccoortrasinhibi(String hccoortrasinhibi) {
		this.hccoortrasinhibi = hccoortrasinhibi;
	}

	/**
	 * @return the orgtrasinhibi_nombre el nombre del organismo destino del
	 *         traslado o inhibición en castellano
	 */
	public String getOrgtrasinhibi_nombre() {
		return orgtrasinhibi_nombre;
	}

	/**
	 * @param orgtrasinhibi_nombre
	 *            el nombre del organismo destino del traslado o inhibición en
	 *            castellano
	 */
	public void setOrgtrasinhibi_nombre(String orgtrasinhibi_nombre) {
		this.orgtrasinhibi_nombre = orgtrasinhibi_nombre;
	}

	/**
	 * @return el nombre del organismo destino del traslado o inhibición en
	 *         euskera
	 */
	public String getOrgtrasinhibi_nombree() {
		return orgtrasinhibi_nombree;
	}

	/**
	 * @param orgtrasinhibi_nombree
	 *            el nombre del organismo destino del traslado o inhibición en
	 *            euskera
	 */
	public void setOrgtrasinhibi_nombree(String orgtrasinhibi_nombree) {
		this.orgtrasinhibi_nombree = orgtrasinhibi_nombree;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "DecisionHechoDetalle [hccodigo=" + hccodigo + ", hccoor="
				+ hccoor + ", hcfede=" + hcfede + ", hcfecode=" + hcfecode
				+ ", hccoorprop=" + hccoorprop + ", hdcodigo=" + hdcodigo
				+ ", decodigo=" + decodigo + ", denombre=" + denombre
				+ ", denombree=" + denombree + ", debaja=" + debaja
				+ ", hccoortrasinhibi=" + hccoortrasinhibi
				+ ", orgtrasinhibi_nombre=" + orgtrasinhibi_nombre
				+ ", orgtrasinhibi_nombree=" + orgtrasinhibi_nombree
				+ ", q5codocumento=" + q5codocumento + ", q5nofile=" + q5nofile
				+ ", q5datafile=" + q5datafile + ", q5sizefile=" + q5sizefile
				+ ", q5tedesfile=" + q5tedesfile + ", q5origen=" + q5origen
				+ ", q5fecha=" + q5fecha + ", q5indmail=" + q5indmail
				+ ", q5contenttypefile=" + q5contenttypefile + ", mocodigo="
				+ mocodigo + ", monombre=" + monombre + "]";
	}

}
