package com.ejie.y41a.model;

import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * * DecisionHecho generated by UDA, 22-feb-2012 17:30:25.
 * 
 *  
 */

public class DecisionHecho implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String hccodigo;
	private HechoDenunciado hechoDenunciado;
	private Decision decision;
	private String hccoor;
	private Date hcfede;
	private Date hcfecode;
	private String hccoorprop;
	/**
	 * Organismo destino del traslado o inhibición
	 */
	private String hccoortrasinhibi;
	private List<Traslado> traslados = new ArrayList<Traslado>();

	/**
	 * Method 'DecisionHecho'.
	 * 
	 */
	public DecisionHecho() {
	}

	/**
	 * Method 'DecisionHecho'.
	 * 
	 * @param hccodigo
	 *            String
	 * @param hccoor
	 *            String
	 * @param hcfede
	 *            Date
	 * @param hcfecode
	 *            Date
	 * @param hccoorprop
	 *            String
	 * @param hccoortrasinhibi
	 *            String código de organismo destino del traslado o inhibición
	 * @param hechoDenunciado
	 *            HechoDenunciado
	 * @param decision
	 *            Decision
	 */
	public DecisionHecho(String hccodigo, String hccoor, Date hcfede,
			Date hcfecode, String hccoorprop, String hccoortrasinhibi,
			HechoDenunciado hechoDenunciado, Decision decision) {
		this.hccodigo = hccodigo;
		this.hechoDenunciado = hechoDenunciado;
		this.decision = decision;
		this.hccoor = hccoor;
		this.hcfede = hcfede;
		this.hcfecode = hcfecode;
		this.hccoorprop = hccoorprop;
		this.hccoortrasinhibi = hccoortrasinhibi;
	}

	/**
	 * Method 'DecisionHecho'.
	 * 
	 * @param hccodigo
	 *            String
	 * @param hccoor
	 *            String
	 * @param hcfede
	 *            Date
	 * @param hcfecode
	 *            Date
	 * @param hccoorprop
	 *            String
	 * @param hccoortrasinhibi
	 *            String código de organismo destino del traslado o inhibición
	 * @param hechoDenunciado
	 *            HechoDenunciado
	 * @param decision
	 *            Decision
	 * @param traslados
	 *            List<Traslado>
	 */
	public DecisionHecho(String hccodigo, String hccoor, Date hcfede,
			Date hcfecode, String hccoorprop, String hccoortrasinhibi,
			HechoDenunciado hechoDenunciado, Decision decision,
			List<Traslado> traslados) {

		this.hccodigo = hccodigo;
		this.hechoDenunciado = hechoDenunciado;
		this.decision = decision;
		this.hccoor = hccoor;
		this.hcfede = hcfede;
		this.hcfecode = hcfecode;
		this.hccoorprop = hccoorprop;
		this.hccoortrasinhibi = hccoortrasinhibi;
		this.traslados = traslados;
	}

	/**
	 * Method 'getHccodigo'.
	 * 
	 * @return String
	 */

	public String getHccodigo() {
		return this.hccodigo;
	}

	/**
	 * Method 'setHccodigo'.
	 * 
	 * @param hccodigo
	 *            String
	 * @return
	 */

	public void setHccodigo(String hccodigo) {
		this.hccodigo = hccodigo;
	}

	/**
	 * Method 'getHechoDenunciado'.
	 * 
	 * @return HechoDenunciado
	 */
	@JsonIgnore
	public HechoDenunciado getHechoDenunciado() {
		return this.hechoDenunciado;
	}

	/**
	 * Method 'setHechoDenunciado'.
	 * 
	 * @param hechoDenunciado
	 *            HechoDenunciado
	 * @return
	 */

	public void setHechoDenunciado(HechoDenunciado hechoDenunciado) {
		this.hechoDenunciado = hechoDenunciado;
	}

	/**
	 * Method 'getDecision'.
	 * 
	 * @return Decision
	 */
	@JsonIgnore
	public Decision getDecision() {
		return this.decision;
	}

	/**
	 * Method 'setDecision'.
	 * 
	 * @param decision
	 *            Decision
	 * @return
	 */

	public void setDecision(Decision decision) {
		this.decision = decision;
	}

	/**
	 * Method 'getHccoor'.
	 * 
	 * @return String
	 */

	public String getHccoor() {
		return this.hccoor;
	}

	/**
	 * Method 'setHccoor'.
	 * 
	 * @param hccoor
	 *            String
	 * @return
	 */

	public void setHccoor(String hccoor) {
		this.hccoor = hccoor;
	}

	/**
	 * Method 'getHcfede'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getHcfede() {
		return this.hcfede;
	}

	/**
	 * Method 'setHcfede'.
	 * 
	 * @param hcfede
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setHcfede(Date hcfede) {
		this.hcfede = hcfede;
	}

	/**
	 * Method 'getHcfecode'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getHcfecode() {
		return this.hcfecode;
	}

	/**
	 * Method 'setHcfecode'.
	 * 
	 * @param hcfecode
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setHcfecode(Date hcfecode) {
		this.hcfecode = hcfecode;
	}

	/**
	 * Method 'getHccoorprop'.
	 * 
	 * @return String
	 */

	public String getHccoorprop() {
		return this.hccoorprop;
	}

	/**
	 * Method 'setHccoorprop'.
	 * 
	 * @param hccoorprop
	 *            String
	 * @return
	 */

	public void setHccoorprop(String hccoorprop) {
		this.hccoorprop = hccoorprop;
	}

	/**
	 * Method 'getTraslados'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Traslado> getTraslados() {
		return this.traslados;
	}

	/**
	 * Method 'setTraslados'.
	 * 
	 * @param traslados
	 *            List
	 * @return
	 */
	public void setTraslados(List<Traslado> traslados) {
		this.traslados = traslados;
	}

	/**
	 * @return the hccoortrasinhibi
	 */
	public String getHccoortrasinhibi() {
		return hccoortrasinhibi;
	}

	/**
	 * @param hccoortrasinhibi
	 *            the hccoortrasinhibi to set
	 */
	public void setHccoortrasinhibi(String hccoortrasinhibi) {
		this.hccoortrasinhibi = hccoortrasinhibi;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ hccodigo: ").append(this.hccodigo).append(" ]");
		result.append(", [ hccoor: ").append(this.hccoor).append(" ]");
		result.append(", [ hcfede: ").append(this.hcfede).append(" ]");
		result.append(", [ hcfecode: ").append(this.hcfecode).append(" ]");
		result.append(", [ hccoorprop: ").append(this.hccoorprop).append(" ]");
		result.append("}");
		return result.toString();
	}

}
