package com.ejie.y41a.model;

import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;
import javax.validation.constraints.NotNull;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * * Decision generated by UDA, 05-mar-2012 9:11:42.
 * 
 *  
 */

public class Decision implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String decodigo;
	@NotEmpty(message = "required.decision")
	@NotNull()
	@Length(max = 50, message = "lenght.decision")
	private String denombre;
	@NotEmpty(message = "required.decisione")
	@NotNull()
	@Length(max = 50, message = "lenght.decision")
	private String denombree;
	private Date debaja;
	private List<PlantillaDecision> plantillaDecisions = new ArrayList<PlantillaDecision>();

	/**
	 * Method 'Decision'.
	 * 
	 */
	public Decision() {
	}

	/**
	 * Method 'Decision'.
	 * 
	 * @param decodigo
	 *            String
	 * @param denombre
	 *            String
	 * @param denombree
	 *            String
	 * @param debaja
	 *            Date
	 */
	public Decision(String decodigo, String denombre, String denombree,
			Date debaja) {
		this.decodigo = decodigo;
		this.denombre = denombre;
		this.denombree = denombree;
		this.debaja = debaja;
	}

	/**
	 * Method 'Decision'.
	 * 
	 * @param decodigo
	 *            String
	 * @param denombre
	 *            String
	 * @param denombree
	 *            String
	 * @param debaja
	 *            Date
	 * @param plantillaDecisions
	 *            List<PlantillaDecision>
	 */
	public Decision(String decodigo, String denombre, String denombree,
			Date debaja, List<PlantillaDecision> plantillaDecisions) {

		this.decodigo = decodigo;
		this.denombre = denombre;
		this.denombree = denombree;
		this.debaja = debaja;
		this.plantillaDecisions = plantillaDecisions;
	}

	/**
	 * Method 'getDecodigo'.
	 * 
	 * @return String
	 */

	public String getDecodigo() {
		return this.decodigo;
	}

	/**
	 * Method 'setDecodigo'.
	 * 
	 * @param decodigo
	 *            String
	 * @return
	 */

	public void setDecodigo(String decodigo) {
		this.decodigo = decodigo;
	}

	/**
	 * Method 'getDenombre'.
	 * 
	 * @return String
	 */

	public String getDenombre() {
		return this.denombre;
	}

	/**
	 * Method 'setDenombre'.
	 * 
	 * @param denombre
	 *            String
	 * @return
	 */

	public void setDenombre(String denombre) {
		this.denombre = denombre;
	}

	/**
	 * Method 'getDenombree'.
	 * 
	 * @return String
	 */

	public String getDenombree() {
		return this.denombree;
	}

	/**
	 * Method 'setDenombree'.
	 * 
	 * @param denombree
	 *            String
	 * @return
	 */

	public void setDenombree(String denombree) {
		this.denombree = denombree;
	}

	/**
	 * Method 'getDebaja'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getDebaja() {
		return this.debaja;
	}

	/**
	 * Method 'setDebaja'.
	 * 
	 * @param debaja
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setDebaja(Date debaja) {
		this.debaja = debaja;
	}

	/**
	 * Method 'getPlantillaDecisions'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<PlantillaDecision> getPlantillaDecisions() {
		return this.plantillaDecisions;
	}

	/**
	 * Method 'setPlantillaDecisions'.
	 * 
	 * @param plantillaDecisions
	 *            List
	 * @return
	 */
	public void setPlantillaDecisions(List<PlantillaDecision> plantillaDecisions) {
		this.plantillaDecisions = plantillaDecisions;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ decodigo: ").append(this.decodigo).append(" ]");
		result.append(", [ denombre: ").append(this.denombre).append(" ]");
		result.append(", [ denombree: ").append(this.denombree).append(" ]");
		result.append(", [ debaja: ").append(this.debaja).append(" ]");
		result.append("}");
		return result.toString();
	}

}
