package com.ejie.y41a.model;

import com.ejie.y41a.control.Y41aJsonDateSerializer;
import com.ejie.y41a.control.Y41aJsonDateDeserializer;
import javax.validation.constraints.NotNull;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * * CensoMonitor generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

public class CensoMonitor implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	/*
	 * @Length(max = 3, message = "error01.lenght.mocodigo")
	 * 
	 * @NotEmpty(message = "error01.required.mocodigo1")
	 * 
	 * @NotNull()
	 */
	private String mocodigo;
	private Organismo organismo;
	@Length(max = 35, message = "error02.lenght.monombre")
	@NotEmpty(message = "error02.required.monombre")
	@NotNull()
	private String monombre;
	@NotEmpty(message = "error03.required.emailnull")
	@NotNull()
	@Email(message = "error03.required.email")
	private String mocoem;
	@Length(max = 8, message = "error04.lenght.mousu")
	@NotEmpty(message = "error04.required.mousu")
	@NotNull()
	private String mousu;
	@Length(max = 8, message = "error05.lenght.moclave")
	@NotEmpty(message = "error05.required.moclave")
	@NotNull()
	private String moclave;
	private Date mofecbaja;
	private String moadmin;
	private String moprimera;
	private List<Consulta> consultas = new ArrayList<Consulta>();
	private List<Establecimiento> establecimientos = new ArrayList<Establecimiento>();
	private List<Consumidor> consumidors = new ArrayList<Consumidor>();

	/**
	 * Method 'CensoMonitor'.
	 * 
	 */
	public CensoMonitor() {
	}

	/**
	 * Method 'CensoMonitor'.
	 * 
	 * @param mocodigo
	 *            String
	 * @param monombre
	 *            String
	 * @param mocoem
	 *            String
	 * @param mousu
	 *            String
	 * @param moclave
	 *            String
	 * @param mofecbaja
	 *            Date
	 * @param moadmin
	 *            String
	 * @param moprimera
	 *            String
	 * @param organismo
	 *            Organismo
	 */
	public CensoMonitor(String mocodigo, String monombre, String mocoem,
			String mousu, String moclave, Date mofecbaja, String moadmin,
			String moprimera, Organismo organismo) {
		this.mocodigo = mocodigo;
		this.organismo = organismo;
		this.monombre = monombre;
		this.mocoem = mocoem;
		this.mousu = mousu;
		this.moclave = moclave;
		this.mofecbaja = mofecbaja;
		this.moadmin = moadmin;
		this.moprimera = moprimera;
	}

	/**
	 * Method 'CensoMonitor'.
	 * 
	 * @param mocodigo
	 *            String
	 * @param monombre
	 *            String
	 * @param mocoem
	 *            String
	 * @param mousu
	 *            String
	 * @param moclave
	 *            String
	 * @param mofecbaja
	 *            Date
	 * @param moadmin
	 *            String
	 * @param moprimera
	 *            String
	 * @param organismo
	 *            Organismo
	 * @param consultas
	 *            List<Consulta>
	 * @param establecimientos
	 *            List<Establecimiento>
	 * @param consumidors
	 *            List<Consumidor>
	 */
	public CensoMonitor(String mocodigo, String monombre, String mocoem,
			String mousu, String moclave, Date mofecbaja, String moadmin,
			String moprimera, Organismo organismo, List<Consulta> consultas,
			List<Establecimiento> establecimientos, List<Consumidor> consumidors) {

		this.mocodigo = mocodigo;
		this.organismo = organismo;
		this.monombre = monombre;
		this.mocoem = mocoem;
		this.mousu = mousu;
		this.moclave = moclave;
		this.mofecbaja = mofecbaja;
		this.moadmin = moadmin;
		this.moprimera = moprimera;
		this.consultas = consultas;
		this.establecimientos = establecimientos;
		this.consumidors = consumidors;
	}

	/**
	 * Method 'getMocodigo'.
	 * 
	 * @return String
	 */

	public String getMocodigo() {
		return this.mocodigo;
	}

	/**
	 * Method 'setMocodigo'.
	 * 
	 * @param mocodigo
	 *            String
	 * @return
	 */

	public void setMocodigo(String mocodigo) {
		this.mocodigo = mocodigo;
	}

	/**
	 * Method 'getOrganismo'.
	 * 
	 * @return Organismo
	 */
	@JsonIgnore
	public Organismo getOrganismo() {
		return this.organismo;
	}

	/**
	 * Method 'setOrganismo'.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return
	 */

	public void setOrganismo(Organismo organismo) {
		this.organismo = organismo;
	}

	/**
	 * Method 'getMonombre'.
	 * 
	 * @return String
	 */

	public String getMonombre() {
		return this.monombre;
	}

	/**
	 * Method 'setMonombre'.
	 * 
	 * @param monombre
	 *            String
	 * @return
	 */

	public void setMonombre(String monombre) {
		this.monombre = monombre;
	}

	/**
	 * Method 'getMocoem'.
	 * 
	 * @return String
	 */

	public String getMocoem() {
		return this.mocoem;
	}

	/**
	 * Method 'setMocoem'.
	 * 
	 * @param mocoem
	 *            String
	 * @return
	 */

	public void setMocoem(String mocoem) {
		this.mocoem = mocoem;
	}

	/**
	 * Method 'getMousu'.
	 * 
	 * @return String
	 */

	public String getMousu() {
		return this.mousu;
	}

	/**
	 * Method 'setMousu'.
	 * 
	 * @param mousu
	 *            String
	 * @return
	 */

	public void setMousu(String mousu) {
		this.mousu = mousu;
	}

	/**
	 * Method 'getMoclave'.
	 * 
	 * @return String
	 */

	public String getMoclave() {
		return this.moclave;
	}

	/**
	 * Method 'setMoclave'.
	 * 
	 * @param moclave
	 *            String
	 * @return
	 */

	public void setMoclave(String moclave) {
		this.moclave = moclave;
	}

	/**
	 * Method 'getMofecbaja'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getMofecbaja() {
		return this.mofecbaja;
	}

	/**
	 * Method 'setMofecbaja'.
	 * 
	 * @param mofecbaja
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setMofecbaja(Date mofecbaja) {
		this.mofecbaja = mofecbaja;
	}

	/**
	 * Method 'getMoadmin'.
	 * 
	 * @return String
	 */

	public String getMoadmin() {
		return this.moadmin;
	}

	/**
	 * Method 'setMoadmin'.
	 * 
	 * @param moadmin
	 *            String
	 * @return
	 */

	public void setMoadmin(String moadmin) {
		this.moadmin = moadmin;
	}

	/**
	 * Method 'getMoprimera'.
	 * 
	 * @return String
	 */

	public String getMoprimera() {
		return this.moprimera;
	}

	/**
	 * Method 'setMoprimera'.
	 * 
	 * @param moprimera
	 *            String
	 * @return
	 */

	public void setMoprimera(String moprimera) {
		this.moprimera = moprimera;
	}

	/**
	 * Method 'getConsultas'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Consulta> getConsultas() {
		return this.consultas;
	}

	/**
	 * Method 'setConsultas'.
	 * 
	 * @param consultas
	 *            List
	 * @return
	 */
	public void setConsultas(List<Consulta> consultas) {
		this.consultas = consultas;
	}

	/**
	 * Method 'getEstablecimientos'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Establecimiento> getEstablecimientos() {
		return this.establecimientos;
	}

	/**
	 * Method 'setEstablecimientos'.
	 * 
	 * @param establecimientos
	 *            List
	 * @return
	 */
	public void setEstablecimientos(List<Establecimiento> establecimientos) {
		this.establecimientos = establecimientos;
	}

	/**
	 * Method 'getConsumidors'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Consumidor> getConsumidors() {
		return this.consumidors;
	}

	/**
	 * Method 'setConsumidors'.
	 * 
	 * @param consumidors
	 *            List
	 * @return
	 */
	public void setConsumidors(List<Consumidor> consumidors) {
		this.consumidors = consumidors;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ mocodigo: ").append(this.mocodigo).append(" ]");
		result.append(", [ monombre: ").append(this.monombre).append(" ]");
		result.append(", [ mocoem: ").append(this.mocoem).append(" ]");
		result.append(", [ mousu: ").append(this.mousu).append(" ]");
		result.append(", [ moclave: ").append(this.moclave).append(" ]");
		result.append(", [ mofecbaja: ").append(this.mofecbaja).append(" ]");
		result.append(", [ moadmin: ").append(this.moadmin).append(" ]");
		result.append(", [ moprimera: ").append(this.moprimera).append(" ]");
		result.append("}");
		return result.toString();
	}

}
