package com.ejie.y41a.model;

import java.math.BigDecimal;
import java.util.Date;

import javax.validation.constraints.NotNull;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

import com.ejie.y41a.control.Y41aJsonDateDeserializer;
import com.ejie.y41a.control.Y41aJsonDateSerializer;

/**
 * * ActuacionDetalle generated by UDA, 22-mar-2012 16:48:03.
 * 
 *  
 */

public class ActaActuacionAlta implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// Campaña
	private String tipo;
	private String codigo;
	private String descripcion;

	// Visita
	private String accodigo;
	private String accoor;
	@NotEmpty(message = "required.numeroOrdenActa")
	@Length(max = 12, message = "length.numOrdenActa")
	private String acnror;
	private BigDecimal acnran;
	@NotNull(message = "required.fechaVisita")
	private Date acfele;
	private Date acfere;
	private String accoinun;
	private String accoindo;

	// Tipo documento acta
	@NotEmpty(message = "required.tipoDocumento")
	private String tdcodigo;
	private String tdnombre;

	// Compareciente Visita
	private String acnoco;
	private String acape1co;
	private String acape2co;
	private String acdnico;
	private String accoco;
	private String acdirco;
	private String accoloco;
	private String acnrcpco;
	private String acnrtfco;
	private String acnoraPaisId;
	private String acnoraPaisNombre;
	private String acnoraProvinciaId;
	private String acnombreProvincia;
	private String acnoraMunicipioId;
	private String acnombreMunicipio;
	private String acnoraLocalidadId;
	private String acnombreLocalidad;
	private String acnoraCalleId;
	private String acnombreCalle;
	private String acnoraCpId;
	private String acnombreCp;
	private String acnoraPortalId;
	private String acnombrePortal;
	private String acnombrePiso;
	private String acdireccion_nocapv;
	private String dirAntiguaCompletaCompareciente;

	// Establecimiento Visita
	@NotEmpty(message = "required.establecimientovisitado")
	private String escodigoVisita;
	private String esnombreVisita;
	private String esnifVisita;
	private String esnocoVisita;
	private String esnodirVisita;
	private String escoloVisita;
	private String esnrcopoVisita;
	private String esnrtelVisita;
	private String esnrfaxVisita;
	private String escopaVisita;
	private String esinadarVisita;
	private Date esfeadarVisita;
	private String escoemVisita;
	private String esnrtel2Visita;
	private Date esfebaVisita;
	private String esnoloVisita;
	private String escomapvVisita;
	private String escocaVisita;
	private String esnomuVisita;
	private String esteurlVisita;
	private String esnoraPaisIdVisita;
	private String esnoraPaisNombreVisita;
	private String provinciaIdVisita;
	private String esnombreProvinciaVisita;
	private String municipioIdVisita;
	private String esnombreMunicipioVisita;
	private String localidadIdVisita;
	private String esnombreLocalidadVisita;
	private String calleIdVisita;
	private String calleId_labelVisita;
	private String cpIdVisita;
	private String esnombreCpVisita;
	private String portalIdVisita;
	private String esnombrePortalVisita;
	private String esnombrePisoVisita;
	private String esdireccion_nocapvVisita;
	private String eacodigoVisita;
	private String avcodigoVisita;
	private String avnombreVisita;
	private String avnombreeVisita;
	private String secodigoVisita;
	private String senombreVisita;
	private String senombreeVisita;
	private String eainprseVisita;
	private String direccionAntiguaCompletaVisita;

	// Actuacion
	private String atcodigo;
	private BigDecimal atnror;
	private String atcotp;
	private String atteinfo;

	// Tipo de actuacion
	@NotEmpty(message = "required.tipoactuacion")
	private String ttacodigo;
	private String ttanombre;

	// Motivo de actuacion
	@NotEmpty(message = "required.motivoactuacion")
	private String tmacodigo;
	private String tmanombre;

	// Establecimiento Actuacion
	@NotEmpty(message = "required.estresponsable")
	private String escodigoActuacion;
	private String esnombreActuacion;
	private String esnifActuacion;
	private String esnocoActuacion;
	private String esnodirActuacion;
	private String escoloActuacion;
	private String esnrcopoActuacion;
	private String esnrtelActuacion;
	private String esnrfaxActuacion;
	private String escopaActuacion;
	private String esinadarActuacion;
	private Date esfeadarActuacion;
	private String escoemActuacion;
	private String esnrtel2Actuacion;
	private Date esfebaActuacion;
	private String esnoloActuacion;
	private String escomapvActuacion;
	private String escocaActuacion;
	private String esnomuActuacion;
	private String esteurlActuacion;
	private String esnoraPaisIdActuacion;
	private String esnoraPaisNombreActuacion;
	private String provinciaIdActuacion;
	private String esnombreProvinciaActuacion;
	private String municipioIdActuacion;
	private String esnombreMunicipioActuacion;
	private String localidadIdActuacion;
	private String esnombreLocalidadActuacion;
	private String calleIdActuacion;
	private String calleId_labelActuacion;
	private String cpIdActuacion;
	private String esnombreCpActuacion;
	private String portalIdActuacion;
	private String esnombrePortalActuacion;
	private String esnombrePisoActuacion;
	private String esdireccion_nocapvActuacion;
	private String eacodigoActuacion;
	private String avcodigoActuacion;
	private String avnombreActuacion;
	private String avnombreeActuacion;
	private String secodigoActuacion;
	private String senombreActuacion;
	private String senombreeActuacion;
	private String eainprseActuacion;
	private String direccionAntiguaCompletaActuacion;

	// Producto Actuacion
	@NotEmpty(message = "required.productoactuacion")
	private String pscodigoActuacion;
	private String psnombreActuacion;
	private String psnombreeActuacion;
	private String atnoprse;
	private String atnomaps;
	private String atnomops;
	private String atnrlops;
	private Date atfedumi;

	// CampahnaRecib
	private String s4codigo;
	// AlertaRecib
	private String s5codigo;
	// DenunciaRecib
	private String s6codigo;

	// Producto encontrado
	private String atinprse;
	private BigDecimal atcaunep;

	public ActaActuacionAlta() {

	}

	/**
	 * @param tipo
	 * @param codigo
	 * @param descripcion
	 * @param accodigo
	 * @param accoor
	 * @param acnror
	 * @param acnran
	 * @param acfele
	 * @param acfere
	 * @param accoinun
	 * @param accoindo
	 * @param tdcodigo
	 * @param tdnombre
	 * @param acnoco
	 * @param acape1co
	 * @param acape2co
	 * @param acdnico
	 * @param accoco
	 * @param acdirco
	 * @param accoloco
	 * @param acnrcpco
	 * @param acnrtfco
	 * @param acnoraPaisId
	 * @param acnoraPaisNombre
	 * @param acnoraProvinciaId
	 * @param acnombreProvincia
	 * @param acnoraMunicipioId
	 * @param acnombreMunicipio
	 * @param acnoraLocalidadId
	 * @param acnombreLocalidad
	 * @param acnoraCalleId
	 * @param acnombreCalle
	 * @param acnoraCpId
	 * @param acnombreCp
	 * @param acnoraPortalId
	 * @param acnombrePortal
	 * @param acnombrePiso
	 * @param acdireccion_nocapv
	 * @param dirAntiguaCompletaCompareciente
	 * @param escodigoVisita
	 * @param esnombreVisita
	 * @param esnifVisita
	 * @param esnocoVisita
	 * @param esnodirVisita
	 * @param escoloVisita
	 * @param esnrcopoVisita
	 * @param esnrtelVisita
	 * @param esnrfaxVisita
	 * @param escopaVisita
	 * @param esinadarVisita
	 * @param esfeadarVisita
	 * @param escoemVisita
	 * @param esnrtel2Visita
	 * @param esfebaVisita
	 * @param esnoloVisita
	 * @param escomapvVisita
	 * @param escocaVisita
	 * @param esnomuVisita
	 * @param esteurlVisita
	 * @param esnoraPaisIdVisita
	 * @param esnoraPaisNombreVisita
	 * @param provinciaIdVisita
	 * @param esnombreProvinciaVisita
	 * @param municipioIdVisita
	 * @param esnombreMunicipioVisita
	 * @param localidadIdVisita
	 * @param esnombreLocalidadVisita
	 * @param calleIdVisita
	 * @param calleId_labelVisita
	 * @param cpIdVisita
	 * @param esnombreCpVisita
	 * @param portalIdVisita
	 * @param esnombrePortalVisita
	 * @param esnombrePisoVisita
	 * @param esdireccion_nocapvVisita
	 * @param eacodigoVisita
	 * @param avcodigoVisita
	 * @param avnombreVisita
	 * @param avnombreeVisita
	 * @param secodigoVisita
	 * @param senombreVisita
	 * @param senombreeVisita
	 * @param eainprseVisita
	 * @param direccionAntiguaCompletaVisita
	 * @param atcodigo
	 * @param atnror
	 * @param atcotp
	 * @param atteinfo
	 * @param ttacodigo
	 * @param ttanombre
	 * @param tmacodigo
	 * @param tmanombre
	 * @param escodigoActuacion
	 * @param esnombreActuacion
	 * @param esnifActuacion
	 * @param esnocoActuacion
	 * @param esnodirActuacion
	 * @param escoloActuacion
	 * @param esnrcopoActuacion
	 * @param esnrtelActuacion
	 * @param esnrfaxActuacion
	 * @param escopaActuacion
	 * @param esinadarActuacion
	 * @param esfeadarActuacion
	 * @param escoemActuacion
	 * @param esnrtel2Actuacion
	 * @param esfebaActuacion
	 * @param esnoloActuacion
	 * @param escomapvActuacion
	 * @param escocaActuacion
	 * @param esnomuActuacion
	 * @param esteurlActuacion
	 * @param esnoraPaisIdActuacion
	 * @param esnoraPaisNombreActuacion
	 * @param provinciaIdActuacion
	 * @param esnombreProvinciaActuacion
	 * @param municipioIdActuacion
	 * @param esnombreMunicipioActuacion
	 * @param localidadIdActuacion
	 * @param esnombreLocalidadActuacion
	 * @param calleIdActuacion
	 * @param calleId_labelActuacion
	 * @param cpIdActuacion
	 * @param esnombreCpActuacion
	 * @param portalIdActuacion
	 * @param esnombrePortalActuacion
	 * @param esnombrePisoActuacion
	 * @param esdireccion_nocapvActuacion
	 * @param eacodigoActuacion
	 * @param avcodigoActuacion
	 * @param avnombreActuacion
	 * @param avnombreeActuacion
	 * @param secodigoActuacion
	 * @param senombreActuacion
	 * @param senombreeActuacion
	 * @param eainprseActuacion
	 * @param direccionAntiguaCompletaActuacion
	 * @param pscodigoActuacion
	 * @param psnombreActuacion
	 * @param psnombreeActuacion
	 * @param atnoprse
	 * @param atnomaps
	 * @param atnomops
	 * @param atnrlops
	 * @param atfedumi
	 * @param s4codigo
	 * @param s5codigo
	 * @param s6codigo
	 * @param atinprse
	 * @param atcaunep
	 */
	public ActaActuacionAlta(String tipo, String codigo, String descripcion,
			String accodigo, String accoor, String acnror, BigDecimal acnran,
			Date acfele, Date acfere, String accoinun, String accoindo,
			String tdcodigo, String tdnombre, String acnoco, String acape1co,
			String acape2co, String acdnico, String accoco, String acdirco,
			String accoloco, String acnrcpco, String acnrtfco,
			String acnoraPaisId, String acnoraPaisNombre,
			String acnoraProvinciaId, String acnombreProvincia,
			String acnoraMunicipioId, String acnombreMunicipio,
			String acnoraLocalidadId, String acnombreLocalidad,
			String acnoraCalleId, String acnombreCalle, String acnoraCpId,
			String acnombreCp, String acnoraPortalId, String acnombrePortal,
			String acnombrePiso, String acdireccion_nocapv,
			String dirAntiguaCompletaCompareciente, String escodigoVisita,
			String esnombreVisita, String esnifVisita, String esnocoVisita,
			String esnodirVisita, String escoloVisita, String esnrcopoVisita,
			String esnrtelVisita, String esnrfaxVisita, String escopaVisita,
			String esinadarVisita, Date esfeadarVisita, String escoemVisita,
			String esnrtel2Visita, Date esfebaVisita, String esnoloVisita,
			String escomapvVisita, String escocaVisita, String esnomuVisita,
			String esteurlVisita, String esnoraPaisIdVisita,
			String esnoraPaisNombreVisita, String provinciaIdVisita,
			String esnombreProvinciaVisita, String municipioIdVisita,
			String esnombreMunicipioVisita, String localidadIdVisita,
			String esnombreLocalidadVisita, String calleIdVisita,
			String calleId_labelVisita, String cpIdVisita,
			String esnombreCpVisita, String portalIdVisita,
			String esnombrePortalVisita, String esnombrePisoVisita,
			String esdireccion_nocapvVisita, String eacodigoVisita,
			String avcodigoVisita, String avnombreVisita,
			String avnombreeVisita, String secodigoVisita,
			String senombreVisita, String senombreeVisita,
			String eainprseVisita, String direccionAntiguaCompletaVisita,
			String atcodigo, BigDecimal atnror, String atcotp, String atteinfo,
			String ttacodigo, String ttanombre, String tmacodigo,
			String tmanombre, String escodigoActuacion,
			String esnombreActuacion, String esnifActuacion,
			String esnocoActuacion, String esnodirActuacion,
			String escoloActuacion, String esnrcopoActuacion,
			String esnrtelActuacion, String esnrfaxActuacion,
			String escopaActuacion, String esinadarActuacion,
			Date esfeadarActuacion, String escoemActuacion,
			String esnrtel2Actuacion, Date esfebaActuacion,
			String esnoloActuacion, String escomapvActuacion,
			String escocaActuacion, String esnomuActuacion,
			String esteurlActuacion, String esnoraPaisIdActuacion,
			String esnoraPaisNombreActuacion, String provinciaIdActuacion,
			String esnombreProvinciaActuacion, String municipioIdActuacion,
			String esnombreMunicipioActuacion, String localidadIdActuacion,
			String esnombreLocalidadActuacion, String calleIdActuacion,
			String calleId_labelActuacion, String cpIdActuacion,
			String esnombreCpActuacion, String portalIdActuacion,
			String esnombrePortalActuacion, String esnombrePisoActuacion,
			String esdireccion_nocapvActuacion, String eacodigoActuacion,
			String avcodigoActuacion, String avnombreActuacion,
			String avnombreeActuacion, String secodigoActuacion,
			String senombreActuacion, String senombreeActuacion,
			String eainprseActuacion, String direccionAntiguaCompletaActuacion,
			String pscodigoActuacion, String psnombreActuacion,
			String psnombreeActuacion, String atnoprse, String atnomaps,
			String atnomops, String atnrlops, Date atfedumi, String s4codigo,
			String s5codigo, String s6codigo, String atinprse,
			BigDecimal atcaunep) {
		this.tipo = tipo;
		this.codigo = codigo;
		this.descripcion = descripcion;
		this.accodigo = accodigo;
		this.accoor = accoor;
		this.acnror = acnror;
		this.acnran = acnran;
		this.acfele = acfele;
		this.acfere = acfere;
		this.accoinun = accoinun;
		this.accoindo = accoindo;
		this.tdcodigo = tdcodigo;
		this.tdnombre = tdnombre;
		this.acnoco = acnoco;
		this.acape1co = acape1co;
		this.acape2co = acape2co;
		this.acdnico = acdnico;
		this.accoco = accoco;
		this.acdirco = acdirco;
		this.accoloco = accoloco;
		this.acnrcpco = acnrcpco;
		this.acnrtfco = acnrtfco;
		this.acnoraPaisId = acnoraPaisId;
		this.acnoraPaisNombre = acnoraPaisNombre;
		this.acnoraProvinciaId = acnoraProvinciaId;
		this.acnombreProvincia = acnombreProvincia;
		this.acnoraMunicipioId = acnoraMunicipioId;
		this.acnombreMunicipio = acnombreMunicipio;
		this.acnoraLocalidadId = acnoraLocalidadId;
		this.acnombreLocalidad = acnombreLocalidad;
		this.acnoraCalleId = acnoraCalleId;
		this.acnombreCalle = acnombreCalle;
		this.acnoraCpId = acnoraCpId;
		this.acnombreCp = acnombreCp;
		this.acnoraPortalId = acnoraPortalId;
		this.acnombrePortal = acnombrePortal;
		this.acnombrePiso = acnombrePiso;
		this.acdireccion_nocapv = acdireccion_nocapv;
		this.dirAntiguaCompletaCompareciente = dirAntiguaCompletaCompareciente;
		this.escodigoVisita = escodigoVisita;
		this.esnombreVisita = esnombreVisita;
		this.esnifVisita = esnifVisita;
		this.esnocoVisita = esnocoVisita;
		this.esnodirVisita = esnodirVisita;
		this.escoloVisita = escoloVisita;
		this.esnrcopoVisita = esnrcopoVisita;
		this.esnrtelVisita = esnrtelVisita;
		this.esnrfaxVisita = esnrfaxVisita;
		this.escopaVisita = escopaVisita;
		this.esinadarVisita = esinadarVisita;
		this.esfeadarVisita = esfeadarVisita;
		this.escoemVisita = escoemVisita;
		this.esnrtel2Visita = esnrtel2Visita;
		this.esfebaVisita = esfebaVisita;
		this.esnoloVisita = esnoloVisita;
		this.escomapvVisita = escomapvVisita;
		this.escocaVisita = escocaVisita;
		this.esnomuVisita = esnomuVisita;
		this.esteurlVisita = esteurlVisita;
		this.esnoraPaisIdVisita = esnoraPaisIdVisita;
		this.esnoraPaisNombreVisita = esnoraPaisNombreVisita;
		this.provinciaIdVisita = provinciaIdVisita;
		this.esnombreProvinciaVisita = esnombreProvinciaVisita;
		this.municipioIdVisita = municipioIdVisita;
		this.esnombreMunicipioVisita = esnombreMunicipioVisita;
		this.localidadIdVisita = localidadIdVisita;
		this.esnombreLocalidadVisita = esnombreLocalidadVisita;
		this.calleIdVisita = calleIdVisita;
		this.calleId_labelVisita = calleId_labelVisita;
		this.cpIdVisita = cpIdVisita;
		this.esnombreCpVisita = esnombreCpVisita;
		this.portalIdVisita = portalIdVisita;
		this.esnombrePortalVisita = esnombrePortalVisita;
		this.esnombrePisoVisita = esnombrePisoVisita;
		this.esdireccion_nocapvVisita = esdireccion_nocapvVisita;
		this.eacodigoVisita = eacodigoVisita;
		this.avcodigoVisita = avcodigoVisita;
		this.avnombreVisita = avnombreVisita;
		this.avnombreeVisita = avnombreeVisita;
		this.secodigoVisita = secodigoVisita;
		this.senombreVisita = senombreVisita;
		this.senombreeVisita = senombreeVisita;
		this.eainprseVisita = eainprseVisita;
		this.direccionAntiguaCompletaVisita = direccionAntiguaCompletaVisita;
		this.atcodigo = atcodigo;
		this.atnror = atnror;
		this.atcotp = atcotp;
		this.atteinfo = atteinfo;
		this.ttacodigo = ttacodigo;
		this.ttanombre = ttanombre;
		this.tmacodigo = tmacodigo;
		this.tmanombre = tmanombre;
		this.escodigoActuacion = escodigoActuacion;
		this.esnombreActuacion = esnombreActuacion;
		this.esnifActuacion = esnifActuacion;
		this.esnocoActuacion = esnocoActuacion;
		this.esnodirActuacion = esnodirActuacion;
		this.escoloActuacion = escoloActuacion;
		this.esnrcopoActuacion = esnrcopoActuacion;
		this.esnrtelActuacion = esnrtelActuacion;
		this.esnrfaxActuacion = esnrfaxActuacion;
		this.escopaActuacion = escopaActuacion;
		this.esinadarActuacion = esinadarActuacion;
		this.esfeadarActuacion = esfeadarActuacion;
		this.escoemActuacion = escoemActuacion;
		this.esnrtel2Actuacion = esnrtel2Actuacion;
		this.esfebaActuacion = esfebaActuacion;
		this.esnoloActuacion = esnoloActuacion;
		this.escomapvActuacion = escomapvActuacion;
		this.escocaActuacion = escocaActuacion;
		this.esnomuActuacion = esnomuActuacion;
		this.esteurlActuacion = esteurlActuacion;
		this.esnoraPaisIdActuacion = esnoraPaisIdActuacion;
		this.esnoraPaisNombreActuacion = esnoraPaisNombreActuacion;
		this.provinciaIdActuacion = provinciaIdActuacion;
		this.esnombreProvinciaActuacion = esnombreProvinciaActuacion;
		this.municipioIdActuacion = municipioIdActuacion;
		this.esnombreMunicipioActuacion = esnombreMunicipioActuacion;
		this.localidadIdActuacion = localidadIdActuacion;
		this.esnombreLocalidadActuacion = esnombreLocalidadActuacion;
		this.calleIdActuacion = calleIdActuacion;
		this.calleId_labelActuacion = calleId_labelActuacion;
		this.cpIdActuacion = cpIdActuacion;
		this.esnombreCpActuacion = esnombreCpActuacion;
		this.portalIdActuacion = portalIdActuacion;
		this.esnombrePortalActuacion = esnombrePortalActuacion;
		this.esnombrePisoActuacion = esnombrePisoActuacion;
		this.esdireccion_nocapvActuacion = esdireccion_nocapvActuacion;
		this.eacodigoActuacion = eacodigoActuacion;
		this.avcodigoActuacion = avcodigoActuacion;
		this.avnombreActuacion = avnombreActuacion;
		this.avnombreeActuacion = avnombreeActuacion;
		this.secodigoActuacion = secodigoActuacion;
		this.senombreActuacion = senombreActuacion;
		this.senombreeActuacion = senombreeActuacion;
		this.eainprseActuacion = eainprseActuacion;
		this.direccionAntiguaCompletaActuacion = direccionAntiguaCompletaActuacion;
		this.pscodigoActuacion = pscodigoActuacion;
		this.psnombreActuacion = psnombreActuacion;
		this.psnombreeActuacion = psnombreeActuacion;
		this.atnoprse = atnoprse;
		this.atnomaps = atnomaps;
		this.atnomops = atnomops;
		this.atnrlops = atnrlops;
		this.atfedumi = atfedumi;
		this.s4codigo = s4codigo;
		this.s5codigo = s5codigo;
		this.s6codigo = s6codigo;
		this.atinprse = atinprse;
		this.atcaunep = atcaunep;
	}

	/**
	 * @return the tipo
	 */
	public String getTipo() {
		return tipo;
	}

	/**
	 * @param tipo
	 *            the tipo to set
	 */
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}

	/**
	 * @return the codigo
	 */
	public String getCodigo() {
		return codigo;
	}

	/**
	 * @param codigo
	 *            the codigo to set
	 */
	public void setCodigo(String codigo) {
		this.codigo = codigo;
	}

	/**
	 * @return the descripcion
	 */
	public String getDescripcion() {
		return descripcion;
	}

	/**
	 * @param descripcion
	 *            the descripcion to set
	 */
	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}

	/**
	 * @return the accodigo
	 */
	public String getAccodigo() {
		return accodigo;
	}

	/**
	 * @param accodigo
	 *            the accodigo to set
	 */
	public void setAccodigo(String accodigo) {
		this.accodigo = accodigo;
	}

	/**
	 * @return the accoor
	 */
	public String getAccoor() {
		return accoor;
	}

	/**
	 * @param accoor
	 *            the accoor to set
	 */
	public void setAccoor(String accoor) {
		this.accoor = accoor;
	}

	/**
	 * @return the acnror
	 */
	public String getAcnror() {
		return acnror;
	}

	/**
	 * @param acnror
	 *            the acnror to set
	 */
	public void setAcnror(String acnror) {
		this.acnror = acnror;
	}

	/**
	 * @return the acnran
	 */
	public BigDecimal getAcnran() {
		return acnran;
	}

	/**
	 * @param acnran
	 *            the acnran to set
	 */
	public void setAcnran(BigDecimal acnran) {
		this.acnran = acnran;
	}

	/**
	 * @return the acfele
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getAcfele() {
		return acfele;
	}

	/**
	 * @param acfele
	 *            the acfele to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setAcfele(Date acfele) {
		this.acfele = acfele;
	}

	/**
	 * @return the acfere
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getAcfere() {
		return acfere;
	}

	/**
	 * @param acfere
	 *            the acfere to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setAcfere(Date acfere) {
		this.acfere = acfere;
	}

	/**
	 * @return the accoinun
	 */
	public String getAccoinun() {
		return accoinun;
	}

	/**
	 * @param accoinun
	 *            the accoinun to set
	 */
	public void setAccoinun(String accoinun) {
		this.accoinun = accoinun;
	}

	/**
	 * @return the accoindo
	 */
	public String getAccoindo() {
		return accoindo;
	}

	/**
	 * @param accoindo
	 *            the accoindo to set
	 */
	public void setAccoindo(String accoindo) {
		this.accoindo = accoindo;
	}

	/**
	 * @return the tdcodigo
	 */
	public String getTdcodigo() {
		return tdcodigo;
	}

	/**
	 * @param tdcodigo
	 *            the tdcodigo to set
	 */
	public void setTdcodigo(String tdcodigo) {
		this.tdcodigo = tdcodigo;
	}

	/**
	 * @return the tdnombre
	 */
	public String getTdnombre() {
		return tdnombre;
	}

	/**
	 * @param tdnombre
	 *            the tdnombre to set
	 */
	public void setTdnombre(String tdnombre) {
		this.tdnombre = tdnombre;
	}

	/**
	 * @return the acnoco
	 */
	public String getAcnoco() {
		return acnoco;
	}

	/**
	 * @param acnoco
	 *            the acnoco to set
	 */
	public void setAcnoco(String acnoco) {
		this.acnoco = acnoco;
	}

	/**
	 * @return the acape1co
	 */
	public String getAcape1co() {
		return acape1co;
	}

	/**
	 * @param acape1co
	 *            the acape1co to set
	 */
	public void setAcape1co(String acape1co) {
		this.acape1co = acape1co;
	}

	/**
	 * @return the acape2co
	 */
	public String getAcape2co() {
		return acape2co;
	}

	/**
	 * @param acape2co
	 *            the acape2co to set
	 */
	public void setAcape2co(String acape2co) {
		this.acape2co = acape2co;
	}

	/**
	 * @return the acdnico
	 */
	public String getAcdnico() {
		return acdnico;
	}

	/**
	 * @param acdnico
	 *            the acdnico to set
	 */
	public void setAcdnico(String acdnico) {
		this.acdnico = acdnico;
	}

	/**
	 * @return the accoco
	 */
	public String getAccoco() {
		return accoco;
	}

	/**
	 * @param accoco
	 *            the accoco to set
	 */
	public void setAccoco(String accoco) {
		this.accoco = accoco;
	}

	/**
	 * @return the acdirco
	 */
	public String getAcdirco() {
		return acdirco;
	}

	/**
	 * @param acdirco
	 *            the acdirco to set
	 */
	public void setAcdirco(String acdirco) {
		this.acdirco = acdirco;
	}

	/**
	 * @return the accoloco
	 */
	public String getAccoloco() {
		return accoloco;
	}

	/**
	 * @param accoloco
	 *            the accoloco to set
	 */
	public void setAccoloco(String accoloco) {
		this.accoloco = accoloco;
	}

	/**
	 * @return the acnrcpco
	 */
	public String getAcnrcpco() {
		return acnrcpco;
	}

	/**
	 * @param acnrcpco
	 *            the acnrcpco to set
	 */
	public void setAcnrcpco(String acnrcpco) {
		this.acnrcpco = acnrcpco;
	}

	/**
	 * @return the acnrtfco
	 */
	public String getAcnrtfco() {
		return acnrtfco;
	}

	/**
	 * @param acnrtfco
	 *            the acnrtfco to set
	 */
	public void setAcnrtfco(String acnrtfco) {
		this.acnrtfco = acnrtfco;
	}

	/**
	 * @return the acnoraPaisId
	 */
	public String getAcnoraPaisId() {
		return acnoraPaisId;
	}

	/**
	 * @param acnoraPaisId
	 *            the acnoraPaisId to set
	 */
	public void setAcnoraPaisId(String acnoraPaisId) {
		this.acnoraPaisId = acnoraPaisId;
	}

	/**
	 * @return the acnoraPaisNombre
	 */
	public String getAcnoraPaisNombre() {
		return acnoraPaisNombre;
	}

	/**
	 * @param acnoraPaisNombre
	 *            the acnoraPaisNombre to set
	 */
	public void setAcnoraPaisNombre(String acnoraPaisNombre) {
		this.acnoraPaisNombre = acnoraPaisNombre;
	}

	/**
	 * @return the acnoraProvinciaId
	 */
	public String getAcnoraProvinciaId() {
		return acnoraProvinciaId;
	}

	/**
	 * @param acnoraProvinciaId
	 *            the acnoraProvinciaId to set
	 */
	public void setAcnoraProvinciaId(String acnoraProvinciaId) {
		this.acnoraProvinciaId = acnoraProvinciaId;
	}

	/**
	 * @return the acnombreProvincia
	 */
	public String getAcnombreProvincia() {
		return acnombreProvincia;
	}

	/**
	 * @param acnombreProvincia
	 *            the acnombreProvincia to set
	 */
	public void setAcnombreProvincia(String acnombreProvincia) {
		this.acnombreProvincia = acnombreProvincia;
	}

	/**
	 * @return the acnoraMunicipioId
	 */
	public String getAcnoraMunicipioId() {
		return acnoraMunicipioId;
	}

	/**
	 * @param acnoraMunicipioId
	 *            the acnoraMunicipioId to set
	 */
	public void setAcnoraMunicipioId(String acnoraMunicipioId) {
		this.acnoraMunicipioId = acnoraMunicipioId;
	}

	/**
	 * @return the acnombreMunicipio
	 */
	public String getAcnombreMunicipio() {
		return acnombreMunicipio;
	}

	/**
	 * @param acnombreMunicipio
	 *            the acnombreMunicipio to set
	 */
	public void setAcnombreMunicipio(String acnombreMunicipio) {
		this.acnombreMunicipio = acnombreMunicipio;
	}

	/**
	 * @return the acnoraLocalidadId
	 */
	public String getAcnoraLocalidadId() {
		return acnoraLocalidadId;
	}

	/**
	 * @param acnoraLocalidadId
	 *            the acnoraLocalidadId to set
	 */
	public void setAcnoraLocalidadId(String acnoraLocalidadId) {
		this.acnoraLocalidadId = acnoraLocalidadId;
	}

	/**
	 * @return the acnombreLocalidad
	 */
	public String getAcnombreLocalidad() {
		return acnombreLocalidad;
	}

	/**
	 * @param acnombreLocalidad
	 *            the acnombreLocalidad to set
	 */
	public void setAcnombreLocalidad(String acnombreLocalidad) {
		this.acnombreLocalidad = acnombreLocalidad;
	}

	/**
	 * @return the acnoraCalleId
	 */
	public String getAcnoraCalleId() {
		return acnoraCalleId;
	}

	/**
	 * @param acnoraCalleId
	 *            the acnoraCalleId to set
	 */
	public void setAcnoraCalleId(String acnoraCalleId) {
		this.acnoraCalleId = acnoraCalleId;
	}

	/**
	 * @return the acnombreCalle
	 */
	public String getAcnombreCalle() {
		return acnombreCalle;
	}

	/**
	 * @param acnombreCalle
	 *            the acnombreCalle to set
	 */
	public void setAcnombreCalle(String acnombreCalle) {
		this.acnombreCalle = acnombreCalle;
	}

	/**
	 * @return the acnoraCpId
	 */
	public String getAcnoraCpId() {
		return acnoraCpId;
	}

	/**
	 * @param acnoraCpId
	 *            the acnoraCpId to set
	 */
	public void setAcnoraCpId(String acnoraCpId) {
		this.acnoraCpId = acnoraCpId;
	}

	/**
	 * @return the acnombreCp
	 */
	public String getAcnombreCp() {
		return acnombreCp;
	}

	/**
	 * @param acnombreCp
	 *            the acnombreCp to set
	 */
	public void setAcnombreCp(String acnombreCp) {
		this.acnombreCp = acnombreCp;
	}

	/**
	 * @return the acnoraPortalId
	 */
	public String getAcnoraPortalId() {
		return acnoraPortalId;
	}

	/**
	 * @param acnoraPortalId
	 *            the acnoraPortalId to set
	 */
	public void setAcnoraPortalId(String acnoraPortalId) {
		this.acnoraPortalId = acnoraPortalId;
	}

	/**
	 * @return the acnombrePortal
	 */
	public String getAcnombrePortal() {
		return acnombrePortal;
	}

	/**
	 * @param acnombrePortal
	 *            the acnombrePortal to set
	 */
	public void setAcnombrePortal(String acnombrePortal) {
		this.acnombrePortal = acnombrePortal;
	}

	/**
	 * @return the acnombrePiso
	 */
	public String getAcnombrePiso() {
		return acnombrePiso;
	}

	/**
	 * @param acnombrePiso
	 *            the acnombrePiso to set
	 */
	public void setAcnombrePiso(String acnombrePiso) {
		this.acnombrePiso = acnombrePiso;
	}

	/**
	 * @return the dirAntiguaCompletaCompareciente
	 */
	public String getDirAntiguaCompletaCompareciente() {
		return dirAntiguaCompletaCompareciente;
	}

	/**
	 * @param dirAntiguaCompletaCompareciente
	 *            the dirAntiguaCompletaCompareciente to set
	 */
	public void setDirAntiguaCompletaCompareciente(
			String dirAntiguaCompletaCompareciente) {
		this.dirAntiguaCompletaCompareciente = dirAntiguaCompletaCompareciente;
	}

	/**
	 * @return the escodigoVisita
	 */
	public String getEscodigoVisita() {
		return escodigoVisita;
	}

	/**
	 * @param escodigoVisita
	 *            the escodigoVisita to set
	 */
	public void setEscodigoVisita(String escodigoVisita) {
		this.escodigoVisita = escodigoVisita;
	}

	/**
	 * @return the esnombreVisita
	 */
	public String getEsnombreVisita() {
		return esnombreVisita;
	}

	/**
	 * @param esnombreVisita
	 *            the esnombreVisita to set
	 */
	public void setEsnombreVisita(String esnombreVisita) {
		this.esnombreVisita = esnombreVisita;
	}

	/**
	 * @return the esnifVisita
	 */
	public String getEsnifVisita() {
		return esnifVisita;
	}

	/**
	 * @param esnifVisita
	 *            the esnifVisita to set
	 */
	public void setEsnifVisita(String esnifVisita) {
		this.esnifVisita = esnifVisita;
	}

	/**
	 * @return the esnocoVisita
	 */
	public String getEsnocoVisita() {
		return esnocoVisita;
	}

	/**
	 * @param esnocoVisita
	 *            the esnocoVisita to set
	 */
	public void setEsnocoVisita(String esnocoVisita) {
		this.esnocoVisita = esnocoVisita;
	}

	/**
	 * @return the esnodirVisita
	 */
	public String getEsnodirVisita() {
		return esnodirVisita;
	}

	/**
	 * @param esnodirVisita
	 *            the esnodirVisita to set
	 */
	public void setEsnodirVisita(String esnodirVisita) {
		this.esnodirVisita = esnodirVisita;
	}

	/**
	 * @return the escoloVisita
	 */
	public String getEscoloVisita() {
		return escoloVisita;
	}

	/**
	 * @param escoloVisita
	 *            the escoloVisita to set
	 */
	public void setEscoloVisita(String escoloVisita) {
		this.escoloVisita = escoloVisita;
	}

	/**
	 * @return the esnrcopoVisita
	 */
	public String getEsnrcopoVisita() {
		return esnrcopoVisita;
	}

	/**
	 * @param esnrcopoVisita
	 *            the esnrcopoVisita to set
	 */
	public void setEsnrcopoVisita(String esnrcopoVisita) {
		this.esnrcopoVisita = esnrcopoVisita;
	}

	/**
	 * @return the esnrtelVisita
	 */
	public String getEsnrtelVisita() {
		return esnrtelVisita;
	}

	/**
	 * @param esnrtelVisita
	 *            the esnrtelVisita to set
	 */
	public void setEsnrtelVisita(String esnrtelVisita) {
		this.esnrtelVisita = esnrtelVisita;
	}

	/**
	 * @return the esnrfaxVisita
	 */
	public String getEsnrfaxVisita() {
		return esnrfaxVisita;
	}

	/**
	 * @param esnrfaxVisita
	 *            the esnrfaxVisita to set
	 */
	public void setEsnrfaxVisita(String esnrfaxVisita) {
		this.esnrfaxVisita = esnrfaxVisita;
	}

	/**
	 * @return the escopaVisita
	 */
	public String getEscopaVisita() {
		return escopaVisita;
	}

	/**
	 * @param escopaVisita
	 *            the escopaVisita to set
	 */
	public void setEscopaVisita(String escopaVisita) {
		this.escopaVisita = escopaVisita;
	}

	/**
	 * @return the esinadarVisita
	 */
	public String getEsinadarVisita() {
		return esinadarVisita;
	}

	/**
	 * @param esinadarVisita
	 *            the esinadarVisita to set
	 */
	public void setEsinadarVisita(String esinadarVisita) {
		this.esinadarVisita = esinadarVisita;
	}

	/**
	 * @return the esfeadarVisita
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getEsfeadarVisita() {
		return esfeadarVisita;
	}

	/**
	 * @param esfeadarVisita
	 *            the esfeadarVisita to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setEsfeadarVisita(Date esfeadarVisita) {
		this.esfeadarVisita = esfeadarVisita;
	}

	/**
	 * @return the escoemVisita
	 */
	public String getEscoemVisita() {
		return escoemVisita;
	}

	/**
	 * @param escoemVisita
	 *            the escoemVisita to set
	 */
	public void setEscoemVisita(String escoemVisita) {
		this.escoemVisita = escoemVisita;
	}

	/**
	 * @return the esnrtel2Visita
	 */
	public String getEsnrtel2Visita() {
		return esnrtel2Visita;
	}

	/**
	 * @param esnrtel2Visita
	 *            the esnrtel2Visita to set
	 */
	public void setEsnrtel2Visita(String esnrtel2Visita) {
		this.esnrtel2Visita = esnrtel2Visita;
	}

	/**
	 * @return the esfebaVisita
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getEsfebaVisita() {
		return esfebaVisita;
	}

	/**
	 * @param esfebaVisita
	 *            the esfebaVisita to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setEsfebaVisita(Date esfebaVisita) {
		this.esfebaVisita = esfebaVisita;
	}

	/**
	 * @return the esnoloVisita
	 */
	public String getEsnoloVisita() {
		return esnoloVisita;
	}

	/**
	 * @param esnoloVisita
	 *            the esnoloVisita to set
	 */
	public void setEsnoloVisita(String esnoloVisita) {
		this.esnoloVisita = esnoloVisita;
	}

	/**
	 * @return the escomapvVisita
	 */
	public String getEscomapvVisita() {
		return escomapvVisita;
	}

	/**
	 * @param escomapvVisita
	 *            the escomapvVisita to set
	 */
	public void setEscomapvVisita(String escomapvVisita) {
		this.escomapvVisita = escomapvVisita;
	}

	/**
	 * @return the escocaVisita
	 */
	public String getEscocaVisita() {
		return escocaVisita;
	}

	/**
	 * @param escocaVisita
	 *            the escocaVisita to set
	 */
	public void setEscocaVisita(String escocaVisita) {
		this.escocaVisita = escocaVisita;
	}

	/**
	 * @return the esnomuVisita
	 */
	public String getEsnomuVisita() {
		return esnomuVisita;
	}

	/**
	 * @param esnomuVisita
	 *            the esnomuVisita to set
	 */
	public void setEsnomuVisita(String esnomuVisita) {
		this.esnomuVisita = esnomuVisita;
	}

	/**
	 * @return the esteurlVisita
	 */
	public String getEsteurlVisita() {
		return esteurlVisita;
	}

	/**
	 * @param esteurlVisita
	 *            the esteurlVisita to set
	 */
	public void setEsteurlVisita(String esteurlVisita) {
		this.esteurlVisita = esteurlVisita;
	}

	/**
	 * @return the esnoraPaisIdVisita
	 */
	public String getEsnoraPaisIdVisita() {
		return esnoraPaisIdVisita;
	}

	/**
	 * @param esnoraPaisIdVisita
	 *            the esnoraPaisIdVisita to set
	 */
	public void setEsnoraPaisIdVisita(String esnoraPaisIdVisita) {
		this.esnoraPaisIdVisita = esnoraPaisIdVisita;
	}

	/**
	 * @return the esnoraPaisNombreVisita
	 */
	public String getEsnoraPaisNombreVisita() {
		return esnoraPaisNombreVisita;
	}

	/**
	 * @param esnoraPaisNombreVisita
	 *            the esnoraPaisNombreVisita to set
	 */
	public void setEsnoraPaisNombreVisita(String esnoraPaisNombreVisita) {
		this.esnoraPaisNombreVisita = esnoraPaisNombreVisita;
	}

	/**
	 * @return the provinciaIdVisita
	 */
	public String getProvinciaIdVisita() {
		return provinciaIdVisita;
	}

	/**
	 * @param provinciaIdVisita
	 *            the provinciaIdVisita to set
	 */
	public void setProvinciaIdVisita(String provinciaIdVisita) {
		this.provinciaIdVisita = provinciaIdVisita;
	}

	/**
	 * @return the esnombreProvinciaVisita
	 */
	public String getEsnombreProvinciaVisita() {
		return esnombreProvinciaVisita;
	}

	/**
	 * @param esnombreProvinciaVisita
	 *            the esnombreProvinciaVisita to set
	 */
	public void setEsnombreProvinciaVisita(String esnombreProvinciaVisita) {
		this.esnombreProvinciaVisita = esnombreProvinciaVisita;
	}

	/**
	 * @return the municipioIdVisita
	 */
	public String getMunicipioIdVisita() {
		return municipioIdVisita;
	}

	/**
	 * @param municipioIdVisita
	 *            the municipioIdVisita to set
	 */
	public void setMunicipioIdVisita(String municipioIdVisita) {
		this.municipioIdVisita = municipioIdVisita;
	}

	/**
	 * @return the esnombreMunicipioVisita
	 */
	public String getEsnombreMunicipioVisita() {
		return esnombreMunicipioVisita;
	}

	/**
	 * @param esnombreMunicipioVisita
	 *            the esnombreMunicipioVisita to set
	 */
	public void setEsnombreMunicipioVisita(String esnombreMunicipioVisita) {
		this.esnombreMunicipioVisita = esnombreMunicipioVisita;
	}

	/**
	 * @return the localidadIdVisita
	 */
	public String getLocalidadIdVisita() {
		return localidadIdVisita;
	}

	/**
	 * @param localidadIdVisita
	 *            the localidadIdVisita to set
	 */
	public void setLocalidadIdVisita(String localidadIdVisita) {
		this.localidadIdVisita = localidadIdVisita;
	}

	/**
	 * @return the esnombreLocalidadVisita
	 */
	public String getEsnombreLocalidadVisita() {
		return esnombreLocalidadVisita;
	}

	/**
	 * @param esnombreLocalidadVisita
	 *            the esnombreLocalidadVisita to set
	 */
	public void setEsnombreLocalidadVisita(String esnombreLocalidadVisita) {
		this.esnombreLocalidadVisita = esnombreLocalidadVisita;
	}

	/**
	 * @return the calleIdVisita
	 */
	public String getCalleIdVisita() {
		return calleIdVisita;
	}

	/**
	 * @param calleIdVisita
	 *            the calleIdVisita to set
	 */
	public void setCalleIdVisita(String calleIdVisita) {
		this.calleIdVisita = calleIdVisita;
	}

	/**
	 * @return the calleId_labelVisita
	 */
	public String getCalleId_labelVisita() {
		return calleId_labelVisita;
	}

	/**
	 * @param calleId_labelVisita
	 *            the calleId_labelVisita to set
	 */
	public void setCalleId_labelVisita(String calleId_labelVisita) {
		this.calleId_labelVisita = calleId_labelVisita;
	}

	/**
	 * @return the cpIdVisita
	 */
	public String getCpIdVisita() {
		return cpIdVisita;
	}

	/**
	 * @param cpIdVisita
	 *            the cpIdVisita to set
	 */
	public void setCpIdVisita(String cpIdVisita) {
		this.cpIdVisita = cpIdVisita;
	}

	/**
	 * @return the esnombreCpVisita
	 */
	public String getEsnombreCpVisita() {
		return esnombreCpVisita;
	}

	/**
	 * @param esnombreCpVisita
	 *            the esnombreCpVisita to set
	 */
	public void setEsnombreCpVisita(String esnombreCpVisita) {
		this.esnombreCpVisita = esnombreCpVisita;
	}

	/**
	 * @return the portalIdVisita
	 */
	public String getPortalIdVisita() {
		return portalIdVisita;
	}

	/**
	 * @param portalIdVisita
	 *            the portalIdVisita to set
	 */
	public void setPortalIdVisita(String portalIdVisita) {
		this.portalIdVisita = portalIdVisita;
	}

	/**
	 * @return the esnombrePortalVisita
	 */
	public String getEsnombrePortalVisita() {
		return esnombrePortalVisita;
	}

	/**
	 * @param esnombrePortalVisita
	 *            the esnombrePortalVisita to set
	 */
	public void setEsnombrePortalVisita(String esnombrePortalVisita) {
		this.esnombrePortalVisita = esnombrePortalVisita;
	}

	/**
	 * @return the esnombrePisoVisita
	 */
	public String getEsnombrePisoVisita() {
		return esnombrePisoVisita;
	}

	/**
	 * @param esnombrePisoVisita
	 *            the esnombrePisoVisita to set
	 */
	public void setEsnombrePisoVisita(String esnombrePisoVisita) {
		this.esnombrePisoVisita = esnombrePisoVisita;
	}

	/**
	 * @return the eacodigoVisita
	 */
	public String getEacodigoVisita() {
		return eacodigoVisita;
	}

	/**
	 * @param eacodigoVisita
	 *            the eacodigoVisita to set
	 */
	public void setEacodigoVisita(String eacodigoVisita) {
		this.eacodigoVisita = eacodigoVisita;
	}

	/**
	 * @return the avcodigoVisita
	 */
	public String getAvcodigoVisita() {
		return avcodigoVisita;
	}

	/**
	 * @param avcodigoVisita
	 *            the avcodigoVisita to set
	 */
	public void setAvcodigoVisita(String avcodigoVisita) {
		this.avcodigoVisita = avcodigoVisita;
	}

	/**
	 * @return the avnombreVisita
	 */
	public String getAvnombreVisita() {
		return avnombreVisita;
	}

	/**
	 * @param avnombreVisita
	 *            the avnombreVisita to set
	 */
	public void setAvnombreVisita(String avnombreVisita) {
		this.avnombreVisita = avnombreVisita;
	}

	/**
	 * @return the avnombreeVisita
	 */
	public String getAvnombreeVisita() {
		return avnombreeVisita;
	}

	/**
	 * @param avnombreeVisita
	 *            the avnombreeVisita to set
	 */
	public void setAvnombreeVisita(String avnombreeVisita) {
		this.avnombreeVisita = avnombreeVisita;
	}

	/**
	 * @return the secodigoVisita
	 */
	public String getSecodigoVisita() {
		return secodigoVisita;
	}

	/**
	 * @param secodigoVisita
	 *            the secodigoVisita to set
	 */
	public void setSecodigoVisita(String secodigoVisita) {
		this.secodigoVisita = secodigoVisita;
	}

	/**
	 * @return the senombreVisita
	 */
	public String getSenombreVisita() {
		return senombreVisita;
	}

	/**
	 * @param senombreVisita
	 *            the senombreVisita to set
	 */
	public void setSenombreVisita(String senombreVisita) {
		this.senombreVisita = senombreVisita;
	}

	/**
	 * @return the senombreeVisita
	 */
	public String getSenombreeVisita() {
		return senombreeVisita;
	}

	/**
	 * @param senombreeVisita
	 *            the senombreeVisita to set
	 */
	public void setSenombreeVisita(String senombreeVisita) {
		this.senombreeVisita = senombreeVisita;
	}

	/**
	 * @return the eainprseVisita
	 */
	public String getEainprseVisita() {
		return eainprseVisita;
	}

	/**
	 * @param eainprseVisita
	 *            the eainprseVisita to set
	 */
	public void setEainprseVisita(String eainprseVisita) {
		this.eainprseVisita = eainprseVisita;
	}

	/**
	 * @return the direccionAntiguaCompletaVisita
	 */
	public String getDireccionAntiguaCompletaVisita() {
		return direccionAntiguaCompletaVisita;
	}

	/**
	 * @param direccionAntiguaCompletaVisita
	 *            the direccionAntiguaCompletaVisita to set
	 */
	public void setDireccionAntiguaCompletaVisita(
			String direccionAntiguaCompletaVisita) {
		this.direccionAntiguaCompletaVisita = direccionAntiguaCompletaVisita;
	}

	/**
	 * @return the atcodigo
	 */
	public String getAtcodigo() {
		return atcodigo;
	}

	/**
	 * @param atcodigo
	 *            the atcodigo to set
	 */
	public void setAtcodigo(String atcodigo) {
		this.atcodigo = atcodigo;
	}

	/**
	 * @return the atnror
	 */
	public BigDecimal getAtnror() {
		return atnror;
	}

	/**
	 * @param atnror
	 *            the atnror to set
	 */
	public void setAtnror(BigDecimal atnror) {
		this.atnror = atnror;
	}

	/**
	 * @return the ttacodigo
	 */
	public String getTtacodigo() {
		return ttacodigo;
	}

	/**
	 * @param ttacodigo
	 *            the ttacodigo to set
	 */
	public void setTtacodigo(String ttacodigo) {
		this.ttacodigo = ttacodigo;
	}

	/**
	 * @return the ttanombre
	 */
	public String getTtanombre() {
		return ttanombre;
	}

	/**
	 * @param ttanombre
	 *            the ttanombre to set
	 */
	public void setTtanombre(String ttanombre) {
		this.ttanombre = ttanombre;
	}

	/**
	 * @return the tmacodigo
	 */
	public String getTmacodigo() {
		return tmacodigo;
	}

	/**
	 * @param tmacodigo
	 *            the tmacodigo to set
	 */
	public void setTmacodigo(String tmacodigo) {
		this.tmacodigo = tmacodigo;
	}

	/**
	 * @return the tmanombre
	 */
	public String getTmanombre() {
		return tmanombre;
	}

	/**
	 * @param tmanombre
	 *            the tmanombre to set
	 */
	public void setTmanombre(String tmanombre) {
		this.tmanombre = tmanombre;
	}

	/**
	 * @return the escodigoActuacion
	 */
	public String getEscodigoActuacion() {
		return escodigoActuacion;
	}

	/**
	 * @param escodigoActuacion
	 *            the escodigoActuacion to set
	 */
	public void setEscodigoActuacion(String escodigoActuacion) {
		this.escodigoActuacion = escodigoActuacion;
	}

	/**
	 * @return the esnombreActuacion
	 */
	public String getEsnombreActuacion() {
		return esnombreActuacion;
	}

	/**
	 * @param esnombreActuacion
	 *            the esnombreActuacion to set
	 */
	public void setEsnombreActuacion(String esnombreActuacion) {
		this.esnombreActuacion = esnombreActuacion;
	}

	/**
	 * @return the esnifActuacion
	 */
	public String getEsnifActuacion() {
		return esnifActuacion;
	}

	/**
	 * @param esnifActuacion
	 *            the esnifActuacion to set
	 */
	public void setEsnifActuacion(String esnifActuacion) {
		this.esnifActuacion = esnifActuacion;
	}

	/**
	 * @return the esnocoActuacion
	 */
	public String getEsnocoActuacion() {
		return esnocoActuacion;
	}

	/**
	 * @param esnocoActuacion
	 *            the esnocoActuacion to set
	 */
	public void setEsnocoActuacion(String esnocoActuacion) {
		this.esnocoActuacion = esnocoActuacion;
	}

	/**
	 * @return the esnodirActuacion
	 */
	public String getEsnodirActuacion() {
		return esnodirActuacion;
	}

	/**
	 * @param esnodirActuacion
	 *            the esnodirActuacion to set
	 */
	public void setEsnodirActuacion(String esnodirActuacion) {
		this.esnodirActuacion = esnodirActuacion;
	}

	/**
	 * @return the escoloActuacion
	 */
	public String getEscoloActuacion() {
		return escoloActuacion;
	}

	/**
	 * @param escoloActuacion
	 *            the escoloActuacion to set
	 */
	public void setEscoloActuacion(String escoloActuacion) {
		this.escoloActuacion = escoloActuacion;
	}

	/**
	 * @return the esnrcopoActuacion
	 */
	public String getEsnrcopoActuacion() {
		return esnrcopoActuacion;
	}

	/**
	 * @param esnrcopoActuacion
	 *            the esnrcopoActuacion to set
	 */
	public void setEsnrcopoActuacion(String esnrcopoActuacion) {
		this.esnrcopoActuacion = esnrcopoActuacion;
	}

	/**
	 * @return the esnrtelActuacion
	 */
	public String getEsnrtelActuacion() {
		return esnrtelActuacion;
	}

	/**
	 * @param esnrtelActuacion
	 *            the esnrtelActuacion to set
	 */
	public void setEsnrtelActuacion(String esnrtelActuacion) {
		this.esnrtelActuacion = esnrtelActuacion;
	}

	/**
	 * @return the esnrfaxActuacion
	 */
	public String getEsnrfaxActuacion() {
		return esnrfaxActuacion;
	}

	/**
	 * @param esnrfaxActuacion
	 *            the esnrfaxActuacion to set
	 */
	public void setEsnrfaxActuacion(String esnrfaxActuacion) {
		this.esnrfaxActuacion = esnrfaxActuacion;
	}

	/**
	 * @return the escopaActuacion
	 */
	public String getEscopaActuacion() {
		return escopaActuacion;
	}

	/**
	 * @param escopaActuacion
	 *            the escopaActuacion to set
	 */
	public void setEscopaActuacion(String escopaActuacion) {
		this.escopaActuacion = escopaActuacion;
	}

	/**
	 * @return the esinadarActuacion
	 */
	public String getEsinadarActuacion() {
		return esinadarActuacion;
	}

	/**
	 * @param esinadarActuacion
	 *            the esinadarActuacion to set
	 */
	public void setEsinadarActuacion(String esinadarActuacion) {
		this.esinadarActuacion = esinadarActuacion;
	}

	/**
	 * @return the esfeadarActuacion
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getEsfeadarActuacion() {
		return esfeadarActuacion;
	}

	/**
	 * @param esfeadarActuacion
	 *            the esfeadarActuacion to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setEsfeadarActuacion(Date esfeadarActuacion) {
		this.esfeadarActuacion = esfeadarActuacion;
	}

	/**
	 * @return the escoemActuacion
	 */
	public String getEscoemActuacion() {
		return escoemActuacion;
	}

	/**
	 * @param escoemActuacion
	 *            the escoemActuacion to set
	 */
	public void setEscoemActuacion(String escoemActuacion) {
		this.escoemActuacion = escoemActuacion;
	}

	/**
	 * @return the esnrtel2Actuacion
	 */
	public String getEsnrtel2Actuacion() {
		return esnrtel2Actuacion;
	}

	/**
	 * @param esnrtel2Actuacion
	 *            the esnrtel2Actuacion to set
	 */
	public void setEsnrtel2Actuacion(String esnrtel2Actuacion) {
		this.esnrtel2Actuacion = esnrtel2Actuacion;
	}

	/**
	 * @return the esfebaActuacion
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getEsfebaActuacion() {
		return esfebaActuacion;
	}

	/**
	 * @param esfebaActuacion
	 *            the esfebaActuacion to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setEsfebaActuacion(Date esfebaActuacion) {
		this.esfebaActuacion = esfebaActuacion;
	}

	/**
	 * @return the esnoloActuacion
	 */
	public String getEsnoloActuacion() {
		return esnoloActuacion;
	}

	/**
	 * @param esnoloActuacion
	 *            the esnoloActuacion to set
	 */
	public void setEsnoloActuacion(String esnoloActuacion) {
		this.esnoloActuacion = esnoloActuacion;
	}

	/**
	 * @return the escomapvActuacion
	 */
	public String getEscomapvActuacion() {
		return escomapvActuacion;
	}

	/**
	 * @param escomapvActuacion
	 *            the escomapvActuacion to set
	 */
	public void setEscomapvActuacion(String escomapvActuacion) {
		this.escomapvActuacion = escomapvActuacion;
	}

	/**
	 * @return the escocaActuacion
	 */
	public String getEscocaActuacion() {
		return escocaActuacion;
	}

	/**
	 * @param escocaActuacion
	 *            the escocaActuacion to set
	 */
	public void setEscocaActuacion(String escocaActuacion) {
		this.escocaActuacion = escocaActuacion;
	}

	/**
	 * @return the esnomuActuacion
	 */
	public String getEsnomuActuacion() {
		return esnomuActuacion;
	}

	/**
	 * @param esnomuActuacion
	 *            the esnomuActuacion to set
	 */
	public void setEsnomuActuacion(String esnomuActuacion) {
		this.esnomuActuacion = esnomuActuacion;
	}

	/**
	 * @return the esteurlActuacion
	 */
	public String getEsteurlActuacion() {
		return esteurlActuacion;
	}

	/**
	 * @param esteurlActuacion
	 *            the esteurlActuacion to set
	 */
	public void setEsteurlActuacion(String esteurlActuacion) {
		this.esteurlActuacion = esteurlActuacion;
	}

	/**
	 * @return the esnoraPaisIdActuacion
	 */
	public String getEsnoraPaisIdActuacion() {
		return esnoraPaisIdActuacion;
	}

	/**
	 * @param esnoraPaisIdActuacion
	 *            the esnoraPaisIdActuacion to set
	 */
	public void setEsnoraPaisIdActuacion(String esnoraPaisIdActuacion) {
		this.esnoraPaisIdActuacion = esnoraPaisIdActuacion;
	}

	/**
	 * @return the esnoraPaisNombreActuacion
	 */
	public String getEsnoraPaisNombreActuacion() {
		return esnoraPaisNombreActuacion;
	}

	/**
	 * @param esnoraPaisNombreActuacion
	 *            the esnoraPaisNombreActuacion to set
	 */
	public void setEsnoraPaisNombreActuacion(String esnoraPaisNombreActuacion) {
		this.esnoraPaisNombreActuacion = esnoraPaisNombreActuacion;
	}

	/**
	 * @return the provinciaIdActuacion
	 */
	public String getProvinciaIdActuacion() {
		return provinciaIdActuacion;
	}

	/**
	 * @param provinciaIdActuacion
	 *            the provinciaIdActuacion to set
	 */
	public void setProvinciaIdActuacion(String provinciaIdActuacion) {
		this.provinciaIdActuacion = provinciaIdActuacion;
	}

	/**
	 * @return the esnombreProvinciaActuacion
	 */
	public String getEsnombreProvinciaActuacion() {
		return esnombreProvinciaActuacion;
	}

	/**
	 * @param esnombreProvinciaActuacion
	 *            the esnombreProvinciaActuacion to set
	 */
	public void setEsnombreProvinciaActuacion(String esnombreProvinciaActuacion) {
		this.esnombreProvinciaActuacion = esnombreProvinciaActuacion;
	}

	/**
	 * @return the municipioIdActuacion
	 */
	public String getMunicipioIdActuacion() {
		return municipioIdActuacion;
	}

	/**
	 * @param municipioIdActuacion
	 *            the municipioIdActuacion to set
	 */
	public void setMunicipioIdActuacion(String municipioIdActuacion) {
		this.municipioIdActuacion = municipioIdActuacion;
	}

	/**
	 * @return the esnombreMunicipioActuacion
	 */
	public String getEsnombreMunicipioActuacion() {
		return esnombreMunicipioActuacion;
	}

	/**
	 * @param esnombreMunicipioActuacion
	 *            the esnombreMunicipioActuacion to set
	 */
	public void setEsnombreMunicipioActuacion(String esnombreMunicipioActuacion) {
		this.esnombreMunicipioActuacion = esnombreMunicipioActuacion;
	}

	/**
	 * @return the localidadIdActuacion
	 */
	public String getLocalidadIdActuacion() {
		return localidadIdActuacion;
	}

	/**
	 * @param localidadIdActuacion
	 *            the localidadIdActuacion to set
	 */
	public void setLocalidadIdActuacion(String localidadIdActuacion) {
		this.localidadIdActuacion = localidadIdActuacion;
	}

	/**
	 * @return the esnombreLocalidadActuacion
	 */
	public String getEsnombreLocalidadActuacion() {
		return esnombreLocalidadActuacion;
	}

	/**
	 * @param esnombreLocalidadActuacion
	 *            the esnombreLocalidadActuacion to set
	 */
	public void setEsnombreLocalidadActuacion(String esnombreLocalidadActuacion) {
		this.esnombreLocalidadActuacion = esnombreLocalidadActuacion;
	}

	/**
	 * @return the calleIdActuacion
	 */
	public String getCalleIdActuacion() {
		return calleIdActuacion;
	}

	/**
	 * @param calleIdActuacion
	 *            the calleIdActuacion to set
	 */
	public void setCalleIdActuacion(String calleIdActuacion) {
		this.calleIdActuacion = calleIdActuacion;
	}

	/**
	 * @return the calleId_labelActuacion
	 */
	public String getCalleId_labelActuacion() {
		return calleId_labelActuacion;
	}

	/**
	 * @param calleId_labelActuacion
	 *            the calleId_labelActuacion to set
	 */
	public void setCalleId_labelActuacion(String calleId_labelActuacion) {
		this.calleId_labelActuacion = calleId_labelActuacion;
	}

	/**
	 * @return the cpIdActuacion
	 */
	public String getCpIdActuacion() {
		return cpIdActuacion;
	}

	/**
	 * @param cpIdActuacion
	 *            the cpIdActuacion to set
	 */
	public void setCpIdActuacion(String cpIdActuacion) {
		this.cpIdActuacion = cpIdActuacion;
	}

	/**
	 * @return the esnombreCpActuacion
	 */
	public String getEsnombreCpActuacion() {
		return esnombreCpActuacion;
	}

	/**
	 * @param esnombreCpActuacion
	 *            the esnombreCpActuacion to set
	 */
	public void setEsnombreCpActuacion(String esnombreCpActuacion) {
		this.esnombreCpActuacion = esnombreCpActuacion;
	}

	/**
	 * @return the portalIdActuacion
	 */
	public String getPortalIdActuacion() {
		return portalIdActuacion;
	}

	/**
	 * @param portalIdActuacion
	 *            the portalIdActuacion to set
	 */
	public void setPortalIdActuacion(String portalIdActuacion) {
		this.portalIdActuacion = portalIdActuacion;
	}

	/**
	 * @return the esnombrePortalActuacion
	 */
	public String getEsnombrePortalActuacion() {
		return esnombrePortalActuacion;
	}

	/**
	 * @param esnombrePortalActuacion
	 *            the esnombrePortalActuacion to set
	 */
	public void setEsnombrePortalActuacion(String esnombrePortalActuacion) {
		this.esnombrePortalActuacion = esnombrePortalActuacion;
	}

	/**
	 * @return the esnombrePisoActuacion
	 */
	public String getEsnombrePisoActuacion() {
		return esnombrePisoActuacion;
	}

	/**
	 * @param esnombrePisoActuacion
	 *            the esnombrePisoActuacion to set
	 */
	public void setEsnombrePisoActuacion(String esnombrePisoActuacion) {
		this.esnombrePisoActuacion = esnombrePisoActuacion;
	}

	/**
	 * @return the eacodigoActuacion
	 */
	public String getEacodigoActuacion() {
		return eacodigoActuacion;
	}

	/**
	 * @param eacodigoActuacion
	 *            the eacodigoActuacion to set
	 */
	public void setEacodigoActuacion(String eacodigoActuacion) {
		this.eacodigoActuacion = eacodigoActuacion;
	}

	/**
	 * @return the avcodigoActuacion
	 */
	public String getAvcodigoActuacion() {
		return avcodigoActuacion;
	}

	/**
	 * @param avcodigoActuacion
	 *            the avcodigoActuacion to set
	 */
	public void setAvcodigoActuacion(String avcodigoActuacion) {
		this.avcodigoActuacion = avcodigoActuacion;
	}

	/**
	 * @return the avnombreActuacion
	 */
	public String getAvnombreActuacion() {
		return avnombreActuacion;
	}

	/**
	 * @param avnombreActuacion
	 *            the avnombreActuacion to set
	 */
	public void setAvnombreActuacion(String avnombreActuacion) {
		this.avnombreActuacion = avnombreActuacion;
	}

	/**
	 * @return the avnombreeActuacion
	 */
	public String getAvnombreeActuacion() {
		return avnombreeActuacion;
	}

	/**
	 * @param avnombreeActuacion
	 *            the avnombreeActuacion to set
	 */
	public void setAvnombreeActuacion(String avnombreeActuacion) {
		this.avnombreeActuacion = avnombreeActuacion;
	}

	/**
	 * @return the secodigoActuacion
	 */
	public String getSecodigoActuacion() {
		return secodigoActuacion;
	}

	/**
	 * @param secodigoActuacion
	 *            the secodigoActuacion to set
	 */
	public void setSecodigoActuacion(String secodigoActuacion) {
		this.secodigoActuacion = secodigoActuacion;
	}

	/**
	 * @return the senombreActuacion
	 */
	public String getSenombreActuacion() {
		return senombreActuacion;
	}

	/**
	 * @param senombreActuacion
	 *            the senombreActuacion to set
	 */
	public void setSenombreActuacion(String senombreActuacion) {
		this.senombreActuacion = senombreActuacion;
	}

	/**
	 * @return the senombreeActuacion
	 */
	public String getSenombreeActuacion() {
		return senombreeActuacion;
	}

	/**
	 * @param senombreeActuacion
	 *            the senombreeActuacion to set
	 */
	public void setSenombreeActuacion(String senombreeActuacion) {
		this.senombreeActuacion = senombreeActuacion;
	}

	/**
	 * @return the eainprseActuacion
	 */
	public String getEainprseActuacion() {
		return eainprseActuacion;
	}

	/**
	 * @param eainprseActuacion
	 *            the eainprseActuacion to set
	 */
	public void setEainprseActuacion(String eainprseActuacion) {
		this.eainprseActuacion = eainprseActuacion;
	}

	/**
	 * @return the direccionAntiguaCompletaActuacion
	 */
	public String getDireccionAntiguaCompletaActuacion() {
		return direccionAntiguaCompletaActuacion;
	}

	/**
	 * @param direccionAntiguaCompletaActuacion
	 *            the direccionAntiguaCompletaActuacion to set
	 */
	public void setDireccionAntiguaCompletaActuacion(
			String direccionAntiguaCompletaActuacion) {
		this.direccionAntiguaCompletaActuacion = direccionAntiguaCompletaActuacion;
	}

	/**
	 * @return the pscodigoActuacion
	 */
	public String getPscodigoActuacion() {
		return pscodigoActuacion;
	}

	/**
	 * @param pscodigoActuacion
	 *            the pscodigoActuacion to set
	 */
	public void setPscodigoActuacion(String pscodigoActuacion) {
		this.pscodigoActuacion = pscodigoActuacion;
	}

	/**
	 * @return the psnombreActuacion
	 */
	public String getPsnombreActuacion() {
		return psnombreActuacion;
	}

	/**
	 * @param psnombreActuacion
	 *            the psnombreActuacion to set
	 */
	public void setPsnombreActuacion(String psnombreActuacion) {
		this.psnombreActuacion = psnombreActuacion;
	}

	/**
	 * @return the psnombreeActuacion
	 */
	public String getPsnombreeActuacion() {
		return psnombreeActuacion;
	}

	/**
	 * @param psnombreeActuacion
	 *            the psnombreeActuacion to set
	 */
	public void setPsnombreeActuacion(String psnombreeActuacion) {
		this.psnombreeActuacion = psnombreeActuacion;
	}

	/**
	 * @return the atnoprse
	 */
	public String getAtnoprse() {
		return atnoprse;
	}

	/**
	 * @param atnoprse
	 *            the atnoprse to set
	 */
	public void setAtnoprse(String atnoprse) {
		this.atnoprse = atnoprse;
	}

	/**
	 * @return the atnomaps
	 */
	public String getAtnomaps() {
		return atnomaps;
	}

	/**
	 * @param atnomaps
	 *            the atnomaps to set
	 */
	public void setAtnomaps(String atnomaps) {
		this.atnomaps = atnomaps;
	}

	/**
	 * @return the atnomops
	 */
	public String getAtnomops() {
		return atnomops;
	}

	/**
	 * @param atnomops
	 *            the atnomops to set
	 */
	public void setAtnomops(String atnomops) {
		this.atnomops = atnomops;
	}

	/**
	 * @return the atnrlops
	 */
	public String getAtnrlops() {
		return atnrlops;
	}

	/**
	 * @param atnrlops
	 *            the atnrlops to set
	 */
	public void setAtnrlops(String atnrlops) {
		this.atnrlops = atnrlops;
	}

	/**
	 * @return the atfedumi
	 */
	@JsonSerialize(using = Y41aJsonDateSerializer.class)
	public Date getAtfedumi() {
		return atfedumi;
	}

	/**
	 * @param atfedumi
	 *            the atfedumi to set
	 */
	@JsonDeserialize(using = Y41aJsonDateDeserializer.class)
	public void setAtfedumi(Date atfedumi) {
		this.atfedumi = atfedumi;
	}

	/**
	 * @return the atinprse
	 */
	public String getAtinprse() {
		return atinprse;
	}

	/**
	 * @param atinprse
	 *            the atinprse to set
	 */
	public void setAtinprse(String atinprse) {
		this.atinprse = atinprse;
	}

	/**
	 * @return the atcaunep
	 */
	public BigDecimal getAtcaunep() {
		return atcaunep;
	}

	/**
	 * @param atcaunep
	 *            the atcaunep to set
	 */
	public void setAtcaunep(BigDecimal atcaunep) {
		this.atcaunep = atcaunep;
	}

	/**
	 * @return the s4codigo
	 */
	public String getS4codigo() {
		return s4codigo;
	}

	/**
	 * @param s4codigo
	 *            the s4codigo to set
	 */
	public void setS4codigo(String s4codigo) {
		this.s4codigo = s4codigo;
	}

	/**
	 * @return the s5codigo
	 */
	public String getS5codigo() {
		return s5codigo;
	}

	/**
	 * @param s5codigo
	 *            the s5codigo to set
	 */
	public void setS5codigo(String s5codigo) {
		this.s5codigo = s5codigo;
	}

	/**
	 * @return the s6codigo
	 */
	public String getS6codigo() {
		return s6codigo;
	}

	/**
	 * @param s6codigo
	 *            the s6codigo to set
	 */
	public void setS6codigo(String s6codigo) {
		this.s6codigo = s6codigo;
	}

	/**
	 * @return the atcotp
	 */
	public String getAtcotp() {
		return atcotp;
	}

	/**
	 * @param atcotp
	 *            the atcotp to set
	 */
	public void setAtcotp(String atcotp) {
		this.atcotp = atcotp;
	}

	/**
	 * @return the acdireccion_nocapv
	 */
	public String getAcdireccion_nocapv() {
		return acdireccion_nocapv;
	}

	/**
	 * @param acdireccion_nocapv
	 *            the acdireccion_nocapv to set
	 */
	public void setAcdireccion_nocapv(String acdireccion_nocapv) {
		this.acdireccion_nocapv = acdireccion_nocapv;
	}

	/**
	 * @return the esdireccion_nocapvVisita
	 */
	public String getEsdireccion_nocapvVisita() {
		return esdireccion_nocapvVisita;
	}

	/**
	 * @param esdireccion_nocapvVisita
	 *            the esdireccion_nocapvVisita to set
	 */
	public void setEsdireccion_nocapvVisita(String esdireccion_nocapvVisita) {
		this.esdireccion_nocapvVisita = esdireccion_nocapvVisita;
	}

	/**
	 * @return the esdireccion_nocapvActuacion
	 */
	public String getEsdireccion_nocapvActuacion() {
		return esdireccion_nocapvActuacion;
	}

	/**
	 * @param esdireccion_nocapvActuacion
	 *            the esdireccion_nocapvActuacion to set
	 */
	public void setEsdireccion_nocapvActuacion(
			String esdireccion_nocapvActuacion) {
		this.esdireccion_nocapvActuacion = esdireccion_nocapvActuacion;
	}

	/**
	 * @return the atteinfo
	 */
	public String getAtteinfo() {
		return atteinfo;
	}

	/**
	 * @param atteinfo
	 *            the atteinfo to set
	 */
	public void setAtteinfo(String atteinfo) {
		this.atteinfo = atteinfo;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "ActaActuacionAlta [tipo=" + tipo + ", codigo=" + codigo
				+ ", descripcion=" + descripcion + ", accodigo=" + accodigo
				+ ", accoor=" + accoor + ", acnror=" + acnror + ", acnran="
				+ acnran + ", acfele=" + acfele + ", acfere=" + acfere
				+ ", accoinun=" + accoinun + ", accoindo=" + accoindo
				+ ", tdcodigo=" + tdcodigo + ", tdnombre=" + tdnombre
				+ ", acnoco=" + acnoco + ", acape1co=" + acape1co
				+ ", acape2co=" + acape2co + ", acdnico=" + acdnico
				+ ", accoco=" + accoco + ", acdirco=" + acdirco + ", accoloco="
				+ accoloco + ", acnrcpco=" + acnrcpco + ", acnrtfco="
				+ acnrtfco + ", acnoraPaisId=" + acnoraPaisId
				+ ", acnoraPaisNombre=" + acnoraPaisNombre
				+ ", acnoraProvinciaId=" + acnoraProvinciaId
				+ ", acnombreProvincia=" + acnombreProvincia
				+ ", acnoraMunicipioId=" + acnoraMunicipioId
				+ ", acnombreMunicipio=" + acnombreMunicipio
				+ ", acnoraLocalidadId=" + acnoraLocalidadId
				+ ", acnombreLocalidad=" + acnombreLocalidad
				+ ", acnoraCalleId=" + acnoraCalleId + ", acnombreCalle="
				+ acnombreCalle + ", acnoraCpId=" + acnoraCpId
				+ ", acnombreCp=" + acnombreCp + ", acnoraPortalId="
				+ acnoraPortalId + ", acnombrePortal=" + acnombrePortal
				+ ", acnombrePiso=" + acnombrePiso + ", acdireccion_nocapv="
				+ acdireccion_nocapv + ", dirAntiguaCompletaCompareciente="
				+ dirAntiguaCompletaCompareciente + ", escodigoVisita="
				+ escodigoVisita + ", esnombreVisita=" + esnombreVisita
				+ ", esnifVisita=" + esnifVisita + ", esnocoVisita="
				+ esnocoVisita + ", esnodirVisita=" + esnodirVisita
				+ ", escoloVisita=" + escoloVisita + ", esnrcopoVisita="
				+ esnrcopoVisita + ", esnrtelVisita=" + esnrtelVisita
				+ ", esnrfaxVisita=" + esnrfaxVisita + ", escopaVisita="
				+ escopaVisita + ", esinadarVisita=" + esinadarVisita
				+ ", esfeadarVisita=" + esfeadarVisita + ", escoemVisita="
				+ escoemVisita + ", esnrtel2Visita=" + esnrtel2Visita
				+ ", esfebaVisita=" + esfebaVisita + ", esnoloVisita="
				+ esnoloVisita + ", escomapvVisita=" + escomapvVisita
				+ ", escocaVisita=" + escocaVisita + ", esnomuVisita="
				+ esnomuVisita + ", esteurlVisita=" + esteurlVisita
				+ ", esnoraPaisIdVisita=" + esnoraPaisIdVisita
				+ ", esnoraPaisNombreVisita=" + esnoraPaisNombreVisita
				+ ", provinciaIdVisita=" + provinciaIdVisita
				+ ", esnombreProvinciaVisita=" + esnombreProvinciaVisita
				+ ", municipioIdVisita=" + municipioIdVisita
				+ ", esnombreMunicipioVisita=" + esnombreMunicipioVisita
				+ ", localidadIdVisita=" + localidadIdVisita
				+ ", esnombreLocalidadVisita=" + esnombreLocalidadVisita
				+ ", calleIdVisita=" + calleIdVisita + ", calleId_labelVisita="
				+ calleId_labelVisita + ", cpIdVisita=" + cpIdVisita
				+ ", esnombreCpVisita=" + esnombreCpVisita
				+ ", portalIdVisita=" + portalIdVisita
				+ ", esnombrePortalVisita=" + esnombrePortalVisita
				+ ", esnombrePisoVisita=" + esnombrePisoVisita
				+ ", esdireccion_nocapvVisita=" + esdireccion_nocapvVisita
				+ ", eacodigoVisita=" + eacodigoVisita + ", avcodigoVisita="
				+ avcodigoVisita + ", avnombreVisita=" + avnombreVisita
				+ ", avnombreeVisita=" + avnombreeVisita + ", secodigoVisita="
				+ secodigoVisita + ", senombreVisita=" + senombreVisita
				+ ", senombreeVisita=" + senombreeVisita + ", eainprseVisita="
				+ eainprseVisita + ", direccionAntiguaCompletaVisita="
				+ direccionAntiguaCompletaVisita + ", atcodigo=" + atcodigo
				+ ", atnror=" + atnror + ", atcotp=" + atcotp + ", ttacodigo="
				+ ttacodigo + ", ttanombre=" + ttanombre + ", tmacodigo="
				+ tmacodigo + ", tmanombre=" + tmanombre
				+ ", escodigoActuacion=" + escodigoActuacion
				+ ", esnombreActuacion=" + esnombreActuacion
				+ ", esnifActuacion=" + esnifActuacion + ", esnocoActuacion="
				+ esnocoActuacion + ", esnodirActuacion=" + esnodirActuacion
				+ ", escoloActuacion=" + escoloActuacion
				+ ", esnrcopoActuacion=" + esnrcopoActuacion
				+ ", esnrtelActuacion=" + esnrtelActuacion
				+ ", esnrfaxActuacion=" + esnrfaxActuacion
				+ ", escopaActuacion=" + escopaActuacion
				+ ", esinadarActuacion=" + esinadarActuacion
				+ ", esfeadarActuacion=" + esfeadarActuacion
				+ ", escoemActuacion=" + escoemActuacion
				+ ", esnrtel2Actuacion=" + esnrtel2Actuacion
				+ ", esfebaActuacion=" + esfebaActuacion + ", esnoloActuacion="
				+ esnoloActuacion + ", escomapvActuacion=" + escomapvActuacion
				+ ", escocaActuacion=" + escocaActuacion + ", esnomuActuacion="
				+ esnomuActuacion + ", esteurlActuacion=" + esteurlActuacion
				+ ", esnoraPaisIdActuacion=" + esnoraPaisIdActuacion
				+ ", esnoraPaisNombreActuacion=" + esnoraPaisNombreActuacion
				+ ", provinciaIdActuacion=" + provinciaIdActuacion
				+ ", esnombreProvinciaActuacion=" + esnombreProvinciaActuacion
				+ ", municipioIdActuacion=" + municipioIdActuacion
				+ ", esnombreMunicipioActuacion=" + esnombreMunicipioActuacion
				+ ", localidadIdActuacion=" + localidadIdActuacion
				+ ", esnombreLocalidadActuacion=" + esnombreLocalidadActuacion
				+ ", calleIdActuacion=" + calleIdActuacion
				+ ", calleId_labelActuacion=" + calleId_labelActuacion
				+ ", cpIdActuacion=" + cpIdActuacion + ", esnombreCpActuacion="
				+ esnombreCpActuacion + ", portalIdActuacion="
				+ portalIdActuacion + ", esnombrePortalActuacion="
				+ esnombrePortalActuacion + ", esnombrePisoActuacion="
				+ esnombrePisoActuacion + ", esdireccion_nocapvActuacion="
				+ esdireccion_nocapvActuacion + ", eacodigoActuacion="
				+ eacodigoActuacion + ", avcodigoActuacion="
				+ avcodigoActuacion + ", avnombreActuacion="
				+ avnombreActuacion + ", avnombreeActuacion="
				+ avnombreeActuacion + ", secodigoActuacion="
				+ secodigoActuacion + ", senombreActuacion="
				+ senombreActuacion + ", senombreeActuacion="
				+ senombreeActuacion + ", eainprseActuacion="
				+ eainprseActuacion + ", direccionAntiguaCompletaActuacion="
				+ direccionAntiguaCompletaActuacion + ", pscodigoActuacion="
				+ pscodigoActuacion + ", psnombreActuacion="
				+ psnombreActuacion + ", psnombreeActuacion="
				+ psnombreeActuacion + ", atnoprse=" + atnoprse + ", atnomaps="
				+ atnomaps + ", atnomops=" + atnomops + ", atnrlops="
				+ atnrlops + ", atfedumi=" + atfedumi + ", s4codigo="
				+ s4codigo + ", s5codigo=" + s5codigo + ", s6codigo="
				+ s6codigo + ", atinprse=" + atinprse + ", atcaunep="
				+ atcaunep + "]";
	}

}
