package com.ejie.y41a.log;

import java.util.Hashtable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger.Level;

import com.ejie.x38.log.LoggingManager;
import com.ejie.x38.util.StackTraceManager;
import com.ejie.x38.util.TableManager;

public class Y41aIncidenceLoggingAdviceImpl implements
		Y41aIncidenceLoggingAdvice {
	private static final Logger logger = LoggerFactory
			.getLogger(Y41aIncidenceLoggingAdviceImpl.class);

	private LoggingManager loggingManager;

	public void logIncidence(Object target, Exception exception) {
		Hashtable<String, String> table = TableManager.initTable();
		table.put(Y41aLogConstants.CRITICALITY, Level.ERROR.toString());
		table.put(Y41aLogConstants.FUNCTIONALSUBSYSTEM,
				Y41aLogConstants.INCIDENCESUBSYSTEM);
		table.put(Y41aLogConstants.ADITIONALINFO,
				StackTraceManager.getStackTrace(exception));
		if (exception.getMessage() != null) {
			table.put(Y41aLogConstants.MESSAGE, exception.getMessage());
		}
		loggingManager
				.logIncidences(target.getClass().getName(), logger, table);
	}

	// Getters & Setters
	public LoggingManager getLoggingManager() {
		return loggingManager;
	}

	public void setLoggingManager(LoggingManager loggingManager) {
		this.loggingManager = loggingManager;
	}
}
