package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Decision;
import com.ejie.y41a.model.DecisionHecho;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.model.TramiteHechoDetalle;
import com.ejie.y41a.model.Traslado;
import com.ejie.y41a.model.TrasladoBusqueda;

/**
 * * TrasladoDaoImpl generated by UDA, 22-feb-2012 17:30:27.
 * 
 *  
 */

@Repository
@Transactional
public class TrasladoDaoImpl implements TrasladoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Traslado> rwMap = new RowMapper<Traslado>() {
		public Traslado mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Traslado(resultSet.getString("IHCODIGO"),
					resultSet.getString("IHCOORTR"),
					resultSet.getBigDecimal("IHNRORTR"),
					resultSet.getBigDecimal("IHNRANTR"),
					resultSet.getString("IHCOOR"),
					resultSet.getBigDecimal("IHNROR"),
					resultSet.getBigDecimal("IHNRAN"),
					resultSet.getString("IHININTR"),
					resultSet.getDate("IHFEREEN"),
					resultSet.getString("IHTEREOR"),
					resultSet.getDate("IHFEREOR"),
					resultSet.getString("IHCOOROR"),
					resultSet.getString("IHCOORDT"),
					resultSet.getString("IHTEDOAD"),
					resultSet.getString("IHCOAD"),
					resultSet.getString("IHCOORAC"),
					resultSet.getString("IHNRORAC"),
					resultSet.getBigDecimal("IHNRANAC"),
					resultSet.getBigDecimal("IHNRORAT"),
					resultSet.getString("IHCOCPDE"),
					resultSet.getString("IHCOORDE"),
					resultSet.getBigDecimal("IHNRANDE"),
					resultSet.getBigDecimal("IHNRORDE"),
					resultSet.getBigDecimal("IHNRORHD"),
					resultSet.getDate("IHFEACRE"),
					resultSet.getDate("IHFECDOI"),
					resultSet.getDate("IHFECDIN"),
					resultSet.getDate("IHFERESA"),
					resultSet.getString("IHTERARD"),
					resultSet.getString("IHCOTTDD"),
					resultSet.getBigDecimal("IHCAPTMD"),
					resultSet.getDate("IHFECODD"),
					resultSet.getString("IHCOORD2"),
					resultSet.getDate("IHFESET1"),
					resultSet.getDate("IHFESET2"),
					resultSet.getDate("IHFESET3"),
					resultSet.getDate("IHFESET4"),
					resultSet.getDate("IHFECDD1"),
					resultSet.getString("IHINDREC"),
					resultSet.getString("IHCOHCDS"),
					resultSet.getString("IHCOADDS"),
					resultSet.getString("IHCOEH"),
					resultSet.getString("IHNRRGEN"), new DecisionHecho(
							resultSet.getString("DecisionHechoHCCODIGO"),
							resultSet.getString("DecisionHechoHCCOOR"),
							resultSet.getDate("DecisionHechoHCFEDE"),
							resultSet.getDate("DecisionHechoHCFECODE"),
							resultSet.getString("DecisionHechoHCCOORPROP"),
							resultSet.getString("DecisionHechoHCCOORTRI"),
							new HechoDenunciado(resultSet
									.getString("DecisionHechoHCCOHD"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null),
							new Decision(resultSet
									.getString("DecisionHechoHCCOTTD"), null,
									null, null, null)));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Pagination
	 * @return Traslado
	 */
	public Traslado add(Traslado traslado) {

		String query = "INSERT INTO TRASLADO( IHCODIGO,IHCOHC,IHCOORTR,IHNRORTR,IHNRANTR,IHCOOR,IHNROR,IHNRAN,IHININTR,IHFEREEN,IHTEREOR,IHFEREOR,IHCOOROR,IHCOORDT,IHTEDOAD,IHCOAD,IHCOORAC,IHNRORAC,IHNRANAC,IHNRORAT,IHCOCPDE,IHCOORDE,IHNRANDE,IHNRORDE,IHNRORHD,IHFEACRE,IHFECDOI,IHFECDIN,IHFERESA,IHTERARD,IHCOTTDD,IHCAPTMD,IHFECODD,IHCOORD2,IHFESET1,IHFESET2,IHFESET3,IHFESET4,IHFECDD1,IHINDREC,IHCOHCDS,IHCOADDS,IHCOEH,IHNRRGEN)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getDecisionHechoHccodigoAux = null;
		if (traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHccodigo() != null) {
			getDecisionHechoHccodigoAux = traslado.getDecisionHecho()
					.getHccodigo();
		}
		this.jdbcTemplate.update(query, traslado.getIhcodigo(),
				getDecisionHechoHccodigoAux, traslado.getIhcoortr(),
				traslado.getIhnrortr(), traslado.getIhnrantr(),
				traslado.getIhcoor(), traslado.getIhnror(),
				traslado.getIhnran(), traslado.getIhinintr(),
				traslado.getIhfereen(), traslado.getIhtereor(),
				traslado.getIhfereor(), traslado.getIhcooror(),
				traslado.getIhcoordt(), traslado.getIhtedoad(),
				traslado.getIhcoad(), traslado.getIhcoorac(),
				traslado.getIhnrorac(), traslado.getIhnranac(),
				traslado.getIhnrorat(), traslado.getIhcocpde(),
				traslado.getIhcoorde(), traslado.getIhnrande(),
				traslado.getIhnrorde(), traslado.getIhnrorhd(),
				traslado.getIhfeacre(), traslado.getIhfecdoi(),
				traslado.getIhfecdin(), traslado.getIhferesa(),
				traslado.getIhterard(), traslado.getIhcottdd(),
				traslado.getIhcaptmd(), traslado.getIhfecodd(),
				traslado.getIhcoord2(), traslado.getIhfeset1(),
				traslado.getIhfeset2(), traslado.getIhfeset3(),
				traslado.getIhfeset4(), traslado.getIhfecdd1(),
				traslado.getIhindrec(), traslado.getIhcohcds(),
				traslado.getIhcoadds(), traslado.getIhcoeh(),
				traslado.getIhnrrgen());
		return traslado;
	}

	/**
	 * Inserts a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Pagination
	 * @return Traslado
	 */
	public Traslado addTraslado(Traslado traslado) {

		String query = "INSERT INTO TRASLADO( IHCODIGO,IHCOHC,IHCOORTR,IHNRORTR,IHNRANTR,IHCOOR,IHNROR,IHNRAN,IHININTR,IHFEREEN,IHTEREOR,IHFEREOR,IHCOOROR,IHCOORDT,IHTEDOAD,IHCOAD,IHCOORAC,IHNRORAC,IHNRANAC,IHNRORAT,IHCOCPDE,IHCOORDE,IHNRANDE,IHNRORDE,IHNRORHD,IHFEACRE,IHFECDOI,IHFECDIN,IHFERESA,IHTERARD,IHCOTTDD,IHCAPTMD,IHFECODD,IHCOORD2,IHFESET1,IHFESET2,IHFESET3,IHFESET4,IHFECDD1,IHINDREC,IHCOHCDS,IHCOADDS,IHCOEH,IHNRRGEN)"
				+ "VALUES (?,?,?,(SELECT NVL(MAX(ABS(IHNRORTR)),0)+1 FROM TRASLADO WHERE IHCOORTR = ? AND IHNRANTR = ?),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getDecisionHechoHccodigoAux = null;
		if (traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHccodigo() != null) {
			getDecisionHechoHccodigoAux = traslado.getDecisionHecho()
					.getHccodigo();
		}
		this.jdbcTemplate.update(query, traslado.getIhcodigo(),
				getDecisionHechoHccodigoAux, traslado.getIhcoortr(),
				traslado.getIhcoortr(), traslado.getIhnrantr(),
				traslado.getIhnrantr(), traslado.getIhcoor(),
				traslado.getIhnror(), traslado.getIhnran(),
				traslado.getIhinintr(), traslado.getIhfereen(),
				traslado.getIhtereor(), traslado.getIhfereor(),
				traslado.getIhcooror(), traslado.getIhcoordt(),
				traslado.getIhtedoad(), traslado.getIhcoad(),
				traslado.getIhcoorac(), traslado.getIhnrorac(),
				traslado.getIhnranac(), traslado.getIhnrorat(),
				traslado.getIhcocpde(), traslado.getIhcoorde(),
				traslado.getIhnrande(), traslado.getIhnrorde(),
				traslado.getIhnrorhd(), traslado.getIhfeacre(),
				traslado.getIhfecdoi(), traslado.getIhfecdin(),
				traslado.getIhferesa(), traslado.getIhterard(),
				traslado.getIhcottdd(), traslado.getIhcaptmd(),
				traslado.getIhfecodd(), traslado.getIhcoord2(),
				traslado.getIhfeset1(), traslado.getIhfeset2(),
				traslado.getIhfeset3(), traslado.getIhfeset4(),
				traslado.getIhfecdd1(), traslado.getIhindrec(),
				traslado.getIhcohcds(), traslado.getIhcoadds(),
				traslado.getIhcoeh(), traslado.getIhnrrgen());
		return traslado;
	}

	/**
	 * Updates a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Pagination
	 * @return Traslado
	 */
	public Traslado update(Traslado traslado) {
		String query = "UPDATE TRASLADO SET IHCOHC=?,IHCOORTR=?,IHNRORTR=?,IHNRANTR=?,IHCOOR=?,IHNROR=?,IHNRAN=?,IHININTR=?,IHFEREEN=?,IHTEREOR=?,IHFEREOR=?,IHCOOROR=?,IHCOORDT=?,IHTEDOAD=?,IHCOAD=?,IHCOORAC=?,IHNRORAC=?,IHNRANAC=?,IHNRORAT=?,IHCOCPDE=?,IHCOORDE=?,IHNRANDE=?,IHNRORDE=?,IHNRORHD=?,IHFEACRE=?,IHFECDOI=?,IHFECDIN=?,IHFERESA=?,IHTERARD=?,IHCOTTDD=?,IHCAPTMD=?,IHFECODD=?,IHCOORD2=?,IHFESET1=?,IHFESET2=?,IHFESET3=?,IHFESET4=?,IHFECDD1=?,IHINDREC=?,IHCOHCDS=?,IHCOADDS=?,IHCOEH=?,IHNRRGEN=? WHERE IHCODIGO=?";
		Object getDecisionHechoHccodigoAux = null;
		if (traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHccodigo() != null) {
			getDecisionHechoHccodigoAux = traslado.getDecisionHecho()
					.getHccodigo();
		}
		this.jdbcTemplate.update(query, getDecisionHechoHccodigoAux,
				traslado.getIhcoortr(), traslado.getIhnrortr(),
				traslado.getIhnrantr(), traslado.getIhcoor(),
				traslado.getIhnror(), traslado.getIhnran(),
				traslado.getIhinintr(), traslado.getIhfereen(),
				traslado.getIhtereor(), traslado.getIhfereor(),
				traslado.getIhcooror(), traslado.getIhcoordt(),
				traslado.getIhtedoad(), traslado.getIhcoad(),
				traslado.getIhcoorac(), traslado.getIhnrorac(),
				traslado.getIhnranac(), traslado.getIhnrorat(),
				traslado.getIhcocpde(), traslado.getIhcoorde(),
				traslado.getIhnrande(), traslado.getIhnrorde(),
				traslado.getIhnrorhd(), traslado.getIhfeacre(),
				traslado.getIhfecdoi(), traslado.getIhfecdin(),
				traslado.getIhferesa(), traslado.getIhterard(),
				traslado.getIhcottdd(), traslado.getIhcaptmd(),
				traslado.getIhfecodd(), traslado.getIhcoord2(),
				traslado.getIhfeset1(), traslado.getIhfeset2(),
				traslado.getIhfeset3(), traslado.getIhfeset4(),
				traslado.getIhfecdd1(), traslado.getIhindrec(),
				traslado.getIhcohcds(), traslado.getIhcoadds(),
				traslado.getIhcoeh(), traslado.getIhnrrgen(),
				traslado.getIhcodigo());
		return traslado;
	}

	/**
	 * Updates a single row in the Traslado table.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @return TrasladoBusqueda
	 */
	public TrasladoBusqueda updateTraslado(TrasladoBusqueda trasladoBusqueda) {
		String query = "UPDATE TRASLADO SET IHFEREEN=? WHERE IHCODIGO=?";

		this.jdbcTemplate.update(query, trasladoBusqueda.getIhfereen(),
				trasladoBusqueda.getIhcodigo());
		return trasladoBusqueda;
	}

	/**
	 * Finds a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Pagination
	 * @return Traslado
	 */
	@Transactional(readOnly = true)
	public Traslado find(Traslado traslado) {
		String query = "SELECT t1.IHCODIGO IHCODIGO, t1.IHCOORTR IHCOORTR, t1.IHNRORTR IHNRORTR, t1.IHNRANTR IHNRANTR, t1.IHCOOR IHCOOR, t1.IHNROR IHNROR, t1.IHNRAN IHNRAN, t1.IHININTR IHININTR, t1.IHFEREEN IHFEREEN, t1.IHTEREOR IHTEREOR, t1.IHFEREOR IHFEREOR, t1.IHCOOROR IHCOOROR, t1.IHCOORDT IHCOORDT, t1.IHTEDOAD IHTEDOAD, t1.IHCOAD IHCOAD, t1.IHCOORAC IHCOORAC, t1.IHNRORAC IHNRORAC, t1.IHNRANAC IHNRANAC, t1.IHNRORAT IHNRORAT, t1.IHCOCPDE IHCOCPDE, t1.IHCOORDE IHCOORDE, t1.IHNRANDE IHNRANDE, t1.IHNRORDE IHNRORDE, t1.IHNRORHD IHNRORHD, t1.IHFEACRE IHFEACRE, t1.IHFECDOI IHFECDOI, t1.IHFECDIN IHFECDIN, t1.IHFERESA IHFERESA, t1.IHTERARD IHTERARD, t1.IHCOTTDD IHCOTTDD, t1.IHCAPTMD IHCAPTMD, t1.IHFECODD IHFECODD, t1.IHCOORD2 IHCOORD2, t1.IHFESET1 IHFESET1, t1.IHFESET2 IHFESET2, t1.IHFESET3 IHFESET3, t1.IHFESET4 IHFESET4, t1.IHFECDD1 IHFECDD1, t1.IHINDREC IHINDREC, t1.IHCOHCDS IHCOHCDS, t1.IHCOADDS IHCOADDS, t1.IHCOEH IHCOEH, t1.IHNRRGEN IHNRRGEN, t2.HCCODIGO DECISIONHECHOHCCODIGO, t2.HCCOOR DECISIONHECHOHCCOOR, t2.HCFEDE DECISIONHECHOHCFEDE, t2.HCFECODE DECISIONHECHOHCFECODE, t2.HCCOORPROP DECISIONHECHOHCCOORPROP, t2.HCCOORTRASINHIBI DECISIONHECHOHCCOORTRI, t2.HCCOHD DECISIONHECHOHCCOHD, t2.HCCOTTD DECISIONHECHOHCCOTTD "
				+ "FROM TRASLADO t1 , DECISION_HECHO t2  "
				+ "WHERE t1.IHCODIGO = ?   AND t1.IHCOHC= t2.HCCODIGO(+)  ";
		return (Traslado) this.jdbcTemplate.queryForObject(query, rwMap,
				traslado.getIhcodigo());
	}

	/**
	 * Finds a single row in the Traslado table.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @return TrasladoBusqueda
	 */
	@Transactional(readOnly = true)
	public TrasladoBusqueda findTraslado(TrasladoBusqueda trasladoBusqueda) {
		// String query =
		// "SELECT t1.IHCODIGO IHCODIGO, t1.IHCOORTR IHCOORTR, t1.IHNRORTR IHNRORTR, t1.IHNRANTR IHNRANTR, t1.IHCOOR IHCOOR, t1.IHNROR IHNROR, t1.IHNRAN IHNRAN, t1.IHININTR IHININTR, t1.IHFEREEN IHFEREEN, t1.IHTEREOR IHTEREOR, t1.IHFEREOR IHFEREOR, t1.IHCOOROR IHCOOROR, t1.IHCOORDT IHCOORDT, t1.IHTEDOAD IHTEDOAD, t1.IHCOAD IHCOAD, t1.IHCOORAC IHCOORAC, t1.IHNRORAC IHNRORAC, t1.IHNRANAC IHNRANAC, t1.IHNRORAT IHNRORAT, t1.IHCOCPDE IHCOCPDE, t1.IHCOORDE IHCOORDE, t1.IHNRANDE IHNRANDE, t1.IHNRORDE IHNRORDE, t1.IHNRORHD IHNRORHD, t1.IHFEACRE IHFEACRE, t1.IHFECDOI IHFECDOI, t1.IHFECDIN IHFECDIN, t1.IHFERESA IHFERESA, t1.IHTERARD IHTERARD, t1.IHCOTTDD IHCOTTDD, t1.IHCAPTMD IHCAPTMD, t1.IHFECODD IHFECODD, t1.IHCOORD2 IHCOORD2, t1.IHFESET1 IHFESET1, t1.IHFESET2 IHFESET2, t1.IHFESET3 IHFESET3, t1.IHFESET4 IHFESET4, t1.IHFECDD1 IHFECDD1, t1.IHINDREC IHINDREC, t1.IHCOHCDS IHCOHCDS, t1.IHCOADDS IHCOADDS, t1.IHCOEH IHCOEH, t1.IHNRRGEN IHNRRGEN, t2.HCCODIGO DECISIONHECHOHCCODIGO, t2.HCCOOR DECISIONHECHOHCCOOR, t2.HCFEDE DECISIONHECHOHCFEDE, t2.HCFECODE DECISIONHECHOHCFECODE, t2.HCCOORPROP DECISIONHECHOHCCOORPROP, t2.HCCOHD DECISIONHECHOHCCOHD, t2.HCCOTTD DECISIONHECHOHCCOTTD "
		// + "FROM TRASLADO t1 , DECISION_HECHO t2  "
		// +
		// "WHERE t1.IHCODIGO = ? AND t1.IHCOOROR = oror.COD_ORG(+) AND t1.IHCOORDT = ordt.COD_ORG(+) AND t1.IHCOHC = t4.HCCODIGO AND t4.HCCOHD = t5.HDCODIGO AND t5.HDCODE = t6.DECODIGO AND t5.HDCODIGO = t7.EHCOHD AND t7.EHCOMO= t8.MOCODIGO";

		StringBuffer query = new StringBuffer(
				"SELECT  t1.IHCODIGO IHCODIGO, t1.IHCOORTR IHCOORTR, t1.IHNRORTR IHNRORTR, t1.IHNRANTR IHNRANTR, t1.IHININTR IHININTR, t1.IHFEREOR IHFEREOR, t1.IHFEREEN IHFEREEN, t1.IHTEDOAD IHTEDOAD, t1.IHCOOROR IHCOOROR, oror.NOMBRE_ES ORGANISMOORNOMBREES, oror.NOMBRE_EU ORGANISMOORNOMBREEU, t1.IHCOORDT IHCOORDT, ordt.NOMBRE_ES ORGANISMODTNOMBREES, ordt.NOMBRE_EU ORGANISMODTNOMBREEU, t6.DECODIGO DECODIGO,t6.DECOOR DECOOR,t6.DENRAN DENRAN,t6.DENROR DENROR, t5.HDCODIGO HDCODIGO,t5.HDNROR HDNROR, t7.EHFECHA EHFECHA, t7.EHHORA EHHORA, t8.MOCODIGO MOCODIGO, t8.MONOMBRE MONOMBRE "
						+ "FROM TRASLADO t1, ORGANISMO oror, ORGANISMO ordt, DECISION_HECHO t4, HECHO_DENUNCIADO t5, DENUNCIA t6, TRAMITE_HECHO t7, CENSO_MONITOR t8 ");
		query.append(" WHERE t1.IHCODIGO = ? AND t1.IHCOOROR = oror.COD_ORG(+) AND t1.IHCOORDT = ordt.COD_ORG(+) AND t1.IHCOHC = t4.HCCODIGO AND t4.HCCOHD = t5.HDCODIGO AND t5.HDCODE = t6.DECODIGO AND t5.HDCODIGO = t7.EHCOHD AND t7.EHCOMO= t8.MOCODIGO(+) AND t1.IHCOEH=t7.EHCODIGO ");

		return (TrasladoBusqueda) this.jdbcTemplate.queryForObject(
				query.toString(), new RowMapper<TrasladoBusqueda>() {
					public TrasladoBusqueda mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {

						return new TrasladoBusqueda(resultSet
								.getString("IHCODIGO"), resultSet
								.getString("IHCOORTR"), resultSet
								.getBigDecimal("IHNRORTR"), resultSet
								.getBigDecimal("IHNRANTR"), resultSet
								.getDate("IHFEREOR"), resultSet
								.getDate("IHFEREEN"), null, null, resultSet
								.getString("IHTEDOAD"), resultSet
								.getString("IHININTR"), resultSet
								.getString("IHCOOROR"), resultSet
								.getString("ORGANISMOORNOMBREES"), resultSet
								.getString("ORGANISMOORNOMBREEU"), resultSet
								.getString("IHCOORDT"), resultSet
								.getString("ORGANISMODTNOMBREES"), resultSet
								.getString("ORGANISMODTNOMBREEU"), null, null,
								resultSet.getString("DECOOR"), resultSet
										.getBigDecimal("DENRAN"), resultSet
										.getBigDecimal("DENROR"), resultSet
										.getString("HDCODIGO"), resultSet
										.getBigDecimal("HDNROR"), resultSet
										.getDate("EHFECHA"), null, null,
								resultSet.getString("EHHORA"), resultSet
										.getString("MOCODIGO"), resultSet
										.getString("MONOMBRE"), null);
					}
				}, trasladoBusqueda.getIhcodigo());
	}

	/**
	 * Finds a single row in the Traslado table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TrasladoBusqueda
	 */
	@Transactional(readOnly = true)
	public TrasladoBusqueda findTrasladoTramite(
			TramiteHechoDetalle tramiteHechoDetalle) {

		StringBuffer query = new StringBuffer(
				"SELECT  t1.IHCODIGO IHCODIGO, t1.IHCOORTR IHCOORTR, t1.IHNRORTR IHNRORTR, t1.IHNRANTR IHNRANTR, t1.IHININTR IHININTR, t1.IHFEREOR IHFEREOR, t1.IHFEREEN IHFEREEN, t1.IHTEDOAD IHTEDOAD, t1.IHCOOROR IHCOOROR, oror.NOMBRE_ES ORGANISMOORNOMBREES, oror.NOMBRE_EU ORGANISMOORNOMBREEU, t1.IHCOORDT IHCOORDT, ordt.NOMBRE_ES ORGANISMODTNOMBREES, ordt.NOMBRE_EU ORGANISMODTNOMBREEU, t6.DECODIGO DECODIGO,t6.DECOOR DECOOR,t6.DENRAN DENRAN,t6.DENROR DENROR, t5.HDCODIGO HDCODIGO,t5.HDNROR HDNROR, t7.EHFECHA EHFECHA, t7.EHHORA EHHORA, t8.MOCODIGO MOCODIGO, t8.MONOMBRE MONOMBRE "
						+ "FROM TRASLADO t1, ORGANISMO oror, ORGANISMO ordt, DECISION_HECHO t4, HECHO_DENUNCIADO t5, DENUNCIA t6, TRAMITE_HECHO t7, CENSO_MONITOR t8 ");
		query.append(" WHERE t1.IHCOEH = ? AND t1.IHCOOROR = oror.COD_ORG(+) AND t1.IHCOORDT = ordt.COD_ORG(+) AND t1.IHCOHC = t4.HCCODIGO AND t4.HCCOHD = t5.HDCODIGO AND t5.HDCODE = t6.DECODIGO AND t5.HDCODIGO = t7.EHCOHD AND t7.EHCOMO= t8.MOCODIGO(+) AND t1.IHCOEH=t7.EHCODIGO ");

		return (TrasladoBusqueda) this.jdbcTemplate.queryForObject(
				query.toString(), new RowMapper<TrasladoBusqueda>() {
					public TrasladoBusqueda mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {

						return new TrasladoBusqueda(resultSet
								.getString("IHCODIGO"), resultSet
								.getString("IHCOORTR"), resultSet
								.getBigDecimal("IHNRORTR"), resultSet
								.getBigDecimal("IHNRANTR"), resultSet
								.getDate("IHFEREOR"), resultSet
								.getDate("IHFEREEN"), null, null, resultSet
								.getString("IHTEDOAD"), resultSet
								.getString("IHININTR"), resultSet
								.getString("IHCOOROR"), resultSet
								.getString("ORGANISMOORNOMBREES"), resultSet
								.getString("ORGANISMOORNOMBREEU"), resultSet
								.getString("IHCOORDT"), resultSet
								.getString("ORGANISMODTNOMBREES"), resultSet
								.getString("ORGANISMODTNOMBREEU"), null, null,
								resultSet.getString("DECOOR"), resultSet
										.getBigDecimal("DENRAN"), resultSet
										.getBigDecimal("DENROR"), resultSet
										.getString("HDCODIGO"), resultSet
										.getBigDecimal("HDNROR"), resultSet
										.getDate("EHFECHA"), null, null,
								resultSet.getString("EHHORA"), resultSet
										.getString("MOCODIGO"), resultSet
										.getString("MONOMBRE"), null);
					}
				}, tramiteHechoDetalle.getEhcodigo());
	}

	/**
	 * Removes a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Pagination
	 * @return
	 */
	public void remove(Traslado traslado) {
		String query = "DELETE  FROM TRASLADO WHERE IHCODIGO=?";
		this.jdbcTemplate.update(query, traslado.getIhcodigo());
	}

	/**
	 * Finds a List of rows in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Traslado> findAll(Traslado traslado, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.IHCOHC= t2.HCCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.IHCODIGO IHCODIGO,t1.IHCOORTR IHCOORTR,t1.IHNRORTR IHNRORTR,t1.IHNRANTR IHNRANTR,t1.IHCOOR IHCOOR,t1.IHNROR IHNROR,t1.IHNRAN IHNRAN,t1.IHININTR IHININTR,t1.IHFEREEN IHFEREEN,t1.IHTEREOR IHTEREOR,t1.IHFEREOR IHFEREOR,t1.IHCOOROR IHCOOROR,t1.IHCOORDT IHCOORDT,t1.IHTEDOAD IHTEDOAD,t1.IHCOAD IHCOAD,t1.IHCOORAC IHCOORAC,t1.IHNRORAC IHNRORAC,t1.IHNRANAC IHNRANAC,t1.IHNRORAT IHNRORAT,t1.IHCOCPDE IHCOCPDE,t1.IHCOORDE IHCOORDE,t1.IHNRANDE IHNRANDE,t1.IHNRORDE IHNRORDE,t1.IHNRORHD IHNRORHD,t1.IHFEACRE IHFEACRE,t1.IHFECDOI IHFECDOI,t1.IHFECDIN IHFECDIN,t1.IHFERESA IHFERESA,t1.IHTERARD IHTERARD,t1.IHCOTTDD IHCOTTDD,t1.IHCAPTMD IHCAPTMD,t1.IHFECODD IHFECODD,t1.IHCOORD2 IHCOORD2,t1.IHFESET1 IHFESET1,t1.IHFESET2 IHFESET2,t1.IHFESET3 IHFESET3,t1.IHFESET4 IHFESET4,t1.IHFECDD1 IHFECDD1,t1.IHINDREC IHINDREC,t1.IHCOHCDS IHCOHCDS,t1.IHCOADDS IHCOADDS,t1.IHCOEH IHCOEH,t1.IHNRRGEN IHNRRGEN,t2.HCCODIGO DECISIONHECHOHCCODIGO,t2.HCCOOR DECISIONHECHOHCCOOR,t2.HCFEDE DECISIONHECHOHCFEDE,t2.HCFECODE DECISIONHECHOHCFECODE,t2.HCCOORPROP DECISIONHECHOHCCOORPROP,t2.HCCOHD DECISIONHECHOHCCOHD,t2.HCCOTTD DECISIONHECHOHCCOTTD "
						+ "FROM TRASLADO t1 ,DECISION_HECHO t2 ");

		if (traslado != null && traslado.getIhcodigo() != null) {
			where.append(" AND t1.IHCODIGO = ?");
			params.add(traslado.getIhcodigo());
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHccodigo() != null) {
			where.append(" AND t2.HCCODIGO = ?");
			params.add(traslado.getDecisionHecho().getHccodigo());
		}
		if (traslado != null
				&& traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHechoDenunciado() != null
				&& traslado.getDecisionHecho().getHechoDenunciado()
						.getHdcodigo() != null) {
			where.append(" AND t2.HCCOHD = ?");
			params.add(traslado.getDecisionHecho().getHechoDenunciado()
					.getHdcodigo());
		}
		if (traslado != null
				&& traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getDecision() != null
				&& traslado.getDecisionHecho().getDecision().getDecodigo() != null) {
			where.append(" AND t2.HCCOTTD = ?");
			params.add(traslado.getDecisionHecho().getDecision().getDecodigo());
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHccoor() != null) {
			where.append(" AND t2.HCCOOR = ?");
			params.add(traslado.getDecisionHecho().getHccoor());
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHcfede() != null) {
			where.append(" AND t2.HCFEDE = ?");
			params.add(traslado.getDecisionHecho().getHcfede());
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHcfecode() != null) {
			where.append(" AND t2.HCFECODE = ?");
			params.add(traslado.getDecisionHecho().getHcfecode());
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHccoorprop() != null) {
			where.append(" AND t2.HCCOORPROP = ?");
			params.add(traslado.getDecisionHecho().getHccoorprop());
		}
		if (traslado != null && traslado.getIhcoortr() != null) {
			where.append(" AND t1.IHCOORTR = ?");
			params.add(traslado.getIhcoortr());
		}
		if (traslado != null && traslado.getIhnrortr() != null) {
			where.append(" AND t1.IHNRORTR = ?");
			params.add(traslado.getIhnrortr());
		}
		if (traslado != null && traslado.getIhnrantr() != null) {
			where.append(" AND t1.IHNRANTR = ?");
			params.add(traslado.getIhnrantr());
		}
		if (traslado != null && traslado.getIhcoor() != null) {
			where.append(" AND t1.IHCOOR = ?");
			params.add(traslado.getIhcoor());
		}
		if (traslado != null && traslado.getIhnror() != null) {
			where.append(" AND t1.IHNROR = ?");
			params.add(traslado.getIhnror());
		}
		if (traslado != null && traslado.getIhnran() != null) {
			where.append(" AND t1.IHNRAN = ?");
			params.add(traslado.getIhnran());
		}
		if (traslado != null && traslado.getIhinintr() != null) {
			where.append(" AND t1.IHININTR = ?");
			params.add(traslado.getIhinintr());
		}
		if (traslado != null && traslado.getIhfereen() != null) {
			where.append(" AND t1.IHFEREEN = ?");
			params.add(traslado.getIhfereen());
		}
		if (traslado != null && traslado.getIhtereor() != null) {
			where.append(" AND t1.IHTEREOR = ?");
			params.add(traslado.getIhtereor());
		}
		if (traslado != null && traslado.getIhfereor() != null) {
			where.append(" AND t1.IHFEREOR = ?");
			params.add(traslado.getIhfereor());
		}
		if (traslado != null && traslado.getIhcooror() != null) {
			where.append(" AND t1.IHCOOROR = ?");
			params.add(traslado.getIhcooror());
		}
		if (traslado != null && traslado.getIhcoordt() != null) {
			where.append(" AND t1.IHCOORDT = ?");
			params.add(traslado.getIhcoordt());
		}
		if (traslado != null && traslado.getIhtedoad() != null) {
			where.append(" AND t1.IHTEDOAD = ?");
			params.add(traslado.getIhtedoad());
		}
		if (traslado != null && traslado.getIhcoad() != null) {
			where.append(" AND t1.IHCOAD = ?");
			params.add(traslado.getIhcoad());
		}
		if (traslado != null && traslado.getIhcoorac() != null) {
			where.append(" AND t1.IHCOORAC = ?");
			params.add(traslado.getIhcoorac());
		}
		if (traslado != null && traslado.getIhnrorac() != null) {
			where.append(" AND t1.IHNRORAC = ?");
			params.add(traslado.getIhnrorac());
		}
		if (traslado != null && traslado.getIhnranac() != null) {
			where.append(" AND t1.IHNRANAC = ?");
			params.add(traslado.getIhnranac());
		}
		if (traslado != null && traslado.getIhnrorat() != null) {
			where.append(" AND t1.IHNRORAT = ?");
			params.add(traslado.getIhnrorat());
		}
		if (traslado != null && traslado.getIhcocpde() != null) {
			where.append(" AND t1.IHCOCPDE = ?");
			params.add(traslado.getIhcocpde());
		}
		if (traslado != null && traslado.getIhcoorde() != null) {
			where.append(" AND t1.IHCOORDE = ?");
			params.add(traslado.getIhcoorde());
		}
		if (traslado != null && traslado.getIhnrande() != null) {
			where.append(" AND t1.IHNRANDE = ?");
			params.add(traslado.getIhnrande());
		}
		if (traslado != null && traslado.getIhnrorde() != null) {
			where.append(" AND t1.IHNRORDE = ?");
			params.add(traslado.getIhnrorde());
		}
		if (traslado != null && traslado.getIhnrorhd() != null) {
			where.append(" AND t1.IHNRORHD = ?");
			params.add(traslado.getIhnrorhd());
		}
		if (traslado != null && traslado.getIhfeacre() != null) {
			where.append(" AND t1.IHFEACRE = ?");
			params.add(traslado.getIhfeacre());
		}
		if (traslado != null && traslado.getIhfecdoi() != null) {
			where.append(" AND t1.IHFECDOI = ?");
			params.add(traslado.getIhfecdoi());
		}
		if (traslado != null && traslado.getIhfecdin() != null) {
			where.append(" AND t1.IHFECDIN = ?");
			params.add(traslado.getIhfecdin());
		}
		if (traslado != null && traslado.getIhferesa() != null) {
			where.append(" AND t1.IHFERESA = ?");
			params.add(traslado.getIhferesa());
		}
		if (traslado != null && traslado.getIhterard() != null) {
			where.append(" AND t1.IHTERARD = ?");
			params.add(traslado.getIhterard());
		}
		if (traslado != null && traslado.getIhcottdd() != null) {
			where.append(" AND t1.IHCOTTDD = ?");
			params.add(traslado.getIhcottdd());
		}
		if (traslado != null && traslado.getIhcaptmd() != null) {
			where.append(" AND t1.IHCAPTMD = ?");
			params.add(traslado.getIhcaptmd());
		}
		if (traslado != null && traslado.getIhfecodd() != null) {
			where.append(" AND t1.IHFECODD = ?");
			params.add(traslado.getIhfecodd());
		}
		if (traslado != null && traslado.getIhcoord2() != null) {
			where.append(" AND t1.IHCOORD2 = ?");
			params.add(traslado.getIhcoord2());
		}
		if (traslado != null && traslado.getIhfeset1() != null) {
			where.append(" AND t1.IHFESET1 = ?");
			params.add(traslado.getIhfeset1());
		}
		if (traslado != null && traslado.getIhfeset2() != null) {
			where.append(" AND t1.IHFESET2 = ?");
			params.add(traslado.getIhfeset2());
		}
		if (traslado != null && traslado.getIhfeset3() != null) {
			where.append(" AND t1.IHFESET3 = ?");
			params.add(traslado.getIhfeset3());
		}
		if (traslado != null && traslado.getIhfeset4() != null) {
			where.append(" AND t1.IHFESET4 = ?");
			params.add(traslado.getIhfeset4());
		}
		if (traslado != null && traslado.getIhfecdd1() != null) {
			where.append(" AND t1.IHFECDD1 = ?");
			params.add(traslado.getIhfecdd1());
		}
		if (traslado != null && traslado.getIhindrec() != null) {
			where.append(" AND t1.IHINDREC = ?");
			params.add(traslado.getIhindrec());
		}
		if (traslado != null && traslado.getIhcohcds() != null) {
			where.append(" AND t1.IHCOHCDS = ?");
			params.add(traslado.getIhcohcds());
		}
		if (traslado != null && traslado.getIhcoadds() != null) {
			where.append(" AND t1.IHCOADDS = ?");
			params.add(traslado.getIhcoadds());
		}
		if (traslado != null && traslado.getIhcoeh() != null) {
			where.append(" AND t1.IHCOEH = ?");
			params.add(traslado.getIhcoeh());
		}
		if (traslado != null && traslado.getIhnrrgen() != null) {
			where.append(" AND t1.IHNRRGEN = ?");
			params.add(traslado.getIhnrrgen());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Traslado>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Traslado traslado) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.IHCOHC= t2.HCCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  TRASLADO t1   ,  DECISION_HECHO t2  ");
		if (traslado != null && traslado.getIhcodigo() != null) {
			where.append(" AND t1.IHCODIGO = ?");
			params.add(traslado.getIhcodigo());
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHccodigo() != null) {
			where.append(" AND t2.HCCODIGO = ?");
			params.add(traslado.getDecisionHecho().getHccodigo());
		}
		if (traslado != null
				&& traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHechoDenunciado() != null
				&& traslado.getDecisionHecho().getHechoDenunciado()
						.getHdcodigo() != null) {
			where.append(" AND t2.HCCOHD = ?");
			params.add(traslado.getDecisionHecho().getHechoDenunciado()
					.getHdcodigo());
		}
		if (traslado != null
				&& traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getDecision() != null
				&& traslado.getDecisionHecho().getDecision().getDecodigo() != null) {
			where.append(" AND t2.HCCOTTD = ?");
			params.add(traslado.getDecisionHecho().getDecision().getDecodigo());
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHccoor() != null) {
			where.append(" AND t2.HCCOOR = ?");
			params.add(traslado.getDecisionHecho().getHccoor());
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHcfede() != null) {
			where.append(" AND t2.HCFEDE = ?");
			params.add(traslado.getDecisionHecho().getHcfede());
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHcfecode() != null) {
			where.append(" AND t2.HCFECODE = ?");
			params.add(traslado.getDecisionHecho().getHcfecode());
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHccoorprop() != null) {
			where.append(" AND t2.HCCOORPROP = ?");
			params.add(traslado.getDecisionHecho().getHccoorprop());
		}
		if (traslado != null && traslado.getIhcoortr() != null) {
			where.append(" AND t1.IHCOORTR = ?");
			params.add(traslado.getIhcoortr());
		}
		if (traslado != null && traslado.getIhnrortr() != null) {
			where.append(" AND t1.IHNRORTR = ?");
			params.add(traslado.getIhnrortr());
		}
		if (traslado != null && traslado.getIhnrantr() != null) {
			where.append(" AND t1.IHNRANTR = ?");
			params.add(traslado.getIhnrantr());
		}
		if (traslado != null && traslado.getIhcoor() != null) {
			where.append(" AND t1.IHCOOR = ?");
			params.add(traslado.getIhcoor());
		}
		if (traslado != null && traslado.getIhnror() != null) {
			where.append(" AND t1.IHNROR = ?");
			params.add(traslado.getIhnror());
		}
		if (traslado != null && traslado.getIhnran() != null) {
			where.append(" AND t1.IHNRAN = ?");
			params.add(traslado.getIhnran());
		}
		if (traslado != null && traslado.getIhinintr() != null) {
			where.append(" AND t1.IHININTR = ?");
			params.add(traslado.getIhinintr());
		}
		if (traslado != null && traslado.getIhfereen() != null) {
			where.append(" AND t1.IHFEREEN = ?");
			params.add(traslado.getIhfereen());
		}
		if (traslado != null && traslado.getIhtereor() != null) {
			where.append(" AND t1.IHTEREOR = ?");
			params.add(traslado.getIhtereor());
		}
		if (traslado != null && traslado.getIhfereor() != null) {
			where.append(" AND t1.IHFEREOR = ?");
			params.add(traslado.getIhfereor());
		}
		if (traslado != null && traslado.getIhcooror() != null) {
			where.append(" AND t1.IHCOOROR = ?");
			params.add(traslado.getIhcooror());
		}
		if (traslado != null && traslado.getIhcoordt() != null) {
			where.append(" AND t1.IHCOORDT = ?");
			params.add(traslado.getIhcoordt());
		}
		if (traslado != null && traslado.getIhtedoad() != null) {
			where.append(" AND t1.IHTEDOAD = ?");
			params.add(traslado.getIhtedoad());
		}
		if (traslado != null && traslado.getIhcoad() != null) {
			where.append(" AND t1.IHCOAD = ?");
			params.add(traslado.getIhcoad());
		}
		if (traslado != null && traslado.getIhcoorac() != null) {
			where.append(" AND t1.IHCOORAC = ?");
			params.add(traslado.getIhcoorac());
		}
		if (traslado != null && traslado.getIhnrorac() != null) {
			where.append(" AND t1.IHNRORAC = ?");
			params.add(traslado.getIhnrorac());
		}
		if (traslado != null && traslado.getIhnranac() != null) {
			where.append(" AND t1.IHNRANAC = ?");
			params.add(traslado.getIhnranac());
		}
		if (traslado != null && traslado.getIhnrorat() != null) {
			where.append(" AND t1.IHNRORAT = ?");
			params.add(traslado.getIhnrorat());
		}
		if (traslado != null && traslado.getIhcocpde() != null) {
			where.append(" AND t1.IHCOCPDE = ?");
			params.add(traslado.getIhcocpde());
		}
		if (traslado != null && traslado.getIhcoorde() != null) {
			where.append(" AND t1.IHCOORDE = ?");
			params.add(traslado.getIhcoorde());
		}
		if (traslado != null && traslado.getIhnrande() != null) {
			where.append(" AND t1.IHNRANDE = ?");
			params.add(traslado.getIhnrande());
		}
		if (traslado != null && traslado.getIhnrorde() != null) {
			where.append(" AND t1.IHNRORDE = ?");
			params.add(traslado.getIhnrorde());
		}
		if (traslado != null && traslado.getIhnrorhd() != null) {
			where.append(" AND t1.IHNRORHD = ?");
			params.add(traslado.getIhnrorhd());
		}
		if (traslado != null && traslado.getIhfeacre() != null) {
			where.append(" AND t1.IHFEACRE = ?");
			params.add(traslado.getIhfeacre());
		}
		if (traslado != null && traslado.getIhfecdoi() != null) {
			where.append(" AND t1.IHFECDOI = ?");
			params.add(traslado.getIhfecdoi());
		}
		if (traslado != null && traslado.getIhfecdin() != null) {
			where.append(" AND t1.IHFECDIN = ?");
			params.add(traslado.getIhfecdin());
		}
		if (traslado != null && traslado.getIhferesa() != null) {
			where.append(" AND t1.IHFERESA = ?");
			params.add(traslado.getIhferesa());
		}
		if (traslado != null && traslado.getIhterard() != null) {
			where.append(" AND t1.IHTERARD = ?");
			params.add(traslado.getIhterard());
		}
		if (traslado != null && traslado.getIhcottdd() != null) {
			where.append(" AND t1.IHCOTTDD = ?");
			params.add(traslado.getIhcottdd());
		}
		if (traslado != null && traslado.getIhcaptmd() != null) {
			where.append(" AND t1.IHCAPTMD = ?");
			params.add(traslado.getIhcaptmd());
		}
		if (traslado != null && traslado.getIhfecodd() != null) {
			where.append(" AND t1.IHFECODD = ?");
			params.add(traslado.getIhfecodd());
		}
		if (traslado != null && traslado.getIhcoord2() != null) {
			where.append(" AND t1.IHCOORD2 = ?");
			params.add(traslado.getIhcoord2());
		}
		if (traslado != null && traslado.getIhfeset1() != null) {
			where.append(" AND t1.IHFESET1 = ?");
			params.add(traslado.getIhfeset1());
		}
		if (traslado != null && traslado.getIhfeset2() != null) {
			where.append(" AND t1.IHFESET2 = ?");
			params.add(traslado.getIhfeset2());
		}
		if (traslado != null && traslado.getIhfeset3() != null) {
			where.append(" AND t1.IHFESET3 = ?");
			params.add(traslado.getIhfeset3());
		}
		if (traslado != null && traslado.getIhfeset4() != null) {
			where.append(" AND t1.IHFESET4 = ?");
			params.add(traslado.getIhfeset4());
		}
		if (traslado != null && traslado.getIhfecdd1() != null) {
			where.append(" AND t1.IHFECDD1 = ?");
			params.add(traslado.getIhfecdd1());
		}
		if (traslado != null && traslado.getIhindrec() != null) {
			where.append(" AND t1.IHINDREC = ?");
			params.add(traslado.getIhindrec());
		}
		if (traslado != null && traslado.getIhcohcds() != null) {
			where.append(" AND t1.IHCOHCDS = ?");
			params.add(traslado.getIhcohcds());
		}
		if (traslado != null && traslado.getIhcoadds() != null) {
			where.append(" AND t1.IHCOADDS = ?");
			params.add(traslado.getIhcoadds());
		}
		if (traslado != null && traslado.getIhcoeh() != null) {
			where.append(" AND t1.IHCOEH = ?");
			params.add(traslado.getIhcoeh());
		}
		if (traslado != null && traslado.getIhnrrgen() != null) {
			where.append(" AND t1.IHNRRGEN = ?");
			params.add(traslado.getIhnrrgen());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Traslado table using like.
	 * 
	 * @param traslado
	 *            Traslado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Traslado> findAllLike(Traslado traslado, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.IHCOHC= t2.HCCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.IHCODIGO IHCODIGO,t1.IHCOORTR IHCOORTR,t1.IHNRORTR IHNRORTR,t1.IHNRANTR IHNRANTR,t1.IHCOOR IHCOOR,t1.IHNROR IHNROR,t1.IHNRAN IHNRAN,t1.IHININTR IHININTR,t1.IHFEREEN IHFEREEN,t1.IHTEREOR IHTEREOR,t1.IHFEREOR IHFEREOR,t1.IHCOOROR IHCOOROR,t1.IHCOORDT IHCOORDT,t1.IHTEDOAD IHTEDOAD,t1.IHCOAD IHCOAD,t1.IHCOORAC IHCOORAC,t1.IHNRORAC IHNRORAC,t1.IHNRANAC IHNRANAC,t1.IHNRORAT IHNRORAT,t1.IHCOCPDE IHCOCPDE,t1.IHCOORDE IHCOORDE,t1.IHNRANDE IHNRANDE,t1.IHNRORDE IHNRORDE,t1.IHNRORHD IHNRORHD,t1.IHFEACRE IHFEACRE,t1.IHFECDOI IHFECDOI,t1.IHFECDIN IHFECDIN,t1.IHFERESA IHFERESA,t1.IHTERARD IHTERARD,t1.IHCOTTDD IHCOTTDD,t1.IHCAPTMD IHCAPTMD,t1.IHFECODD IHFECODD,t1.IHCOORD2 IHCOORD2,t1.IHFESET1 IHFESET1,t1.IHFESET2 IHFESET2,t1.IHFESET3 IHFESET3,t1.IHFESET4 IHFESET4,t1.IHFECDD1 IHFECDD1,t1.IHINDREC IHINDREC,t1.IHCOHCDS IHCOHCDS,t1.IHCOADDS IHCOADDS,t1.IHCOEH IHCOEH,t1.IHNRRGEN IHNRRGEN,t2.HCCODIGO DECISIONHECHOHCCODIGO,t2.HCCOOR DECISIONHECHOHCCOOR,t2.HCFEDE DECISIONHECHOHCFEDE,t2.HCFECODE DECISIONHECHOHCFECODE,t2.HCCOORPROP DECISIONHECHOHCCOORPROP, t2.HCCOORTRASINHIBI DECISIONHECHOHCCOORTRI, t2.HCCOHD DECISIONHECHOHCCOHD,t2.HCCOTTD DECISIONHECHOHCCOTTD "
						+ "FROM TRASLADO t1 ,DECISION_HECHO t2 ");

		if (traslado != null && traslado.getIhcodigo() != null) {
			where.append(" AND UPPER(t1.IHCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.IHCODIGO IS NOT NULL");
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHccodigo() != null) {
			where.append(" AND t2.HCCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getDecisionHecho().getHccodigo() + "%");
			} else {
				params.add("%" + traslado.getDecisionHecho().getHccodigo()
						+ "%");
			}
			where.append(" AND t2.HCCODIGO IS NOT NULL");
		}
		if (traslado != null
				&& traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHechoDenunciado() != null
				&& traslado.getDecisionHecho().getHechoDenunciado()
						.getHdcodigo() != null) {
			where.append(" AND UPPER(t2.HCCOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getDecisionHecho().getHechoDenunciado()
						.getHdcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ traslado.getDecisionHecho().getHechoDenunciado()
								.getHdcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HCCOHD IS NOT NULL");
		}
		if (traslado != null
				&& traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getDecision() != null
				&& traslado.getDecisionHecho().getDecision().getDecodigo() != null) {
			where.append(" AND UPPER(t2.HCCOTTD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getDecisionHecho().getDecision()
						.getDecodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ traslado.getDecisionHecho().getDecision()
								.getDecodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HCCOTTD IS NOT NULL");
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHccoor() != null) {
			where.append(" AND UPPER(t2.HCCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getDecisionHecho().getHccoor()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ traslado.getDecisionHecho().getHccoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.HCCOOR IS NOT NULL");
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHcfede() != null) {
			where.append(" AND t2.HCFEDE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getDecisionHecho().getHcfede() + "%");
			} else {
				params.add("%" + traslado.getDecisionHecho().getHcfede() + "%");
			}
			where.append(" AND t2.HCFEDE IS NOT NULL");
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHcfecode() != null) {
			where.append(" AND t2.HCFECODE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getDecisionHecho().getHcfecode() + "%");
			} else {
				params.add("%" + traslado.getDecisionHecho().getHcfecode()
						+ "%");
			}
			where.append(" AND t2.HCFECODE IS NOT NULL");
		}
		if (traslado != null && traslado.getDecisionHecho() != null
				&& traslado.getDecisionHecho().getHccoorprop() != null) {
			where.append(" AND UPPER(t2.HCCOORPROP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getDecisionHecho().getHccoorprop()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ traslado.getDecisionHecho().getHccoorprop()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HCCOORPROP IS NOT NULL");
		}
		if (traslado != null && traslado.getIhcoortr() != null) {
			where.append(" AND UPPER(t1.IHCOORTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcoortr().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhcoortr().toUpperCase() + "%");
			}
			where.append(" AND t1.IHCOORTR IS NOT NULL");
		}
		if (traslado != null && traslado.getIhnrortr() != null) {
			where.append(" AND t1.IHNRORTR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhnrortr() + "%");
			} else {
				params.add("%" + traslado.getIhnrortr() + "%");
			}
			where.append(" AND t1.IHNRORTR IS NOT NULL");
		}
		if (traslado != null && traslado.getIhnrantr() != null) {
			where.append(" AND t1.IHNRANTR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhnrantr() + "%");
			} else {
				params.add("%" + traslado.getIhnrantr() + "%");
			}
			where.append(" AND t1.IHNRANTR IS NOT NULL");
		}
		if (traslado != null && traslado.getIhcoor() != null) {
			where.append(" AND UPPER(t1.IHCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcoor().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.IHCOOR IS NOT NULL");
		}
		if (traslado != null && traslado.getIhnror() != null) {
			where.append(" AND t1.IHNROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhnror() + "%");
			} else {
				params.add("%" + traslado.getIhnror() + "%");
			}
			where.append(" AND t1.IHNROR IS NOT NULL");
		}
		if (traslado != null && traslado.getIhnran() != null) {
			where.append(" AND t1.IHNRAN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhnran() + "%");
			} else {
				params.add("%" + traslado.getIhnran() + "%");
			}
			where.append(" AND t1.IHNRAN IS NOT NULL");
		}
		if (traslado != null && traslado.getIhinintr() != null) {
			where.append(" AND UPPER(t1.IHININTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhinintr().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhinintr().toUpperCase() + "%");
			}
			where.append(" AND t1.IHININTR IS NOT NULL");
		}
		if (traslado != null && traslado.getIhfereen() != null) {
			where.append(" AND t1.IHFEREEN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhfereen() + "%");
			} else {
				params.add("%" + traslado.getIhfereen() + "%");
			}
			where.append(" AND t1.IHFEREEN IS NOT NULL");
		}
		if (traslado != null && traslado.getIhtereor() != null) {
			where.append(" AND UPPER(t1.IHTEREOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhtereor().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhtereor().toUpperCase() + "%");
			}
			where.append(" AND t1.IHTEREOR IS NOT NULL");
		}
		if (traslado != null && traslado.getIhfereor() != null) {
			where.append(" AND t1.IHFEREOR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhfereor() + "%");
			} else {
				params.add("%" + traslado.getIhfereor() + "%");
			}
			where.append(" AND t1.IHFEREOR IS NOT NULL");
		}
		if (traslado != null && traslado.getIhcooror() != null) {
			where.append(" AND UPPER(t1.IHCOOROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcooror().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhcooror().toUpperCase() + "%");
			}
			where.append(" AND t1.IHCOOROR IS NOT NULL");
		}
		if (traslado != null && traslado.getIhcoordt() != null) {
			where.append(" AND UPPER(t1.IHCOORDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcoordt().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhcoordt().toUpperCase() + "%");
			}
			where.append(" AND t1.IHCOORDT IS NOT NULL");
		}
		if (traslado != null && traslado.getIhtedoad() != null) {
			where.append(" AND UPPER(t1.IHTEDOAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhtedoad().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhtedoad().toUpperCase() + "%");
			}
			where.append(" AND t1.IHTEDOAD IS NOT NULL");
		}
		if (traslado != null && traslado.getIhcoad() != null) {
			where.append(" AND UPPER(t1.IHCOAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcoad().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhcoad().toUpperCase() + "%");
			}
			where.append(" AND t1.IHCOAD IS NOT NULL");
		}
		if (traslado != null && traslado.getIhcoorac() != null) {
			where.append(" AND UPPER(t1.IHCOORAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcoorac().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhcoorac().toUpperCase() + "%");
			}
			where.append(" AND t1.IHCOORAC IS NOT NULL");
		}
		if (traslado != null && traslado.getIhnrorac() != null) {
			where.append(" AND UPPER(t1.IHNRORAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhnrorac().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhnrorac().toUpperCase() + "%");
			}
			where.append(" AND t1.IHNRORAC IS NOT NULL");
		}
		if (traslado != null && traslado.getIhnranac() != null) {
			where.append(" AND t1.IHNRANAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhnranac() + "%");
			} else {
				params.add("%" + traslado.getIhnranac() + "%");
			}
			where.append(" AND t1.IHNRANAC IS NOT NULL");
		}
		if (traslado != null && traslado.getIhnrorat() != null) {
			where.append(" AND t1.IHNRORAT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhnrorat() + "%");
			} else {
				params.add("%" + traslado.getIhnrorat() + "%");
			}
			where.append(" AND t1.IHNRORAT IS NOT NULL");
		}
		if (traslado != null && traslado.getIhcocpde() != null) {
			where.append(" AND UPPER(t1.IHCOCPDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcocpde().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhcocpde().toUpperCase() + "%");
			}
			where.append(" AND t1.IHCOCPDE IS NOT NULL");
		}
		if (traslado != null && traslado.getIhcoorde() != null) {
			where.append(" AND UPPER(t1.IHCOORDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcoorde().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhcoorde().toUpperCase() + "%");
			}
			where.append(" AND t1.IHCOORDE IS NOT NULL");
		}
		if (traslado != null && traslado.getIhnrande() != null) {
			where.append(" AND t1.IHNRANDE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhnrande() + "%");
			} else {
				params.add("%" + traslado.getIhnrande() + "%");
			}
			where.append(" AND t1.IHNRANDE IS NOT NULL");
		}
		if (traslado != null && traslado.getIhnrorde() != null) {
			where.append(" AND t1.IHNRORDE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhnrorde() + "%");
			} else {
				params.add("%" + traslado.getIhnrorde() + "%");
			}
			where.append(" AND t1.IHNRORDE IS NOT NULL");
		}
		if (traslado != null && traslado.getIhnrorhd() != null) {
			where.append(" AND t1.IHNRORHD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhnrorhd() + "%");
			} else {
				params.add("%" + traslado.getIhnrorhd() + "%");
			}
			where.append(" AND t1.IHNRORHD IS NOT NULL");
		}
		if (traslado != null && traslado.getIhfeacre() != null) {
			where.append(" AND t1.IHFEACRE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhfeacre() + "%");
			} else {
				params.add("%" + traslado.getIhfeacre() + "%");
			}
			where.append(" AND t1.IHFEACRE IS NOT NULL");
		}
		if (traslado != null && traslado.getIhfecdoi() != null) {
			where.append(" AND t1.IHFECDOI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhfecdoi() + "%");
			} else {
				params.add("%" + traslado.getIhfecdoi() + "%");
			}
			where.append(" AND t1.IHFECDOI IS NOT NULL");
		}
		if (traslado != null && traslado.getIhfecdin() != null) {
			where.append(" AND t1.IHFECDIN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhfecdin() + "%");
			} else {
				params.add("%" + traslado.getIhfecdin() + "%");
			}
			where.append(" AND t1.IHFECDIN IS NOT NULL");
		}
		if (traslado != null && traslado.getIhferesa() != null) {
			where.append(" AND t1.IHFERESA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhferesa() + "%");
			} else {
				params.add("%" + traslado.getIhferesa() + "%");
			}
			where.append(" AND t1.IHFERESA IS NOT NULL");
		}
		if (traslado != null && traslado.getIhterard() != null) {
			where.append(" AND UPPER(t1.IHTERARD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhterard().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhterard().toUpperCase() + "%");
			}
			where.append(" AND t1.IHTERARD IS NOT NULL");
		}
		if (traslado != null && traslado.getIhcottdd() != null) {
			where.append(" AND UPPER(t1.IHCOTTDD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcottdd().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhcottdd().toUpperCase() + "%");
			}
			where.append(" AND t1.IHCOTTDD IS NOT NULL");
		}
		if (traslado != null && traslado.getIhcaptmd() != null) {
			where.append(" AND t1.IHCAPTMD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcaptmd() + "%");
			} else {
				params.add("%" + traslado.getIhcaptmd() + "%");
			}
			where.append(" AND t1.IHCAPTMD IS NOT NULL");
		}
		if (traslado != null && traslado.getIhfecodd() != null) {
			where.append(" AND t1.IHFECODD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhfecodd() + "%");
			} else {
				params.add("%" + traslado.getIhfecodd() + "%");
			}
			where.append(" AND t1.IHFECODD IS NOT NULL");
		}
		if (traslado != null && traslado.getIhcoord2() != null) {
			where.append(" AND UPPER(t1.IHCOORD2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcoord2().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhcoord2().toUpperCase() + "%");
			}
			where.append(" AND t1.IHCOORD2 IS NOT NULL");
		}
		if (traslado != null && traslado.getIhfeset1() != null) {
			where.append(" AND t1.IHFESET1 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhfeset1() + "%");
			} else {
				params.add("%" + traslado.getIhfeset1() + "%");
			}
			where.append(" AND t1.IHFESET1 IS NOT NULL");
		}
		if (traslado != null && traslado.getIhfeset2() != null) {
			where.append(" AND t1.IHFESET2 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhfeset2() + "%");
			} else {
				params.add("%" + traslado.getIhfeset2() + "%");
			}
			where.append(" AND t1.IHFESET2 IS NOT NULL");
		}
		if (traslado != null && traslado.getIhfeset3() != null) {
			where.append(" AND t1.IHFESET3 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhfeset3() + "%");
			} else {
				params.add("%" + traslado.getIhfeset3() + "%");
			}
			where.append(" AND t1.IHFESET3 IS NOT NULL");
		}
		if (traslado != null && traslado.getIhfeset4() != null) {
			where.append(" AND t1.IHFESET4 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhfeset4() + "%");
			} else {
				params.add("%" + traslado.getIhfeset4() + "%");
			}
			where.append(" AND t1.IHFESET4 IS NOT NULL");
		}
		if (traslado != null && traslado.getIhfecdd1() != null) {
			where.append(" AND t1.IHFECDD1 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhfecdd1() + "%");
			} else {
				params.add("%" + traslado.getIhfecdd1() + "%");
			}
			where.append(" AND t1.IHFECDD1 IS NOT NULL");
		}
		if (traslado != null && traslado.getIhindrec() != null) {
			where.append(" AND UPPER(t1.IHINDREC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhindrec().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhindrec().toUpperCase() + "%");
			}
			where.append(" AND t1.IHINDREC IS NOT NULL");
		}
		if (traslado != null && traslado.getIhcohcds() != null) {
			where.append(" AND UPPER(t1.IHCOHCDS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcohcds().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhcohcds().toUpperCase() + "%");
			}
			where.append(" AND t1.IHCOHCDS IS NOT NULL");
		}
		if (traslado != null && traslado.getIhcoadds() != null) {
			where.append(" AND UPPER(t1.IHCOADDS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcoadds().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhcoadds().toUpperCase() + "%");
			}
			where.append(" AND t1.IHCOADDS IS NOT NULL");
		}
		if (traslado != null && traslado.getIhcoeh() != null) {
			where.append(" AND UPPER(t1.IHCOEH) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhcoeh().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhcoeh().toUpperCase() + "%");
			}
			where.append(" AND t1.IHCOEH IS NOT NULL");
		}
		if (traslado != null && traslado.getIhnrrgen() != null) {
			where.append(" AND UPPER(t1.IHNRRGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(traslado.getIhnrrgen().toUpperCase() + "%");
			} else {
				params.add("%" + traslado.getIhnrrgen().toUpperCase() + "%");
			}
			where.append(" AND t1.IHNRRGEN IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Traslado>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Busca los traslados en la tabla. El organismo destino del traslado debe
	 * estar en la tabla de Organismos Solicitudes.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TrasladoBusqueda> findAllTraslado(
			TrasladoBusqueda trasladoBusqueda, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.IHCOOROR = oror.COD_ORG(+) AND t1.IHCOORDT = ordt.COD_ORG AND t1.IHCOHC = t4.HCCODIGO AND t4.HCCOHD = t5.HDCODIGO AND t5.HDCODE = t6.DECODIGO AND t5.HDCODIGO = t7.EHCOHD AND t7.EHCOMO= t8.MOCODIGO(+) AND t1.IHCOEH=t7.EHCODIGO ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.IHCODIGO IHCODIGO, t1.IHCOORTR IHCOORTR, t1.IHNRORTR IHNRORTR, t1.IHNRANTR IHNRANTR, t1.IHININTR IHININTR, t1.IHFEREOR IHFEREOR, t1.IHFEREEN IHFEREEN, t1.IHTEDOAD IHTEDOAD, t1.IHCOOROR IHCOOROR, oror.NOMBRE_ES ORGANISMOORNOMBREES, oror.NOMBRE_EU ORGANISMOORNOMBREEU, t1.IHCOORDT IHCOORDT, ordt.NOMBRE_ES ORGANISMODTNOMBREES, ordt.NOMBRE_EU ORGANISMODTNOMBREEU, t6.DECODIGO DECODIGO,t6.DECOOR DECOOR,t6.DENRAN DENRAN,t6.DENROR DENROR, t5.HDCODIGO HDCODIGO,t5.HDNROR HDNROR, t7.EHFECHA EHFECHA, t7.EHHORA EHHORA, t8.MOCODIGO MOCODIGO, t8.MONOMBRE MONOMBRE "
						+ "FROM TRASLADO t1, ORGANISMO oror, ORGANISMO_CREAR_SOLICITUDES ordt, DECISION_HECHO t4, HECHO_DENUNCIADO t5, DENUNCIA t6, TRAMITE_HECHO t7, CENSO_MONITOR t8 ");

		// Organismo origen
		if (trasladoBusqueda != null && trasladoBusqueda.getIhcooror() != null) {
			where.append(" AND t1.IHCOOROR = ?");
			params.add(trasladoBusqueda.getIhcooror());
		}

		// Organismo destino
		if (trasladoBusqueda != null && trasladoBusqueda.getIhcoordt() != null) {
			where.append(" AND t1.IHCOORDT = ?");
			params.add(trasladoBusqueda.getIhcoordt());
		}

		// Organismo transmision
		if (trasladoBusqueda != null && trasladoBusqueda.getIhcoortr() != null) {
			where.append(" AND t1.IHCOORTR = ?");
			params.add(trasladoBusqueda.getIhcoortr());
		}

		// Numero orden transmision
		if (trasladoBusqueda != null && trasladoBusqueda.getIhnrortr() != null) {
			where.append(" AND t1.IHNRORTR = ?");
			params.add(trasladoBusqueda.getIhnrortr());
		}

		// Numero año transmision
		if (trasladoBusqueda != null && trasladoBusqueda.getIhnrantr() != null) {
			where.append(" AND t1.IHNRANTR = ?");
			params.add(trasladoBusqueda.getIhnrantr());
		}

		/*
		 * Fechas desde hasta del envio de la transmision.
		 */
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getEhfechaDesde() != null) {
			where.append(" AND t7.EHFECHA >= ?");
			params.add(trasladoBusqueda.getEhfechaDesde());
		}
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getEhfechaHasta() != null) {
			where.append(" AND t7.EHFECHA <= ?");
			params.add(trasladoBusqueda.getEhfechaHasta());
		}

		/*
		 * Fechas desde hasta de la recepcion de la operacion.
		 */
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getIhfereenDesde() != null) {
			where.append(" AND t1.IHFEREEN >= ?");
			params.add(trasladoBusqueda.getIhfereenDesde());
		}
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getIhfereenHasta() != null) {
			where.append(" AND t1.IHFEREEN <= ?");
			params.add(trasladoBusqueda.getIhfereenHasta());
		}

		if (trasladoBusqueda != null
				&& trasladoBusqueda.getSinRecepcionarDestino() != null) {
			where.append(" AND t1.IHFEREEN IS NULL");
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc() + " NULLS LAST ");
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TrasladoBusqueda>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<TrasladoBusqueda>() {
					public TrasladoBusqueda mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {

						return new TrasladoBusqueda(resultSet
								.getString("IHCODIGO"), resultSet
								.getString("IHCOORTR"), resultSet
								.getBigDecimal("IHNRORTR"), resultSet
								.getBigDecimal("IHNRANTR"), resultSet
								.getDate("IHFEREOR"), resultSet
								.getDate("IHFEREEN"), null, null, resultSet
								.getString("IHTEDOAD"), resultSet
								.getString("IHININTR"), resultSet
								.getString("IHCOOROR"), resultSet
								.getString("ORGANISMOORNOMBREES"), resultSet
								.getString("ORGANISMOORNOMBREEU"), resultSet
								.getString("IHCOORDT"), resultSet
								.getString("ORGANISMODTNOMBREES"), resultSet
								.getString("ORGANISMODTNOMBREEU"), null, null,
								resultSet.getString("DECOOR"), resultSet
										.getBigDecimal("DENRAN"), resultSet
										.getBigDecimal("DENROR"), resultSet
										.getString("HDCODIGO"), resultSet
										.getBigDecimal("HDNROR"), resultSet
										.getDate("EHFECHA"), null, null,
								resultSet.getString("EHHORA"), resultSet
										.getString("MOCODIGO"), resultSet
										.getString("MONOMBRE"), null);
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the Traslado table.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTrasladoCount(TrasladoBusqueda trasladoBusqueda) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.IHCOOROR = oror.COD_ORG(+) AND t1.IHCOORDT = ordt.COD_ORG AND t1.IHCOHC = t4.HCCODIGO AND t4.HCCOHD = t5.HDCODIGO AND t5.HDCODE = t6.DECODIGO AND t5.HDCODIGO = t7.EHCOHD AND t7.EHCOMO= t8.MOCODIGO(+) AND t1.IHCOEH=t7.EHCODIGO ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRASLADO t1, ORGANISMO oror, ORGANISMO_CREAR_SOLICITUDES ordt, DECISION_HECHO t4, HECHO_DENUNCIADO t5, DENUNCIA t6, TRAMITE_HECHO t7, CENSO_MONITOR t8");

		// Organismo origen
		if (trasladoBusqueda != null && trasladoBusqueda.getIhcooror() != null) {
			where.append(" AND t1.IHCOOROR = ?");
			params.add(trasladoBusqueda.getIhcooror());
		}

		// Organismo destino
		if (trasladoBusqueda != null && trasladoBusqueda.getIhcoordt() != null) {
			where.append(" AND t1.IHCOORDT = ?");
			params.add(trasladoBusqueda.getIhcoordt());
		}

		// Organismo transmision
		if (trasladoBusqueda != null && trasladoBusqueda.getIhcoortr() != null) {
			where.append(" AND t1.IHCOORTR = ?");
			params.add(trasladoBusqueda.getIhcoortr());
		}

		// Numero orden transmision
		if (trasladoBusqueda != null && trasladoBusqueda.getIhnrortr() != null) {
			where.append(" AND t1.IHNRORTR = ?");
			params.add(trasladoBusqueda.getIhnrortr());
		}

		// Numero año transmision
		if (trasladoBusqueda != null && trasladoBusqueda.getIhnrantr() != null) {
			where.append(" AND t1.IHNRANTR = ?");
			params.add(trasladoBusqueda.getIhnrantr());
		}

		/*
		 * Fechas desde hasta del envio de la transmision.
		 */
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getEhfechaDesde() != null) {
			where.append(" AND t7.EHFECHA >= ?");
			params.add(trasladoBusqueda.getEhfechaDesde());
		}
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getEhfechaHasta() != null) {
			where.append(" AND t7.EHFECHA <= ?");
			params.add(trasladoBusqueda.getEhfechaHasta());
		}

		/*
		 * Fechas desde hasta de la recepcion de la operacion.
		 */
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getIhfereenDesde() != null) {
			where.append(" AND t1.IHFEREEN >= ?");
			params.add(trasladoBusqueda.getIhfereenDesde());
		}
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getIhfereenHasta() != null) {
			where.append(" AND t1.IHFEREEN <= ?");
			params.add(trasladoBusqueda.getIhfereenHasta());
		}

		if (trasladoBusqueda != null
				&& trasladoBusqueda.getSinRecepcionarDestino() != null) {
			where.append(" AND t1.IHFEREEN IS NULL");
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Busca los traslados para los organismos que pueden crear solicitudes
	 * 
	 * @param trasladoBusqueda
	 *            filtro de búsqueda
	 * @param pagination
	 *            paginación
	 * @return List<TrasladoBusqueda>
	 */
	public List<TrasladoBusqueda> findAllTrasladoOrgSolicidudes(
			TrasladoBusqueda trasladoBusqueda, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.IHCOOROR = oror.COD_ORG(+) AND t1.IHCOORDT = ordt.COD_ORG(+) AND t1.IHCOHC = t4.HCCODIGO AND t4.HCCOHD = t5.HDCODIGO AND t5.HDCODE = t6.DECODIGO AND t5.HDCODIGO = t7.EHCOHD AND t7.EHCOMO= t8.MOCODIGO(+) AND t1.IHCOEH=t7.EHCODIGO ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.IHCODIGO IHCODIGO, t1.IHCOORTR IHCOORTR, t1.IHNRORTR IHNRORTR, t1.IHNRANTR IHNRANTR, t1.IHININTR IHININTR, t1.IHFEREOR IHFEREOR, t1.IHFEREEN IHFEREEN, t1.IHTEDOAD IHTEDOAD, t1.IHCOOROR IHCOOROR, oror.NOMBRE_ES ORGANISMOORNOMBREES, oror.NOMBRE_EU ORGANISMOORNOMBREEU, t1.IHCOORDT IHCOORDT, ordt.NOMBRE_ES ORGANISMODTNOMBREES, ordt.NOMBRE_EU ORGANISMODTNOMBREEU, t6.DECODIGO DECODIGO,t6.DECOOR DECOOR,t6.DENRAN DENRAN,t6.DENROR DENROR, t5.HDCODIGO HDCODIGO,t5.HDNROR HDNROR, t7.EHFECHA EHFECHA, t7.EHHORA EHHORA, t8.MOCODIGO MOCODIGO, t8.MONOMBRE MONOMBRE "
						+ "FROM TRASLADO t1, ORGANISMO oror, ORGANISMO ordt, DECISION_HECHO t4, HECHO_DENUNCIADO t5, DENUNCIA t6, TRAMITE_HECHO t7, CENSO_MONITOR t8, ORGANISMO_CREAR_SOLICITUDES t9 ");

		// Organismo origen
		if (trasladoBusqueda != null && trasladoBusqueda.getIhcooror() != null) {
			where.append(" AND t1.IHCOOROR = ?");
			params.add(trasladoBusqueda.getIhcooror());
		}

		// Organismo destino
		if (trasladoBusqueda != null && trasladoBusqueda.getIhcoordt() != null) {
			where.append(" AND t1.IHCOORDT = ?");
			params.add(trasladoBusqueda.getIhcoordt());
		}

		// Organismo transmision
		if (trasladoBusqueda != null && trasladoBusqueda.getIhcoortr() != null) {
			where.append(" AND t1.IHCOORTR = ?");
			params.add(trasladoBusqueda.getIhcoortr());
		}

		// Numero orden transmision
		if (trasladoBusqueda != null && trasladoBusqueda.getIhnrortr() != null) {
			where.append(" AND t1.IHNRORTR = ?");
			params.add(trasladoBusqueda.getIhnrortr());
		}

		// Numero año transmision
		if (trasladoBusqueda != null && trasladoBusqueda.getIhnrantr() != null) {
			where.append(" AND t1.IHNRANTR = ?");
			params.add(trasladoBusqueda.getIhnrantr());
		}

		/*
		 * Fechas desde hasta del envio de la transmision.
		 */
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getEhfechaDesde() != null) {
			where.append(" AND t7.EHFECHA >= ?");
			params.add(trasladoBusqueda.getEhfechaDesde());
		}
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getEhfechaHasta() != null) {
			where.append(" AND t7.EHFECHA <= ?");
			params.add(trasladoBusqueda.getEhfechaHasta());
		}

		/*
		 * Fechas desde hasta de la recepcion de la operacion.
		 */
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getIhfereenDesde() != null) {
			where.append(" AND t1.IHFEREEN >= ?");
			params.add(trasladoBusqueda.getIhfereenDesde());
		}
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getIhfereenHasta() != null) {
			where.append(" AND t1.IHFEREEN <= ?");
			params.add(trasladoBusqueda.getIhfereenHasta());
		}

		if (trasladoBusqueda != null
				&& trasladoBusqueda.getSinRecepcionarDestino() != null) {
			where.append(" AND t1.IHFEREEN IS NULL");
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc() + " NULLS LAST ");
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TrasladoBusqueda>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<TrasladoBusqueda>() {
					public TrasladoBusqueda mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {

						return new TrasladoBusqueda(resultSet
								.getString("IHCODIGO"), resultSet
								.getString("IHCOORTR"), resultSet
								.getBigDecimal("IHNRORTR"), resultSet
								.getBigDecimal("IHNRANTR"), resultSet
								.getDate("IHFEREOR"), resultSet
								.getDate("IHFEREEN"), null, null, resultSet
								.getString("IHTEDOAD"), resultSet
								.getString("IHININTR"), resultSet
								.getString("IHCOOROR"), resultSet
								.getString("ORGANISMOORNOMBREES"), resultSet
								.getString("ORGANISMOORNOMBREEU"), resultSet
								.getString("IHCOORDT"), resultSet
								.getString("ORGANISMODTNOMBREES"), resultSet
								.getString("ORGANISMODTNOMBREEU"), null,
								"NUMEXP", resultSet.getString("DECOOR"),
								resultSet.getBigDecimal("DENRAN"), resultSet
										.getBigDecimal("DENROR"), resultSet
										.getString("HDCODIGO"), resultSet
										.getBigDecimal("HDNROR"), resultSet
										.getDate("EHFECHA"), null, null,
								resultSet.getString("EHHORA"), resultSet
										.getString("MOCODIGO"), resultSet
										.getString("MONOMBRE"), null);
					}
				}, params.toArray());
	}

	/**
	 * Cuenta los traslados para los organismos que pueden crear solicitudes
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda filtro de búsqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTrasladoOrgSolicidudesCount(
			TrasladoBusqueda trasladoBusqueda) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.IHCOOROR = oror.COD_ORG(+) AND t1.IHCOORDT = ordt.COD_ORG(+) AND t1.IHCOHC = t4.HCCODIGO AND t4.HCCOHD = t5.HDCODIGO AND t5.HDCODE = t6.DECODIGO AND t5.HDCODIGO = t7.EHCOHD AND t7.EHCOMO= t8.MOCODIGO(+) AND t1.IHCOEH=t7.EHCODIGO ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRASLADO t1, ORGANISMO oror, ORGANISMO ordt, DECISION_HECHO t4, HECHO_DENUNCIADO t5, DENUNCIA t6, TRAMITE_HECHO t7, CENSO_MONITOR t8, ORGANISMO_CREAR_SOLICITUDES t9 ");

		// Organismo origen
		if (trasladoBusqueda != null && trasladoBusqueda.getIhcooror() != null) {
			where.append(" AND t1.IHCOOROR = ?");
			params.add(trasladoBusqueda.getIhcooror());
		}

		// Organismo destino
		if (trasladoBusqueda != null && trasladoBusqueda.getIhcoordt() != null) {
			where.append(" AND t1.IHCOORDT = ?");
			params.add(trasladoBusqueda.getIhcoordt());
		}

		// Organismo transmision
		if (trasladoBusqueda != null && trasladoBusqueda.getIhcoortr() != null) {
			where.append(" AND t1.IHCOORTR = ?");
			params.add(trasladoBusqueda.getIhcoortr());
		}

		// Numero orden transmision
		if (trasladoBusqueda != null && trasladoBusqueda.getIhnrortr() != null) {
			where.append(" AND t1.IHNRORTR = ?");
			params.add(trasladoBusqueda.getIhnrortr());
		}

		// Numero año transmision
		if (trasladoBusqueda != null && trasladoBusqueda.getIhnrantr() != null) {
			where.append(" AND t1.IHNRANTR = ?");
			params.add(trasladoBusqueda.getIhnrantr());
		}

		/*
		 * Fechas desde hasta del envio de la transmision.
		 */
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getEhfechaDesde() != null) {
			where.append(" AND t7.EHFECHA >= ?");
			params.add(trasladoBusqueda.getEhfechaDesde());
		}
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getEhfechaHasta() != null) {
			where.append(" AND t7.EHFECHA <= ?");
			params.add(trasladoBusqueda.getEhfechaHasta());
		}

		/*
		 * Fechas desde hasta de la recepcion de la operacion.
		 */
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getIhfereenDesde() != null) {
			where.append(" AND t1.IHFEREEN >= ?");
			params.add(trasladoBusqueda.getIhfereenDesde());
		}
		if (trasladoBusqueda != null
				&& trasladoBusqueda.getIhfereenHasta() != null) {
			where.append(" AND t1.IHFEREEN <= ?");
			params.add(trasladoBusqueda.getIhfereenHasta());
		}

		if (trasladoBusqueda != null
				&& trasladoBusqueda.getSinRecepcionarDestino() != null) {
			where.append(" AND t1.IHFEREEN IS NULL");
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
