package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Denuncia;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.model.Motivo;
import com.ejie.y41a.model.Organismo;
import com.ejie.y41a.model.PlantillaTramiteHechoDetalle;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.Sector;
import com.ejie.y41a.model.TipoReclamacion;
import com.ejie.y41a.model.Tramite;
import com.ejie.y41a.model.TramiteHecho;
import com.ejie.y41a.model.TramiteHechoDetalle;
import com.ejie.y41a.model.TramiteHechoKonbide;
import com.ejie.y41a.utils.Y41aUtils;

/**
 * * TramiteHechoDaoImpl generated by UDA, 22-feb-2012 17:30:27.
 * 
 *  
 */

@Repository
@Transactional
public class TramiteHechoDaoImpl implements TramiteHechoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<TramiteHecho> rwMap = new RowMapper<TramiteHecho>() {
		public TramiteHecho mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new TramiteHecho(
					resultSet.getString("EHCODIGO"),
					resultSet.getDate("EHFECHA"),
					resultSet.getString("EHHORA"),
					resultSet.getString("EHCODPOR"),
					resultSet.getString("EHCODPDE"),
					resultSet.getString("EHTEXTO"),
					resultSet.getString("EHCOZS"),
					resultSet.getBigDecimal("EHCIVIHE"),
					resultSet.getDate("EHACUSE"),
					resultSet.getString("EHENVIOMAIL"),
					resultSet.getString("EHDIREMAIL"),
					resultSet.getString("EHCOORTRASPASO"),
					resultSet.getString("EHRESPUESTATRASPASO"),
					new Tramite(resultSet.getString("TramiteTRCODIGO"),
							resultSet.getString("TramiteTRNOMBRE"), resultSet
									.getString("TramiteTRNOMBREE"), resultSet
									.getDate("TramiteTRBAJA")),
					new CensoMonitor(resultSet
							.getString("CensoMonitorMOCODIGO"), resultSet
							.getString("CensoMonitorMONOMBRE"), resultSet
							.getString("CensoMonitorMOCOEM"), resultSet
							.getString("CensoMonitorMOUSU"), resultSet
							.getString("CensoMonitorMOCLAVE"), resultSet
							.getDate("CensoMonitorMOFECBAJA"), resultSet
							.getString("CensoMonitorMOADMIN"), resultSet
							.getString("CensoMonitorMOPRIMERA"), new Organismo(
							resultSet.getString("CensoMonitorMOCOOR"), null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null)),
					new HechoDenunciado(
							resultSet.getString("HechoDenunciadoHDCODIGO"),
							resultSet.getLong("HechoDenunciadoHDNROR"),
							resultSet.getString("HechoDenunciadoHDTE"),
							resultSet.getString("HechoDenunciadoHDTEDOAD"),
							resultSet.getString("HechoDenunciadoHDCOAV"),
							resultSet.getString("HechoDenunciadoHDNOPS"),
							resultSet.getString("HechoDenunciadoHDNOMAPS"),
							resultSet.getString("HechoDenunciadoHDNOMOPS"),
							resultSet.getString("HechoDenunciadoHDNRLOPS"),
							resultSet.getDate("HechoDenunciadoHDFEDMPS"),
							resultSet.getString("HechoDenunciadoHDINSOTR"),
							resultSet.getString("HechoDenunciadoHDINSOMA"),
							resultSet.getBigDecimal("HechoDenunciadoHDCAPTSO"),
							resultSet.getString("HechoDenunciadoHDTESO"),
							resultSet.getDate("HechoDenunciadoHDFEARDT"),
							resultSet.getDate("HechoDenunciadoHDFEIOHD"),
							resultSet.getString("HechoDenunciadoHDINININ"),
							resultSet.getDate("HechoDenunciadoHDFEIOPC"),
							resultSet.getDate("HechoDenunciadoHDFEROPC"),
							resultSet.getString("HechoDenunciadoHDCOREPC"),
							resultSet.getDate("HechoDenunciadoHDFEIORP"),
							resultSet.getDate("HechoDenunciadoHDFERORP"),
							resultSet.getString("HechoDenunciadoHDCOREAP"),
							resultSet.getDate("HechoDenunciadoHDFEIORA"),
							resultSet.getString("HechoDenunciadoHDTEACPA"),
							resultSet.getDate("HechoDenunciadoHDFECEAC"),
							resultSet.getString("HechoDenunciadoHDHOCEAC"),
							resultSet.getDate("HechoDenunciadoHDFEIOCA"),
							resultSet.getString("HechoDenunciadoHDTEACDE"),
							resultSet.getDate("HechoDenunciadoHDFEIOAC"),
							resultSet.getDate("HechoDenunciadoHDFEIOFC"),
							resultSet.getString("HechoDenunciadoHDCOTRA"),
							resultSet.getString("HechoDenunciadoHDTE02"),
							resultSet.getString("HechoDenunciadoHDTE03"),
							resultSet.getString("HechoDenunciadoHDTE04"),
							resultSet.getString("HechoDenunciadoHDTE05"),
							resultSet.getString("HechoDenunciadoHDTE06"),
							resultSet.getString("HechoDenunciadoHDTE07"),
							resultSet.getString("HechoDenunciadoHDTE08"),
							resultSet.getString("HechoDenunciadoHDTE09"),
							resultSet.getString("HechoDenunciadoHDTE10"),
							resultSet.getString("HechoDenunciadoHDCOSC"),
							resultSet.getString("HechoDenunciadoHDIDAL"),
							resultSet.getDate("HechoDenunciadoHDFEROAD"),
							resultSet.getDate("HechoDenunciadoHDFEROAT"),
							resultSet.getString("HechoDenunciadoHDTEALDT"),
							resultSet.getString("HechoDenunciadoHDTEDEAT"),
							resultSet.getDate("HechoDenunciadoHDFEDEAT"),
							resultSet.getDate("HechoDenunciadoHDFEHD"),
							resultSet.getString("HechoDenunciadoHDTEDOADE"),
							resultSet.getString("HechoDenunciadoHDTEDOADI"),
							resultSet.getString("HechoDenunciadoHDTEDOADF"),
							resultSet.getString("HechoDenunciadoHDTEDOADA"),
							resultSet.getString("HechoDenunciadoHDNOPSE"),
							resultSet.getString("HechoDenunciadoHDNOPSI"),
							resultSet.getString("HechoDenunciadoHDNOPSF"),
							resultSet.getString("HechoDenunciadoHDNOPSA"),
							resultSet.getString("HechoDenunciadoHDCOCODIGO"),
							resultSet
									.getString("HechoDenunciadoHDCODEXPEDIENTEORIGEN"),
							new Denuncia(resultSet
									.getString("HechoDenunciadoHDCODE"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null),
							new Establecimiento(resultSet
									.getString("HechoDenunciadoHDCOES"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null), new Sector(resultSet
									.getString("HechoDenunciadoHDCOSE"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null),
							new CensoMonitor(resultSet
									.getString("HechoDenunciadoHDCOMO"), null,
									null, null, null, null, null, null, null,
									null, null, null), new Producto(resultSet
									.getString("HechoDenunciadoHDCOPS"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null),
							new TipoReclamacion(resultSet
									.getString("HechoDenunciadoHDCOTSR"), null,
									null, null, null, null, null),
							new Motivo(resultSet
									.getString("HechoDenunciadoHDCOTIR"), null,
									null, null), null));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho add(TramiteHecho tramitehecho) {

		String query = "INSERT INTO TRAMITE_HECHO( EHCODIGO,EHCOTEE,EHCOMO,EHCOHD,EHFECHA,EHHORA,EHCODPOR,EHCODPDE,EHTEXTO,EHCOZS,EHCIVIHE,EHACUSE,EHENVIOMAIL,EHDIREMAIL, EHCOORTRASPASO,EHFECHAINICIO, EHFECHAFIN)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,SYSDATE,SYSDATE)";

		Object getTramiteTrcodigoAux = null;
		if (tramitehecho.getTramite() != null
				&& tramitehecho.getTramite().getTrcodigo() != null) {
			getTramiteTrcodigoAux = tramitehecho.getTramite().getTrcodigo();
		}
		Object getCensoMonitorMocodigoAux = null;
		if (tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = tramitehecho.getCensoMonitor()
					.getMocodigo();
		}
		Object getHechoDenunciadoHdcodigoAux = null;
		if (tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcodigo() != null) {
			getHechoDenunciadoHdcodigoAux = tramitehecho.getHechoDenunciado()
					.getHdcodigo();
		}
		this.jdbcTemplate.update(query, tramitehecho.getEhcodigo(),
				getTramiteTrcodigoAux, getCensoMonitorMocodigoAux,
				getHechoDenunciadoHdcodigoAux, tramitehecho.getEhfecha(),
				tramitehecho.getEhhora(), tramitehecho.getEhcodpor(),
				tramitehecho.getEhcodpde(), tramitehecho.getEhtexto(),
				tramitehecho.getEhcozs(), tramitehecho.getEhcivihe(),
				tramitehecho.getEhacuse(), tramitehecho.getEhenviomail(),
				tramitehecho.getEhdiremail(), tramitehecho.getCodOrgTraslado());
		return tramitehecho;
	}

	/**
	 * Inserts a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoKonbide
	 *            TramiteHechoKonbide
	 * @return TramiteHechoKonbide
	 */
	public TramiteHechoKonbide addTramiteHechoKonbide(
			TramiteHechoKonbide tramiteHechoKonbide) throws Exception {
		String query = "INSERT INTO TRAMITE_HECHO (EHCODIGO, EHCODIGORELACIONADO, EHCOTEE, EHFECHA, EHHORA, EHCODPOR, EHCODPDE, EHTEXTO, EHCOHD, EHCOZS, EHCOMO, EHCIVIHE, EHCOEH, EHACUSE, EHENVIOMAIL, EHDIREMAIL, EHCOORTRASPASO, EHCOACTUA, EHFECHAINICIO, EHFECHAFIN, EHCOMOEJECUCION, EHCOSC, EHRESPUESTA, EHFECHAMEDIACION, EHHORAMEDIACION, EHFECHAENVIOCONVOCATORIA, EHFECHAREALIZACION, EHHORAREALIZACION, EHFECHACONCILIACION, EHFECHAFIRMAACUERDO, EHPLAZOINSPECCION, INCODIGO, EHRESPUESTATRASPASO, EHDECODIGO, EHFECHARESOLUCION, EHFECHARECURSO, EHTIPORECURSO, EHABOGADO, EHESTIMACION, EHFECHACIERRE, EHDESTINATARIO, EHFECHACOMUNICACION, EHTIPOCOMUNICACION, EHTIPONOTIFICACION, EHNUMREGISTROSALIDA, EHACUSERECIBO, EHACUSERECIBORECIBIDO, EHNUMREGISTROENTRADA, EHIDNOTIFICACIONPLATEA, EHNOMBRETRAMITE, EHNRTEL1, EHNRTEL2, EHNRTEL3, EHIDDESTINATARIO, EHCOMOASIGNADO, EHFECHAREGISTROSALIDA, EHFECHAREGISTROENTRADA, EHESTADOTRAMITE, EHSIGUIENTESTRAMITES, EHTEXTOACUERDO, EHINSTRUCINSPECC, EHMOTIVORECHAZO, EHMOTIVORECURSO, EHCOMODESIGNADO,EHREQUIEREFIRMA,EHRESUMENALEGACION,EHRESUMENMEDIACION,EHTEXTOCOMUNICACION,EHTIPONOTIFICACIONPLATEA,EHIDESPERAPLATEA,EHMATARESPERA,EHINTERVINIENTES,EHTIPOMEDIACION) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getTramiteHechoEhcodigoAux = null;
		if (tramiteHechoKonbide.getTramiteHecho() != null
				&& tramiteHechoKonbide.getTramiteHecho().getEhcodigo() != null) {
			getTramiteHechoEhcodigoAux = tramiteHechoKonbide.getTramiteHecho()
					.getEhcodigo();
		}
		this.jdbcTemplate
				.update(query, tramiteHechoKonbide.getEhcodigo(),
						getTramiteHechoEhcodigoAux, tramiteHechoKonbide
								.getEhcotee(),
						tramiteHechoKonbide.getEhfecha(), tramiteHechoKonbide
								.getEhhora(),
						tramiteHechoKonbide.getEhcodpor(), tramiteHechoKonbide
								.getEhcodpde(), tramiteHechoKonbide
								.getEhtexto(), tramiteHechoKonbide.getEhcohd(),
						tramiteHechoKonbide.getEhcozs(), tramiteHechoKonbide
								.getEhcomo(),
						tramiteHechoKonbide.getEhcivihe(), tramiteHechoKonbide
								.getEhcoeh(), tramiteHechoKonbide.getEhacuse(),
						tramiteHechoKonbide.getEhenviomail(),
						tramiteHechoKonbide.getEhdiremail(),
						tramiteHechoKonbide.getEhcoortraspaso(),
						tramiteHechoKonbide.getEhcoactua(), tramiteHechoKonbide
								.getEhfechainicio(), tramiteHechoKonbide
								.getEhfechafin(), tramiteHechoKonbide
								.getEhcomoejecucion(), tramiteHechoKonbide
								.getEhcosc(), tramiteHechoKonbide
								.getEhrespuesta(), tramiteHechoKonbide
								.getEhfechamediacion(), tramiteHechoKonbide
								.getEhhoramediacion(), tramiteHechoKonbide
								.getEhfechaenvioconvocatoria(),
						tramiteHechoKonbide.getEhfecharealizacion(),
						tramiteHechoKonbide.getEhhorarealizacion(),
						tramiteHechoKonbide.getEhfechaconciliacion(),
						tramiteHechoKonbide.getEhfechafirmaacuerdo(),
						tramiteHechoKonbide.getEhplazoinspeccion(),
						tramiteHechoKonbide.getIncodigo(), tramiteHechoKonbide
								.getEhrespuestatraspaso(), tramiteHechoKonbide
								.getEhdecodigo(), tramiteHechoKonbide
								.getEhfecharesolucion(), tramiteHechoKonbide
								.getEhfecharecurso(), tramiteHechoKonbide
								.getEhtiporecurso(), tramiteHechoKonbide
								.getEhabogado(), tramiteHechoKonbide
								.getEhestimacion(), tramiteHechoKonbide
								.getEhfechacierre(), tramiteHechoKonbide
								.getEhdestinatario(), tramiteHechoKonbide
								.getEhfechacomunicacion(), tramiteHechoKonbide
								.getEhtipocomunicacion(), tramiteHechoKonbide
								.getEhtiponotificacion(), tramiteHechoKonbide
								.getEhnumregistrosalida(), tramiteHechoKonbide
								.getEhacuserecibo(), tramiteHechoKonbide
								.getEhacusereciborecibido(),
						tramiteHechoKonbide.getEhnumregistroentrada(),
						tramiteHechoKonbide.getEhidnotificacionplatea(),
						tramiteHechoKonbide.getEhnombretramite(),
						tramiteHechoKonbide.getEhnrtel1(), tramiteHechoKonbide
								.getEhnrtel2(), tramiteHechoKonbide
								.getEhnrtel3(), tramiteHechoKonbide
								.getEhiddestinatario(), tramiteHechoKonbide
								.getEhcomoasignado(), tramiteHechoKonbide
								.getEhfecharegistrosalida(),
						tramiteHechoKonbide.getEhfecharegistroentrada(),
						tramiteHechoKonbide.getEhestadotramite(), Y41aUtils
								.clobToString(tramiteHechoKonbide
										.getEhsiguientestramites()), Y41aUtils
								.clobToString(tramiteHechoKonbide
										.getEhtextoacuerdo()), Y41aUtils
								.clobToString(tramiteHechoKonbide
										.getEhinstrucinspecc()), Y41aUtils
								.clobToString(tramiteHechoKonbide
										.getEhmotivorechazo()), Y41aUtils
								.clobToString(tramiteHechoKonbide
										.getEhmotivorecurso()),
						tramiteHechoKonbide.getEhcomodesignado(),
						tramiteHechoKonbide.getEhrequierefirma(), Y41aUtils
								.clobToString(tramiteHechoKonbide
										.getEhresumenalegacion()), Y41aUtils
								.clobToString(tramiteHechoKonbide
										.getEhresumenmediacion()), Y41aUtils
								.clobToString(tramiteHechoKonbide
										.getEhtextocomunicacion()),
						tramiteHechoKonbide.getEhtiponotificacionplatea(),
						tramiteHechoKonbide.getEhidesperaplatea(),
						tramiteHechoKonbide.getEhmatarespera(), Y41aUtils
								.clobToString(tramiteHechoKonbide
										.getEhintervinientes()),
						tramiteHechoKonbide.getEhtipomediacion());
		return tramiteHechoKonbide;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho update(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHCOTEE=?,EHCOMO=?,EHCOHD=?,EHFECHA=?,EHHORA=?,EHCODPOR=?,EHCODPDE=?,EHTEXTO=?,EHCOZS=?,EHCIVIHE=?,EHACUSE=?,EHENVIOMAIL=?,EHDIREMAIL=? WHERE EHCODIGO=?";
		Object getTramiteTrcodigoAux = null;
		if (tramitehecho.getTramite() != null
				&& tramitehecho.getTramite().getTrcodigo() != null) {
			getTramiteTrcodigoAux = tramitehecho.getTramite().getTrcodigo();
		}
		Object getCensoMonitorMocodigoAux = null;
		if (tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = tramitehecho.getCensoMonitor()
					.getMocodigo();
		}
		Object getHechoDenunciadoHdcodigoAux = null;
		if (tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcodigo() != null) {
			getHechoDenunciadoHdcodigoAux = tramitehecho.getHechoDenunciado()
					.getHdcodigo();
		}
		this.jdbcTemplate.update(query, getTramiteTrcodigoAux,
				getCensoMonitorMocodigoAux, getHechoDenunciadoHdcodigoAux,
				tramitehecho.getEhfecha(), tramitehecho.getEhhora(),
				tramitehecho.getEhcodpor(), tramitehecho.getEhcodpde(),
				tramitehecho.getEhtexto(), tramitehecho.getEhcozs(),
				tramitehecho.getEhcivihe(), tramitehecho.getEhacuse(),
				tramitehecho.getEhenviomail(), tramitehecho.getEhdiremail(),
				tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateTramiteHecho(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHTEXTO=?,EHACUSE=?,EHFECHAFIN=SYSDATE WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhtexto(),
				tramitehecho.getEhacuse(), tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	@Transactional(readOnly = true)
	public TramiteHecho find(TramiteHecho tramitehecho) {
		String query = "SELECT t1.EHCODIGO EHCODIGO, t1.EHFECHA EHFECHA, t1.EHHORA EHHORA, t1.EHCODPOR EHCODPOR, t1.EHCODPDE EHCODPDE, t1.EHTEXTO EHTEXTO, t1.EHCOZS EHCOZS, t1.EHCIVIHE EHCIVIHE, t1.EHACUSE EHACUSE, t1.EHENVIOMAIL EHENVIOMAIL, t1.EHDIREMAIL EHDIREMAIL, t1.EHCOORTRASPASO EHCOORTRASPASO, t1.EHRESPUESTATRASPASO EHRESPUESTATRASPASO, t2.TRCODIGO TRAMITETRCODIGO, t2.TRNOMBRE TRAMITETRNOMBRE, t2.TRNOMBREE TRAMITETRNOMBREE, t2.TRBAJA TRAMITETRBAJA, t3.MOCODIGO CENSOMONITORMOCODIGO, t3.MONOMBRE CENSOMONITORMONOMBRE, t3.MOCOEM CENSOMONITORMOCOEM, t3.MOUSU CENSOMONITORMOUSU, t3.MOCLAVE CENSOMONITORMOCLAVE, t3.MOFECBAJA CENSOMONITORMOFECBAJA, t3.MOADMIN CENSOMONITORMOADMIN, t3.MOPRIMERA CENSOMONITORMOPRIMERA, t4.HDCODIGO HECHODENUNCIADOHDCODIGO, t4.HDNROR HECHODENUNCIADOHDNROR, t4.HDTE HECHODENUNCIADOHDTE, t4.HDTEDOAD HECHODENUNCIADOHDTEDOAD, t4.HDCOAV HECHODENUNCIADOHDCOAV, t4.HDNOPS HECHODENUNCIADOHDNOPS, t4.HDNOMAPS HECHODENUNCIADOHDNOMAPS, t4.HDNOMOPS HECHODENUNCIADOHDNOMOPS, t4.HDNRLOPS HECHODENUNCIADOHDNRLOPS, t4.HDFEDMPS HECHODENUNCIADOHDFEDMPS, t4.HDINSOTR HECHODENUNCIADOHDINSOTR, t4.HDINSOMA HECHODENUNCIADOHDINSOMA, t4.HDCAPTSO HECHODENUNCIADOHDCAPTSO, t4.HDTESO HECHODENUNCIADOHDTESO, t4.HDFEARDT HECHODENUNCIADOHDFEARDT, t4.HDFEIOHD HECHODENUNCIADOHDFEIOHD, t4.HDINININ HECHODENUNCIADOHDINININ, t4.HDFEIOPC HECHODENUNCIADOHDFEIOPC, t4.HDFEROPC HECHODENUNCIADOHDFEROPC, t4.HDCOREPC HECHODENUNCIADOHDCOREPC, t4.HDFEIORP HECHODENUNCIADOHDFEIORP, t4.HDFERORP HECHODENUNCIADOHDFERORP, t4.HDCOREAP HECHODENUNCIADOHDCOREAP, t4.HDFEIORA HECHODENUNCIADOHDFEIORA, t4.HDTEACPA HECHODENUNCIADOHDTEACPA, t4.HDFECEAC HECHODENUNCIADOHDFECEAC, t4.HDHOCEAC HECHODENUNCIADOHDHOCEAC, t4.HDFEIOCA HECHODENUNCIADOHDFEIOCA, t4.HDTEACDE HECHODENUNCIADOHDTEACDE, t4.HDFEIOAC HECHODENUNCIADOHDFEIOAC, t4.HDFEIOFC HECHODENUNCIADOHDFEIOFC, t4.HDCOTRA HECHODENUNCIADOHDCOTRA, t4.HDTE02 HECHODENUNCIADOHDTE02, t4.HDTE03 HECHODENUNCIADOHDTE03, t4.HDTE04 HECHODENUNCIADOHDTE04, t4.HDTE05 HECHODENUNCIADOHDTE05, t4.HDTE06 HECHODENUNCIADOHDTE06, t4.HDTE07 HECHODENUNCIADOHDTE07, t4.HDTE08 HECHODENUNCIADOHDTE08, t4.HDTE09 HECHODENUNCIADOHDTE09, t4.HDTE10 HECHODENUNCIADOHDTE10, t4.HDCOSC HECHODENUNCIADOHDCOSC, t4.HDIDAL HECHODENUNCIADOHDIDAL, t4.HDFEROAD HECHODENUNCIADOHDFEROAD, t4.HDFEROAT HECHODENUNCIADOHDFEROAT, t4.HDTEALDT HECHODENUNCIADOHDTEALDT, t4.HDTEDEAT HECHODENUNCIADOHDTEDEAT, t4.HDFEDEAT HECHODENUNCIADOHDFEDEAT, t4.HDFEHD HECHODENUNCIADOHDFEHD, t4.HDTEDOADE HECHODENUNCIADOHDTEDOADE, t4.HDTEDOADI HECHODENUNCIADOHDTEDOADI, t4.HDTEDOADF HECHODENUNCIADOHDTEDOADF, t4.HDTEDOADA HECHODENUNCIADOHDTEDOADA, t4.HDNOPSE HECHODENUNCIADOHDNOPSE, t4.HDNOPSI HECHODENUNCIADOHDNOPSI, t4.HDNOPSF HECHODENUNCIADOHDNOPSF, t4.HDNOPSA HECHODENUNCIADOHDNOPSA, t4.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO, t3.MOCOOR CENSOMONITORMOCOOR, t4.HDCODE HECHODENUNCIADOHDCODE, t4.HDCOES HECHODENUNCIADOHDCOES, t4.HDCOSE HECHODENUNCIADOHDCOSE, t4.HDCOMO HECHODENUNCIADOHDCOMO, t4.HDCOPS HECHODENUNCIADOHDCOPS, t4.HDCOTSR HECHODENUNCIADOHDCOTSR, t4.HDCOTIR HECHODENUNCIADOHDCOTIR "
				+ "FROM TRAMITE_HECHO t1 , TRAMITE t2 , CENSO_MONITOR t3 , HECHO_DENUNCIADO t4  "
				+ "WHERE t1.EHCODIGO = ?   AND t1.EHCOTEE= t2.TRCODIGO AND t1.EHCOMO= t3.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+)  ";
		return (TramiteHecho) this.jdbcTemplate.queryForObject(query, rwMap,
				tramitehecho.getEhcodigo());
	}

	/**
	 * Removes a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return
	 */
	public void remove(TramiteHecho tramitehecho) {
		StringBuffer query = new StringBuffer(3000);
		query.append("DELETE  FROM TRAMITE_HECHO WHERE EHCODIGO='")
				.append(tramitehecho.getEhcodigo()).append("'");
		this.jdbcTemplate.update(query.toString());
	}

	/**
	 * Removes all tramites of the Solicitud.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return
	 */
	public void removeTramitesSolicitud(TramiteHecho tramitehecho) {
		String query = "DELETE  FROM TRAMITE_HECHO WHERE EHCOHD=?";
		this.jdbcTemplate.update(query, tramitehecho.getHechoDenunciado()
				.getHdcodigo());
	}

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteHecho> findAll(TramiteHecho tramitehecho,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO(+) AND t1.EHCOMO= t3.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.EHCODIGO EHCODIGO,t1.EHFECHA EHFECHA,t1.EHHORA EHHORA,t1.EHCODPOR EHCODPOR,t1.EHCODPDE EHCODPDE,t1.EHTEXTO EHTEXTO,t1.EHCOZS EHCOZS,t1.EHCIVIHE EHCIVIHE,t1.EHACUSE EHACUSE,t1.EHENVIOMAIL EHENVIOMAIL,t1.EHDIREMAIL EHDIREMAIL, t1.EHCOORTRASPASO EHCOORTRASPASO,t2.TRCODIGO TRAMITETRCODIGO,t2.TRNOMBRE TRAMITETRNOMBRE,t2.TRNOMBREE TRAMITETRNOMBREE,t2.TRBAJA TRAMITETRBAJA,t3.MOCODIGO CENSOMONITORMOCODIGO,t3.MONOMBRE CENSOMONITORMONOMBRE,t3.MOCOEM CENSOMONITORMOCOEM,t3.MOUSU CENSOMONITORMOUSU,t3.MOCLAVE CENSOMONITORMOCLAVE,t3.MOFECBAJA CENSOMONITORMOFECBAJA,t3.MOADMIN CENSOMONITORMOADMIN,t3.MOPRIMERA CENSOMONITORMOPRIMERA,t4.HDCODIGO HECHODENUNCIADOHDCODIGO,t4.HDNROR HECHODENUNCIADOHDNROR,t4.HDTE HECHODENUNCIADOHDTE,t4.HDTEDOAD HECHODENUNCIADOHDTEDOAD,t4.HDCOAV HECHODENUNCIADOHDCOAV,t4.HDNOPS HECHODENUNCIADOHDNOPS,t4.HDNOMAPS HECHODENUNCIADOHDNOMAPS,t4.HDNOMOPS HECHODENUNCIADOHDNOMOPS,t4.HDNRLOPS HECHODENUNCIADOHDNRLOPS,t4.HDFEDMPS HECHODENUNCIADOHDFEDMPS,t4.HDINSOTR HECHODENUNCIADOHDINSOTR,t4.HDINSOMA HECHODENUNCIADOHDINSOMA,t4.HDCAPTSO HECHODENUNCIADOHDCAPTSO,t4.HDTESO HECHODENUNCIADOHDTESO,t4.HDFEARDT HECHODENUNCIADOHDFEARDT,t4.HDFEIOHD HECHODENUNCIADOHDFEIOHD,t4.HDINININ HECHODENUNCIADOHDINININ,t4.HDFEIOPC HECHODENUNCIADOHDFEIOPC,t4.HDFEROPC HECHODENUNCIADOHDFEROPC,t4.HDCOREPC HECHODENUNCIADOHDCOREPC,t4.HDFEIORP HECHODENUNCIADOHDFEIORP,t4.HDFERORP HECHODENUNCIADOHDFERORP,t4.HDCOREAP HECHODENUNCIADOHDCOREAP,t4.HDFEIORA HECHODENUNCIADOHDFEIORA,t4.HDTEACPA HECHODENUNCIADOHDTEACPA,t4.HDFECEAC HECHODENUNCIADOHDFECEAC,t4.HDHOCEAC HECHODENUNCIADOHDHOCEAC,t4.HDFEIOCA HECHODENUNCIADOHDFEIOCA,t4.HDTEACDE HECHODENUNCIADOHDTEACDE,t4.HDFEIOAC HECHODENUNCIADOHDFEIOAC,t4.HDFEIOFC HECHODENUNCIADOHDFEIOFC,t4.HDCOTRA HECHODENUNCIADOHDCOTRA,t4.HDTE02 HECHODENUNCIADOHDTE02,t4.HDTE03 HECHODENUNCIADOHDTE03,t4.HDTE04 HECHODENUNCIADOHDTE04,t4.HDTE05 HECHODENUNCIADOHDTE05,t4.HDTE06 HECHODENUNCIADOHDTE06,t4.HDTE07 HECHODENUNCIADOHDTE07,t4.HDTE08 HECHODENUNCIADOHDTE08,t4.HDTE09 HECHODENUNCIADOHDTE09,t4.HDTE10 HECHODENUNCIADOHDTE10,t4.HDCOSC HECHODENUNCIADOHDCOSC,t4.HDIDAL HECHODENUNCIADOHDIDAL,t4.HDFEROAD HECHODENUNCIADOHDFEROAD,t4.HDFEROAT HECHODENUNCIADOHDFEROAT,t4.HDTEALDT HECHODENUNCIADOHDTEALDT,t4.HDTEDEAT HECHODENUNCIADOHDTEDEAT,t4.HDFEDEAT HECHODENUNCIADOHDFEDEAT,t4.HDFEHD HECHODENUNCIADOHDFEHD,t4.HDTEDOADE HECHODENUNCIADOHDTEDOADE,t4.HDTEDOADI HECHODENUNCIADOHDTEDOADI,t4.HDTEDOADF HECHODENUNCIADOHDTEDOADF,t4.HDTEDOADA HECHODENUNCIADOHDTEDOADA,t4.HDNOPSE HECHODENUNCIADOHDNOPSE,t4.HDNOPSI HECHODENUNCIADOHDNOPSI,t4.HDNOPSF HECHODENUNCIADOHDNOPSF,t4.HDNOPSA HECHODENUNCIADOHDNOPSA,t4.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO,t3.MOCOOR CENSOMONITORMOCOOR,t4.HDCODE HECHODENUNCIADOHDCODE,t4.HDCOES HECHODENUNCIADOHDCOES,t4.HDCOSE HECHODENUNCIADOHDCOSE,t4.HDCOMO HECHODENUNCIADOHDCOMO,t4.HDCOPS HECHODENUNCIADOHDCOPS,t4.HDCOTSR HECHODENUNCIADOHDCOTSR,t4.HDCOTIR HECHODENUNCIADOHDCOTIR "
						+ "FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3 ,HECHO_DENUNCIADO t4 ");

		if (tramitehecho != null && tramitehecho.getEhcodigo() != null) {
			where.append(" AND t1.EHCODIGO = ?");
			params.add(tramitehecho.getEhcodigo());
		}
		if (tramitehecho != null && tramitehecho.getTramite() != null
				&& tramitehecho.getTramite().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(tramitehecho.getTramite().getTrcodigo());
		}
		if (tramitehecho != null && tramitehecho.getTramite() != null
				&& tramitehecho.getTramite().getTrnombre() != null) {
			where.append(" AND t2.TRNOMBRE = ?");
			params.add(tramitehecho.getTramite().getTrnombre());
		}
		if (tramitehecho != null && tramitehecho.getTramite() != null
				&& tramitehecho.getTramite().getTrnombree() != null) {
			where.append(" AND t2.TRNOMBREE = ?");
			params.add(tramitehecho.getTramite().getTrnombree());
		}
		if (tramitehecho != null && tramitehecho.getTramite() != null
				&& tramitehecho.getTramite().getTrbaja() != null) {
			where.append(" AND t2.TRBAJA = ?");
			params.add(tramitehecho.getTramite().getTrbaja());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t3.MOCODIGO = ?");
			params.add(tramitehecho.getCensoMonitor().getMocodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getOrganismo() != null
				&& tramitehecho.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t3.MOCOOR = ?");
			params.add(tramitehecho.getCensoMonitor().getOrganismo()
					.getCodOrg());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t3.MONOMBRE = ?");
			params.add(tramitehecho.getCensoMonitor().getMonombre());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t3.MOCOEM = ?");
			params.add(tramitehecho.getCensoMonitor().getMocoem());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMousu() != null) {
			where.append(" AND t3.MOUSU = ?");
			params.add(tramitehecho.getCensoMonitor().getMousu());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMoclave() != null) {
			where.append(" AND t3.MOCLAVE = ?");
			params.add(tramitehecho.getCensoMonitor().getMoclave());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t3.MOFECBAJA = ?");
			params.add(tramitehecho.getCensoMonitor().getMofecbaja());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMoadmin() != null) {
			where.append(" AND t3.MOADMIN = ?");
			params.add(tramitehecho.getCensoMonitor().getMoadmin());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMoprimera() != null) {
			where.append(" AND t3.MOPRIMERA = ?");
			params.add(tramitehecho.getCensoMonitor().getMoprimera());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getDenuncia() != null
				&& tramitehecho.getHechoDenunciado().getDenuncia()
						.getDecodigo() != null) {
			where.append(" AND t4.HDCODE = ?");
			params.add(tramitehecho.getHechoDenunciado().getDenuncia()
					.getDecodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getEstablecimiento() != null
				&& tramitehecho.getHechoDenunciado().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND t4.HDCOES = ?");
			params.add(tramitehecho.getHechoDenunciado().getEstablecimiento()
					.getEscodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getSector() != null
				&& tramitehecho.getHechoDenunciado().getSector().getSecodigo() != null) {
			where.append(" AND t4.HDCOSE = ?");
			params.add(tramitehecho.getHechoDenunciado().getSector()
					.getSecodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getCensoMonitor() != null
				&& tramitehecho.getHechoDenunciado().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t4.HDCOMO = ?");
			params.add(tramitehecho.getHechoDenunciado().getCensoMonitor()
					.getMocodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getProducto() != null
				&& tramitehecho.getHechoDenunciado().getProducto()
						.getPscodigo() != null) {
			where.append(" AND t4.HDCOPS = ?");
			params.add(tramitehecho.getHechoDenunciado().getProducto()
					.getPscodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getTipoReclamacion() != null
				&& tramitehecho.getHechoDenunciado().getTipoReclamacion()
						.getTsrcodigo() != null) {
			where.append(" AND t4.HDCOTSR = ?");
			params.add(tramitehecho.getHechoDenunciado().getTipoReclamacion()
					.getTsrcodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getMotivo() != null
				&& tramitehecho.getHechoDenunciado().getMotivo().getTircodigo() != null) {
			where.append(" AND t4.HDCOTIR = ?");
			params.add(tramitehecho.getHechoDenunciado().getMotivo()
					.getTircodigo());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t4.HDNROR = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnror());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte() != null) {
			where.append(" AND t4.HDTE = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND t4.HDTEDOAD = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdtedoad());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND t4.HDCOAV = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcoav());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND t4.HDNOPS = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnops());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND t4.HDNOMAPS = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnomaps());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND t4.HDNOMOPS = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnomops());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND t4.HDNRLOPS = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnrlops());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t4.HDFEDMPS = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfedmps());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND t4.HDINSOTR = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdinsotr());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND t4.HDINSOMA = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdinsoma());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t4.HDCAPTSO = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcaptso());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND t4.HDTESO = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdteso());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t4.HDFEARDT = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeardt());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t4.HDFEIOHD = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeiohd());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND t4.HDINININ = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdininin());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t4.HDFEIOPC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeiopc());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t4.HDFEROPC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdferopc());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND t4.HDCOREPC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcorepc());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t4.HDFEIORP = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeiorp());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t4.HDFERORP = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdferorp());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND t4.HDCOREAP = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcoreap());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t4.HDFEIORA = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeiora());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND t4.HDTEACPA = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdteacpa());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t4.HDFECEAC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeceac());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND t4.HDHOCEAC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdhoceac());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t4.HDFEIOCA = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeioca());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND t4.HDTEACDE = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdteacde());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t4.HDFEIOAC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeioac());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t4.HDFEIOFC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeiofc());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND t4.HDCOTRA = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcotra());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND t4.HDTE02 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte02());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND t4.HDTE03 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte03());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND t4.HDTE04 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte04());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND t4.HDTE05 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte05());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND t4.HDTE06 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte06());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND t4.HDTE07 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte07());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND t4.HDTE08 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte08());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND t4.HDTE09 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte09());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND t4.HDTE10 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte10());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND t4.HDCOSC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcosc());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND t4.HDIDAL = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdidal());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t4.HDFEROAD = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdferoad());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t4.HDFEROAT = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdferoat());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND t4.HDTEALDT = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdtealdt());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND t4.HDTEDEAT = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdtedeat());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t4.HDFEDEAT = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfedeat());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t4.HDFEHD = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfehd());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND t4.HDTEDOADE = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdtedoade());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND t4.HDTEDOADI = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdtedoadi());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND t4.HDTEDOADF = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdtedoadf());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND t4.HDTEDOADA = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdtedoada());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND t4.HDNOPSE = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnopse());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND t4.HDNOPSI = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnopsi());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND t4.HDNOPSF = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnopsf());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND t4.HDNOPSA = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnopsa());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND t4.HDCOCODIGO = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcocodigo());
		}
		if (tramitehecho != null && tramitehecho.getEhfecha() != null) {
			where.append(" AND t1.EHFECHA = ?");
			params.add(tramitehecho.getEhfecha());
		}
		if (tramitehecho != null && tramitehecho.getEhhora() != null) {
			where.append(" AND t1.EHHORA = ?");
			params.add(tramitehecho.getEhhora());
		}
		if (tramitehecho != null && tramitehecho.getEhcodpor() != null) {
			where.append(" AND t1.EHCODPOR = ?");
			params.add(tramitehecho.getEhcodpor());
		}
		if (tramitehecho != null && tramitehecho.getEhcodpde() != null) {
			where.append(" AND t1.EHCODPDE = ?");
			params.add(tramitehecho.getEhcodpde());
		}
		if (tramitehecho != null && tramitehecho.getEhtexto() != null) {
			where.append(" AND t1.EHTEXTO = ?");
			params.add(tramitehecho.getEhtexto());
		}
		if (tramitehecho != null && tramitehecho.getEhcozs() != null) {
			where.append(" AND t1.EHCOZS = ?");
			params.add(tramitehecho.getEhcozs());
		}
		if (tramitehecho != null && tramitehecho.getEhcivihe() != null) {
			where.append(" AND t1.EHCIVIHE = ?");
			params.add(tramitehecho.getEhcivihe());
		}
		if (tramitehecho != null && tramitehecho.getEhacuse() != null) {
			where.append(" AND t1.EHACUSE = ?");
			params.add(tramitehecho.getEhacuse());
		}
		if (tramitehecho != null && tramitehecho.getEhenviomail() != null) {
			where.append(" AND t1.EHENVIOMAIL = ?");
			params.add(tramitehecho.getEhenviomail());
		}
		if (tramitehecho != null && tramitehecho.getEhdiremail() != null) {
			where.append(" AND t1.EHDIREMAIL = ?");
			params.add(tramitehecho.getEhdiremail());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TramiteHecho>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TramiteHecho tramitehecho) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.EHCOTEE= t2.TRCODIGO(+) and t1.EHCOMO= t3.MOCODIGO(+) and t1.EHCOHD= t4.HDCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  TRAMITE_HECHO t1   ,  TRAMITE t2   ,  CENSO_MONITOR t3   ,  HECHO_DENUNCIADO t4  ");
		if (tramitehecho != null && tramitehecho.getEhcodigo() != null) {
			where.append(" AND t1.EHCODIGO = ?");
			params.add(tramitehecho.getEhcodigo());
		}
		if (tramitehecho != null && tramitehecho.getTramite() != null
				&& tramitehecho.getTramite().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(tramitehecho.getTramite().getTrcodigo());
		}
		if (tramitehecho != null && tramitehecho.getTramite() != null
				&& tramitehecho.getTramite().getTrnombre() != null) {
			where.append(" AND t2.TRNOMBRE = ?");
			params.add(tramitehecho.getTramite().getTrnombre());
		}
		if (tramitehecho != null && tramitehecho.getTramite() != null
				&& tramitehecho.getTramite().getTrnombree() != null) {
			where.append(" AND t2.TRNOMBREE = ?");
			params.add(tramitehecho.getTramite().getTrnombree());
		}
		if (tramitehecho != null && tramitehecho.getTramite() != null
				&& tramitehecho.getTramite().getTrbaja() != null) {
			where.append(" AND t2.TRBAJA = ?");
			params.add(tramitehecho.getTramite().getTrbaja());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t3.MOCODIGO = ?");
			params.add(tramitehecho.getCensoMonitor().getMocodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getOrganismo() != null
				&& tramitehecho.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t3.MOCOOR = ?");
			params.add(tramitehecho.getCensoMonitor().getOrganismo()
					.getCodOrg());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t3.MONOMBRE = ?");
			params.add(tramitehecho.getCensoMonitor().getMonombre());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t3.MOCOEM = ?");
			params.add(tramitehecho.getCensoMonitor().getMocoem());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMousu() != null) {
			where.append(" AND t3.MOUSU = ?");
			params.add(tramitehecho.getCensoMonitor().getMousu());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMoclave() != null) {
			where.append(" AND t3.MOCLAVE = ?");
			params.add(tramitehecho.getCensoMonitor().getMoclave());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t3.MOFECBAJA = ?");
			params.add(tramitehecho.getCensoMonitor().getMofecbaja());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMoadmin() != null) {
			where.append(" AND t3.MOADMIN = ?");
			params.add(tramitehecho.getCensoMonitor().getMoadmin());
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMoprimera() != null) {
			where.append(" AND t3.MOPRIMERA = ?");
			params.add(tramitehecho.getCensoMonitor().getMoprimera());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getDenuncia() != null
				&& tramitehecho.getHechoDenunciado().getDenuncia()
						.getDecodigo() != null) {
			where.append(" AND t4.HDCODE = ?");
			params.add(tramitehecho.getHechoDenunciado().getDenuncia()
					.getDecodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getEstablecimiento() != null
				&& tramitehecho.getHechoDenunciado().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND t4.HDCOES = ?");
			params.add(tramitehecho.getHechoDenunciado().getEstablecimiento()
					.getEscodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getSector() != null
				&& tramitehecho.getHechoDenunciado().getSector().getSecodigo() != null) {
			where.append(" AND t4.HDCOSE = ?");
			params.add(tramitehecho.getHechoDenunciado().getSector()
					.getSecodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getCensoMonitor() != null
				&& tramitehecho.getHechoDenunciado().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t4.HDCOMO = ?");
			params.add(tramitehecho.getHechoDenunciado().getCensoMonitor()
					.getMocodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getProducto() != null
				&& tramitehecho.getHechoDenunciado().getProducto()
						.getPscodigo() != null) {
			where.append(" AND t4.HDCOPS = ?");
			params.add(tramitehecho.getHechoDenunciado().getProducto()
					.getPscodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getTipoReclamacion() != null
				&& tramitehecho.getHechoDenunciado().getTipoReclamacion()
						.getTsrcodigo() != null) {
			where.append(" AND t4.HDCOTSR = ?");
			params.add(tramitehecho.getHechoDenunciado().getTipoReclamacion()
					.getTsrcodigo());
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getMotivo() != null
				&& tramitehecho.getHechoDenunciado().getMotivo().getTircodigo() != null) {
			where.append(" AND t4.HDCOTIR = ?");
			params.add(tramitehecho.getHechoDenunciado().getMotivo()
					.getTircodigo());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t4.HDNROR = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnror());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte() != null) {
			where.append(" AND t4.HDTE = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND t4.HDTEDOAD = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdtedoad());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND t4.HDCOAV = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcoav());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND t4.HDNOPS = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnops());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND t4.HDNOMAPS = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnomaps());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND t4.HDNOMOPS = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnomops());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND t4.HDNRLOPS = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnrlops());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t4.HDFEDMPS = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfedmps());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND t4.HDINSOTR = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdinsotr());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND t4.HDINSOMA = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdinsoma());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t4.HDCAPTSO = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcaptso());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND t4.HDTESO = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdteso());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t4.HDFEARDT = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeardt());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t4.HDFEIOHD = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeiohd());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND t4.HDINININ = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdininin());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t4.HDFEIOPC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeiopc());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t4.HDFEROPC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdferopc());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND t4.HDCOREPC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcorepc());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t4.HDFEIORP = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeiorp());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t4.HDFERORP = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdferorp());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND t4.HDCOREAP = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcoreap());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t4.HDFEIORA = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeiora());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND t4.HDTEACPA = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdteacpa());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t4.HDFECEAC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeceac());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND t4.HDHOCEAC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdhoceac());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t4.HDFEIOCA = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeioca());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND t4.HDTEACDE = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdteacde());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t4.HDFEIOAC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeioac());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t4.HDFEIOFC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfeiofc());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND t4.HDCOTRA = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcotra());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND t4.HDTE02 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte02());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND t4.HDTE03 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte03());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND t4.HDTE04 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte04());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND t4.HDTE05 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte05());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND t4.HDTE06 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte06());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND t4.HDTE07 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte07());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND t4.HDTE08 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte08());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND t4.HDTE09 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte09());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND t4.HDTE10 = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdte10());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND t4.HDCOSC = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcosc());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND t4.HDIDAL = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdidal());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t4.HDFEROAD = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdferoad());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t4.HDFEROAT = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdferoat());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND t4.HDTEALDT = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdtealdt());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND t4.HDTEDEAT = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdtedeat());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t4.HDFEDEAT = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfedeat());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t4.HDFEHD = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdfehd());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND t4.HDTEDOADE = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdtedoade());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND t4.HDTEDOADI = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdtedoadi());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND t4.HDTEDOADF = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdtedoadf());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND t4.HDTEDOADA = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdtedoada());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND t4.HDNOPSE = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnopse());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND t4.HDNOPSI = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnopsi());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND t4.HDNOPSF = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnopsf());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND t4.HDNOPSA = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdnopsa());
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND t4.HDCOCODIGO = ?");
			params.add(tramitehecho.getHechoDenunciado().getHdcocodigo());
		}
		if (tramitehecho != null && tramitehecho.getEhfecha() != null) {
			where.append(" AND t1.EHFECHA = ?");
			params.add(tramitehecho.getEhfecha());
		}
		if (tramitehecho != null && tramitehecho.getEhhora() != null) {
			where.append(" AND t1.EHHORA = ?");
			params.add(tramitehecho.getEhhora());
		}
		if (tramitehecho != null && tramitehecho.getEhcodpor() != null) {
			where.append(" AND t1.EHCODPOR = ?");
			params.add(tramitehecho.getEhcodpor());
		}
		if (tramitehecho != null && tramitehecho.getEhcodpde() != null) {
			where.append(" AND t1.EHCODPDE = ?");
			params.add(tramitehecho.getEhcodpde());
		}
		if (tramitehecho != null && tramitehecho.getEhtexto() != null) {
			where.append(" AND t1.EHTEXTO = ?");
			params.add(tramitehecho.getEhtexto());
		}
		if (tramitehecho != null && tramitehecho.getEhcozs() != null) {
			where.append(" AND t1.EHCOZS = ?");
			params.add(tramitehecho.getEhcozs());
		}
		if (tramitehecho != null && tramitehecho.getEhcivihe() != null) {
			where.append(" AND t1.EHCIVIHE = ?");
			params.add(tramitehecho.getEhcivihe());
		}
		if (tramitehecho != null && tramitehecho.getEhacuse() != null) {
			where.append(" AND t1.EHACUSE = ?");
			params.add(tramitehecho.getEhacuse());
		}
		if (tramitehecho != null && tramitehecho.getEhenviomail() != null) {
			where.append(" AND t1.EHENVIOMAIL = ?");
			params.add(tramitehecho.getEhenviomail());
		}
		if (tramitehecho != null && tramitehecho.getEhdiremail() != null) {
			where.append(" AND t1.EHDIREMAIL = ?");
			params.add(tramitehecho.getEhdiremail());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteHechoDetalle> findAllTramiteHecho(
			TramiteHechoDetalle tramiteHechoDetalle, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO AND t1.EHCOMO= t3.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t1.EHCODIGO = t5.Q5TRAMITE(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.EHCODIGO EHCODIGO,t1.EHFECHA EHFECHA,t1.EHHORA EHHORA,t1.EHCODPOR EHCODPOR,t1.EHCODPDE EHCODPDE, t1.EHCOZS EHCOZS,t1.EHCIVIHE EHCIVIHE,t1.EHACUSE EHACUSE,t1.EHENVIOMAIL EHENVIOMAIL,t1.EHDIREMAIL EHDIREMAIL, t1.EHCOORTRASPASO EHCOORTRASPASO, t1.EHRESPUESTATRASPASO EHRESPUESTATRASPASO, t2.TRCODIGO TRCODIGO,t2.TRNOMBRE TRNOMBRE,t2.TRNOMBREE TRNOMBREE,t2.TRBAJA TRBAJA, t3.MOCODIGO MOCODIGO,t3.MONOMBRE MONOMBRE,t3.MOCOOR MOCOOR, t3.MOCOEM MOCOEM, t4.HDCODIGO HDCODIGO, t5.Q5CODOCUMENTO Q5CODOCUMENTO,t5.Q5NOFILE Q5NOFILE,t5.Q5SIZEFILE Q5SIZEFILE,t5.Q5TEDESFILE Q5TEDESFILE,t5.Q5ORIGEN Q5ORIGEN,t5.Q5FECHA Q5FECHA,t5.Q5INDMAIL Q5INDMAIL, t5.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE "
						+ "FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3 ,HECHO_DENUNCIADO t4,DOCUMENTO_HECHO t5 ");

		if (tramiteHechoDetalle != null
				&& tramiteHechoDetalle.getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO = ?");
			params.add(tramiteHechoDetalle.getHdcodigo());
		}
		if (tramiteHechoDetalle != null
				&& tramiteHechoDetalle.getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(tramiteHechoDetalle.getTrcodigo());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TramiteHechoDetalle>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<TramiteHechoDetalle>() {
					public TramiteHechoDetalle mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new TramiteHechoDetalle(resultSet
								.getString("EHCODIGO"), resultSet
								.getDate("EHFECHA"), resultSet
								.getString("EHHORA"), resultSet
								.getString("EHCODPOR"), resultSet
								.getString("EHCODPDE"), null, resultSet
								.getString("EHCOZS"), resultSet
								.getBigDecimal("EHCIVIHE"), resultSet
								.getDate("EHACUSE"), resultSet
								.getString("EHENVIOMAIL"), resultSet
								.getString("EHRESPUESTATRASPASO"), resultSet
								.getString("EHDIREMAIL"), resultSet
								.getString("TRCODIGO"), resultSet
								.getString("TRNOMBRE"), resultSet
								.getString("TRNOMBREE"), resultSet
								.getDate("TRBAJA"), resultSet
								.getString("MOCODIGO"), resultSet
								.getString("MOCOOR"), resultSet
								.getString("MONOMBRE"), resultSet
								.getString("MOCOEM"), resultSet
								.getString("HDCODIGO"), resultSet
								.getInt("Q5CODOCUMENTO"), resultSet
								.getString("Q5NOFILE"), null, resultSet
								.getInt("Q5SIZEFILE"), resultSet
								.getString("Q5TEDESFILE"), resultSet
								.getString("Q5ORIGEN"), resultSet
								.getDate("Q5FECHA"), resultSet
								.getString("Q5INDMAIL"), resultSet
								.getString("Q5CONTENTTYPEFILE"), resultSet
								.getString("EHCOORTRASPASO"), null, null, null,
								null, null, null, null, null, null);
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteHechoCount(TramiteHechoDetalle tramiteHechoDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO AND t1.EHCOMO= t3.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t1.EHCODIGO = t5.Q5TRAMITE(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3 ,HECHO_DENUNCIADO t4,DOCUMENTO_HECHO t5 ");

		if (tramiteHechoDetalle != null
				&& tramiteHechoDetalle.getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO = ?");
			params.add(tramiteHechoDetalle.getHdcodigo());
		}
		if (tramiteHechoDetalle != null
				&& tramiteHechoDetalle.getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(tramiteHechoDetalle.getTrcodigo());
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findTramiteHecho(
			TramiteHechoDetalle tramiteHechoDetalle) {
		String query = "SELECT  t1.EHCODIGO EHCODIGO,t1.EHFECHA EHFECHA,t1.EHHORA EHHORA,t1.EHCODPOR EHCODPOR,t1.EHCODPDE EHCODPDE, t1.EHCOZS EHCOZS,t1.EHCIVIHE EHCIVIHE,t1.EHACUSE EHACUSE,t1.EHENVIOMAIL EHENVIOMAIL,t1.EHDIREMAIL EHDIREMAIL, t1.EHRESPUESTATRASPASO EHRESPUESTATRASPASO, t2.TRCODIGO TRCODIGO,t2.TRNOMBRE TRNOMBRE,t2.TRNOMBREE TRNOMBREE,t2.TRBAJA TRBAJA, t3.MOCODIGO MOCODIGO,t3.MONOMBRE MONOMBRE,t3.MOCOOR MOCOOR, t3.MOCOEM MOCOEM, t4.HDCODIGO HDCODIGO, t6.COD_ORG CODORG, t6.NOMBRE_ES NOMBREES, t6.NOMBRE_EU NOMBREEU, t1.EHAUTOMATICO EHAUTOMATICO "
				+ "FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3 ,HECHO_DENUNCIADO t4, ORGANISMO t6  "
				+ "WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO AND t1.EHCOMO= t3.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t1.EHCOORTRASPASO= t6.COD_ORG(+) AND t1.EHCODIGO = ? ";
		return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query,
				new RowMapper<TramiteHechoDetalle>() {
					public TramiteHechoDetalle mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new TramiteHechoDetalle(resultSet
								.getString("EHCODIGO"), resultSet
								.getDate("EHFECHA"), resultSet
								.getString("EHHORA"), resultSet
								.getString("EHCODPOR"), resultSet
								.getString("EHCODPDE"), null, resultSet
								.getString("EHCOZS"), resultSet
								.getBigDecimal("EHCIVIHE"), resultSet
								.getDate("EHACUSE"), resultSet
								.getString("EHENVIOMAIL"), resultSet
								.getString("EHDIREMAIL"), resultSet
								.getString("EHRESPUESTATRASPASO"), resultSet
								.getString("TRCODIGO"), resultSet
								.getString("TRNOMBRE"), resultSet
								.getString("TRNOMBREE"), resultSet
								.getDate("TRBAJA"), resultSet
								.getString("MOCODIGO"), resultSet
								.getString("MOCOOR"), resultSet
								.getString("MONOMBRE"), resultSet
								.getString("MOCOEM"), resultSet
								.getString("HDCODIGO"), null, null, null, null,
								null, null, null, null, null, resultSet
										.getString("CODORG"), resultSet
										.getString("NOMBREES"), resultSet
										.getString("NOMBREEU"), null, null,
								null, null, null, null, resultSet
										.getString("EHAUTOMATICO"));
					}
				}, tramiteHechoDetalle.getEhcodigo());
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findNombreTramiteGenericoTramiteHecho(
			TramiteHechoDetalle tramiteHechoDetalle) {
		String query = "SELECT  t1.EHCODIGO EHCODIGO,t1.EHNOMBRETRAMITE EHNOMBRETRAMITE "
				+ "FROM TRAMITE_HECHO t1 " + "WHERE 1=1 AND t1.EHCODIGO = ? ";
		return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query,
				new RowMapper<TramiteHechoDetalle>() {
					public TramiteHechoDetalle mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new TramiteHechoDetalle(resultSet
								.getString("EHCODIGO"), resultSet
								.getString("EHNOMBRETRAMITE"));
					}
				}, tramiteHechoDetalle.getEhcodigo());
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findLobTablaTemporal(
			TramiteHechoDetalle tramiteHechoDetalle) {
		String query = "SELECT EHCODIGO, EHTEXTO " + "FROM TRAMITE_HECHO  "
				+ "WHERE EHCODIGO = ? ";
		return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query,
				new RowMapper<TramiteHechoDetalle>() {
					public TramiteHechoDetalle mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new TramiteHechoDetalle(resultSet
								.getString("EHCODIGO"), null, null, null, null,
								resultSet.getString("EHTEXTO"), null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null);
					}
				}, tramiteHechoDetalle.getEhcodigo());
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findUltimoTramiteHechoPorTipoTramite(
			TramiteHechoDetalle tramiteHechoDetalle) {
		try {
			String query = "SELECT tr1.EHCODIGO EHCODIGO, tr1.EHFECHA EHFECHA, tr1.EHCOORTRASPASO EHCOORTRASPASO "
					+ "FROM TRAMITE_HECHO tr1 "
					+ "WHERE to_date(to_char(tr1.EHFECHA, 'DD/MM/YYYY') || ' ' || tr1.EHHORA) = (SELECT max(to_date(to_char(tr2.EHFECHA, 'DD/MM/YYYY') || ' ' || tr2.EHHORA)) FROM TRAMITE_HECHO tr2 WHERE tr2.EHCOHD=? AND tr2.EHCOTEE=? )	AND tr1.EHCOHD=? AND tr1.EHCOTEE=? AND ROWNUM=1";
			return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(
					query,
					new RowMapper<TramiteHechoDetalle>() {
						public TramiteHechoDetalle mapRow(ResultSet resultSet,
								int rowNum) throws SQLException {
							return new TramiteHechoDetalle(resultSet
									.getString("EHCODIGO"), resultSet
									.getDate("EHFECHA"), null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, resultSet
											.getString("EHCOORTRASPASO"), null,
									null, null, null, null, null, null, null,
									null);
						}
					}, tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle
							.getTrcodigo(), tramiteHechoDetalle.getHdcodigo(),
					tramiteHechoDetalle.getTrcodigo());
		} catch (EmptyResultDataAccessException e) {
			return new TramiteHechoDetalle();
		} catch (DataIntegrityViolationException e) {
			return new TramiteHechoDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param plantillaTramiteHechoDetalle
	 *            PlantillaTramiteHechoDetalle
	 * @return PlantillaTramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public PlantillaTramiteHechoDetalle findPlantillaTramiteHecho(
			PlantillaTramiteHechoDetalle plantillaTramiteHechoDetalle) {

		String query = "SELECT t1.DECODIGO DECODIGO, t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t2.HDCODIGO HDCODIGO, t2.HDNROR HDNROR ,t2.HDCAPTSO HDCAPTSO, t2.HDTESO HDTESO, t9.TSRNOMBRE TSRNOMBRE,t9.TSRNOMBREE TSRNOMBREE,t3.ESCODIGO ESCODIGO, t3.ESNOMBRE ESNOMBRE, t3.ESNIF ESNIF, t3.ESNOCO ESNOCO, t3.ESINADAR ESINADAR, t3.ESNORA_PROVINCIA_ID ESNORAPROVINCIAID, t3.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIA, t3.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOID, t3.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIO, t3.ESNORA_LOCALIDAD_ID ESNORALOCALIDADID, t3.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDAD, t3.ESNORA_CALLE_ID ESNORACALLEID, t3.ESNOMBRE_CALLE ESNOMBRECALLE, t3.ESNORA_CP_ID ESNORACPID, t3.ESNOMBRE_CP ESNOMBRECP, t3.ESNORA_PORTAL_ID ESNORAPORTALID, t3.ESNOMBRE_PORTAL ESNOMBREPORTAL, t3.ESNOMBRE_PISO ESNOMBREPISO, t3.ESNOLO ESNOLO, t3.ESNODIR ESNODIR, t3.ESNRCOPO ESNRCOPO, t3.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPV, t3.ESEXTRANJERO ESEXTRANJERO, T3.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBRE,T3.ESCOEM ESCOEM,T3.ESNRTEL ESNRTEL, t4.DTCODIGO DTCODIGO, (RTRIM(t4.DTNOMBRE) || ' ' || RTRIM(t4.DTAPELLIDO1) || ' ' || RTRIM(t4.DTAPELLIDO2)) as DTNOMBRE, t4.DTNIF DTNIF, t4.DTNORA_PROVINCIA_ID DTNORAPROVINCIAID, t4.DTNOMBRE_PROVINCIA DTNOMBREPROVINCIA, t4.DTNORA_MUNICIPIO_ID DTNORAMUNICIPIOID, t4.DTNOMBRE_MUNICIPIO DTNOMBREMUNICIPIO, t4.DTNORA_LOCALIDAD_ID DTNORALOCALIDADID, t4.DTNOMBRE_LOCALIDAD DTNOMBRELOCALIDAD, t4.DTNORA_CALLE_ID DTNORACALLEID, t4.DTNOMBRE_CALLE DTNOMBRECALLE, t4.DTNORA_CP_ID DTNORACPID, t4.DTNOMBRE_CP DTNOMBRECP, t4.DTNORA_PORTAL_ID DTNORAPORTALID, t4.DTNOMBRE_PORTAL DTNOMBREPORTAL, t4.DTNOMBRE_PISO DTNOMBREPISO, t4.DTNOLO DTNOLO, t4.DTNODIR DTNODIR, t4.DTNRCOPO DTNRCOPO, t4.DTDIRECCION_NOCAPV DTDIRECCION_NOCAPV, T4.DTEXTRANJERO DTEXTRANJERO, T4.DTNORA_PAIS_NOMBRE DTNORAPAISNOMBRE, T4.DTTECOEM DTTECOEM,T4.DTNRTEL DTNRTEL,t6.COD_ORG CODORG, t6.NOMBRE_ES NOMBREES, t6.NOMBRE_EU NOMBREEU,  t6.NORA_PROVINCIA_ID NORAPROVINCIAID, t6.NOMBRE_PROVINCIA NOMBREPROVINCIA, t6.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t6.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t6.NORA_LOCALIDAD_ID NORALOCALIDADID, t6.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t6.NORA_CALLE_ID NORACALLEID, t6.NOMBRE_CALLE NOMBRECALLE, t6.NORA_CP_ID NORACPID, t6.NOMBRE_CP NOMBRECP, t6.NORA_PORTAL_ID NORAPORTALID, t6.NOMBRE_PORTAL NOMBREPORTAL, t6.EMAIL EMAIL, t6.TELEFONO TELEFONO, t7.EHCODIGO EHCODIGO, t7.EHFECHA EHFECHA, t8.COD_ORG CODORGTRASPASO, t8.NOMBRE_ES NOMBREESTRASPASO, t8.NOMBRE_EU NOMBREEUTRASPASO,  t8.NORA_PROVINCIA_ID NORAPROVINCIAIDTRASPASO, t8.NOMBRE_PROVINCIA NOMBREPROVINCIATRASPASO, t8.NORA_MUNICIPIO_ID NORAMUNICIPIOIDTRASPASO, t8.NOMBRE_MUNICIPIO NOMBREMUNICIPIOTRASPASO, t8.NORA_LOCALIDAD_ID NORALOCALIDADIDTRASPASO, t8.NOMBRE_LOCALIDAD NOMBRELOCALIDADTRASPASO, t8.NORA_CALLE_ID NORACALLEIDTRASPASO, t8.NOMBRE_CALLE NOMBRECALLETRASPASO, t8.NORA_CP_ID NORACPIDTRASPASO, t8.NOMBRE_CP NOMBRECPTRASPASO, t8.NORA_PORTAL_ID NORAPORTALIDTRASPASO, t8.NOMBRE_PORTAL NOMBREPORTALTRASPASO, t8.EMAIL EMAILTRASPASO, t8.TELEFONO TELEFONOTRASPASO "
				+ "FROM DENUNCIA t1 ,HECHO_DENUNCIADO t2,ESTABLECIMIENTO t3, CONSUMIDOR t4, DECISION_HECHO t5, ORGANISMO t6,TRAMITE_HECHO t7, ORGANISMO t8, TIPO_RECLAMACION t9 "
				+ "WHERE 1=1 AND t1.DECODIGO= t2.HDCODE(+)  AND t2.HDCOES= t3.ESCODIGO(+) AND t1.DECODT= t4.DTCODIGO(+) AND t2.HDCODIGO = t5.HCCOHD AND t5.HCCOOR= t6.COD_ORG AND t2.HDCODIGO = t7.EHCOHD(+) AND t7.EHCOORTRASPASO = t8.COD_ORG(+) AND t2.HDCOTSR = t9.TSRCODIGO(+) AND t7.EHCODIGO = ? ";

		return (PlantillaTramiteHechoDetalle) this.jdbcTemplate.queryForObject(
				query, new RowMapper<PlantillaTramiteHechoDetalle>() {
					public PlantillaTramiteHechoDetalle mapRow(
							ResultSet resultSet, int rowNum)
							throws SQLException {

						return new PlantillaTramiteHechoDetalle(resultSet
								.getString("DECODIGO"), resultSet
								.getString("DECOOR"), resultSet
								.getBigDecimal("DENRAN"), resultSet
								.getBigDecimal("DENROR"), resultSet
								.getString("HDCODIGO"), resultSet
								.getBigDecimal("HDNROR"), resultSet
								.getBigDecimal("HDCAPTSO"), resultSet
								.getString("HDTESO"), resultSet
								.getString("TSRNOMBRE"), resultSet
								.getString("TSRNOMBREE"), resultSet
								.getString("DTCODIGO"), resultSet
								.getString("DTNOMBRE"), resultSet
								.getString("DTNIF"), resultSet
								.getString("DTNORAPROVINCIAID"), resultSet
								.getString("DTNOMBREPROVINCIA"), resultSet
								.getString("DTNORAMUNICIPIOID"), resultSet
								.getString("DTNOMBREMUNICIPIO"), resultSet
								.getString("DTNORALOCALIDADID"), resultSet
								.getString("DTNOMBRELOCALIDAD"), resultSet
								.getString("DTNORACALLEID"), resultSet
								.getString("DTNOMBRECALLE"), resultSet
								.getString("DTNORACPID"), resultSet
								.getString("DTNOMBRECP"), resultSet
								.getString("DTNORAPORTALID"), resultSet
								.getString("DTNOMBREPORTAL"), resultSet
								.getString("DTNOMBREPISO"), resultSet
								.getString("DTNOLO"), resultSet
								.getString("DTNODIR"), resultSet
								.getString("DTNRCOPO"), resultSet
								.getString("DTDIRECCION_NOCAPV"), resultSet
								.getString("DTEXTRANJERO"), resultSet
								.getString("DTNORAPAISNOMBRE"), resultSet
								.getString("DTTECOEM"), resultSet
								.getString("DTNRTEL"), resultSet
								.getString("ESCODIGO"), resultSet
								.getString("ESNOMBRE"), resultSet
								.getString("ESNIF"), resultSet
								.getString("ESNOCO"), resultSet
								.getString("ESINADAR"), resultSet
								.getString("ESNORAPROVINCIAID"), resultSet
								.getString("ESNOMBREPROVINCIA"), resultSet
								.getString("ESNORAMUNICIPIOID"), resultSet
								.getString("ESNOMBREMUNICIPIO"), resultSet
								.getString("ESNORALOCALIDADID"), resultSet
								.getString("ESNOMBRELOCALIDAD"), resultSet
								.getString("ESNORACALLEID"), resultSet
								.getString("ESNOMBRECALLE"), resultSet
								.getString("ESNORACPID"), resultSet
								.getString("ESNOMBRECP"), resultSet
								.getString("ESNORAPORTALID"), resultSet
								.getString("ESNOMBREPORTAL"), resultSet
								.getString("ESNOMBREPISO"), resultSet
								.getString("ESNOLO"), resultSet
								.getString("ESNODIR"), resultSet
								.getString("ESNRCOPO"), resultSet
								.getString("ESDIRECCION_NOCAPV"), resultSet
								.getString("ESEXTRANJERO"), resultSet
								.getString("ESNORAPAISNOMBRE"), resultSet
								.getString("ESCOEM"), resultSet
								.getString("ESNRTEL"), resultSet
								.getString("CODORG"), resultSet
								.getString("NOMBREES"), resultSet
								.getString("NOMBREEU"), resultSet
								.getString("NORAPROVINCIAID"), resultSet
								.getString("NOMBREPROVINCIA"), resultSet
								.getString("NORAMUNICIPIOID"), resultSet
								.getString("NOMBREMUNICIPIO"), resultSet
								.getString("NORALOCALIDADID"), resultSet
								.getString("NOMBRELOCALIDAD"), resultSet
								.getString("NORACALLEID"), resultSet
								.getString("NOMBRECALLE"), resultSet
								.getString("NORACPID"), resultSet
								.getString("NOMBRECP"), resultSet
								.getString("NORAPORTALID"), resultSet
								.getString("NOMBREPORTAL"), resultSet
								.getString("EMAIL"), resultSet
								.getString("TELEFONO"), resultSet
								.getString("EHCODIGO"), resultSet
								.getDate("EHFECHA"), resultSet
								.getString("CODORGTRASPASO"), resultSet
								.getString("NOMBREESTRASPASO"), resultSet
								.getString("NOMBREEUTRASPASO"), resultSet
								.getString("NORAPROVINCIAIDTRASPASO"),
								resultSet.getString("NOMBREPROVINCIATRASPASO"),
								resultSet.getString("NORAMUNICIPIOIDTRASPASO"),
								resultSet.getString("NOMBREMUNICIPIOTRASPASO"),
								resultSet.getString("NORALOCALIDADIDTRASPASO"),
								resultSet.getString("NOMBRELOCALIDADTRASPASO"),
								resultSet.getString("NORACALLEIDTRASPASO"),
								resultSet.getString("NOMBRECALLETRASPASO"),
								resultSet.getString("NORACPIDTRASPASO"),
								resultSet.getString("NOMBRECPTRASPASO"),
								resultSet.getString("NORAPORTALIDTRASPASO"),
								resultSet.getString("NOMBREPORTALTRASPASO"),
								resultSet.getString("EMAILTRASPASO"), resultSet
										.getString("TELEFONOTRASPASO"));
					}
				}, plantillaTramiteHechoDetalle.getEhcodigo());
	}

	/**
	 * Finds rows in the TramiteHecho table using like.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteHecho> findAllLike(TramiteHecho tramitehecho,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO(+) AND t1.EHCOMO= t3.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.EHCODIGO EHCODIGO,t1.EHFECHA EHFECHA,t1.EHHORA EHHORA,t1.EHCODPOR EHCODPOR,t1.EHCODPDE EHCODPDE,t1.EHTEXTO EHTEXTO,t1.EHCOZS EHCOZS,t1.EHCIVIHE EHCIVIHE,t1.EHACUSE EHACUSE,t1.EHENVIOMAIL EHENVIOMAIL,t1.EHDIREMAIL EHDIREMAIL, t1.EHCOORTRASPASO EHCOORTRASPASO, t1.EHRESPUESTATRASPASO EHRESPUESTATRASPASO, t2.TRCODIGO TRAMITETRCODIGO,t2.TRNOMBRE TRAMITETRNOMBRE,t2.TRNOMBREE TRAMITETRNOMBREE,t2.TRBAJA TRAMITETRBAJA,t3.MOCODIGO CENSOMONITORMOCODIGO,t3.MONOMBRE CENSOMONITORMONOMBRE,t3.MOCOEM CENSOMONITORMOCOEM,t3.MOUSU CENSOMONITORMOUSU,t3.MOCLAVE CENSOMONITORMOCLAVE,t3.MOFECBAJA CENSOMONITORMOFECBAJA,t3.MOADMIN CENSOMONITORMOADMIN,t3.MOPRIMERA CENSOMONITORMOPRIMERA,t4.HDCODIGO HECHODENUNCIADOHDCODIGO,t4.HDNROR HECHODENUNCIADOHDNROR,t4.HDTE HECHODENUNCIADOHDTE,t4.HDTEDOAD HECHODENUNCIADOHDTEDOAD,t4.HDCOAV HECHODENUNCIADOHDCOAV,t4.HDNOPS HECHODENUNCIADOHDNOPS,t4.HDNOMAPS HECHODENUNCIADOHDNOMAPS,t4.HDNOMOPS HECHODENUNCIADOHDNOMOPS,t4.HDNRLOPS HECHODENUNCIADOHDNRLOPS,t4.HDFEDMPS HECHODENUNCIADOHDFEDMPS,t4.HDINSOTR HECHODENUNCIADOHDINSOTR,t4.HDINSOMA HECHODENUNCIADOHDINSOMA,t4.HDCAPTSO HECHODENUNCIADOHDCAPTSO,t4.HDTESO HECHODENUNCIADOHDTESO,t4.HDFEARDT HECHODENUNCIADOHDFEARDT,t4.HDFEIOHD HECHODENUNCIADOHDFEIOHD,t4.HDINININ HECHODENUNCIADOHDINININ,t4.HDFEIOPC HECHODENUNCIADOHDFEIOPC,t4.HDFEROPC HECHODENUNCIADOHDFEROPC,t4.HDCOREPC HECHODENUNCIADOHDCOREPC,t4.HDFEIORP HECHODENUNCIADOHDFEIORP,t4.HDFERORP HECHODENUNCIADOHDFERORP,t4.HDCOREAP HECHODENUNCIADOHDCOREAP,t4.HDFEIORA HECHODENUNCIADOHDFEIORA,t4.HDTEACPA HECHODENUNCIADOHDTEACPA,t4.HDFECEAC HECHODENUNCIADOHDFECEAC,t4.HDHOCEAC HECHODENUNCIADOHDHOCEAC,t4.HDFEIOCA HECHODENUNCIADOHDFEIOCA,t4.HDTEACDE HECHODENUNCIADOHDTEACDE,t4.HDFEIOAC HECHODENUNCIADOHDFEIOAC,t4.HDFEIOFC HECHODENUNCIADOHDFEIOFC,t4.HDCOTRA HECHODENUNCIADOHDCOTRA,t4.HDTE02 HECHODENUNCIADOHDTE02,t4.HDTE03 HECHODENUNCIADOHDTE03,t4.HDTE04 HECHODENUNCIADOHDTE04,t4.HDTE05 HECHODENUNCIADOHDTE05,t4.HDTE06 HECHODENUNCIADOHDTE06,t4.HDTE07 HECHODENUNCIADOHDTE07,t4.HDTE08 HECHODENUNCIADOHDTE08,t4.HDTE09 HECHODENUNCIADOHDTE09,t4.HDTE10 HECHODENUNCIADOHDTE10,t4.HDCOSC HECHODENUNCIADOHDCOSC,t4.HDIDAL HECHODENUNCIADOHDIDAL,t4.HDFEROAD HECHODENUNCIADOHDFEROAD,t4.HDFEROAT HECHODENUNCIADOHDFEROAT,t4.HDTEALDT HECHODENUNCIADOHDTEALDT,t4.HDTEDEAT HECHODENUNCIADOHDTEDEAT,t4.HDFEDEAT HECHODENUNCIADOHDFEDEAT,t4.HDFEHD HECHODENUNCIADOHDFEHD,t4.HDTEDOADE HECHODENUNCIADOHDTEDOADE,t4.HDTEDOADI HECHODENUNCIADOHDTEDOADI,t4.HDTEDOADF HECHODENUNCIADOHDTEDOADF,t4.HDTEDOADA HECHODENUNCIADOHDTEDOADA,t4.HDNOPSE HECHODENUNCIADOHDNOPSE,t4.HDNOPSI HECHODENUNCIADOHDNOPSI,t4.HDNOPSF HECHODENUNCIADOHDNOPSF,t4.HDNOPSA HECHODENUNCIADOHDNOPSA,t4.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO,t3.MOCOOR CENSOMONITORMOCOOR,t4.HDCODE HECHODENUNCIADOHDCODE,t4.HDCOES HECHODENUNCIADOHDCOES,t4.HDCOSE HECHODENUNCIADOHDCOSE,t4.HDCOMO HECHODENUNCIADOHDCOMO,t4.HDCOPS HECHODENUNCIADOHDCOPS,t4.HDCOTSR HECHODENUNCIADOHDCOTSR,t4.HDCOTIR HECHODENUNCIADOHDCOTIR "
						+ "FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3 ,HECHO_DENUNCIADO t4 ");

		if (tramitehecho != null && tramitehecho.getEhcodigo() != null) {
			where.append(" AND UPPER(t1.EHCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCODIGO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramite() != null
				&& tramitehecho.getTramite().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramite().getTrcodigo() + "%");
			} else {
				params.add("%" + tramitehecho.getTramite().getTrcodigo() + "%");
			}
			where.append(" AND t2.TRCODIGO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramite() != null
				&& tramitehecho.getTramite().getTrnombre() != null) {
			where.append(" AND UPPER(t2.TRNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramite().getTrnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getTramite().getTrnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.TRNOMBRE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramite() != null
				&& tramitehecho.getTramite().getTrnombree() != null) {
			where.append(" AND UPPER(t2.TRNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramite().getTrnombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getTramite().getTrnombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRNOMBREE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramite() != null
				&& tramitehecho.getTramite().getTrbaja() != null) {
			where.append(" AND t2.TRBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramite().getTrbaja() + "%");
			} else {
				params.add("%" + tramitehecho.getTramite().getTrbaja() + "%");
			}
			where.append(" AND t2.TRBAJA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t3.MOCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getCensoMonitor().getMocodigo() + "%");
			} else {
				params.add("%" + tramitehecho.getCensoMonitor().getMocodigo()
						+ "%");
			}
			where.append(" AND t3.MOCODIGO IS NOT NULL");
		}
		if (tramitehecho != null
				&& tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getOrganismo() != null
				&& tramitehecho.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND UPPER(t3.MOCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getCensoMonitor().getOrganismo()
						.getCodOrg().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getCensoMonitor().getOrganismo()
								.getCodOrg().toUpperCase() + "%");
			}
			where.append(" AND t3.MOCOOR IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMonombre() != null) {
			where.append(" AND UPPER(t3.MONOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getCensoMonitor().getMonombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getCensoMonitor().getMonombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.MONOMBRE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMocoem() != null) {
			where.append(" AND UPPER(t3.MOCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getCensoMonitor().getMocoem()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getCensoMonitor().getMocoem()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.MOCOEM IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMousu() != null) {
			where.append(" AND UPPER(t3.MOUSU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getCensoMonitor().getMousu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getCensoMonitor().getMousu()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.MOUSU IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMoclave() != null) {
			where.append(" AND UPPER(t3.MOCLAVE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getCensoMonitor().getMoclave()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getCensoMonitor().getMoclave()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.MOCLAVE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t3.MOFECBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getCensoMonitor().getMofecbaja() + "%");
			} else {
				params.add("%" + tramitehecho.getCensoMonitor().getMofecbaja()
						+ "%");
			}
			where.append(" AND t3.MOFECBAJA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMoadmin() != null) {
			where.append(" AND UPPER(t3.MOADMIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getCensoMonitor().getMoadmin()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getCensoMonitor().getMoadmin()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.MOADMIN IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getCensoMonitor() != null
				&& tramitehecho.getCensoMonitor().getMoprimera() != null) {
			where.append(" AND UPPER(t3.MOPRIMERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getCensoMonitor().getMoprimera()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getCensoMonitor().getMoprimera()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.MOPRIMERA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdcodigo()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdcodigo() + "%");
			}
			where.append(" AND t4.HDCODIGO IS NOT NULL");
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getDenuncia() != null
				&& tramitehecho.getHechoDenunciado().getDenuncia()
						.getDecodigo() != null) {
			where.append(" AND UPPER(t4.HDCODE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getDenuncia()
						.getDecodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getDenuncia()
								.getDecodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.HDCODE IS NOT NULL");
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getEstablecimiento() != null
				&& tramitehecho.getHechoDenunciado().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND UPPER(t4.HDCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado()
						.getEstablecimiento().getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado()
								.getEstablecimiento().getEscodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOES IS NOT NULL");
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getSector() != null
				&& tramitehecho.getHechoDenunciado().getSector().getSecodigo() != null) {
			where.append(" AND UPPER(t4.HDCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getSector()
						.getSecodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getSector()
								.getSecodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOSE IS NOT NULL");
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getCensoMonitor() != null
				&& tramitehecho.getHechoDenunciado().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND UPPER(t4.HDCOMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getCensoMonitor()
						.getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getCensoMonitor()
								.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOMO IS NOT NULL");
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getProducto() != null
				&& tramitehecho.getHechoDenunciado().getProducto()
						.getPscodigo() != null) {
			where.append(" AND UPPER(t4.HDCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getProducto()
						.getPscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getProducto()
								.getPscodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOPS IS NOT NULL");
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getTipoReclamacion() != null
				&& tramitehecho.getHechoDenunciado().getTipoReclamacion()
						.getTsrcodigo() != null) {
			where.append(" AND UPPER(t4.HDCOTSR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado()
						.getTipoReclamacion().getTsrcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado()
								.getTipoReclamacion().getTsrcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOTSR IS NOT NULL");
		}
		if (tramitehecho != null
				&& tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getMotivo() != null
				&& tramitehecho.getHechoDenunciado().getMotivo().getTircodigo() != null) {
			where.append(" AND UPPER(t4.HDCOTIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getMotivo()
						.getTircodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getMotivo()
								.getTircodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOTIR IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t4.HDNROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdnror() + "%");
			} else {
				params.add("%" + tramitehecho.getHechoDenunciado().getHdnror()
						+ "%");
			}
			where.append(" AND t4.HDNROR IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte() != null) {
			where.append(" AND UPPER(t4.HDTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdte()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdte()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND UPPER(t4.HDTEDOAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdtedoad()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdtedoad()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEDOAD IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND UPPER(t4.HDCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdcoav()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdcoav()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOAV IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND UPPER(t4.HDNOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdnops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdnops()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNOPS IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND UPPER(t4.HDNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdnomaps()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdnomaps()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNOMAPS IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND UPPER(t4.HDNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdnomops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdnomops()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNOMOPS IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND UPPER(t4.HDNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdnrlops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdnrlops()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNRLOPS IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t4.HDFEDMPS like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdfedmps()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdfedmps() + "%");
			}
			where.append(" AND t4.HDFEDMPS IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND UPPER(t4.HDINSOTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdinsotr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdinsotr()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDINSOTR IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND UPPER(t4.HDINSOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdinsoma()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdinsoma()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDINSOMA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t4.HDCAPTSO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdcaptso()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdcaptso() + "%");
			}
			where.append(" AND t4.HDCAPTSO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND UPPER(t4.HDTESO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdteso()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdteso()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTESO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t4.HDFEARDT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdfeardt()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdfeardt() + "%");
			}
			where.append(" AND t4.HDFEARDT IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t4.HDFEIOHD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdfeiohd()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdfeiohd() + "%");
			}
			where.append(" AND t4.HDFEIOHD IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND UPPER(t4.HDINININ) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdininin()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdininin()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDINININ IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t4.HDFEIOPC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdfeiopc()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdfeiopc() + "%");
			}
			where.append(" AND t4.HDFEIOPC IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t4.HDFEROPC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdferopc()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdferopc() + "%");
			}
			where.append(" AND t4.HDFEROPC IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND UPPER(t4.HDCOREPC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdcorepc()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdcorepc()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOREPC IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t4.HDFEIORP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdfeiorp()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdfeiorp() + "%");
			}
			where.append(" AND t4.HDFEIORP IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t4.HDFERORP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdferorp()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdferorp() + "%");
			}
			where.append(" AND t4.HDFERORP IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND UPPER(t4.HDCOREAP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdcoreap()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdcoreap()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOREAP IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t4.HDFEIORA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdfeiora()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdfeiora() + "%");
			}
			where.append(" AND t4.HDFEIORA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND UPPER(t4.HDTEACPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdteacpa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdteacpa()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEACPA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t4.HDFECEAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdfeceac()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdfeceac() + "%");
			}
			where.append(" AND t4.HDFECEAC IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND UPPER(t4.HDHOCEAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdhoceac()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdhoceac()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDHOCEAC IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t4.HDFEIOCA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdfeioca()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdfeioca() + "%");
			}
			where.append(" AND t4.HDFEIOCA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND UPPER(t4.HDTEACDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdteacde()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdteacde()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEACDE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t4.HDFEIOAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdfeioac()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdfeioac() + "%");
			}
			where.append(" AND t4.HDFEIOAC IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t4.HDFEIOFC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdfeiofc()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdfeiofc() + "%");
			}
			where.append(" AND t4.HDFEIOFC IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND UPPER(t4.HDCOTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdcotra()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdcotra()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOTRA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND UPPER(t4.HDTE02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdte02()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdte02()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE02 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND UPPER(t4.HDTE03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdte03()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdte03()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE03 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND UPPER(t4.HDTE04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdte04()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdte04()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE04 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND UPPER(t4.HDTE05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdte05()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdte05()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE05 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND UPPER(t4.HDTE06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdte06()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdte06()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE06 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND UPPER(t4.HDTE07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdte07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdte07()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE07 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND UPPER(t4.HDTE08) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdte08()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdte08()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE08 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND UPPER(t4.HDTE09) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdte09()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdte09()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE09 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND UPPER(t4.HDTE10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdte10()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdte10()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE10 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND UPPER(t4.HDCOSC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdcosc()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdcosc()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOSC IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND UPPER(t4.HDIDAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdidal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdidal()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDIDAL IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t4.HDFEROAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdferoad()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdferoad() + "%");
			}
			where.append(" AND t4.HDFEROAD IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t4.HDFEROAT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdferoat()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdferoat() + "%");
			}
			where.append(" AND t4.HDFEROAT IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND UPPER(t4.HDTEALDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdtealdt()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdtealdt()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEALDT IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND UPPER(t4.HDTEDEAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdtedeat()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdtedeat()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEDEAT IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t4.HDFEDEAT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdfedeat()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdfedeat() + "%");
			}
			where.append(" AND t4.HDFEDEAT IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t4.HDFEHD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdfehd() + "%");
			} else {
				params.add("%" + tramitehecho.getHechoDenunciado().getHdfehd()
						+ "%");
			}
			where.append(" AND t4.HDFEHD IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND UPPER(t4.HDTEDOADE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdtedoade()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdtedoade()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEDOADE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND UPPER(t4.HDTEDOADI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdtedoadi()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdtedoadi()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEDOADI IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND UPPER(t4.HDTEDOADF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdtedoadf()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdtedoadf()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEDOADF IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND UPPER(t4.HDTEDOADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdtedoada()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdtedoada()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEDOADA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND UPPER(t4.HDNOPSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdnopse()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdnopse()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNOPSE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND UPPER(t4.HDNOPSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdnopsi()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdnopsi()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNOPSI IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND UPPER(t4.HDNOPSF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdnopsf()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdnopsf()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNOPSF IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND UPPER(t4.HDNOPSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdnopsa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdnopsa()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNOPSA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getHechoDenunciado() != null
				&& tramitehecho.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND UPPER(t4.HDCOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getHechoDenunciado().getHdcocodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramitehecho.getHechoDenunciado().getHdcocodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOCODIGO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhfecha() != null) {
			where.append(" AND t1.EHFECHA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhfecha() + "%");
			} else {
				params.add("%" + tramitehecho.getEhfecha() + "%");
			}
			where.append(" AND t1.EHFECHA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhhora() != null) {
			where.append(" AND UPPER(t1.EHHORA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhhora().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhhora().toUpperCase() + "%");
			}
			where.append(" AND t1.EHHORA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcodpor() != null) {
			where.append(" AND UPPER(t1.EHCODPOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcodpor().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcodpor().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCODPOR IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcodpde() != null) {
			where.append(" AND UPPER(t1.EHCODPDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcodpde().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcodpde().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCODPDE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhtexto() != null) {
			where.append(" AND UPPER(t1.EHTEXTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhtexto().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhtexto().toUpperCase() + "%");
			}
			where.append(" AND t1.EHTEXTO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcozs() != null) {
			where.append(" AND UPPER(t1.EHCOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcozs().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcozs().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCOZS IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcivihe() != null) {
			where.append(" AND t1.EHCIVIHE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcivihe() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcivihe() + "%");
			}
			where.append(" AND t1.EHCIVIHE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhacuse() != null) {
			where.append(" AND t1.EHACUSE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhacuse() + "%");
			} else {
				params.add("%" + tramitehecho.getEhacuse() + "%");
			}
			where.append(" AND t1.EHACUSE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhenviomail() != null) {
			where.append(" AND UPPER(t1.EHENVIOMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhenviomail().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhenviomail().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.EHENVIOMAIL IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhdiremail() != null) {
			where.append(" AND UPPER(t1.EHDIREMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhdiremail().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhdiremail().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.EHDIREMAIL IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TramiteHecho>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(readOnly = true)
	public TramiteHecho findCLobsTabla(TramiteHecho tramiteHecho) {
		try {
			String query = "SELECT EHCODIGO, EHSIGUIENTESTRAMITES, EHTEXTOACUERDO, EHINSTRUCINSPECC, EHMOTIVORECHAZO, EHMOTIVORECURSO,EHRESUMENALEGACION,EHRESUMENMEDIACION,EHTEXTOCOMUNICACION,EHINTERVINIENTES,EHJUSTIFICACIONINFRACCION "
					+ "FROM TRAMITE_HECHO  " + "WHERE EHCODIGO = ? ";
			return (TramiteHecho) this.jdbcTemplate.queryForObject(query,
					new RowMapper<TramiteHecho>() {
						public TramiteHecho mapRow(ResultSet resultSet,
								int rowNum) throws SQLException {
							return new TramiteHecho(resultSet
									.getString("EHCODIGO"), resultSet
									.getClob("EHSIGUIENTESTRAMITES"), resultSet
									.getClob("EHTEXTOACUERDO"), resultSet
									.getClob("EHINSTRUCINSPECC"), resultSet
									.getClob("EHMOTIVORECHAZO"), resultSet
									.getClob("EHMOTIVORECURSO"), resultSet
									.getClob("EHRESUMENALEGACION"), resultSet
									.getClob("EHRESUMENMEDIACION"), resultSet
									.getClob("EHTEXTOCOMUNICACION"), resultSet
									.getClob("EHINTERVINIENTES"), resultSet
									.getClob("EHJUSTIFICACIONINFRACCION"));
						}
					}, tramiteHecho.getEhcodigo());
		} catch (EmptyResultDataAccessException e) {
			return new TramiteHecho();
		}
	}

	/**
	 * Busca la última fase ejecutada del trámite
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle datos del trámite con el código de trámite
	 *            informado
	 * @return TramiteHechoDetalle datos del tramite
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findUltimaFase(
			TramiteHechoDetalle tramiteHechoDetalle) {
		String query = "select FNOMBRE, FNOMBREE FROM(SELECT tr3.FNOMBRE FNOMBRE, tr3.FNOMBREE FNOMBREE FROM TRAMITE_HECHO tr1, TRAMITE tr2, FASE tr3 WHERE tr1.EHCOTEE = tr2.TRCODIGO AND tr2.FCODIGO = tr3.FCODIGO(+) AND tr2.FCODIGO IS NOT NULL AND tr1.EHCOHD=? AND EHFECHA <= (SELECT EHFECHA FROM TRAMITE_HECHO tr2 WHERE tr2.EHCODIGO=? ) ORDER BY EHFECHA DESC, EHHORA DESC) WHERE ROWNUM=1 ";

		return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query,
				new RowMapper<TramiteHechoDetalle>() {
					public TramiteHechoDetalle mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new TramiteHechoDetalle(null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								resultSet.getString("FNOMBRE"), resultSet
										.getString("FNOMBREE"), null, null);
					}
				}, tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle
						.getEhcodigo());
	}

	/**
	 * Consulta los tramites asociados al detalle de un hecho obteniendo los
	 * datos de cada trámite y el número de documentos asociados a cada uno de
	 * ellos.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle filtro de búsqueda con ehcodigo informado
	 * @param pagination
	 *            Pagination datos de paginacion
	 * @return List<TramiteHechoDetalle> lista de tramites. Se almacena el dato
	 *         relativo al número de documentos en el campo de texto
	 *         multidocumento.
	 */
	@Transactional(readOnly = true)
	public List<TramiteHechoDetalle> findAllTramiteHechoCountDoc(
			TramiteHechoDetalle tramiteHechoDetalle, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");
		where.append("AND t1.EHCOTEE= t2.TRCODIGO ");
		where.append("AND t1.EHCOMO= t3.MOCODIGO(+) ");
		where.append("AND t1.EHCOHD= t4.HDCODIGO(+) ");
		where.append("AND t1.EHCODIGO = t5.Q5TRAMITE(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.EHCODIGO EHCODIGO,t1.EHFECHA EHFECHA,t1.EHHORA EHHORA,t1.EHCODPOR EHCODPOR, ");
		query.append("t1.EHCODPDE EHCODPDE, t1.EHCOZS EHCOZS,t1.EHCIVIHE EHCIVIHE,t1.EHACUSE EHACUSE,t1.EHENVIOMAIL EHENVIOMAIL,");
		query.append("t1.EHDIREMAIL EHDIREMAIL, t1.EHCOORTRASPASO EHCOORTRASPASO, t1.EHRESPUESTATRASPASO EHRESPUESTATRASPASO, t2.TRCODIGO TRCODIGO,t2.TRNOMBRE TRNOMBRE,");
		query.append("t2.TRNOMBREE TRNOMBREE,t2.TRBAJA TRBAJA, t3.MOCODIGO MOCODIGO,t3.MONOMBRE MONOMBRE,t3.MOCOOR MOCOOR, ");
		query.append("t3.MOCOEM MOCOEM, t4.HDCODIGO HDCODIGO, count(t5.Q5CODOCUMENTO) NUMDOC ");
		// , t5.Q5CODOCUMENTO Q5CODOCUMENTO,t5.Q5NOFILE Q5NOFILE,t5.Q5SIZEFILE
		// Q5SIZEFILE,t5.Q5TEDESFILE Q5TEDESFILE,t5.Q5ORIGEN Q5ORIGEN,t5.Q5FECHA
		// Q5FECHA,t5.Q5INDMAIL Q5INDMAIL, t5.Q5CONTENTTYPEFILE
		// Q5CONTENTTYPEFILE "
		query.append("FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3 ,HECHO_DENUNCIADO t4,DOCUMENTO_HECHO t5 ");

		if (tramiteHechoDetalle != null
				&& tramiteHechoDetalle.getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO = ?");
			params.add(tramiteHechoDetalle.getHdcodigo());
		}
		if (tramiteHechoDetalle != null
				&& tramiteHechoDetalle.getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(tramiteHechoDetalle.getTrcodigo());
		}

		query.append(where);
		query.append(" GROUP BY t1.EHCODIGO, t1.EHFECHA, t1.EHHORA, t1.EHCODPOR, t1.EHCODPDE, t1.EHCOZS, t1.EHCIVIHE, ");
		query.append("t1.EHACUSE, t1.EHENVIOMAIL, t1.EHDIREMAIL, t1.EHCOORTRASPASO, t1.EHRESPUESTATRASPASO, t2.TRCODIGO, ");
		query.append("t2.TRNOMBRE,t2.TRNOMBREE,t2.TRBAJA,t3.MOCODIGO, t3.MONOMBRE, t3.MOCOOR, t3.MOCOEM, t4.HDCODIGO");

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TramiteHechoDetalle>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<TramiteHechoDetalle>() {
					public TramiteHechoDetalle mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new TramiteHechoDetalle(resultSet
								.getString("EHCODIGO"), resultSet
								.getDate("EHFECHA"), resultSet
								.getString("EHHORA"), resultSet
								.getString("EHCODPOR"), resultSet
								.getString("EHCODPDE"), null, resultSet
								.getString("EHCOZS"), resultSet
								.getBigDecimal("EHCIVIHE"), resultSet
								.getDate("EHACUSE"), resultSet
								.getString("EHENVIOMAIL"), resultSet
								.getString("EHDIREMAIL"), resultSet
								.getString("EHRESPUESTATRASPASO"), resultSet
								.getString("TRCODIGO"), resultSet
								.getString("TRNOMBRE"), resultSet
								.getString("TRNOMBREE"), resultSet
								.getDate("TRBAJA"), resultSet
								.getString("MOCODIGO"), resultSet
								.getString("MOCOOR"), resultSet
								.getString("MONOMBRE"), resultSet
								.getString("MOCOEM"), resultSet
								.getString("HDCODIGO"), null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, Long
										.toString(resultSet.getLong("NUMDOC")),
								null);
					}
				}, params.toArray());
	}

}
