package com.ejie.y41a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.PlantillaTramiteHechoDetalle;
import com.ejie.y41a.model.TramiteHecho;
import com.ejie.y41a.model.TramiteHechoDetalle;
import com.ejie.y41a.model.TramiteHechoKonbide;

/**
 * * TramiteHechoDao generated by UDA, 22-feb-2012 17:30:27.
 * 
 *  
 */

public interface TramiteHechoDao {

	/**
	 * Inserts a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	TramiteHecho add(TramiteHecho tramitehecho);

	/**
	 * Inserts a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoKonbide
	 *            TramiteHechoKonbide
	 * @return TramiteHechoKonbide
	 */
	public TramiteHechoKonbide addTramiteHechoKonbide(
			TramiteHechoKonbide tramiteHechoKonbide) throws Exception;

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	TramiteHecho update(TramiteHecho tramitehecho);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	TramiteHecho updateTramiteHecho(TramiteHecho tramitehecho);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	TramiteHecho find(TramiteHecho tramitehecho);

	/**
	 * Deletes a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return
	 */
	void remove(TramiteHecho tramitehecho);

	/**
	 * Removes all tramites of the Solicitud.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return
	 */
	void removeTramitesSolicitud(TramiteHecho tramitehecho);

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TramiteHecho> findAll(TramiteHecho tramitehecho, Pagination pagination);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return List
	 */
	Long findAllCount(TramiteHecho tramitehecho);

	/**
	 * Finds rows in the TramiteHecho table using like.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TramiteHecho> findAllLike(TramiteHecho tramitehecho,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TramiteHechoDetalle> findAllTramiteHecho(
			TramiteHechoDetalle tramiteHechoDetalle, Pagination pagination);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	Long findAllTramiteHechoCount(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	TramiteHechoDetalle findTramiteHecho(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	public TramiteHechoDetalle findNombreTramiteGenericoTramiteHecho(
			TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	TramiteHechoDetalle findUltimoTramiteHechoPorTipoTramite(
			TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param plantillaTramiteHechoDetalle
	 *            PlantillaTramiteHechoDetalle
	 * @return PlantillaTramiteHechoDetalle
	 */
	PlantillaTramiteHechoDetalle findPlantillaTramiteHecho(
			PlantillaTramiteHechoDetalle plantillaTramiteHechoDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	TramiteHechoDetalle findLobTablaTemporal(
			TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Busca la última fase ejecutada del trámite
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle datos del trámite con el código de trámite
	 *            informado
	 * @return TramiteHechoDetalle datos del tramite
	 */

	public TramiteHechoDetalle findUltimaFase(
			TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Consulta los tramites asociados al detalle de un hecho obteniendo los
	 * datos de cada trámite y el número de documentos asociados a cada uno de
	 * ellos.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle filtro de búsqueda con ehcodigo informado
	 * @param pagination
	 *            Pagination datos de paginacion
	 * @return List<TramiteHechoDetalle> lista de tramites. Se almacena el dato
	 *         relativo al número de documentos en el campo de texto
	 *         multidocumento.
	 */
	List<TramiteHechoDetalle> findAllTramiteHechoCountDoc(
			TramiteHechoDetalle tramiteHechoDetalle, Pagination pagination);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	public TramiteHecho findCLobsTabla(TramiteHecho tramiteHecho);
}
