package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Tramite;

/**
 * * TramiteDaoImpl generated by UDA, 05-mar-2012 9:11:42.
 * 
 *  
 */

@Repository
@Transactional
public class TramiteDaoImpl implements TramiteDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Tramite> rwMap = new RowMapper<Tramite>() {
		public Tramite mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Tramite(resultSet.getString("TRCODIGO"),
					resultSet.getString("TRNOMBRE"),
					resultSet.getString("TRNOMBREE"),
					resultSet.getDate("TRBAJA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return Tramite
	 */
	public Tramite add(Tramite tramite) {

		String query = "INSERT INTO TRAMITE( TRCODIGO,TRNOMBRE,TRNOMBREE,TRBAJA,ISKONTSUMONET)"
				+ "VALUES (?,?,?,?,?)";

		this.jdbcTemplate.update(query, tramite.getTrcodigo(),
				tramite.getTrnombre(), tramite.getTrnombree(),
				tramite.getTrbaja(), Y41aConstantes.SI);
		return tramite;
	}

	/**
	 * Updates a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return Tramite
	 */
	public Tramite update(Tramite tramite) {
		String query = "UPDATE TRAMITE SET TRNOMBRE=?,TRNOMBREE=?,TRBAJA=? WHERE TRCODIGO=?";
		this.jdbcTemplate.update(query, tramite.getTrnombre(),
				tramite.getTrnombree(), tramite.getTrbaja(),
				tramite.getTrcodigo());
		return tramite;
	}

	/**
	 * Updates a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return Tramite
	 */
	public Tramite updateFecha(Tramite tramite) {
		String query = "UPDATE TRAMITE SET TRBAJA=? WHERE TRCODIGO=?";
		this.jdbcTemplate.update(query, tramite.getTrbaja(),
				tramite.getTrcodigo());
		return tramite;
	}

	/**
	 * Finds a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return Tramite
	 */
	@Transactional(readOnly = true)
	public Tramite find(Tramite tramite) {
		String query = "SELECT t1.TRCODIGO TRCODIGO, t1.TRNOMBRE TRNOMBRE, t1.TRNOMBREE TRNOMBREE, t1.TRBAJA TRBAJA "
				+ "FROM TRAMITE t1  " + "WHERE t1.TRCODIGO = ?    ";
		return (Tramite) this.jdbcTemplate.queryForObject(query, rwMap,
				tramite.getTrcodigo());
	}

	/**
	 * Removes a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return
	 */
	public void remove(Tramite tramite) {
		String query = "DELETE  FROM TRAMITE WHERE TRCODIGO=?";
		this.jdbcTemplate.update(query, tramite.getTrcodigo());
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tramite> findAll(Tramite tramite, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNOMBRE TRNOMBRE,t1.TRNOMBREE TRNOMBREE,t1.TRBAJA TRBAJA "
						+ "FROM TRAMITE t1 ");

		where.append(" AND t1.ISKONTSUMONET = ? ");
		params.add(Y41aConstantes.SI);

		if (tramite != null && tramite.getTrcodigo() != null) {
			where.append(" AND t1.TRCODIGO = ?");
			params.add(tramite.getTrcodigo());
		}
		if (tramite != null && tramite.getTrnombre() != null) {
			where.append(" AND t1.TRNOMBRE = ?");
			params.add(tramite.getTrnombre());
		}
		if (tramite != null && tramite.getTrnombree() != null) {
			where.append(" AND t1.TRNOMBREE = ?");
			params.add(tramite.getTrnombree());
		}
		if (tramite != null && tramite.getTrbaja() != null) {
			where.append(" AND t1.TRBAJA = ?");
			params.add(tramite.getTrbaja());
		} else {
			// Al mostrar el listado en los combos evitar muestre elementos de
			// baja
			where.append(" AND t1.TRBAJA IS NULL ");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Tramite>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Counts rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Tramite tramite) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  TRAMITE t1  ");

		where.append(" AND t1.ISKONTSUMONET = ? ");
		params.add(Y41aConstantes.SI);

		if (tramite != null && tramite.getTrcodigo() != null) {
			where.append(" AND t1.TRCODIGO = ?");
			params.add(tramite.getTrcodigo());
		}
		if (tramite != null && tramite.getTrnombre() != null) {
			where.append(" AND t1.TRNOMBRE = ?");
			params.add(tramite.getTrnombre());
		}
		if (tramite != null && tramite.getTrnombree() != null) {
			where.append(" AND t1.TRNOMBREE = ?");
			params.add(tramite.getTrnombree());
		}
		if (tramite != null && tramite.getTrbaja() != null) {
			where.append(" AND t1.TRBAJA = ?");
			params.add(tramite.getTrbaja());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tramite> findAllTramites(Tramite tramite, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNOMBRE TRNOMBRE,t1.TRNOMBREE TRNOMBREE,t1.TRBAJA TRBAJA "
						+ "FROM TRAMITE t1 ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Tramite>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Counts rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramitesCount(Tramite tramite) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  TRAMITE t1  ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Tramite table using like.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tramite> findAllLike(Tramite tramite, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNOMBRE TRNOMBRE,t1.TRNOMBREE TRNOMBREE,t1.TRBAJA TRBAJA "
						+ "FROM TRAMITE t1 ");

		where.append(" AND t1.ISKONTSUMONET = ? ");
		params.add(Y41aConstantes.SI);

		if (tramite != null && tramite.getTrcodigo() != null) {
			where.append(" AND UPPER(t1.TRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramite.getTrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramite.getTrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCODIGO IS NOT NULL");
		}
		if (tramite != null && tramite.getTrnombre() != null) {
			where.append(" AND UPPER(t1.TRNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramite.getTrnombre().toUpperCase() + "%");
			} else {
				params.add("%" + tramite.getTrnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.TRNOMBRE IS NOT NULL");
		}
		if (tramite != null && tramite.getTrnombree() != null) {
			where.append(" AND UPPER(t1.TRNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramite.getTrnombree().toUpperCase() + "%");
			} else {
				params.add("%" + tramite.getTrnombree().toUpperCase() + "%");
			}
			where.append(" AND t1.TRNOMBREE IS NOT NULL");
		}
		if (tramite != null && tramite.getTrbaja() != null) {
			where.append(" AND t1.TRBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramite.getTrbaja() + "%");
			} else {
				params.add("%" + tramite.getTrbaja() + "%");
			}
			where.append(" AND t1.TRBAJA IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Tramite>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT SEQ_L21R6T00.NEXTVAL FROM DUAL");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Busca los trámites utilizables desde añadir trámite en el detalle del
	 * hecho. Se omiten los codigos de los trámites no utilizables.
	 * 
	 * @param tramite
	 *            Tramite filtro de trámite
	 * @param pagination
	 *            Pagination paginación
	 * @return List lista de trámites
	 */
	@Transactional(readOnly = true)
	public List<Tramite> findAllTramitesAlta(Tramite tramite,
			Pagination pagination) {
		List<String> codigosTramitesNoUtilizables = new ArrayList<String>();
		codigosTramitesNoUtilizables.add("1");
		codigosTramitesNoUtilizables.add("13");
		codigosTramitesNoUtilizables.add("K01");
		codigosTramitesNoUtilizables.add("K14");

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNOMBRE TRNOMBRE,t1.TRNOMBREE TRNOMBREE,t1.TRBAJA TRBAJA "
						+ "FROM TRAMITE t1 ");

		where.append(" AND t1.ISKONTSUMONET = ? ");
		params.add(Y41aConstantes.SI);

		for (String codigoNoUtilizable : codigosTramitesNoUtilizables) {
			where.append(" AND t1.TRCODIGO <> ?");
			params.add(codigoNoUtilizable);
		}

		if (tramite != null && tramite.getTrnombre() != null) {
			where.append(" AND t1.TRNOMBRE = ?");
			params.add(tramite.getTrnombre());
		}
		if (tramite != null && tramite.getTrnombree() != null) {
			where.append(" AND t1.TRNOMBREE = ?");
			params.add(tramite.getTrnombree());
		}
		if (tramite != null && tramite.getTrbaja() != null) {
			where.append(" AND t1.TRBAJA = ?");
			params.add(tramite.getTrbaja());
		} else {
			// Al mostrar el listado en los combos evitar muestre elementos de
			// baja
			where.append(" AND t1.TRBAJA IS NULL ");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Tramite>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Finds a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return Tramite
	 */
	@Transactional(readOnly = true)
	public Tramite findTramiteKontsumoGest(Tramite tramite) {
		try {
			String query = "SELECT t1.TEECODIGO TRCODIGO, t1.TEENOMBRE TRNOMBRE, t1.TEENOMBREE TRNOMBREE FROM TRAMITESKONTSUMOGEST t1  WHERE t1.TEECODIGO = ? ";

			List<Tramite> tramiteList = this.jdbcTemplate.query(query,
					new RowMapper<Tramite>() {
						public Tramite mapRow(ResultSet resultSet, int rowNum)
								throws SQLException {
							return new Tramite(resultSet.getString("TRCODIGO"),
									resultSet.getString("TRNOMBRE"), resultSet
											.getString("TRNOMBREE"), null);
						}
					}, tramite.getTrcodigo());
			return (Tramite) DataAccessUtils.uniqueResult(tramiteList);
		} catch (EmptyResultDataAccessException e) {
			return new Tramite();
		}
	}
}
