package com.ejie.y41a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Tramite;

/**
 * * TramiteDao generated by UDA, 05-mar-2012 9:11:42.
 * 
 *  
 */

public interface TramiteDao {

	/**
	 * Inserts a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	Tramite add(Tramite tramite);

	/**
	 * Updates a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	Tramite update(Tramite tramite);

	/**
	 * Updates a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	Tramite updateFecha(Tramite tramite);

	/**
	 * Finds a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	Tramite find(Tramite tramite);

	/**
	 * Deletes a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return
	 */
	void remove(Tramite tramite);

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tramite> findAll(Tramite tramite, Pagination pagination);

	/**
	 * Counts rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return List
	 */
	Long findAllCount(Tramite tramite);

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAllTramites(Tramite tramite, Pagination pagination);

	/**
	 * Counts rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Long
	 */
	public Long findAllTramitesCount(Tramite tramite);

	/**
	 * Finds rows in the Tramite table using like.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Tramite> findAllLike(Tramite tramite, Pagination pagination,
			Boolean startsWith);

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * Busca los trámites utilizables desde añadir trámite en el detalle del
	 * hecho
	 * 
	 * @param tramite
	 *            Tramite filtro de trámite
	 * @param pagination
	 *            Pagination paginación
	 * @return List lista de trámites
	 */
	List<Tramite> findAllTramitesAlta(Tramite tramite, Pagination pagination);

	/**
	 * Finds a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return Tramite
	 */
	public Tramite findTramiteKontsumoGest(Tramite tramite);
}
