package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Tipodoc;

/**
 *  * TipodocDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 *  
 */
 
@Repository
@Transactional
public class TipodocDaoImpl implements TipodocDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Tipodoc> rwMap = new RowMapper<Tipodoc>() {
		public Tipodoc mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Tipodoc(
               resultSet.getString("TDCODIGO"), resultSet.getString("TDNOMBRE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Tipodoc table.
     *
     * @param tipodoc Pagination
     * @return Tipodoc
     */
	public Tipodoc add(Tipodoc tipodoc) {

    	String query = "INSERT INTO TIPODOC( TDCODIGO,TDNOMBRE)"
        + "VALUES (?,?)";

		this.jdbcTemplate.update(query, tipodoc.getTdcodigo(), tipodoc.getTdnombre());
		return tipodoc;
	}

    /**
     * Updates a single row in the Tipodoc table.
     *
     * @param tipodoc Pagination
     * @return Tipodoc
     */
    public Tipodoc update(Tipodoc tipodoc) {
		String query = "UPDATE TIPODOC SET TDNOMBRE=? WHERE TDCODIGO=?";
		this.jdbcTemplate.update(query, tipodoc.getTdnombre(), tipodoc.getTdcodigo());
		return tipodoc;
	}

    /**
     * Finds a single row in the Tipodoc table.
     *
     * @param tipodoc Pagination
     * @return Tipodoc
     */
    @Transactional (readOnly = true)
    public Tipodoc find(Tipodoc tipodoc) {
		String query = "SELECT t1.TDCODIGO TDCODIGO, t1.TDNOMBRE TDNOMBRE " 
         + "FROM TIPODOC t1  " 
         + "WHERE t1.TDCODIGO = ?    ";
		return (Tipodoc) this.jdbcTemplate.queryForObject(query, 
			rwMap , tipodoc.getTdcodigo());	 
    }

    /**
     * Removes a single row in the Tipodoc table.
     *
     * @param tipodoc Pagination
     * @return
     */
    public void remove(Tipodoc tipodoc) {
		String query = "DELETE  FROM TIPODOC WHERE TDCODIGO=?";
		this.jdbcTemplate.update(query, tipodoc.getTdcodigo());
    	}
    
   /**
    * Finds a List of rows in the Tipodoc table.
    * 
    * @param tipodoc Tipodoc
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Tipodoc> findAll(Tipodoc tipodoc, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TDCODIGO TDCODIGO,t1.TDNOMBRE TDNOMBRE " 
			+ "FROM TIPODOC t1 ");
		
		if (tipodoc  != null  && tipodoc.getTdcodigo() != null ) {
			where.append(" AND t1.TDCODIGO = ?");
			params.add(tipodoc.getTdcodigo());
		}
		if (tipodoc  != null  && tipodoc.getTdnombre() != null ) {
			where.append(" AND t1.TDNOMBRE = ?");
			params.add(tipodoc.getTdnombre());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<Tipodoc>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Tipodoc table.
     * 
     * @param tipodoc Tipodoc
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Tipodoc tipodoc) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  TIPODOC t1  ");
		if (tipodoc  != null  && tipodoc.getTdcodigo() != null ) {
			where.append(" AND t1.TDCODIGO = ?");
			params.add(tipodoc.getTdcodigo());
		}
		if (tipodoc  != null  && tipodoc.getTdnombre() != null ) {
			where.append(" AND t1.TDNOMBRE = ?");
			params.add(tipodoc.getTdnombre());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Tipodoc table using like.
     * 
     * @param tipodoc Tipodoc
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Tipodoc> findAllLike(Tipodoc tipodoc, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TDCODIGO TDCODIGO,t1.TDNOMBRE TDNOMBRE " 
        	+ "FROM TIPODOC t1 ");
      	
		if (tipodoc  != null  && tipodoc.getTdcodigo() != null ) {
			where.append(" AND UPPER(t1.TDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipodoc.getTdcodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+tipodoc.getTdcodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.TDCODIGO IS NOT NULL");
        }
		if (tipodoc  != null  && tipodoc.getTdnombre() != null ) {
			where.append(" AND UPPER(t1.TDNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipodoc.getTdnombre().toUpperCase()  +"%");
			}else{
				params.add("%"+tipodoc.getTdnombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.TDNOMBRE IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<Tipodoc>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

