package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipoRespuesta;

/**
 *  * TipoRespuestaDaoImpl generated by UDA, 01-feb-2012 17:10:36.
 *  
 */
 
@Repository
@Transactional
public class TipoRespuestaDaoImpl implements TipoRespuestaDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<TipoRespuesta> rwMap = new RowMapper<TipoRespuesta>() {
		public TipoRespuesta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new TipoRespuesta(
               resultSet.getString("P8CODIGO"), resultSet.getString("P8NOMBRE"), resultSet.getString("P8NOMBREE"), resultSet.getString("P8TEDES"), resultSet.getString("P8TEDESE"), resultSet.getString("P8TEICO")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the TipoRespuesta table.
     *
     * @param tiporespuesta Pagination
     * @return TipoRespuesta
     */
	public TipoRespuesta add(TipoRespuesta tiporespuesta) {

    	String query = "INSERT INTO TIPO_RESPUESTA( P8CODIGO,P8NOMBRE,P8NOMBREE,P8TEDES,P8TEDESE,P8TEICO)"
        + "VALUES (?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, tiporespuesta.getP8codigo(), tiporespuesta.getP8nombre(), tiporespuesta.getP8nombree(), tiporespuesta.getP8tedes(), tiporespuesta.getP8tedese(), tiporespuesta.getP8teico());
		return tiporespuesta;
	}

    /**
     * Updates a single row in the TipoRespuesta table.
     *
     * @param tiporespuesta Pagination
     * @return TipoRespuesta
     */
    public TipoRespuesta update(TipoRespuesta tiporespuesta) {
		String query = "UPDATE TIPO_RESPUESTA SET P8NOMBRE=?,P8NOMBREE=?,P8TEDES=?,P8TEDESE=?,P8TEICO=? WHERE P8CODIGO=?";
		this.jdbcTemplate.update(query, tiporespuesta.getP8nombre(), tiporespuesta.getP8nombree(), tiporespuesta.getP8tedes(), tiporespuesta.getP8tedese(), tiporespuesta.getP8teico(), tiporespuesta.getP8codigo());
		return tiporespuesta;
	}

    /**
     * Finds a single row in the TipoRespuesta table.
     *
     * @param tiporespuesta Pagination
     * @return TipoRespuesta
     */
    @Transactional (readOnly = true)
    public TipoRespuesta find(TipoRespuesta tiporespuesta) {
		String query = "SELECT t1.P8CODIGO P8CODIGO, t1.P8NOMBRE P8NOMBRE, t1.P8NOMBREE P8NOMBREE, t1.P8TEDES P8TEDES, t1.P8TEDESE P8TEDESE, t1.P8TEICO P8TEICO " 
         + "FROM TIPO_RESPUESTA t1  " 
         + "WHERE t1.P8CODIGO = ?    ";
		return (TipoRespuesta) this.jdbcTemplate.queryForObject(query, 
			rwMap , tiporespuesta.getP8codigo());	 
    }

    /**
     * Removes a single row in the TipoRespuesta table.
     *
     * @param tiporespuesta Pagination
     * @return
     */
    public void remove(TipoRespuesta tiporespuesta) {
		String query = "DELETE  FROM TIPO_RESPUESTA WHERE P8CODIGO=?";
		this.jdbcTemplate.update(query, tiporespuesta.getP8codigo());
    	}
    
   /**
    * Finds a List of rows in the TipoRespuesta table.
    * 
    * @param tiporespuesta TipoRespuesta
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<TipoRespuesta> findAll(TipoRespuesta tiporespuesta, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.P8CODIGO P8CODIGO,t1.P8NOMBRE P8NOMBRE,t1.P8NOMBREE P8NOMBREE,t1.P8TEDES P8TEDES,t1.P8TEDESE P8TEDESE,t1.P8TEICO P8TEICO " 
			+ "FROM TIPO_RESPUESTA t1 ");
		
		if (tiporespuesta  != null  && tiporespuesta.getP8codigo() != null ) {
			where.append(" AND t1.P8CODIGO = ?");
			params.add(tiporespuesta.getP8codigo());
		}
		if (tiporespuesta  != null  && tiporespuesta.getP8nombre() != null ) {
			where.append(" AND t1.P8NOMBRE = ?");
			params.add(tiporespuesta.getP8nombre());
		}
		if (tiporespuesta  != null  && tiporespuesta.getP8nombree() != null ) {
			where.append(" AND t1.P8NOMBREE = ?");
			params.add(tiporespuesta.getP8nombree());
		}
		if (tiporespuesta  != null  && tiporespuesta.getP8tedes() != null ) {
			where.append(" AND t1.P8TEDES = ?");
			params.add(tiporespuesta.getP8tedes());
		}
		if (tiporespuesta  != null  && tiporespuesta.getP8tedese() != null ) {
			where.append(" AND t1.P8TEDESE = ?");
			params.add(tiporespuesta.getP8tedese());
		}
		if (tiporespuesta  != null  && tiporespuesta.getP8teico() != null ) {
			where.append(" AND t1.P8TEICO = ?");
			params.add(tiporespuesta.getP8teico());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipoRespuesta>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the TipoRespuesta table.
     * 
     * @param tiporespuesta TipoRespuesta
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(TipoRespuesta tiporespuesta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  TIPO_RESPUESTA t1  ");
		if (tiporespuesta  != null  && tiporespuesta.getP8codigo() != null ) {
			where.append(" AND t1.P8CODIGO = ?");
			params.add(tiporespuesta.getP8codigo());
		}
		if (tiporespuesta  != null  && tiporespuesta.getP8nombre() != null ) {
			where.append(" AND t1.P8NOMBRE = ?");
			params.add(tiporespuesta.getP8nombre());
		}
		if (tiporespuesta  != null  && tiporespuesta.getP8nombree() != null ) {
			where.append(" AND t1.P8NOMBREE = ?");
			params.add(tiporespuesta.getP8nombree());
		}
		if (tiporespuesta  != null  && tiporespuesta.getP8tedes() != null ) {
			where.append(" AND t1.P8TEDES = ?");
			params.add(tiporespuesta.getP8tedes());
		}
		if (tiporespuesta  != null  && tiporespuesta.getP8tedese() != null ) {
			where.append(" AND t1.P8TEDESE = ?");
			params.add(tiporespuesta.getP8tedese());
		}
		if (tiporespuesta  != null  && tiporespuesta.getP8teico() != null ) {
			where.append(" AND t1.P8TEICO = ?");
			params.add(tiporespuesta.getP8teico());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the TipoRespuesta table using like.
     * 
     * @param tiporespuesta TipoRespuesta
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<TipoRespuesta> findAllLike(TipoRespuesta tiporespuesta, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.P8CODIGO P8CODIGO,t1.P8NOMBRE P8NOMBRE,t1.P8NOMBREE P8NOMBREE,t1.P8TEDES P8TEDES,t1.P8TEDESE P8TEDESE,t1.P8TEICO P8TEICO " 
        	+ "FROM TIPO_RESPUESTA t1 ");
      	
		if (tiporespuesta  != null  && tiporespuesta.getP8codigo() != null ) {
			where.append(" AND UPPER(t1.P8CODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tiporespuesta.getP8codigo().toUpperCase()  +"%");
			}else{
				params.add("%"+tiporespuesta.getP8codigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.P8CODIGO IS NOT NULL");
        }
		if (tiporespuesta  != null  && tiporespuesta.getP8nombre() != null ) {
			where.append(" AND UPPER(t1.P8NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tiporespuesta.getP8nombre().toUpperCase()  +"%");
			}else{
				params.add("%"+tiporespuesta.getP8nombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.P8NOMBRE IS NOT NULL");
        }
		if (tiporespuesta  != null  && tiporespuesta.getP8nombree() != null ) {
			where.append(" AND UPPER(t1.P8NOMBREE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tiporespuesta.getP8nombree().toUpperCase()  +"%");
			}else{
				params.add("%"+tiporespuesta.getP8nombree().toUpperCase() +"%");
			}	
			where.append(" AND t1.P8NOMBREE IS NOT NULL");
        }
		if (tiporespuesta  != null  && tiporespuesta.getP8tedes() != null ) {
			where.append(" AND UPPER(t1.P8TEDES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tiporespuesta.getP8tedes().toUpperCase()  +"%");
			}else{
				params.add("%"+tiporespuesta.getP8tedes().toUpperCase() +"%");
			}	
			where.append(" AND t1.P8TEDES IS NOT NULL");
        }
		if (tiporespuesta  != null  && tiporespuesta.getP8tedese() != null ) {
			where.append(" AND UPPER(t1.P8TEDESE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tiporespuesta.getP8tedese().toUpperCase()  +"%");
			}else{
				params.add("%"+tiporespuesta.getP8tedese().toUpperCase() +"%");
			}	
			where.append(" AND t1.P8TEDESE IS NOT NULL");
        }
		if (tiporespuesta  != null  && tiporespuesta.getP8teico() != null ) {
			where.append(" AND UPPER(t1.P8TEICO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tiporespuesta.getP8teico().toUpperCase()  +"%");
			}else{
				params.add("%"+tiporespuesta.getP8teico().toUpperCase() +"%");
			}	
			where.append(" AND t1.P8TEICO IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipoRespuesta>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

