package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipoReclamacion;

/**
 * * TipoReclamacionDaoImpl generated by UDA, 22-feb-2012 17:30:27.
 * 
 *  
 */

@Repository
@Transactional
public class TipoReclamacionDaoImpl implements TipoReclamacionDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<TipoReclamacion> rwMap = new RowMapper<TipoReclamacion>() {
		public TipoReclamacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new TipoReclamacion(resultSet.getString("TSRCODIGO"),
					resultSet.getString("TSRNOMBRE"),
					resultSet.getString("TSRNOMBREE"),
					resultSet.getString("TSRNOMBREI"),
					resultSet.getString("TSRNOMBREF"),
					resultSet.getString("TSRNOMBREA"),
					resultSet.getString("TSRIMPORTE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            Pagination
	 * @return TipoReclamacion
	 */
	public TipoReclamacion add(TipoReclamacion tiporeclamacion) {

		String query = "INSERT INTO TIPO_RECLAMACION( TSRCODIGO,TSRNOMBRE,TSRNOMBREE,TSRNOMBREI,TSRNOMBREF,TSRNOMBREA,TSRIMPORTE)"
				+ "VALUES (?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, tiporeclamacion.getTsrcodigo(),
				tiporeclamacion.getTsrnombre(),
				tiporeclamacion.getTsrnombree(),
				tiporeclamacion.getTsrnombrei(),
				tiporeclamacion.getTsrnombref(),
				tiporeclamacion.getTsrnombrea(),
				tiporeclamacion.getTsrimporte());
		return tiporeclamacion;
	}

	/**
	 * Updates a single row in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            Pagination
	 * @return TipoReclamacion
	 */
	public TipoReclamacion update(TipoReclamacion tiporeclamacion) {
		String query = "UPDATE TIPO_RECLAMACION SET TSRNOMBRE=?,TSRNOMBREE=?,TSRNOMBREI=?,TSRNOMBREF=?,TSRNOMBREA=?,TSRIMPORTE=? WHERE TSRCODIGO=?";
		this.jdbcTemplate
				.update(query, tiporeclamacion.getTsrnombre(),
						tiporeclamacion.getTsrnombree(),
						tiporeclamacion.getTsrnombrei(),
						tiporeclamacion.getTsrnombref(),
						tiporeclamacion.getTsrnombrea(),
						tiporeclamacion.getTsrcodigo(),
						tiporeclamacion.getTsrimporte());
		return tiporeclamacion;
	}

	/**
	 * Finds a single row in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            Pagination
	 * @return TipoReclamacion
	 */
	@Transactional(readOnly = true)
	public TipoReclamacion find(TipoReclamacion tiporeclamacion) {
		String query = "SELECT t1.TSRCODIGO TSRCODIGO, t1.TSRNOMBRE TSRNOMBRE, t1.TSRNOMBREE TSRNOMBREE, t1.TSRNOMBREI TSRNOMBREI, t1.TSRNOMBREF TSRNOMBREF, t1.TSRNOMBREA TSRNOMBREA, t1.TSRIMPORTE TSRIMPORTE "
				+ "FROM TIPO_RECLAMACION t1  " + "WHERE t1.TSRCODIGO = ?    ";
		return (TipoReclamacion) this.jdbcTemplate.queryForObject(query, rwMap,
				tiporeclamacion.getTsrcodigo());
	}

	/**
	 * Removes a single row in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            Pagination
	 * @return
	 */
	public void remove(TipoReclamacion tiporeclamacion) {
		String query = "DELETE  FROM TIPO_RECLAMACION WHERE TSRCODIGO=?";
		this.jdbcTemplate.update(query, tiporeclamacion.getTsrcodigo());
	}

	/**
	 * Finds a List of rows in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            TipoReclamacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipoReclamacion> findAll(TipoReclamacion tiporeclamacion,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TSRCODIGO TSRCODIGO,t1.TSRNOMBRE TSRNOMBRE,t1.TSRNOMBREE TSRNOMBREE,t1.TSRNOMBREI TSRNOMBREI,t1.TSRNOMBREF TSRNOMBREF,t1.TSRNOMBREA TSRNOMBREA, t1.TSRIMPORTE TSRIMPORTE "
						+ "FROM TIPO_RECLAMACION t1 ");

		if (tiporeclamacion != null && tiporeclamacion.getTsrcodigo() != null) {
			where.append(" AND t1.TSRCODIGO = ?");
			params.add(tiporeclamacion.getTsrcodigo());
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombre() != null) {
			where.append(" AND t1.TSRNOMBRE = ?");
			params.add(tiporeclamacion.getTsrnombre());
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombree() != null) {
			where.append(" AND t1.TSRNOMBREE = ?");
			params.add(tiporeclamacion.getTsrnombree());
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombrei() != null) {
			where.append(" AND t1.TSRNOMBREI = ?");
			params.add(tiporeclamacion.getTsrnombrei());
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombref() != null) {
			where.append(" AND t1.TSRNOMBREF = ?");
			params.add(tiporeclamacion.getTsrnombref());
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombrea() != null) {
			where.append(" AND t1.TSRNOMBREA = ?");
			params.add(tiporeclamacion.getTsrnombrea());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TipoReclamacion>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            TipoReclamacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TipoReclamacion tiporeclamacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  TIPO_RECLAMACION t1  ");
		if (tiporeclamacion != null && tiporeclamacion.getTsrcodigo() != null) {
			where.append(" AND t1.TSRCODIGO = ?");
			params.add(tiporeclamacion.getTsrcodigo());
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombre() != null) {
			where.append(" AND t1.TSRNOMBRE = ?");
			params.add(tiporeclamacion.getTsrnombre());
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombree() != null) {
			where.append(" AND t1.TSRNOMBREE = ?");
			params.add(tiporeclamacion.getTsrnombree());
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombrei() != null) {
			where.append(" AND t1.TSRNOMBREI = ?");
			params.add(tiporeclamacion.getTsrnombrei());
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombref() != null) {
			where.append(" AND t1.TSRNOMBREF = ?");
			params.add(tiporeclamacion.getTsrnombref());
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombrea() != null) {
			where.append(" AND t1.TSRNOMBREA = ?");
			params.add(tiporeclamacion.getTsrnombrea());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the TipoReclamacion table using like.
	 * 
	 * @param tiporeclamacion
	 *            TipoReclamacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipoReclamacion> findAllLike(TipoReclamacion tiporeclamacion,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TSRCODIGO TSRCODIGO,t1.TSRNOMBRE TSRNOMBRE,t1.TSRNOMBREE TSRNOMBREE,t1.TSRNOMBREI TSRNOMBREI,t1.TSRNOMBREF TSRNOMBREF,t1.TSRNOMBREA TSRNOMBREA, t1.TSRIMPORTE TSRIMPORTE "
						+ "FROM TIPO_RECLAMACION t1 ");

		if (tiporeclamacion != null && tiporeclamacion.getTsrcodigo() != null) {
			where.append(" AND UPPER(t1.TSRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiporeclamacion.getTsrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tiporeclamacion.getTsrcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TSRCODIGO IS NOT NULL");
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombre() != null) {
			where.append(" AND UPPER(t1.TSRNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiporeclamacion.getTsrnombre().toUpperCase() + "%");
			} else {
				params.add("%" + tiporeclamacion.getTsrnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TSRNOMBRE IS NOT NULL");
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombree() != null) {
			where.append(" AND UPPER(t1.TSRNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiporeclamacion.getTsrnombree().toUpperCase() + "%");
			} else {
				params.add("%" + tiporeclamacion.getTsrnombree().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TSRNOMBREE IS NOT NULL");
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombrei() != null) {
			where.append(" AND UPPER(t1.TSRNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiporeclamacion.getTsrnombrei().toUpperCase() + "%");
			} else {
				params.add("%" + tiporeclamacion.getTsrnombrei().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TSRNOMBREI IS NOT NULL");
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombref() != null) {
			where.append(" AND UPPER(t1.TSRNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiporeclamacion.getTsrnombref().toUpperCase() + "%");
			} else {
				params.add("%" + tiporeclamacion.getTsrnombref().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TSRNOMBREF IS NOT NULL");
		}
		if (tiporeclamacion != null && tiporeclamacion.getTsrnombrea() != null) {
			where.append(" AND UPPER(t1.TSRNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiporeclamacion.getTsrnombrea().toUpperCase() + "%");
			} else {
				params.add("%" + tiporeclamacion.getTsrnombrea().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TSRNOMBREA IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TipoReclamacion>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}
}
