package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipoComunicacion;

/**
 *  * TipoComunicacionDaoImpl generated by UDA, 22-feb-2012 17:30:27.
 *  
 */
 
@Repository
@Transactional
public class TipoComunicacionDaoImpl implements TipoComunicacionDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<TipoComunicacion> rwMap = new RowMapper<TipoComunicacion>() {
		public TipoComunicacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new TipoComunicacion(
               resultSet.getInt("M6CODIGO"), resultSet.getString("M6NOTIPO"), resultSet.getString("M6TETIPO"), resultSet.getString("M6NOTIPOE"), resultSet.getString("M6NOTIPOI"), resultSet.getString("M6NOTIPOF"), resultSet.getString("M6NOTIPOA")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the TipoComunicacion table.
     *
     * @param tipocomunicacion Pagination
     * @return TipoComunicacion
     */
	public TipoComunicacion add(TipoComunicacion tipocomunicacion) {

    	String query = "INSERT INTO TIPO_COMUNICACION( M6CODIGO,M6NOTIPO,M6TETIPO,M6NOTIPOE,M6NOTIPOI,M6NOTIPOF,M6NOTIPOA)"
        + "VALUES (?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, tipocomunicacion.getM6codigo(), tipocomunicacion.getM6notipo(), tipocomunicacion.getM6tetipo(), tipocomunicacion.getM6notipoe(), tipocomunicacion.getM6notipoi(), tipocomunicacion.getM6notipof(), tipocomunicacion.getM6notipoa());
		return tipocomunicacion;
	}

    /**
     * Updates a single row in the TipoComunicacion table.
     *
     * @param tipocomunicacion Pagination
     * @return TipoComunicacion
     */
    public TipoComunicacion update(TipoComunicacion tipocomunicacion) {
		String query = "UPDATE TIPO_COMUNICACION SET M6NOTIPO=?,M6TETIPO=?,M6NOTIPOE=?,M6NOTIPOI=?,M6NOTIPOF=?,M6NOTIPOA=? WHERE M6CODIGO=?";
		this.jdbcTemplate.update(query, tipocomunicacion.getM6notipo(), tipocomunicacion.getM6tetipo(), tipocomunicacion.getM6notipoe(), tipocomunicacion.getM6notipoi(), tipocomunicacion.getM6notipof(), tipocomunicacion.getM6notipoa(), tipocomunicacion.getM6codigo());
		return tipocomunicacion;
	}

    /**
     * Finds a single row in the TipoComunicacion table.
     *
     * @param tipocomunicacion Pagination
     * @return TipoComunicacion
     */
    @Transactional (readOnly = true)
    public TipoComunicacion find(TipoComunicacion tipocomunicacion) {
		String query = "SELECT t1.M6CODIGO M6CODIGO, t1.M6NOTIPO M6NOTIPO, t1.M6TETIPO M6TETIPO, t1.M6NOTIPOE M6NOTIPOE, t1.M6NOTIPOI M6NOTIPOI, t1.M6NOTIPOF M6NOTIPOF, t1.M6NOTIPOA M6NOTIPOA " 
         + "FROM TIPO_COMUNICACION t1  " 
         + "WHERE t1.M6CODIGO = ?    ";
		return (TipoComunicacion) this.jdbcTemplate.queryForObject(query, 
			rwMap , tipocomunicacion.getM6codigo());	 
    }

    /**
     * Removes a single row in the TipoComunicacion table.
     *
     * @param tipocomunicacion Pagination
     * @return
     */
    public void remove(TipoComunicacion tipocomunicacion) {
		String query = "DELETE  FROM TIPO_COMUNICACION WHERE M6CODIGO=?";
		this.jdbcTemplate.update(query, tipocomunicacion.getM6codigo());
    	}
    
   /**
    * Finds a List of rows in the TipoComunicacion table.
    * 
    * @param tipocomunicacion TipoComunicacion
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<TipoComunicacion> findAll(TipoComunicacion tipocomunicacion, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.M6CODIGO M6CODIGO,t1.M6NOTIPO M6NOTIPO,t1.M6TETIPO M6TETIPO,t1.M6NOTIPOE M6NOTIPOE,t1.M6NOTIPOI M6NOTIPOI,t1.M6NOTIPOF M6NOTIPOF,t1.M6NOTIPOA M6NOTIPOA " 
			+ "FROM TIPO_COMUNICACION t1 ");
		
		if (tipocomunicacion  != null  && tipocomunicacion.getM6codigo() != null ) {
			where.append(" AND t1.M6CODIGO = ?");
			params.add(tipocomunicacion.getM6codigo());
		}
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipo() != null ) {
			where.append(" AND t1.M6NOTIPO = ?");
			params.add(tipocomunicacion.getM6notipo());
		}
		if (tipocomunicacion  != null  && tipocomunicacion.getM6tetipo() != null ) {
			where.append(" AND t1.M6TETIPO = ?");
			params.add(tipocomunicacion.getM6tetipo());
		}
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipoe() != null ) {
			where.append(" AND t1.M6NOTIPOE = ?");
			params.add(tipocomunicacion.getM6notipoe());
		}
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipoi() != null ) {
			where.append(" AND t1.M6NOTIPOI = ?");
			params.add(tipocomunicacion.getM6notipoi());
		}
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipof() != null ) {
			where.append(" AND t1.M6NOTIPOF = ?");
			params.add(tipocomunicacion.getM6notipof());
		}
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipoa() != null ) {
			where.append(" AND t1.M6NOTIPOA = ?");
			params.add(tipocomunicacion.getM6notipoa());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipoComunicacion>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the TipoComunicacion table.
     * 
     * @param tipocomunicacion TipoComunicacion
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(TipoComunicacion tipocomunicacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  TIPO_COMUNICACION t1  ");
		if (tipocomunicacion  != null  && tipocomunicacion.getM6codigo() != null ) {
			where.append(" AND t1.M6CODIGO = ?");
			params.add(tipocomunicacion.getM6codigo());
		}
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipo() != null ) {
			where.append(" AND t1.M6NOTIPO = ?");
			params.add(tipocomunicacion.getM6notipo());
		}
		if (tipocomunicacion  != null  && tipocomunicacion.getM6tetipo() != null ) {
			where.append(" AND t1.M6TETIPO = ?");
			params.add(tipocomunicacion.getM6tetipo());
		}
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipoe() != null ) {
			where.append(" AND t1.M6NOTIPOE = ?");
			params.add(tipocomunicacion.getM6notipoe());
		}
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipoi() != null ) {
			where.append(" AND t1.M6NOTIPOI = ?");
			params.add(tipocomunicacion.getM6notipoi());
		}
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipof() != null ) {
			where.append(" AND t1.M6NOTIPOF = ?");
			params.add(tipocomunicacion.getM6notipof());
		}
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipoa() != null ) {
			where.append(" AND t1.M6NOTIPOA = ?");
			params.add(tipocomunicacion.getM6notipoa());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the TipoComunicacion table using like.
     * 
     * @param tipocomunicacion TipoComunicacion
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<TipoComunicacion> findAllLike(TipoComunicacion tipocomunicacion, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.M6CODIGO M6CODIGO,t1.M6NOTIPO M6NOTIPO,t1.M6TETIPO M6TETIPO,t1.M6NOTIPOE M6NOTIPOE,t1.M6NOTIPOI M6NOTIPOI,t1.M6NOTIPOF M6NOTIPOF,t1.M6NOTIPOA M6NOTIPOA " 
        	+ "FROM TIPO_COMUNICACION t1 ");
      	
		if (tipocomunicacion  != null  && tipocomunicacion.getM6codigo() != null ) {
			where.append(" AND t1.M6CODIGO like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipocomunicacion.getM6codigo()  +"%");
			}else{
				params.add("%"+tipocomunicacion.getM6codigo() +"%");
			}	
			where.append(" AND t1.M6CODIGO IS NOT NULL");
        }
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipo() != null ) {
			where.append(" AND UPPER(t1.M6NOTIPO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipocomunicacion.getM6notipo().toUpperCase()  +"%");
			}else{
				params.add("%"+tipocomunicacion.getM6notipo().toUpperCase() +"%");
			}	
			where.append(" AND t1.M6NOTIPO IS NOT NULL");
        }
		if (tipocomunicacion  != null  && tipocomunicacion.getM6tetipo() != null ) {
			where.append(" AND UPPER(t1.M6TETIPO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipocomunicacion.getM6tetipo().toUpperCase()  +"%");
			}else{
				params.add("%"+tipocomunicacion.getM6tetipo().toUpperCase() +"%");
			}	
			where.append(" AND t1.M6TETIPO IS NOT NULL");
        }
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipoe() != null ) {
			where.append(" AND UPPER(t1.M6NOTIPOE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipocomunicacion.getM6notipoe().toUpperCase()  +"%");
			}else{
				params.add("%"+tipocomunicacion.getM6notipoe().toUpperCase() +"%");
			}	
			where.append(" AND t1.M6NOTIPOE IS NOT NULL");
        }
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipoi() != null ) {
			where.append(" AND UPPER(t1.M6NOTIPOI) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipocomunicacion.getM6notipoi().toUpperCase()  +"%");
			}else{
				params.add("%"+tipocomunicacion.getM6notipoi().toUpperCase() +"%");
			}	
			where.append(" AND t1.M6NOTIPOI IS NOT NULL");
        }
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipof() != null ) {
			where.append(" AND UPPER(t1.M6NOTIPOF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipocomunicacion.getM6notipof().toUpperCase()  +"%");
			}else{
				params.add("%"+tipocomunicacion.getM6notipof().toUpperCase() +"%");
			}	
			where.append(" AND t1.M6NOTIPOF IS NOT NULL");
        }
		if (tipocomunicacion  != null  && tipocomunicacion.getM6notipoa() != null ) {
			where.append(" AND UPPER(t1.M6NOTIPOA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipocomunicacion.getM6notipoa().toUpperCase()  +"%");
			}else{
				params.add("%"+tipocomunicacion.getM6notipoa().toUpperCase() +"%");
			}	
			where.append(" AND t1.M6NOTIPOA IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipoComunicacion>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

