package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipmotActuacion;

/**
 *  * TipmotActuacionDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 *  
 */
 
@Repository
@Transactional
public class TipmotActuacionDaoImpl implements TipmotActuacionDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<TipmotActuacion> rwMap = new RowMapper<TipmotActuacion>() {
		public TipmotActuacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new TipmotActuacion(
               resultSet.getString("TMACODIGO"), resultSet.getString("TMANOMBRE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the TipmotActuacion table.
     *
     * @param tipmotactuacion Pagination
     * @return TipmotActuacion
     */
	public TipmotActuacion add(TipmotActuacion tipmotactuacion) {

    	String query = "INSERT INTO TIPMOT_ACTUACION( TMACODIGO,TMANOMBRE)"
        + "VALUES (?,?)";

		this.jdbcTemplate.update(query, tipmotactuacion.getTmacodigo(), tipmotactuacion.getTmanombre());
		return tipmotactuacion;
	}

    /**
     * Updates a single row in the TipmotActuacion table.
     *
     * @param tipmotactuacion Pagination
     * @return TipmotActuacion
     */
    public TipmotActuacion update(TipmotActuacion tipmotactuacion) {
		String query = "UPDATE TIPMOT_ACTUACION SET TMANOMBRE=? WHERE TMACODIGO=?";
		this.jdbcTemplate.update(query, tipmotactuacion.getTmanombre(), tipmotactuacion.getTmacodigo());
		return tipmotactuacion;
	}

    /**
     * Finds a single row in the TipmotActuacion table.
     *
     * @param tipmotactuacion Pagination
     * @return TipmotActuacion
     */
    @Transactional (readOnly = true)
    public TipmotActuacion find(TipmotActuacion tipmotactuacion) {
		String query = "SELECT t1.TMACODIGO TMACODIGO, t1.TMANOMBRE TMANOMBRE " 
         + "FROM TIPMOT_ACTUACION t1  " 
         + "WHERE t1.TMACODIGO = ?    ";
		return (TipmotActuacion) this.jdbcTemplate.queryForObject(query, 
			rwMap , tipmotactuacion.getTmacodigo());	 
    }

    /**
     * Removes a single row in the TipmotActuacion table.
     *
     * @param tipmotactuacion Pagination
     * @return
     */
    public void remove(TipmotActuacion tipmotactuacion) {
		String query = "DELETE  FROM TIPMOT_ACTUACION WHERE TMACODIGO=?";
		this.jdbcTemplate.update(query, tipmotactuacion.getTmacodigo());
    	}
    
   /**
    * Finds a List of rows in the TipmotActuacion table.
    * 
    * @param tipmotactuacion TipmotActuacion
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<TipmotActuacion> findAll(TipmotActuacion tipmotactuacion, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TMACODIGO TMACODIGO,t1.TMANOMBRE TMANOMBRE " 
			+ "FROM TIPMOT_ACTUACION t1 ");
		
		if (tipmotactuacion  != null  && tipmotactuacion.getTmacodigo() != null ) {
			where.append(" AND t1.TMACODIGO = ?");
			params.add(tipmotactuacion.getTmacodigo());
		}
		if (tipmotactuacion  != null  && tipmotactuacion.getTmanombre() != null ) {
			where.append(" AND t1.TMANOMBRE = ?");
			params.add(tipmotactuacion.getTmanombre());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipmotActuacion>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the TipmotActuacion table.
     * 
     * @param tipmotactuacion TipmotActuacion
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(TipmotActuacion tipmotactuacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  TIPMOT_ACTUACION t1  ");
		if (tipmotactuacion  != null  && tipmotactuacion.getTmacodigo() != null ) {
			where.append(" AND t1.TMACODIGO = ?");
			params.add(tipmotactuacion.getTmacodigo());
		}
		if (tipmotactuacion  != null  && tipmotactuacion.getTmanombre() != null ) {
			where.append(" AND t1.TMANOMBRE = ?");
			params.add(tipmotactuacion.getTmanombre());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the TipmotActuacion table using like.
     * 
     * @param tipmotactuacion TipmotActuacion
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<TipmotActuacion> findAllLike(TipmotActuacion tipmotactuacion, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TMACODIGO TMACODIGO,t1.TMANOMBRE TMANOMBRE " 
        	+ "FROM TIPMOT_ACTUACION t1 ");
      	
		if (tipmotactuacion  != null  && tipmotactuacion.getTmacodigo() != null ) {
			where.append(" AND UPPER(t1.TMACODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipmotactuacion.getTmacodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+tipmotactuacion.getTmacodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.TMACODIGO IS NOT NULL");
        }
		if (tipmotactuacion  != null  && tipmotactuacion.getTmanombre() != null ) {
			where.append(" AND UPPER(t1.TMANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipmotactuacion.getTmanombre().toUpperCase()  +"%");
			}else{
				params.add("%"+tipmotactuacion.getTmanombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.TMANOMBRE IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipmotActuacion>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

