package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Campanha;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipProtocolo;

/**
 *  * TipProtocoloDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 *  
 */
 
@Repository
@Transactional
public class TipProtocoloDaoImpl implements TipProtocoloDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<TipProtocolo> rwMap = new RowMapper<TipProtocolo>() {
		public TipProtocolo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new TipProtocolo(
               resultSet.getString("TPCODIGO"), resultSet.getString("TPNOMBRE"), resultSet.getString("TPCOTMO"), new Campanha(resultSet.getString("CampanhaCMCODIGO"), resultSet.getString("CampanhaCMNOMBRE"), resultSet.getString("CampanhaCMCOPS"), resultSet.getString("CampanhaCMNOAR"), resultSet.getString("CampanhaCMNOPS"), resultSet.getString("CampanhaCMCOTMO"))
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the TipProtocolo table.
     *
     * @param tipprotocolo Pagination
     * @return TipProtocolo
     */
	public TipProtocolo add(TipProtocolo tipprotocolo) {

    	String query = "INSERT INTO TIP_PROTOCOLO( TPCODIGO,TPCOCM,TPNOMBRE,TPCOTMO)"
        + "VALUES (?,?,?,?)";

				   Object getCampanhaCmcodigoAux=null;
		     if (tipprotocolo.getCampanha()!= null  && tipprotocolo.getCampanha().getCmcodigo()!=null ){
			     getCampanhaCmcodigoAux=tipprotocolo.getCampanha().getCmcodigo();
		   	  }
		this.jdbcTemplate.update(query, tipprotocolo.getTpcodigo(), getCampanhaCmcodigoAux, tipprotocolo.getTpnombre(), tipprotocolo.getTpcotmo());
		return tipprotocolo;
	}

    /**
     * Updates a single row in the TipProtocolo table.
     *
     * @param tipprotocolo Pagination
     * @return TipProtocolo
     */
    public TipProtocolo update(TipProtocolo tipprotocolo) {
		String query = "UPDATE TIP_PROTOCOLO SET TPCOCM=?,TPNOMBRE=?,TPCOTMO=? WHERE TPCODIGO=?";
				Object getCampanhaCmcodigoAux=null;
				if (tipprotocolo.getCampanha()!= null   && tipprotocolo.getCampanha().getCmcodigo()!=null ){
					getCampanhaCmcodigoAux=tipprotocolo.getCampanha().getCmcodigo();
				}
		this.jdbcTemplate.update(query, getCampanhaCmcodigoAux, tipprotocolo.getTpnombre(), tipprotocolo.getTpcotmo(), tipprotocolo.getTpcodigo());
		return tipprotocolo;
	}

    /**
     * Finds a single row in the TipProtocolo table.
     *
     * @param tipprotocolo Pagination
     * @return TipProtocolo
     */
    @Transactional (readOnly = true)
    public TipProtocolo find(TipProtocolo tipprotocolo) {
		String query = "SELECT t1.TPCODIGO TPCODIGO, t1.TPNOMBRE TPNOMBRE, t1.TPCOTMO TPCOTMO, t2.CMCODIGO CAMPANHACMCODIGO, t2.CMNOMBRE CAMPANHACMNOMBRE, t2.CMCOPS CAMPANHACMCOPS, t2.CMNOAR CAMPANHACMNOAR, t2.CMNOPS CAMPANHACMNOPS, t2.CMCOTMO CAMPANHACMCOTMO " 
         + "FROM TIP_PROTOCOLO t1 , CAMPANHA t2  " 
         + "WHERE t1.TPCODIGO = ?   AND t1.TPCOCM= t2.CMCODIGO(+)  ";
		return (TipProtocolo) this.jdbcTemplate.queryForObject(query, 
			rwMap , tipprotocolo.getTpcodigo());	 
    }

    /**
     * Removes a single row in the TipProtocolo table.
     *
     * @param tipprotocolo Pagination
     * @return
     */
    public void remove(TipProtocolo tipprotocolo) {
		String query = "DELETE  FROM TIP_PROTOCOLO WHERE TPCODIGO=?";
		this.jdbcTemplate.update(query, tipprotocolo.getTpcodigo());
    	}
    
   /**
    * Finds a List of rows in the TipProtocolo table.
    * 
    * @param tipprotocolo TipProtocolo
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<TipProtocolo> findAll(TipProtocolo tipprotocolo, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TPCOCM= t2.CMCODIGO(+) 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TPCODIGO TPCODIGO,t1.TPNOMBRE TPNOMBRE,t1.TPCOTMO TPCOTMO,t2.CMCODIGO CAMPANHACMCODIGO,t2.CMNOMBRE CAMPANHACMNOMBRE,t2.CMCOPS CAMPANHACMCOPS,t2.CMNOAR CAMPANHACMNOAR,t2.CMNOPS CAMPANHACMNOPS,t2.CMCOTMO CAMPANHACMCOTMO " 
			+ "FROM TIP_PROTOCOLO t1 ,CAMPANHA t2 ");
		
		if (tipprotocolo  != null  && tipprotocolo.getTpcodigo() != null ) {
			where.append(" AND t1.TPCODIGO = ?");
			params.add(tipprotocolo.getTpcodigo());
		}
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmcodigo() != null ) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(tipprotocolo.getCampanha().getCmcodigo());
		}
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmnombre() != null ) {
			where.append(" AND t2.CMNOMBRE = ?");
			params.add(tipprotocolo.getCampanha().getCmnombre());
		}
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmcops() != null ) {
			where.append(" AND t2.CMCOPS = ?");
			params.add(tipprotocolo.getCampanha().getCmcops());
		}
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmnoar() != null ) {
			where.append(" AND t2.CMNOAR = ?");
			params.add(tipprotocolo.getCampanha().getCmnoar());
		}
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmnops() != null ) {
			where.append(" AND t2.CMNOPS = ?");
			params.add(tipprotocolo.getCampanha().getCmnops());
		}
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmcotmo() != null ) {
			where.append(" AND t2.CMCOTMO = ?");
			params.add(tipprotocolo.getCampanha().getCmcotmo());
		}
		if (tipprotocolo  != null  && tipprotocolo.getTpnombre() != null ) {
			where.append(" AND t1.TPNOMBRE = ?");
			params.add(tipprotocolo.getTpnombre());
		}
		if (tipprotocolo  != null  && tipprotocolo.getTpcotmo() != null ) {
			where.append(" AND t1.TPCOTMO = ?");
			params.add(tipprotocolo.getTpcotmo());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipProtocolo>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the TipProtocolo table.
     * 
     * @param tipprotocolo TipProtocolo
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(TipProtocolo tipprotocolo) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.TPCOCM= t2.CMCODIGO(+) ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  TIP_PROTOCOLO t1   ,  CAMPANHA t2  ");
		if (tipprotocolo  != null  && tipprotocolo.getTpcodigo() != null ) {
			where.append(" AND t1.TPCODIGO = ?");
			params.add(tipprotocolo.getTpcodigo());
		}
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmcodigo() != null ) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(tipprotocolo.getCampanha().getCmcodigo());
		}
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmnombre() != null ) {
			where.append(" AND t2.CMNOMBRE = ?");
			params.add(tipprotocolo.getCampanha().getCmnombre());
		}
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmcops() != null ) {
			where.append(" AND t2.CMCOPS = ?");
			params.add(tipprotocolo.getCampanha().getCmcops());
		}
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmnoar() != null ) {
			where.append(" AND t2.CMNOAR = ?");
			params.add(tipprotocolo.getCampanha().getCmnoar());
		}
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmnops() != null ) {
			where.append(" AND t2.CMNOPS = ?");
			params.add(tipprotocolo.getCampanha().getCmnops());
		}
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmcotmo() != null ) {
			where.append(" AND t2.CMCOTMO = ?");
			params.add(tipprotocolo.getCampanha().getCmcotmo());
		}
		if (tipprotocolo  != null  && tipprotocolo.getTpnombre() != null ) {
			where.append(" AND t1.TPNOMBRE = ?");
			params.add(tipprotocolo.getTpnombre());
		}
		if (tipprotocolo  != null  && tipprotocolo.getTpcotmo() != null ) {
			where.append(" AND t1.TPCOTMO = ?");
			params.add(tipprotocolo.getTpcotmo());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the TipProtocolo table using like.
     * 
     * @param tipprotocolo TipProtocolo
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<TipProtocolo> findAllLike(TipProtocolo tipprotocolo, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TPCOCM= t2.CMCODIGO(+) 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TPCODIGO TPCODIGO,t1.TPNOMBRE TPNOMBRE,t1.TPCOTMO TPCOTMO,t2.CMCODIGO CAMPANHACMCODIGO,t2.CMNOMBRE CAMPANHACMNOMBRE,t2.CMCOPS CAMPANHACMCOPS,t2.CMNOAR CAMPANHACMNOAR,t2.CMNOPS CAMPANHACMNOPS,t2.CMCOTMO CAMPANHACMCOTMO " 
        	+ "FROM TIP_PROTOCOLO t1 ,CAMPANHA t2 ");
      	
		if (tipprotocolo  != null  && tipprotocolo.getTpcodigo() != null ) {
			where.append(" AND UPPER(t1.TPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipprotocolo.getTpcodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+tipprotocolo.getTpcodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.TPCODIGO IS NOT NULL");
        }
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmcodigo() != null ) {
			where.append(" AND t2.CMCODIGO like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipprotocolo.getCampanha().getCmcodigo()  +"%");
			}else{
				params.add("%"+tipprotocolo.getCampanha().getCmcodigo() +"%");
			}	
			where.append(" AND t2.CMCODIGO IS NOT NULL");
        }
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmnombre() != null ) {
			where.append(" AND UPPER(t2.CMNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipprotocolo.getCampanha().getCmnombre().toUpperCase()  +"%");
			}else{
				params.add("%"+tipprotocolo.getCampanha().getCmnombre().toUpperCase() +"%");
			}	
			where.append(" AND t2.CMNOMBRE IS NOT NULL");
        }
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmcops() != null ) {
			where.append(" AND UPPER(t2.CMCOPS) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipprotocolo.getCampanha().getCmcops().toUpperCase()  +"%");
			}else{
				params.add("%"+tipprotocolo.getCampanha().getCmcops().toUpperCase() +"%");
			}	
			where.append(" AND t2.CMCOPS IS NOT NULL");
        }
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmnoar() != null ) {
			where.append(" AND UPPER(t2.CMNOAR) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipprotocolo.getCampanha().getCmnoar().toUpperCase()  +"%");
			}else{
				params.add("%"+tipprotocolo.getCampanha().getCmnoar().toUpperCase() +"%");
			}	
			where.append(" AND t2.CMNOAR IS NOT NULL");
        }
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmnops() != null ) {
			where.append(" AND UPPER(t2.CMNOPS) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipprotocolo.getCampanha().getCmnops().toUpperCase()  +"%");
			}else{
				params.add("%"+tipprotocolo.getCampanha().getCmnops().toUpperCase() +"%");
			}	
			where.append(" AND t2.CMNOPS IS NOT NULL");
        }
		if (tipprotocolo!=null && tipprotocolo.getCampanha() != null  && tipprotocolo.getCampanha().getCmcotmo() != null ) {
			where.append(" AND UPPER(t2.CMCOTMO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipprotocolo.getCampanha().getCmcotmo().toUpperCase()  +"%");
			}else{
				params.add("%"+tipprotocolo.getCampanha().getCmcotmo().toUpperCase() +"%");
			}	
			where.append(" AND t2.CMCOTMO IS NOT NULL");
        }
		if (tipprotocolo  != null  && tipprotocolo.getTpnombre() != null ) {
			where.append(" AND UPPER(t1.TPNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipprotocolo.getTpnombre().toUpperCase()  +"%");
			}else{
				params.add("%"+tipprotocolo.getTpnombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.TPNOMBRE IS NOT NULL");
        }
		if (tipprotocolo  != null  && tipprotocolo.getTpcotmo() != null ) {
			where.append(" AND UPPER(t1.TPCOTMO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipprotocolo.getTpcotmo().toUpperCase()  +"%");
			}else{
				params.add("%"+tipprotocolo.getTpcotmo().toUpperCase() +"%");
			}	
			where.append(" AND t1.TPCOTMO IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipProtocolo>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

