package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Campanha;
import com.ejie.y41a.model.TipProtocolo;
import com.ejie.y41a.model.TipReqNormativo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipPregProtoc;

/**
 * * TipPregProtocDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class TipPregProtocDaoImpl implements TipPregProtocDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<TipPregProtoc> rwMap = new RowMapper<TipPregProtoc>() {
		public TipPregProtoc mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new TipPregProtoc(resultSet.getString("TRCODIGO"),
					resultSet.getLong("TRNRTIPP"),
					resultSet.getString("TRCOTIPP"),
					resultSet.getString("TRDETIPP"),
					resultSet.getString("TRINTI"),
					resultSet.getString("TRINRE"),
					resultSet.getString("TRREES"), new TipProtocolo(
							resultSet.getString("TipProtocoloTPCODIGO"),
							resultSet.getString("TipProtocoloTPNOMBRE"),
							resultSet.getString("TipProtocoloTPCOTMO"),
							new Campanha(
									resultSet.getString("TipProtocoloTPCOCM"),
									null, null, null, null, null, null, null,
									null)), new TipReqNormativo(
							resultSet.getString("TipReqNormativoTTICODIGO"),
							resultSet.getString("TipReqNormativoTTINOMBRE"),
							resultSet.getString("TipReqNormativoTTINOCO"),
							resultSet.getString("TipReqNormativoTTITEDE"),
							resultSet.getString("TipReqNormativoTTICOSE"),
							resultSet.getString("TipReqNormativoTTINOCO2"),
							resultSet.getString("TipReqNormativoTTIINSEL1"),
							resultSet.getString("TipReqNormativoTTICOL4"),
							resultSet.getString("TipReqNormativoTTINOMBREE"),
							resultSet.getString("TipReqNormativoTTINOMBREI"),
							resultSet.getString("TipReqNormativoTTINOMBREF"),
							resultSet.getString("TipReqNormativoTTINOCOE"),
							resultSet.getString("TipReqNormativoTTINOCOI"),
							resultSet.getString("TipReqNormativoTTINOCOF"),
							resultSet.getString("TipReqNormativoTTITEDEE"),
							resultSet.getString("TipReqNormativoTTITEDEI"),
							resultSet.getString("TipReqNormativoTTITEDEF"),
							resultSet.getString("TipReqNormativoTTICODGRUPO"),
							resultSet.getString("TipReqNormativoTTINOMBREA"),
							resultSet.getString("TipReqNormativoTTINOCOA"),
							resultSet.getString("TipReqNormativoTTITEDEA"),
							resultSet.getString("TipReqNormativoTTICOE7"),
							resultSet.getString("TipReqNormativoTTICOINC")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            Pagination
	 * @return TipPregProtoc
	 */
	public TipPregProtoc add(TipPregProtoc tippregprotoc) {

		String query = "INSERT INTO TIP_PREG_PROTOC( TRCODIGO,TRCOTP,TRCOTTI,TRNRTIPP,TRCOTIPP,TRDETIPP,TRINTI,TRINRE,TRREES)"
				+ "VALUES (?,?,?,?,?,?,?,?,?)";

		Object getTipProtocoloTpcodigoAux = null;
		if (tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcodigo() != null) {
			getTipProtocoloTpcodigoAux = tippregprotoc.getTipProtocolo()
					.getTpcodigo();
		}
		Object getTipReqNormativoTticodigoAux = null;
		if (tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticodigo() != null) {
			getTipReqNormativoTticodigoAux = tippregprotoc.getTipReqNormativo()
					.getTticodigo();
		}
		this.jdbcTemplate.update(query, tippregprotoc.getTrcodigo(),
				getTipProtocoloTpcodigoAux, getTipReqNormativoTticodigoAux,
				tippregprotoc.getTrnrtipp(), tippregprotoc.getTrcotipp(),
				tippregprotoc.getTrdetipp(), tippregprotoc.getTrinti(),
				tippregprotoc.getTrinre(), tippregprotoc.getTrrees());
		return tippregprotoc;
	}

	/**
	 * Updates a single row in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            Pagination
	 * @return TipPregProtoc
	 */
	public TipPregProtoc update(TipPregProtoc tippregprotoc) {
		String query = "UPDATE TIP_PREG_PROTOC SET TRCOTP=?,TRCOTTI=?,TRNRTIPP=?,TRCOTIPP=?,TRDETIPP=?,TRINTI=?,TRINRE=?,TRREES=? WHERE TRCODIGO=?";
		Object getTipProtocoloTpcodigoAux = null;
		if (tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcodigo() != null) {
			getTipProtocoloTpcodigoAux = tippregprotoc.getTipProtocolo()
					.getTpcodigo();
		}
		Object getTipReqNormativoTticodigoAux = null;
		if (tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticodigo() != null) {
			getTipReqNormativoTticodigoAux = tippregprotoc.getTipReqNormativo()
					.getTticodigo();
		}
		this.jdbcTemplate.update(query, getTipProtocoloTpcodigoAux,
				getTipReqNormativoTticodigoAux, tippregprotoc.getTrnrtipp(),
				tippregprotoc.getTrcotipp(), tippregprotoc.getTrdetipp(),
				tippregprotoc.getTrinti(), tippregprotoc.getTrinre(),
				tippregprotoc.getTrrees(), tippregprotoc.getTrcodigo());
		return tippregprotoc;
	}

	/**
	 * Finds a single row in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            Pagination
	 * @return TipPregProtoc
	 */
	@Transactional(readOnly = true)
	public TipPregProtoc find(TipPregProtoc tippregprotoc) {
		String query = "SELECT t1.TRCODIGO TRCODIGO, t1.TRNRTIPP TRNRTIPP, t1.TRCOTIPP TRCOTIPP, t1.TRDETIPP TRDETIPP, t1.TRINTI TRINTI, t1.TRINRE TRINRE, t1.TRREES TRREES, t2.TPCODIGO TIPPROTOCOLOTPCODIGO, t2.TPNOMBRE TIPPROTOCOLOTPNOMBRE, t2.TPCOTMO TIPPROTOCOLOTPCOTMO, t3.TTICODIGO TIPREQNORMATIVOTTICODIGO, t3.TTINOMBRE TIPREQNORMATIVOTTINOMBRE, t3.TTINOCO TIPREQNORMATIVOTTINOCO, t3.TTITEDE TIPREQNORMATIVOTTITEDE, t3.TTICOSE TIPREQNORMATIVOTTICOSE, t3.TTINOCO2 TIPREQNORMATIVOTTINOCO2, t3.TTIINSEL1 TIPREQNORMATIVOTTIINSEL1, t3.TTICOL4 TIPREQNORMATIVOTTICOL4, t3.TTINOMBREE TIPREQNORMATIVOTTINOMBREE, t3.TTINOMBREI TIPREQNORMATIVOTTINOMBREI, t3.TTINOMBREF TIPREQNORMATIVOTTINOMBREF, t3.TTINOCOE TIPREQNORMATIVOTTINOCOE, t3.TTINOCOI TIPREQNORMATIVOTTINOCOI, t3.TTINOCOF TIPREQNORMATIVOTTINOCOF, t3.TTITEDEE TIPREQNORMATIVOTTITEDEE, t3.TTITEDEI TIPREQNORMATIVOTTITEDEI, t3.TTITEDEF TIPREQNORMATIVOTTITEDEF, t3.TTICODGRUPO TIPREQNORMATIVOTTICODGRUPO, t3.TTINOMBREA TIPREQNORMATIVOTTINOMBREA, t3.TTINOCOA TIPREQNORMATIVOTTINOCOA, t3.TTITEDEA TIPREQNORMATIVOTTITEDEA, t3.TTICOE7 TIPREQNORMATIVOTTICOE7, t3.TTICOINC TIPREQNORMATIVOTTICOINC, t2.TPCOCM TIPPROTOCOLOTPCOCM "
				+ "FROM TIP_PREG_PROTOC t1 , TIP_PROTOCOLO t2 , TIP_REQ_NORMATIVO t3  "
				+ "WHERE t1.TRCODIGO = ?   AND t1.TRCOTP= t2.TPCODIGO(+) AND t1.TRCOTTI= t3.TTICODIGO(+)  ";
		return (TipPregProtoc) this.jdbcTemplate.queryForObject(query, rwMap,
				tippregprotoc.getTrcodigo());
	}

	/**
	 * Removes a single row in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            Pagination
	 * @return
	 */
	public void remove(TipPregProtoc tippregprotoc) {
		String query = "DELETE  FROM TIP_PREG_PROTOC WHERE TRCODIGO=?";
		this.jdbcTemplate.update(query, tippregprotoc.getTrcodigo());
	}

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipPregProtoc> findAll(TipPregProtoc tippregprotoc,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TRCOTP= t2.TPCODIGO(+) AND t1.TRCOTTI= t3.TTICODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNRTIPP TRNRTIPP,t1.TRCOTIPP TRCOTIPP,t1.TRDETIPP TRDETIPP,t1.TRINTI TRINTI,t1.TRINRE TRINRE,t1.TRREES TRREES,t2.TPCODIGO TIPPROTOCOLOTPCODIGO,t2.TPNOMBRE TIPPROTOCOLOTPNOMBRE,t2.TPCOTMO TIPPROTOCOLOTPCOTMO,t3.TTICODIGO TIPREQNORMATIVOTTICODIGO,t3.TTINOMBRE TIPREQNORMATIVOTTINOMBRE,t3.TTINOCO TIPREQNORMATIVOTTINOCO,t3.TTITEDE TIPREQNORMATIVOTTITEDE,t3.TTICOSE TIPREQNORMATIVOTTICOSE,t3.TTINOCO2 TIPREQNORMATIVOTTINOCO2,t3.TTIINSEL1 TIPREQNORMATIVOTTIINSEL1,t3.TTICOL4 TIPREQNORMATIVOTTICOL4,t3.TTINOMBREE TIPREQNORMATIVOTTINOMBREE,t3.TTINOMBREI TIPREQNORMATIVOTTINOMBREI,t3.TTINOMBREF TIPREQNORMATIVOTTINOMBREF,t3.TTINOCOE TIPREQNORMATIVOTTINOCOE,t3.TTINOCOI TIPREQNORMATIVOTTINOCOI,t3.TTINOCOF TIPREQNORMATIVOTTINOCOF,t3.TTITEDEE TIPREQNORMATIVOTTITEDEE,t3.TTITEDEI TIPREQNORMATIVOTTITEDEI,t3.TTITEDEF TIPREQNORMATIVOTTITEDEF,t3.TTICODGRUPO TIPREQNORMATIVOTTICODGRUPO,t3.TTINOMBREA TIPREQNORMATIVOTTINOMBREA,t3.TTINOCOA TIPREQNORMATIVOTTINOCOA,t3.TTITEDEA TIPREQNORMATIVOTTITEDEA,t3.TTICOE7 TIPREQNORMATIVOTTICOE7,t3.TTICOINC TIPREQNORMATIVOTTICOINC,t2.TPCOCM TIPPROTOCOLOTPCOCM "
						+ "FROM TIP_PREG_PROTOC t1 ,TIP_PROTOCOLO t2 ,TIP_REQ_NORMATIVO t3 ");

		if (tippregprotoc != null && tippregprotoc.getTrcodigo() != null) {
			where.append(" AND t1.TRCODIGO = ?");
			params.add(tippregprotoc.getTrcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t2.TPCODIGO = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpcodigo());
		}
		if (tippregprotoc != null
				&& tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getCampanha() != null
				&& tippregprotoc.getTipProtocolo().getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.TPCOCM = ?");
			params.add(tippregprotoc.getTipProtocolo().getCampanha()
					.getCmcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpnombre() != null) {
			where.append(" AND t2.TPNOMBRE = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpnombre());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcotmo() != null) {
			where.append(" AND t2.TPCOTMO = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpcotmo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND t3.TTICODIGO = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombre() != null) {
			where.append(" AND t3.TTINOMBRE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombre());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinoco() != null) {
			where.append(" AND t3.TTINOCO = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinoco());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitede() != null) {
			where.append(" AND t3.TTITEDE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitede());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticose() != null) {
			where.append(" AND t3.TTICOSE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticose());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinoco2() != null) {
			where.append(" AND t3.TTINOCO2 = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinoco2());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtiinsel1() != null) {
			where.append(" AND t3.TTIINSEL1 = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtiinsel1());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticol4() != null) {
			where.append(" AND t3.TTICOL4 = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticol4());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombree() != null) {
			where.append(" AND t3.TTINOMBREE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombree());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombrei() != null) {
			where.append(" AND t3.TTINOMBREI = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombrei());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombref() != null) {
			where.append(" AND t3.TTINOMBREF = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombref());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocoe() != null) {
			where.append(" AND t3.TTINOCOE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinocoe());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocoi() != null) {
			where.append(" AND t3.TTINOCOI = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinocoi());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocof() != null) {
			where.append(" AND t3.TTINOCOF = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinocof());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedee() != null) {
			where.append(" AND t3.TTITEDEE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitedee());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedei() != null) {
			where.append(" AND t3.TTITEDEI = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitedei());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedef() != null) {
			where.append(" AND t3.TTITEDEF = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitedef());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticodgrupo() != null) {
			where.append(" AND t3.TTICODGRUPO = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticodgrupo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombrea() != null) {
			where.append(" AND t3.TTINOMBREA = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombrea());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocoa() != null) {
			where.append(" AND t3.TTINOCOA = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinocoa());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedea() != null) {
			where.append(" AND t3.TTITEDEA = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitedea());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticoe7() != null) {
			where.append(" AND t3.TTICOE7 = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticoe7());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticoinc() != null) {
			where.append(" AND t3.TTICOINC = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticoinc());
		}
		if (tippregprotoc != null && tippregprotoc.getTrnrtipp() != null) {
			where.append(" AND t1.TRNRTIPP = ?");
			params.add(tippregprotoc.getTrnrtipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrcotipp() != null) {
			where.append(" AND t1.TRCOTIPP = ?");
			params.add(tippregprotoc.getTrcotipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrdetipp() != null) {
			where.append(" AND t1.TRDETIPP = ?");
			params.add(tippregprotoc.getTrdetipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrinti() != null) {
			where.append(" AND t1.TRINTI = ?");
			params.add(tippregprotoc.getTrinti());
		}
		if (tippregprotoc != null && tippregprotoc.getTrinre() != null) {
			where.append(" AND t1.TRINRE = ?");
			params.add(tippregprotoc.getTrinre());
		}
		if (tippregprotoc != null && tippregprotoc.getTrrees() != null) {
			where.append(" AND t1.TRREES = ?");
			params.add(tippregprotoc.getTrrees());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TipPregProtoc>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TipPregProtoc tippregprotoc) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.TRCOTP= t2.TPCODIGO(+) and t1.TRCOTTI= t3.TTICODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  TIP_PREG_PROTOC t1   ,  TIP_PROTOCOLO t2   ,  TIP_REQ_NORMATIVO t3  ");
		if (tippregprotoc != null && tippregprotoc.getTrcodigo() != null) {
			where.append(" AND t1.TRCODIGO = ?");
			params.add(tippregprotoc.getTrcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t2.TPCODIGO = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpcodigo());
		}
		if (tippregprotoc != null
				&& tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getCampanha() != null
				&& tippregprotoc.getTipProtocolo().getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.TPCOCM = ?");
			params.add(tippregprotoc.getTipProtocolo().getCampanha()
					.getCmcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpnombre() != null) {
			where.append(" AND t2.TPNOMBRE = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpnombre());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcotmo() != null) {
			where.append(" AND t2.TPCOTMO = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpcotmo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND t3.TTICODIGO = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombre() != null) {
			where.append(" AND t3.TTINOMBRE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombre());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinoco() != null) {
			where.append(" AND t3.TTINOCO = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinoco());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitede() != null) {
			where.append(" AND t3.TTITEDE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitede());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticose() != null) {
			where.append(" AND t3.TTICOSE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticose());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinoco2() != null) {
			where.append(" AND t3.TTINOCO2 = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinoco2());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtiinsel1() != null) {
			where.append(" AND t3.TTIINSEL1 = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtiinsel1());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticol4() != null) {
			where.append(" AND t3.TTICOL4 = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticol4());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombree() != null) {
			where.append(" AND t3.TTINOMBREE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombree());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombrei() != null) {
			where.append(" AND t3.TTINOMBREI = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombrei());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombref() != null) {
			where.append(" AND t3.TTINOMBREF = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombref());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocoe() != null) {
			where.append(" AND t3.TTINOCOE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinocoe());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocoi() != null) {
			where.append(" AND t3.TTINOCOI = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinocoi());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocof() != null) {
			where.append(" AND t3.TTINOCOF = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinocof());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedee() != null) {
			where.append(" AND t3.TTITEDEE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitedee());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedei() != null) {
			where.append(" AND t3.TTITEDEI = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitedei());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedef() != null) {
			where.append(" AND t3.TTITEDEF = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitedef());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticodgrupo() != null) {
			where.append(" AND t3.TTICODGRUPO = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticodgrupo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombrea() != null) {
			where.append(" AND t3.TTINOMBREA = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombrea());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocoa() != null) {
			where.append(" AND t3.TTINOCOA = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinocoa());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedea() != null) {
			where.append(" AND t3.TTITEDEA = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitedea());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticoe7() != null) {
			where.append(" AND t3.TTICOE7 = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticoe7());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticoinc() != null) {
			where.append(" AND t3.TTICOINC = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticoinc());
		}
		if (tippregprotoc != null && tippregprotoc.getTrnrtipp() != null) {
			where.append(" AND t1.TRNRTIPP = ?");
			params.add(tippregprotoc.getTrnrtipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrcotipp() != null) {
			where.append(" AND t1.TRCOTIPP = ?");
			params.add(tippregprotoc.getTrcotipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrdetipp() != null) {
			where.append(" AND t1.TRDETIPP = ?");
			params.add(tippregprotoc.getTrdetipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrinti() != null) {
			where.append(" AND t1.TRINTI = ?");
			params.add(tippregprotoc.getTrinti());
		}
		if (tippregprotoc != null && tippregprotoc.getTrinre() != null) {
			where.append(" AND t1.TRINRE = ?");
			params.add(tippregprotoc.getTrinre());
		}
		if (tippregprotoc != null && tippregprotoc.getTrrees() != null) {
			where.append(" AND t1.TRREES = ?");
			params.add(tippregprotoc.getTrrees());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipPregProtoc> findAllProtocoloOrdenado(
			TipPregProtoc tippregprotoc) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TRCOTP= t2.TPCODIGO(+) AND t1.TRCOTTI= t3.TTICODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNRTIPP TRNRTIPP,t1.TRCOTIPP TRCOTIPP,t1.TRDETIPP TRDETIPP,t1.TRINTI TRINTI,t1.TRINRE TRINRE,t1.TRREES TRREES,t2.TPCODIGO TIPPROTOCOLOTPCODIGO,t2.TPNOMBRE TIPPROTOCOLOTPNOMBRE,t2.TPCOTMO TIPPROTOCOLOTPCOTMO,t3.TTICODIGO TIPREQNORMATIVOTTICODIGO,t3.TTINOMBRE TIPREQNORMATIVOTTINOMBRE,t3.TTINOCO TIPREQNORMATIVOTTINOCO,t3.TTITEDE TIPREQNORMATIVOTTITEDE,t3.TTICOSE TIPREQNORMATIVOTTICOSE,t3.TTINOCO2 TIPREQNORMATIVOTTINOCO2,t3.TTIINSEL1 TIPREQNORMATIVOTTIINSEL1,t3.TTICOL4 TIPREQNORMATIVOTTICOL4,t3.TTINOMBREE TIPREQNORMATIVOTTINOMBREE,t3.TTINOMBREI TIPREQNORMATIVOTTINOMBREI,t3.TTINOMBREF TIPREQNORMATIVOTTINOMBREF,t3.TTINOCOE TIPREQNORMATIVOTTINOCOE,t3.TTINOCOI TIPREQNORMATIVOTTINOCOI,t3.TTINOCOF TIPREQNORMATIVOTTINOCOF,t3.TTITEDEE TIPREQNORMATIVOTTITEDEE,t3.TTITEDEI TIPREQNORMATIVOTTITEDEI,t3.TTITEDEF TIPREQNORMATIVOTTITEDEF,t3.TTICODGRUPO TIPREQNORMATIVOTTICODGRUPO,t3.TTINOMBREA TIPREQNORMATIVOTTINOMBREA,t3.TTINOCOA TIPREQNORMATIVOTTINOCOA,t3.TTITEDEA TIPREQNORMATIVOTTITEDEA,t3.TTICOE7 TIPREQNORMATIVOTTICOE7,t3.TTICOINC TIPREQNORMATIVOTTICOINC,t2.TPCOCM TIPPROTOCOLOTPCOCM "
						+ "FROM TIP_PREG_PROTOC t1 ,TIP_PROTOCOLO t2 ,TIP_REQ_NORMATIVO t3 ");

		if (tippregprotoc != null && tippregprotoc.getTrcodigo() != null) {
			where.append(" AND t1.TRCODIGO = ?");
			params.add(tippregprotoc.getTrcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t2.TPCODIGO = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpcodigo());
		}
		if (tippregprotoc != null
				&& tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getCampanha() != null
				&& tippregprotoc.getTipProtocolo().getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.TPCOCM = ?");
			params.add(tippregprotoc.getTipProtocolo().getCampanha()
					.getCmcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpnombre() != null) {
			where.append(" AND t2.TPNOMBRE = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpnombre());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcotmo() != null) {
			where.append(" AND t2.TPCOTMO = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpcotmo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND t3.TTICODIGO = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombre() != null) {
			where.append(" AND t3.TTINOMBRE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombre());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinoco() != null) {
			where.append(" AND t3.TTINOCO = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinoco());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitede() != null) {
			where.append(" AND t3.TTITEDE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitede());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticose() != null) {
			where.append(" AND t3.TTICOSE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticose());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinoco2() != null) {
			where.append(" AND t3.TTINOCO2 = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinoco2());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtiinsel1() != null) {
			where.append(" AND t3.TTIINSEL1 = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtiinsel1());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticol4() != null) {
			where.append(" AND t3.TTICOL4 = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticol4());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombree() != null) {
			where.append(" AND t3.TTINOMBREE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombree());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombrei() != null) {
			where.append(" AND t3.TTINOMBREI = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombrei());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombref() != null) {
			where.append(" AND t3.TTINOMBREF = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombref());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocoe() != null) {
			where.append(" AND t3.TTINOCOE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinocoe());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocoi() != null) {
			where.append(" AND t3.TTINOCOI = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinocoi());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocof() != null) {
			where.append(" AND t3.TTINOCOF = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinocof());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedee() != null) {
			where.append(" AND t3.TTITEDEE = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitedee());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedei() != null) {
			where.append(" AND t3.TTITEDEI = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitedei());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedef() != null) {
			where.append(" AND t3.TTITEDEF = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitedef());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticodgrupo() != null) {
			where.append(" AND t3.TTICODGRUPO = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticodgrupo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombrea() != null) {
			where.append(" AND t3.TTINOMBREA = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinombrea());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocoa() != null) {
			where.append(" AND t3.TTINOCOA = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtinocoa());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedea() != null) {
			where.append(" AND t3.TTITEDEA = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTtitedea());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticoe7() != null) {
			where.append(" AND t3.TTICOE7 = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticoe7());
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticoinc() != null) {
			where.append(" AND t3.TTICOINC = ?");
			params.add(tippregprotoc.getTipReqNormativo().getTticoinc());
		}
		if (tippregprotoc != null && tippregprotoc.getTrnrtipp() != null) {
			where.append(" AND t1.TRNRTIPP = ?");
			params.add(tippregprotoc.getTrnrtipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrcotipp() != null) {
			where.append(" AND t1.TRCOTIPP = ?");
			params.add(tippregprotoc.getTrcotipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrdetipp() != null) {
			where.append(" AND t1.TRDETIPP = ?");
			params.add(tippregprotoc.getTrdetipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrinti() != null) {
			where.append(" AND t1.TRINTI = ?");
			params.add(tippregprotoc.getTrinti());
		}
		if (tippregprotoc != null && tippregprotoc.getTrinre() != null) {
			where.append(" AND t1.TRINRE = ?");
			params.add(tippregprotoc.getTrinre());
		}
		if (tippregprotoc != null && tippregprotoc.getTrrees() != null) {
			where.append(" AND t1.TRREES = ?");
			params.add(tippregprotoc.getTrrees());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		order.append(" ORDER BY TRNRTIPP");
		query.append(order);

		return (List<TipPregProtoc>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds rows in the TipPregProtoc table using like.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipPregProtoc> findAllLike(TipPregProtoc tippregprotoc,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TRCOTP= t2.TPCODIGO(+) AND t1.TRCOTTI= t3.TTICODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNRTIPP TRNRTIPP,t1.TRCOTIPP TRCOTIPP,t1.TRDETIPP TRDETIPP,t1.TRINTI TRINTI,t1.TRINRE TRINRE,t1.TRREES TRREES,t2.TPCODIGO TIPPROTOCOLOTPCODIGO,t2.TPNOMBRE TIPPROTOCOLOTPNOMBRE,t2.TPCOTMO TIPPROTOCOLOTPCOTMO,t3.TTICODIGO TIPREQNORMATIVOTTICODIGO,t3.TTINOMBRE TIPREQNORMATIVOTTINOMBRE,t3.TTINOCO TIPREQNORMATIVOTTINOCO,t3.TTITEDE TIPREQNORMATIVOTTITEDE,t3.TTICOSE TIPREQNORMATIVOTTICOSE,t3.TTINOCO2 TIPREQNORMATIVOTTINOCO2,t3.TTIINSEL1 TIPREQNORMATIVOTTIINSEL1,t3.TTICOL4 TIPREQNORMATIVOTTICOL4,t3.TTINOMBREE TIPREQNORMATIVOTTINOMBREE,t3.TTINOMBREI TIPREQNORMATIVOTTINOMBREI,t3.TTINOMBREF TIPREQNORMATIVOTTINOMBREF,t3.TTINOCOE TIPREQNORMATIVOTTINOCOE,t3.TTINOCOI TIPREQNORMATIVOTTINOCOI,t3.TTINOCOF TIPREQNORMATIVOTTINOCOF,t3.TTITEDEE TIPREQNORMATIVOTTITEDEE,t3.TTITEDEI TIPREQNORMATIVOTTITEDEI,t3.TTITEDEF TIPREQNORMATIVOTTITEDEF,t3.TTICODGRUPO TIPREQNORMATIVOTTICODGRUPO,t3.TTINOMBREA TIPREQNORMATIVOTTINOMBREA,t3.TTINOCOA TIPREQNORMATIVOTTINOCOA,t3.TTITEDEA TIPREQNORMATIVOTTITEDEA,t3.TTICOE7 TIPREQNORMATIVOTTICOE7,t3.TTICOINC TIPREQNORMATIVOTTICOINC,t2.TPCOCM TIPPROTOCOLOTPCOCM "
						+ "FROM TIP_PREG_PROTOC t1 ,TIP_PROTOCOLO t2 ,TIP_REQ_NORMATIVO t3 ");

		if (tippregprotoc != null && tippregprotoc.getTrcodigo() != null) {
			where.append(" AND UPPER(t1.TRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTrcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRCODIGO IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t2.TPCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipProtocolo().getTpcodigo() + "%");
			} else {
				params.add("%" + tippregprotoc.getTipProtocolo().getTpcodigo()
						+ "%");
			}
			where.append(" AND t2.TPCODIGO IS NOT NULL");
		}
		if (tippregprotoc != null
				&& tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getCampanha() != null
				&& tippregprotoc.getTipProtocolo().getCampanha().getCmcodigo() != null) {
			where.append(" AND UPPER(t2.TPCOCM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipProtocolo().getCampanha()
						.getCmcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipProtocolo().getCampanha()
								.getCmcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TPCOCM IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpnombre() != null) {
			where.append(" AND UPPER(t2.TPNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipProtocolo().getTpnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipProtocolo().getTpnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TPNOMBRE IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcotmo() != null) {
			where.append(" AND UPPER(t2.TPCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipProtocolo().getTpcotmo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipProtocolo().getTpcotmo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TPCOTMO IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND t3.TTICODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTticodigo()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTticodigo()
						+ "%");
			}
			where.append(" AND t3.TTICODIGO IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombre() != null) {
			where.append(" AND UPPER(t3.TTINOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtinombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtinombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOMBRE IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinoco() != null) {
			where.append(" AND UPPER(t3.TTINOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtinoco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtinoco()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOCO IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitede() != null) {
			where.append(" AND UPPER(t3.TTITEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtitede()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtitede()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTITEDE IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticose() != null) {
			where.append(" AND UPPER(t3.TTICOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTticose()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTticose()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTICOSE IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinoco2() != null) {
			where.append(" AND UPPER(t3.TTINOCO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtinoco2()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtinoco2()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOCO2 IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtiinsel1() != null) {
			where.append(" AND UPPER(t3.TTIINSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtiinsel1()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtiinsel1()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTIINSEL1 IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticol4() != null) {
			where.append(" AND UPPER(t3.TTICOL4) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTticol4()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTticol4()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTICOL4 IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombree() != null) {
			where.append(" AND UPPER(t3.TTINOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtinombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtinombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOMBREE IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombrei() != null) {
			where.append(" AND UPPER(t3.TTINOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtinombrei()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtinombrei()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOMBREI IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombref() != null) {
			where.append(" AND UPPER(t3.TTINOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtinombref()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtinombref()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOMBREF IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocoe() != null) {
			where.append(" AND UPPER(t3.TTINOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtinocoe()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtinocoe()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOCOE IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocoi() != null) {
			where.append(" AND UPPER(t3.TTINOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtinocoi()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtinocoi()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOCOI IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocof() != null) {
			where.append(" AND UPPER(t3.TTINOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtinocof()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtinocof()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOCOF IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedee() != null) {
			where.append(" AND UPPER(t3.TTITEDEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtitedee()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtitedee()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTITEDEE IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedei() != null) {
			where.append(" AND UPPER(t3.TTITEDEI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtitedei()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtitedei()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTITEDEI IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedef() != null) {
			where.append(" AND UPPER(t3.TTITEDEF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtitedef()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtitedef()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTITEDEF IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticodgrupo() != null) {
			where.append(" AND UPPER(t3.TTICODGRUPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTticodgrupo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTticodgrupo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTICODGRUPO IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinombrea() != null) {
			where.append(" AND UPPER(t3.TTINOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtinombrea()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtinombrea()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOMBREA IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtinocoa() != null) {
			where.append(" AND UPPER(t3.TTINOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtinocoa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtinocoa()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOCOA IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTtitedea() != null) {
			where.append(" AND UPPER(t3.TTITEDEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTtitedea()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTtitedea()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTITEDEA IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticoe7() != null) {
			where.append(" AND UPPER(t3.TTICOE7) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTticoe7()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTticoe7()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTICOE7 IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipReqNormativo() != null
				&& tippregprotoc.getTipReqNormativo().getTticoinc() != null) {
			where.append(" AND UPPER(t3.TTICOINC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipReqNormativo().getTticoinc()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tippregprotoc.getTipReqNormativo().getTticoinc()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTICOINC IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTrnrtipp() != null) {
			where.append(" AND t1.TRNRTIPP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTrnrtipp() + "%");
			} else {
				params.add("%" + tippregprotoc.getTrnrtipp() + "%");
			}
			where.append(" AND t1.TRNRTIPP IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTrcotipp() != null) {
			where.append(" AND UPPER(t1.TRCOTIPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTrcotipp().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTrcotipp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRCOTIPP IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTrdetipp() != null) {
			where.append(" AND UPPER(t1.TRDETIPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTrdetipp().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTrdetipp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRDETIPP IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTrinti() != null) {
			where.append(" AND UPPER(t1.TRINTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTrinti().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTrinti().toUpperCase() + "%");
			}
			where.append(" AND t1.TRINTI IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTrinre() != null) {
			where.append(" AND UPPER(t1.TRINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTrinre().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTrinre().toUpperCase() + "%");
			}
			where.append(" AND t1.TRINRE IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTrrees() != null) {
			where.append(" AND UPPER(t1.TRREES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTrrees().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTrrees().toUpperCase() + "%");
			}
			where.append(" AND t1.TRREES IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TipPregProtoc>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
