package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipOrigenProd;

/**
 * * TipOrigenProdDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class TipOrigenProdDaoImpl implements TipOrigenProdDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<TipOrigenProd> rwMap = new RowMapper<TipOrigenProd>() {
		public TipOrigenProd mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new TipOrigenProd(resultSet.getString("TOPCODIGO"),
					resultSet.getString("TOPNOMBRE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the TipOrigenProd table.
	 * 
	 * @param tiporigenprod
	 *            Pagination
	 * @return TipOrigenProd
	 */
	public TipOrigenProd add(TipOrigenProd tiporigenprod) {

		String query = "INSERT INTO ORI_PROD_MUESTRA( TOPCODIGO,TOPNOMBRE)"
				+ "VALUES (?,?)";

		this.jdbcTemplate.update(query, tiporigenprod.getTopcodigo(),
				tiporigenprod.getTopnombre());
		return tiporigenprod;
	}

	/**
	 * Updates a single row in the TipOrigenProd table.
	 * 
	 * @param tiporigenprod
	 *            Pagination
	 * @return TipOrigenProd
	 */
	public TipOrigenProd update(TipOrigenProd tiporigenprod) {
		String query = "UPDATE ORI_PROD_MUESTRA SET TOPNOMBRE=? WHERE TOPCODIGO=?";
		this.jdbcTemplate.update(query, tiporigenprod.getTopnombre(),
				tiporigenprod.getTopcodigo());
		return tiporigenprod;
	}

	/**
	 * Finds a single row in the TipOrigenProd table.
	 * 
	 * @param tiporigenprod
	 *            Pagination
	 * @return TipOrigenProd
	 */
	@Transactional(readOnly = true)
	public TipOrigenProd find(TipOrigenProd tiporigenprod) {
		String query = "SELECT t1.TOPCODIGO TOPCODIGO, t1.TOPNOMBRE TOPNOMBRE "
				+ "FROM ORI_PROD_MUESTRA t1  " + "WHERE t1.TOPCODIGO = ?    ";
		return (TipOrigenProd) this.jdbcTemplate.queryForObject(query, rwMap,
				tiporigenprod.getTopcodigo());
	}

	/**
	 * Removes a single row in the TipOrigenProd table.
	 * 
	 * @param tiporigenprod
	 *            Pagination
	 * @return
	 */
	public void remove(TipOrigenProd tiporigenprod) {
		String query = "DELETE  FROM ORI_PROD_MUESTRA WHERE TOPCODIGO=?";
		this.jdbcTemplate.update(query, tiporigenprod.getTopcodigo());
	}

	/**
	 * Finds a List of rows in the TipOrigenProd table.
	 * 
	 * @param tiporigenprod
	 *            TipOrigenProd
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipOrigenProd> findAll(TipOrigenProd tiporigenprod,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TOPCODIGO TOPCODIGO,t1.TOPNOMBRE TOPNOMBRE "
						+ "FROM ORI_PROD_MUESTRA t1 ");

		if (tiporigenprod != null && tiporigenprod.getTopcodigo() != null) {
			where.append(" AND t1.TOPCODIGO = ?");
			params.add(tiporigenprod.getTopcodigo());
		}
		if (tiporigenprod != null && tiporigenprod.getTopnombre() != null) {
			where.append(" AND t1.TOPNOMBRE = ?");
			params.add(tiporigenprod.getTopnombre());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TipOrigenProd>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TipOrigenProd table.
	 * 
	 * @param tiporigenprod
	 *            TipOrigenProd
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TipOrigenProd tiporigenprod) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ORI_PROD_MUESTRA t1  ");
		if (tiporigenprod != null && tiporigenprod.getTopcodigo() != null) {
			where.append(" AND t1.TOPCODIGO = ?");
			params.add(tiporigenprod.getTopcodigo());
		}
		if (tiporigenprod != null && tiporigenprod.getTopnombre() != null) {
			where.append(" AND t1.TOPNOMBRE = ?");
			params.add(tiporigenprod.getTopnombre());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the TipOrigenProd table using like.
	 * 
	 * @param tiporigenprod
	 *            TipOrigenProd
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipOrigenProd> findAllLike(TipOrigenProd tiporigenprod,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TOPCODIGO TOPCODIGO,t1.TOPNOMBRE TOPNOMBRE "
						+ "FROM ORI_PROD_MUESTRA t1 ");

		if (tiporigenprod != null && tiporigenprod.getTopcodigo() != null) {
			where.append(" AND UPPER(t1.TOPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiporigenprod.getTopcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tiporigenprod.getTopcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TOPCODIGO IS NOT NULL");
		}
		if (tiporigenprod != null && tiporigenprod.getTopnombre() != null) {
			where.append(" AND UPPER(t1.TOPNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiporigenprod.getTopnombre().toUpperCase() + "%");
			} else {
				params.add("%" + tiporigenprod.getTopnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TOPNOMBRE IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TipOrigenProd>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
