package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipDepoMuestra;

/**
 *  * TipDepoMuestraDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 *  
 */
 
@Repository
@Transactional
public class TipDepoMuestraDaoImpl implements TipDepoMuestraDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<TipDepoMuestra> rwMap = new RowMapper<TipDepoMuestra>() {
		public TipDepoMuestra mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new TipDepoMuestra(
               resultSet.getString("TDMCODIGO"), resultSet.getString("TDMNOMBRE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the TipDepoMuestra table.
     *
     * @param tipdepomuestra Pagination
     * @return TipDepoMuestra
     */
	public TipDepoMuestra add(TipDepoMuestra tipdepomuestra) {

    	String query = "INSERT INTO TIP_DEPO_MUESTRA( TDMCODIGO,TDMNOMBRE)"
        + "VALUES (?,?)";

		this.jdbcTemplate.update(query, tipdepomuestra.getTdmcodigo(), tipdepomuestra.getTdmnombre());
		return tipdepomuestra;
	}

    /**
     * Updates a single row in the TipDepoMuestra table.
     *
     * @param tipdepomuestra Pagination
     * @return TipDepoMuestra
     */
    public TipDepoMuestra update(TipDepoMuestra tipdepomuestra) {
		String query = "UPDATE TIP_DEPO_MUESTRA SET TDMNOMBRE=? WHERE TDMCODIGO=?";
		this.jdbcTemplate.update(query, tipdepomuestra.getTdmnombre(), tipdepomuestra.getTdmcodigo());
		return tipdepomuestra;
	}

    /**
     * Finds a single row in the TipDepoMuestra table.
     *
     * @param tipdepomuestra Pagination
     * @return TipDepoMuestra
     */
    @Transactional (readOnly = true)
    public TipDepoMuestra find(TipDepoMuestra tipdepomuestra) {
		String query = "SELECT t1.TDMCODIGO TDMCODIGO, t1.TDMNOMBRE TDMNOMBRE " 
         + "FROM TIP_DEPO_MUESTRA t1  " 
         + "WHERE t1.TDMCODIGO = ?    ";
		return (TipDepoMuestra) this.jdbcTemplate.queryForObject(query, 
			rwMap , tipdepomuestra.getTdmcodigo());	 
    }

    /**
     * Removes a single row in the TipDepoMuestra table.
     *
     * @param tipdepomuestra Pagination
     * @return
     */
    public void remove(TipDepoMuestra tipdepomuestra) {
		String query = "DELETE  FROM TIP_DEPO_MUESTRA WHERE TDMCODIGO=?";
		this.jdbcTemplate.update(query, tipdepomuestra.getTdmcodigo());
    	}
    
   /**
    * Finds a List of rows in the TipDepoMuestra table.
    * 
    * @param tipdepomuestra TipDepoMuestra
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<TipDepoMuestra> findAll(TipDepoMuestra tipdepomuestra, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TDMCODIGO TDMCODIGO,t1.TDMNOMBRE TDMNOMBRE " 
			+ "FROM TIP_DEPO_MUESTRA t1 ");
		
		if (tipdepomuestra  != null  && tipdepomuestra.getTdmcodigo() != null ) {
			where.append(" AND t1.TDMCODIGO = ?");
			params.add(tipdepomuestra.getTdmcodigo());
		}
		if (tipdepomuestra  != null  && tipdepomuestra.getTdmnombre() != null ) {
			where.append(" AND t1.TDMNOMBRE = ?");
			params.add(tipdepomuestra.getTdmnombre());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipDepoMuestra>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the TipDepoMuestra table.
     * 
     * @param tipdepomuestra TipDepoMuestra
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(TipDepoMuestra tipdepomuestra) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  TIP_DEPO_MUESTRA t1  ");
		if (tipdepomuestra  != null  && tipdepomuestra.getTdmcodigo() != null ) {
			where.append(" AND t1.TDMCODIGO = ?");
			params.add(tipdepomuestra.getTdmcodigo());
		}
		if (tipdepomuestra  != null  && tipdepomuestra.getTdmnombre() != null ) {
			where.append(" AND t1.TDMNOMBRE = ?");
			params.add(tipdepomuestra.getTdmnombre());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the TipDepoMuestra table using like.
     * 
     * @param tipdepomuestra TipDepoMuestra
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<TipDepoMuestra> findAllLike(TipDepoMuestra tipdepomuestra, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TDMCODIGO TDMCODIGO,t1.TDMNOMBRE TDMNOMBRE " 
        	+ "FROM TIP_DEPO_MUESTRA t1 ");
      	
		if (tipdepomuestra  != null  && tipdepomuestra.getTdmcodigo() != null ) {
			where.append(" AND UPPER(t1.TDMCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipdepomuestra.getTdmcodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+tipdepomuestra.getTdmcodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.TDMCODIGO IS NOT NULL");
        }
		if (tipdepomuestra  != null  && tipdepomuestra.getTdmnombre() != null ) {
			where.append(" AND UPPER(t1.TDMNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipdepomuestra.getTdmnombre().toUpperCase()  +"%");
			}else{
				params.add("%"+tipdepomuestra.getTdmnombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.TDMNOMBRE IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipDepoMuestra>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

