package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipCaracMuestra;

/**
 *  * TipCaracMuestraDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 *  
 */
 
@Repository
@Transactional
public class TipCaracMuestraDaoImpl implements TipCaracMuestraDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<TipCaracMuestra> rwMap = new RowMapper<TipCaracMuestra>() {
		public TipCaracMuestra mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new TipCaracMuestra(
               resultSet.getString("TCTCODIGO"), resultSet.getString("TCTNOMBRE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the TipCaracMuestra table.
     *
     * @param tipcaracmuestra Pagination
     * @return TipCaracMuestra
     */
	public TipCaracMuestra add(TipCaracMuestra tipcaracmuestra) {

    	String query = "INSERT INTO TIP_CARAC_MUESTRA( TCTCODIGO,TCTNOMBRE)"
        + "VALUES (?,?)";

		this.jdbcTemplate.update(query, tipcaracmuestra.getTctcodigo(), tipcaracmuestra.getTctnombre());
		return tipcaracmuestra;
	}

    /**
     * Updates a single row in the TipCaracMuestra table.
     *
     * @param tipcaracmuestra Pagination
     * @return TipCaracMuestra
     */
    public TipCaracMuestra update(TipCaracMuestra tipcaracmuestra) {
		String query = "UPDATE TIP_CARAC_MUESTRA SET TCTNOMBRE=? WHERE TCTCODIGO=?";
		this.jdbcTemplate.update(query, tipcaracmuestra.getTctnombre(), tipcaracmuestra.getTctcodigo());
		return tipcaracmuestra;
	}

    /**
     * Finds a single row in the TipCaracMuestra table.
     *
     * @param tipcaracmuestra Pagination
     * @return TipCaracMuestra
     */
    @Transactional (readOnly = true)
    public TipCaracMuestra find(TipCaracMuestra tipcaracmuestra) {
		String query = "SELECT t1.TCTCODIGO TCTCODIGO, t1.TCTNOMBRE TCTNOMBRE " 
         + "FROM TIP_CARAC_MUESTRA t1  " 
         + "WHERE t1.TCTCODIGO = ?    ";
		return (TipCaracMuestra) this.jdbcTemplate.queryForObject(query, 
			rwMap , tipcaracmuestra.getTctcodigo());	 
    }

    /**
     * Removes a single row in the TipCaracMuestra table.
     *
     * @param tipcaracmuestra Pagination
     * @return
     */
    public void remove(TipCaracMuestra tipcaracmuestra) {
		String query = "DELETE  FROM TIP_CARAC_MUESTRA WHERE TCTCODIGO=?";
		this.jdbcTemplate.update(query, tipcaracmuestra.getTctcodigo());
    	}
    
   /**
    * Finds a List of rows in the TipCaracMuestra table.
    * 
    * @param tipcaracmuestra TipCaracMuestra
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<TipCaracMuestra> findAll(TipCaracMuestra tipcaracmuestra, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TCTCODIGO TCTCODIGO,t1.TCTNOMBRE TCTNOMBRE " 
			+ "FROM TIP_CARAC_MUESTRA t1 ");
		
		if (tipcaracmuestra  != null  && tipcaracmuestra.getTctcodigo() != null ) {
			where.append(" AND t1.TCTCODIGO = ?");
			params.add(tipcaracmuestra.getTctcodigo());
		}
		if (tipcaracmuestra  != null  && tipcaracmuestra.getTctnombre() != null ) {
			where.append(" AND t1.TCTNOMBRE = ?");
			params.add(tipcaracmuestra.getTctnombre());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipCaracMuestra>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the TipCaracMuestra table.
     * 
     * @param tipcaracmuestra TipCaracMuestra
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(TipCaracMuestra tipcaracmuestra) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  TIP_CARAC_MUESTRA t1  ");
		if (tipcaracmuestra  != null  && tipcaracmuestra.getTctcodigo() != null ) {
			where.append(" AND t1.TCTCODIGO = ?");
			params.add(tipcaracmuestra.getTctcodigo());
		}
		if (tipcaracmuestra  != null  && tipcaracmuestra.getTctnombre() != null ) {
			where.append(" AND t1.TCTNOMBRE = ?");
			params.add(tipcaracmuestra.getTctnombre());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the TipCaracMuestra table using like.
     * 
     * @param tipcaracmuestra TipCaracMuestra
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<TipCaracMuestra> findAllLike(TipCaracMuestra tipcaracmuestra, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TCTCODIGO TCTCODIGO,t1.TCTNOMBRE TCTNOMBRE " 
        	+ "FROM TIP_CARAC_MUESTRA t1 ");
      	
		if (tipcaracmuestra  != null  && tipcaracmuestra.getTctcodigo() != null ) {
			where.append(" AND UPPER(t1.TCTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipcaracmuestra.getTctcodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+tipcaracmuestra.getTctcodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.TCTCODIGO IS NOT NULL");
        }
		if (tipcaracmuestra  != null  && tipcaracmuestra.getTctnombre() != null ) {
			where.append(" AND UPPER(t1.TCTNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipcaracmuestra.getTctnombre().toUpperCase()  +"%");
			}else{
				params.add("%"+tipcaracmuestra.getTctnombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.TCTNOMBRE IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipCaracMuestra>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

