package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipAlerta;

/**
 *  * TipAlertaDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 *  
 */
 
@Repository
@Transactional
public class TipAlertaDaoImpl implements TipAlertaDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<TipAlerta> rwMap = new RowMapper<TipAlerta>() {
		public TipAlerta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new TipAlerta(
               resultSet.getString("TCACODIGO"), resultSet.getString("TCANOMBRE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the TipAlerta table.
     *
     * @param tipalerta Pagination
     * @return TipAlerta
     */
	public TipAlerta add(TipAlerta tipalerta) {

    	String query = "INSERT INTO TIP_ALERTA( TCACODIGO,TCANOMBRE)"
        + "VALUES (?,?)";

		this.jdbcTemplate.update(query, tipalerta.getTcacodigo(), tipalerta.getTcanombre());
		return tipalerta;
	}

    /**
     * Updates a single row in the TipAlerta table.
     *
     * @param tipalerta Pagination
     * @return TipAlerta
     */
    public TipAlerta update(TipAlerta tipalerta) {
		String query = "UPDATE TIP_ALERTA SET TCANOMBRE=? WHERE TCACODIGO=?";
		this.jdbcTemplate.update(query, tipalerta.getTcanombre(), tipalerta.getTcacodigo());
		return tipalerta;
	}

    /**
     * Finds a single row in the TipAlerta table.
     *
     * @param tipalerta Pagination
     * @return TipAlerta
     */
    @Transactional (readOnly = true)
    public TipAlerta find(TipAlerta tipalerta) {
		String query = "SELECT t1.TCACODIGO TCACODIGO, t1.TCANOMBRE TCANOMBRE " 
         + "FROM TIP_ALERTA t1  " 
         + "WHERE t1.TCACODIGO = ?    ";
		return (TipAlerta) this.jdbcTemplate.queryForObject(query, 
			rwMap , tipalerta.getTcacodigo());	 
    }

    /**
     * Removes a single row in the TipAlerta table.
     *
     * @param tipalerta Pagination
     * @return
     */
    public void remove(TipAlerta tipalerta) {
		String query = "DELETE  FROM TIP_ALERTA WHERE TCACODIGO=?";
		this.jdbcTemplate.update(query, tipalerta.getTcacodigo());
    	}
    
   /**
    * Finds a List of rows in the TipAlerta table.
    * 
    * @param tipalerta TipAlerta
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<TipAlerta> findAll(TipAlerta tipalerta, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TCACODIGO TCACODIGO,t1.TCANOMBRE TCANOMBRE " 
			+ "FROM TIP_ALERTA t1 ");
		
		if (tipalerta  != null  && tipalerta.getTcacodigo() != null ) {
			where.append(" AND t1.TCACODIGO = ?");
			params.add(tipalerta.getTcacodigo());
		}
		if (tipalerta  != null  && tipalerta.getTcanombre() != null ) {
			where.append(" AND t1.TCANOMBRE = ?");
			params.add(tipalerta.getTcanombre());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipAlerta>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the TipAlerta table.
     * 
     * @param tipalerta TipAlerta
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(TipAlerta tipalerta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  TIP_ALERTA t1  ");
		if (tipalerta  != null  && tipalerta.getTcacodigo() != null ) {
			where.append(" AND t1.TCACODIGO = ?");
			params.add(tipalerta.getTcacodigo());
		}
		if (tipalerta  != null  && tipalerta.getTcanombre() != null ) {
			where.append(" AND t1.TCANOMBRE = ?");
			params.add(tipalerta.getTcanombre());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the TipAlerta table using like.
     * 
     * @param tipalerta TipAlerta
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<TipAlerta> findAllLike(TipAlerta tipalerta, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TCACODIGO TCACODIGO,t1.TCANOMBRE TCANOMBRE " 
        	+ "FROM TIP_ALERTA t1 ");
      	
		if (tipalerta  != null  && tipalerta.getTcacodigo() != null ) {
			where.append(" AND UPPER(t1.TCACODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipalerta.getTcacodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+tipalerta.getTcacodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.TCACODIGO IS NOT NULL");
        }
		if (tipalerta  != null  && tipalerta.getTcanombre() != null ) {
			where.append(" AND UPPER(t1.TCANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipalerta.getTcanombre().toUpperCase()  +"%");
			}else{
				params.add("%"+tipalerta.getTcanombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.TCANOMBRE IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipAlerta>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

