package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipActuacion;

/**
 *  * TipActuacionDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 *  
 */
 
@Repository
@Transactional
public class TipActuacionDaoImpl implements TipActuacionDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<TipActuacion> rwMap = new RowMapper<TipActuacion>() {
		public TipActuacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new TipActuacion(
               resultSet.getString("TTACODIGO"), resultSet.getString("TTANOMBRE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the TipActuacion table.
     *
     * @param tipactuacion Pagination
     * @return TipActuacion
     */
	public TipActuacion add(TipActuacion tipactuacion) {

    	String query = "INSERT INTO TIP_ACTUACION( TTACODIGO,TTANOMBRE)"
        + "VALUES (?,?)";

		this.jdbcTemplate.update(query, tipactuacion.getTtacodigo(), tipactuacion.getTtanombre());
		return tipactuacion;
	}

    /**
     * Updates a single row in the TipActuacion table.
     *
     * @param tipactuacion Pagination
     * @return TipActuacion
     */
    public TipActuacion update(TipActuacion tipactuacion) {
		String query = "UPDATE TIP_ACTUACION SET TTANOMBRE=? WHERE TTACODIGO=?";
		this.jdbcTemplate.update(query, tipactuacion.getTtanombre(), tipactuacion.getTtacodigo());
		return tipactuacion;
	}

    /**
     * Finds a single row in the TipActuacion table.
     *
     * @param tipactuacion Pagination
     * @return TipActuacion
     */
    @Transactional (readOnly = true)
    public TipActuacion find(TipActuacion tipactuacion) {
		String query = "SELECT t1.TTACODIGO TTACODIGO, t1.TTANOMBRE TTANOMBRE " 
         + "FROM TIP_ACTUACION t1  " 
         + "WHERE t1.TTACODIGO = ?    ";
		return (TipActuacion) this.jdbcTemplate.queryForObject(query, 
			rwMap , tipactuacion.getTtacodigo());	 
    }

    /**
     * Removes a single row in the TipActuacion table.
     *
     * @param tipactuacion Pagination
     * @return
     */
    public void remove(TipActuacion tipactuacion) {
		String query = "DELETE  FROM TIP_ACTUACION WHERE TTACODIGO=?";
		this.jdbcTemplate.update(query, tipactuacion.getTtacodigo());
    	}
    
   /**
    * Finds a List of rows in the TipActuacion table.
    * 
    * @param tipactuacion TipActuacion
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<TipActuacion> findAll(TipActuacion tipactuacion, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TTACODIGO TTACODIGO,t1.TTANOMBRE TTANOMBRE " 
			+ "FROM TIP_ACTUACION t1 ");
		
		if (tipactuacion  != null  && tipactuacion.getTtacodigo() != null ) {
			where.append(" AND t1.TTACODIGO = ?");
			params.add(tipactuacion.getTtacodigo());
		}
		if (tipactuacion  != null  && tipactuacion.getTtanombre() != null ) {
			where.append(" AND t1.TTANOMBRE = ?");
			params.add(tipactuacion.getTtanombre());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipActuacion>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the TipActuacion table.
     * 
     * @param tipactuacion TipActuacion
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(TipActuacion tipactuacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  TIP_ACTUACION t1  ");
		if (tipactuacion  != null  && tipactuacion.getTtacodigo() != null ) {
			where.append(" AND t1.TTACODIGO = ?");
			params.add(tipactuacion.getTtacodigo());
		}
		if (tipactuacion  != null  && tipactuacion.getTtanombre() != null ) {
			where.append(" AND t1.TTANOMBRE = ?");
			params.add(tipactuacion.getTtanombre());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the TipActuacion table using like.
     * 
     * @param tipactuacion TipActuacion
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<TipActuacion> findAllLike(TipActuacion tipactuacion, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TTACODIGO TTACODIGO,t1.TTANOMBRE TTANOMBRE " 
        	+ "FROM TIP_ACTUACION t1 ");
      	
		if (tipactuacion  != null  && tipactuacion.getTtacodigo() != null ) {
			where.append(" AND UPPER(t1.TTACODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipactuacion.getTtacodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+tipactuacion.getTtacodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.TTACODIGO IS NOT NULL");
        }
		if (tipactuacion  != null  && tipactuacion.getTtanombre() != null ) {
			where.append(" AND UPPER(t1.TTANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipactuacion.getTtanombre().toUpperCase()  +"%");
			}else{
				params.add("%"+tipactuacion.getTtanombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.TTANOMBRE IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<TipActuacion>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

