package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Denuncia;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.model.Motivo;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.Sector;
import com.ejie.y41a.model.SolicitudArbitraje;
import com.ejie.y41a.model.SolicitudArbitrajeDetalle;
import com.ejie.y41a.model.TipoReclamacion;

/**
 * * SolicitudArbitrajeDaoImpl generated by UDA, 22-feb-2012 17:30:27.
 * 
 *  
 */

@Repository
@Transactional
public class SolicitudArbitrajeDaoImpl implements SolicitudArbitrajeDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<SolicitudArbitraje> rwMap = new RowMapper<SolicitudArbitraje>() {
		public SolicitudArbitraje mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new SolicitudArbitraje(
					resultSet.getString("SACODIGO"),
					resultSet.getString("SACOJA"),
					resultSet.getInt("SANROR"),
					resultSet.getLong("SANRAN"),
					resultSet.getDate("SAFESOLI"),
					resultSet.getString("SACOT4"),
					resultSet.getString("SACOXJ"),
					resultSet.getString("SANODIDC"),
					resultSet.getString("SACOLODC"),
					resultSet.getString("SANOLODC"),
					resultSet.getString("SACOPVDC"),
					resultSet.getString("SACOMUDC"),
					resultSet.getString("SANRCPDC"),
					resultSet.getString("SAINACUO"),
					resultSet.getString("SACOORPR"),
					resultSet.getString("SACOSERE"),
					resultSet.getString("SACOTTI"),
					resultSet.getString("SAINTISO"),
					resultSet.getBigDecimal("SACNRECL"),
					resultSet.getString("SATEOBRC"),
					resultSet.getDate("SAFEINAD"),
					resultSet.getString("SACOT5"),
					resultSet.getString("SATEINAD"),
					resultSet.getDate("SAFEREIT"),
					resultSet.getDate("SAFETRAS"),
					resultSet.getString("SACOORTR"),
					resultSet.getDate("SAFERETT"),
					resultSet.getDate("SAFERETS"),
					resultSet.getDate("SAFEMEDI"),
					resultSet.getString("SAINREME"),
					resultSet.getDate("SAFEREMT"),
					resultSet.getDate("SAFEDESI"),
					resultSet.getDate("SAFEREDT"),
					resultSet.getDate("SAFENOCO"),
					resultSet.getDate("SAFEREAR"),
					resultSet.getDate("SAFEDECO"),
					resultSet.getString("SACOARPT"),
					resultSet.getString("SAINMENCPT"),
					resultSet.getString("SAINRENCPT"),
					resultSet.getString("SACOARPS"),
					resultSet.getString("SAINMENCPS"),
					resultSet.getString("SAINRENCPS"),
					resultSet.getString("SACOARTT"),
					resultSet.getString("SAINMENCTT"),
					resultSet.getString("SAINRENCTT"),
					resultSet.getString("SACOARTS"),
					resultSet.getString("SAINMENCTS"),
					resultSet.getString("SAINRENCTS"),
					resultSet.getString("SACOCCCO"),
					resultSet.getString("SACOARDT"),
					resultSet.getString("SAINMENCDT"),
					resultSet.getString("SAINRENCDT"),
					resultSet.getString("SACOARDS"),
					resultSet.getString("SAINMENCDS"),
					resultSet.getString("SAINRENCDS"),
					resultSet.getString("SACOOECO"),
					resultSet.getString("SACOSET"),
					resultSet.getString("SAINMENCST"),
					resultSet.getString("SAINRENCST"),
					resultSet.getString("SACOSES"),
					resultSet.getString("SAINMENCSS"),
					resultSet.getString("SAINRENCSS"),
					resultSet.getString("SAINMENCT"),
					resultSet.getString("SAINRENCT"),
					resultSet.getDate("SAFECIAU"),
					resultSet.getString("SAHRCIAU"),
					resultSet.getString("SANOLURA"),
					resultSet.getString("SANODIRA"),
					resultSet.getString("SACOLOA"),
					resultSet.getString("SANRCPA"),
					resultSet.getString("SAINSOPR"),
					resultSet.getString("SAININPR"),
					resultSet.getString("SATEOBPR"),
					resultSet.getString("SACOPE1"),
					resultSet.getBigDecimal("SACNEUPR1"),
					resultSet.getString("SACOPE2"),
					resultSet.getBigDecimal("SACNEUPR2"),
					resultSet.getDate("SAFENOPR"),
					resultSet.getString("SAINMENP1"),
					resultSet.getString("SAINRENP1"),
					resultSet.getString("SAINMENP2"),
					resultSet.getString("SAINRENP2"),
					resultSet.getString("SAINMENPT"),
					resultSet.getString("SAINRENPT"),
					resultSet.getString("SANOLUP"),
					resultSet.getString("SANODIRP"),
					resultSet.getString("SACOLOP"),
					resultSet.getString("SANRCOPOP"),
					resultSet.getString("SANOPVP"),
					resultSet.getString("SANRTELP"),
					resultSet.getString("SANRFAXP"),
					resultSet.getDate("SAFEREPR"),
					resultSet.getString("SAHRREPR"),
					resultSet.getString("SACOARPT2"),
					resultSet.getString("SAINMENCPT2"),
					resultSet.getString("SAINRENCPT2"),
					resultSet.getString("SACOARPS2"),
					resultSet.getString("SAINMENCPS2"),
					resultSet.getString("SAINRENCPS2"),
					resultSet.getString("SACOARTT2"),
					resultSet.getString("SAINMENCTT2"),
					resultSet.getString("SAINRENCTT2"),
					resultSet.getString("SACOARTS2"),
					resultSet.getString("SAINMENCTS2"),
					resultSet.getString("SAINRENCTS2"),
					resultSet.getString("SACOCCCO2"),
					resultSet.getString("SACOARDT2"),
					resultSet.getString("SAINMENCDT2"),
					resultSet.getString("SAINRENCDT2"),
					resultSet.getString("SACOARDS2"),
					resultSet.getString("SAINMENCDS2"),
					resultSet.getString("SAINRENCDS2"),
					resultSet.getString("SACOOECO2"),
					resultSet.getString("SACOSET2"),
					resultSet.getString("SAINMENCST2"),
					resultSet.getString("SAINRENCST2"),
					resultSet.getString("SACOSES2"),
					resultSet.getString("SAINMENCSS2"),
					resultSet.getString("SAINRENCSS2"),
					resultSet.getString("SAINMENCT2"),
					resultSet.getString("SAINRENCT2"),
					resultSet.getDate("SAFECIAU2"),
					resultSet.getString("SAHRCIAU2"),
					resultSet.getString("SANOLURA2"),
					resultSet.getString("SANODIRA2"),
					resultSet.getString("SACOLOA2"),
					resultSet.getString("SANRCPA2"),
					resultSet.getDate("SAFELAUD"),
					resultSet.getString("SATEOBRE"),
					resultSet.getString("SATEMORE"),
					resultSet.getBigDecimal("SACNEUIL"),
					resultSet.getString("SAINFDLA"),
					resultSet.getString("SAINVOLA"),
					resultSet.getString("SAINARNL"),
					resultSet.getString("SACOT7"),
					resultSet.getDate("SAFENOLT"),
					resultSet.getString("SAINMELT"),
					resultSet.getString("SAINPUBO"),
					resultSet.getString("SACOTA1"),
					resultSet.getDate("SAFESERA"),
					resultSet.getString("SAINFDRA"),
					resultSet.getDate("SAFEPEEX"),
					resultSet.getString("SAINRAIN"),
					resultSet.getString("SAINEFIN"),
					resultSet.getDate("SAFEINEF"),
					resultSet.getDate("SAFEAR"),
					resultSet.getDate("SAFENODE"),
					resultSet.getDate("SAFERELT"),
					resultSet.getDate("SAFENOCA"),
					resultSet.getDate("SAFENOCA2"),
					resultSet.getDate("SAFENOAR"),
					resultSet.getString("SACOCCCOS"),
					resultSet.getString("SACOCCCO2S"),
					resultSet.getString("SACOOECOS"),
					resultSet.getString("SACOOECO2S"),
					resultSet.getDate("SAFESOAC"),
					resultSet.getDate("SAFEENAC"),
					resultSet.getDate("SAFENOAC"),
					resultSet.getString("SATEFPR1"),
					resultSet.getString("SATEFPR2"),
					resultSet.getDate("SAFEFPR1"),
					resultSet.getDate("SAFEFPR2"),
					resultSet.getString("SANRBOPL"),
					resultSet.getDate("SAFEENIN"),
					resultSet.getString("SACOTMD"),
					resultSet.getDate("SAFEOPPE"),
					resultSet.getDate("SAFEOPLA"),
					resultSet.getDate("SAFERECO"),
					resultSet.getDate("SAFENOLA"),
					resultSet.getDate("SAFENONA"),
					resultSet.getDate("SAFERENA"),
					resultSet.getDate("SAFECONA"),
					resultSet.getString("SAPUB"),
					resultSet.getString("SAINTICA"),
					resultSet.getString("SACOTIR"),
					resultSet.getString("SACOPS"),
					new HechoDenunciado(
							resultSet.getString("HechoDenunciadoHDCODIGO"),
							resultSet.getLong("HechoDenunciadoHDNROR"),
							resultSet.getString("HechoDenunciadoHDTE"),
							resultSet.getString("HechoDenunciadoHDTEDOAD"),
							resultSet.getString("HechoDenunciadoHDCOAV"),
							resultSet.getString("HechoDenunciadoHDNOPS"),
							resultSet.getString("HechoDenunciadoHDNOMAPS"),
							resultSet.getString("HechoDenunciadoHDNOMOPS"),
							resultSet.getString("HechoDenunciadoHDNRLOPS"),
							resultSet.getDate("HechoDenunciadoHDFEDMPS"),
							resultSet.getString("HechoDenunciadoHDINSOTR"),
							resultSet.getString("HechoDenunciadoHDINSOMA"),
							resultSet.getBigDecimal("HechoDenunciadoHDCAPTSO"),
							resultSet.getString("HechoDenunciadoHDTESO"),
							resultSet.getDate("HechoDenunciadoHDFEARDT"),
							resultSet.getDate("HechoDenunciadoHDFEIOHD"),
							resultSet.getString("HechoDenunciadoHDINININ"),
							resultSet.getDate("HechoDenunciadoHDFEIOPC"),
							resultSet.getDate("HechoDenunciadoHDFEROPC"),
							resultSet.getString("HechoDenunciadoHDCOREPC"),
							resultSet.getDate("HechoDenunciadoHDFEIORP"),
							resultSet.getDate("HechoDenunciadoHDFERORP"),
							resultSet.getString("HechoDenunciadoHDCOREAP"),
							resultSet.getDate("HechoDenunciadoHDFEIORA"),
							resultSet.getString("HechoDenunciadoHDTEACPA"),
							resultSet.getDate("HechoDenunciadoHDFECEAC"),
							resultSet.getString("HechoDenunciadoHDHOCEAC"),
							resultSet.getDate("HechoDenunciadoHDFEIOCA"),
							resultSet.getString("HechoDenunciadoHDTEACDE"),
							resultSet.getDate("HechoDenunciadoHDFEIOAC"),
							resultSet.getDate("HechoDenunciadoHDFEIOFC"),
							resultSet.getString("HechoDenunciadoHDCOTRA"),
							resultSet.getString("HechoDenunciadoHDTE02"),
							resultSet.getString("HechoDenunciadoHDTE03"),
							resultSet.getString("HechoDenunciadoHDTE04"),
							resultSet.getString("HechoDenunciadoHDTE05"),
							resultSet.getString("HechoDenunciadoHDTE06"),
							resultSet.getString("HechoDenunciadoHDTE07"),
							resultSet.getString("HechoDenunciadoHDTE08"),
							resultSet.getString("HechoDenunciadoHDTE09"),
							resultSet.getString("HechoDenunciadoHDTE10"),
							resultSet.getString("HechoDenunciadoHDCOSC"),
							resultSet.getString("HechoDenunciadoHDIDAL"),
							resultSet.getDate("HechoDenunciadoHDFEROAD"),
							resultSet.getDate("HechoDenunciadoHDFEROAT"),
							resultSet.getString("HechoDenunciadoHDTEALDT"),
							resultSet.getString("HechoDenunciadoHDTEDEAT"),
							resultSet.getDate("HechoDenunciadoHDFEDEAT"),
							resultSet.getDate("HechoDenunciadoHDFEHD"),
							resultSet.getString("HechoDenunciadoHDTEDOADE"),
							resultSet.getString("HechoDenunciadoHDTEDOADI"),
							resultSet.getString("HechoDenunciadoHDTEDOADF"),
							resultSet.getString("HechoDenunciadoHDTEDOADA"),
							resultSet.getString("HechoDenunciadoHDNOPSE"),
							resultSet.getString("HechoDenunciadoHDNOPSI"),
							resultSet.getString("HechoDenunciadoHDNOPSF"),
							resultSet.getString("HechoDenunciadoHDNOPSA"),
							resultSet.getString("HechoDenunciadoHDCOCODIGO"),
							resultSet
									.getString("HechoDenunciadoHDCODEXPEDIENTEORIGEN"),
							new Denuncia(resultSet
									.getString("HechoDenunciadoHDCODE"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null),
							new Establecimiento(resultSet
									.getString("HechoDenunciadoHDCOES"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null), new Sector(resultSet
									.getString("HechoDenunciadoHDCOSE"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null),
							new CensoMonitor(resultSet
									.getString("HechoDenunciadoHDCOMO"), null,
									null, null, null, null, null, null, null,
									null, null, null), new Producto(resultSet
									.getString("HechoDenunciadoHDCOPS"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null),
							new TipoReclamacion(resultSet
									.getString("HechoDenunciadoHDCOTSR"), null,
									null, null, null, null, null),
							new Motivo(resultSet
									.getString("HechoDenunciadoHDCOTIR"), null,
									null, null), null),
					new SolicitudArbitraje(
							resultSet.getString("SolicitudArbitrajeSACODIGO"),
							resultSet.getString("SolicitudArbitrajeSACOJA"),
							resultSet.getInt("SolicitudArbitrajeSANROR"),
							resultSet.getLong("SolicitudArbitrajeSANRAN"),
							resultSet.getDate("SolicitudArbitrajeSAFESOLI"),
							resultSet.getString("SolicitudArbitrajeSACOT4"),
							resultSet.getString("SolicitudArbitrajeSACOXJ"),
							resultSet.getString("SolicitudArbitrajeSANODIDC"),
							resultSet.getString("SolicitudArbitrajeSACOLODC"),
							resultSet.getString("SolicitudArbitrajeSANOLODC"),
							resultSet.getString("SolicitudArbitrajeSACOPVDC"),
							resultSet.getString("SolicitudArbitrajeSACOMUDC"),
							resultSet.getString("SolicitudArbitrajeSANRCPDC"),
							resultSet.getString("SolicitudArbitrajeSAINACUO"),
							resultSet.getString("SolicitudArbitrajeSACOORPR"),
							resultSet.getString("SolicitudArbitrajeSACOSERE"),
							resultSet.getString("SolicitudArbitrajeSACOTTI"),
							resultSet.getString("SolicitudArbitrajeSAINTISO"),
							resultSet
									.getBigDecimal("SolicitudArbitrajeSACNRECL"),
							resultSet.getString("SolicitudArbitrajeSATEOBRC"),
							resultSet.getDate("SolicitudArbitrajeSAFEINAD"),
							resultSet.getString("SolicitudArbitrajeSACOT5"),
							resultSet.getString("SolicitudArbitrajeSATEINAD"),
							resultSet.getDate("SolicitudArbitrajeSAFEREIT"),
							resultSet.getDate("SolicitudArbitrajeSAFETRAS"),
							resultSet.getString("SolicitudArbitrajeSACOORTR"),
							resultSet.getDate("SolicitudArbitrajeSAFERETT"),
							resultSet.getDate("SolicitudArbitrajeSAFERETS"),
							resultSet.getDate("SolicitudArbitrajeSAFEMEDI"),
							resultSet.getString("SolicitudArbitrajeSAINREME"),
							resultSet.getDate("SolicitudArbitrajeSAFEREMT"),
							resultSet.getDate("SolicitudArbitrajeSAFEDESI"),
							resultSet.getDate("SolicitudArbitrajeSAFEREDT"),
							resultSet.getDate("SolicitudArbitrajeSAFENOCO"),
							resultSet.getDate("SolicitudArbitrajeSAFEREAR"),
							resultSet.getDate("SolicitudArbitrajeSAFEDECO"),
							resultSet.getString("SolicitudArbitrajeSACOARPT"),
							resultSet.getString("SolicitudArbitrajeSAINMENCPT"),
							resultSet.getString("SolicitudArbitrajeSAINRENCPT"),
							resultSet.getString("SolicitudArbitrajeSACOARPS"),
							resultSet.getString("SolicitudArbitrajeSAINMENCPS"),
							resultSet.getString("SolicitudArbitrajeSAINRENCPS"),
							resultSet.getString("SolicitudArbitrajeSACOARTT"),
							resultSet.getString("SolicitudArbitrajeSAINMENCTT"),
							resultSet.getString("SolicitudArbitrajeSAINRENCTT"),
							resultSet.getString("SolicitudArbitrajeSACOARTS"),
							resultSet.getString("SolicitudArbitrajeSAINMENCTS"),
							resultSet.getString("SolicitudArbitrajeSAINRENCTS"),
							resultSet.getString("SolicitudArbitrajeSACOCCCO"),
							resultSet.getString("SolicitudArbitrajeSACOARDT"),
							resultSet.getString("SolicitudArbitrajeSAINMENCDT"),
							resultSet.getString("SolicitudArbitrajeSAINRENCDT"),
							resultSet.getString("SolicitudArbitrajeSACOARDS"),
							resultSet.getString("SolicitudArbitrajeSAINMENCDS"),
							resultSet.getString("SolicitudArbitrajeSAINRENCDS"),
							resultSet.getString("SolicitudArbitrajeSACOOECO"),
							resultSet.getString("SolicitudArbitrajeSACOSET"),
							resultSet.getString("SolicitudArbitrajeSAINMENCST"),
							resultSet.getString("SolicitudArbitrajeSAINRENCST"),
							resultSet.getString("SolicitudArbitrajeSACOSES"),
							resultSet.getString("SolicitudArbitrajeSAINMENCSS"),
							resultSet.getString("SolicitudArbitrajeSAINRENCSS"),
							resultSet.getString("SolicitudArbitrajeSAINMENCT"),
							resultSet.getString("SolicitudArbitrajeSAINRENCT"),
							resultSet.getDate("SolicitudArbitrajeSAFECIAU"),
							resultSet.getString("SolicitudArbitrajeSAHRCIAU"),
							resultSet.getString("SolicitudArbitrajeSANOLURA"),
							resultSet.getString("SolicitudArbitrajeSANODIRA"),
							resultSet.getString("SolicitudArbitrajeSACOLOA"),
							resultSet.getString("SolicitudArbitrajeSANRCPA"),
							resultSet.getString("SolicitudArbitrajeSAINSOPR"),
							resultSet.getString("SolicitudArbitrajeSAININPR"),
							resultSet.getString("SolicitudArbitrajeSATEOBPR"),
							resultSet.getString("SolicitudArbitrajeSACOPE1"),
							resultSet
									.getBigDecimal("SolicitudArbitrajeSACNEUPR1"),
							resultSet.getString("SolicitudArbitrajeSACOPE2"),
							resultSet
									.getBigDecimal("SolicitudArbitrajeSACNEUPR2"),
							resultSet.getDate("SolicitudArbitrajeSAFENOPR"),
							resultSet.getString("SolicitudArbitrajeSAINMENP1"),
							resultSet.getString("SolicitudArbitrajeSAINRENP1"),
							resultSet.getString("SolicitudArbitrajeSAINMENP2"),
							resultSet.getString("SolicitudArbitrajeSAINRENP2"),
							resultSet.getString("SolicitudArbitrajeSAINMENPT"),
							resultSet.getString("SolicitudArbitrajeSAINRENPT"),
							resultSet.getString("SolicitudArbitrajeSANOLUP"),
							resultSet.getString("SolicitudArbitrajeSANODIRP"),
							resultSet.getString("SolicitudArbitrajeSACOLOP"),
							resultSet.getString("SolicitudArbitrajeSANRCOPOP"),
							resultSet.getString("SolicitudArbitrajeSANOPVP"),
							resultSet.getString("SolicitudArbitrajeSANRTELP"),
							resultSet.getString("SolicitudArbitrajeSANRFAXP"),
							resultSet.getDate("SolicitudArbitrajeSAFEREPR"),
							resultSet.getString("SolicitudArbitrajeSAHRREPR"),
							resultSet.getString("SolicitudArbitrajeSACOARPT2"),
							resultSet
									.getString("SolicitudArbitrajeSAINMENCPT2"),
							resultSet
									.getString("SolicitudArbitrajeSAINRENCPT2"),
							resultSet.getString("SolicitudArbitrajeSACOARPS2"),
							resultSet
									.getString("SolicitudArbitrajeSAINMENCPS2"),
							resultSet
									.getString("SolicitudArbitrajeSAINRENCPS2"),
							resultSet.getString("SolicitudArbitrajeSACOARTT2"),
							resultSet
									.getString("SolicitudArbitrajeSAINMENCTT2"),
							resultSet
									.getString("SolicitudArbitrajeSAINRENCTT2"),
							resultSet.getString("SolicitudArbitrajeSACOARTS2"),
							resultSet
									.getString("SolicitudArbitrajeSAINMENCTS2"),
							resultSet
									.getString("SolicitudArbitrajeSAINRENCTS2"),
							resultSet.getString("SolicitudArbitrajeSACOCCCO2"),
							resultSet.getString("SolicitudArbitrajeSACOARDT2"),
							resultSet
									.getString("SolicitudArbitrajeSAINMENCDT2"),
							resultSet
									.getString("SolicitudArbitrajeSAINRENCDT2"),
							resultSet.getString("SolicitudArbitrajeSACOARDS2"),
							resultSet
									.getString("SolicitudArbitrajeSAINMENCDS2"),
							resultSet
									.getString("SolicitudArbitrajeSAINRENCDS2"),
							resultSet.getString("SolicitudArbitrajeSACOOECO2"),
							resultSet.getString("SolicitudArbitrajeSACOSET2"),
							resultSet
									.getString("SolicitudArbitrajeSAINMENCST2"),
							resultSet
									.getString("SolicitudArbitrajeSAINRENCST2"),
							resultSet.getString("SolicitudArbitrajeSACOSES2"),
							resultSet
									.getString("SolicitudArbitrajeSAINMENCSS2"),
							resultSet
									.getString("SolicitudArbitrajeSAINRENCSS2"),
							resultSet.getString("SolicitudArbitrajeSAINMENCT2"),
							resultSet.getString("SolicitudArbitrajeSAINRENCT2"),
							resultSet.getDate("SolicitudArbitrajeSAFECIAU2"),
							resultSet.getString("SolicitudArbitrajeSAHRCIAU2"),
							resultSet.getString("SolicitudArbitrajeSANOLURA2"),
							resultSet.getString("SolicitudArbitrajeSANODIRA2"),
							resultSet.getString("SolicitudArbitrajeSACOLOA2"),
							resultSet.getString("SolicitudArbitrajeSANRCPA2"),
							resultSet.getDate("SolicitudArbitrajeSAFELAUD"),
							resultSet.getString("SolicitudArbitrajeSATEOBRE"),
							resultSet.getString("SolicitudArbitrajeSATEMORE"),
							resultSet
									.getBigDecimal("SolicitudArbitrajeSACNEUIL"),
							resultSet.getString("SolicitudArbitrajeSAINFDLA"),
							resultSet.getString("SolicitudArbitrajeSAINVOLA"),
							resultSet.getString("SolicitudArbitrajeSAINARNL"),
							resultSet.getString("SolicitudArbitrajeSACOT7"),
							resultSet.getDate("SolicitudArbitrajeSAFENOLT"),
							resultSet.getString("SolicitudArbitrajeSAINMELT"),
							resultSet.getString("SolicitudArbitrajeSAINPUBO"),
							resultSet.getString("SolicitudArbitrajeSACOTA1"),
							resultSet.getDate("SolicitudArbitrajeSAFESERA"),
							resultSet.getString("SolicitudArbitrajeSAINFDRA"),
							resultSet.getDate("SolicitudArbitrajeSAFEPEEX"),
							resultSet.getString("SolicitudArbitrajeSAINRAIN"),
							resultSet.getString("SolicitudArbitrajeSAINEFIN"),
							resultSet.getDate("SolicitudArbitrajeSAFEINEF"),
							resultSet.getDate("SolicitudArbitrajeSAFEAR"),
							resultSet.getDate("SolicitudArbitrajeSAFENODE"),
							resultSet.getDate("SolicitudArbitrajeSAFERELT"),
							resultSet.getDate("SolicitudArbitrajeSAFENOCA"),
							resultSet.getDate("SolicitudArbitrajeSAFENOCA2"),
							resultSet.getDate("SolicitudArbitrajeSAFENOAR"),
							resultSet.getString("SolicitudArbitrajeSACOCCCOS"),
							resultSet.getString("SolicitudArbitrajeSACOCCCO2S"),
							resultSet.getString("SolicitudArbitrajeSACOOECOS"),
							resultSet.getString("SolicitudArbitrajeSACOOECO2S"),
							resultSet.getDate("SolicitudArbitrajeSAFESOAC"),
							resultSet.getDate("SolicitudArbitrajeSAFEENAC"),
							resultSet.getDate("SolicitudArbitrajeSAFENOAC"),
							resultSet.getString("SolicitudArbitrajeSATEFPR1"),
							resultSet.getString("SolicitudArbitrajeSATEFPR2"),
							resultSet.getDate("SolicitudArbitrajeSAFEFPR1"),
							resultSet.getDate("SolicitudArbitrajeSAFEFPR2"),
							resultSet.getString("SolicitudArbitrajeSANRBOPL"),
							resultSet.getDate("SolicitudArbitrajeSAFEENIN"),
							resultSet.getString("SolicitudArbitrajeSACOTMD"),
							resultSet.getDate("SolicitudArbitrajeSAFEOPPE"),
							resultSet.getDate("SolicitudArbitrajeSAFEOPLA"),
							resultSet.getDate("SolicitudArbitrajeSAFERECO"),
							resultSet.getDate("SolicitudArbitrajeSAFENOLA"),
							resultSet.getDate("SolicitudArbitrajeSAFENONA"),
							resultSet.getDate("SolicitudArbitrajeSAFERENA"),
							resultSet.getDate("SolicitudArbitrajeSAFECONA"),
							resultSet.getString("SolicitudArbitrajeSAPUB"),
							resultSet.getString("SolicitudArbitrajeSAINTICA"),
							resultSet.getString("SolicitudArbitrajeSACOTIR"),
							resultSet.getString("SolicitudArbitrajeSACOPS"),
							new HechoDenunciado(resultSet
									.getString("SolicitudArbitrajeSACOHD"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null),
							new SolicitudArbitraje(resultSet
									.getString("SolicitudArbitrajeSACOSAAC"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null)));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the SolicitudArbitraje table.
	 * 
	 * @param solicitudarbitraje
	 *            Pagination
	 * @return SolicitudArbitraje
	 */
	public SolicitudArbitraje add(SolicitudArbitraje solicitudarbitraje) {

		String query = "INSERT INTO SOLICITUD_ARBITRAJE( SACODIGO,SACOHD,SACOSAAC,SACOJA,SANROR,SANRAN,SAFESOLI,SACOT4,SACOXJ,SANODIDC,SACOLODC,SANOLODC,SACOPVDC,SACOMUDC,SANRCPDC,SAINACUO,SACOORPR,SACOSERE,SACOTTI,SAINTISO,SACNRECL,SATEOBRC,SAFEINAD,SACOT5,SATEINAD,SAFEREIT,SAFETRAS,SACOORTR,SAFERETT,SAFERETS,SAFEMEDI,SAINREME,SAFEREMT,SAFEDESI,SAFEREDT,SAFENOCO,SAFEREAR,SAFEDECO,SACOARPT,SAINMENCPT,SAINRENCPT,SACOARPS,SAINMENCPS,SAINRENCPS,SACOARTT,SAINMENCTT,SAINRENCTT,SACOARTS,SAINMENCTS,SAINRENCTS,SACOCCCO,SACOARDT,SAINMENCDT,SAINRENCDT,SACOARDS,SAINMENCDS,SAINRENCDS,SACOOECO,SACOSET,SAINMENCST,SAINRENCST,SACOSES,SAINMENCSS,SAINRENCSS,SAINMENCT,SAINRENCT,SAFECIAU,SAHRCIAU,SANOLURA,SANODIRA,SACOLOA,SANRCPA,SAINSOPR,SAININPR,SATEOBPR,SACOPE1,SACNEUPR1,SACOPE2,SACNEUPR2,SAFENOPR,SAINMENP1,SAINRENP1,SAINMENP2,SAINRENP2,SAINMENPT,SAINRENPT,SANOLUP,SANODIRP,SACOLOP,SANRCOPOP,SANOPVP,SANRTELP,SANRFAXP,SAFEREPR,SAHRREPR,SACOARPT2,SAINMENCPT2,SAINRENCPT2,SACOARPS2,SAINMENCPS2,SAINRENCPS2,SACOARTT2,SAINMENCTT2,SAINRENCTT2,SACOARTS2,SAINMENCTS2,SAINRENCTS2,SACOCCCO2,SACOARDT2,SAINMENCDT2,SAINRENCDT2,SACOARDS2,SAINMENCDS2,SAINRENCDS2,SACOOECO2,SACOSET2,SAINMENCST2,SAINRENCST2,SACOSES2,SAINMENCSS2,SAINRENCSS2,SAINMENCT2,SAINRENCT2,SAFECIAU2,SAHRCIAU2,SANOLURA2,SANODIRA2,SACOLOA2,SANRCPA2,SAFELAUD,SATEOBRE,SATEMORE,SACNEUIL,SAINFDLA,SAINVOLA,SAINARNL,SACOT7,SAFENOLT,SAINMELT,SAINPUBO,SACOTA1,SAFESERA,SAINFDRA,SAFEPEEX,SAINRAIN,SAINEFIN,SAFEINEF,SAFEAR,SAFENODE,SAFERELT,SAFENOCA,SAFENOCA2,SAFENOAR,SACOCCCOS,SACOCCCO2S,SACOOECOS,SACOOECO2S,SAFESOAC,SAFEENAC,SAFENOAC,SATEFPR1,SATEFPR2,SAFEFPR1,SAFEFPR2,SANRBOPL,SAFEENIN,SACOTMD,SAFEOPPE,SAFEOPLA,SAFERECO,SAFENOLA,SAFENONA,SAFERENA,SAFECONA,SAPUB,SAINTICA,SACOTIR,SACOPS)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getHechoDenunciadoHdcodigoAux = null;
		if (solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcodigo() != null) {
			getHechoDenunciadoHdcodigoAux = solicitudarbitraje
					.getHechoDenunciado().getHdcodigo();
		}
		Object getSolicitudArbitrajeSacodigoAux = null;
		if (solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacodigo() != null) {
			getSolicitudArbitrajeSacodigoAux = solicitudarbitraje
					.getSolicitudArbitraje().getSacodigo();
		}
		this.jdbcTemplate
				.update(query, solicitudarbitraje.getSacodigo(),
						getHechoDenunciadoHdcodigoAux,
						getSolicitudArbitrajeSacodigoAux,
						solicitudarbitraje.getSacoja(),
						solicitudarbitraje.getSanror(),
						solicitudarbitraje.getSanran(),
						solicitudarbitraje.getSafesoli(),
						solicitudarbitraje.getSacot4(),
						solicitudarbitraje.getSacoxj(),
						solicitudarbitraje.getSanodidc(),
						solicitudarbitraje.getSacolodc(),
						solicitudarbitraje.getSanolodc(),
						solicitudarbitraje.getSacopvdc(),
						solicitudarbitraje.getSacomudc(),
						solicitudarbitraje.getSanrcpdc(),
						solicitudarbitraje.getSainacuo(),
						solicitudarbitraje.getSacoorpr(),
						solicitudarbitraje.getSacosere(),
						solicitudarbitraje.getSacotti(),
						solicitudarbitraje.getSaintiso(),
						solicitudarbitraje.getSacnrecl(),
						solicitudarbitraje.getSateobrc(),
						solicitudarbitraje.getSafeinad(),
						solicitudarbitraje.getSacot5(),
						solicitudarbitraje.getSateinad(),
						solicitudarbitraje.getSafereit(),
						solicitudarbitraje.getSafetras(),
						solicitudarbitraje.getSacoortr(),
						solicitudarbitraje.getSaferett(),
						solicitudarbitraje.getSaferets(),
						solicitudarbitraje.getSafemedi(),
						solicitudarbitraje.getSainreme(),
						solicitudarbitraje.getSaferemt(),
						solicitudarbitraje.getSafedesi(),
						solicitudarbitraje.getSaferedt(),
						solicitudarbitraje.getSafenoco(),
						solicitudarbitraje.getSaferear(),
						solicitudarbitraje.getSafedeco(),
						solicitudarbitraje.getSacoarpt(),
						solicitudarbitraje.getSainmencpt(),
						solicitudarbitraje.getSainrencpt(),
						solicitudarbitraje.getSacoarps(),
						solicitudarbitraje.getSainmencps(),
						solicitudarbitraje.getSainrencps(),
						solicitudarbitraje.getSacoartt(),
						solicitudarbitraje.getSainmenctt(),
						solicitudarbitraje.getSainrenctt(),
						solicitudarbitraje.getSacoarts(),
						solicitudarbitraje.getSainmencts(),
						solicitudarbitraje.getSainrencts(),
						solicitudarbitraje.getSacoccco(),
						solicitudarbitraje.getSacoardt(),
						solicitudarbitraje.getSainmencdt(),
						solicitudarbitraje.getSainrencdt(),
						solicitudarbitraje.getSacoards(),
						solicitudarbitraje.getSainmencds(),
						solicitudarbitraje.getSainrencds(),
						solicitudarbitraje.getSacooeco(),
						solicitudarbitraje.getSacoset(),
						solicitudarbitraje.getSainmencst(),
						solicitudarbitraje.getSainrencst(),
						solicitudarbitraje.getSacoses(),
						solicitudarbitraje.getSainmencss(),
						solicitudarbitraje.getSainrencss(),
						solicitudarbitraje.getSainmenct(),
						solicitudarbitraje.getSainrenct(),
						solicitudarbitraje.getSafeciau(),
						solicitudarbitraje.getSahrciau(),
						solicitudarbitraje.getSanolura(),
						solicitudarbitraje.getSanodira(),
						solicitudarbitraje.getSacoloa(),
						solicitudarbitraje.getSanrcpa(),
						solicitudarbitraje.getSainsopr(),
						solicitudarbitraje.getSaininpr(),
						solicitudarbitraje.getSateobpr(),
						solicitudarbitraje.getSacope1(),
						solicitudarbitraje.getSacneupr1(),
						solicitudarbitraje.getSacope2(),
						solicitudarbitraje.getSacneupr2(),
						solicitudarbitraje.getSafenopr(),
						solicitudarbitraje.getSainmenp1(),
						solicitudarbitraje.getSainrenp1(),
						solicitudarbitraje.getSainmenp2(),
						solicitudarbitraje.getSainrenp2(),
						solicitudarbitraje.getSainmenpt(),
						solicitudarbitraje.getSainrenpt(),
						solicitudarbitraje.getSanolup(),
						solicitudarbitraje.getSanodirp(),
						solicitudarbitraje.getSacolop(),
						solicitudarbitraje.getSanrcopop(),
						solicitudarbitraje.getSanopvp(),
						solicitudarbitraje.getSanrtelp(),
						solicitudarbitraje.getSanrfaxp(),
						solicitudarbitraje.getSaferepr(),
						solicitudarbitraje.getSahrrepr(),
						solicitudarbitraje.getSacoarpt2(),
						solicitudarbitraje.getSainmencpt2(),
						solicitudarbitraje.getSainrencpt2(),
						solicitudarbitraje.getSacoarps2(),
						solicitudarbitraje.getSainmencps2(),
						solicitudarbitraje.getSainrencps2(),
						solicitudarbitraje.getSacoartt2(),
						solicitudarbitraje.getSainmenctt2(),
						solicitudarbitraje.getSainrenctt2(),
						solicitudarbitraje.getSacoarts2(),
						solicitudarbitraje.getSainmencts2(),
						solicitudarbitraje.getSainrencts2(),
						solicitudarbitraje.getSacoccco2(),
						solicitudarbitraje.getSacoardt2(),
						solicitudarbitraje.getSainmencdt2(),
						solicitudarbitraje.getSainrencdt2(),
						solicitudarbitraje.getSacoards2(),
						solicitudarbitraje.getSainmencds2(),
						solicitudarbitraje.getSainrencds2(),
						solicitudarbitraje.getSacooeco2(),
						solicitudarbitraje.getSacoset2(),
						solicitudarbitraje.getSainmencst2(),
						solicitudarbitraje.getSainrencst2(),
						solicitudarbitraje.getSacoses2(),
						solicitudarbitraje.getSainmencss2(),
						solicitudarbitraje.getSainrencss2(),
						solicitudarbitraje.getSainmenct2(),
						solicitudarbitraje.getSainrenct2(),
						solicitudarbitraje.getSafeciau2(),
						solicitudarbitraje.getSahrciau2(),
						solicitudarbitraje.getSanolura2(),
						solicitudarbitraje.getSanodira2(),
						solicitudarbitraje.getSacoloa2(),
						solicitudarbitraje.getSanrcpa2(),
						solicitudarbitraje.getSafelaud(),
						solicitudarbitraje.getSateobre(),
						solicitudarbitraje.getSatemore(),
						solicitudarbitraje.getSacneuil(),
						solicitudarbitraje.getSainfdla(),
						solicitudarbitraje.getSainvola(),
						solicitudarbitraje.getSainarnl(),
						solicitudarbitraje.getSacot7(),
						solicitudarbitraje.getSafenolt(),
						solicitudarbitraje.getSainmelt(),
						solicitudarbitraje.getSainpubo(),
						solicitudarbitraje.getSacota1(),
						solicitudarbitraje.getSafesera(),
						solicitudarbitraje.getSainfdra(),
						solicitudarbitraje.getSafepeex(),
						solicitudarbitraje.getSainrain(),
						solicitudarbitraje.getSainefin(),
						solicitudarbitraje.getSafeinef(),
						solicitudarbitraje.getSafear(),
						solicitudarbitraje.getSafenode(),
						solicitudarbitraje.getSaferelt(),
						solicitudarbitraje.getSafenoca(),
						solicitudarbitraje.getSafenoca2(),
						solicitudarbitraje.getSafenoar(),
						solicitudarbitraje.getSacocccos(),
						solicitudarbitraje.getSacoccco2s(),
						solicitudarbitraje.getSacooecos(),
						solicitudarbitraje.getSacooeco2s(),
						solicitudarbitraje.getSafesoac(),
						solicitudarbitraje.getSafeenac(),
						solicitudarbitraje.getSafenoac(),
						solicitudarbitraje.getSatefpr1(),
						solicitudarbitraje.getSatefpr2(),
						solicitudarbitraje.getSafefpr1(),
						solicitudarbitraje.getSafefpr2(),
						solicitudarbitraje.getSanrbopl(),
						solicitudarbitraje.getSafeenin(),
						solicitudarbitraje.getSacotmd(),
						solicitudarbitraje.getSafeoppe(),
						solicitudarbitraje.getSafeopla(),
						solicitudarbitraje.getSafereco(),
						solicitudarbitraje.getSafenola(),
						solicitudarbitraje.getSafenona(),
						solicitudarbitraje.getSaferena(),
						solicitudarbitraje.getSafecona(),
						solicitudarbitraje.getSapub(),
						solicitudarbitraje.getSaintica(),
						solicitudarbitraje.getSacotir(),
						solicitudarbitraje.getSacops());
		return solicitudarbitraje;
	}

	/**
	 * Updates a single row in the SolicitudArbitraje table.
	 * 
	 * @param solicitudarbitraje
	 *            Pagination
	 * @return SolicitudArbitraje
	 */
	public SolicitudArbitraje update(SolicitudArbitraje solicitudarbitraje) {
		String query = "UPDATE SOLICITUD_ARBITRAJE SET SACOHD=?,SACOSAAC=?,SACOJA=?,SANROR=?,SANRAN=?,SAFESOLI=?,SACOT4=?,SACOXJ=?,SANODIDC=?,SACOLODC=?,SANOLODC=?,SACOPVDC=?,SACOMUDC=?,SANRCPDC=?,SAINACUO=?,SACOORPR=?,SACOSERE=?,SACOTTI=?,SAINTISO=?,SACNRECL=?,SATEOBRC=?,SAFEINAD=?,SACOT5=?,SATEINAD=?,SAFEREIT=?,SAFETRAS=?,SACOORTR=?,SAFERETT=?,SAFERETS=?,SAFEMEDI=?,SAINREME=?,SAFEREMT=?,SAFEDESI=?,SAFEREDT=?,SAFENOCO=?,SAFEREAR=?,SAFEDECO=?,SACOARPT=?,SAINMENCPT=?,SAINRENCPT=?,SACOARPS=?,SAINMENCPS=?,SAINRENCPS=?,SACOARTT=?,SAINMENCTT=?,SAINRENCTT=?,SACOARTS=?,SAINMENCTS=?,SAINRENCTS=?,SACOCCCO=?,SACOARDT=?,SAINMENCDT=?,SAINRENCDT=?,SACOARDS=?,SAINMENCDS=?,SAINRENCDS=?,SACOOECO=?,SACOSET=?,SAINMENCST=?,SAINRENCST=?,SACOSES=?,SAINMENCSS=?,SAINRENCSS=?,SAINMENCT=?,SAINRENCT=?,SAFECIAU=?,SAHRCIAU=?,SANOLURA=?,SANODIRA=?,SACOLOA=?,SANRCPA=?,SAINSOPR=?,SAININPR=?,SATEOBPR=?,SACOPE1=?,SACNEUPR1=?,SACOPE2=?,SACNEUPR2=?,SAFENOPR=?,SAINMENP1=?,SAINRENP1=?,SAINMENP2=?,SAINRENP2=?,SAINMENPT=?,SAINRENPT=?,SANOLUP=?,SANODIRP=?,SACOLOP=?,SANRCOPOP=?,SANOPVP=?,SANRTELP=?,SANRFAXP=?,SAFEREPR=?,SAHRREPR=?,SACOARPT2=?,SAINMENCPT2=?,SAINRENCPT2=?,SACOARPS2=?,SAINMENCPS2=?,SAINRENCPS2=?,SACOARTT2=?,SAINMENCTT2=?,SAINRENCTT2=?,SACOARTS2=?,SAINMENCTS2=?,SAINRENCTS2=?,SACOCCCO2=?,SACOARDT2=?,SAINMENCDT2=?,SAINRENCDT2=?,SACOARDS2=?,SAINMENCDS2=?,SAINRENCDS2=?,SACOOECO2=?,SACOSET2=?,SAINMENCST2=?,SAINRENCST2=?,SACOSES2=?,SAINMENCSS2=?,SAINRENCSS2=?,SAINMENCT2=?,SAINRENCT2=?,SAFECIAU2=?,SAHRCIAU2=?,SANOLURA2=?,SANODIRA2=?,SACOLOA2=?,SANRCPA2=?,SAFELAUD=?,SATEOBRE=?,SATEMORE=?,SACNEUIL=?,SAINFDLA=?,SAINVOLA=?,SAINARNL=?,SACOT7=?,SAFENOLT=?,SAINMELT=?,SAINPUBO=?,SACOTA1=?,SAFESERA=?,SAINFDRA=?,SAFEPEEX=?,SAINRAIN=?,SAINEFIN=?,SAFEINEF=?,SAFEAR=?,SAFENODE=?,SAFERELT=?,SAFENOCA=?,SAFENOCA2=?,SAFENOAR=?,SACOCCCOS=?,SACOCCCO2S=?,SACOOECOS=?,SACOOECO2S=?,SAFESOAC=?,SAFEENAC=?,SAFENOAC=?,SATEFPR1=?,SATEFPR2=?,SAFEFPR1=?,SAFEFPR2=?,SANRBOPL=?,SAFEENIN=?,SACOTMD=?,SAFEOPPE=?,SAFEOPLA=?,SAFERECO=?,SAFENOLA=?,SAFENONA=?,SAFERENA=?,SAFECONA=?,SAPUB=?,SAINTICA=?,SACOTIR=?,SACOPS=? WHERE SACODIGO=?";
		Object getHechoDenunciadoHdcodigoAux = null;
		if (solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcodigo() != null) {
			getHechoDenunciadoHdcodigoAux = solicitudarbitraje
					.getHechoDenunciado().getHdcodigo();
		}
		Object getSolicitudArbitrajeSacodigoAux = null;
		if (solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacodigo() != null) {
			getSolicitudArbitrajeSacodigoAux = solicitudarbitraje
					.getSolicitudArbitraje().getSacodigo();
		}
		this.jdbcTemplate.update(query, getHechoDenunciadoHdcodigoAux,
				getSolicitudArbitrajeSacodigoAux,
				solicitudarbitraje.getSacoja(), solicitudarbitraje.getSanror(),
				solicitudarbitraje.getSanran(),
				solicitudarbitraje.getSafesoli(),
				solicitudarbitraje.getSacot4(), solicitudarbitraje.getSacoxj(),
				solicitudarbitraje.getSanodidc(),
				solicitudarbitraje.getSacolodc(),
				solicitudarbitraje.getSanolodc(),
				solicitudarbitraje.getSacopvdc(),
				solicitudarbitraje.getSacomudc(),
				solicitudarbitraje.getSanrcpdc(),
				solicitudarbitraje.getSainacuo(),
				solicitudarbitraje.getSacoorpr(),
				solicitudarbitraje.getSacosere(),
				solicitudarbitraje.getSacotti(),
				solicitudarbitraje.getSaintiso(),
				solicitudarbitraje.getSacnrecl(),
				solicitudarbitraje.getSateobrc(),
				solicitudarbitraje.getSafeinad(),
				solicitudarbitraje.getSacot5(),
				solicitudarbitraje.getSateinad(),
				solicitudarbitraje.getSafereit(),
				solicitudarbitraje.getSafetras(),
				solicitudarbitraje.getSacoortr(),
				solicitudarbitraje.getSaferett(),
				solicitudarbitraje.getSaferets(),
				solicitudarbitraje.getSafemedi(),
				solicitudarbitraje.getSainreme(),
				solicitudarbitraje.getSaferemt(),
				solicitudarbitraje.getSafedesi(),
				solicitudarbitraje.getSaferedt(),
				solicitudarbitraje.getSafenoco(),
				solicitudarbitraje.getSaferear(),
				solicitudarbitraje.getSafedeco(),
				solicitudarbitraje.getSacoarpt(),
				solicitudarbitraje.getSainmencpt(),
				solicitudarbitraje.getSainrencpt(),
				solicitudarbitraje.getSacoarps(),
				solicitudarbitraje.getSainmencps(),
				solicitudarbitraje.getSainrencps(),
				solicitudarbitraje.getSacoartt(),
				solicitudarbitraje.getSainmenctt(),
				solicitudarbitraje.getSainrenctt(),
				solicitudarbitraje.getSacoarts(),
				solicitudarbitraje.getSainmencts(),
				solicitudarbitraje.getSainrencts(),
				solicitudarbitraje.getSacoccco(),
				solicitudarbitraje.getSacoardt(),
				solicitudarbitraje.getSainmencdt(),
				solicitudarbitraje.getSainrencdt(),
				solicitudarbitraje.getSacoards(),
				solicitudarbitraje.getSainmencds(),
				solicitudarbitraje.getSainrencds(),
				solicitudarbitraje.getSacooeco(),
				solicitudarbitraje.getSacoset(),
				solicitudarbitraje.getSainmencst(),
				solicitudarbitraje.getSainrencst(),
				solicitudarbitraje.getSacoses(),
				solicitudarbitraje.getSainmencss(),
				solicitudarbitraje.getSainrencss(),
				solicitudarbitraje.getSainmenct(),
				solicitudarbitraje.getSainrenct(),
				solicitudarbitraje.getSafeciau(),
				solicitudarbitraje.getSahrciau(),
				solicitudarbitraje.getSanolura(),
				solicitudarbitraje.getSanodira(),
				solicitudarbitraje.getSacoloa(),
				solicitudarbitraje.getSanrcpa(),
				solicitudarbitraje.getSainsopr(),
				solicitudarbitraje.getSaininpr(),
				solicitudarbitraje.getSateobpr(),
				solicitudarbitraje.getSacope1(),
				solicitudarbitraje.getSacneupr1(),
				solicitudarbitraje.getSacope2(),
				solicitudarbitraje.getSacneupr2(),
				solicitudarbitraje.getSafenopr(),
				solicitudarbitraje.getSainmenp1(),
				solicitudarbitraje.getSainrenp1(),
				solicitudarbitraje.getSainmenp2(),
				solicitudarbitraje.getSainrenp2(),
				solicitudarbitraje.getSainmenpt(),
				solicitudarbitraje.getSainrenpt(),
				solicitudarbitraje.getSanolup(),
				solicitudarbitraje.getSanodirp(),
				solicitudarbitraje.getSacolop(),
				solicitudarbitraje.getSanrcopop(),
				solicitudarbitraje.getSanopvp(),
				solicitudarbitraje.getSanrtelp(),
				solicitudarbitraje.getSanrfaxp(),
				solicitudarbitraje.getSaferepr(),
				solicitudarbitraje.getSahrrepr(),
				solicitudarbitraje.getSacoarpt2(),
				solicitudarbitraje.getSainmencpt2(),
				solicitudarbitraje.getSainrencpt2(),
				solicitudarbitraje.getSacoarps2(),
				solicitudarbitraje.getSainmencps2(),
				solicitudarbitraje.getSainrencps2(),
				solicitudarbitraje.getSacoartt2(),
				solicitudarbitraje.getSainmenctt2(),
				solicitudarbitraje.getSainrenctt2(),
				solicitudarbitraje.getSacoarts2(),
				solicitudarbitraje.getSainmencts2(),
				solicitudarbitraje.getSainrencts2(),
				solicitudarbitraje.getSacoccco2(),
				solicitudarbitraje.getSacoardt2(),
				solicitudarbitraje.getSainmencdt2(),
				solicitudarbitraje.getSainrencdt2(),
				solicitudarbitraje.getSacoards2(),
				solicitudarbitraje.getSainmencds2(),
				solicitudarbitraje.getSainrencds2(),
				solicitudarbitraje.getSacooeco2(),
				solicitudarbitraje.getSacoset2(),
				solicitudarbitraje.getSainmencst2(),
				solicitudarbitraje.getSainrencst2(),
				solicitudarbitraje.getSacoses2(),
				solicitudarbitraje.getSainmencss2(),
				solicitudarbitraje.getSainrencss2(),
				solicitudarbitraje.getSainmenct2(),
				solicitudarbitraje.getSainrenct2(),
				solicitudarbitraje.getSafeciau2(),
				solicitudarbitraje.getSahrciau2(),
				solicitudarbitraje.getSanolura2(),
				solicitudarbitraje.getSanodira2(),
				solicitudarbitraje.getSacoloa2(),
				solicitudarbitraje.getSanrcpa2(),
				solicitudarbitraje.getSafelaud(),
				solicitudarbitraje.getSateobre(),
				solicitudarbitraje.getSatemore(),
				solicitudarbitraje.getSacneuil(),
				solicitudarbitraje.getSainfdla(),
				solicitudarbitraje.getSainvola(),
				solicitudarbitraje.getSainarnl(),
				solicitudarbitraje.getSacot7(),
				solicitudarbitraje.getSafenolt(),
				solicitudarbitraje.getSainmelt(),
				solicitudarbitraje.getSainpubo(),
				solicitudarbitraje.getSacota1(),
				solicitudarbitraje.getSafesera(),
				solicitudarbitraje.getSainfdra(),
				solicitudarbitraje.getSafepeex(),
				solicitudarbitraje.getSainrain(),
				solicitudarbitraje.getSainefin(),
				solicitudarbitraje.getSafeinef(),
				solicitudarbitraje.getSafear(),
				solicitudarbitraje.getSafenode(),
				solicitudarbitraje.getSaferelt(),
				solicitudarbitraje.getSafenoca(),
				solicitudarbitraje.getSafenoca2(),
				solicitudarbitraje.getSafenoar(),
				solicitudarbitraje.getSacocccos(),
				solicitudarbitraje.getSacoccco2s(),
				solicitudarbitraje.getSacooecos(),
				solicitudarbitraje.getSacooeco2s(),
				solicitudarbitraje.getSafesoac(),
				solicitudarbitraje.getSafeenac(),
				solicitudarbitraje.getSafenoac(),
				solicitudarbitraje.getSatefpr1(),
				solicitudarbitraje.getSatefpr2(),
				solicitudarbitraje.getSafefpr1(),
				solicitudarbitraje.getSafefpr2(),
				solicitudarbitraje.getSanrbopl(),
				solicitudarbitraje.getSafeenin(),
				solicitudarbitraje.getSacotmd(),
				solicitudarbitraje.getSafeoppe(),
				solicitudarbitraje.getSafeopla(),
				solicitudarbitraje.getSafereco(),
				solicitudarbitraje.getSafenola(),
				solicitudarbitraje.getSafenona(),
				solicitudarbitraje.getSaferena(),
				solicitudarbitraje.getSafecona(),
				solicitudarbitraje.getSapub(),
				solicitudarbitraje.getSaintica(),
				solicitudarbitraje.getSacotir(),
				solicitudarbitraje.getSacops(),
				solicitudarbitraje.getSacodigo());
		return solicitudarbitraje;
	}

	/**
	 * Finds a single row in the SolicitudArbitraje table.
	 * 
	 * @param solicitudarbitraje
	 *            Pagination
	 * @return SolicitudArbitraje
	 */
	@Transactional(readOnly = true)
	public SolicitudArbitraje find(SolicitudArbitraje solicitudarbitraje) {
		String query = "SELECT t1.SACODIGO SACODIGO, t1.SACOJA SACOJA, t1.SANROR SANROR, t1.SANRAN SANRAN, t1.SAFESOLI SAFESOLI, t1.SACOT4 SACOT4, t1.SACOXJ SACOXJ, t1.SANODIDC SANODIDC, t1.SACOLODC SACOLODC, t1.SANOLODC SANOLODC, t1.SACOPVDC SACOPVDC, t1.SACOMUDC SACOMUDC, t1.SANRCPDC SANRCPDC, t1.SAINACUO SAINACUO, t1.SACOORPR SACOORPR, t1.SACOSERE SACOSERE, t1.SACOTTI SACOTTI, t1.SAINTISO SAINTISO, t1.SACNRECL SACNRECL, t1.SATEOBRC SATEOBRC, t1.SAFEINAD SAFEINAD, t1.SACOT5 SACOT5, t1.SATEINAD SATEINAD, t1.SAFEREIT SAFEREIT, t1.SAFETRAS SAFETRAS, t1.SACOORTR SACOORTR, t1.SAFERETT SAFERETT, t1.SAFERETS SAFERETS, t1.SAFEMEDI SAFEMEDI, t1.SAINREME SAINREME, t1.SAFEREMT SAFEREMT, t1.SAFEDESI SAFEDESI, t1.SAFEREDT SAFEREDT, t1.SAFENOCO SAFENOCO, t1.SAFEREAR SAFEREAR, t1.SAFEDECO SAFEDECO, t1.SACOARPT SACOARPT, t1.SAINMENCPT SAINMENCPT, t1.SAINRENCPT SAINRENCPT, t1.SACOARPS SACOARPS, t1.SAINMENCPS SAINMENCPS, t1.SAINRENCPS SAINRENCPS, t1.SACOARTT SACOARTT, t1.SAINMENCTT SAINMENCTT, t1.SAINRENCTT SAINRENCTT, t1.SACOARTS SACOARTS, t1.SAINMENCTS SAINMENCTS, t1.SAINRENCTS SAINRENCTS, t1.SACOCCCO SACOCCCO, t1.SACOARDT SACOARDT, t1.SAINMENCDT SAINMENCDT, t1.SAINRENCDT SAINRENCDT, t1.SACOARDS SACOARDS, t1.SAINMENCDS SAINMENCDS, t1.SAINRENCDS SAINRENCDS, t1.SACOOECO SACOOECO, t1.SACOSET SACOSET, t1.SAINMENCST SAINMENCST, t1.SAINRENCST SAINRENCST, t1.SACOSES SACOSES, t1.SAINMENCSS SAINMENCSS, t1.SAINRENCSS SAINRENCSS, t1.SAINMENCT SAINMENCT, t1.SAINRENCT SAINRENCT, t1.SAFECIAU SAFECIAU, t1.SAHRCIAU SAHRCIAU, t1.SANOLURA SANOLURA, t1.SANODIRA SANODIRA, t1.SACOLOA SACOLOA, t1.SANRCPA SANRCPA, t1.SAINSOPR SAINSOPR, t1.SAININPR SAININPR, t1.SATEOBPR SATEOBPR, t1.SACOPE1 SACOPE1, t1.SACNEUPR1 SACNEUPR1, t1.SACOPE2 SACOPE2, t1.SACNEUPR2 SACNEUPR2, t1.SAFENOPR SAFENOPR, t1.SAINMENP1 SAINMENP1, t1.SAINRENP1 SAINRENP1, t1.SAINMENP2 SAINMENP2, t1.SAINRENP2 SAINRENP2, t1.SAINMENPT SAINMENPT, t1.SAINRENPT SAINRENPT, t1.SANOLUP SANOLUP, t1.SANODIRP SANODIRP, t1.SACOLOP SACOLOP, t1.SANRCOPOP SANRCOPOP, t1.SANOPVP SANOPVP, t1.SANRTELP SANRTELP, t1.SANRFAXP SANRFAXP, t1.SAFEREPR SAFEREPR, t1.SAHRREPR SAHRREPR, t1.SACOARPT2 SACOARPT2, t1.SAINMENCPT2 SAINMENCPT2, t1.SAINRENCPT2 SAINRENCPT2, t1.SACOARPS2 SACOARPS2, t1.SAINMENCPS2 SAINMENCPS2, t1.SAINRENCPS2 SAINRENCPS2, t1.SACOARTT2 SACOARTT2, t1.SAINMENCTT2 SAINMENCTT2, t1.SAINRENCTT2 SAINRENCTT2, t1.SACOARTS2 SACOARTS2, t1.SAINMENCTS2 SAINMENCTS2, t1.SAINRENCTS2 SAINRENCTS2, t1.SACOCCCO2 SACOCCCO2, t1.SACOARDT2 SACOARDT2, t1.SAINMENCDT2 SAINMENCDT2, t1.SAINRENCDT2 SAINRENCDT2, t1.SACOARDS2 SACOARDS2, t1.SAINMENCDS2 SAINMENCDS2, t1.SAINRENCDS2 SAINRENCDS2, t1.SACOOECO2 SACOOECO2, t1.SACOSET2 SACOSET2, t1.SAINMENCST2 SAINMENCST2, t1.SAINRENCST2 SAINRENCST2, t1.SACOSES2 SACOSES2, t1.SAINMENCSS2 SAINMENCSS2, t1.SAINRENCSS2 SAINRENCSS2, t1.SAINMENCT2 SAINMENCT2, t1.SAINRENCT2 SAINRENCT2, t1.SAFECIAU2 SAFECIAU2, t1.SAHRCIAU2 SAHRCIAU2, t1.SANOLURA2 SANOLURA2, t1.SANODIRA2 SANODIRA2, t1.SACOLOA2 SACOLOA2, t1.SANRCPA2 SANRCPA2, t1.SAFELAUD SAFELAUD, t1.SATEOBRE SATEOBRE, t1.SATEMORE SATEMORE, t1.SACNEUIL SACNEUIL, t1.SAINFDLA SAINFDLA, t1.SAINVOLA SAINVOLA, t1.SAINARNL SAINARNL, t1.SACOT7 SACOT7, t1.SAFENOLT SAFENOLT, t1.SAINMELT SAINMELT, t1.SAINPUBO SAINPUBO, t1.SACOTA1 SACOTA1, t1.SAFESERA SAFESERA, t1.SAINFDRA SAINFDRA, t1.SAFEPEEX SAFEPEEX, t1.SAINRAIN SAINRAIN, t1.SAINEFIN SAINEFIN, t1.SAFEINEF SAFEINEF, t1.SAFEAR SAFEAR, t1.SAFENODE SAFENODE, t1.SAFERELT SAFERELT, t1.SAFENOCA SAFENOCA, t1.SAFENOCA2 SAFENOCA2, t1.SAFENOAR SAFENOAR, t1.SACOCCCOS SACOCCCOS, t1.SACOCCCO2S SACOCCCO2S, t1.SACOOECOS SACOOECOS, t1.SACOOECO2S SACOOECO2S, t1.SAFESOAC SAFESOAC, t1.SAFEENAC SAFEENAC, t1.SAFENOAC SAFENOAC, t1.SATEFPR1 SATEFPR1, t1.SATEFPR2 SATEFPR2, t1.SAFEFPR1 SAFEFPR1, t1.SAFEFPR2 SAFEFPR2, t1.SANRBOPL SANRBOPL, t1.SAFEENIN SAFEENIN, t1.SACOTMD SACOTMD, t1.SAFEOPPE SAFEOPPE, t1.SAFEOPLA SAFEOPLA, t1.SAFERECO SAFERECO, t1.SAFENOLA SAFENOLA, t1.SAFENONA SAFENONA, t1.SAFERENA SAFERENA, t1.SAFECONA SAFECONA, t1.SAPUB SAPUB, t1.SAINTICA SAINTICA, t1.SACOTIR SACOTIR, t1.SACOPS SACOPS, t2.HDCODIGO HECHODENUNCIADOHDCODIGO, t2.HDNROR HECHODENUNCIADOHDNROR, t2.HDTE HECHODENUNCIADOHDTE, t2.HDTEDOAD HECHODENUNCIADOHDTEDOAD, t2.HDCOAV HECHODENUNCIADOHDCOAV, t2.HDNOPS HECHODENUNCIADOHDNOPS, t2.HDNOMAPS HECHODENUNCIADOHDNOMAPS, t2.HDNOMOPS HECHODENUNCIADOHDNOMOPS, t2.HDNRLOPS HECHODENUNCIADOHDNRLOPS, t2.HDFEDMPS HECHODENUNCIADOHDFEDMPS, t2.HDINSOTR HECHODENUNCIADOHDINSOTR, t2.HDINSOMA HECHODENUNCIADOHDINSOMA, t2.HDCAPTSO HECHODENUNCIADOHDCAPTSO, t2.HDTESO HECHODENUNCIADOHDTESO, t2.HDFEARDT HECHODENUNCIADOHDFEARDT, t2.HDFEIOHD HECHODENUNCIADOHDFEIOHD, t2.HDINININ HECHODENUNCIADOHDINININ, t2.HDFEIOPC HECHODENUNCIADOHDFEIOPC, t2.HDFEROPC HECHODENUNCIADOHDFEROPC, t2.HDCOREPC HECHODENUNCIADOHDCOREPC, t2.HDFEIORP HECHODENUNCIADOHDFEIORP, t2.HDFERORP HECHODENUNCIADOHDFERORP, t2.HDCOREAP HECHODENUNCIADOHDCOREAP, t2.HDFEIORA HECHODENUNCIADOHDFEIORA, t2.HDTEACPA HECHODENUNCIADOHDTEACPA, t2.HDFECEAC HECHODENUNCIADOHDFECEAC, t2.HDHOCEAC HECHODENUNCIADOHDHOCEAC, t2.HDFEIOCA HECHODENUNCIADOHDFEIOCA, t2.HDTEACDE HECHODENUNCIADOHDTEACDE, t2.HDFEIOAC HECHODENUNCIADOHDFEIOAC, t2.HDFEIOFC HECHODENUNCIADOHDFEIOFC, t2.HDCOTRA HECHODENUNCIADOHDCOTRA, t2.HDTE02 HECHODENUNCIADOHDTE02, t2.HDTE03 HECHODENUNCIADOHDTE03, t2.HDTE04 HECHODENUNCIADOHDTE04, t2.HDTE05 HECHODENUNCIADOHDTE05, t2.HDTE06 HECHODENUNCIADOHDTE06, t2.HDTE07 HECHODENUNCIADOHDTE07, t2.HDTE08 HECHODENUNCIADOHDTE08, t2.HDTE09 HECHODENUNCIADOHDTE09, t2.HDTE10 HECHODENUNCIADOHDTE10, t2.HDCOSC HECHODENUNCIADOHDCOSC, t2.HDIDAL HECHODENUNCIADOHDIDAL, t2.HDFEROAD HECHODENUNCIADOHDFEROAD, t2.HDFEROAT HECHODENUNCIADOHDFEROAT, t2.HDTEALDT HECHODENUNCIADOHDTEALDT, t2.HDTEDEAT HECHODENUNCIADOHDTEDEAT, t2.HDFEDEAT HECHODENUNCIADOHDFEDEAT, t2.HDFEHD HECHODENUNCIADOHDFEHD, t2.HDTEDOADE HECHODENUNCIADOHDTEDOADE, t2.HDTEDOADI HECHODENUNCIADOHDTEDOADI, t2.HDTEDOADF HECHODENUNCIADOHDTEDOADF, t2.HDTEDOADA HECHODENUNCIADOHDTEDOADA, t2.HDNOPSE HECHODENUNCIADOHDNOPSE, t2.HDNOPSI HECHODENUNCIADOHDNOPSI, t2.HDNOPSF HECHODENUNCIADOHDNOPSF, t2.HDNOPSA HECHODENUNCIADOHDNOPSA, t2.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO, t3.SACODIGO SOLICITUDARBITRAJESACODIGO, t3.SACOJA SOLICITUDARBITRAJESACOJA, t3.SANROR SOLICITUDARBITRAJESANROR, t3.SANRAN SOLICITUDARBITRAJESANRAN, t3.SAFESOLI SOLICITUDARBITRAJESAFESOLI, t3.SACOT4 SOLICITUDARBITRAJESACOT4, t3.SACOXJ SOLICITUDARBITRAJESACOXJ, t3.SANODIDC SOLICITUDARBITRAJESANODIDC, t3.SACOLODC SOLICITUDARBITRAJESACOLODC, t3.SANOLODC SOLICITUDARBITRAJESANOLODC, t3.SACOPVDC SOLICITUDARBITRAJESACOPVDC, t3.SACOMUDC SOLICITUDARBITRAJESACOMUDC, t3.SANRCPDC SOLICITUDARBITRAJESANRCPDC, t3.SAINACUO SOLICITUDARBITRAJESAINACUO, t3.SACOORPR SOLICITUDARBITRAJESACOORPR, t3.SACOSERE SOLICITUDARBITRAJESACOSERE, t3.SACOTTI SOLICITUDARBITRAJESACOTTI, t3.SAINTISO SOLICITUDARBITRAJESAINTISO, t3.SACNRECL SOLICITUDARBITRAJESACNRECL, t3.SATEOBRC SOLICITUDARBITRAJESATEOBRC, t3.SAFEINAD SOLICITUDARBITRAJESAFEINAD, t3.SACOT5 SOLICITUDARBITRAJESACOT5, t3.SATEINAD SOLICITUDARBITRAJESATEINAD, t3.SAFEREIT SOLICITUDARBITRAJESAFEREIT, t3.SAFETRAS SOLICITUDARBITRAJESAFETRAS, t3.SACOORTR SOLICITUDARBITRAJESACOORTR, t3.SAFERETT SOLICITUDARBITRAJESAFERETT, t3.SAFERETS SOLICITUDARBITRAJESAFERETS, t3.SAFEMEDI SOLICITUDARBITRAJESAFEMEDI, t3.SAINREME SOLICITUDARBITRAJESAINREME, t3.SAFEREMT SOLICITUDARBITRAJESAFEREMT, t3.SAFEDESI SOLICITUDARBITRAJESAFEDESI, t3.SAFEREDT SOLICITUDARBITRAJESAFEREDT, t3.SAFENOCO SOLICITUDARBITRAJESAFENOCO, t3.SAFEREAR SOLICITUDARBITRAJESAFEREAR, t3.SAFEDECO SOLICITUDARBITRAJESAFEDECO, t3.SACOARPT SOLICITUDARBITRAJESACOARPT, t3.SAINMENCPT SOLICITUDARBITRAJESAINMENCPT, t3.SAINRENCPT SOLICITUDARBITRAJESAINRENCPT, t3.SACOARPS SOLICITUDARBITRAJESACOARPS, t3.SAINMENCPS SOLICITUDARBITRAJESAINMENCPS, t3.SAINRENCPS SOLICITUDARBITRAJESAINRENCPS, t3.SACOARTT SOLICITUDARBITRAJESACOARTT, t3.SAINMENCTT SOLICITUDARBITRAJESAINMENCTT, t3.SAINRENCTT SOLICITUDARBITRAJESAINRENCTT, t3.SACOARTS SOLICITUDARBITRAJESACOARTS, t3.SAINMENCTS SOLICITUDARBITRAJESAINMENCTS, t3.SAINRENCTS SOLICITUDARBITRAJESAINRENCTS, t3.SACOCCCO SOLICITUDARBITRAJESACOCCCO, t3.SACOARDT SOLICITUDARBITRAJESACOARDT, t3.SAINMENCDT SOLICITUDARBITRAJESAINMENCDT, t3.SAINRENCDT SOLICITUDARBITRAJESAINRENCDT, t3.SACOARDS SOLICITUDARBITRAJESACOARDS, t3.SAINMENCDS SOLICITUDARBITRAJESAINMENCDS, t3.SAINRENCDS SOLICITUDARBITRAJESAINRENCDS, t3.SACOOECO SOLICITUDARBITRAJESACOOECO, t3.SACOSET SOLICITUDARBITRAJESACOSET, t3.SAINMENCST SOLICITUDARBITRAJESAINMENCST, t3.SAINRENCST SOLICITUDARBITRAJESAINRENCST, t3.SACOSES SOLICITUDARBITRAJESACOSES, t3.SAINMENCSS SOLICITUDARBITRAJESAINMENCSS, t3.SAINRENCSS SOLICITUDARBITRAJESAINRENCSS, t3.SAINMENCT SOLICITUDARBITRAJESAINMENCT, t3.SAINRENCT SOLICITUDARBITRAJESAINRENCT, t3.SAFECIAU SOLICITUDARBITRAJESAFECIAU, t3.SAHRCIAU SOLICITUDARBITRAJESAHRCIAU, t3.SANOLURA SOLICITUDARBITRAJESANOLURA, t3.SANODIRA SOLICITUDARBITRAJESANODIRA, t3.SACOLOA SOLICITUDARBITRAJESACOLOA, t3.SANRCPA SOLICITUDARBITRAJESANRCPA, t3.SAINSOPR SOLICITUDARBITRAJESAINSOPR, t3.SAININPR SOLICITUDARBITRAJESAININPR, t3.SATEOBPR SOLICITUDARBITRAJESATEOBPR, t3.SACOPE1 SOLICITUDARBITRAJESACOPE1, t3.SACNEUPR1 SOLICITUDARBITRAJESACNEUPR1, t3.SACOPE2 SOLICITUDARBITRAJESACOPE2, t3.SACNEUPR2 SOLICITUDARBITRAJESACNEUPR2, t3.SAFENOPR SOLICITUDARBITRAJESAFENOPR, t3.SAINMENP1 SOLICITUDARBITRAJESAINMENP1, t3.SAINRENP1 SOLICITUDARBITRAJESAINRENP1, t3.SAINMENP2 SOLICITUDARBITRAJESAINMENP2, t3.SAINRENP2 SOLICITUDARBITRAJESAINRENP2, t3.SAINMENPT SOLICITUDARBITRAJESAINMENPT, t3.SAINRENPT SOLICITUDARBITRAJESAINRENPT, t3.SANOLUP SOLICITUDARBITRAJESANOLUP, t3.SANODIRP SOLICITUDARBITRAJESANODIRP, t3.SACOLOP SOLICITUDARBITRAJESACOLOP, t3.SANRCOPOP SOLICITUDARBITRAJESANRCOPOP, t3.SANOPVP SOLICITUDARBITRAJESANOPVP, t3.SANRTELP SOLICITUDARBITRAJESANRTELP, t3.SANRFAXP SOLICITUDARBITRAJESANRFAXP, t3.SAFEREPR SOLICITUDARBITRAJESAFEREPR, t3.SAHRREPR SOLICITUDARBITRAJESAHRREPR, t3.SACOARPT2 SOLICITUDARBITRAJESACOARPT2, t3.SAINMENCPT2 SOLICITUDARBITRAJESAINMENCPT2, t3.SAINRENCPT2 SOLICITUDARBITRAJESAINRENCPT2, t3.SACOARPS2 SOLICITUDARBITRAJESACOARPS2, t3.SAINMENCPS2 SOLICITUDARBITRAJESAINMENCPS2, t3.SAINRENCPS2 SOLICITUDARBITRAJESAINRENCPS2, t3.SACOARTT2 SOLICITUDARBITRAJESACOARTT2, t3.SAINMENCTT2 SOLICITUDARBITRAJESAINMENCTT2, t3.SAINRENCTT2 SOLICITUDARBITRAJESAINRENCTT2, t3.SACOARTS2 SOLICITUDARBITRAJESACOARTS2, t3.SAINMENCTS2 SOLICITUDARBITRAJESAINMENCTS2, t3.SAINRENCTS2 SOLICITUDARBITRAJESAINRENCTS2, t3.SACOCCCO2 SOLICITUDARBITRAJESACOCCCO2, t3.SACOARDT2 SOLICITUDARBITRAJESACOARDT2, t3.SAINMENCDT2 SOLICITUDARBITRAJESAINMENCDT2, t3.SAINRENCDT2 SOLICITUDARBITRAJESAINRENCDT2, t3.SACOARDS2 SOLICITUDARBITRAJESACOARDS2, t3.SAINMENCDS2 SOLICITUDARBITRAJESAINMENCDS2, t3.SAINRENCDS2 SOLICITUDARBITRAJESAINRENCDS2, t3.SACOOECO2 SOLICITUDARBITRAJESACOOECO2, t3.SACOSET2 SOLICITUDARBITRAJESACOSET2, t3.SAINMENCST2 SOLICITUDARBITRAJESAINMENCST2, t3.SAINRENCST2 SOLICITUDARBITRAJESAINRENCST2, t3.SACOSES2 SOLICITUDARBITRAJESACOSES2, t3.SAINMENCSS2 SOLICITUDARBITRAJESAINMENCSS2, t3.SAINRENCSS2 SOLICITUDARBITRAJESAINRENCSS2, t3.SAINMENCT2 SOLICITUDARBITRAJESAINMENCT2, t3.SAINRENCT2 SOLICITUDARBITRAJESAINRENCT2, t3.SAFECIAU2 SOLICITUDARBITRAJESAFECIAU2, t3.SAHRCIAU2 SOLICITUDARBITRAJESAHRCIAU2, t3.SANOLURA2 SOLICITUDARBITRAJESANOLURA2, t3.SANODIRA2 SOLICITUDARBITRAJESANODIRA2, t3.SACOLOA2 SOLICITUDARBITRAJESACOLOA2, t3.SANRCPA2 SOLICITUDARBITRAJESANRCPA2, t3.SAFELAUD SOLICITUDARBITRAJESAFELAUD, t3.SATEOBRE SOLICITUDARBITRAJESATEOBRE, t3.SATEMORE SOLICITUDARBITRAJESATEMORE, t3.SACNEUIL SOLICITUDARBITRAJESACNEUIL, t3.SAINFDLA SOLICITUDARBITRAJESAINFDLA, t3.SAINVOLA SOLICITUDARBITRAJESAINVOLA, t3.SAINARNL SOLICITUDARBITRAJESAINARNL, t3.SACOT7 SOLICITUDARBITRAJESACOT7, t3.SAFENOLT SOLICITUDARBITRAJESAFENOLT, t3.SAINMELT SOLICITUDARBITRAJESAINMELT, t3.SAINPUBO SOLICITUDARBITRAJESAINPUBO, t3.SACOTA1 SOLICITUDARBITRAJESACOTA1, t3.SAFESERA SOLICITUDARBITRAJESAFESERA, t3.SAINFDRA SOLICITUDARBITRAJESAINFDRA, t3.SAFEPEEX SOLICITUDARBITRAJESAFEPEEX, t3.SAINRAIN SOLICITUDARBITRAJESAINRAIN, t3.SAINEFIN SOLICITUDARBITRAJESAINEFIN, t3.SAFEINEF SOLICITUDARBITRAJESAFEINEF, t3.SAFEAR SOLICITUDARBITRAJESAFEAR, t3.SAFENODE SOLICITUDARBITRAJESAFENODE, t3.SAFERELT SOLICITUDARBITRAJESAFERELT, t3.SAFENOCA SOLICITUDARBITRAJESAFENOCA, t3.SAFENOCA2 SOLICITUDARBITRAJESAFENOCA2, t3.SAFENOAR SOLICITUDARBITRAJESAFENOAR, t3.SACOCCCOS SOLICITUDARBITRAJESACOCCCOS, t3.SACOCCCO2S SOLICITUDARBITRAJESACOCCCO2S, t3.SACOOECOS SOLICITUDARBITRAJESACOOECOS, t3.SACOOECO2S SOLICITUDARBITRAJESACOOECO2S, t3.SAFESOAC SOLICITUDARBITRAJESAFESOAC, t3.SAFEENAC SOLICITUDARBITRAJESAFEENAC, t3.SAFENOAC SOLICITUDARBITRAJESAFENOAC, t3.SATEFPR1 SOLICITUDARBITRAJESATEFPR1, t3.SATEFPR2 SOLICITUDARBITRAJESATEFPR2, t3.SAFEFPR1 SOLICITUDARBITRAJESAFEFPR1, t3.SAFEFPR2 SOLICITUDARBITRAJESAFEFPR2, t3.SANRBOPL SOLICITUDARBITRAJESANRBOPL, t3.SAFEENIN SOLICITUDARBITRAJESAFEENIN, t3.SACOTMD SOLICITUDARBITRAJESACOTMD, t3.SAFEOPPE SOLICITUDARBITRAJESAFEOPPE, t3.SAFEOPLA SOLICITUDARBITRAJESAFEOPLA, t3.SAFERECO SOLICITUDARBITRAJESAFERECO, t3.SAFENOLA SOLICITUDARBITRAJESAFENOLA, t3.SAFENONA SOLICITUDARBITRAJESAFENONA, t3.SAFERENA SOLICITUDARBITRAJESAFERENA, t3.SAFECONA SOLICITUDARBITRAJESAFECONA, t3.SAPUB SOLICITUDARBITRAJESAPUB, t3.SAINTICA SOLICITUDARBITRAJESAINTICA, t3.SACOTIR SOLICITUDARBITRAJESACOTIR, t3.SACOPS SOLICITUDARBITRAJESACOPS, t2.HDCODE HECHODENUNCIADOHDCODE, t2.HDCOES HECHODENUNCIADOHDCOES, t2.HDCOSE HECHODENUNCIADOHDCOSE, t2.HDCOMO HECHODENUNCIADOHDCOMO, t2.HDCOPS HECHODENUNCIADOHDCOPS, t2.HDCOTSR HECHODENUNCIADOHDCOTSR, t2.HDCOTIR HECHODENUNCIADOHDCOTIR, t3.SACOHD SOLICITUDARBITRAJESACOHD, t3.SACOSAAC SOLICITUDARBITRAJESACOSAAC "
				+ "FROM SOLICITUD_ARBITRAJE t1 , HECHO_DENUNCIADO t2 , SOLICITUD_ARBITRAJE t3  "
				+ "WHERE t1.SACODIGO = ?   AND t1.SACOHD= t2.HDCODIGO(+) AND t1.SACOSAAC= t3.SACODIGO(+)  ";
		return (SolicitudArbitraje) this.jdbcTemplate.queryForObject(query,
				rwMap, solicitudarbitraje.getSacodigo());
	}

	/**
	 * Finds a single row in the SolicitudArbitraje table.
	 * 
	 * @param solicitudArbitrajeDetalle
	 *            SolicitudArbitrajeDetalle
	 * @return SolicitudArbitrajeDetalle
	 */
	@Transactional(readOnly = true)
	public SolicitudArbitrajeDetalle findSolicitudArbitraje(
			SolicitudArbitrajeDetalle solicitudArbitrajeDetalle) {
		String query = "SELECT t1.SACODIGO SACODIGO, t1.SACOJA SACOJA, t1.SANROR SANROR, t1.SANRAN SANRAN, t1.SAINTISO SAINTISO, t1.SAFETRAS SAFETRAS, t1.SACOORTR SACOORTR, t1.SAFEMEDI SAFEMEDI, t1.SAFEDESI SAFEDESI, t1.SAINREME SAINREME, t1.SACOTMD SACOTMD,t1.SAFECIAU SAFECIAU, t1.SAFEREPR SAFEREPR, t1.SAFECIAU2 SAFECIAU2, t1.SAFELAUD SAFELAUD, t1.SAINFDLA SAINFDLA, t1.SAINVOLA SAINVOLA, t2.HDCODIGO HECHODENUNCIADOHDCODIGO, t3.SACODIGO SOLICITUDARBITRAJESACODIGO, t3.SACOJA SOLICITUDARBITRAJESACOJA, t3.SANROR SOLICITUDARBITRAJESANROR, t3.SANRAN SOLICITUDARBITRAJESANRAN, t4.NOMBRE_ES NOMBREES, t4.NOMBRE_EU NOMBREEU "
				+ "FROM SOLICITUD_ARBITRAJE t1 , HECHO_DENUNCIADO t2 , SOLICITUD_ARBITRAJE t3, ORGANISMO t4  "
				+ "WHERE t1.SACOHD = ?   AND t1.SACOHD= t2.HDCODIGO(+) AND t1.SACOSAAC= t3.SACODIGO(+) AND t1.SACOORTR= t4.COD_ORG(+)  ";
		return (SolicitudArbitrajeDetalle) this.jdbcTemplate.queryForObject(
				query, new RowMapper<SolicitudArbitrajeDetalle>() {
					public SolicitudArbitrajeDetalle mapRow(
							ResultSet resultSet, int rowNum)
							throws SQLException {
						return new SolicitudArbitrajeDetalle(
								resultSet.getString("SACODIGO"),
								resultSet.getString("SACOJA"),
								resultSet.getInt("SANROR"),
								resultSet.getLong("SANRAN"),
								resultSet.getString("SAINTISO"),
								resultSet.getDate("SAFETRAS"),
								resultSet.getString("SACOORTR"),
								resultSet.getDate("SAFEMEDI"),
								resultSet.getDate("SAFEDESI"),
								resultSet.getString("SAINREME"),
								resultSet.getString("SACOTMD"),
								resultSet.getDate("SAFECIAU"),
								resultSet.getDate("SAFEREPR"),
								resultSet.getDate("SAFECIAU2"),
								resultSet.getDate("SAFELAUD"),
								resultSet.getString("SAINFDLA"),
								resultSet.getString("SAINVOLA"),
								resultSet.getString("NOMBREES"),
								resultSet.getString("NOMBREEU"),
								resultSet.getString("HECHODENUNCIADOHDCODIGO"),
								resultSet
										.getString("SOLICITUDARBITRAJESACODIGO"),
								resultSet.getString("SOLICITUDARBITRAJESACOJA"),
								resultSet.getInt("SOLICITUDARBITRAJESANROR"),
								resultSet.getLong("SOLICITUDARBITRAJESANRAN"));
					}
				}, solicitudArbitrajeDetalle.getHdcodigo());
	}

	/**
	 * Removes a single row in the SolicitudArbitraje table.
	 * 
	 * @param solicitudarbitraje
	 *            Pagination
	 * @return
	 */
	public void remove(SolicitudArbitraje solicitudarbitraje) {
		String query = "DELETE  FROM SOLICITUD_ARBITRAJE WHERE SACODIGO=?";
		this.jdbcTemplate.update(query, solicitudarbitraje.getSacodigo());
	}

	/**
	 * Finds a List of rows in the SolicitudArbitraje table.
	 * 
	 * @param solicitudarbitraje
	 *            SolicitudArbitraje
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<SolicitudArbitraje> findAll(
			SolicitudArbitraje solicitudarbitraje, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.SACOHD= t2.HDCODIGO(+) AND t1.SACOSAAC= t3.SACODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.SACODIGO SACODIGO,t1.SACOJA SACOJA,t1.SANROR SANROR,t1.SANRAN SANRAN,t1.SAFESOLI SAFESOLI,t1.SACOT4 SACOT4,t1.SACOXJ SACOXJ,t1.SANODIDC SANODIDC,t1.SACOLODC SACOLODC,t1.SANOLODC SANOLODC,t1.SACOPVDC SACOPVDC,t1.SACOMUDC SACOMUDC,t1.SANRCPDC SANRCPDC,t1.SAINACUO SAINACUO,t1.SACOORPR SACOORPR,t1.SACOSERE SACOSERE,t1.SACOTTI SACOTTI,t1.SAINTISO SAINTISO,t1.SACNRECL SACNRECL,t1.SATEOBRC SATEOBRC,t1.SAFEINAD SAFEINAD,t1.SACOT5 SACOT5,t1.SATEINAD SATEINAD,t1.SAFEREIT SAFEREIT,t1.SAFETRAS SAFETRAS,t1.SACOORTR SACOORTR,t1.SAFERETT SAFERETT,t1.SAFERETS SAFERETS,t1.SAFEMEDI SAFEMEDI,t1.SAINREME SAINREME,t1.SAFEREMT SAFEREMT,t1.SAFEDESI SAFEDESI,t1.SAFEREDT SAFEREDT,t1.SAFENOCO SAFENOCO,t1.SAFEREAR SAFEREAR,t1.SAFEDECO SAFEDECO,t1.SACOARPT SACOARPT,t1.SAINMENCPT SAINMENCPT,t1.SAINRENCPT SAINRENCPT,t1.SACOARPS SACOARPS,t1.SAINMENCPS SAINMENCPS,t1.SAINRENCPS SAINRENCPS,t1.SACOARTT SACOARTT,t1.SAINMENCTT SAINMENCTT,t1.SAINRENCTT SAINRENCTT,t1.SACOARTS SACOARTS,t1.SAINMENCTS SAINMENCTS,t1.SAINRENCTS SAINRENCTS,t1.SACOCCCO SACOCCCO,t1.SACOARDT SACOARDT,t1.SAINMENCDT SAINMENCDT,t1.SAINRENCDT SAINRENCDT,t1.SACOARDS SACOARDS,t1.SAINMENCDS SAINMENCDS,t1.SAINRENCDS SAINRENCDS,t1.SACOOECO SACOOECO,t1.SACOSET SACOSET,t1.SAINMENCST SAINMENCST,t1.SAINRENCST SAINRENCST,t1.SACOSES SACOSES,t1.SAINMENCSS SAINMENCSS,t1.SAINRENCSS SAINRENCSS,t1.SAINMENCT SAINMENCT,t1.SAINRENCT SAINRENCT,t1.SAFECIAU SAFECIAU,t1.SAHRCIAU SAHRCIAU,t1.SANOLURA SANOLURA,t1.SANODIRA SANODIRA,t1.SACOLOA SACOLOA,t1.SANRCPA SANRCPA,t1.SAINSOPR SAINSOPR,t1.SAININPR SAININPR,t1.SATEOBPR SATEOBPR,t1.SACOPE1 SACOPE1,t1.SACNEUPR1 SACNEUPR1,t1.SACOPE2 SACOPE2,t1.SACNEUPR2 SACNEUPR2,t1.SAFENOPR SAFENOPR,t1.SAINMENP1 SAINMENP1,t1.SAINRENP1 SAINRENP1,t1.SAINMENP2 SAINMENP2,t1.SAINRENP2 SAINRENP2,t1.SAINMENPT SAINMENPT,t1.SAINRENPT SAINRENPT,t1.SANOLUP SANOLUP,t1.SANODIRP SANODIRP,t1.SACOLOP SACOLOP,t1.SANRCOPOP SANRCOPOP,t1.SANOPVP SANOPVP,t1.SANRTELP SANRTELP,t1.SANRFAXP SANRFAXP,t1.SAFEREPR SAFEREPR,t1.SAHRREPR SAHRREPR,t1.SACOARPT2 SACOARPT2,t1.SAINMENCPT2 SAINMENCPT2,t1.SAINRENCPT2 SAINRENCPT2,t1.SACOARPS2 SACOARPS2,t1.SAINMENCPS2 SAINMENCPS2,t1.SAINRENCPS2 SAINRENCPS2,t1.SACOARTT2 SACOARTT2,t1.SAINMENCTT2 SAINMENCTT2,t1.SAINRENCTT2 SAINRENCTT2,t1.SACOARTS2 SACOARTS2,t1.SAINMENCTS2 SAINMENCTS2,t1.SAINRENCTS2 SAINRENCTS2,t1.SACOCCCO2 SACOCCCO2,t1.SACOARDT2 SACOARDT2,t1.SAINMENCDT2 SAINMENCDT2,t1.SAINRENCDT2 SAINRENCDT2,t1.SACOARDS2 SACOARDS2,t1.SAINMENCDS2 SAINMENCDS2,t1.SAINRENCDS2 SAINRENCDS2,t1.SACOOECO2 SACOOECO2,t1.SACOSET2 SACOSET2,t1.SAINMENCST2 SAINMENCST2,t1.SAINRENCST2 SAINRENCST2,t1.SACOSES2 SACOSES2,t1.SAINMENCSS2 SAINMENCSS2,t1.SAINRENCSS2 SAINRENCSS2,t1.SAINMENCT2 SAINMENCT2,t1.SAINRENCT2 SAINRENCT2,t1.SAFECIAU2 SAFECIAU2,t1.SAHRCIAU2 SAHRCIAU2,t1.SANOLURA2 SANOLURA2,t1.SANODIRA2 SANODIRA2,t1.SACOLOA2 SACOLOA2,t1.SANRCPA2 SANRCPA2,t1.SAFELAUD SAFELAUD,t1.SATEOBRE SATEOBRE,t1.SATEMORE SATEMORE,t1.SACNEUIL SACNEUIL,t1.SAINFDLA SAINFDLA,t1.SAINVOLA SAINVOLA,t1.SAINARNL SAINARNL,t1.SACOT7 SACOT7,t1.SAFENOLT SAFENOLT,t1.SAINMELT SAINMELT,t1.SAINPUBO SAINPUBO,t1.SACOTA1 SACOTA1,t1.SAFESERA SAFESERA,t1.SAINFDRA SAINFDRA,t1.SAFEPEEX SAFEPEEX,t1.SAINRAIN SAINRAIN,t1.SAINEFIN SAINEFIN,t1.SAFEINEF SAFEINEF,t1.SAFEAR SAFEAR,t1.SAFENODE SAFENODE,t1.SAFERELT SAFERELT,t1.SAFENOCA SAFENOCA,t1.SAFENOCA2 SAFENOCA2,t1.SAFENOAR SAFENOAR,t1.SACOCCCOS SACOCCCOS,t1.SACOCCCO2S SACOCCCO2S,t1.SACOOECOS SACOOECOS,t1.SACOOECO2S SACOOECO2S,t1.SAFESOAC SAFESOAC,t1.SAFEENAC SAFEENAC,t1.SAFENOAC SAFENOAC,t1.SATEFPR1 SATEFPR1,t1.SATEFPR2 SATEFPR2,t1.SAFEFPR1 SAFEFPR1,t1.SAFEFPR2 SAFEFPR2,t1.SANRBOPL SANRBOPL,t1.SAFEENIN SAFEENIN,t1.SACOTMD SACOTMD,t1.SAFEOPPE SAFEOPPE,t1.SAFEOPLA SAFEOPLA,t1.SAFERECO SAFERECO,t1.SAFENOLA SAFENOLA,t1.SAFENONA SAFENONA,t1.SAFERENA SAFERENA,t1.SAFECONA SAFECONA,t1.SAPUB SAPUB,t1.SAINTICA SAINTICA,t1.SACOTIR SACOTIR,t1.SACOPS SACOPS,t2.HDCODIGO HECHODENUNCIADOHDCODIGO,t2.HDNROR HECHODENUNCIADOHDNROR,t2.HDTE HECHODENUNCIADOHDTE,t2.HDTEDOAD HECHODENUNCIADOHDTEDOAD,t2.HDCOAV HECHODENUNCIADOHDCOAV,t2.HDNOPS HECHODENUNCIADOHDNOPS,t2.HDNOMAPS HECHODENUNCIADOHDNOMAPS,t2.HDNOMOPS HECHODENUNCIADOHDNOMOPS,t2.HDNRLOPS HECHODENUNCIADOHDNRLOPS,t2.HDFEDMPS HECHODENUNCIADOHDFEDMPS,t2.HDINSOTR HECHODENUNCIADOHDINSOTR,t2.HDINSOMA HECHODENUNCIADOHDINSOMA,t2.HDCAPTSO HECHODENUNCIADOHDCAPTSO,t2.HDTESO HECHODENUNCIADOHDTESO,t2.HDFEARDT HECHODENUNCIADOHDFEARDT,t2.HDFEIOHD HECHODENUNCIADOHDFEIOHD,t2.HDINININ HECHODENUNCIADOHDINININ,t2.HDFEIOPC HECHODENUNCIADOHDFEIOPC,t2.HDFEROPC HECHODENUNCIADOHDFEROPC,t2.HDCOREPC HECHODENUNCIADOHDCOREPC,t2.HDFEIORP HECHODENUNCIADOHDFEIORP,t2.HDFERORP HECHODENUNCIADOHDFERORP,t2.HDCOREAP HECHODENUNCIADOHDCOREAP,t2.HDFEIORA HECHODENUNCIADOHDFEIORA,t2.HDTEACPA HECHODENUNCIADOHDTEACPA,t2.HDFECEAC HECHODENUNCIADOHDFECEAC,t2.HDHOCEAC HECHODENUNCIADOHDHOCEAC,t2.HDFEIOCA HECHODENUNCIADOHDFEIOCA,t2.HDTEACDE HECHODENUNCIADOHDTEACDE,t2.HDFEIOAC HECHODENUNCIADOHDFEIOAC,t2.HDFEIOFC HECHODENUNCIADOHDFEIOFC,t2.HDCOTRA HECHODENUNCIADOHDCOTRA,t2.HDTE02 HECHODENUNCIADOHDTE02,t2.HDTE03 HECHODENUNCIADOHDTE03,t2.HDTE04 HECHODENUNCIADOHDTE04,t2.HDTE05 HECHODENUNCIADOHDTE05,t2.HDTE06 HECHODENUNCIADOHDTE06,t2.HDTE07 HECHODENUNCIADOHDTE07,t2.HDTE08 HECHODENUNCIADOHDTE08,t2.HDTE09 HECHODENUNCIADOHDTE09,t2.HDTE10 HECHODENUNCIADOHDTE10,t2.HDCOSC HECHODENUNCIADOHDCOSC,t2.HDIDAL HECHODENUNCIADOHDIDAL,t2.HDFEROAD HECHODENUNCIADOHDFEROAD,t2.HDFEROAT HECHODENUNCIADOHDFEROAT,t2.HDTEALDT HECHODENUNCIADOHDTEALDT,t2.HDTEDEAT HECHODENUNCIADOHDTEDEAT,t2.HDFEDEAT HECHODENUNCIADOHDFEDEAT,t2.HDFEHD HECHODENUNCIADOHDFEHD,t2.HDTEDOADE HECHODENUNCIADOHDTEDOADE,t2.HDTEDOADI HECHODENUNCIADOHDTEDOADI,t2.HDTEDOADF HECHODENUNCIADOHDTEDOADF,t2.HDTEDOADA HECHODENUNCIADOHDTEDOADA,t2.HDNOPSE HECHODENUNCIADOHDNOPSE,t2.HDNOPSI HECHODENUNCIADOHDNOPSI,t2.HDNOPSF HECHODENUNCIADOHDNOPSF,t2.HDNOPSA HECHODENUNCIADOHDNOPSA,t2.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO,t3.SACODIGO SOLICITUDARBITRAJESACODIGO,t3.SACOJA SOLICITUDARBITRAJESACOJA,t3.SANROR SOLICITUDARBITRAJESANROR,t3.SANRAN SOLICITUDARBITRAJESANRAN,t3.SAFESOLI SOLICITUDARBITRAJESAFESOLI,t3.SACOT4 SOLICITUDARBITRAJESACOT4,t3.SACOXJ SOLICITUDARBITRAJESACOXJ,t3.SANODIDC SOLICITUDARBITRAJESANODIDC,t3.SACOLODC SOLICITUDARBITRAJESACOLODC,t3.SANOLODC SOLICITUDARBITRAJESANOLODC,t3.SACOPVDC SOLICITUDARBITRAJESACOPVDC,t3.SACOMUDC SOLICITUDARBITRAJESACOMUDC,t3.SANRCPDC SOLICITUDARBITRAJESANRCPDC,t3.SAINACUO SOLICITUDARBITRAJESAINACUO,t3.SACOORPR SOLICITUDARBITRAJESACOORPR,t3.SACOSERE SOLICITUDARBITRAJESACOSERE,t3.SACOTTI SOLICITUDARBITRAJESACOTTI,t3.SAINTISO SOLICITUDARBITRAJESAINTISO,t3.SACNRECL SOLICITUDARBITRAJESACNRECL,t3.SATEOBRC SOLICITUDARBITRAJESATEOBRC,t3.SAFEINAD SOLICITUDARBITRAJESAFEINAD,t3.SACOT5 SOLICITUDARBITRAJESACOT5,t3.SATEINAD SOLICITUDARBITRAJESATEINAD,t3.SAFEREIT SOLICITUDARBITRAJESAFEREIT,t3.SAFETRAS SOLICITUDARBITRAJESAFETRAS,t3.SACOORTR SOLICITUDARBITRAJESACOORTR,t3.SAFERETT SOLICITUDARBITRAJESAFERETT,t3.SAFERETS SOLICITUDARBITRAJESAFERETS,t3.SAFEMEDI SOLICITUDARBITRAJESAFEMEDI,t3.SAINREME SOLICITUDARBITRAJESAINREME,t3.SAFEREMT SOLICITUDARBITRAJESAFEREMT,t3.SAFEDESI SOLICITUDARBITRAJESAFEDESI,t3.SAFEREDT SOLICITUDARBITRAJESAFEREDT,t3.SAFENOCO SOLICITUDARBITRAJESAFENOCO,t3.SAFEREAR SOLICITUDARBITRAJESAFEREAR,t3.SAFEDECO SOLICITUDARBITRAJESAFEDECO,t3.SACOARPT SOLICITUDARBITRAJESACOARPT,t3.SAINMENCPT SOLICITUDARBITRAJESAINMENCPT,t3.SAINRENCPT SOLICITUDARBITRAJESAINRENCPT,t3.SACOARPS SOLICITUDARBITRAJESACOARPS,t3.SAINMENCPS SOLICITUDARBITRAJESAINMENCPS,t3.SAINRENCPS SOLICITUDARBITRAJESAINRENCPS,t3.SACOARTT SOLICITUDARBITRAJESACOARTT,t3.SAINMENCTT SOLICITUDARBITRAJESAINMENCTT,t3.SAINRENCTT SOLICITUDARBITRAJESAINRENCTT,t3.SACOARTS SOLICITUDARBITRAJESACOARTS,t3.SAINMENCTS SOLICITUDARBITRAJESAINMENCTS,t3.SAINRENCTS SOLICITUDARBITRAJESAINRENCTS,t3.SACOCCCO SOLICITUDARBITRAJESACOCCCO,t3.SACOARDT SOLICITUDARBITRAJESACOARDT,t3.SAINMENCDT SOLICITUDARBITRAJESAINMENCDT,t3.SAINRENCDT SOLICITUDARBITRAJESAINRENCDT,t3.SACOARDS SOLICITUDARBITRAJESACOARDS,t3.SAINMENCDS SOLICITUDARBITRAJESAINMENCDS,t3.SAINRENCDS SOLICITUDARBITRAJESAINRENCDS,t3.SACOOECO SOLICITUDARBITRAJESACOOECO,t3.SACOSET SOLICITUDARBITRAJESACOSET,t3.SAINMENCST SOLICITUDARBITRAJESAINMENCST,t3.SAINRENCST SOLICITUDARBITRAJESAINRENCST,t3.SACOSES SOLICITUDARBITRAJESACOSES,t3.SAINMENCSS SOLICITUDARBITRAJESAINMENCSS,t3.SAINRENCSS SOLICITUDARBITRAJESAINRENCSS,t3.SAINMENCT SOLICITUDARBITRAJESAINMENCT,t3.SAINRENCT SOLICITUDARBITRAJESAINRENCT,t3.SAFECIAU SOLICITUDARBITRAJESAFECIAU,t3.SAHRCIAU SOLICITUDARBITRAJESAHRCIAU,t3.SANOLURA SOLICITUDARBITRAJESANOLURA,t3.SANODIRA SOLICITUDARBITRAJESANODIRA,t3.SACOLOA SOLICITUDARBITRAJESACOLOA,t3.SANRCPA SOLICITUDARBITRAJESANRCPA,t3.SAINSOPR SOLICITUDARBITRAJESAINSOPR,t3.SAININPR SOLICITUDARBITRAJESAININPR,t3.SATEOBPR SOLICITUDARBITRAJESATEOBPR,t3.SACOPE1 SOLICITUDARBITRAJESACOPE1,t3.SACNEUPR1 SOLICITUDARBITRAJESACNEUPR1,t3.SACOPE2 SOLICITUDARBITRAJESACOPE2,t3.SACNEUPR2 SOLICITUDARBITRAJESACNEUPR2,t3.SAFENOPR SOLICITUDARBITRAJESAFENOPR,t3.SAINMENP1 SOLICITUDARBITRAJESAINMENP1,t3.SAINRENP1 SOLICITUDARBITRAJESAINRENP1,t3.SAINMENP2 SOLICITUDARBITRAJESAINMENP2,t3.SAINRENP2 SOLICITUDARBITRAJESAINRENP2,t3.SAINMENPT SOLICITUDARBITRAJESAINMENPT,t3.SAINRENPT SOLICITUDARBITRAJESAINRENPT,t3.SANOLUP SOLICITUDARBITRAJESANOLUP,t3.SANODIRP SOLICITUDARBITRAJESANODIRP,t3.SACOLOP SOLICITUDARBITRAJESACOLOP,t3.SANRCOPOP SOLICITUDARBITRAJESANRCOPOP,t3.SANOPVP SOLICITUDARBITRAJESANOPVP,t3.SANRTELP SOLICITUDARBITRAJESANRTELP,t3.SANRFAXP SOLICITUDARBITRAJESANRFAXP,t3.SAFEREPR SOLICITUDARBITRAJESAFEREPR,t3.SAHRREPR SOLICITUDARBITRAJESAHRREPR,t3.SACOARPT2 SOLICITUDARBITRAJESACOARPT2,t3.SAINMENCPT2 SOLICITUDARBITRAJESAINMENCPT2,t3.SAINRENCPT2 SOLICITUDARBITRAJESAINRENCPT2,t3.SACOARPS2 SOLICITUDARBITRAJESACOARPS2,t3.SAINMENCPS2 SOLICITUDARBITRAJESAINMENCPS2,t3.SAINRENCPS2 SOLICITUDARBITRAJESAINRENCPS2,t3.SACOARTT2 SOLICITUDARBITRAJESACOARTT2,t3.SAINMENCTT2 SOLICITUDARBITRAJESAINMENCTT2,t3.SAINRENCTT2 SOLICITUDARBITRAJESAINRENCTT2,t3.SACOARTS2 SOLICITUDARBITRAJESACOARTS2,t3.SAINMENCTS2 SOLICITUDARBITRAJESAINMENCTS2,t3.SAINRENCTS2 SOLICITUDARBITRAJESAINRENCTS2,t3.SACOCCCO2 SOLICITUDARBITRAJESACOCCCO2,t3.SACOARDT2 SOLICITUDARBITRAJESACOARDT2,t3.SAINMENCDT2 SOLICITUDARBITRAJESAINMENCDT2,t3.SAINRENCDT2 SOLICITUDARBITRAJESAINRENCDT2,t3.SACOARDS2 SOLICITUDARBITRAJESACOARDS2,t3.SAINMENCDS2 SOLICITUDARBITRAJESAINMENCDS2,t3.SAINRENCDS2 SOLICITUDARBITRAJESAINRENCDS2,t3.SACOOECO2 SOLICITUDARBITRAJESACOOECO2,t3.SACOSET2 SOLICITUDARBITRAJESACOSET2,t3.SAINMENCST2 SOLICITUDARBITRAJESAINMENCST2,t3.SAINRENCST2 SOLICITUDARBITRAJESAINRENCST2,t3.SACOSES2 SOLICITUDARBITRAJESACOSES2,t3.SAINMENCSS2 SOLICITUDARBITRAJESAINMENCSS2,t3.SAINRENCSS2 SOLICITUDARBITRAJESAINRENCSS2,t3.SAINMENCT2 SOLICITUDARBITRAJESAINMENCT2,t3.SAINRENCT2 SOLICITUDARBITRAJESAINRENCT2,t3.SAFECIAU2 SOLICITUDARBITRAJESAFECIAU2,t3.SAHRCIAU2 SOLICITUDARBITRAJESAHRCIAU2,t3.SANOLURA2 SOLICITUDARBITRAJESANOLURA2,t3.SANODIRA2 SOLICITUDARBITRAJESANODIRA2,t3.SACOLOA2 SOLICITUDARBITRAJESACOLOA2,t3.SANRCPA2 SOLICITUDARBITRAJESANRCPA2,t3.SAFELAUD SOLICITUDARBITRAJESAFELAUD,t3.SATEOBRE SOLICITUDARBITRAJESATEOBRE,t3.SATEMORE SOLICITUDARBITRAJESATEMORE,t3.SACNEUIL SOLICITUDARBITRAJESACNEUIL,t3.SAINFDLA SOLICITUDARBITRAJESAINFDLA,t3.SAINVOLA SOLICITUDARBITRAJESAINVOLA,t3.SAINARNL SOLICITUDARBITRAJESAINARNL,t3.SACOT7 SOLICITUDARBITRAJESACOT7,t3.SAFENOLT SOLICITUDARBITRAJESAFENOLT,t3.SAINMELT SOLICITUDARBITRAJESAINMELT,t3.SAINPUBO SOLICITUDARBITRAJESAINPUBO,t3.SACOTA1 SOLICITUDARBITRAJESACOTA1,t3.SAFESERA SOLICITUDARBITRAJESAFESERA,t3.SAINFDRA SOLICITUDARBITRAJESAINFDRA,t3.SAFEPEEX SOLICITUDARBITRAJESAFEPEEX,t3.SAINRAIN SOLICITUDARBITRAJESAINRAIN,t3.SAINEFIN SOLICITUDARBITRAJESAINEFIN,t3.SAFEINEF SOLICITUDARBITRAJESAFEINEF,t3.SAFEAR SOLICITUDARBITRAJESAFEAR,t3.SAFENODE SOLICITUDARBITRAJESAFENODE,t3.SAFERELT SOLICITUDARBITRAJESAFERELT,t3.SAFENOCA SOLICITUDARBITRAJESAFENOCA,t3.SAFENOCA2 SOLICITUDARBITRAJESAFENOCA2,t3.SAFENOAR SOLICITUDARBITRAJESAFENOAR,t3.SACOCCCOS SOLICITUDARBITRAJESACOCCCOS,t3.SACOCCCO2S SOLICITUDARBITRAJESACOCCCO2S,t3.SACOOECOS SOLICITUDARBITRAJESACOOECOS,t3.SACOOECO2S SOLICITUDARBITRAJESACOOECO2S,t3.SAFESOAC SOLICITUDARBITRAJESAFESOAC,t3.SAFEENAC SOLICITUDARBITRAJESAFEENAC,t3.SAFENOAC SOLICITUDARBITRAJESAFENOAC,t3.SATEFPR1 SOLICITUDARBITRAJESATEFPR1,t3.SATEFPR2 SOLICITUDARBITRAJESATEFPR2,t3.SAFEFPR1 SOLICITUDARBITRAJESAFEFPR1,t3.SAFEFPR2 SOLICITUDARBITRAJESAFEFPR2,t3.SANRBOPL SOLICITUDARBITRAJESANRBOPL,t3.SAFEENIN SOLICITUDARBITRAJESAFEENIN,t3.SACOTMD SOLICITUDARBITRAJESACOTMD,t3.SAFEOPPE SOLICITUDARBITRAJESAFEOPPE,t3.SAFEOPLA SOLICITUDARBITRAJESAFEOPLA,t3.SAFERECO SOLICITUDARBITRAJESAFERECO,t3.SAFENOLA SOLICITUDARBITRAJESAFENOLA,t3.SAFENONA SOLICITUDARBITRAJESAFENONA,t3.SAFERENA SOLICITUDARBITRAJESAFERENA,t3.SAFECONA SOLICITUDARBITRAJESAFECONA,t3.SAPUB SOLICITUDARBITRAJESAPUB,t3.SAINTICA SOLICITUDARBITRAJESAINTICA,t3.SACOTIR SOLICITUDARBITRAJESACOTIR,t3.SACOPS SOLICITUDARBITRAJESACOPS,t2.HDCODE HECHODENUNCIADOHDCODE,t2.HDCOES HECHODENUNCIADOHDCOES,t2.HDCOSE HECHODENUNCIADOHDCOSE,t2.HDCOMO HECHODENUNCIADOHDCOMO,t2.HDCOPS HECHODENUNCIADOHDCOPS,t2.HDCOTSR HECHODENUNCIADOHDCOTSR,t2.HDCOTIR HECHODENUNCIADOHDCOTIR,t3.SACOHD SOLICITUDARBITRAJESACOHD,t3.SACOSAAC SOLICITUDARBITRAJESACOSAAC "
						+ "FROM SOLICITUD_ARBITRAJE t1 ,HECHO_DENUNCIADO t2 ,SOLICITUD_ARBITRAJE t3 ");

		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacodigo() != null) {
			where.append(" AND t1.SACODIGO = ?");
			params.add(solicitudarbitraje.getSacodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t2.HDCODIGO = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getDenuncia() != null
				&& solicitudarbitraje.getHechoDenunciado().getDenuncia()
						.getDecodigo() != null) {
			where.append(" AND t2.HDCODE = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getDenuncia()
					.getDecodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getEstablecimiento() != null
				&& solicitudarbitraje.getHechoDenunciado().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND t2.HDCOES = ?");
			params.add(solicitudarbitraje.getHechoDenunciado()
					.getEstablecimiento().getEscodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getSector() != null
				&& solicitudarbitraje.getHechoDenunciado().getSector()
						.getSecodigo() != null) {
			where.append(" AND t2.HDCOSE = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getSector()
					.getSecodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getCensoMonitor() != null
				&& solicitudarbitraje.getHechoDenunciado().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t2.HDCOMO = ?");
			params.add(solicitudarbitraje.getHechoDenunciado()
					.getCensoMonitor().getMocodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getProducto() != null
				&& solicitudarbitraje.getHechoDenunciado().getProducto()
						.getPscodigo() != null) {
			where.append(" AND t2.HDCOPS = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getProducto()
					.getPscodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getTipoReclamacion() != null
				&& solicitudarbitraje.getHechoDenunciado().getTipoReclamacion()
						.getTsrcodigo() != null) {
			where.append(" AND t2.HDCOTSR = ?");
			params.add(solicitudarbitraje.getHechoDenunciado()
					.getTipoReclamacion().getTsrcodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getMotivo() != null
				&& solicitudarbitraje.getHechoDenunciado().getMotivo()
						.getTircodigo() != null) {
			where.append(" AND t2.HDCOTIR = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getMotivo()
					.getTircodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t2.HDNROR = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnror());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte() != null) {
			where.append(" AND t2.HDTE = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND t2.HDTEDOAD = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdtedoad());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND t2.HDCOAV = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcoav());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND t2.HDNOPS = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnops());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND t2.HDNOMAPS = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnomaps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND t2.HDNOMOPS = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnomops());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND t2.HDNRLOPS = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnrlops());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t2.HDFEDMPS = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfedmps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND t2.HDINSOTR = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdinsotr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND t2.HDINSOMA = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdinsoma());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t2.HDCAPTSO = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcaptso());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND t2.HDTESO = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdteso());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t2.HDFEARDT = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeardt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t2.HDFEIOHD = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeiohd());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND t2.HDINININ = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdininin());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t2.HDFEIOPC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeiopc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t2.HDFEROPC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdferopc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND t2.HDCOREPC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcorepc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t2.HDFEIORP = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeiorp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t2.HDFERORP = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdferorp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND t2.HDCOREAP = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcoreap());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t2.HDFEIORA = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeiora());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND t2.HDTEACPA = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdteacpa());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t2.HDFECEAC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeceac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND t2.HDHOCEAC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdhoceac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t2.HDFEIOCA = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeioca());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND t2.HDTEACDE = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdteacde());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t2.HDFEIOAC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeioac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t2.HDFEIOFC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeiofc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND t2.HDCOTRA = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcotra());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND t2.HDTE02 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte02());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND t2.HDTE03 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte03());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND t2.HDTE04 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte04());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND t2.HDTE05 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte05());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND t2.HDTE06 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte06());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND t2.HDTE07 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte07());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND t2.HDTE08 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte08());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND t2.HDTE09 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte09());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND t2.HDTE10 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte10());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND t2.HDCOSC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcosc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND t2.HDIDAL = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdidal());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t2.HDFEROAD = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdferoad());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t2.HDFEROAT = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdferoat());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND t2.HDTEALDT = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdtealdt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND t2.HDTEDEAT = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdtedeat());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t2.HDFEDEAT = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfedeat());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t2.HDFEHD = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfehd());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND t2.HDTEDOADE = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdtedoade());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND t2.HDTEDOADI = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdtedoadi());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND t2.HDTEDOADF = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdtedoadf());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND t2.HDTEDOADA = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdtedoada());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND t2.HDNOPSE = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnopse());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND t2.HDNOPSI = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnopsi());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND t2.HDNOPSF = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnopsf());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND t2.HDNOPSA = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnopsa());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND t2.HDCOCODIGO = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcocodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacodigo() != null) {
			where.append(" AND t3.SACODIGO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje()
						.getHechoDenunciado() != null
				&& solicitudarbitraje.getSolicitudArbitraje()
						.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t3.SACOHD = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getHechoDenunciado().getHdcodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje()
						.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje()
						.getSolicitudArbitraje().getSacodigo() != null) {
			where.append(" AND t3.SACOSAAC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSolicitudArbitraje().getSacodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoja() != null) {
			where.append(" AND t3.SACOJA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoja());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanror() != null) {
			where.append(" AND t3.SANROR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanror());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanran() != null) {
			where.append(" AND t3.SANRAN = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanran());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafesoli() != null) {
			where.append(" AND t3.SAFESOLI = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafesoli());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacot4() != null) {
			where.append(" AND t3.SACOT4 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacot4());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoxj() != null) {
			where.append(" AND t3.SACOXJ = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoxj());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanodidc() != null) {
			where.append(" AND t3.SANODIDC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanodidc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacolodc() != null) {
			where.append(" AND t3.SACOLODC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacolodc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanolodc() != null) {
			where.append(" AND t3.SANOLODC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanolodc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacopvdc() != null) {
			where.append(" AND t3.SACOPVDC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacopvdc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacomudc() != null) {
			where.append(" AND t3.SACOMUDC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacomudc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrcpdc() != null) {
			where.append(" AND t3.SANRCPDC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanrcpdc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainacuo() != null) {
			where.append(" AND t3.SAINACUO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainacuo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoorpr() != null) {
			where.append(" AND t3.SACOORPR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoorpr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacosere() != null) {
			where.append(" AND t3.SACOSERE = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacosere());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacotti() != null) {
			where.append(" AND t3.SACOTTI = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacotti());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaintiso() != null) {
			where.append(" AND t3.SAINTISO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaintiso());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacnrecl() != null) {
			where.append(" AND t3.SACNRECL = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacnrecl());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSateobrc() != null) {
			where.append(" AND t3.SATEOBRC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSateobrc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeinad() != null) {
			where.append(" AND t3.SAFEINAD = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafeinad());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacot5() != null) {
			where.append(" AND t3.SACOT5 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacot5());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSateinad() != null) {
			where.append(" AND t3.SATEINAD = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSateinad());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafereit() != null) {
			where.append(" AND t3.SAFEREIT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafereit());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafetras() != null) {
			where.append(" AND t3.SAFETRAS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafetras());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoortr() != null) {
			where.append(" AND t3.SACOORTR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoortr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferett() != null) {
			where.append(" AND t3.SAFERETT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferett());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferets() != null) {
			where.append(" AND t3.SAFERETS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferets());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafemedi() != null) {
			where.append(" AND t3.SAFEMEDI = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafemedi());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainreme() != null) {
			where.append(" AND t3.SAINREME = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainreme());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferemt() != null) {
			where.append(" AND t3.SAFEREMT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferemt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafedesi() != null) {
			where.append(" AND t3.SAFEDESI = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafedesi());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferedt() != null) {
			where.append(" AND t3.SAFEREDT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferedt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoco() != null) {
			where.append(" AND t3.SAFENOCO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenoco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferear() != null) {
			where.append(" AND t3.SAFEREAR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferear());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafedeco() != null) {
			where.append(" AND t3.SAFEDECO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafedeco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarpt() != null) {
			where.append(" AND t3.SACOARPT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoarpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencpt() != null) {
			where.append(" AND t3.SAINMENCPT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencpt() != null) {
			where.append(" AND t3.SAINRENCPT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarps() != null) {
			where.append(" AND t3.SACOARPS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoarps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencps() != null) {
			where.append(" AND t3.SAINMENCPS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencps() != null) {
			where.append(" AND t3.SAINRENCPS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoartt() != null) {
			where.append(" AND t3.SACOARTT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoartt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenctt() != null) {
			where.append(" AND t3.SAINMENCTT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmenctt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenctt() != null) {
			where.append(" AND t3.SAINRENCTT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrenctt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarts() != null) {
			where.append(" AND t3.SACOARTS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoarts());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencts() != null) {
			where.append(" AND t3.SAINMENCTS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencts());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencts() != null) {
			where.append(" AND t3.SAINRENCTS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencts());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoccco() != null) {
			where.append(" AND t3.SACOCCCO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoccco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoardt() != null) {
			where.append(" AND t3.SACOARDT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoardt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencdt() != null) {
			where.append(" AND t3.SAINMENCDT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencdt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencdt() != null) {
			where.append(" AND t3.SAINRENCDT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencdt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoards() != null) {
			where.append(" AND t3.SACOARDS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoards());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencds() != null) {
			where.append(" AND t3.SAINMENCDS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencds());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencds() != null) {
			where.append(" AND t3.SAINRENCDS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencds());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacooeco() != null) {
			where.append(" AND t3.SACOOECO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacooeco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoset() != null) {
			where.append(" AND t3.SACOSET = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoset());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencst() != null) {
			where.append(" AND t3.SAINMENCST = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencst());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencst() != null) {
			where.append(" AND t3.SAINRENCST = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencst());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoses() != null) {
			where.append(" AND t3.SACOSES = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoses());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencss() != null) {
			where.append(" AND t3.SAINMENCSS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencss());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencss() != null) {
			where.append(" AND t3.SAINRENCSS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencss());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenct() != null) {
			where.append(" AND t3.SAINMENCT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmenct());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenct() != null) {
			where.append(" AND t3.SAINRENCT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrenct());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeciau() != null) {
			where.append(" AND t3.SAFECIAU = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafeciau());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSahrciau() != null) {
			where.append(" AND t3.SAHRCIAU = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSahrciau());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanolura() != null) {
			where.append(" AND t3.SANOLURA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanolura());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanodira() != null) {
			where.append(" AND t3.SANODIRA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanodira());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoloa() != null) {
			where.append(" AND t3.SACOLOA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoloa());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrcpa() != null) {
			where.append(" AND t3.SANRCPA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanrcpa());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainsopr() != null) {
			where.append(" AND t3.SAINSOPR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainsopr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaininpr() != null) {
			where.append(" AND t3.SAININPR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaininpr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSateobpr() != null) {
			where.append(" AND t3.SATEOBPR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSateobpr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacope1() != null) {
			where.append(" AND t3.SACOPE1 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacope1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacneupr1() != null) {
			where.append(" AND t3.SACNEUPR1 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacneupr1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacope2() != null) {
			where.append(" AND t3.SACOPE2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacope2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacneupr2() != null) {
			where.append(" AND t3.SACNEUPR2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacneupr2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenopr() != null) {
			where.append(" AND t3.SAFENOPR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenopr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenp1() != null) {
			where.append(" AND t3.SAINMENP1 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmenp1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenp1() != null) {
			where.append(" AND t3.SAINRENP1 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrenp1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenp2() != null) {
			where.append(" AND t3.SAINMENP2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmenp2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenp2() != null) {
			where.append(" AND t3.SAINRENP2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrenp2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenpt() != null) {
			where.append(" AND t3.SAINMENPT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmenpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenpt() != null) {
			where.append(" AND t3.SAINRENPT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrenpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanolup() != null) {
			where.append(" AND t3.SANOLUP = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanolup());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanodirp() != null) {
			where.append(" AND t3.SANODIRP = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanodirp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacolop() != null) {
			where.append(" AND t3.SACOLOP = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacolop());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrcopop() != null) {
			where.append(" AND t3.SANRCOPOP = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSanrcopop());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanopvp() != null) {
			where.append(" AND t3.SANOPVP = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanopvp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrtelp() != null) {
			where.append(" AND t3.SANRTELP = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanrtelp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrfaxp() != null) {
			where.append(" AND t3.SANRFAXP = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanrfaxp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferepr() != null) {
			where.append(" AND t3.SAFEREPR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferepr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSahrrepr() != null) {
			where.append(" AND t3.SAHRREPR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSahrrepr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarpt2() != null) {
			where.append(" AND t3.SACOARPT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoarpt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencpt2() != null) {
			where.append(" AND t3.SAINMENCPT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencpt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencpt2() != null) {
			where.append(" AND t3.SAINRENCPT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencpt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarps2() != null) {
			where.append(" AND t3.SACOARPS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoarps2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencps2() != null) {
			where.append(" AND t3.SAINMENCPS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencps2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencps2() != null) {
			where.append(" AND t3.SAINRENCPS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencps2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoartt2() != null) {
			where.append(" AND t3.SACOARTT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoartt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenctt2() != null) {
			where.append(" AND t3.SAINMENCTT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmenctt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenctt2() != null) {
			where.append(" AND t3.SAINRENCTT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrenctt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarts2() != null) {
			where.append(" AND t3.SACOARTS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoarts2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencts2() != null) {
			where.append(" AND t3.SAINMENCTS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencts2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencts2() != null) {
			where.append(" AND t3.SAINRENCTS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencts2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoccco2() != null) {
			where.append(" AND t3.SACOCCCO2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoccco2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoardt2() != null) {
			where.append(" AND t3.SACOARDT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoardt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencdt2() != null) {
			where.append(" AND t3.SAINMENCDT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencdt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencdt2() != null) {
			where.append(" AND t3.SAINRENCDT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencdt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoards2() != null) {
			where.append(" AND t3.SACOARDS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoards2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencds2() != null) {
			where.append(" AND t3.SAINMENCDS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencds2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencds2() != null) {
			where.append(" AND t3.SAINRENCDS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencds2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacooeco2() != null) {
			where.append(" AND t3.SACOOECO2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacooeco2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoset2() != null) {
			where.append(" AND t3.SACOSET2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoset2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencst2() != null) {
			where.append(" AND t3.SAINMENCST2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencst2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencst2() != null) {
			where.append(" AND t3.SAINRENCST2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencst2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoses2() != null) {
			where.append(" AND t3.SACOSES2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoses2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencss2() != null) {
			where.append(" AND t3.SAINMENCSS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencss2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencss2() != null) {
			where.append(" AND t3.SAINRENCSS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencss2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenct2() != null) {
			where.append(" AND t3.SAINMENCT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmenct2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenct2() != null) {
			where.append(" AND t3.SAINRENCT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrenct2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeciau2() != null) {
			where.append(" AND t3.SAFECIAU2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSafeciau2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSahrciau2() != null) {
			where.append(" AND t3.SAHRCIAU2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSahrciau2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanolura2() != null) {
			where.append(" AND t3.SANOLURA2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSanolura2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanodira2() != null) {
			where.append(" AND t3.SANODIRA2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSanodira2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoloa2() != null) {
			where.append(" AND t3.SACOLOA2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoloa2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrcpa2() != null) {
			where.append(" AND t3.SANRCPA2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanrcpa2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafelaud() != null) {
			where.append(" AND t3.SAFELAUD = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafelaud());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSateobre() != null) {
			where.append(" AND t3.SATEOBRE = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSateobre());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSatemore() != null) {
			where.append(" AND t3.SATEMORE = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSatemore());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacneuil() != null) {
			where.append(" AND t3.SACNEUIL = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacneuil());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainfdla() != null) {
			where.append(" AND t3.SAINFDLA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainfdla());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainvola() != null) {
			where.append(" AND t3.SAINVOLA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainvola());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainarnl() != null) {
			where.append(" AND t3.SAINARNL = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainarnl());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacot7() != null) {
			where.append(" AND t3.SACOT7 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacot7());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenolt() != null) {
			where.append(" AND t3.SAFENOLT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenolt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmelt() != null) {
			where.append(" AND t3.SAINMELT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainmelt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainpubo() != null) {
			where.append(" AND t3.SAINPUBO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainpubo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacota1() != null) {
			where.append(" AND t3.SACOTA1 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacota1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafesera() != null) {
			where.append(" AND t3.SAFESERA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafesera());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainfdra() != null) {
			where.append(" AND t3.SAINFDRA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainfdra());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafepeex() != null) {
			where.append(" AND t3.SAFEPEEX = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafepeex());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrain() != null) {
			where.append(" AND t3.SAINRAIN = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainrain());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainefin() != null) {
			where.append(" AND t3.SAINEFIN = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainefin());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeinef() != null) {
			where.append(" AND t3.SAFEINEF = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafeinef());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafear() != null) {
			where.append(" AND t3.SAFEAR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafear());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenode() != null) {
			where.append(" AND t3.SAFENODE = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenode());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferelt() != null) {
			where.append(" AND t3.SAFERELT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferelt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoca() != null) {
			where.append(" AND t3.SAFENOCA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenoca());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoca2() != null) {
			where.append(" AND t3.SAFENOCA2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSafenoca2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoar() != null) {
			where.append(" AND t3.SAFENOAR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenoar());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacocccos() != null) {
			where.append(" AND t3.SACOCCCOS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacocccos());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoccco2s() != null) {
			where.append(" AND t3.SACOCCCO2S = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoccco2s());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacooecos() != null) {
			where.append(" AND t3.SACOOECOS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacooecos());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacooeco2s() != null) {
			where.append(" AND t3.SACOOECO2S = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacooeco2s());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafesoac() != null) {
			where.append(" AND t3.SAFESOAC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafesoac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeenac() != null) {
			where.append(" AND t3.SAFEENAC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafeenac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoac() != null) {
			where.append(" AND t3.SAFENOAC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenoac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSatefpr1() != null) {
			where.append(" AND t3.SATEFPR1 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSatefpr1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSatefpr2() != null) {
			where.append(" AND t3.SATEFPR2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSatefpr2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafefpr1() != null) {
			where.append(" AND t3.SAFEFPR1 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafefpr1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafefpr2() != null) {
			where.append(" AND t3.SAFEFPR2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafefpr2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrbopl() != null) {
			where.append(" AND t3.SANRBOPL = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanrbopl());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeenin() != null) {
			where.append(" AND t3.SAFEENIN = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafeenin());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacotmd() != null) {
			where.append(" AND t3.SACOTMD = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacotmd());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeoppe() != null) {
			where.append(" AND t3.SAFEOPPE = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafeoppe());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeopla() != null) {
			where.append(" AND t3.SAFEOPLA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafeopla());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafereco() != null) {
			where.append(" AND t3.SAFERECO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafereco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenola() != null) {
			where.append(" AND t3.SAFENOLA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenola());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenona() != null) {
			where.append(" AND t3.SAFENONA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenona());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferena() != null) {
			where.append(" AND t3.SAFERENA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferena());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafecona() != null) {
			where.append(" AND t3.SAFECONA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafecona());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSapub() != null) {
			where.append(" AND t3.SAPUB = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSapub());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaintica() != null) {
			where.append(" AND t3.SAINTICA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaintica());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacotir() != null) {
			where.append(" AND t3.SACOTIR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacotir());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacops() != null) {
			where.append(" AND t3.SACOPS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacops());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoja() != null) {
			where.append(" AND t1.SACOJA = ?");
			params.add(solicitudarbitraje.getSacoja());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanror() != null) {
			where.append(" AND t1.SANROR = ?");
			params.add(solicitudarbitraje.getSanror());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanran() != null) {
			where.append(" AND t1.SANRAN = ?");
			params.add(solicitudarbitraje.getSanran());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafesoli() != null) {
			where.append(" AND t1.SAFESOLI = ?");
			params.add(solicitudarbitraje.getSafesoli());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacot4() != null) {
			where.append(" AND t1.SACOT4 = ?");
			params.add(solicitudarbitraje.getSacot4());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoxj() != null) {
			where.append(" AND t1.SACOXJ = ?");
			params.add(solicitudarbitraje.getSacoxj());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanodidc() != null) {
			where.append(" AND t1.SANODIDC = ?");
			params.add(solicitudarbitraje.getSanodidc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacolodc() != null) {
			where.append(" AND t1.SACOLODC = ?");
			params.add(solicitudarbitraje.getSacolodc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanolodc() != null) {
			where.append(" AND t1.SANOLODC = ?");
			params.add(solicitudarbitraje.getSanolodc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacopvdc() != null) {
			where.append(" AND t1.SACOPVDC = ?");
			params.add(solicitudarbitraje.getSacopvdc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacomudc() != null) {
			where.append(" AND t1.SACOMUDC = ?");
			params.add(solicitudarbitraje.getSacomudc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrcpdc() != null) {
			where.append(" AND t1.SANRCPDC = ?");
			params.add(solicitudarbitraje.getSanrcpdc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainacuo() != null) {
			where.append(" AND t1.SAINACUO = ?");
			params.add(solicitudarbitraje.getSainacuo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoorpr() != null) {
			where.append(" AND t1.SACOORPR = ?");
			params.add(solicitudarbitraje.getSacoorpr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacosere() != null) {
			where.append(" AND t1.SACOSERE = ?");
			params.add(solicitudarbitraje.getSacosere());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacotti() != null) {
			where.append(" AND t1.SACOTTI = ?");
			params.add(solicitudarbitraje.getSacotti());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaintiso() != null) {
			where.append(" AND t1.SAINTISO = ?");
			params.add(solicitudarbitraje.getSaintiso());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacnrecl() != null) {
			where.append(" AND t1.SACNRECL = ?");
			params.add(solicitudarbitraje.getSacnrecl());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSateobrc() != null) {
			where.append(" AND t1.SATEOBRC = ?");
			params.add(solicitudarbitraje.getSateobrc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeinad() != null) {
			where.append(" AND t1.SAFEINAD = ?");
			params.add(solicitudarbitraje.getSafeinad());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacot5() != null) {
			where.append(" AND t1.SACOT5 = ?");
			params.add(solicitudarbitraje.getSacot5());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSateinad() != null) {
			where.append(" AND t1.SATEINAD = ?");
			params.add(solicitudarbitraje.getSateinad());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafereit() != null) {
			where.append(" AND t1.SAFEREIT = ?");
			params.add(solicitudarbitraje.getSafereit());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafetras() != null) {
			where.append(" AND t1.SAFETRAS = ?");
			params.add(solicitudarbitraje.getSafetras());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoortr() != null) {
			where.append(" AND t1.SACOORTR = ?");
			params.add(solicitudarbitraje.getSacoortr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferett() != null) {
			where.append(" AND t1.SAFERETT = ?");
			params.add(solicitudarbitraje.getSaferett());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferets() != null) {
			where.append(" AND t1.SAFERETS = ?");
			params.add(solicitudarbitraje.getSaferets());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafemedi() != null) {
			where.append(" AND t1.SAFEMEDI = ?");
			params.add(solicitudarbitraje.getSafemedi());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainreme() != null) {
			where.append(" AND t1.SAINREME = ?");
			params.add(solicitudarbitraje.getSainreme());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferemt() != null) {
			where.append(" AND t1.SAFEREMT = ?");
			params.add(solicitudarbitraje.getSaferemt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafedesi() != null) {
			where.append(" AND t1.SAFEDESI = ?");
			params.add(solicitudarbitraje.getSafedesi());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferedt() != null) {
			where.append(" AND t1.SAFEREDT = ?");
			params.add(solicitudarbitraje.getSaferedt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoco() != null) {
			where.append(" AND t1.SAFENOCO = ?");
			params.add(solicitudarbitraje.getSafenoco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferear() != null) {
			where.append(" AND t1.SAFEREAR = ?");
			params.add(solicitudarbitraje.getSaferear());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafedeco() != null) {
			where.append(" AND t1.SAFEDECO = ?");
			params.add(solicitudarbitraje.getSafedeco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarpt() != null) {
			where.append(" AND t1.SACOARPT = ?");
			params.add(solicitudarbitraje.getSacoarpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencpt() != null) {
			where.append(" AND t1.SAINMENCPT = ?");
			params.add(solicitudarbitraje.getSainmencpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencpt() != null) {
			where.append(" AND t1.SAINRENCPT = ?");
			params.add(solicitudarbitraje.getSainrencpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarps() != null) {
			where.append(" AND t1.SACOARPS = ?");
			params.add(solicitudarbitraje.getSacoarps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencps() != null) {
			where.append(" AND t1.SAINMENCPS = ?");
			params.add(solicitudarbitraje.getSainmencps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencps() != null) {
			where.append(" AND t1.SAINRENCPS = ?");
			params.add(solicitudarbitraje.getSainrencps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoartt() != null) {
			where.append(" AND t1.SACOARTT = ?");
			params.add(solicitudarbitraje.getSacoartt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenctt() != null) {
			where.append(" AND t1.SAINMENCTT = ?");
			params.add(solicitudarbitraje.getSainmenctt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenctt() != null) {
			where.append(" AND t1.SAINRENCTT = ?");
			params.add(solicitudarbitraje.getSainrenctt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarts() != null) {
			where.append(" AND t1.SACOARTS = ?");
			params.add(solicitudarbitraje.getSacoarts());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencts() != null) {
			where.append(" AND t1.SAINMENCTS = ?");
			params.add(solicitudarbitraje.getSainmencts());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencts() != null) {
			where.append(" AND t1.SAINRENCTS = ?");
			params.add(solicitudarbitraje.getSainrencts());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoccco() != null) {
			where.append(" AND t1.SACOCCCO = ?");
			params.add(solicitudarbitraje.getSacoccco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoardt() != null) {
			where.append(" AND t1.SACOARDT = ?");
			params.add(solicitudarbitraje.getSacoardt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencdt() != null) {
			where.append(" AND t1.SAINMENCDT = ?");
			params.add(solicitudarbitraje.getSainmencdt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencdt() != null) {
			where.append(" AND t1.SAINRENCDT = ?");
			params.add(solicitudarbitraje.getSainrencdt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoards() != null) {
			where.append(" AND t1.SACOARDS = ?");
			params.add(solicitudarbitraje.getSacoards());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencds() != null) {
			where.append(" AND t1.SAINMENCDS = ?");
			params.add(solicitudarbitraje.getSainmencds());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencds() != null) {
			where.append(" AND t1.SAINRENCDS = ?");
			params.add(solicitudarbitraje.getSainrencds());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacooeco() != null) {
			where.append(" AND t1.SACOOECO = ?");
			params.add(solicitudarbitraje.getSacooeco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoset() != null) {
			where.append(" AND t1.SACOSET = ?");
			params.add(solicitudarbitraje.getSacoset());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencst() != null) {
			where.append(" AND t1.SAINMENCST = ?");
			params.add(solicitudarbitraje.getSainmencst());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencst() != null) {
			where.append(" AND t1.SAINRENCST = ?");
			params.add(solicitudarbitraje.getSainrencst());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoses() != null) {
			where.append(" AND t1.SACOSES = ?");
			params.add(solicitudarbitraje.getSacoses());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencss() != null) {
			where.append(" AND t1.SAINMENCSS = ?");
			params.add(solicitudarbitraje.getSainmencss());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencss() != null) {
			where.append(" AND t1.SAINRENCSS = ?");
			params.add(solicitudarbitraje.getSainrencss());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenct() != null) {
			where.append(" AND t1.SAINMENCT = ?");
			params.add(solicitudarbitraje.getSainmenct());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenct() != null) {
			where.append(" AND t1.SAINRENCT = ?");
			params.add(solicitudarbitraje.getSainrenct());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeciau() != null) {
			where.append(" AND t1.SAFECIAU = ?");
			params.add(solicitudarbitraje.getSafeciau());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSahrciau() != null) {
			where.append(" AND t1.SAHRCIAU = ?");
			params.add(solicitudarbitraje.getSahrciau());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanolura() != null) {
			where.append(" AND t1.SANOLURA = ?");
			params.add(solicitudarbitraje.getSanolura());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanodira() != null) {
			where.append(" AND t1.SANODIRA = ?");
			params.add(solicitudarbitraje.getSanodira());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoloa() != null) {
			where.append(" AND t1.SACOLOA = ?");
			params.add(solicitudarbitraje.getSacoloa());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrcpa() != null) {
			where.append(" AND t1.SANRCPA = ?");
			params.add(solicitudarbitraje.getSanrcpa());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainsopr() != null) {
			where.append(" AND t1.SAINSOPR = ?");
			params.add(solicitudarbitraje.getSainsopr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaininpr() != null) {
			where.append(" AND t1.SAININPR = ?");
			params.add(solicitudarbitraje.getSaininpr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSateobpr() != null) {
			where.append(" AND t1.SATEOBPR = ?");
			params.add(solicitudarbitraje.getSateobpr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacope1() != null) {
			where.append(" AND t1.SACOPE1 = ?");
			params.add(solicitudarbitraje.getSacope1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacneupr1() != null) {
			where.append(" AND t1.SACNEUPR1 = ?");
			params.add(solicitudarbitraje.getSacneupr1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacope2() != null) {
			where.append(" AND t1.SACOPE2 = ?");
			params.add(solicitudarbitraje.getSacope2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacneupr2() != null) {
			where.append(" AND t1.SACNEUPR2 = ?");
			params.add(solicitudarbitraje.getSacneupr2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenopr() != null) {
			where.append(" AND t1.SAFENOPR = ?");
			params.add(solicitudarbitraje.getSafenopr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenp1() != null) {
			where.append(" AND t1.SAINMENP1 = ?");
			params.add(solicitudarbitraje.getSainmenp1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenp1() != null) {
			where.append(" AND t1.SAINRENP1 = ?");
			params.add(solicitudarbitraje.getSainrenp1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenp2() != null) {
			where.append(" AND t1.SAINMENP2 = ?");
			params.add(solicitudarbitraje.getSainmenp2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenp2() != null) {
			where.append(" AND t1.SAINRENP2 = ?");
			params.add(solicitudarbitraje.getSainrenp2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenpt() != null) {
			where.append(" AND t1.SAINMENPT = ?");
			params.add(solicitudarbitraje.getSainmenpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenpt() != null) {
			where.append(" AND t1.SAINRENPT = ?");
			params.add(solicitudarbitraje.getSainrenpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanolup() != null) {
			where.append(" AND t1.SANOLUP = ?");
			params.add(solicitudarbitraje.getSanolup());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanodirp() != null) {
			where.append(" AND t1.SANODIRP = ?");
			params.add(solicitudarbitraje.getSanodirp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacolop() != null) {
			where.append(" AND t1.SACOLOP = ?");
			params.add(solicitudarbitraje.getSacolop());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrcopop() != null) {
			where.append(" AND t1.SANRCOPOP = ?");
			params.add(solicitudarbitraje.getSanrcopop());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanopvp() != null) {
			where.append(" AND t1.SANOPVP = ?");
			params.add(solicitudarbitraje.getSanopvp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrtelp() != null) {
			where.append(" AND t1.SANRTELP = ?");
			params.add(solicitudarbitraje.getSanrtelp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrfaxp() != null) {
			where.append(" AND t1.SANRFAXP = ?");
			params.add(solicitudarbitraje.getSanrfaxp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferepr() != null) {
			where.append(" AND t1.SAFEREPR = ?");
			params.add(solicitudarbitraje.getSaferepr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSahrrepr() != null) {
			where.append(" AND t1.SAHRREPR = ?");
			params.add(solicitudarbitraje.getSahrrepr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarpt2() != null) {
			where.append(" AND t1.SACOARPT2 = ?");
			params.add(solicitudarbitraje.getSacoarpt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencpt2() != null) {
			where.append(" AND t1.SAINMENCPT2 = ?");
			params.add(solicitudarbitraje.getSainmencpt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencpt2() != null) {
			where.append(" AND t1.SAINRENCPT2 = ?");
			params.add(solicitudarbitraje.getSainrencpt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarps2() != null) {
			where.append(" AND t1.SACOARPS2 = ?");
			params.add(solicitudarbitraje.getSacoarps2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencps2() != null) {
			where.append(" AND t1.SAINMENCPS2 = ?");
			params.add(solicitudarbitraje.getSainmencps2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencps2() != null) {
			where.append(" AND t1.SAINRENCPS2 = ?");
			params.add(solicitudarbitraje.getSainrencps2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoartt2() != null) {
			where.append(" AND t1.SACOARTT2 = ?");
			params.add(solicitudarbitraje.getSacoartt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenctt2() != null) {
			where.append(" AND t1.SAINMENCTT2 = ?");
			params.add(solicitudarbitraje.getSainmenctt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenctt2() != null) {
			where.append(" AND t1.SAINRENCTT2 = ?");
			params.add(solicitudarbitraje.getSainrenctt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarts2() != null) {
			where.append(" AND t1.SACOARTS2 = ?");
			params.add(solicitudarbitraje.getSacoarts2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencts2() != null) {
			where.append(" AND t1.SAINMENCTS2 = ?");
			params.add(solicitudarbitraje.getSainmencts2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencts2() != null) {
			where.append(" AND t1.SAINRENCTS2 = ?");
			params.add(solicitudarbitraje.getSainrencts2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoccco2() != null) {
			where.append(" AND t1.SACOCCCO2 = ?");
			params.add(solicitudarbitraje.getSacoccco2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoardt2() != null) {
			where.append(" AND t1.SACOARDT2 = ?");
			params.add(solicitudarbitraje.getSacoardt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencdt2() != null) {
			where.append(" AND t1.SAINMENCDT2 = ?");
			params.add(solicitudarbitraje.getSainmencdt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencdt2() != null) {
			where.append(" AND t1.SAINRENCDT2 = ?");
			params.add(solicitudarbitraje.getSainrencdt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoards2() != null) {
			where.append(" AND t1.SACOARDS2 = ?");
			params.add(solicitudarbitraje.getSacoards2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencds2() != null) {
			where.append(" AND t1.SAINMENCDS2 = ?");
			params.add(solicitudarbitraje.getSainmencds2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencds2() != null) {
			where.append(" AND t1.SAINRENCDS2 = ?");
			params.add(solicitudarbitraje.getSainrencds2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacooeco2() != null) {
			where.append(" AND t1.SACOOECO2 = ?");
			params.add(solicitudarbitraje.getSacooeco2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoset2() != null) {
			where.append(" AND t1.SACOSET2 = ?");
			params.add(solicitudarbitraje.getSacoset2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencst2() != null) {
			where.append(" AND t1.SAINMENCST2 = ?");
			params.add(solicitudarbitraje.getSainmencst2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencst2() != null) {
			where.append(" AND t1.SAINRENCST2 = ?");
			params.add(solicitudarbitraje.getSainrencst2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoses2() != null) {
			where.append(" AND t1.SACOSES2 = ?");
			params.add(solicitudarbitraje.getSacoses2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencss2() != null) {
			where.append(" AND t1.SAINMENCSS2 = ?");
			params.add(solicitudarbitraje.getSainmencss2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencss2() != null) {
			where.append(" AND t1.SAINRENCSS2 = ?");
			params.add(solicitudarbitraje.getSainrencss2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenct2() != null) {
			where.append(" AND t1.SAINMENCT2 = ?");
			params.add(solicitudarbitraje.getSainmenct2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenct2() != null) {
			where.append(" AND t1.SAINRENCT2 = ?");
			params.add(solicitudarbitraje.getSainrenct2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeciau2() != null) {
			where.append(" AND t1.SAFECIAU2 = ?");
			params.add(solicitudarbitraje.getSafeciau2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSahrciau2() != null) {
			where.append(" AND t1.SAHRCIAU2 = ?");
			params.add(solicitudarbitraje.getSahrciau2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanolura2() != null) {
			where.append(" AND t1.SANOLURA2 = ?");
			params.add(solicitudarbitraje.getSanolura2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanodira2() != null) {
			where.append(" AND t1.SANODIRA2 = ?");
			params.add(solicitudarbitraje.getSanodira2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoloa2() != null) {
			where.append(" AND t1.SACOLOA2 = ?");
			params.add(solicitudarbitraje.getSacoloa2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrcpa2() != null) {
			where.append(" AND t1.SANRCPA2 = ?");
			params.add(solicitudarbitraje.getSanrcpa2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafelaud() != null) {
			where.append(" AND t1.SAFELAUD = ?");
			params.add(solicitudarbitraje.getSafelaud());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSateobre() != null) {
			where.append(" AND t1.SATEOBRE = ?");
			params.add(solicitudarbitraje.getSateobre());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSatemore() != null) {
			where.append(" AND t1.SATEMORE = ?");
			params.add(solicitudarbitraje.getSatemore());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacneuil() != null) {
			where.append(" AND t1.SACNEUIL = ?");
			params.add(solicitudarbitraje.getSacneuil());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainfdla() != null) {
			where.append(" AND t1.SAINFDLA = ?");
			params.add(solicitudarbitraje.getSainfdla());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainvola() != null) {
			where.append(" AND t1.SAINVOLA = ?");
			params.add(solicitudarbitraje.getSainvola());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainarnl() != null) {
			where.append(" AND t1.SAINARNL = ?");
			params.add(solicitudarbitraje.getSainarnl());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacot7() != null) {
			where.append(" AND t1.SACOT7 = ?");
			params.add(solicitudarbitraje.getSacot7());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenolt() != null) {
			where.append(" AND t1.SAFENOLT = ?");
			params.add(solicitudarbitraje.getSafenolt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmelt() != null) {
			where.append(" AND t1.SAINMELT = ?");
			params.add(solicitudarbitraje.getSainmelt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainpubo() != null) {
			where.append(" AND t1.SAINPUBO = ?");
			params.add(solicitudarbitraje.getSainpubo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacota1() != null) {
			where.append(" AND t1.SACOTA1 = ?");
			params.add(solicitudarbitraje.getSacota1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafesera() != null) {
			where.append(" AND t1.SAFESERA = ?");
			params.add(solicitudarbitraje.getSafesera());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainfdra() != null) {
			where.append(" AND t1.SAINFDRA = ?");
			params.add(solicitudarbitraje.getSainfdra());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafepeex() != null) {
			where.append(" AND t1.SAFEPEEX = ?");
			params.add(solicitudarbitraje.getSafepeex());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrain() != null) {
			where.append(" AND t1.SAINRAIN = ?");
			params.add(solicitudarbitraje.getSainrain());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainefin() != null) {
			where.append(" AND t1.SAINEFIN = ?");
			params.add(solicitudarbitraje.getSainefin());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeinef() != null) {
			where.append(" AND t1.SAFEINEF = ?");
			params.add(solicitudarbitraje.getSafeinef());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafear() != null) {
			where.append(" AND t1.SAFEAR = ?");
			params.add(solicitudarbitraje.getSafear());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenode() != null) {
			where.append(" AND t1.SAFENODE = ?");
			params.add(solicitudarbitraje.getSafenode());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferelt() != null) {
			where.append(" AND t1.SAFERELT = ?");
			params.add(solicitudarbitraje.getSaferelt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoca() != null) {
			where.append(" AND t1.SAFENOCA = ?");
			params.add(solicitudarbitraje.getSafenoca());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoca2() != null) {
			where.append(" AND t1.SAFENOCA2 = ?");
			params.add(solicitudarbitraje.getSafenoca2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoar() != null) {
			where.append(" AND t1.SAFENOAR = ?");
			params.add(solicitudarbitraje.getSafenoar());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacocccos() != null) {
			where.append(" AND t1.SACOCCCOS = ?");
			params.add(solicitudarbitraje.getSacocccos());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoccco2s() != null) {
			where.append(" AND t1.SACOCCCO2S = ?");
			params.add(solicitudarbitraje.getSacoccco2s());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacooecos() != null) {
			where.append(" AND t1.SACOOECOS = ?");
			params.add(solicitudarbitraje.getSacooecos());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacooeco2s() != null) {
			where.append(" AND t1.SACOOECO2S = ?");
			params.add(solicitudarbitraje.getSacooeco2s());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafesoac() != null) {
			where.append(" AND t1.SAFESOAC = ?");
			params.add(solicitudarbitraje.getSafesoac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeenac() != null) {
			where.append(" AND t1.SAFEENAC = ?");
			params.add(solicitudarbitraje.getSafeenac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoac() != null) {
			where.append(" AND t1.SAFENOAC = ?");
			params.add(solicitudarbitraje.getSafenoac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSatefpr1() != null) {
			where.append(" AND t1.SATEFPR1 = ?");
			params.add(solicitudarbitraje.getSatefpr1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSatefpr2() != null) {
			where.append(" AND t1.SATEFPR2 = ?");
			params.add(solicitudarbitraje.getSatefpr2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafefpr1() != null) {
			where.append(" AND t1.SAFEFPR1 = ?");
			params.add(solicitudarbitraje.getSafefpr1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafefpr2() != null) {
			where.append(" AND t1.SAFEFPR2 = ?");
			params.add(solicitudarbitraje.getSafefpr2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrbopl() != null) {
			where.append(" AND t1.SANRBOPL = ?");
			params.add(solicitudarbitraje.getSanrbopl());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeenin() != null) {
			where.append(" AND t1.SAFEENIN = ?");
			params.add(solicitudarbitraje.getSafeenin());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacotmd() != null) {
			where.append(" AND t1.SACOTMD = ?");
			params.add(solicitudarbitraje.getSacotmd());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeoppe() != null) {
			where.append(" AND t1.SAFEOPPE = ?");
			params.add(solicitudarbitraje.getSafeoppe());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeopla() != null) {
			where.append(" AND t1.SAFEOPLA = ?");
			params.add(solicitudarbitraje.getSafeopla());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafereco() != null) {
			where.append(" AND t1.SAFERECO = ?");
			params.add(solicitudarbitraje.getSafereco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenola() != null) {
			where.append(" AND t1.SAFENOLA = ?");
			params.add(solicitudarbitraje.getSafenola());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenona() != null) {
			where.append(" AND t1.SAFENONA = ?");
			params.add(solicitudarbitraje.getSafenona());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferena() != null) {
			where.append(" AND t1.SAFERENA = ?");
			params.add(solicitudarbitraje.getSaferena());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafecona() != null) {
			where.append(" AND t1.SAFECONA = ?");
			params.add(solicitudarbitraje.getSafecona());
		}
		if (solicitudarbitraje != null && solicitudarbitraje.getSapub() != null) {
			where.append(" AND t1.SAPUB = ?");
			params.add(solicitudarbitraje.getSapub());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaintica() != null) {
			where.append(" AND t1.SAINTICA = ?");
			params.add(solicitudarbitraje.getSaintica());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacotir() != null) {
			where.append(" AND t1.SACOTIR = ?");
			params.add(solicitudarbitraje.getSacotir());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacops() != null) {
			where.append(" AND t1.SACOPS = ?");
			params.add(solicitudarbitraje.getSacops());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<SolicitudArbitraje>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the SolicitudArbitraje table.
	 * 
	 * @param solicitudarbitraje
	 *            SolicitudArbitraje
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(SolicitudArbitraje solicitudarbitraje) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.SACOHD= t2.HDCODIGO(+) and t1.SACOSAAC= t3.SACODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  SOLICITUD_ARBITRAJE t1   ,  HECHO_DENUNCIADO t2   ,  SOLICITUD_ARBITRAJE t3  ");
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacodigo() != null) {
			where.append(" AND t1.SACODIGO = ?");
			params.add(solicitudarbitraje.getSacodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t2.HDCODIGO = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getDenuncia() != null
				&& solicitudarbitraje.getHechoDenunciado().getDenuncia()
						.getDecodigo() != null) {
			where.append(" AND t2.HDCODE = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getDenuncia()
					.getDecodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getEstablecimiento() != null
				&& solicitudarbitraje.getHechoDenunciado().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND t2.HDCOES = ?");
			params.add(solicitudarbitraje.getHechoDenunciado()
					.getEstablecimiento().getEscodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getSector() != null
				&& solicitudarbitraje.getHechoDenunciado().getSector()
						.getSecodigo() != null) {
			where.append(" AND t2.HDCOSE = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getSector()
					.getSecodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getCensoMonitor() != null
				&& solicitudarbitraje.getHechoDenunciado().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t2.HDCOMO = ?");
			params.add(solicitudarbitraje.getHechoDenunciado()
					.getCensoMonitor().getMocodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getProducto() != null
				&& solicitudarbitraje.getHechoDenunciado().getProducto()
						.getPscodigo() != null) {
			where.append(" AND t2.HDCOPS = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getProducto()
					.getPscodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getTipoReclamacion() != null
				&& solicitudarbitraje.getHechoDenunciado().getTipoReclamacion()
						.getTsrcodigo() != null) {
			where.append(" AND t2.HDCOTSR = ?");
			params.add(solicitudarbitraje.getHechoDenunciado()
					.getTipoReclamacion().getTsrcodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getMotivo() != null
				&& solicitudarbitraje.getHechoDenunciado().getMotivo()
						.getTircodigo() != null) {
			where.append(" AND t2.HDCOTIR = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getMotivo()
					.getTircodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t2.HDNROR = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnror());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte() != null) {
			where.append(" AND t2.HDTE = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND t2.HDTEDOAD = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdtedoad());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND t2.HDCOAV = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcoav());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND t2.HDNOPS = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnops());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND t2.HDNOMAPS = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnomaps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND t2.HDNOMOPS = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnomops());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND t2.HDNRLOPS = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnrlops());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t2.HDFEDMPS = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfedmps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND t2.HDINSOTR = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdinsotr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND t2.HDINSOMA = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdinsoma());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t2.HDCAPTSO = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcaptso());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND t2.HDTESO = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdteso());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t2.HDFEARDT = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeardt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t2.HDFEIOHD = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeiohd());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND t2.HDINININ = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdininin());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t2.HDFEIOPC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeiopc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t2.HDFEROPC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdferopc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND t2.HDCOREPC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcorepc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t2.HDFEIORP = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeiorp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t2.HDFERORP = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdferorp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND t2.HDCOREAP = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcoreap());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t2.HDFEIORA = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeiora());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND t2.HDTEACPA = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdteacpa());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t2.HDFECEAC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeceac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND t2.HDHOCEAC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdhoceac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t2.HDFEIOCA = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeioca());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND t2.HDTEACDE = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdteacde());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t2.HDFEIOAC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeioac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t2.HDFEIOFC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfeiofc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND t2.HDCOTRA = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcotra());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND t2.HDTE02 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte02());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND t2.HDTE03 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte03());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND t2.HDTE04 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte04());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND t2.HDTE05 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte05());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND t2.HDTE06 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte06());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND t2.HDTE07 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte07());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND t2.HDTE08 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte08());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND t2.HDTE09 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte09());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND t2.HDTE10 = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdte10());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND t2.HDCOSC = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcosc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND t2.HDIDAL = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdidal());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t2.HDFEROAD = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdferoad());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t2.HDFEROAT = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdferoat());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND t2.HDTEALDT = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdtealdt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND t2.HDTEDEAT = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdtedeat());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t2.HDFEDEAT = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfedeat());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t2.HDFEHD = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdfehd());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND t2.HDTEDOADE = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdtedoade());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND t2.HDTEDOADI = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdtedoadi());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND t2.HDTEDOADF = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdtedoadf());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND t2.HDTEDOADA = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdtedoada());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND t2.HDNOPSE = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnopse());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND t2.HDNOPSI = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnopsi());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND t2.HDNOPSF = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnopsf());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND t2.HDNOPSA = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdnopsa());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND t2.HDCOCODIGO = ?");
			params.add(solicitudarbitraje.getHechoDenunciado().getHdcocodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacodigo() != null) {
			where.append(" AND t3.SACODIGO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje()
						.getHechoDenunciado() != null
				&& solicitudarbitraje.getSolicitudArbitraje()
						.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t3.SACOHD = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getHechoDenunciado().getHdcodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje()
						.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje()
						.getSolicitudArbitraje().getSacodigo() != null) {
			where.append(" AND t3.SACOSAAC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSolicitudArbitraje().getSacodigo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoja() != null) {
			where.append(" AND t3.SACOJA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoja());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanror() != null) {
			where.append(" AND t3.SANROR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanror());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanran() != null) {
			where.append(" AND t3.SANRAN = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanran());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafesoli() != null) {
			where.append(" AND t3.SAFESOLI = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafesoli());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacot4() != null) {
			where.append(" AND t3.SACOT4 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacot4());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoxj() != null) {
			where.append(" AND t3.SACOXJ = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoxj());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanodidc() != null) {
			where.append(" AND t3.SANODIDC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanodidc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacolodc() != null) {
			where.append(" AND t3.SACOLODC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacolodc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanolodc() != null) {
			where.append(" AND t3.SANOLODC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanolodc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacopvdc() != null) {
			where.append(" AND t3.SACOPVDC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacopvdc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacomudc() != null) {
			where.append(" AND t3.SACOMUDC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacomudc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrcpdc() != null) {
			where.append(" AND t3.SANRCPDC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanrcpdc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainacuo() != null) {
			where.append(" AND t3.SAINACUO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainacuo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoorpr() != null) {
			where.append(" AND t3.SACOORPR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoorpr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacosere() != null) {
			where.append(" AND t3.SACOSERE = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacosere());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacotti() != null) {
			where.append(" AND t3.SACOTTI = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacotti());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaintiso() != null) {
			where.append(" AND t3.SAINTISO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaintiso());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacnrecl() != null) {
			where.append(" AND t3.SACNRECL = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacnrecl());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSateobrc() != null) {
			where.append(" AND t3.SATEOBRC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSateobrc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeinad() != null) {
			where.append(" AND t3.SAFEINAD = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafeinad());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacot5() != null) {
			where.append(" AND t3.SACOT5 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacot5());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSateinad() != null) {
			where.append(" AND t3.SATEINAD = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSateinad());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafereit() != null) {
			where.append(" AND t3.SAFEREIT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafereit());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafetras() != null) {
			where.append(" AND t3.SAFETRAS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafetras());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoortr() != null) {
			where.append(" AND t3.SACOORTR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoortr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferett() != null) {
			where.append(" AND t3.SAFERETT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferett());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferets() != null) {
			where.append(" AND t3.SAFERETS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferets());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafemedi() != null) {
			where.append(" AND t3.SAFEMEDI = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafemedi());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainreme() != null) {
			where.append(" AND t3.SAINREME = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainreme());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferemt() != null) {
			where.append(" AND t3.SAFEREMT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferemt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafedesi() != null) {
			where.append(" AND t3.SAFEDESI = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafedesi());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferedt() != null) {
			where.append(" AND t3.SAFEREDT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferedt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoco() != null) {
			where.append(" AND t3.SAFENOCO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenoco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferear() != null) {
			where.append(" AND t3.SAFEREAR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferear());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafedeco() != null) {
			where.append(" AND t3.SAFEDECO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafedeco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarpt() != null) {
			where.append(" AND t3.SACOARPT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoarpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencpt() != null) {
			where.append(" AND t3.SAINMENCPT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencpt() != null) {
			where.append(" AND t3.SAINRENCPT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarps() != null) {
			where.append(" AND t3.SACOARPS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoarps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencps() != null) {
			where.append(" AND t3.SAINMENCPS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencps() != null) {
			where.append(" AND t3.SAINRENCPS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoartt() != null) {
			where.append(" AND t3.SACOARTT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoartt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenctt() != null) {
			where.append(" AND t3.SAINMENCTT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmenctt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenctt() != null) {
			where.append(" AND t3.SAINRENCTT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrenctt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarts() != null) {
			where.append(" AND t3.SACOARTS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoarts());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencts() != null) {
			where.append(" AND t3.SAINMENCTS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencts());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencts() != null) {
			where.append(" AND t3.SAINRENCTS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencts());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoccco() != null) {
			where.append(" AND t3.SACOCCCO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoccco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoardt() != null) {
			where.append(" AND t3.SACOARDT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoardt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencdt() != null) {
			where.append(" AND t3.SAINMENCDT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencdt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencdt() != null) {
			where.append(" AND t3.SAINRENCDT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencdt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoards() != null) {
			where.append(" AND t3.SACOARDS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoards());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencds() != null) {
			where.append(" AND t3.SAINMENCDS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencds());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencds() != null) {
			where.append(" AND t3.SAINRENCDS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencds());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacooeco() != null) {
			where.append(" AND t3.SACOOECO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacooeco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoset() != null) {
			where.append(" AND t3.SACOSET = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoset());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencst() != null) {
			where.append(" AND t3.SAINMENCST = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencst());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencst() != null) {
			where.append(" AND t3.SAINRENCST = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencst());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoses() != null) {
			where.append(" AND t3.SACOSES = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoses());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencss() != null) {
			where.append(" AND t3.SAINMENCSS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencss());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencss() != null) {
			where.append(" AND t3.SAINRENCSS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencss());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenct() != null) {
			where.append(" AND t3.SAINMENCT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmenct());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenct() != null) {
			where.append(" AND t3.SAINRENCT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrenct());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeciau() != null) {
			where.append(" AND t3.SAFECIAU = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafeciau());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSahrciau() != null) {
			where.append(" AND t3.SAHRCIAU = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSahrciau());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanolura() != null) {
			where.append(" AND t3.SANOLURA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanolura());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanodira() != null) {
			where.append(" AND t3.SANODIRA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanodira());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoloa() != null) {
			where.append(" AND t3.SACOLOA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoloa());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrcpa() != null) {
			where.append(" AND t3.SANRCPA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanrcpa());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainsopr() != null) {
			where.append(" AND t3.SAINSOPR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainsopr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaininpr() != null) {
			where.append(" AND t3.SAININPR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaininpr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSateobpr() != null) {
			where.append(" AND t3.SATEOBPR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSateobpr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacope1() != null) {
			where.append(" AND t3.SACOPE1 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacope1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacneupr1() != null) {
			where.append(" AND t3.SACNEUPR1 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacneupr1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacope2() != null) {
			where.append(" AND t3.SACOPE2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacope2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacneupr2() != null) {
			where.append(" AND t3.SACNEUPR2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacneupr2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenopr() != null) {
			where.append(" AND t3.SAFENOPR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenopr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenp1() != null) {
			where.append(" AND t3.SAINMENP1 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmenp1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenp1() != null) {
			where.append(" AND t3.SAINRENP1 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrenp1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenp2() != null) {
			where.append(" AND t3.SAINMENP2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmenp2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenp2() != null) {
			where.append(" AND t3.SAINRENP2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrenp2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenpt() != null) {
			where.append(" AND t3.SAINMENPT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmenpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenpt() != null) {
			where.append(" AND t3.SAINRENPT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrenpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanolup() != null) {
			where.append(" AND t3.SANOLUP = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanolup());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanodirp() != null) {
			where.append(" AND t3.SANODIRP = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanodirp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacolop() != null) {
			where.append(" AND t3.SACOLOP = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacolop());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrcopop() != null) {
			where.append(" AND t3.SANRCOPOP = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSanrcopop());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanopvp() != null) {
			where.append(" AND t3.SANOPVP = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanopvp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrtelp() != null) {
			where.append(" AND t3.SANRTELP = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanrtelp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrfaxp() != null) {
			where.append(" AND t3.SANRFAXP = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanrfaxp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferepr() != null) {
			where.append(" AND t3.SAFEREPR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferepr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSahrrepr() != null) {
			where.append(" AND t3.SAHRREPR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSahrrepr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarpt2() != null) {
			where.append(" AND t3.SACOARPT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoarpt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencpt2() != null) {
			where.append(" AND t3.SAINMENCPT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencpt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencpt2() != null) {
			where.append(" AND t3.SAINRENCPT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencpt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarps2() != null) {
			where.append(" AND t3.SACOARPS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoarps2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencps2() != null) {
			where.append(" AND t3.SAINMENCPS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencps2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencps2() != null) {
			where.append(" AND t3.SAINRENCPS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencps2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoartt2() != null) {
			where.append(" AND t3.SACOARTT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoartt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenctt2() != null) {
			where.append(" AND t3.SAINMENCTT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmenctt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenctt2() != null) {
			where.append(" AND t3.SAINRENCTT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrenctt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarts2() != null) {
			where.append(" AND t3.SACOARTS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoarts2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencts2() != null) {
			where.append(" AND t3.SAINMENCTS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencts2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencts2() != null) {
			where.append(" AND t3.SAINRENCTS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencts2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoccco2() != null) {
			where.append(" AND t3.SACOCCCO2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoccco2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoardt2() != null) {
			where.append(" AND t3.SACOARDT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoardt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencdt2() != null) {
			where.append(" AND t3.SAINMENCDT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencdt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencdt2() != null) {
			where.append(" AND t3.SAINRENCDT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencdt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoards2() != null) {
			where.append(" AND t3.SACOARDS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoards2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencds2() != null) {
			where.append(" AND t3.SAINMENCDS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencds2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencds2() != null) {
			where.append(" AND t3.SAINRENCDS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencds2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacooeco2() != null) {
			where.append(" AND t3.SACOOECO2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacooeco2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoset2() != null) {
			where.append(" AND t3.SACOSET2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoset2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencst2() != null) {
			where.append(" AND t3.SAINMENCST2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencst2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencst2() != null) {
			where.append(" AND t3.SAINRENCST2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencst2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoses2() != null) {
			where.append(" AND t3.SACOSES2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoses2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencss2() != null) {
			where.append(" AND t3.SAINMENCSS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmencss2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencss2() != null) {
			where.append(" AND t3.SAINRENCSS2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrencss2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenct2() != null) {
			where.append(" AND t3.SAINMENCT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainmenct2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenct2() != null) {
			where.append(" AND t3.SAINRENCT2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSainrenct2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeciau2() != null) {
			where.append(" AND t3.SAFECIAU2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSafeciau2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSahrciau2() != null) {
			where.append(" AND t3.SAHRCIAU2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSahrciau2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanolura2() != null) {
			where.append(" AND t3.SANOLURA2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSanolura2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanodira2() != null) {
			where.append(" AND t3.SANODIRA2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSanodira2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoloa2() != null) {
			where.append(" AND t3.SACOLOA2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacoloa2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrcpa2() != null) {
			where.append(" AND t3.SANRCPA2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanrcpa2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafelaud() != null) {
			where.append(" AND t3.SAFELAUD = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafelaud());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSateobre() != null) {
			where.append(" AND t3.SATEOBRE = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSateobre());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSatemore() != null) {
			where.append(" AND t3.SATEMORE = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSatemore());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacneuil() != null) {
			where.append(" AND t3.SACNEUIL = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacneuil());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainfdla() != null) {
			where.append(" AND t3.SAINFDLA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainfdla());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainvola() != null) {
			where.append(" AND t3.SAINVOLA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainvola());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainarnl() != null) {
			where.append(" AND t3.SAINARNL = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainarnl());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacot7() != null) {
			where.append(" AND t3.SACOT7 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacot7());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenolt() != null) {
			where.append(" AND t3.SAFENOLT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenolt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmelt() != null) {
			where.append(" AND t3.SAINMELT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainmelt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainpubo() != null) {
			where.append(" AND t3.SAINPUBO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainpubo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacota1() != null) {
			where.append(" AND t3.SACOTA1 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacota1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafesera() != null) {
			where.append(" AND t3.SAFESERA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafesera());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainfdra() != null) {
			where.append(" AND t3.SAINFDRA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainfdra());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafepeex() != null) {
			where.append(" AND t3.SAFEPEEX = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafepeex());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrain() != null) {
			where.append(" AND t3.SAINRAIN = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainrain());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainefin() != null) {
			where.append(" AND t3.SAINEFIN = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSainefin());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeinef() != null) {
			where.append(" AND t3.SAFEINEF = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafeinef());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafear() != null) {
			where.append(" AND t3.SAFEAR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafear());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenode() != null) {
			where.append(" AND t3.SAFENODE = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenode());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferelt() != null) {
			where.append(" AND t3.SAFERELT = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferelt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoca() != null) {
			where.append(" AND t3.SAFENOCA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenoca());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoca2() != null) {
			where.append(" AND t3.SAFENOCA2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSafenoca2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoar() != null) {
			where.append(" AND t3.SAFENOAR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenoar());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacocccos() != null) {
			where.append(" AND t3.SACOCCCOS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacocccos());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoccco2s() != null) {
			where.append(" AND t3.SACOCCCO2S = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacoccco2s());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacooecos() != null) {
			where.append(" AND t3.SACOOECOS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacooecos());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacooeco2s() != null) {
			where.append(" AND t3.SACOOECO2S = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje()
					.getSacooeco2s());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafesoac() != null) {
			where.append(" AND t3.SAFESOAC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafesoac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeenac() != null) {
			where.append(" AND t3.SAFEENAC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafeenac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoac() != null) {
			where.append(" AND t3.SAFENOAC = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenoac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSatefpr1() != null) {
			where.append(" AND t3.SATEFPR1 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSatefpr1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSatefpr2() != null) {
			where.append(" AND t3.SATEFPR2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSatefpr2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafefpr1() != null) {
			where.append(" AND t3.SAFEFPR1 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafefpr1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafefpr2() != null) {
			where.append(" AND t3.SAFEFPR2 = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafefpr2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrbopl() != null) {
			where.append(" AND t3.SANRBOPL = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSanrbopl());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeenin() != null) {
			where.append(" AND t3.SAFEENIN = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafeenin());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacotmd() != null) {
			where.append(" AND t3.SACOTMD = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacotmd());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeoppe() != null) {
			where.append(" AND t3.SAFEOPPE = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafeoppe());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeopla() != null) {
			where.append(" AND t3.SAFEOPLA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafeopla());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafereco() != null) {
			where.append(" AND t3.SAFERECO = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafereco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenola() != null) {
			where.append(" AND t3.SAFENOLA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenola());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenona() != null) {
			where.append(" AND t3.SAFENONA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafenona());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferena() != null) {
			where.append(" AND t3.SAFERENA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaferena());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafecona() != null) {
			where.append(" AND t3.SAFECONA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSafecona());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSapub() != null) {
			where.append(" AND t3.SAPUB = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSapub());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaintica() != null) {
			where.append(" AND t3.SAINTICA = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSaintica());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacotir() != null) {
			where.append(" AND t3.SACOTIR = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacotir());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacops() != null) {
			where.append(" AND t3.SACOPS = ?");
			params.add(solicitudarbitraje.getSolicitudArbitraje().getSacops());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoja() != null) {
			where.append(" AND t1.SACOJA = ?");
			params.add(solicitudarbitraje.getSacoja());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanror() != null) {
			where.append(" AND t1.SANROR = ?");
			params.add(solicitudarbitraje.getSanror());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanran() != null) {
			where.append(" AND t1.SANRAN = ?");
			params.add(solicitudarbitraje.getSanran());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafesoli() != null) {
			where.append(" AND t1.SAFESOLI = ?");
			params.add(solicitudarbitraje.getSafesoli());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacot4() != null) {
			where.append(" AND t1.SACOT4 = ?");
			params.add(solicitudarbitraje.getSacot4());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoxj() != null) {
			where.append(" AND t1.SACOXJ = ?");
			params.add(solicitudarbitraje.getSacoxj());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanodidc() != null) {
			where.append(" AND t1.SANODIDC = ?");
			params.add(solicitudarbitraje.getSanodidc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacolodc() != null) {
			where.append(" AND t1.SACOLODC = ?");
			params.add(solicitudarbitraje.getSacolodc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanolodc() != null) {
			where.append(" AND t1.SANOLODC = ?");
			params.add(solicitudarbitraje.getSanolodc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacopvdc() != null) {
			where.append(" AND t1.SACOPVDC = ?");
			params.add(solicitudarbitraje.getSacopvdc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacomudc() != null) {
			where.append(" AND t1.SACOMUDC = ?");
			params.add(solicitudarbitraje.getSacomudc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrcpdc() != null) {
			where.append(" AND t1.SANRCPDC = ?");
			params.add(solicitudarbitraje.getSanrcpdc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainacuo() != null) {
			where.append(" AND t1.SAINACUO = ?");
			params.add(solicitudarbitraje.getSainacuo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoorpr() != null) {
			where.append(" AND t1.SACOORPR = ?");
			params.add(solicitudarbitraje.getSacoorpr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacosere() != null) {
			where.append(" AND t1.SACOSERE = ?");
			params.add(solicitudarbitraje.getSacosere());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacotti() != null) {
			where.append(" AND t1.SACOTTI = ?");
			params.add(solicitudarbitraje.getSacotti());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaintiso() != null) {
			where.append(" AND t1.SAINTISO = ?");
			params.add(solicitudarbitraje.getSaintiso());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacnrecl() != null) {
			where.append(" AND t1.SACNRECL = ?");
			params.add(solicitudarbitraje.getSacnrecl());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSateobrc() != null) {
			where.append(" AND t1.SATEOBRC = ?");
			params.add(solicitudarbitraje.getSateobrc());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeinad() != null) {
			where.append(" AND t1.SAFEINAD = ?");
			params.add(solicitudarbitraje.getSafeinad());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacot5() != null) {
			where.append(" AND t1.SACOT5 = ?");
			params.add(solicitudarbitraje.getSacot5());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSateinad() != null) {
			where.append(" AND t1.SATEINAD = ?");
			params.add(solicitudarbitraje.getSateinad());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafereit() != null) {
			where.append(" AND t1.SAFEREIT = ?");
			params.add(solicitudarbitraje.getSafereit());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafetras() != null) {
			where.append(" AND t1.SAFETRAS = ?");
			params.add(solicitudarbitraje.getSafetras());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoortr() != null) {
			where.append(" AND t1.SACOORTR = ?");
			params.add(solicitudarbitraje.getSacoortr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferett() != null) {
			where.append(" AND t1.SAFERETT = ?");
			params.add(solicitudarbitraje.getSaferett());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferets() != null) {
			where.append(" AND t1.SAFERETS = ?");
			params.add(solicitudarbitraje.getSaferets());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafemedi() != null) {
			where.append(" AND t1.SAFEMEDI = ?");
			params.add(solicitudarbitraje.getSafemedi());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainreme() != null) {
			where.append(" AND t1.SAINREME = ?");
			params.add(solicitudarbitraje.getSainreme());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferemt() != null) {
			where.append(" AND t1.SAFEREMT = ?");
			params.add(solicitudarbitraje.getSaferemt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafedesi() != null) {
			where.append(" AND t1.SAFEDESI = ?");
			params.add(solicitudarbitraje.getSafedesi());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferedt() != null) {
			where.append(" AND t1.SAFEREDT = ?");
			params.add(solicitudarbitraje.getSaferedt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoco() != null) {
			where.append(" AND t1.SAFENOCO = ?");
			params.add(solicitudarbitraje.getSafenoco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferear() != null) {
			where.append(" AND t1.SAFEREAR = ?");
			params.add(solicitudarbitraje.getSaferear());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafedeco() != null) {
			where.append(" AND t1.SAFEDECO = ?");
			params.add(solicitudarbitraje.getSafedeco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarpt() != null) {
			where.append(" AND t1.SACOARPT = ?");
			params.add(solicitudarbitraje.getSacoarpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencpt() != null) {
			where.append(" AND t1.SAINMENCPT = ?");
			params.add(solicitudarbitraje.getSainmencpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencpt() != null) {
			where.append(" AND t1.SAINRENCPT = ?");
			params.add(solicitudarbitraje.getSainrencpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarps() != null) {
			where.append(" AND t1.SACOARPS = ?");
			params.add(solicitudarbitraje.getSacoarps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencps() != null) {
			where.append(" AND t1.SAINMENCPS = ?");
			params.add(solicitudarbitraje.getSainmencps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencps() != null) {
			where.append(" AND t1.SAINRENCPS = ?");
			params.add(solicitudarbitraje.getSainrencps());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoartt() != null) {
			where.append(" AND t1.SACOARTT = ?");
			params.add(solicitudarbitraje.getSacoartt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenctt() != null) {
			where.append(" AND t1.SAINMENCTT = ?");
			params.add(solicitudarbitraje.getSainmenctt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenctt() != null) {
			where.append(" AND t1.SAINRENCTT = ?");
			params.add(solicitudarbitraje.getSainrenctt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarts() != null) {
			where.append(" AND t1.SACOARTS = ?");
			params.add(solicitudarbitraje.getSacoarts());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencts() != null) {
			where.append(" AND t1.SAINMENCTS = ?");
			params.add(solicitudarbitraje.getSainmencts());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencts() != null) {
			where.append(" AND t1.SAINRENCTS = ?");
			params.add(solicitudarbitraje.getSainrencts());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoccco() != null) {
			where.append(" AND t1.SACOCCCO = ?");
			params.add(solicitudarbitraje.getSacoccco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoardt() != null) {
			where.append(" AND t1.SACOARDT = ?");
			params.add(solicitudarbitraje.getSacoardt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencdt() != null) {
			where.append(" AND t1.SAINMENCDT = ?");
			params.add(solicitudarbitraje.getSainmencdt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencdt() != null) {
			where.append(" AND t1.SAINRENCDT = ?");
			params.add(solicitudarbitraje.getSainrencdt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoards() != null) {
			where.append(" AND t1.SACOARDS = ?");
			params.add(solicitudarbitraje.getSacoards());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencds() != null) {
			where.append(" AND t1.SAINMENCDS = ?");
			params.add(solicitudarbitraje.getSainmencds());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencds() != null) {
			where.append(" AND t1.SAINRENCDS = ?");
			params.add(solicitudarbitraje.getSainrencds());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacooeco() != null) {
			where.append(" AND t1.SACOOECO = ?");
			params.add(solicitudarbitraje.getSacooeco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoset() != null) {
			where.append(" AND t1.SACOSET = ?");
			params.add(solicitudarbitraje.getSacoset());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencst() != null) {
			where.append(" AND t1.SAINMENCST = ?");
			params.add(solicitudarbitraje.getSainmencst());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencst() != null) {
			where.append(" AND t1.SAINRENCST = ?");
			params.add(solicitudarbitraje.getSainrencst());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoses() != null) {
			where.append(" AND t1.SACOSES = ?");
			params.add(solicitudarbitraje.getSacoses());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencss() != null) {
			where.append(" AND t1.SAINMENCSS = ?");
			params.add(solicitudarbitraje.getSainmencss());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencss() != null) {
			where.append(" AND t1.SAINRENCSS = ?");
			params.add(solicitudarbitraje.getSainrencss());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenct() != null) {
			where.append(" AND t1.SAINMENCT = ?");
			params.add(solicitudarbitraje.getSainmenct());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenct() != null) {
			where.append(" AND t1.SAINRENCT = ?");
			params.add(solicitudarbitraje.getSainrenct());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeciau() != null) {
			where.append(" AND t1.SAFECIAU = ?");
			params.add(solicitudarbitraje.getSafeciau());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSahrciau() != null) {
			where.append(" AND t1.SAHRCIAU = ?");
			params.add(solicitudarbitraje.getSahrciau());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanolura() != null) {
			where.append(" AND t1.SANOLURA = ?");
			params.add(solicitudarbitraje.getSanolura());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanodira() != null) {
			where.append(" AND t1.SANODIRA = ?");
			params.add(solicitudarbitraje.getSanodira());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoloa() != null) {
			where.append(" AND t1.SACOLOA = ?");
			params.add(solicitudarbitraje.getSacoloa());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrcpa() != null) {
			where.append(" AND t1.SANRCPA = ?");
			params.add(solicitudarbitraje.getSanrcpa());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainsopr() != null) {
			where.append(" AND t1.SAINSOPR = ?");
			params.add(solicitudarbitraje.getSainsopr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaininpr() != null) {
			where.append(" AND t1.SAININPR = ?");
			params.add(solicitudarbitraje.getSaininpr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSateobpr() != null) {
			where.append(" AND t1.SATEOBPR = ?");
			params.add(solicitudarbitraje.getSateobpr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacope1() != null) {
			where.append(" AND t1.SACOPE1 = ?");
			params.add(solicitudarbitraje.getSacope1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacneupr1() != null) {
			where.append(" AND t1.SACNEUPR1 = ?");
			params.add(solicitudarbitraje.getSacneupr1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacope2() != null) {
			where.append(" AND t1.SACOPE2 = ?");
			params.add(solicitudarbitraje.getSacope2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacneupr2() != null) {
			where.append(" AND t1.SACNEUPR2 = ?");
			params.add(solicitudarbitraje.getSacneupr2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenopr() != null) {
			where.append(" AND t1.SAFENOPR = ?");
			params.add(solicitudarbitraje.getSafenopr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenp1() != null) {
			where.append(" AND t1.SAINMENP1 = ?");
			params.add(solicitudarbitraje.getSainmenp1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenp1() != null) {
			where.append(" AND t1.SAINRENP1 = ?");
			params.add(solicitudarbitraje.getSainrenp1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenp2() != null) {
			where.append(" AND t1.SAINMENP2 = ?");
			params.add(solicitudarbitraje.getSainmenp2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenp2() != null) {
			where.append(" AND t1.SAINRENP2 = ?");
			params.add(solicitudarbitraje.getSainrenp2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenpt() != null) {
			where.append(" AND t1.SAINMENPT = ?");
			params.add(solicitudarbitraje.getSainmenpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenpt() != null) {
			where.append(" AND t1.SAINRENPT = ?");
			params.add(solicitudarbitraje.getSainrenpt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanolup() != null) {
			where.append(" AND t1.SANOLUP = ?");
			params.add(solicitudarbitraje.getSanolup());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanodirp() != null) {
			where.append(" AND t1.SANODIRP = ?");
			params.add(solicitudarbitraje.getSanodirp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacolop() != null) {
			where.append(" AND t1.SACOLOP = ?");
			params.add(solicitudarbitraje.getSacolop());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrcopop() != null) {
			where.append(" AND t1.SANRCOPOP = ?");
			params.add(solicitudarbitraje.getSanrcopop());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanopvp() != null) {
			where.append(" AND t1.SANOPVP = ?");
			params.add(solicitudarbitraje.getSanopvp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrtelp() != null) {
			where.append(" AND t1.SANRTELP = ?");
			params.add(solicitudarbitraje.getSanrtelp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrfaxp() != null) {
			where.append(" AND t1.SANRFAXP = ?");
			params.add(solicitudarbitraje.getSanrfaxp());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferepr() != null) {
			where.append(" AND t1.SAFEREPR = ?");
			params.add(solicitudarbitraje.getSaferepr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSahrrepr() != null) {
			where.append(" AND t1.SAHRREPR = ?");
			params.add(solicitudarbitraje.getSahrrepr());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarpt2() != null) {
			where.append(" AND t1.SACOARPT2 = ?");
			params.add(solicitudarbitraje.getSacoarpt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencpt2() != null) {
			where.append(" AND t1.SAINMENCPT2 = ?");
			params.add(solicitudarbitraje.getSainmencpt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencpt2() != null) {
			where.append(" AND t1.SAINRENCPT2 = ?");
			params.add(solicitudarbitraje.getSainrencpt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarps2() != null) {
			where.append(" AND t1.SACOARPS2 = ?");
			params.add(solicitudarbitraje.getSacoarps2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencps2() != null) {
			where.append(" AND t1.SAINMENCPS2 = ?");
			params.add(solicitudarbitraje.getSainmencps2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencps2() != null) {
			where.append(" AND t1.SAINRENCPS2 = ?");
			params.add(solicitudarbitraje.getSainrencps2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoartt2() != null) {
			where.append(" AND t1.SACOARTT2 = ?");
			params.add(solicitudarbitraje.getSacoartt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenctt2() != null) {
			where.append(" AND t1.SAINMENCTT2 = ?");
			params.add(solicitudarbitraje.getSainmenctt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenctt2() != null) {
			where.append(" AND t1.SAINRENCTT2 = ?");
			params.add(solicitudarbitraje.getSainrenctt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarts2() != null) {
			where.append(" AND t1.SACOARTS2 = ?");
			params.add(solicitudarbitraje.getSacoarts2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencts2() != null) {
			where.append(" AND t1.SAINMENCTS2 = ?");
			params.add(solicitudarbitraje.getSainmencts2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencts2() != null) {
			where.append(" AND t1.SAINRENCTS2 = ?");
			params.add(solicitudarbitraje.getSainrencts2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoccco2() != null) {
			where.append(" AND t1.SACOCCCO2 = ?");
			params.add(solicitudarbitraje.getSacoccco2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoardt2() != null) {
			where.append(" AND t1.SACOARDT2 = ?");
			params.add(solicitudarbitraje.getSacoardt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencdt2() != null) {
			where.append(" AND t1.SAINMENCDT2 = ?");
			params.add(solicitudarbitraje.getSainmencdt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencdt2() != null) {
			where.append(" AND t1.SAINRENCDT2 = ?");
			params.add(solicitudarbitraje.getSainrencdt2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoards2() != null) {
			where.append(" AND t1.SACOARDS2 = ?");
			params.add(solicitudarbitraje.getSacoards2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencds2() != null) {
			where.append(" AND t1.SAINMENCDS2 = ?");
			params.add(solicitudarbitraje.getSainmencds2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencds2() != null) {
			where.append(" AND t1.SAINRENCDS2 = ?");
			params.add(solicitudarbitraje.getSainrencds2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacooeco2() != null) {
			where.append(" AND t1.SACOOECO2 = ?");
			params.add(solicitudarbitraje.getSacooeco2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoset2() != null) {
			where.append(" AND t1.SACOSET2 = ?");
			params.add(solicitudarbitraje.getSacoset2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencst2() != null) {
			where.append(" AND t1.SAINMENCST2 = ?");
			params.add(solicitudarbitraje.getSainmencst2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencst2() != null) {
			where.append(" AND t1.SAINRENCST2 = ?");
			params.add(solicitudarbitraje.getSainrencst2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoses2() != null) {
			where.append(" AND t1.SACOSES2 = ?");
			params.add(solicitudarbitraje.getSacoses2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencss2() != null) {
			where.append(" AND t1.SAINMENCSS2 = ?");
			params.add(solicitudarbitraje.getSainmencss2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencss2() != null) {
			where.append(" AND t1.SAINRENCSS2 = ?");
			params.add(solicitudarbitraje.getSainrencss2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenct2() != null) {
			where.append(" AND t1.SAINMENCT2 = ?");
			params.add(solicitudarbitraje.getSainmenct2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenct2() != null) {
			where.append(" AND t1.SAINRENCT2 = ?");
			params.add(solicitudarbitraje.getSainrenct2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeciau2() != null) {
			where.append(" AND t1.SAFECIAU2 = ?");
			params.add(solicitudarbitraje.getSafeciau2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSahrciau2() != null) {
			where.append(" AND t1.SAHRCIAU2 = ?");
			params.add(solicitudarbitraje.getSahrciau2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanolura2() != null) {
			where.append(" AND t1.SANOLURA2 = ?");
			params.add(solicitudarbitraje.getSanolura2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanodira2() != null) {
			where.append(" AND t1.SANODIRA2 = ?");
			params.add(solicitudarbitraje.getSanodira2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoloa2() != null) {
			where.append(" AND t1.SACOLOA2 = ?");
			params.add(solicitudarbitraje.getSacoloa2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrcpa2() != null) {
			where.append(" AND t1.SANRCPA2 = ?");
			params.add(solicitudarbitraje.getSanrcpa2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafelaud() != null) {
			where.append(" AND t1.SAFELAUD = ?");
			params.add(solicitudarbitraje.getSafelaud());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSateobre() != null) {
			where.append(" AND t1.SATEOBRE = ?");
			params.add(solicitudarbitraje.getSateobre());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSatemore() != null) {
			where.append(" AND t1.SATEMORE = ?");
			params.add(solicitudarbitraje.getSatemore());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacneuil() != null) {
			where.append(" AND t1.SACNEUIL = ?");
			params.add(solicitudarbitraje.getSacneuil());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainfdla() != null) {
			where.append(" AND t1.SAINFDLA = ?");
			params.add(solicitudarbitraje.getSainfdla());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainvola() != null) {
			where.append(" AND t1.SAINVOLA = ?");
			params.add(solicitudarbitraje.getSainvola());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainarnl() != null) {
			where.append(" AND t1.SAINARNL = ?");
			params.add(solicitudarbitraje.getSainarnl());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacot7() != null) {
			where.append(" AND t1.SACOT7 = ?");
			params.add(solicitudarbitraje.getSacot7());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenolt() != null) {
			where.append(" AND t1.SAFENOLT = ?");
			params.add(solicitudarbitraje.getSafenolt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmelt() != null) {
			where.append(" AND t1.SAINMELT = ?");
			params.add(solicitudarbitraje.getSainmelt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainpubo() != null) {
			where.append(" AND t1.SAINPUBO = ?");
			params.add(solicitudarbitraje.getSainpubo());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacota1() != null) {
			where.append(" AND t1.SACOTA1 = ?");
			params.add(solicitudarbitraje.getSacota1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafesera() != null) {
			where.append(" AND t1.SAFESERA = ?");
			params.add(solicitudarbitraje.getSafesera());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainfdra() != null) {
			where.append(" AND t1.SAINFDRA = ?");
			params.add(solicitudarbitraje.getSainfdra());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafepeex() != null) {
			where.append(" AND t1.SAFEPEEX = ?");
			params.add(solicitudarbitraje.getSafepeex());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrain() != null) {
			where.append(" AND t1.SAINRAIN = ?");
			params.add(solicitudarbitraje.getSainrain());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainefin() != null) {
			where.append(" AND t1.SAINEFIN = ?");
			params.add(solicitudarbitraje.getSainefin());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeinef() != null) {
			where.append(" AND t1.SAFEINEF = ?");
			params.add(solicitudarbitraje.getSafeinef());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafear() != null) {
			where.append(" AND t1.SAFEAR = ?");
			params.add(solicitudarbitraje.getSafear());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenode() != null) {
			where.append(" AND t1.SAFENODE = ?");
			params.add(solicitudarbitraje.getSafenode());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferelt() != null) {
			where.append(" AND t1.SAFERELT = ?");
			params.add(solicitudarbitraje.getSaferelt());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoca() != null) {
			where.append(" AND t1.SAFENOCA = ?");
			params.add(solicitudarbitraje.getSafenoca());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoca2() != null) {
			where.append(" AND t1.SAFENOCA2 = ?");
			params.add(solicitudarbitraje.getSafenoca2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoar() != null) {
			where.append(" AND t1.SAFENOAR = ?");
			params.add(solicitudarbitraje.getSafenoar());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacocccos() != null) {
			where.append(" AND t1.SACOCCCOS = ?");
			params.add(solicitudarbitraje.getSacocccos());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoccco2s() != null) {
			where.append(" AND t1.SACOCCCO2S = ?");
			params.add(solicitudarbitraje.getSacoccco2s());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacooecos() != null) {
			where.append(" AND t1.SACOOECOS = ?");
			params.add(solicitudarbitraje.getSacooecos());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacooeco2s() != null) {
			where.append(" AND t1.SACOOECO2S = ?");
			params.add(solicitudarbitraje.getSacooeco2s());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafesoac() != null) {
			where.append(" AND t1.SAFESOAC = ?");
			params.add(solicitudarbitraje.getSafesoac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeenac() != null) {
			where.append(" AND t1.SAFEENAC = ?");
			params.add(solicitudarbitraje.getSafeenac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoac() != null) {
			where.append(" AND t1.SAFENOAC = ?");
			params.add(solicitudarbitraje.getSafenoac());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSatefpr1() != null) {
			where.append(" AND t1.SATEFPR1 = ?");
			params.add(solicitudarbitraje.getSatefpr1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSatefpr2() != null) {
			where.append(" AND t1.SATEFPR2 = ?");
			params.add(solicitudarbitraje.getSatefpr2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafefpr1() != null) {
			where.append(" AND t1.SAFEFPR1 = ?");
			params.add(solicitudarbitraje.getSafefpr1());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafefpr2() != null) {
			where.append(" AND t1.SAFEFPR2 = ?");
			params.add(solicitudarbitraje.getSafefpr2());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrbopl() != null) {
			where.append(" AND t1.SANRBOPL = ?");
			params.add(solicitudarbitraje.getSanrbopl());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeenin() != null) {
			where.append(" AND t1.SAFEENIN = ?");
			params.add(solicitudarbitraje.getSafeenin());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacotmd() != null) {
			where.append(" AND t1.SACOTMD = ?");
			params.add(solicitudarbitraje.getSacotmd());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeoppe() != null) {
			where.append(" AND t1.SAFEOPPE = ?");
			params.add(solicitudarbitraje.getSafeoppe());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeopla() != null) {
			where.append(" AND t1.SAFEOPLA = ?");
			params.add(solicitudarbitraje.getSafeopla());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafereco() != null) {
			where.append(" AND t1.SAFERECO = ?");
			params.add(solicitudarbitraje.getSafereco());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenola() != null) {
			where.append(" AND t1.SAFENOLA = ?");
			params.add(solicitudarbitraje.getSafenola());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenona() != null) {
			where.append(" AND t1.SAFENONA = ?");
			params.add(solicitudarbitraje.getSafenona());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferena() != null) {
			where.append(" AND t1.SAFERENA = ?");
			params.add(solicitudarbitraje.getSaferena());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafecona() != null) {
			where.append(" AND t1.SAFECONA = ?");
			params.add(solicitudarbitraje.getSafecona());
		}
		if (solicitudarbitraje != null && solicitudarbitraje.getSapub() != null) {
			where.append(" AND t1.SAPUB = ?");
			params.add(solicitudarbitraje.getSapub());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaintica() != null) {
			where.append(" AND t1.SAINTICA = ?");
			params.add(solicitudarbitraje.getSaintica());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacotir() != null) {
			where.append(" AND t1.SACOTIR = ?");
			params.add(solicitudarbitraje.getSacotir());
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacops() != null) {
			where.append(" AND t1.SACOPS = ?");
			params.add(solicitudarbitraje.getSacops());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the SolicitudArbitraje table using like.
	 * 
	 * @param solicitudarbitraje
	 *            SolicitudArbitraje
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<SolicitudArbitraje> findAllLike(
			SolicitudArbitraje solicitudarbitraje, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.SACOHD= t2.HDCODIGO(+) AND t1.SACOSAAC= t3.SACODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.SACODIGO SACODIGO,t1.SACOJA SACOJA,t1.SANROR SANROR,t1.SANRAN SANRAN,t1.SAFESOLI SAFESOLI,t1.SACOT4 SACOT4,t1.SACOXJ SACOXJ,t1.SANODIDC SANODIDC,t1.SACOLODC SACOLODC,t1.SANOLODC SANOLODC,t1.SACOPVDC SACOPVDC,t1.SACOMUDC SACOMUDC,t1.SANRCPDC SANRCPDC,t1.SAINACUO SAINACUO,t1.SACOORPR SACOORPR,t1.SACOSERE SACOSERE,t1.SACOTTI SACOTTI,t1.SAINTISO SAINTISO,t1.SACNRECL SACNRECL,t1.SATEOBRC SATEOBRC,t1.SAFEINAD SAFEINAD,t1.SACOT5 SACOT5,t1.SATEINAD SATEINAD,t1.SAFEREIT SAFEREIT,t1.SAFETRAS SAFETRAS,t1.SACOORTR SACOORTR,t1.SAFERETT SAFERETT,t1.SAFERETS SAFERETS,t1.SAFEMEDI SAFEMEDI,t1.SAINREME SAINREME,t1.SAFEREMT SAFEREMT,t1.SAFEDESI SAFEDESI,t1.SAFEREDT SAFEREDT,t1.SAFENOCO SAFENOCO,t1.SAFEREAR SAFEREAR,t1.SAFEDECO SAFEDECO,t1.SACOARPT SACOARPT,t1.SAINMENCPT SAINMENCPT,t1.SAINRENCPT SAINRENCPT,t1.SACOARPS SACOARPS,t1.SAINMENCPS SAINMENCPS,t1.SAINRENCPS SAINRENCPS,t1.SACOARTT SACOARTT,t1.SAINMENCTT SAINMENCTT,t1.SAINRENCTT SAINRENCTT,t1.SACOARTS SACOARTS,t1.SAINMENCTS SAINMENCTS,t1.SAINRENCTS SAINRENCTS,t1.SACOCCCO SACOCCCO,t1.SACOARDT SACOARDT,t1.SAINMENCDT SAINMENCDT,t1.SAINRENCDT SAINRENCDT,t1.SACOARDS SACOARDS,t1.SAINMENCDS SAINMENCDS,t1.SAINRENCDS SAINRENCDS,t1.SACOOECO SACOOECO,t1.SACOSET SACOSET,t1.SAINMENCST SAINMENCST,t1.SAINRENCST SAINRENCST,t1.SACOSES SACOSES,t1.SAINMENCSS SAINMENCSS,t1.SAINRENCSS SAINRENCSS,t1.SAINMENCT SAINMENCT,t1.SAINRENCT SAINRENCT,t1.SAFECIAU SAFECIAU,t1.SAHRCIAU SAHRCIAU,t1.SANOLURA SANOLURA,t1.SANODIRA SANODIRA,t1.SACOLOA SACOLOA,t1.SANRCPA SANRCPA,t1.SAINSOPR SAINSOPR,t1.SAININPR SAININPR,t1.SATEOBPR SATEOBPR,t1.SACOPE1 SACOPE1,t1.SACNEUPR1 SACNEUPR1,t1.SACOPE2 SACOPE2,t1.SACNEUPR2 SACNEUPR2,t1.SAFENOPR SAFENOPR,t1.SAINMENP1 SAINMENP1,t1.SAINRENP1 SAINRENP1,t1.SAINMENP2 SAINMENP2,t1.SAINRENP2 SAINRENP2,t1.SAINMENPT SAINMENPT,t1.SAINRENPT SAINRENPT,t1.SANOLUP SANOLUP,t1.SANODIRP SANODIRP,t1.SACOLOP SACOLOP,t1.SANRCOPOP SANRCOPOP,t1.SANOPVP SANOPVP,t1.SANRTELP SANRTELP,t1.SANRFAXP SANRFAXP,t1.SAFEREPR SAFEREPR,t1.SAHRREPR SAHRREPR,t1.SACOARPT2 SACOARPT2,t1.SAINMENCPT2 SAINMENCPT2,t1.SAINRENCPT2 SAINRENCPT2,t1.SACOARPS2 SACOARPS2,t1.SAINMENCPS2 SAINMENCPS2,t1.SAINRENCPS2 SAINRENCPS2,t1.SACOARTT2 SACOARTT2,t1.SAINMENCTT2 SAINMENCTT2,t1.SAINRENCTT2 SAINRENCTT2,t1.SACOARTS2 SACOARTS2,t1.SAINMENCTS2 SAINMENCTS2,t1.SAINRENCTS2 SAINRENCTS2,t1.SACOCCCO2 SACOCCCO2,t1.SACOARDT2 SACOARDT2,t1.SAINMENCDT2 SAINMENCDT2,t1.SAINRENCDT2 SAINRENCDT2,t1.SACOARDS2 SACOARDS2,t1.SAINMENCDS2 SAINMENCDS2,t1.SAINRENCDS2 SAINRENCDS2,t1.SACOOECO2 SACOOECO2,t1.SACOSET2 SACOSET2,t1.SAINMENCST2 SAINMENCST2,t1.SAINRENCST2 SAINRENCST2,t1.SACOSES2 SACOSES2,t1.SAINMENCSS2 SAINMENCSS2,t1.SAINRENCSS2 SAINRENCSS2,t1.SAINMENCT2 SAINMENCT2,t1.SAINRENCT2 SAINRENCT2,t1.SAFECIAU2 SAFECIAU2,t1.SAHRCIAU2 SAHRCIAU2,t1.SANOLURA2 SANOLURA2,t1.SANODIRA2 SANODIRA2,t1.SACOLOA2 SACOLOA2,t1.SANRCPA2 SANRCPA2,t1.SAFELAUD SAFELAUD,t1.SATEOBRE SATEOBRE,t1.SATEMORE SATEMORE,t1.SACNEUIL SACNEUIL,t1.SAINFDLA SAINFDLA,t1.SAINVOLA SAINVOLA,t1.SAINARNL SAINARNL,t1.SACOT7 SACOT7,t1.SAFENOLT SAFENOLT,t1.SAINMELT SAINMELT,t1.SAINPUBO SAINPUBO,t1.SACOTA1 SACOTA1,t1.SAFESERA SAFESERA,t1.SAINFDRA SAINFDRA,t1.SAFEPEEX SAFEPEEX,t1.SAINRAIN SAINRAIN,t1.SAINEFIN SAINEFIN,t1.SAFEINEF SAFEINEF,t1.SAFEAR SAFEAR,t1.SAFENODE SAFENODE,t1.SAFERELT SAFERELT,t1.SAFENOCA SAFENOCA,t1.SAFENOCA2 SAFENOCA2,t1.SAFENOAR SAFENOAR,t1.SACOCCCOS SACOCCCOS,t1.SACOCCCO2S SACOCCCO2S,t1.SACOOECOS SACOOECOS,t1.SACOOECO2S SACOOECO2S,t1.SAFESOAC SAFESOAC,t1.SAFEENAC SAFEENAC,t1.SAFENOAC SAFENOAC,t1.SATEFPR1 SATEFPR1,t1.SATEFPR2 SATEFPR2,t1.SAFEFPR1 SAFEFPR1,t1.SAFEFPR2 SAFEFPR2,t1.SANRBOPL SANRBOPL,t1.SAFEENIN SAFEENIN,t1.SACOTMD SACOTMD,t1.SAFEOPPE SAFEOPPE,t1.SAFEOPLA SAFEOPLA,t1.SAFERECO SAFERECO,t1.SAFENOLA SAFENOLA,t1.SAFENONA SAFENONA,t1.SAFERENA SAFERENA,t1.SAFECONA SAFECONA,t1.SAPUB SAPUB,t1.SAINTICA SAINTICA,t1.SACOTIR SACOTIR,t1.SACOPS SACOPS,t2.HDCODIGO HECHODENUNCIADOHDCODIGO,t2.HDNROR HECHODENUNCIADOHDNROR,t2.HDTE HECHODENUNCIADOHDTE,t2.HDTEDOAD HECHODENUNCIADOHDTEDOAD,t2.HDCOAV HECHODENUNCIADOHDCOAV,t2.HDNOPS HECHODENUNCIADOHDNOPS,t2.HDNOMAPS HECHODENUNCIADOHDNOMAPS,t2.HDNOMOPS HECHODENUNCIADOHDNOMOPS,t2.HDNRLOPS HECHODENUNCIADOHDNRLOPS,t2.HDFEDMPS HECHODENUNCIADOHDFEDMPS,t2.HDINSOTR HECHODENUNCIADOHDINSOTR,t2.HDINSOMA HECHODENUNCIADOHDINSOMA,t2.HDCAPTSO HECHODENUNCIADOHDCAPTSO,t2.HDTESO HECHODENUNCIADOHDTESO,t2.HDFEARDT HECHODENUNCIADOHDFEARDT,t2.HDFEIOHD HECHODENUNCIADOHDFEIOHD,t2.HDINININ HECHODENUNCIADOHDINININ,t2.HDFEIOPC HECHODENUNCIADOHDFEIOPC,t2.HDFEROPC HECHODENUNCIADOHDFEROPC,t2.HDCOREPC HECHODENUNCIADOHDCOREPC,t2.HDFEIORP HECHODENUNCIADOHDFEIORP,t2.HDFERORP HECHODENUNCIADOHDFERORP,t2.HDCOREAP HECHODENUNCIADOHDCOREAP,t2.HDFEIORA HECHODENUNCIADOHDFEIORA,t2.HDTEACPA HECHODENUNCIADOHDTEACPA,t2.HDFECEAC HECHODENUNCIADOHDFECEAC,t2.HDHOCEAC HECHODENUNCIADOHDHOCEAC,t2.HDFEIOCA HECHODENUNCIADOHDFEIOCA,t2.HDTEACDE HECHODENUNCIADOHDTEACDE,t2.HDFEIOAC HECHODENUNCIADOHDFEIOAC,t2.HDFEIOFC HECHODENUNCIADOHDFEIOFC,t2.HDCOTRA HECHODENUNCIADOHDCOTRA,t2.HDTE02 HECHODENUNCIADOHDTE02,t2.HDTE03 HECHODENUNCIADOHDTE03,t2.HDTE04 HECHODENUNCIADOHDTE04,t2.HDTE05 HECHODENUNCIADOHDTE05,t2.HDTE06 HECHODENUNCIADOHDTE06,t2.HDTE07 HECHODENUNCIADOHDTE07,t2.HDTE08 HECHODENUNCIADOHDTE08,t2.HDTE09 HECHODENUNCIADOHDTE09,t2.HDTE10 HECHODENUNCIADOHDTE10,t2.HDCOSC HECHODENUNCIADOHDCOSC,t2.HDIDAL HECHODENUNCIADOHDIDAL,t2.HDFEROAD HECHODENUNCIADOHDFEROAD,t2.HDFEROAT HECHODENUNCIADOHDFEROAT,t2.HDTEALDT HECHODENUNCIADOHDTEALDT,t2.HDTEDEAT HECHODENUNCIADOHDTEDEAT,t2.HDFEDEAT HECHODENUNCIADOHDFEDEAT,t2.HDFEHD HECHODENUNCIADOHDFEHD,t2.HDTEDOADE HECHODENUNCIADOHDTEDOADE,t2.HDTEDOADI HECHODENUNCIADOHDTEDOADI,t2.HDTEDOADF HECHODENUNCIADOHDTEDOADF,t2.HDTEDOADA HECHODENUNCIADOHDTEDOADA,t2.HDNOPSE HECHODENUNCIADOHDNOPSE,t2.HDNOPSI HECHODENUNCIADOHDNOPSI,t2.HDNOPSF HECHODENUNCIADOHDNOPSF,t2.HDNOPSA HECHODENUNCIADOHDNOPSA,t2.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO,t3.SACODIGO SOLICITUDARBITRAJESACODIGO,t3.SACOJA SOLICITUDARBITRAJESACOJA,t3.SANROR SOLICITUDARBITRAJESANROR,t3.SANRAN SOLICITUDARBITRAJESANRAN,t3.SAFESOLI SOLICITUDARBITRAJESAFESOLI,t3.SACOT4 SOLICITUDARBITRAJESACOT4,t3.SACOXJ SOLICITUDARBITRAJESACOXJ,t3.SANODIDC SOLICITUDARBITRAJESANODIDC,t3.SACOLODC SOLICITUDARBITRAJESACOLODC,t3.SANOLODC SOLICITUDARBITRAJESANOLODC,t3.SACOPVDC SOLICITUDARBITRAJESACOPVDC,t3.SACOMUDC SOLICITUDARBITRAJESACOMUDC,t3.SANRCPDC SOLICITUDARBITRAJESANRCPDC,t3.SAINACUO SOLICITUDARBITRAJESAINACUO,t3.SACOORPR SOLICITUDARBITRAJESACOORPR,t3.SACOSERE SOLICITUDARBITRAJESACOSERE,t3.SACOTTI SOLICITUDARBITRAJESACOTTI,t3.SAINTISO SOLICITUDARBITRAJESAINTISO,t3.SACNRECL SOLICITUDARBITRAJESACNRECL,t3.SATEOBRC SOLICITUDARBITRAJESATEOBRC,t3.SAFEINAD SOLICITUDARBITRAJESAFEINAD,t3.SACOT5 SOLICITUDARBITRAJESACOT5,t3.SATEINAD SOLICITUDARBITRAJESATEINAD,t3.SAFEREIT SOLICITUDARBITRAJESAFEREIT,t3.SAFETRAS SOLICITUDARBITRAJESAFETRAS,t3.SACOORTR SOLICITUDARBITRAJESACOORTR,t3.SAFERETT SOLICITUDARBITRAJESAFERETT,t3.SAFERETS SOLICITUDARBITRAJESAFERETS,t3.SAFEMEDI SOLICITUDARBITRAJESAFEMEDI,t3.SAINREME SOLICITUDARBITRAJESAINREME,t3.SAFEREMT SOLICITUDARBITRAJESAFEREMT,t3.SAFEDESI SOLICITUDARBITRAJESAFEDESI,t3.SAFEREDT SOLICITUDARBITRAJESAFEREDT,t3.SAFENOCO SOLICITUDARBITRAJESAFENOCO,t3.SAFEREAR SOLICITUDARBITRAJESAFEREAR,t3.SAFEDECO SOLICITUDARBITRAJESAFEDECO,t3.SACOARPT SOLICITUDARBITRAJESACOARPT,t3.SAINMENCPT SOLICITUDARBITRAJESAINMENCPT,t3.SAINRENCPT SOLICITUDARBITRAJESAINRENCPT,t3.SACOARPS SOLICITUDARBITRAJESACOARPS,t3.SAINMENCPS SOLICITUDARBITRAJESAINMENCPS,t3.SAINRENCPS SOLICITUDARBITRAJESAINRENCPS,t3.SACOARTT SOLICITUDARBITRAJESACOARTT,t3.SAINMENCTT SOLICITUDARBITRAJESAINMENCTT,t3.SAINRENCTT SOLICITUDARBITRAJESAINRENCTT,t3.SACOARTS SOLICITUDARBITRAJESACOARTS,t3.SAINMENCTS SOLICITUDARBITRAJESAINMENCTS,t3.SAINRENCTS SOLICITUDARBITRAJESAINRENCTS,t3.SACOCCCO SOLICITUDARBITRAJESACOCCCO,t3.SACOARDT SOLICITUDARBITRAJESACOARDT,t3.SAINMENCDT SOLICITUDARBITRAJESAINMENCDT,t3.SAINRENCDT SOLICITUDARBITRAJESAINRENCDT,t3.SACOARDS SOLICITUDARBITRAJESACOARDS,t3.SAINMENCDS SOLICITUDARBITRAJESAINMENCDS,t3.SAINRENCDS SOLICITUDARBITRAJESAINRENCDS,t3.SACOOECO SOLICITUDARBITRAJESACOOECO,t3.SACOSET SOLICITUDARBITRAJESACOSET,t3.SAINMENCST SOLICITUDARBITRAJESAINMENCST,t3.SAINRENCST SOLICITUDARBITRAJESAINRENCST,t3.SACOSES SOLICITUDARBITRAJESACOSES,t3.SAINMENCSS SOLICITUDARBITRAJESAINMENCSS,t3.SAINRENCSS SOLICITUDARBITRAJESAINRENCSS,t3.SAINMENCT SOLICITUDARBITRAJESAINMENCT,t3.SAINRENCT SOLICITUDARBITRAJESAINRENCT,t3.SAFECIAU SOLICITUDARBITRAJESAFECIAU,t3.SAHRCIAU SOLICITUDARBITRAJESAHRCIAU,t3.SANOLURA SOLICITUDARBITRAJESANOLURA,t3.SANODIRA SOLICITUDARBITRAJESANODIRA,t3.SACOLOA SOLICITUDARBITRAJESACOLOA,t3.SANRCPA SOLICITUDARBITRAJESANRCPA,t3.SAINSOPR SOLICITUDARBITRAJESAINSOPR,t3.SAININPR SOLICITUDARBITRAJESAININPR,t3.SATEOBPR SOLICITUDARBITRAJESATEOBPR,t3.SACOPE1 SOLICITUDARBITRAJESACOPE1,t3.SACNEUPR1 SOLICITUDARBITRAJESACNEUPR1,t3.SACOPE2 SOLICITUDARBITRAJESACOPE2,t3.SACNEUPR2 SOLICITUDARBITRAJESACNEUPR2,t3.SAFENOPR SOLICITUDARBITRAJESAFENOPR,t3.SAINMENP1 SOLICITUDARBITRAJESAINMENP1,t3.SAINRENP1 SOLICITUDARBITRAJESAINRENP1,t3.SAINMENP2 SOLICITUDARBITRAJESAINMENP2,t3.SAINRENP2 SOLICITUDARBITRAJESAINRENP2,t3.SAINMENPT SOLICITUDARBITRAJESAINMENPT,t3.SAINRENPT SOLICITUDARBITRAJESAINRENPT,t3.SANOLUP SOLICITUDARBITRAJESANOLUP,t3.SANODIRP SOLICITUDARBITRAJESANODIRP,t3.SACOLOP SOLICITUDARBITRAJESACOLOP,t3.SANRCOPOP SOLICITUDARBITRAJESANRCOPOP,t3.SANOPVP SOLICITUDARBITRAJESANOPVP,t3.SANRTELP SOLICITUDARBITRAJESANRTELP,t3.SANRFAXP SOLICITUDARBITRAJESANRFAXP,t3.SAFEREPR SOLICITUDARBITRAJESAFEREPR,t3.SAHRREPR SOLICITUDARBITRAJESAHRREPR,t3.SACOARPT2 SOLICITUDARBITRAJESACOARPT2,t3.SAINMENCPT2 SOLICITUDARBITRAJESAINMENCPT2,t3.SAINRENCPT2 SOLICITUDARBITRAJESAINRENCPT2,t3.SACOARPS2 SOLICITUDARBITRAJESACOARPS2,t3.SAINMENCPS2 SOLICITUDARBITRAJESAINMENCPS2,t3.SAINRENCPS2 SOLICITUDARBITRAJESAINRENCPS2,t3.SACOARTT2 SOLICITUDARBITRAJESACOARTT2,t3.SAINMENCTT2 SOLICITUDARBITRAJESAINMENCTT2,t3.SAINRENCTT2 SOLICITUDARBITRAJESAINRENCTT2,t3.SACOARTS2 SOLICITUDARBITRAJESACOARTS2,t3.SAINMENCTS2 SOLICITUDARBITRAJESAINMENCTS2,t3.SAINRENCTS2 SOLICITUDARBITRAJESAINRENCTS2,t3.SACOCCCO2 SOLICITUDARBITRAJESACOCCCO2,t3.SACOARDT2 SOLICITUDARBITRAJESACOARDT2,t3.SAINMENCDT2 SOLICITUDARBITRAJESAINMENCDT2,t3.SAINRENCDT2 SOLICITUDARBITRAJESAINRENCDT2,t3.SACOARDS2 SOLICITUDARBITRAJESACOARDS2,t3.SAINMENCDS2 SOLICITUDARBITRAJESAINMENCDS2,t3.SAINRENCDS2 SOLICITUDARBITRAJESAINRENCDS2,t3.SACOOECO2 SOLICITUDARBITRAJESACOOECO2,t3.SACOSET2 SOLICITUDARBITRAJESACOSET2,t3.SAINMENCST2 SOLICITUDARBITRAJESAINMENCST2,t3.SAINRENCST2 SOLICITUDARBITRAJESAINRENCST2,t3.SACOSES2 SOLICITUDARBITRAJESACOSES2,t3.SAINMENCSS2 SOLICITUDARBITRAJESAINMENCSS2,t3.SAINRENCSS2 SOLICITUDARBITRAJESAINRENCSS2,t3.SAINMENCT2 SOLICITUDARBITRAJESAINMENCT2,t3.SAINRENCT2 SOLICITUDARBITRAJESAINRENCT2,t3.SAFECIAU2 SOLICITUDARBITRAJESAFECIAU2,t3.SAHRCIAU2 SOLICITUDARBITRAJESAHRCIAU2,t3.SANOLURA2 SOLICITUDARBITRAJESANOLURA2,t3.SANODIRA2 SOLICITUDARBITRAJESANODIRA2,t3.SACOLOA2 SOLICITUDARBITRAJESACOLOA2,t3.SANRCPA2 SOLICITUDARBITRAJESANRCPA2,t3.SAFELAUD SOLICITUDARBITRAJESAFELAUD,t3.SATEOBRE SOLICITUDARBITRAJESATEOBRE,t3.SATEMORE SOLICITUDARBITRAJESATEMORE,t3.SACNEUIL SOLICITUDARBITRAJESACNEUIL,t3.SAINFDLA SOLICITUDARBITRAJESAINFDLA,t3.SAINVOLA SOLICITUDARBITRAJESAINVOLA,t3.SAINARNL SOLICITUDARBITRAJESAINARNL,t3.SACOT7 SOLICITUDARBITRAJESACOT7,t3.SAFENOLT SOLICITUDARBITRAJESAFENOLT,t3.SAINMELT SOLICITUDARBITRAJESAINMELT,t3.SAINPUBO SOLICITUDARBITRAJESAINPUBO,t3.SACOTA1 SOLICITUDARBITRAJESACOTA1,t3.SAFESERA SOLICITUDARBITRAJESAFESERA,t3.SAINFDRA SOLICITUDARBITRAJESAINFDRA,t3.SAFEPEEX SOLICITUDARBITRAJESAFEPEEX,t3.SAINRAIN SOLICITUDARBITRAJESAINRAIN,t3.SAINEFIN SOLICITUDARBITRAJESAINEFIN,t3.SAFEINEF SOLICITUDARBITRAJESAFEINEF,t3.SAFEAR SOLICITUDARBITRAJESAFEAR,t3.SAFENODE SOLICITUDARBITRAJESAFENODE,t3.SAFERELT SOLICITUDARBITRAJESAFERELT,t3.SAFENOCA SOLICITUDARBITRAJESAFENOCA,t3.SAFENOCA2 SOLICITUDARBITRAJESAFENOCA2,t3.SAFENOAR SOLICITUDARBITRAJESAFENOAR,t3.SACOCCCOS SOLICITUDARBITRAJESACOCCCOS,t3.SACOCCCO2S SOLICITUDARBITRAJESACOCCCO2S,t3.SACOOECOS SOLICITUDARBITRAJESACOOECOS,t3.SACOOECO2S SOLICITUDARBITRAJESACOOECO2S,t3.SAFESOAC SOLICITUDARBITRAJESAFESOAC,t3.SAFEENAC SOLICITUDARBITRAJESAFEENAC,t3.SAFENOAC SOLICITUDARBITRAJESAFENOAC,t3.SATEFPR1 SOLICITUDARBITRAJESATEFPR1,t3.SATEFPR2 SOLICITUDARBITRAJESATEFPR2,t3.SAFEFPR1 SOLICITUDARBITRAJESAFEFPR1,t3.SAFEFPR2 SOLICITUDARBITRAJESAFEFPR2,t3.SANRBOPL SOLICITUDARBITRAJESANRBOPL,t3.SAFEENIN SOLICITUDARBITRAJESAFEENIN,t3.SACOTMD SOLICITUDARBITRAJESACOTMD,t3.SAFEOPPE SOLICITUDARBITRAJESAFEOPPE,t3.SAFEOPLA SOLICITUDARBITRAJESAFEOPLA,t3.SAFERECO SOLICITUDARBITRAJESAFERECO,t3.SAFENOLA SOLICITUDARBITRAJESAFENOLA,t3.SAFENONA SOLICITUDARBITRAJESAFENONA,t3.SAFERENA SOLICITUDARBITRAJESAFERENA,t3.SAFECONA SOLICITUDARBITRAJESAFECONA,t3.SAPUB SOLICITUDARBITRAJESAPUB,t3.SAINTICA SOLICITUDARBITRAJESAINTICA,t3.SACOTIR SOLICITUDARBITRAJESACOTIR,t3.SACOPS SOLICITUDARBITRAJESACOPS,t2.HDCODE HECHODENUNCIADOHDCODE,t2.HDCOES HECHODENUNCIADOHDCOES,t2.HDCOSE HECHODENUNCIADOHDCOSE,t2.HDCOMO HECHODENUNCIADOHDCOMO,t2.HDCOPS HECHODENUNCIADOHDCOPS,t2.HDCOTSR HECHODENUNCIADOHDCOTSR,t2.HDCOTIR HECHODENUNCIADOHDCOTIR,t3.SACOHD SOLICITUDARBITRAJESACOHD,t3.SACOSAAC SOLICITUDARBITRAJESACOSAAC "
						+ "FROM SOLICITUD_ARBITRAJE t1 ,HECHO_DENUNCIADO t2 ,SOLICITUD_ARBITRAJE t3 ");

		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacodigo() != null) {
			where.append(" AND UPPER(t1.SACODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacodigo().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACODIGO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t2.HDCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdcodigo() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdcodigo()
						+ "%");
			}
			where.append(" AND t2.HDCODIGO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getDenuncia() != null
				&& solicitudarbitraje.getHechoDenunciado().getDenuncia()
						.getDecodigo() != null) {
			where.append(" AND UPPER(t2.HDCODE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getDenuncia().getDecodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getDenuncia()
								.getDecodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCODE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getEstablecimiento() != null
				&& solicitudarbitraje.getHechoDenunciado().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND UPPER(t2.HDCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getEstablecimiento().getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado()
								.getEstablecimiento().getEscodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOES IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getSector() != null
				&& solicitudarbitraje.getHechoDenunciado().getSector()
						.getSecodigo() != null) {
			where.append(" AND UPPER(t2.HDCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getSector()
						.getSecodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getSector()
								.getSecodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOSE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getCensoMonitor() != null
				&& solicitudarbitraje.getHechoDenunciado().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND UPPER(t2.HDCOMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getCensoMonitor().getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado()
								.getCensoMonitor().getMocodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.HDCOMO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getProducto() != null
				&& solicitudarbitraje.getHechoDenunciado().getProducto()
						.getPscodigo() != null) {
			where.append(" AND UPPER(t2.HDCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getProducto().getPscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getProducto()
								.getPscodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOPS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getTipoReclamacion() != null
				&& solicitudarbitraje.getHechoDenunciado().getTipoReclamacion()
						.getTsrcodigo() != null) {
			where.append(" AND UPPER(t2.HDCOTSR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getTipoReclamacion().getTsrcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado()
								.getTipoReclamacion().getTsrcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOTSR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getMotivo() != null
				&& solicitudarbitraje.getHechoDenunciado().getMotivo()
						.getTircodigo() != null) {
			where.append(" AND UPPER(t2.HDCOTIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getMotivo()
						.getTircodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getMotivo()
								.getTircodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOTIR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t2.HDNROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdnror()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdnror()
						+ "%");
			}
			where.append(" AND t2.HDNROR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte() != null) {
			where.append(" AND UPPER(t2.HDTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdte()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdte()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND UPPER(t2.HDTEDOAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdtedoad().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdtedoad()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOAD IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND UPPER(t2.HDCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdcoav()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdcoav()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOAV IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND UPPER(t2.HDNOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdnops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdnops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND UPPER(t2.HDNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdnomaps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdnomaps()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOMAPS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND UPPER(t2.HDNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdnomops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdnomops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOMOPS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND UPPER(t2.HDNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdnrlops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdnrlops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNRLOPS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t2.HDFEDMPS like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdfedmps() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdfedmps()
						+ "%");
			}
			where.append(" AND t2.HDFEDMPS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND UPPER(t2.HDINSOTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdinsotr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdinsotr()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDINSOTR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND UPPER(t2.HDINSOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdinsoma().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdinsoma()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDINSOMA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t2.HDCAPTSO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdcaptso() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdcaptso()
						+ "%");
			}
			where.append(" AND t2.HDCAPTSO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND UPPER(t2.HDTESO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdteso()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdteso()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTESO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t2.HDFEARDT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdfeardt() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdfeardt()
						+ "%");
			}
			where.append(" AND t2.HDFEARDT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t2.HDFEIOHD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdfeiohd() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdfeiohd()
						+ "%");
			}
			where.append(" AND t2.HDFEIOHD IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND UPPER(t2.HDINININ) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdininin().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdininin()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDINININ IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t2.HDFEIOPC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdfeiopc() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdfeiopc()
						+ "%");
			}
			where.append(" AND t2.HDFEIOPC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t2.HDFEROPC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdferopc() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdferopc()
						+ "%");
			}
			where.append(" AND t2.HDFEROPC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND UPPER(t2.HDCOREPC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdcorepc().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdcorepc()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOREPC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t2.HDFEIORP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdfeiorp() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdfeiorp()
						+ "%");
			}
			where.append(" AND t2.HDFEIORP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t2.HDFERORP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdferorp() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdferorp()
						+ "%");
			}
			where.append(" AND t2.HDFERORP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND UPPER(t2.HDCOREAP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdcoreap().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdcoreap()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOREAP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t2.HDFEIORA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdfeiora() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdfeiora()
						+ "%");
			}
			where.append(" AND t2.HDFEIORA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND UPPER(t2.HDTEACPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdteacpa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdteacpa()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEACPA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t2.HDFECEAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdfeceac() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdfeceac()
						+ "%");
			}
			where.append(" AND t2.HDFECEAC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND UPPER(t2.HDHOCEAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdhoceac().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdhoceac()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDHOCEAC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t2.HDFEIOCA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdfeioca() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdfeioca()
						+ "%");
			}
			where.append(" AND t2.HDFEIOCA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND UPPER(t2.HDTEACDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdteacde().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdteacde()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEACDE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t2.HDFEIOAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdfeioac() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdfeioac()
						+ "%");
			}
			where.append(" AND t2.HDFEIOAC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t2.HDFEIOFC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdfeiofc() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdfeiofc()
						+ "%");
			}
			where.append(" AND t2.HDFEIOFC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND UPPER(t2.HDCOTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdcotra()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdcotra()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOTRA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND UPPER(t2.HDTE02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdte02()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdte02()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE02 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND UPPER(t2.HDTE03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdte03()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdte03()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE03 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND UPPER(t2.HDTE04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdte04()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdte04()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE04 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND UPPER(t2.HDTE05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdte05()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdte05()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE05 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND UPPER(t2.HDTE06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdte06()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdte06()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE06 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND UPPER(t2.HDTE07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdte07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdte07()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE07 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND UPPER(t2.HDTE08) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdte08()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdte08()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE08 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND UPPER(t2.HDTE09) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdte09()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdte09()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE09 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND UPPER(t2.HDTE10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdte10()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdte10()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE10 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND UPPER(t2.HDCOSC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdcosc()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdcosc()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOSC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND UPPER(t2.HDIDAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdidal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdidal()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDIDAL IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t2.HDFEROAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdferoad() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdferoad()
						+ "%");
			}
			where.append(" AND t2.HDFEROAD IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t2.HDFEROAT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdferoat() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdferoat()
						+ "%");
			}
			where.append(" AND t2.HDFEROAT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND UPPER(t2.HDTEALDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdtealdt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdtealdt()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEALDT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND UPPER(t2.HDTEDEAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdtedeat().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdtedeat()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDEAT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t2.HDFEDEAT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdfedeat() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdfedeat()
						+ "%");
			}
			where.append(" AND t2.HDFEDEAT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t2.HDFEHD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdfehd()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdfehd()
						+ "%");
			}
			where.append(" AND t2.HDFEHD IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND UPPER(t2.HDTEDOADE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdtedoade().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado()
								.getHdtedoade().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOADE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND UPPER(t2.HDTEDOADI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdtedoadi().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado()
								.getHdtedoadi().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOADI IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND UPPER(t2.HDTEDOADF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdtedoadf().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado()
								.getHdtedoadf().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOADF IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND UPPER(t2.HDTEDOADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdtedoada().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado()
								.getHdtedoada().toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOADA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND UPPER(t2.HDNOPSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdnopse()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdnopse()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPSE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND UPPER(t2.HDNOPSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdnopsi()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdnopsi()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPSI IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND UPPER(t2.HDNOPSF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdnopsf()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdnopsf()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPSF IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND UPPER(t2.HDNOPSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado().getHdnopsa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado().getHdnopsa()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPSA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getHechoDenunciado() != null
				&& solicitudarbitraje.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND UPPER(t2.HDCOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getHechoDenunciado()
						.getHdcocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getHechoDenunciado()
								.getHdcocodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOCODIGO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacodigo() != null) {
			where.append(" AND t3.SACODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacodigo() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacodigo() + "%");
			}
			where.append(" AND t3.SACODIGO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje()
						.getHechoDenunciado() != null
				&& solicitudarbitraje.getSolicitudArbitraje()
						.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND UPPER(t3.SACOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getHechoDenunciado().getHdcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getHechoDenunciado().getHdcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.SACOHD IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje()
						.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje()
						.getSolicitudArbitraje().getSacodigo() != null) {
			where.append(" AND UPPER(t3.SACOSAAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSolicitudArbitraje().getSacodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSolicitudArbitraje().getSacodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.SACOSAAC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoja() != null) {
			where.append(" AND UPPER(t3.SACOJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoja().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoja().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOJA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanror() != null) {
			where.append(" AND t3.SANROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanror() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanror() + "%");
			}
			where.append(" AND t3.SANROR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanran() != null) {
			where.append(" AND t3.SANRAN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanran() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanran() + "%");
			}
			where.append(" AND t3.SANRAN IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafesoli() != null) {
			where.append(" AND t3.SAFESOLI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafesoli() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafesoli() + "%");
			}
			where.append(" AND t3.SAFESOLI IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacot4() != null) {
			where.append(" AND UPPER(t3.SACOT4) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacot4().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacot4().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOT4 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoxj() != null) {
			where.append(" AND UPPER(t3.SACOXJ) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoxj().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoxj().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOXJ IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanodidc() != null) {
			where.append(" AND UPPER(t3.SANODIDC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanodidc().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanodidc().toUpperCase() + "%");
			}
			where.append(" AND t3.SANODIDC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacolodc() != null) {
			where.append(" AND UPPER(t3.SACOLODC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacolodc().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacolodc().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOLODC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanolodc() != null) {
			where.append(" AND UPPER(t3.SANOLODC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanolodc().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanolodc().toUpperCase() + "%");
			}
			where.append(" AND t3.SANOLODC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacopvdc() != null) {
			where.append(" AND UPPER(t3.SACOPVDC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacopvdc().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacopvdc().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOPVDC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacomudc() != null) {
			where.append(" AND UPPER(t3.SACOMUDC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacomudc().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacomudc().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOMUDC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrcpdc() != null) {
			where.append(" AND UPPER(t3.SANRCPDC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanrcpdc().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanrcpdc().toUpperCase() + "%");
			}
			where.append(" AND t3.SANRCPDC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainacuo() != null) {
			where.append(" AND UPPER(t3.SAINACUO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainacuo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainacuo().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINACUO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoorpr() != null) {
			where.append(" AND UPPER(t3.SACOORPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoorpr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoorpr().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOORPR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacosere() != null) {
			where.append(" AND UPPER(t3.SACOSERE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacosere().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacosere().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOSERE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacotti() != null) {
			where.append(" AND UPPER(t3.SACOTTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacotti().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacotti().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOTTI IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaintiso() != null) {
			where.append(" AND UPPER(t3.SAINTISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSaintiso().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSaintiso().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINTISO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacnrecl() != null) {
			where.append(" AND t3.SACNRECL like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacnrecl() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacnrecl() + "%");
			}
			where.append(" AND t3.SACNRECL IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSateobrc() != null) {
			where.append(" AND UPPER(t3.SATEOBRC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSateobrc().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSateobrc().toUpperCase() + "%");
			}
			where.append(" AND t3.SATEOBRC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeinad() != null) {
			where.append(" AND t3.SAFEINAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafeinad() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafeinad() + "%");
			}
			where.append(" AND t3.SAFEINAD IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacot5() != null) {
			where.append(" AND UPPER(t3.SACOT5) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacot5().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacot5().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOT5 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSateinad() != null) {
			where.append(" AND UPPER(t3.SATEINAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSateinad().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSateinad().toUpperCase() + "%");
			}
			where.append(" AND t3.SATEINAD IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafereit() != null) {
			where.append(" AND t3.SAFEREIT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafereit() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafereit() + "%");
			}
			where.append(" AND t3.SAFEREIT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafetras() != null) {
			where.append(" AND t3.SAFETRAS like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafetras() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafetras() + "%");
			}
			where.append(" AND t3.SAFETRAS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoortr() != null) {
			where.append(" AND UPPER(t3.SACOORTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoortr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoortr().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOORTR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferett() != null) {
			where.append(" AND t3.SAFERETT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSaferett() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSaferett() + "%");
			}
			where.append(" AND t3.SAFERETT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferets() != null) {
			where.append(" AND t3.SAFERETS like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSaferets() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSaferets() + "%");
			}
			where.append(" AND t3.SAFERETS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafemedi() != null) {
			where.append(" AND t3.SAFEMEDI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafemedi() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafemedi() + "%");
			}
			where.append(" AND t3.SAFEMEDI IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainreme() != null) {
			where.append(" AND UPPER(t3.SAINREME) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainreme().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainreme().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINREME IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferemt() != null) {
			where.append(" AND t3.SAFEREMT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSaferemt() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSaferemt() + "%");
			}
			where.append(" AND t3.SAFEREMT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafedesi() != null) {
			where.append(" AND t3.SAFEDESI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafedesi() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafedesi() + "%");
			}
			where.append(" AND t3.SAFEDESI IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferedt() != null) {
			where.append(" AND t3.SAFEREDT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSaferedt() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSaferedt() + "%");
			}
			where.append(" AND t3.SAFEREDT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoco() != null) {
			where.append(" AND t3.SAFENOCO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafenoco() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafenoco() + "%");
			}
			where.append(" AND t3.SAFENOCO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferear() != null) {
			where.append(" AND t3.SAFEREAR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSaferear() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSaferear() + "%");
			}
			where.append(" AND t3.SAFEREAR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafedeco() != null) {
			where.append(" AND t3.SAFEDECO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafedeco() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafedeco() + "%");
			}
			where.append(" AND t3.SAFEDECO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarpt() != null) {
			where.append(" AND UPPER(t3.SACOARPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoarpt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoarpt().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOARPT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencpt() != null) {
			where.append(" AND UPPER(t3.SAINMENCPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmencpt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmencpt().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCPT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencpt() != null) {
			where.append(" AND UPPER(t3.SAINRENCPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrencpt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrencpt().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCPT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarps() != null) {
			where.append(" AND UPPER(t3.SACOARPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoarps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoarps().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOARPS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencps() != null) {
			where.append(" AND UPPER(t3.SAINMENCPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmencps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmencps().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCPS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencps() != null) {
			where.append(" AND UPPER(t3.SAINRENCPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrencps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrencps().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCPS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoartt() != null) {
			where.append(" AND UPPER(t3.SACOARTT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoartt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoartt().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOARTT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenctt() != null) {
			where.append(" AND UPPER(t3.SAINMENCTT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmenctt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmenctt().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCTT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenctt() != null) {
			where.append(" AND UPPER(t3.SAINRENCTT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrenctt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrenctt().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCTT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarts() != null) {
			where.append(" AND UPPER(t3.SACOARTS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoarts().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoarts().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOARTS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencts() != null) {
			where.append(" AND UPPER(t3.SAINMENCTS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmencts().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmencts().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCTS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencts() != null) {
			where.append(" AND UPPER(t3.SAINRENCTS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrencts().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrencts().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCTS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoccco() != null) {
			where.append(" AND UPPER(t3.SACOCCCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoccco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoccco().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOCCCO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoardt() != null) {
			where.append(" AND UPPER(t3.SACOARDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoardt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoardt().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOARDT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencdt() != null) {
			where.append(" AND UPPER(t3.SAINMENCDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmencdt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmencdt().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCDT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencdt() != null) {
			where.append(" AND UPPER(t3.SAINRENCDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrencdt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrencdt().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCDT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoards() != null) {
			where.append(" AND UPPER(t3.SACOARDS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoards().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoards().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOARDS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencds() != null) {
			where.append(" AND UPPER(t3.SAINMENCDS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmencds().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmencds().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCDS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencds() != null) {
			where.append(" AND UPPER(t3.SAINRENCDS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrencds().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrencds().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCDS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacooeco() != null) {
			where.append(" AND UPPER(t3.SACOOECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacooeco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacooeco().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOOECO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoset() != null) {
			where.append(" AND UPPER(t3.SACOSET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoset().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoset().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOSET IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencst() != null) {
			where.append(" AND UPPER(t3.SAINMENCST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmencst().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmencst().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCST IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencst() != null) {
			where.append(" AND UPPER(t3.SAINRENCST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrencst().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrencst().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCST IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoses() != null) {
			where.append(" AND UPPER(t3.SACOSES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoses().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoses().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOSES IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencss() != null) {
			where.append(" AND UPPER(t3.SAINMENCSS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmencss().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmencss().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCSS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencss() != null) {
			where.append(" AND UPPER(t3.SAINRENCSS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrencss().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrencss().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCSS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenct() != null) {
			where.append(" AND UPPER(t3.SAINMENCT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmenct().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmenct().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenct() != null) {
			where.append(" AND UPPER(t3.SAINRENCT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrenct().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrenct().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeciau() != null) {
			where.append(" AND t3.SAFECIAU like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafeciau() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafeciau() + "%");
			}
			where.append(" AND t3.SAFECIAU IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSahrciau() != null) {
			where.append(" AND UPPER(t3.SAHRCIAU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSahrciau().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSahrciau().toUpperCase() + "%");
			}
			where.append(" AND t3.SAHRCIAU IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanolura() != null) {
			where.append(" AND UPPER(t3.SANOLURA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanolura().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanolura().toUpperCase() + "%");
			}
			where.append(" AND t3.SANOLURA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanodira() != null) {
			where.append(" AND UPPER(t3.SANODIRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanodira().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanodira().toUpperCase() + "%");
			}
			where.append(" AND t3.SANODIRA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoloa() != null) {
			where.append(" AND UPPER(t3.SACOLOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoloa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoloa().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOLOA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrcpa() != null) {
			where.append(" AND UPPER(t3.SANRCPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanrcpa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanrcpa().toUpperCase() + "%");
			}
			where.append(" AND t3.SANRCPA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainsopr() != null) {
			where.append(" AND UPPER(t3.SAINSOPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainsopr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainsopr().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINSOPR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaininpr() != null) {
			where.append(" AND UPPER(t3.SAININPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSaininpr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSaininpr().toUpperCase() + "%");
			}
			where.append(" AND t3.SAININPR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSateobpr() != null) {
			where.append(" AND UPPER(t3.SATEOBPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSateobpr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSateobpr().toUpperCase() + "%");
			}
			where.append(" AND t3.SATEOBPR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacope1() != null) {
			where.append(" AND UPPER(t3.SACOPE1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacope1().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacope1().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOPE1 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacneupr1() != null) {
			where.append(" AND t3.SACNEUPR1 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacneupr1() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacneupr1() + "%");
			}
			where.append(" AND t3.SACNEUPR1 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacope2() != null) {
			where.append(" AND UPPER(t3.SACOPE2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacope2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacope2().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOPE2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacneupr2() != null) {
			where.append(" AND t3.SACNEUPR2 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacneupr2() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacneupr2() + "%");
			}
			where.append(" AND t3.SACNEUPR2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenopr() != null) {
			where.append(" AND t3.SAFENOPR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafenopr() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafenopr() + "%");
			}
			where.append(" AND t3.SAFENOPR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenp1() != null) {
			where.append(" AND UPPER(t3.SAINMENP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmenp1().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmenp1().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENP1 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenp1() != null) {
			where.append(" AND UPPER(t3.SAINRENP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrenp1().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrenp1().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENP1 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenp2() != null) {
			where.append(" AND UPPER(t3.SAINMENP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmenp2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmenp2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENP2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenp2() != null) {
			where.append(" AND UPPER(t3.SAINRENP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrenp2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrenp2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENP2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenpt() != null) {
			where.append(" AND UPPER(t3.SAINMENPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmenpt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmenpt().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENPT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenpt() != null) {
			where.append(" AND UPPER(t3.SAINRENPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrenpt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrenpt().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENPT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanolup() != null) {
			where.append(" AND UPPER(t3.SANOLUP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanolup().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanolup().toUpperCase() + "%");
			}
			where.append(" AND t3.SANOLUP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanodirp() != null) {
			where.append(" AND UPPER(t3.SANODIRP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanodirp().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanodirp().toUpperCase() + "%");
			}
			where.append(" AND t3.SANODIRP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacolop() != null) {
			where.append(" AND UPPER(t3.SACOLOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacolop().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacolop().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOLOP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrcopop() != null) {
			where.append(" AND UPPER(t3.SANRCOPOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanrcopop().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanrcopop().toUpperCase() + "%");
			}
			where.append(" AND t3.SANRCOPOP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanopvp() != null) {
			where.append(" AND UPPER(t3.SANOPVP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanopvp().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanopvp().toUpperCase() + "%");
			}
			where.append(" AND t3.SANOPVP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrtelp() != null) {
			where.append(" AND UPPER(t3.SANRTELP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanrtelp().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanrtelp().toUpperCase() + "%");
			}
			where.append(" AND t3.SANRTELP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrfaxp() != null) {
			where.append(" AND UPPER(t3.SANRFAXP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanrfaxp().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanrfaxp().toUpperCase() + "%");
			}
			where.append(" AND t3.SANRFAXP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferepr() != null) {
			where.append(" AND t3.SAFEREPR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSaferepr() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSaferepr() + "%");
			}
			where.append(" AND t3.SAFEREPR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSahrrepr() != null) {
			where.append(" AND UPPER(t3.SAHRREPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSahrrepr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSahrrepr().toUpperCase() + "%");
			}
			where.append(" AND t3.SAHRREPR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarpt2() != null) {
			where.append(" AND UPPER(t3.SACOARPT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoarpt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoarpt2().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOARPT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencpt2() != null) {
			where.append(" AND UPPER(t3.SAINMENCPT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmencpt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmencpt2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCPT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencpt2() != null) {
			where.append(" AND UPPER(t3.SAINRENCPT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrencpt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrencpt2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCPT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarps2() != null) {
			where.append(" AND UPPER(t3.SACOARPS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoarps2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoarps2().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOARPS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencps2() != null) {
			where.append(" AND UPPER(t3.SAINMENCPS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmencps2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmencps2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCPS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencps2() != null) {
			where.append(" AND UPPER(t3.SAINRENCPS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrencps2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrencps2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCPS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoartt2() != null) {
			where.append(" AND UPPER(t3.SACOARTT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoartt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoartt2().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOARTT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenctt2() != null) {
			where.append(" AND UPPER(t3.SAINMENCTT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmenctt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmenctt2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCTT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenctt2() != null) {
			where.append(" AND UPPER(t3.SAINRENCTT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrenctt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrenctt2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCTT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoarts2() != null) {
			where.append(" AND UPPER(t3.SACOARTS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoarts2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoarts2().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOARTS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencts2() != null) {
			where.append(" AND UPPER(t3.SAINMENCTS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmencts2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmencts2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCTS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencts2() != null) {
			where.append(" AND UPPER(t3.SAINRENCTS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrencts2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrencts2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCTS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoccco2() != null) {
			where.append(" AND UPPER(t3.SACOCCCO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoccco2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoccco2().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOCCCO2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoardt2() != null) {
			where.append(" AND UPPER(t3.SACOARDT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoardt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoardt2().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOARDT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencdt2() != null) {
			where.append(" AND UPPER(t3.SAINMENCDT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmencdt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmencdt2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCDT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencdt2() != null) {
			where.append(" AND UPPER(t3.SAINRENCDT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrencdt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrencdt2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCDT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoards2() != null) {
			where.append(" AND UPPER(t3.SACOARDS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoards2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoards2().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOARDS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencds2() != null) {
			where.append(" AND UPPER(t3.SAINMENCDS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmencds2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmencds2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCDS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencds2() != null) {
			where.append(" AND UPPER(t3.SAINRENCDS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrencds2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrencds2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCDS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacooeco2() != null) {
			where.append(" AND UPPER(t3.SACOOECO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacooeco2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacooeco2().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOOECO2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoset2() != null) {
			where.append(" AND UPPER(t3.SACOSET2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoset2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoset2().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOSET2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencst2() != null) {
			where.append(" AND UPPER(t3.SAINMENCST2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmencst2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmencst2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCST2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencst2() != null) {
			where.append(" AND UPPER(t3.SAINRENCST2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrencst2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrencst2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCST2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoses2() != null) {
			where.append(" AND UPPER(t3.SACOSES2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoses2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoses2().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOSES2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmencss2() != null) {
			where.append(" AND UPPER(t3.SAINMENCSS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmencss2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmencss2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCSS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrencss2() != null) {
			where.append(" AND UPPER(t3.SAINRENCSS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrencss2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrencss2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCSS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmenct2() != null) {
			where.append(" AND UPPER(t3.SAINMENCT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmenct2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmenct2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMENCT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrenct2() != null) {
			where.append(" AND UPPER(t3.SAINRENCT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrenct2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrenct2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRENCT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeciau2() != null) {
			where.append(" AND t3.SAFECIAU2 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafeciau2() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafeciau2() + "%");
			}
			where.append(" AND t3.SAFECIAU2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSahrciau2() != null) {
			where.append(" AND UPPER(t3.SAHRCIAU2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSahrciau2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSahrciau2().toUpperCase() + "%");
			}
			where.append(" AND t3.SAHRCIAU2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanolura2() != null) {
			where.append(" AND UPPER(t3.SANOLURA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanolura2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanolura2().toUpperCase() + "%");
			}
			where.append(" AND t3.SANOLURA2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanodira2() != null) {
			where.append(" AND UPPER(t3.SANODIRA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanodira2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanodira2().toUpperCase() + "%");
			}
			where.append(" AND t3.SANODIRA2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoloa2() != null) {
			where.append(" AND UPPER(t3.SACOLOA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoloa2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoloa2().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOLOA2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrcpa2() != null) {
			where.append(" AND UPPER(t3.SANRCPA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanrcpa2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanrcpa2().toUpperCase() + "%");
			}
			where.append(" AND t3.SANRCPA2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafelaud() != null) {
			where.append(" AND t3.SAFELAUD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafelaud() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafelaud() + "%");
			}
			where.append(" AND t3.SAFELAUD IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSateobre() != null) {
			where.append(" AND UPPER(t3.SATEOBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSateobre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSateobre().toUpperCase() + "%");
			}
			where.append(" AND t3.SATEOBRE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSatemore() != null) {
			where.append(" AND UPPER(t3.SATEMORE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSatemore().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSatemore().toUpperCase() + "%");
			}
			where.append(" AND t3.SATEMORE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacneuil() != null) {
			where.append(" AND t3.SACNEUIL like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacneuil() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacneuil() + "%");
			}
			where.append(" AND t3.SACNEUIL IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainfdla() != null) {
			where.append(" AND UPPER(t3.SAINFDLA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainfdla().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainfdla().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINFDLA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainvola() != null) {
			where.append(" AND UPPER(t3.SAINVOLA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainvola().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainvola().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINVOLA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainarnl() != null) {
			where.append(" AND UPPER(t3.SAINARNL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainarnl().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainarnl().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINARNL IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacot7() != null) {
			where.append(" AND UPPER(t3.SACOT7) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacot7().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacot7().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOT7 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenolt() != null) {
			where.append(" AND t3.SAFENOLT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafenolt() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafenolt() + "%");
			}
			where.append(" AND t3.SAFENOLT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainmelt() != null) {
			where.append(" AND UPPER(t3.SAINMELT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainmelt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainmelt().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINMELT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainpubo() != null) {
			where.append(" AND UPPER(t3.SAINPUBO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainpubo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainpubo().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINPUBO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacota1() != null) {
			where.append(" AND UPPER(t3.SACOTA1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacota1().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacota1().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOTA1 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafesera() != null) {
			where.append(" AND t3.SAFESERA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafesera() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafesera() + "%");
			}
			where.append(" AND t3.SAFESERA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainfdra() != null) {
			where.append(" AND UPPER(t3.SAINFDRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainfdra().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainfdra().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINFDRA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafepeex() != null) {
			where.append(" AND t3.SAFEPEEX like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafepeex() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafepeex() + "%");
			}
			where.append(" AND t3.SAFEPEEX IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainrain() != null) {
			where.append(" AND UPPER(t3.SAINRAIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainrain().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainrain().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINRAIN IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSainefin() != null) {
			where.append(" AND UPPER(t3.SAINEFIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSainefin().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSainefin().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINEFIN IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeinef() != null) {
			where.append(" AND t3.SAFEINEF like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafeinef() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafeinef() + "%");
			}
			where.append(" AND t3.SAFEINEF IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafear() != null) {
			where.append(" AND t3.SAFEAR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafear() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafear() + "%");
			}
			where.append(" AND t3.SAFEAR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenode() != null) {
			where.append(" AND t3.SAFENODE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafenode() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafenode() + "%");
			}
			where.append(" AND t3.SAFENODE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferelt() != null) {
			where.append(" AND t3.SAFERELT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSaferelt() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSaferelt() + "%");
			}
			where.append(" AND t3.SAFERELT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoca() != null) {
			where.append(" AND t3.SAFENOCA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafenoca() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafenoca() + "%");
			}
			where.append(" AND t3.SAFENOCA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoca2() != null) {
			where.append(" AND t3.SAFENOCA2 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafenoca2() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafenoca2() + "%");
			}
			where.append(" AND t3.SAFENOCA2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoar() != null) {
			where.append(" AND t3.SAFENOAR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafenoar() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafenoar() + "%");
			}
			where.append(" AND t3.SAFENOAR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacocccos() != null) {
			where.append(" AND UPPER(t3.SACOCCCOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacocccos().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacocccos().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOCCCOS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacoccco2s() != null) {
			where.append(" AND UPPER(t3.SACOCCCO2S) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacoccco2s().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacoccco2s().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOCCCO2S IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacooecos() != null) {
			where.append(" AND UPPER(t3.SACOOECOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacooecos().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacooecos().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOOECOS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacooeco2s() != null) {
			where.append(" AND UPPER(t3.SACOOECO2S) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacooeco2s().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacooeco2s().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOOECO2S IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafesoac() != null) {
			where.append(" AND t3.SAFESOAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafesoac() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafesoac() + "%");
			}
			where.append(" AND t3.SAFESOAC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeenac() != null) {
			where.append(" AND t3.SAFEENAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafeenac() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafeenac() + "%");
			}
			where.append(" AND t3.SAFEENAC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenoac() != null) {
			where.append(" AND t3.SAFENOAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafenoac() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafenoac() + "%");
			}
			where.append(" AND t3.SAFENOAC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSatefpr1() != null) {
			where.append(" AND UPPER(t3.SATEFPR1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSatefpr1().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSatefpr1().toUpperCase() + "%");
			}
			where.append(" AND t3.SATEFPR1 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSatefpr2() != null) {
			where.append(" AND UPPER(t3.SATEFPR2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSatefpr2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSatefpr2().toUpperCase() + "%");
			}
			where.append(" AND t3.SATEFPR2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafefpr1() != null) {
			where.append(" AND t3.SAFEFPR1 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafefpr1() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafefpr1() + "%");
			}
			where.append(" AND t3.SAFEFPR1 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafefpr2() != null) {
			where.append(" AND t3.SAFEFPR2 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafefpr2() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafefpr2() + "%");
			}
			where.append(" AND t3.SAFEFPR2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSanrbopl() != null) {
			where.append(" AND UPPER(t3.SANRBOPL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSanrbopl().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSanrbopl().toUpperCase() + "%");
			}
			where.append(" AND t3.SANRBOPL IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeenin() != null) {
			where.append(" AND t3.SAFEENIN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafeenin() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafeenin() + "%");
			}
			where.append(" AND t3.SAFEENIN IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacotmd() != null) {
			where.append(" AND UPPER(t3.SACOTMD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacotmd().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacotmd().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOTMD IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeoppe() != null) {
			where.append(" AND t3.SAFEOPPE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafeoppe() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafeoppe() + "%");
			}
			where.append(" AND t3.SAFEOPPE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafeopla() != null) {
			where.append(" AND t3.SAFEOPLA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafeopla() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafeopla() + "%");
			}
			where.append(" AND t3.SAFEOPLA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafereco() != null) {
			where.append(" AND t3.SAFERECO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafereco() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafereco() + "%");
			}
			where.append(" AND t3.SAFERECO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenola() != null) {
			where.append(" AND t3.SAFENOLA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafenola() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafenola() + "%");
			}
			where.append(" AND t3.SAFENOLA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafenona() != null) {
			where.append(" AND t3.SAFENONA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafenona() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafenona() + "%");
			}
			where.append(" AND t3.SAFENONA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaferena() != null) {
			where.append(" AND t3.SAFERENA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSaferena() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSaferena() + "%");
			}
			where.append(" AND t3.SAFERENA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSafecona() != null) {
			where.append(" AND t3.SAFECONA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSafecona() + "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSafecona() + "%");
			}
			where.append(" AND t3.SAFECONA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSapub() != null) {
			where.append(" AND UPPER(t3.SAPUB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSapub().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje().getSapub()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.SAPUB IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSaintica() != null) {
			where.append(" AND UPPER(t3.SAINTICA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSaintica().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSaintica().toUpperCase() + "%");
			}
			where.append(" AND t3.SAINTICA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacotir() != null) {
			where.append(" AND UPPER(t3.SACOTIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacotir().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacotir().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOTIR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSolicitudArbitraje() != null
				&& solicitudarbitraje.getSolicitudArbitraje().getSacops() != null) {
			where.append(" AND UPPER(t3.SACOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSolicitudArbitraje()
						.getSacops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSolicitudArbitraje()
								.getSacops().toUpperCase() + "%");
			}
			where.append(" AND t3.SACOPS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoja() != null) {
			where.append(" AND UPPER(t1.SACOJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoja().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoja().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOJA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanror() != null) {
			where.append(" AND t1.SANROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanror() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanror() + "%");
			}
			where.append(" AND t1.SANROR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanran() != null) {
			where.append(" AND t1.SANRAN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanran() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanran() + "%");
			}
			where.append(" AND t1.SANRAN IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafesoli() != null) {
			where.append(" AND t1.SAFESOLI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafesoli() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafesoli() + "%");
			}
			where.append(" AND t1.SAFESOLI IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacot4() != null) {
			where.append(" AND UPPER(t1.SACOT4) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacot4().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacot4().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOT4 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoxj() != null) {
			where.append(" AND UPPER(t1.SACOXJ) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoxj().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoxj().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOXJ IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanodidc() != null) {
			where.append(" AND UPPER(t1.SANODIDC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanodidc().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanodidc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SANODIDC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacolodc() != null) {
			where.append(" AND UPPER(t1.SACOLODC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacolodc().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacolodc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOLODC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanolodc() != null) {
			where.append(" AND UPPER(t1.SANOLODC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanolodc().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanolodc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SANOLODC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacopvdc() != null) {
			where.append(" AND UPPER(t1.SACOPVDC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacopvdc().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacopvdc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOPVDC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacomudc() != null) {
			where.append(" AND UPPER(t1.SACOMUDC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacomudc().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacomudc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOMUDC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrcpdc() != null) {
			where.append(" AND UPPER(t1.SANRCPDC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanrcpdc().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanrcpdc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SANRCPDC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainacuo() != null) {
			where.append(" AND UPPER(t1.SAINACUO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainacuo().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSainacuo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINACUO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoorpr() != null) {
			where.append(" AND UPPER(t1.SACOORPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoorpr().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoorpr().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOORPR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacosere() != null) {
			where.append(" AND UPPER(t1.SACOSERE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacosere().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacosere().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOSERE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacotti() != null) {
			where.append(" AND UPPER(t1.SACOTTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacotti().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacotti().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOTTI IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaintiso() != null) {
			where.append(" AND UPPER(t1.SAINTISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSaintiso().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSaintiso().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINTISO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacnrecl() != null) {
			where.append(" AND t1.SACNRECL like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacnrecl() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacnrecl() + "%");
			}
			where.append(" AND t1.SACNRECL IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSateobrc() != null) {
			where.append(" AND UPPER(t1.SATEOBRC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSateobrc().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSateobrc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SATEOBRC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeinad() != null) {
			where.append(" AND t1.SAFEINAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafeinad() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafeinad() + "%");
			}
			where.append(" AND t1.SAFEINAD IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacot5() != null) {
			where.append(" AND UPPER(t1.SACOT5) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacot5().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacot5().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOT5 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSateinad() != null) {
			where.append(" AND UPPER(t1.SATEINAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSateinad().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSateinad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SATEINAD IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafereit() != null) {
			where.append(" AND t1.SAFEREIT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafereit() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafereit() + "%");
			}
			where.append(" AND t1.SAFEREIT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafetras() != null) {
			where.append(" AND t1.SAFETRAS like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafetras() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafetras() + "%");
			}
			where.append(" AND t1.SAFETRAS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoortr() != null) {
			where.append(" AND UPPER(t1.SACOORTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoortr().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoortr().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOORTR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferett() != null) {
			where.append(" AND t1.SAFERETT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSaferett() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSaferett() + "%");
			}
			where.append(" AND t1.SAFERETT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferets() != null) {
			where.append(" AND t1.SAFERETS like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSaferets() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSaferets() + "%");
			}
			where.append(" AND t1.SAFERETS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafemedi() != null) {
			where.append(" AND t1.SAFEMEDI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafemedi() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafemedi() + "%");
			}
			where.append(" AND t1.SAFEMEDI IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainreme() != null) {
			where.append(" AND UPPER(t1.SAINREME) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainreme().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSainreme().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINREME IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferemt() != null) {
			where.append(" AND t1.SAFEREMT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSaferemt() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSaferemt() + "%");
			}
			where.append(" AND t1.SAFEREMT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafedesi() != null) {
			where.append(" AND t1.SAFEDESI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafedesi() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafedesi() + "%");
			}
			where.append(" AND t1.SAFEDESI IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferedt() != null) {
			where.append(" AND t1.SAFEREDT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSaferedt() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSaferedt() + "%");
			}
			where.append(" AND t1.SAFEREDT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoco() != null) {
			where.append(" AND t1.SAFENOCO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafenoco() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafenoco() + "%");
			}
			where.append(" AND t1.SAFENOCO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferear() != null) {
			where.append(" AND t1.SAFEREAR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSaferear() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSaferear() + "%");
			}
			where.append(" AND t1.SAFEREAR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafedeco() != null) {
			where.append(" AND t1.SAFEDECO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafedeco() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafedeco() + "%");
			}
			where.append(" AND t1.SAFEDECO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarpt() != null) {
			where.append(" AND UPPER(t1.SACOARPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoarpt().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoarpt().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOARPT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencpt() != null) {
			where.append(" AND UPPER(t1.SAINMENCPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmencpt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmencpt().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCPT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencpt() != null) {
			where.append(" AND UPPER(t1.SAINRENCPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrencpt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrencpt().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCPT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarps() != null) {
			where.append(" AND UPPER(t1.SACOARPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoarps().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoarps().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOARPS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencps() != null) {
			where.append(" AND UPPER(t1.SAINMENCPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmencps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmencps().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCPS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencps() != null) {
			where.append(" AND UPPER(t1.SAINRENCPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrencps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrencps().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCPS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoartt() != null) {
			where.append(" AND UPPER(t1.SACOARTT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoartt().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoartt().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOARTT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenctt() != null) {
			where.append(" AND UPPER(t1.SAINMENCTT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmenctt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmenctt().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCTT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenctt() != null) {
			where.append(" AND UPPER(t1.SAINRENCTT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrenctt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrenctt().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCTT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarts() != null) {
			where.append(" AND UPPER(t1.SACOARTS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoarts().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoarts().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOARTS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencts() != null) {
			where.append(" AND UPPER(t1.SAINMENCTS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmencts().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmencts().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCTS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencts() != null) {
			where.append(" AND UPPER(t1.SAINRENCTS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrencts().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrencts().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCTS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoccco() != null) {
			where.append(" AND UPPER(t1.SACOCCCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoccco().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoccco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOCCCO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoardt() != null) {
			where.append(" AND UPPER(t1.SACOARDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoardt().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoardt().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOARDT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencdt() != null) {
			where.append(" AND UPPER(t1.SAINMENCDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmencdt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmencdt().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCDT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencdt() != null) {
			where.append(" AND UPPER(t1.SAINRENCDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrencdt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrencdt().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCDT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoards() != null) {
			where.append(" AND UPPER(t1.SACOARDS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoards().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoards().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOARDS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencds() != null) {
			where.append(" AND UPPER(t1.SAINMENCDS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmencds().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmencds().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCDS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencds() != null) {
			where.append(" AND UPPER(t1.SAINRENCDS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrencds().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrencds().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCDS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacooeco() != null) {
			where.append(" AND UPPER(t1.SACOOECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacooeco().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacooeco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOOECO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoset() != null) {
			where.append(" AND UPPER(t1.SACOSET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoset().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoset().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOSET IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencst() != null) {
			where.append(" AND UPPER(t1.SAINMENCST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmencst().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmencst().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCST IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencst() != null) {
			where.append(" AND UPPER(t1.SAINRENCST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrencst().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrencst().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCST IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoses() != null) {
			where.append(" AND UPPER(t1.SACOSES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoses().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoses().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOSES IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencss() != null) {
			where.append(" AND UPPER(t1.SAINMENCSS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmencss().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmencss().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCSS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencss() != null) {
			where.append(" AND UPPER(t1.SAINRENCSS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrencss().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrencss().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCSS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenct() != null) {
			where.append(" AND UPPER(t1.SAINMENCT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmenct().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmenct().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenct() != null) {
			where.append(" AND UPPER(t1.SAINRENCT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrenct().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrenct().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeciau() != null) {
			where.append(" AND t1.SAFECIAU like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafeciau() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafeciau() + "%");
			}
			where.append(" AND t1.SAFECIAU IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSahrciau() != null) {
			where.append(" AND UPPER(t1.SAHRCIAU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSahrciau().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSahrciau().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAHRCIAU IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanolura() != null) {
			where.append(" AND UPPER(t1.SANOLURA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanolura().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanolura().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SANOLURA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanodira() != null) {
			where.append(" AND UPPER(t1.SANODIRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanodira().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanodira().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SANODIRA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoloa() != null) {
			where.append(" AND UPPER(t1.SACOLOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoloa().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoloa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOLOA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrcpa() != null) {
			where.append(" AND UPPER(t1.SANRCPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanrcpa().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanrcpa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SANRCPA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainsopr() != null) {
			where.append(" AND UPPER(t1.SAINSOPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainsopr().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSainsopr().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINSOPR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaininpr() != null) {
			where.append(" AND UPPER(t1.SAININPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSaininpr().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSaininpr().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAININPR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSateobpr() != null) {
			where.append(" AND UPPER(t1.SATEOBPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSateobpr().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSateobpr().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SATEOBPR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacope1() != null) {
			where.append(" AND UPPER(t1.SACOPE1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacope1().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacope1().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOPE1 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacneupr1() != null) {
			where.append(" AND t1.SACNEUPR1 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacneupr1() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacneupr1() + "%");
			}
			where.append(" AND t1.SACNEUPR1 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacope2() != null) {
			where.append(" AND UPPER(t1.SACOPE2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacope2().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacope2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOPE2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacneupr2() != null) {
			where.append(" AND t1.SACNEUPR2 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacneupr2() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacneupr2() + "%");
			}
			where.append(" AND t1.SACNEUPR2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenopr() != null) {
			where.append(" AND t1.SAFENOPR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafenopr() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafenopr() + "%");
			}
			where.append(" AND t1.SAFENOPR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenp1() != null) {
			where.append(" AND UPPER(t1.SAINMENP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmenp1().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmenp1().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENP1 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenp1() != null) {
			where.append(" AND UPPER(t1.SAINRENP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrenp1().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrenp1().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENP1 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenp2() != null) {
			where.append(" AND UPPER(t1.SAINMENP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmenp2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmenp2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENP2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenp2() != null) {
			where.append(" AND UPPER(t1.SAINRENP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrenp2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrenp2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENP2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenpt() != null) {
			where.append(" AND UPPER(t1.SAINMENPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmenpt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmenpt().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENPT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenpt() != null) {
			where.append(" AND UPPER(t1.SAINRENPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrenpt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrenpt().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENPT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanolup() != null) {
			where.append(" AND UPPER(t1.SANOLUP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanolup().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanolup().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SANOLUP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanodirp() != null) {
			where.append(" AND UPPER(t1.SANODIRP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanodirp().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanodirp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SANODIRP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacolop() != null) {
			where.append(" AND UPPER(t1.SACOLOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacolop().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacolop().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOLOP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrcopop() != null) {
			where.append(" AND UPPER(t1.SANRCOPOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanrcopop().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSanrcopop().toUpperCase() + "%");
			}
			where.append(" AND t1.SANRCOPOP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanopvp() != null) {
			where.append(" AND UPPER(t1.SANOPVP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanopvp().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanopvp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SANOPVP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrtelp() != null) {
			where.append(" AND UPPER(t1.SANRTELP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanrtelp().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanrtelp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SANRTELP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrfaxp() != null) {
			where.append(" AND UPPER(t1.SANRFAXP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanrfaxp().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanrfaxp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SANRFAXP IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferepr() != null) {
			where.append(" AND t1.SAFEREPR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSaferepr() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSaferepr() + "%");
			}
			where.append(" AND t1.SAFEREPR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSahrrepr() != null) {
			where.append(" AND UPPER(t1.SAHRREPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSahrrepr().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSahrrepr().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAHRREPR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarpt2() != null) {
			where.append(" AND UPPER(t1.SACOARPT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoarpt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSacoarpt2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARPT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencpt2() != null) {
			where.append(" AND UPPER(t1.SAINMENCPT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmencpt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmencpt2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCPT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencpt2() != null) {
			where.append(" AND UPPER(t1.SAINRENCPT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrencpt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrencpt2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCPT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarps2() != null) {
			where.append(" AND UPPER(t1.SACOARPS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoarps2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSacoarps2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARPS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencps2() != null) {
			where.append(" AND UPPER(t1.SAINMENCPS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmencps2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmencps2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCPS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencps2() != null) {
			where.append(" AND UPPER(t1.SAINRENCPS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrencps2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrencps2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCPS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoartt2() != null) {
			where.append(" AND UPPER(t1.SACOARTT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoartt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSacoartt2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARTT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenctt2() != null) {
			where.append(" AND UPPER(t1.SAINMENCTT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmenctt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmenctt2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCTT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenctt2() != null) {
			where.append(" AND UPPER(t1.SAINRENCTT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrenctt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrenctt2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCTT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoarts2() != null) {
			where.append(" AND UPPER(t1.SACOARTS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoarts2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSacoarts2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARTS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencts2() != null) {
			where.append(" AND UPPER(t1.SAINMENCTS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmencts2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmencts2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCTS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencts2() != null) {
			where.append(" AND UPPER(t1.SAINRENCTS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrencts2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrencts2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCTS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoccco2() != null) {
			where.append(" AND UPPER(t1.SACOCCCO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoccco2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSacoccco2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOCCCO2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoardt2() != null) {
			where.append(" AND UPPER(t1.SACOARDT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoardt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSacoardt2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARDT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencdt2() != null) {
			where.append(" AND UPPER(t1.SAINMENCDT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmencdt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmencdt2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCDT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencdt2() != null) {
			where.append(" AND UPPER(t1.SAINRENCDT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrencdt2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrencdt2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCDT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoards2() != null) {
			where.append(" AND UPPER(t1.SACOARDS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoards2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSacoards2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARDS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencds2() != null) {
			where.append(" AND UPPER(t1.SAINMENCDS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmencds2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmencds2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCDS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencds2() != null) {
			where.append(" AND UPPER(t1.SAINRENCDS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrencds2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrencds2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCDS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacooeco2() != null) {
			where.append(" AND UPPER(t1.SACOOECO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacooeco2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSacooeco2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOOECO2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoset2() != null) {
			where.append(" AND UPPER(t1.SACOSET2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoset2().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoset2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOSET2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencst2() != null) {
			where.append(" AND UPPER(t1.SAINMENCST2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmencst2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmencst2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCST2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencst2() != null) {
			where.append(" AND UPPER(t1.SAINRENCST2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrencst2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrencst2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCST2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoses2() != null) {
			where.append(" AND UPPER(t1.SACOSES2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoses2().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoses2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOSES2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmencss2() != null) {
			where.append(" AND UPPER(t1.SAINMENCSS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmencss2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmencss2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCSS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrencss2() != null) {
			where.append(" AND UPPER(t1.SAINRENCSS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrencss2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrencss2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCSS2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmenct2() != null) {
			where.append(" AND UPPER(t1.SAINMENCT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmenct2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainmenct2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMENCT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrenct2() != null) {
			where.append(" AND UPPER(t1.SAINRENCT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrenct2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSainrenct2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRENCT2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeciau2() != null) {
			where.append(" AND t1.SAFECIAU2 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafeciau2() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafeciau2() + "%");
			}
			where.append(" AND t1.SAFECIAU2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSahrciau2() != null) {
			where.append(" AND UPPER(t1.SAHRCIAU2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSahrciau2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSahrciau2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAHRCIAU2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanolura2() != null) {
			where.append(" AND UPPER(t1.SANOLURA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanolura2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSanolura2().toUpperCase() + "%");
			}
			where.append(" AND t1.SANOLURA2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanodira2() != null) {
			where.append(" AND UPPER(t1.SANODIRA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanodira2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSanodira2().toUpperCase() + "%");
			}
			where.append(" AND t1.SANODIRA2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoloa2() != null) {
			where.append(" AND UPPER(t1.SACOLOA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoloa2().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacoloa2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOLOA2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrcpa2() != null) {
			where.append(" AND UPPER(t1.SANRCPA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanrcpa2().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanrcpa2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SANRCPA2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafelaud() != null) {
			where.append(" AND t1.SAFELAUD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafelaud() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafelaud() + "%");
			}
			where.append(" AND t1.SAFELAUD IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSateobre() != null) {
			where.append(" AND UPPER(t1.SATEOBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSateobre().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSateobre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SATEOBRE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSatemore() != null) {
			where.append(" AND UPPER(t1.SATEMORE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSatemore().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSatemore().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SATEMORE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacneuil() != null) {
			where.append(" AND t1.SACNEUIL like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacneuil() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacneuil() + "%");
			}
			where.append(" AND t1.SACNEUIL IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainfdla() != null) {
			where.append(" AND UPPER(t1.SAINFDLA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainfdla().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSainfdla().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINFDLA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainvola() != null) {
			where.append(" AND UPPER(t1.SAINVOLA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainvola().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSainvola().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINVOLA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainarnl() != null) {
			where.append(" AND UPPER(t1.SAINARNL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainarnl().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSainarnl().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINARNL IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacot7() != null) {
			where.append(" AND UPPER(t1.SACOT7) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacot7().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacot7().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOT7 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenolt() != null) {
			where.append(" AND t1.SAFENOLT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafenolt() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafenolt() + "%");
			}
			where.append(" AND t1.SAFENOLT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainmelt() != null) {
			where.append(" AND UPPER(t1.SAINMELT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainmelt().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSainmelt().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINMELT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainpubo() != null) {
			where.append(" AND UPPER(t1.SAINPUBO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainpubo().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSainpubo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINPUBO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacota1() != null) {
			where.append(" AND UPPER(t1.SACOTA1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacota1().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacota1().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOTA1 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafesera() != null) {
			where.append(" AND t1.SAFESERA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafesera() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafesera() + "%");
			}
			where.append(" AND t1.SAFESERA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainfdra() != null) {
			where.append(" AND UPPER(t1.SAINFDRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainfdra().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSainfdra().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINFDRA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafepeex() != null) {
			where.append(" AND t1.SAFEPEEX like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafepeex() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafepeex() + "%");
			}
			where.append(" AND t1.SAFEPEEX IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainrain() != null) {
			where.append(" AND UPPER(t1.SAINRAIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainrain().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSainrain().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINRAIN IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSainefin() != null) {
			where.append(" AND UPPER(t1.SAINEFIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSainefin().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSainefin().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINEFIN IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeinef() != null) {
			where.append(" AND t1.SAFEINEF like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafeinef() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafeinef() + "%");
			}
			where.append(" AND t1.SAFEINEF IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafear() != null) {
			where.append(" AND t1.SAFEAR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafear() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafear() + "%");
			}
			where.append(" AND t1.SAFEAR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenode() != null) {
			where.append(" AND t1.SAFENODE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafenode() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafenode() + "%");
			}
			where.append(" AND t1.SAFENODE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferelt() != null) {
			where.append(" AND t1.SAFERELT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSaferelt() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSaferelt() + "%");
			}
			where.append(" AND t1.SAFERELT IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoca() != null) {
			where.append(" AND t1.SAFENOCA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafenoca() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafenoca() + "%");
			}
			where.append(" AND t1.SAFENOCA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoca2() != null) {
			where.append(" AND t1.SAFENOCA2 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafenoca2() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafenoca2() + "%");
			}
			where.append(" AND t1.SAFENOCA2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoar() != null) {
			where.append(" AND t1.SAFENOAR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafenoar() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafenoar() + "%");
			}
			where.append(" AND t1.SAFENOAR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacocccos() != null) {
			where.append(" AND UPPER(t1.SACOCCCOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacocccos().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSacocccos().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOCCCOS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacoccco2s() != null) {
			where.append(" AND UPPER(t1.SACOCCCO2S) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacoccco2s().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSacoccco2s().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOCCCO2S IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacooecos() != null) {
			where.append(" AND UPPER(t1.SACOOECOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacooecos().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSacooecos().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOOECOS IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacooeco2s() != null) {
			where.append(" AND UPPER(t1.SACOOECO2S) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacooeco2s().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitudarbitraje.getSacooeco2s().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOOECO2S IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafesoac() != null) {
			where.append(" AND t1.SAFESOAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafesoac() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafesoac() + "%");
			}
			where.append(" AND t1.SAFESOAC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeenac() != null) {
			where.append(" AND t1.SAFEENAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafeenac() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafeenac() + "%");
			}
			where.append(" AND t1.SAFEENAC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenoac() != null) {
			where.append(" AND t1.SAFENOAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafenoac() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafenoac() + "%");
			}
			where.append(" AND t1.SAFENOAC IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSatefpr1() != null) {
			where.append(" AND UPPER(t1.SATEFPR1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSatefpr1().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSatefpr1().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SATEFPR1 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSatefpr2() != null) {
			where.append(" AND UPPER(t1.SATEFPR2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSatefpr2().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSatefpr2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SATEFPR2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafefpr1() != null) {
			where.append(" AND t1.SAFEFPR1 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafefpr1() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafefpr1() + "%");
			}
			where.append(" AND t1.SAFEFPR1 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafefpr2() != null) {
			where.append(" AND t1.SAFEFPR2 like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafefpr2() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafefpr2() + "%");
			}
			where.append(" AND t1.SAFEFPR2 IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSanrbopl() != null) {
			where.append(" AND UPPER(t1.SANRBOPL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSanrbopl().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSanrbopl().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SANRBOPL IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeenin() != null) {
			where.append(" AND t1.SAFEENIN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafeenin() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafeenin() + "%");
			}
			where.append(" AND t1.SAFEENIN IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacotmd() != null) {
			where.append(" AND UPPER(t1.SACOTMD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacotmd().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacotmd().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOTMD IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeoppe() != null) {
			where.append(" AND t1.SAFEOPPE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafeoppe() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafeoppe() + "%");
			}
			where.append(" AND t1.SAFEOPPE IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafeopla() != null) {
			where.append(" AND t1.SAFEOPLA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafeopla() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafeopla() + "%");
			}
			where.append(" AND t1.SAFEOPLA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafereco() != null) {
			where.append(" AND t1.SAFERECO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafereco() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafereco() + "%");
			}
			where.append(" AND t1.SAFERECO IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenola() != null) {
			where.append(" AND t1.SAFENOLA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafenola() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafenola() + "%");
			}
			where.append(" AND t1.SAFENOLA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafenona() != null) {
			where.append(" AND t1.SAFENONA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafenona() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafenona() + "%");
			}
			where.append(" AND t1.SAFENONA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaferena() != null) {
			where.append(" AND t1.SAFERENA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSaferena() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSaferena() + "%");
			}
			where.append(" AND t1.SAFERENA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSafecona() != null) {
			where.append(" AND t1.SAFECONA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSafecona() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSafecona() + "%");
			}
			where.append(" AND t1.SAFECONA IS NOT NULL");
		}
		if (solicitudarbitraje != null && solicitudarbitraje.getSapub() != null) {
			where.append(" AND UPPER(t1.SAPUB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSapub().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSapub().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAPUB IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSaintica() != null) {
			where.append(" AND UPPER(t1.SAINTICA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSaintica().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSaintica().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SAINTICA IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacotir() != null) {
			where.append(" AND UPPER(t1.SACOTIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacotir().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacotir().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOTIR IS NOT NULL");
		}
		if (solicitudarbitraje != null
				&& solicitudarbitraje.getSacops() != null) {
			where.append(" AND UPPER(t1.SACOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudarbitraje.getSacops().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudarbitraje.getSacops().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SACOPS IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<SolicitudArbitraje>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}
}
