// CHECKSTYLE:OFF
package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Solarb;

/**
 * SolarbDaoImpl generated by UDA, 30-nov-2016 10:44:44.
 * 
 *  
 */

@Repository
@Transactional
public class SolarbDaoImpl implements SolarbDao {

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Solarb> rwMap = new RowMapper<Solarb>() {
		public Solarb mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Solarb solarb = new Solarb(resultSet.getString("SACODIGO"),
					resultSet.getString("SACOHD"),
					resultSet.getString("SACOJA"),
					resultSet.getBigDecimal("SANROR"),
					resultSet.getBigDecimal("SANRAN"),
					resultSet.getDate("SAFESOLI"),
					resultSet.getString("SANODIDC"),
					resultSet.getString("SACOLODC"),
					resultSet.getString("SANOLODC"),
					resultSet.getString("SACOPVDC"),
					resultSet.getString("SACOMUDC"),
					resultSet.getString("SANRCPDC"),
					resultSet.getString("SAINACUO"),
					resultSet.getString("SACOORPR"),
					resultSet.getString("SACOSERE"),
					resultSet.getString("SACOTTI"),
					resultSet.getString("SAINTISO"),
					resultSet.getBigDecimal("SACNRECL"),
					resultSet.getString("SATEOBRC"),
					resultSet.getDate("SAFEINAD"),
					resultSet.getString("SATEINAD"),
					resultSet.getDate("SAFEREIT"),
					resultSet.getDate("SAFETRAS"),
					resultSet.getString("SACOORTR"),
					resultSet.getDate("SAFERETT"),
					resultSet.getDate("SAFERETS"),
					resultSet.getDate("SAFEMEDI"),
					resultSet.getString("SAINREME"),
					resultSet.getDate("SAFEREMT"),
					resultSet.getDate("SAFEDESI"),
					resultSet.getDate("SAFEREDT"),
					resultSet.getDate("SAFENOCO"),
					resultSet.getDate("SAFEREAR"),
					resultSet.getDate("SAFEDECO"),
					resultSet.getString("SACOARPT"),
					resultSet.getString("SAINMENCPT"),
					resultSet.getString("SAINRENCPT"),
					resultSet.getString("SACOARPS"),
					resultSet.getString("SAINMENCPS"),
					resultSet.getString("SAINRENCPS"),
					resultSet.getString("SACOARTT"),
					resultSet.getString("SAINMENCTT"),
					resultSet.getString("SAINRENCTT"),
					resultSet.getString("SACOARTS"),
					resultSet.getString("SAINMENCTS"),
					resultSet.getString("SAINRENCTS"),
					resultSet.getString("SACOCCCO"),
					resultSet.getString("SACOARDT"),
					resultSet.getString("SAINMENCDT"),
					resultSet.getString("SAINRENCDT"),
					resultSet.getString("SACOARDS"),
					resultSet.getString("SAINMENCDS"),
					resultSet.getString("SAINRENCDS"),
					resultSet.getString("SACOOECO"),
					resultSet.getString("SAINMENCST"),
					resultSet.getString("SAINRENCST"),
					resultSet.getString("SAINMENCSS"),
					resultSet.getString("SAINRENCSS"),
					resultSet.getString("SAINMENCT"),
					resultSet.getString("SAINRENCT"),
					resultSet.getDate("SAFECIAU"),
					resultSet.getString("SAHRCIAU"),
					resultSet.getString("SANOLURA"),
					resultSet.getString("SANODIRA"),
					resultSet.getString("SACOLOA"),
					resultSet.getString("SANRCPA"),
					resultSet.getString("SAINSOPR"),
					resultSet.getString("SAININPR"),
					resultSet.getString("SATEOBPR"),
					resultSet.getString("SACOPE1"),
					resultSet.getBigDecimal("SACNEUPR1"),
					resultSet.getString("SACOPE2"),
					resultSet.getBigDecimal("SACNEUPR2"),
					resultSet.getDate("SAFENOPR"),
					resultSet.getString("SAINMENP1"),
					resultSet.getString("SAINRENP1"),
					resultSet.getString("SAINMENP2"),
					resultSet.getString("SAINRENP2"),
					resultSet.getString("SAINMENPT"),
					resultSet.getString("SAINRENPT"),
					resultSet.getString("SANOLUP"),
					resultSet.getString("SANODIRP"),
					resultSet.getString("SACOLOP"),
					resultSet.getString("SANRCOPOP"),
					resultSet.getString("SANOPVP"),
					resultSet.getString("SANRTELP"),
					resultSet.getString("SANRFAXP"),
					resultSet.getDate("SAFEREPR"),
					resultSet.getString("SAHRREPR"),
					resultSet.getString("SACOARPT2"),
					resultSet.getString("SAINMENCPT2"),
					resultSet.getString("SAINRENCPT2"),
					resultSet.getString("SACOARPS2"),
					resultSet.getString("SAINMENCPS2"),
					resultSet.getString("SAINRENCPS2"),
					resultSet.getString("SACOARTT2"),
					resultSet.getString("SAINMENCTT2"),
					resultSet.getString("SAINRENCTT2"),
					resultSet.getString("SACOARTS2"),
					resultSet.getString("SAINMENCTS2"),
					resultSet.getString("SAINRENCTS2"),
					resultSet.getString("SACOCCCO2"),
					resultSet.getString("SACOARDT2"),
					resultSet.getString("SAINMENCDT2"),
					resultSet.getString("SAINRENCDT2"),
					resultSet.getString("SACOARDS2"),
					resultSet.getString("SAINMENCDS2"),
					resultSet.getString("SAINRENCDS2"),
					resultSet.getString("SACOOECO2"),
					resultSet.getString("SAINMENCST2"),
					resultSet.getString("SAINRENCST2"),
					resultSet.getString("SAINMENCSS2"),
					resultSet.getString("SAINRENCSS2"),
					resultSet.getString("SAINMENCT2"),
					resultSet.getString("SAINRENCT2"),
					resultSet.getDate("SAFECIAU2"),
					resultSet.getString("SAHRCIAU2"),
					resultSet.getString("SANOLURA2"),
					resultSet.getString("SANODIRA2"),
					resultSet.getString("SACOLOA2"),
					resultSet.getString("SANRCPA2"),
					resultSet.getDate("SAFELAUD"),
					resultSet.getString("SATEOBRE"),
					resultSet.getString("SATEMORE"),
					resultSet.getBigDecimal("SACNEUIL"),
					resultSet.getString("SAINFDLA"),
					resultSet.getString("SAINVOLA"),
					resultSet.getString("SAINARNL"),
					resultSet.getDate("SAFENOLT"),
					resultSet.getString("SAINMELT"),
					resultSet.getString("SAINPUBO"),
					resultSet.getString("SACOTA1"),
					resultSet.getDate("SAFESERA"),
					resultSet.getString("SAINFDRA"),
					resultSet.getDate("SAFEPEEX"),
					resultSet.getString("SAINRAIN"),
					resultSet.getString("SAINEFIN"),
					resultSet.getDate("SAFEINEF"), resultSet.getDate("SAFEAR"),
					resultSet.getDate("SAFENODE"),
					resultSet.getDate("SAFERELT"),
					resultSet.getDate("SAFENOCA"),
					resultSet.getDate("SAFENOCA2"),
					resultSet.getDate("SAFENOAR"),
					resultSet.getString("SACOCCCOS"),
					resultSet.getString("SACOCCCO2S"),
					resultSet.getString("SACOOECOS"),
					resultSet.getString("SACOOECO2S"),
					resultSet.getDate("SAFESOAC"),
					resultSet.getDate("SAFEENAC"),
					resultSet.getDate("SAFENOAC"),
					resultSet.getString("SATEFPR1"),
					resultSet.getString("SATEFPR2"),
					resultSet.getDate("SAFEFPR1"),
					resultSet.getDate("SAFEFPR2"),
					resultSet.getString("SANRBOPL"),
					resultSet.getDate("SAFEENIN"),
					resultSet.getDate("SAFEOPPE"),
					resultSet.getDate("SAFEOPLA"),
					resultSet.getDate("SAFERECO"),
					resultSet.getDate("SAFENOLA"),
					resultSet.getDate("SAFENONA"),
					resultSet.getDate("SAFERENA"),
					resultSet.getDate("SAFECONA"),
					resultSet.getString("SAPUB"),
					resultSet.getString("SAINTICA"),
					resultSet.getString("SACOTIR"),
					resultSet.getString("SACOPS"),
					resultSet.getString("SACOSET2"),
					resultSet.getString("SACOSET"),
					resultSet.getString("SACOSAAC"),
					resultSet.getString("SACOSES2"),
					resultSet.getString("SACOSES"));

			return solarb;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Finds a List of rows in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Solarb> findAll(Solarb solarb, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SACODIGO SACODIGO,t1.SACOHD SACOHD,t1.SACOJA SACOJA,t1.SANROR SANROR,t1.SANRAN SANRAN,t1.SAFESOLI SAFESOLI,t1.SANODIDC SANODIDC,t1.SACOLODC SACOLODC,t1.SANOLODC SANOLODC,t1.SACOPVDC SACOPVDC,t1.SACOMUDC SACOMUDC,t1.SANRCPDC SANRCPDC,t1.SAINACUO SAINACUO,t1.SACOORPR SACOORPR,t1.SACOSERE SACOSERE,t1.SACOTTI SACOTTI,t1.SAINTISO SAINTISO,t1.SACNRECL SACNRECL,t1.SATEOBRC SATEOBRC,t1.SAFEINAD SAFEINAD,t1.SATEINAD SATEINAD,t1.SAFEREIT SAFEREIT,t1.SAFETRAS SAFETRAS,t1.SACOORTR SACOORTR,t1.SAFERETT SAFERETT,t1.SAFERETS SAFERETS,t1.SAFEMEDI SAFEMEDI,t1.SAINREME SAINREME,t1.SAFEREMT SAFEREMT,t1.SAFEDESI SAFEDESI,t1.SAFEREDT SAFEREDT,t1.SAFENOCO SAFENOCO,t1.SAFEREAR SAFEREAR,t1.SAFEDECO SAFEDECO,t1.SACOARPT SACOARPT,t1.SAINMENCPT SAINMENCPT,t1.SAINRENCPT SAINRENCPT,t1.SACOARPS SACOARPS,t1.SAINMENCPS SAINMENCPS,t1.SAINRENCPS SAINRENCPS,t1.SACOARTT SACOARTT,t1.SAINMENCTT SAINMENCTT,t1.SAINRENCTT SAINRENCTT,t1.SACOARTS SACOARTS,t1.SAINMENCTS SAINMENCTS,t1.SAINRENCTS SAINRENCTS,t1.SACOCCCO SACOCCCO,t1.SACOARDT SACOARDT,t1.SAINMENCDT SAINMENCDT,t1.SAINRENCDT SAINRENCDT,t1.SACOARDS SACOARDS,t1.SAINMENCDS SAINMENCDS,t1.SAINRENCDS SAINRENCDS,t1.SACOOECO SACOOECO,t1.SAINMENCST SAINMENCST,t1.SAINRENCST SAINRENCST,t1.SAINMENCSS SAINMENCSS,t1.SAINRENCSS SAINRENCSS,t1.SAINMENCT SAINMENCT,t1.SAINRENCT SAINRENCT,t1.SAFECIAU SAFECIAU,t1.SAHRCIAU SAHRCIAU,t1.SANOLURA SANOLURA,t1.SANODIRA SANODIRA,t1.SACOLOA SACOLOA,t1.SANRCPA SANRCPA,t1.SAINSOPR SAINSOPR,t1.SAININPR SAININPR,t1.SATEOBPR SATEOBPR,t1.SACOPE1 SACOPE1,t1.SACNEUPR1 SACNEUPR1,t1.SACOPE2 SACOPE2,t1.SACNEUPR2 SACNEUPR2,t1.SAFENOPR SAFENOPR,t1.SAINMENP1 SAINMENP1,t1.SAINRENP1 SAINRENP1,t1.SAINMENP2 SAINMENP2,t1.SAINRENP2 SAINRENP2,t1.SAINMENPT SAINMENPT,t1.SAINRENPT SAINRENPT,t1.SANOLUP SANOLUP,t1.SANODIRP SANODIRP,t1.SACOLOP SACOLOP,t1.SANRCOPOP SANRCOPOP,t1.SANOPVP SANOPVP,t1.SANRTELP SANRTELP,t1.SANRFAXP SANRFAXP,t1.SAFEREPR SAFEREPR,t1.SAHRREPR SAHRREPR,t1.SACOARPT2 SACOARPT2,t1.SAINMENCPT2 SAINMENCPT2,t1.SAINRENCPT2 SAINRENCPT2,t1.SACOARPS2 SACOARPS2,t1.SAINMENCPS2 SAINMENCPS2,t1.SAINRENCPS2 SAINRENCPS2,t1.SACOARTT2 SACOARTT2,t1.SAINMENCTT2 SAINMENCTT2,t1.SAINRENCTT2 SAINRENCTT2,t1.SACOARTS2 SACOARTS2,t1.SAINMENCTS2 SAINMENCTS2,t1.SAINRENCTS2 SAINRENCTS2,t1.SACOCCCO2 SACOCCCO2,t1.SACOARDT2 SACOARDT2,t1.SAINMENCDT2 SAINMENCDT2,t1.SAINRENCDT2 SAINRENCDT2,t1.SACOARDS2 SACOARDS2,t1.SAINMENCDS2 SAINMENCDS2,t1.SAINRENCDS2 SAINRENCDS2,t1.SACOOECO2 SACOOECO2,t1.SAINMENCST2 SAINMENCST2,t1.SAINRENCST2 SAINRENCST2,t1.SAINMENCSS2 SAINMENCSS2,t1.SAINRENCSS2 SAINRENCSS2,t1.SAINMENCT2 SAINMENCT2,t1.SAINRENCT2 SAINRENCT2,t1.SAFECIAU2 SAFECIAU2,t1.SAHRCIAU2 SAHRCIAU2,t1.SANOLURA2 SANOLURA2,t1.SANODIRA2 SANODIRA2,t1.SACOLOA2 SACOLOA2,t1.SANRCPA2 SANRCPA2,t1.SAFELAUD SAFELAUD,t1.SATEOBRE SATEOBRE,t1.SATEMORE SATEMORE,t1.SACNEUIL SACNEUIL,t1.SAINFDLA SAINFDLA,t1.SAINVOLA SAINVOLA,t1.SAINARNL SAINARNL,t1.SAFENOLT SAFENOLT,t1.SAINMELT SAINMELT,t1.SAINPUBO SAINPUBO,t1.SACOTA1 SACOTA1,t1.SAFESERA SAFESERA,t1.SAINFDRA SAINFDRA,t1.SAFEPEEX SAFEPEEX,t1.SAINRAIN SAINRAIN,t1.SAINEFIN SAINEFIN,t1.SAFEINEF SAFEINEF,t1.SAFEAR SAFEAR,t1.SAFENODE SAFENODE,t1.SAFERELT SAFERELT,t1.SAFENOCA SAFENOCA,t1.SAFENOCA2 SAFENOCA2,t1.SAFENOAR SAFENOAR,t1.SACOCCCOS SACOCCCOS,t1.SACOCCCO2S SACOCCCO2S,t1.SACOOECOS SACOOECOS,t1.SACOOECO2S SACOOECO2S,t1.SAFESOAC SAFESOAC,t1.SAFEENAC SAFEENAC,t1.SAFENOAC SAFENOAC,t1.SATEFPR1 SATEFPR1,t1.SATEFPR2 SATEFPR2,t1.SAFEFPR1 SAFEFPR1,t1.SAFEFPR2 SAFEFPR2,t1.SANRBOPL SANRBOPL,t1.SAFEENIN SAFEENIN,t1.SAFEOPPE SAFEOPPE,t1.SAFEOPLA SAFEOPLA,t1.SAFERECO SAFERECO,t1.SAFENOLA SAFENOLA,t1.SAFENONA SAFENONA,t1.SAFERENA SAFERENA,t1.SAFECONA SAFECONA,t1.SAPUB SAPUB,t1.SAINTICA SAINTICA,t1.SACOTIR SACOTIR,t1.SACOPS SACOPS,t1.SACOSAAC SACOSAAC,t1.SACOSET2 SACOSET2, t1.SACOSET SACOSET, t1.SACOSES2 SACOSES2,t1.SACOSES SACOSES, t2.XJCODIGO ZDDESTADXJCODIGO,t2.XJIDEX ZDDESTADXJIDEX,t2.XJNOMBRE ZDDESTADXJNOMBRE,t2.XJVALOR ZDDESTADXJVALOR,t3.T5CODIGO TCMOTINAT5CODIGO,t3.T5NOMBRE TCMOTINAT5NOMBRE,t3.T5NOMBREEU TCMOTINAT5NOMBREEU,t4.T7CODIGO TCMONOLAT7CODIGO,t4.T7NOMBRE TCMONOLAT7NOMBRE,t5.TMDCODIGO TCMOTDESTMDCODIGO,t5.TMDNOMBRE TCMOTDESTMDNOMBRE,t7.T4CODIGO TCLUGAUDT4CODIGO,t7.T4NOMBRE TCLUGAUDT4NOMBRE,t7.T4NOMBREEU TCLUGAUDT4NOMBREEU ");
		query.append(" ,t8.EXCODIGO EXCODIGO, t8.EXFCODIGO EXFCODIGO ");
		query.append("FROM SOLARB t1 ,ZDDESTAD t2 ,TCMOTINA t3 ,TCMONOLA t4 ,TCMOTDES t5 , TCLUGAUD t7, ARBEXP t8  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(solarb);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SACODIGO=t8.EXCODIGO(+) AND t1.SACOXJ= t2.XJCODIGO(+) AND t1.SACOT5= t3.T5CODIGO(+) AND t1.SACOT7= t4.T7CODIGO(+) AND t1.SACOTMD= t5.TMDCODIGO(+) AND t1.SACOT4= t7.T4CODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Solarb>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Solarb entity
	 * 
	 * @param solarb
	 *            Solarb Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */

	private Map<String, ?> getWhereMap(Solarb solarb) {

		StringBuilder where = new StringBuilder(
				SolarbDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (solarb != null && solarb.getSacodigo() != null) {
			where.append(" AND t1.SACODIGO = ?");
			params.add(solarb.getSacodigo());
		}
		if (solarb != null && solarb.getSacoset2() != null) {
			where.append(" AND t1.SACOSET2 = ?");
			params.add(solarb.getSacoset2());
		}
		if (solarb != null && solarb.getSacoset() != null) {
			where.append(" AND t1.SACOSET = ?");
			params.add(solarb.getSacoset());
		}
		if (solarb != null && solarb.getSacoses2() != null) {
			where.append(" AND t1.SACOSES2 = ?");
			params.add(solarb.getSacoses2());
		}
		if (solarb != null && solarb.getSacoses() != null) {
			where.append(" AND t1.SACOSES = ?");
			params.add(solarb.getSacoses());
		}
		if (solarb != null && solarb.getSacohd() != null) {
			where.append(" AND t1.SACOHD = ?");
			params.add(solarb.getSacohd());
		}
		if (solarb != null && solarb.getSacoja() != null) {
			where.append(" AND t1.SACOJA = ?");
			params.add(solarb.getSacoja());
		}
		if (solarb != null && solarb.getSanror() != null) {
			where.append(" AND t1.SANROR = ?");
			params.add(solarb.getSanror());
		}
		if (solarb != null && solarb.getSanran() != null) {
			where.append(" AND t1.SANRAN = ?");
			params.add(solarb.getSanran());
		}
		if (solarb != null && solarb.getSafesoli() != null) {
			where.append(" AND t1.SAFESOLI = ?");
			params.add(solarb.getSafesoli());
		}
		if (solarb != null && solarb.getSanodidc() != null) {
			where.append(" AND t1.SANODIDC = ?");
			params.add(solarb.getSanodidc());
		}
		if (solarb != null && solarb.getSacolodc() != null) {
			where.append(" AND t1.SACOLODC = ?");
			params.add(solarb.getSacolodc());
		}
		if (solarb != null && solarb.getSanolodc() != null) {
			where.append(" AND t1.SANOLODC = ?");
			params.add(solarb.getSanolodc());
		}
		if (solarb != null && solarb.getSacopvdc() != null) {
			where.append(" AND t1.SACOPVDC = ?");
			params.add(solarb.getSacopvdc());
		}
		if (solarb != null && solarb.getSacomudc() != null) {
			where.append(" AND t1.SACOMUDC = ?");
			params.add(solarb.getSacomudc());
		}
		if (solarb != null && solarb.getSanrcpdc() != null) {
			where.append(" AND t1.SANRCPDC = ?");
			params.add(solarb.getSanrcpdc());
		}
		if (solarb != null && solarb.getSainacuo() != null) {
			where.append(" AND t1.SAINACUO = ?");
			params.add(solarb.getSainacuo());
		}
		if (solarb != null && solarb.getSacoorpr() != null) {
			where.append(" AND t1.SACOORPR = ?");
			params.add(solarb.getSacoorpr());
		}
		if (solarb != null && solarb.getSacosere() != null) {
			where.append(" AND t1.SACOSERE = ?");
			params.add(solarb.getSacosere());
		}
		if (solarb != null && solarb.getSacotti() != null) {
			where.append(" AND t1.SACOTTI = ?");
			params.add(solarb.getSacotti());
		}
		if (solarb != null && solarb.getSaintiso() != null) {
			where.append(" AND t1.SAINTISO = ?");
			params.add(solarb.getSaintiso());
		}
		if (solarb != null && solarb.getSacnrecl() != null) {
			where.append(" AND t1.SACNRECL = ?");
			params.add(solarb.getSacnrecl());
		}
		if (solarb != null && solarb.getSateobrc() != null) {
			where.append(" AND t1.SATEOBRC = ?");
			params.add(solarb.getSateobrc());
		}
		if (solarb != null && solarb.getSafeinad() != null) {
			where.append(" AND t1.SAFEINAD = ?");
			params.add(solarb.getSafeinad());
		}
		if (solarb != null && solarb.getSateinad() != null) {
			where.append(" AND t1.SATEINAD = ?");
			params.add(solarb.getSateinad());
		}
		if (solarb != null && solarb.getSafereit() != null) {
			where.append(" AND t1.SAFEREIT = ?");
			params.add(solarb.getSafereit());
		}
		if (solarb != null && solarb.getSafetras() != null) {
			where.append(" AND t1.SAFETRAS = ?");
			params.add(solarb.getSafetras());
		}
		if (solarb != null && solarb.getSacoortr() != null) {
			where.append(" AND t1.SACOORTR = ?");
			params.add(solarb.getSacoortr());
		}
		if (solarb != null && solarb.getSaferett() != null) {
			where.append(" AND t1.SAFERETT = ?");
			params.add(solarb.getSaferett());
		}
		if (solarb != null && solarb.getSaferets() != null) {
			where.append(" AND t1.SAFERETS = ?");
			params.add(solarb.getSaferets());
		}
		if (solarb != null && solarb.getSafemedi() != null) {
			where.append(" AND t1.SAFEMEDI = ?");
			params.add(solarb.getSafemedi());
		}
		if (solarb != null && solarb.getSainreme() != null) {
			where.append(" AND t1.SAINREME = ?");
			params.add(solarb.getSainreme());
		}
		if (solarb != null && solarb.getSaferemt() != null) {
			where.append(" AND t1.SAFEREMT = ?");
			params.add(solarb.getSaferemt());
		}
		if (solarb != null && solarb.getSafedesi() != null) {
			where.append(" AND t1.SAFEDESI = ?");
			params.add(solarb.getSafedesi());
		}
		if (solarb != null && solarb.getSaferedt() != null) {
			where.append(" AND t1.SAFEREDT = ?");
			params.add(solarb.getSaferedt());
		}
		if (solarb != null && solarb.getSafenoco() != null) {
			where.append(" AND t1.SAFENOCO = ?");
			params.add(solarb.getSafenoco());
		}
		if (solarb != null && solarb.getSaferear() != null) {
			where.append(" AND t1.SAFEREAR = ?");
			params.add(solarb.getSaferear());
		}
		if (solarb != null && solarb.getSafedeco() != null) {
			where.append(" AND t1.SAFEDECO = ?");
			params.add(solarb.getSafedeco());
		}
		if (solarb != null && solarb.getSacoarpt() != null) {
			where.append(" AND t1.SACOARPT = ?");
			params.add(solarb.getSacoarpt());
		}
		if (solarb != null && solarb.getSainmencpt() != null) {
			where.append(" AND t1.SAINMENCPT = ?");
			params.add(solarb.getSainmencpt());
		}
		if (solarb != null && solarb.getSainrencpt() != null) {
			where.append(" AND t1.SAINRENCPT = ?");
			params.add(solarb.getSainrencpt());
		}
		if (solarb != null && solarb.getSacoarps() != null) {
			where.append(" AND t1.SACOARPS = ?");
			params.add(solarb.getSacoarps());
		}
		if (solarb != null && solarb.getSainmencps() != null) {
			where.append(" AND t1.SAINMENCPS = ?");
			params.add(solarb.getSainmencps());
		}
		if (solarb != null && solarb.getSainrencps() != null) {
			where.append(" AND t1.SAINRENCPS = ?");
			params.add(solarb.getSainrencps());
		}
		if (solarb != null && solarb.getSacoartt() != null) {
			where.append(" AND t1.SACOARTT = ?");
			params.add(solarb.getSacoartt());
		}
		if (solarb != null && solarb.getSainmenctt() != null) {
			where.append(" AND t1.SAINMENCTT = ?");
			params.add(solarb.getSainmenctt());
		}
		if (solarb != null && solarb.getSainrenctt() != null) {
			where.append(" AND t1.SAINRENCTT = ?");
			params.add(solarb.getSainrenctt());
		}
		if (solarb != null && solarb.getSacoarts() != null) {
			where.append(" AND t1.SACOARTS = ?");
			params.add(solarb.getSacoarts());
		}
		if (solarb != null && solarb.getSainmencts() != null) {
			where.append(" AND t1.SAINMENCTS = ?");
			params.add(solarb.getSainmencts());
		}
		if (solarb != null && solarb.getSainrencts() != null) {
			where.append(" AND t1.SAINRENCTS = ?");
			params.add(solarb.getSainrencts());
		}
		if (solarb != null && solarb.getSacoccco() != null) {
			where.append(" AND t1.SACOCCCO = ?");
			params.add(solarb.getSacoccco());
		}
		if (solarb != null && solarb.getSacoardt() != null) {
			where.append(" AND t1.SACOARDT = ?");
			params.add(solarb.getSacoardt());
		}
		if (solarb != null && solarb.getSainmencdt() != null) {
			where.append(" AND t1.SAINMENCDT = ?");
			params.add(solarb.getSainmencdt());
		}
		if (solarb != null && solarb.getSainrencdt() != null) {
			where.append(" AND t1.SAINRENCDT = ?");
			params.add(solarb.getSainrencdt());
		}
		if (solarb != null && solarb.getSacoards() != null) {
			where.append(" AND t1.SACOARDS = ?");
			params.add(solarb.getSacoards());
		}
		if (solarb != null && solarb.getSainmencds() != null) {
			where.append(" AND t1.SAINMENCDS = ?");
			params.add(solarb.getSainmencds());
		}
		if (solarb != null && solarb.getSainrencds() != null) {
			where.append(" AND t1.SAINRENCDS = ?");
			params.add(solarb.getSainrencds());
		}
		if (solarb != null && solarb.getSacooeco() != null) {
			where.append(" AND t1.SACOOECO = ?");
			params.add(solarb.getSacooeco());
		}
		if (solarb != null && solarb.getSainmencst() != null) {
			where.append(" AND t1.SAINMENCST = ?");
			params.add(solarb.getSainmencst());
		}
		if (solarb != null && solarb.getSainrencst() != null) {
			where.append(" AND t1.SAINRENCST = ?");
			params.add(solarb.getSainrencst());
		}
		if (solarb != null && solarb.getSainmencss() != null) {
			where.append(" AND t1.SAINMENCSS = ?");
			params.add(solarb.getSainmencss());
		}
		if (solarb != null && solarb.getSainrencss() != null) {
			where.append(" AND t1.SAINRENCSS = ?");
			params.add(solarb.getSainrencss());
		}
		if (solarb != null && solarb.getSainmenct() != null) {
			where.append(" AND t1.SAINMENCT = ?");
			params.add(solarb.getSainmenct());
		}
		if (solarb != null && solarb.getSainrenct() != null) {
			where.append(" AND t1.SAINRENCT = ?");
			params.add(solarb.getSainrenct());
		}
		if (solarb != null && solarb.getSafeciau() != null) {
			where.append(" AND t1.SAFECIAU = ?");
			params.add(solarb.getSafeciau());
		}
		if (solarb != null && solarb.getSahrciau() != null) {
			where.append(" AND t1.SAHRCIAU = ?");
			params.add(solarb.getSahrciau());
		}
		if (solarb != null && solarb.getSanolura() != null) {
			where.append(" AND t1.SANOLURA = ?");
			params.add(solarb.getSanolura());
		}
		if (solarb != null && solarb.getSanodira() != null) {
			where.append(" AND t1.SANODIRA = ?");
			params.add(solarb.getSanodira());
		}
		if (solarb != null && solarb.getSacoloa() != null) {
			where.append(" AND t1.SACOLOA = ?");
			params.add(solarb.getSacoloa());
		}
		if (solarb != null && solarb.getSanrcpa() != null) {
			where.append(" AND t1.SANRCPA = ?");
			params.add(solarb.getSanrcpa());
		}
		if (solarb != null && solarb.getSainsopr() != null) {
			where.append(" AND t1.SAINSOPR = ?");
			params.add(solarb.getSainsopr());
		}
		if (solarb != null && solarb.getSaininpr() != null) {
			where.append(" AND t1.SAININPR = ?");
			params.add(solarb.getSaininpr());
		}
		if (solarb != null && solarb.getSateobpr() != null) {
			where.append(" AND t1.SATEOBPR = ?");
			params.add(solarb.getSateobpr());
		}
		if (solarb != null && solarb.getSacope1() != null) {
			where.append(" AND t1.SACOPE1 = ?");
			params.add(solarb.getSacope1());
		}
		if (solarb != null && solarb.getSacneupr1() != null) {
			where.append(" AND t1.SACNEUPR1 = ?");
			params.add(solarb.getSacneupr1());
		}
		if (solarb != null && solarb.getSacope2() != null) {
			where.append(" AND t1.SACOPE2 = ?");
			params.add(solarb.getSacope2());
		}
		if (solarb != null && solarb.getSacneupr2() != null) {
			where.append(" AND t1.SACNEUPR2 = ?");
			params.add(solarb.getSacneupr2());
		}
		if (solarb != null && solarb.getSafenopr() != null) {
			where.append(" AND t1.SAFENOPR = ?");
			params.add(solarb.getSafenopr());
		}
		if (solarb != null && solarb.getSainmenp1() != null) {
			where.append(" AND t1.SAINMENP1 = ?");
			params.add(solarb.getSainmenp1());
		}
		if (solarb != null && solarb.getSainrenp1() != null) {
			where.append(" AND t1.SAINRENP1 = ?");
			params.add(solarb.getSainrenp1());
		}
		if (solarb != null && solarb.getSainmenp2() != null) {
			where.append(" AND t1.SAINMENP2 = ?");
			params.add(solarb.getSainmenp2());
		}
		if (solarb != null && solarb.getSainrenp2() != null) {
			where.append(" AND t1.SAINRENP2 = ?");
			params.add(solarb.getSainrenp2());
		}
		if (solarb != null && solarb.getSainmenpt() != null) {
			where.append(" AND t1.SAINMENPT = ?");
			params.add(solarb.getSainmenpt());
		}
		if (solarb != null && solarb.getSainrenpt() != null) {
			where.append(" AND t1.SAINRENPT = ?");
			params.add(solarb.getSainrenpt());
		}
		if (solarb != null && solarb.getSanolup() != null) {
			where.append(" AND t1.SANOLUP = ?");
			params.add(solarb.getSanolup());
		}
		if (solarb != null && solarb.getSanodirp() != null) {
			where.append(" AND t1.SANODIRP = ?");
			params.add(solarb.getSanodirp());
		}
		if (solarb != null && solarb.getSacolop() != null) {
			where.append(" AND t1.SACOLOP = ?");
			params.add(solarb.getSacolop());
		}
		if (solarb != null && solarb.getSanrcopop() != null) {
			where.append(" AND t1.SANRCOPOP = ?");
			params.add(solarb.getSanrcopop());
		}
		if (solarb != null && solarb.getSanopvp() != null) {
			where.append(" AND t1.SANOPVP = ?");
			params.add(solarb.getSanopvp());
		}
		if (solarb != null && solarb.getSanrtelp() != null) {
			where.append(" AND t1.SANRTELP = ?");
			params.add(solarb.getSanrtelp());
		}
		if (solarb != null && solarb.getSanrfaxp() != null) {
			where.append(" AND t1.SANRFAXP = ?");
			params.add(solarb.getSanrfaxp());
		}
		if (solarb != null && solarb.getSaferepr() != null) {
			where.append(" AND t1.SAFEREPR = ?");
			params.add(solarb.getSaferepr());
		}
		if (solarb != null && solarb.getSahrrepr() != null) {
			where.append(" AND t1.SAHRREPR = ?");
			params.add(solarb.getSahrrepr());
		}
		if (solarb != null && solarb.getSacoarpt2() != null) {
			where.append(" AND t1.SACOARPT2 = ?");
			params.add(solarb.getSacoarpt2());
		}
		if (solarb != null && solarb.getSainmencpt2() != null) {
			where.append(" AND t1.SAINMENCPT2 = ?");
			params.add(solarb.getSainmencpt2());
		}
		if (solarb != null && solarb.getSainrencpt2() != null) {
			where.append(" AND t1.SAINRENCPT2 = ?");
			params.add(solarb.getSainrencpt2());
		}
		if (solarb != null && solarb.getSacoarps2() != null) {
			where.append(" AND t1.SACOARPS2 = ?");
			params.add(solarb.getSacoarps2());
		}
		if (solarb != null && solarb.getSainmencps2() != null) {
			where.append(" AND t1.SAINMENCPS2 = ?");
			params.add(solarb.getSainmencps2());
		}
		if (solarb != null && solarb.getSainrencps2() != null) {
			where.append(" AND t1.SAINRENCPS2 = ?");
			params.add(solarb.getSainrencps2());
		}
		if (solarb != null && solarb.getSacoartt2() != null) {
			where.append(" AND t1.SACOARTT2 = ?");
			params.add(solarb.getSacoartt2());
		}
		if (solarb != null && solarb.getSainmenctt2() != null) {
			where.append(" AND t1.SAINMENCTT2 = ?");
			params.add(solarb.getSainmenctt2());
		}
		if (solarb != null && solarb.getSainrenctt2() != null) {
			where.append(" AND t1.SAINRENCTT2 = ?");
			params.add(solarb.getSainrenctt2());
		}
		if (solarb != null && solarb.getSacoarts2() != null) {
			where.append(" AND t1.SACOARTS2 = ?");
			params.add(solarb.getSacoarts2());
		}
		if (solarb != null && solarb.getSainmencts2() != null) {
			where.append(" AND t1.SAINMENCTS2 = ?");
			params.add(solarb.getSainmencts2());
		}
		if (solarb != null && solarb.getSainrencts2() != null) {
			where.append(" AND t1.SAINRENCTS2 = ?");
			params.add(solarb.getSainrencts2());
		}
		if (solarb != null && solarb.getSacoccco2() != null) {
			where.append(" AND t1.SACOCCCO2 = ?");
			params.add(solarb.getSacoccco2());
		}
		if (solarb != null && solarb.getSacoardt2() != null) {
			where.append(" AND t1.SACOARDT2 = ?");
			params.add(solarb.getSacoardt2());
		}
		if (solarb != null && solarb.getSainmencdt2() != null) {
			where.append(" AND t1.SAINMENCDT2 = ?");
			params.add(solarb.getSainmencdt2());
		}
		if (solarb != null && solarb.getSainrencdt2() != null) {
			where.append(" AND t1.SAINRENCDT2 = ?");
			params.add(solarb.getSainrencdt2());
		}
		if (solarb != null && solarb.getSacoards2() != null) {
			where.append(" AND t1.SACOARDS2 = ?");
			params.add(solarb.getSacoards2());
		}
		if (solarb != null && solarb.getSainmencds2() != null) {
			where.append(" AND t1.SAINMENCDS2 = ?");
			params.add(solarb.getSainmencds2());
		}
		if (solarb != null && solarb.getSainrencds2() != null) {
			where.append(" AND t1.SAINRENCDS2 = ?");
			params.add(solarb.getSainrencds2());
		}
		if (solarb != null && solarb.getSacooeco2() != null) {
			where.append(" AND t1.SACOOECO2 = ?");
			params.add(solarb.getSacooeco2());
		}
		if (solarb != null && solarb.getSainmencst2() != null) {
			where.append(" AND t1.SAINMENCST2 = ?");
			params.add(solarb.getSainmencst2());
		}
		if (solarb != null && solarb.getSainrencst2() != null) {
			where.append(" AND t1.SAINRENCST2 = ?");
			params.add(solarb.getSainrencst2());
		}
		if (solarb != null && solarb.getSainmencss2() != null) {
			where.append(" AND t1.SAINMENCSS2 = ?");
			params.add(solarb.getSainmencss2());
		}
		if (solarb != null && solarb.getSainrencss2() != null) {
			where.append(" AND t1.SAINRENCSS2 = ?");
			params.add(solarb.getSainrencss2());
		}
		if (solarb != null && solarb.getSainmenct2() != null) {
			where.append(" AND t1.SAINMENCT2 = ?");
			params.add(solarb.getSainmenct2());
		}
		if (solarb != null && solarb.getSainrenct2() != null) {
			where.append(" AND t1.SAINRENCT2 = ?");
			params.add(solarb.getSainrenct2());
		}
		if (solarb != null && solarb.getSafeciau2() != null) {
			where.append(" AND t1.SAFECIAU2 = ?");
			params.add(solarb.getSafeciau2());
		}
		if (solarb != null && solarb.getSahrciau2() != null) {
			where.append(" AND t1.SAHRCIAU2 = ?");
			params.add(solarb.getSahrciau2());
		}
		if (solarb != null && solarb.getSanolura2() != null) {
			where.append(" AND t1.SANOLURA2 = ?");
			params.add(solarb.getSanolura2());
		}
		if (solarb != null && solarb.getSanodira2() != null) {
			where.append(" AND t1.SANODIRA2 = ?");
			params.add(solarb.getSanodira2());
		}
		if (solarb != null && solarb.getSacoloa2() != null) {
			where.append(" AND t1.SACOLOA2 = ?");
			params.add(solarb.getSacoloa2());
		}
		if (solarb != null && solarb.getSanrcpa2() != null) {
			where.append(" AND t1.SANRCPA2 = ?");
			params.add(solarb.getSanrcpa2());
		}
		if (solarb != null && solarb.getSafelaud() != null) {
			where.append(" AND t1.SAFELAUD = ?");
			params.add(solarb.getSafelaud());
		}
		if (solarb != null && solarb.getSateobre() != null) {
			where.append(" AND t1.SATEOBRE = ?");
			params.add(solarb.getSateobre());
		}
		if (solarb != null && solarb.getSatemore() != null) {
			where.append(" AND t1.SATEMORE = ?");
			params.add(solarb.getSatemore());
		}
		if (solarb != null && solarb.getSacneuil() != null) {
			where.append(" AND t1.SACNEUIL = ?");
			params.add(solarb.getSacneuil());
		}
		if (solarb != null && solarb.getSainfdla() != null) {
			where.append(" AND t1.SAINFDLA = ?");
			params.add(solarb.getSainfdla());
		}
		if (solarb != null && solarb.getSainvola() != null) {
			where.append(" AND t1.SAINVOLA = ?");
			params.add(solarb.getSainvola());
		}
		if (solarb != null && solarb.getSainarnl() != null) {
			where.append(" AND t1.SAINARNL = ?");
			params.add(solarb.getSainarnl());
		}
		if (solarb != null && solarb.getSafenolt() != null) {
			where.append(" AND t1.SAFENOLT = ?");
			params.add(solarb.getSafenolt());
		}
		if (solarb != null && solarb.getSainmelt() != null) {
			where.append(" AND t1.SAINMELT = ?");
			params.add(solarb.getSainmelt());
		}
		if (solarb != null && solarb.getSainpubo() != null) {
			where.append(" AND t1.SAINPUBO = ?");
			params.add(solarb.getSainpubo());
		}
		if (solarb != null && solarb.getSacota1() != null) {
			where.append(" AND t1.SACOTA1 = ?");
			params.add(solarb.getSacota1());
		}
		if (solarb != null && solarb.getSafesera() != null) {
			where.append(" AND t1.SAFESERA = ?");
			params.add(solarb.getSafesera());
		}
		if (solarb != null && solarb.getSainfdra() != null) {
			where.append(" AND t1.SAINFDRA = ?");
			params.add(solarb.getSainfdra());
		}
		if (solarb != null && solarb.getSafepeex() != null) {
			where.append(" AND t1.SAFEPEEX = ?");
			params.add(solarb.getSafepeex());
		}
		if (solarb != null && solarb.getSainrain() != null) {
			where.append(" AND t1.SAINRAIN = ?");
			params.add(solarb.getSainrain());
		}
		if (solarb != null && solarb.getSainefin() != null) {
			where.append(" AND t1.SAINEFIN = ?");
			params.add(solarb.getSainefin());
		}
		if (solarb != null && solarb.getSafeinef() != null) {
			where.append(" AND t1.SAFEINEF = ?");
			params.add(solarb.getSafeinef());
		}
		if (solarb != null && solarb.getSafear() != null) {
			where.append(" AND t1.SAFEAR = ?");
			params.add(solarb.getSafear());
		}
		if (solarb != null && solarb.getSafenode() != null) {
			where.append(" AND t1.SAFENODE = ?");
			params.add(solarb.getSafenode());
		}
		if (solarb != null && solarb.getSaferelt() != null) {
			where.append(" AND t1.SAFERELT = ?");
			params.add(solarb.getSaferelt());
		}
		if (solarb != null && solarb.getSafenoca() != null) {
			where.append(" AND t1.SAFENOCA = ?");
			params.add(solarb.getSafenoca());
		}
		if (solarb != null && solarb.getSafenoca2() != null) {
			where.append(" AND t1.SAFENOCA2 = ?");
			params.add(solarb.getSafenoca2());
		}
		if (solarb != null && solarb.getSafenoar() != null) {
			where.append(" AND t1.SAFENOAR = ?");
			params.add(solarb.getSafenoar());
		}
		if (solarb != null && solarb.getSacocccos() != null) {
			where.append(" AND t1.SACOCCCOS = ?");
			params.add(solarb.getSacocccos());
		}
		if (solarb != null && solarb.getSacoccco2s() != null) {
			where.append(" AND t1.SACOCCCO2S = ?");
			params.add(solarb.getSacoccco2s());
		}
		if (solarb != null && solarb.getSacooecos() != null) {
			where.append(" AND t1.SACOOECOS = ?");
			params.add(solarb.getSacooecos());
		}
		if (solarb != null && solarb.getSacooeco2s() != null) {
			where.append(" AND t1.SACOOECO2S = ?");
			params.add(solarb.getSacooeco2s());
		}
		if (solarb != null && solarb.getSafesoac() != null) {
			where.append(" AND t1.SAFESOAC = ?");
			params.add(solarb.getSafesoac());
		}
		if (solarb != null && solarb.getSafeenac() != null) {
			where.append(" AND t1.SAFEENAC = ?");
			params.add(solarb.getSafeenac());
		}
		if (solarb != null && solarb.getSafenoac() != null) {
			where.append(" AND t1.SAFENOAC = ?");
			params.add(solarb.getSafenoac());
		}
		if (solarb != null && solarb.getSatefpr1() != null) {
			where.append(" AND t1.SATEFPR1 = ?");
			params.add(solarb.getSatefpr1());
		}
		if (solarb != null && solarb.getSatefpr2() != null) {
			where.append(" AND t1.SATEFPR2 = ?");
			params.add(solarb.getSatefpr2());
		}
		if (solarb != null && solarb.getSafefpr1() != null) {
			where.append(" AND t1.SAFEFPR1 = ?");
			params.add(solarb.getSafefpr1());
		}
		if (solarb != null && solarb.getSafefpr2() != null) {
			where.append(" AND t1.SAFEFPR2 = ?");
			params.add(solarb.getSafefpr2());
		}
		if (solarb != null && solarb.getSanrbopl() != null) {
			where.append(" AND t1.SANRBOPL = ?");
			params.add(solarb.getSanrbopl());
		}
		if (solarb != null && solarb.getSafeenin() != null) {
			where.append(" AND t1.SAFEENIN = ?");
			params.add(solarb.getSafeenin());
		}
		if (solarb != null && solarb.getSafeoppe() != null) {
			where.append(" AND t1.SAFEOPPE = ?");
			params.add(solarb.getSafeoppe());
		}
		if (solarb != null && solarb.getSafeopla() != null) {
			where.append(" AND t1.SAFEOPLA = ?");
			params.add(solarb.getSafeopla());
		}
		if (solarb != null && solarb.getSafereco() != null) {
			where.append(" AND t1.SAFERECO = ?");
			params.add(solarb.getSafereco());
		}
		if (solarb != null && solarb.getSafenola() != null) {
			where.append(" AND t1.SAFENOLA = ?");
			params.add(solarb.getSafenola());
		}
		if (solarb != null && solarb.getSafenona() != null) {
			where.append(" AND t1.SAFENONA = ?");
			params.add(solarb.getSafenona());
		}
		if (solarb != null && solarb.getSaferena() != null) {
			where.append(" AND t1.SAFERENA = ?");
			params.add(solarb.getSaferena());
		}
		if (solarb != null && solarb.getSafecona() != null) {
			where.append(" AND t1.SAFECONA = ?");
			params.add(solarb.getSafecona());
		}
		if (solarb != null && solarb.getSapub() != null) {
			where.append(" AND t1.SAPUB = ?");
			params.add(solarb.getSapub());
		}
		if (solarb != null && solarb.getSaintica() != null) {
			where.append(" AND t1.SAINTICA = ?");
			params.add(solarb.getSaintica());
		}
		if (solarb != null && solarb.getSacotir() != null) {
			where.append(" AND t1.SACOTIR = ?");
			params.add(solarb.getSacotir());
		}
		if (solarb != null && solarb.getSacops() != null) {
			where.append(" AND t1.SACOPS = ?");
			params.add(solarb.getSacops());
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
}
