package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.SectorAgrupado;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Sector;

/**
 * * SectorDaoImpl generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

@Repository
@Transactional
public class SectorDaoImpl implements SectorDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Sector> rwMap = new RowMapper<Sector>() {
		public Sector mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Sector(resultSet.getString("SECODIGO"),
					resultSet.getString("SENOMBRE"),
					resultSet.getString("SENOCO"),
					resultSet.getString("SEDESCRI"),
					resultSet.getString("SECOSE"),
					resultSet.getString("SENOCO2"),
					resultSet.getString("SEINSEL1"),
					resultSet.getString("SENOMBREE"),
					resultSet.getString("SENOMBREI"),
					resultSet.getString("SENOMBREF"),
					resultSet.getString("SENOCOE"),
					resultSet.getString("SENOCOI"),
					resultSet.getString("SENOCOF"),
					resultSet.getString("SEDESCRIE"),
					resultSet.getString("SEDESCRII"),
					resultSet.getString("SEDESCRIF"),
					resultSet.getString("SECODGRUPO"),
					resultSet.getString("SENOMBREA"),
					resultSet.getString("SEDESCRIA"),
					resultSet.getString("SENOCOA"), new SectorAgrupado(
							resultSet.getString("SectorAgrupadoL0CODIGO"),
							resultSet.getString("SectorAgrupadoL0NOMBRE"),
							resultSet.getString("SectorAgrupadoL0NOMBREE"),
							resultSet.getString("SectorAgrupadoL0NOMBREI"),
							resultSet.getString("SectorAgrupadoL0NOMBREF")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Sector table.
	 * 
	 * @param sector
	 *            Pagination
	 * @return Sector
	 */
	public Sector add(Sector sector) {

		String query = "INSERT INTO SECTOR( SECODIGO,SECOL0,SENOMBRE,SENOCO,SEDESCRI,SECOSE,SENOCO2,SEINSEL1,SENOMBREE,SENOMBREI,SENOMBREF,SENOCOE,SENOCOI,SENOCOF,SEDESCRIE,SEDESCRII,SEDESCRIF,SECODGRUPO,SENOMBREA,SEDESCRIA,SENOCOA)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getSectorAgrupadoL0codigoAux = null;
		if (sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0codigo() != null) {
			getSectorAgrupadoL0codigoAux = sector.getSectorAgrupado()
					.getL0codigo();
		}
		this.jdbcTemplate.update(query, sector.getSecodigo(),
				getSectorAgrupadoL0codigoAux, sector.getSenombre(),
				sector.getSenoco(), sector.getSedescri(), sector.getSecose(),
				sector.getSenoco2(), sector.getSeinsel1(),
				sector.getSenombree(), sector.getSenombrei(),
				sector.getSenombref(), sector.getSenocoe(),
				sector.getSenocoi(), sector.getSenocof(),
				sector.getSedescrie(), sector.getSedescrii(),
				sector.getSedescrif(), sector.getSecodgrupo(),
				sector.getSenombrea(), sector.getSedescria(),
				sector.getSenocoa());
		return sector;
	}

	/**
	 * Updates a single row in the Sector table.
	 * 
	 * @param sector
	 *            Pagination
	 * @return Sector
	 */
	public Sector update(Sector sector) {
		String query = "UPDATE SECTOR SET SECOL0=?,SENOMBRE=?,SENOCO=?,SEDESCRI=?,SECOSE=?,SENOCO2=?,SEINSEL1=?,SENOMBREE=?,SENOMBREI=?,SENOMBREF=?,SENOCOE=?,SENOCOI=?,SENOCOF=?,SEDESCRIE=?,SEDESCRII=?,SEDESCRIF=?,SECODGRUPO=?,SENOMBREA=?,SEDESCRIA=?,SENOCOA=? WHERE SECODIGO=?";
		Object getSectorAgrupadoL0codigoAux = null;
		if (sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0codigo() != null) {
			getSectorAgrupadoL0codigoAux = sector.getSectorAgrupado()
					.getL0codigo();
		}
		this.jdbcTemplate.update(query, getSectorAgrupadoL0codigoAux,
				sector.getSenombre(), sector.getSenoco(), sector.getSedescri(),
				sector.getSecose(), sector.getSenoco2(), sector.getSeinsel1(),
				sector.getSenombree(), sector.getSenombrei(),
				sector.getSenombref(), sector.getSenocoe(),
				sector.getSenocoi(), sector.getSenocof(),
				sector.getSedescrie(), sector.getSedescrii(),
				sector.getSedescrif(), sector.getSecodgrupo(),
				sector.getSenombrea(), sector.getSedescria(),
				sector.getSenocoa(), sector.getSecodigo());
		return sector;
	}

	/**
	 * Finds a single row in the Sector table.
	 * 
	 * @param sector
	 *            Pagination
	 * @return Sector
	 */
	@Transactional(readOnly = true)
	public Sector find(Sector sector) {
		String query = "SELECT t1.SECODIGO SECODIGO, t1.SENOMBRE SENOMBRE, t1.SENOCO SENOCO, t1.SEDESCRI SEDESCRI, t1.SECOSE SECOSE, t1.SENOCO2 SENOCO2, t1.SEINSEL1 SEINSEL1, t1.SENOMBREE SENOMBREE, t1.SENOMBREI SENOMBREI, t1.SENOMBREF SENOMBREF, t1.SENOCOE SENOCOE, t1.SENOCOI SENOCOI, t1.SENOCOF SENOCOF, t1.SEDESCRIE SEDESCRIE, t1.SEDESCRII SEDESCRII, t1.SEDESCRIF SEDESCRIF, t1.SECODGRUPO SECODGRUPO, t1.SENOMBREA SENOMBREA, t1.SEDESCRIA SEDESCRIA, t1.SENOCOA SENOCOA, t2.L0CODIGO SECTORAGRUPADOL0CODIGO, t2.L0NOMBRE SECTORAGRUPADOL0NOMBRE, t2.L0NOMBREE SECTORAGRUPADOL0NOMBREE, t2.L0NOMBREI SECTORAGRUPADOL0NOMBREI, t2.L0NOMBREF SECTORAGRUPADOL0NOMBREF "
				+ "FROM SECTOR t1 , SECTOR_AGRUPADO t2  "
				+ "WHERE t1.SECODIGO = ?   AND t1.SECOL0= t2.L0CODIGO(+)  ";
		return (Sector) this.jdbcTemplate.queryForObject(query, rwMap,
				sector.getSecodigo());
	}

	/**
	 * Finds a single row in the Sector table.
	 * 
	 * @param sector
	 *            Pagination
	 * @return Sector
	 */
	@Transactional(readOnly = true)
	public Sector findSectorSeleccionable(Sector sector) {
		String query = "SELECT t1.SECODIGO SECODIGO, t1.SENOMBRE SENOMBRE, t1.SENOCO SENOCO, t1.SEDESCRI SEDESCRI, t1.SECOSE SECOSE, t1.SENOCO2 SENOCO2, t1.SEINSEL1 SEINSEL1, t1.SENOMBREE SENOMBREE, t1.SENOMBREI SENOMBREI, t1.SENOMBREF SENOMBREF, t1.SENOCOE SENOCOE, t1.SENOCOI SENOCOI, t1.SENOCOF SENOCOF, t1.SEDESCRIE SEDESCRIE, t1.SEDESCRII SEDESCRII, t1.SEDESCRIF SEDESCRIF, t1.SECODGRUPO SECODGRUPO, t1.SENOMBREA SENOMBREA, t1.SEDESCRIA SEDESCRIA, t1.SENOCOA SENOCOA, t2.L0CODIGO SECTORAGRUPADOL0CODIGO, t2.L0NOMBRE SECTORAGRUPADOL0NOMBRE, t2.L0NOMBREE SECTORAGRUPADOL0NOMBREE, t2.L0NOMBREI SECTORAGRUPADOL0NOMBREI, t2.L0NOMBREF SECTORAGRUPADOL0NOMBREF "
				+ "FROM SECTOR t1 , SECTOR_AGRUPADO t2  "
				+ "WHERE t1.SECODIGO = ?   AND t1.SECOL0= t2.L0CODIGO(+) AND t1.SECOSE = ? ";
		return (Sector) this.jdbcTemplate.queryForObject(query, rwMap,
				sector.getSecodigo(), Y41aConstantes.ELEMENTO_SELECCIONABLE);
	}

	/**
	 * Removes a single row in the Sector table.
	 * 
	 * @param sector
	 *            Pagination
	 * @return
	 */
	public void remove(Sector sector) {
		String query = "DELETE  FROM SECTOR WHERE SECODIGO=?";
		this.jdbcTemplate.update(query, sector.getSecodigo());
	}

	/**
	 * Finds a List of rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sector> findAll(Sector sector, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.SECOL0= t2.L0CODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.SECODIGO SECODIGO,t1.SENOMBRE SENOMBRE,t1.SENOCO SENOCO,t1.SEDESCRI SEDESCRI,t1.SECOSE SECOSE,t1.SENOCO2 SENOCO2,t1.SEINSEL1 SEINSEL1,t1.SENOMBREE SENOMBREE,t1.SENOMBREI SENOMBREI,t1.SENOMBREF SENOMBREF,t1.SENOCOE SENOCOE,t1.SENOCOI SENOCOI,t1.SENOCOF SENOCOF,t1.SEDESCRIE SEDESCRIE,t1.SEDESCRII SEDESCRII,t1.SEDESCRIF SEDESCRIF,t1.SECODGRUPO SECODGRUPO,t1.SENOMBREA SENOMBREA,t1.SEDESCRIA SEDESCRIA,t1.SENOCOA SENOCOA,t2.L0CODIGO SECTORAGRUPADOL0CODIGO,t2.L0NOMBRE SECTORAGRUPADOL0NOMBRE,t2.L0NOMBREE SECTORAGRUPADOL0NOMBREE,t2.L0NOMBREI SECTORAGRUPADOL0NOMBREI,t2.L0NOMBREF SECTORAGRUPADOL0NOMBREF "
						+ "FROM SECTOR t1 ,SECTOR_AGRUPADO t2 ");

		if (sector != null && sector.getSecodigo() != null) {
			where.append(" AND t1.SECODIGO = ?");
			params.add(sector.getSecodigo());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0codigo() != null) {
			where.append(" AND t2.L0CODIGO = ?");
			params.add(sector.getSectorAgrupado().getL0codigo());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombre() != null) {
			where.append(" AND t2.L0NOMBRE = ?");
			params.add(sector.getSectorAgrupado().getL0nombre());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombree() != null) {
			where.append(" AND t2.L0NOMBREE = ?");
			params.add(sector.getSectorAgrupado().getL0nombree());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombrei() != null) {
			where.append(" AND t2.L0NOMBREI = ?");
			params.add(sector.getSectorAgrupado().getL0nombrei());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombref() != null) {
			where.append(" AND t2.L0NOMBREF = ?");
			params.add(sector.getSectorAgrupado().getL0nombref());
		}
		if (sector != null && sector.getSenombre() != null) {
			where.append(" AND t1.SENOMBRE = ?");
			params.add(sector.getSenombre());
		}
		if (sector != null && sector.getSenoco() != null) {
			where.append(" AND t1.SENOCO = ?");
			params.add(sector.getSenoco());
		}
		if (sector != null && sector.getSedescri() != null) {
			where.append(" AND t1.SEDESCRI = ?");
			params.add(sector.getSedescri());
		}
		if (sector != null && sector.getSecose() != null) {
			where.append(" AND t1.SECOSE = ?");
			params.add(sector.getSecose());
		}
		if (sector != null && sector.getSenoco2() != null) {
			where.append(" AND t1.SENOCO2 = ?");
			params.add(sector.getSenoco2());
		}
		if (sector != null && sector.getSeinsel1() != null) {
			where.append(" AND t1.SEINSEL1 = ?");
			params.add(sector.getSeinsel1());
		}
		if (sector != null && sector.getSenombree() != null) {
			where.append(" AND t1.SENOMBREE = ?");
			params.add(sector.getSenombree());
		}
		if (sector != null && sector.getSenombrei() != null) {
			where.append(" AND t1.SENOMBREI = ?");
			params.add(sector.getSenombrei());
		}
		if (sector != null && sector.getSenombref() != null) {
			where.append(" AND t1.SENOMBREF = ?");
			params.add(sector.getSenombref());
		}
		if (sector != null && sector.getSenocoe() != null) {
			where.append(" AND t1.SENOCOE = ?");
			params.add(sector.getSenocoe());
		}
		if (sector != null && sector.getSenocoi() != null) {
			where.append(" AND t1.SENOCOI = ?");
			params.add(sector.getSenocoi());
		}
		if (sector != null && sector.getSenocof() != null) {
			where.append(" AND t1.SENOCOF = ?");
			params.add(sector.getSenocof());
		}
		if (sector != null && sector.getSedescrie() != null) {
			where.append(" AND t1.SEDESCRIE = ?");
			params.add(sector.getSedescrie());
		}
		if (sector != null && sector.getSedescrii() != null) {
			where.append(" AND t1.SEDESCRII = ?");
			params.add(sector.getSedescrii());
		}
		if (sector != null && sector.getSedescrif() != null) {
			where.append(" AND t1.SEDESCRIF = ?");
			params.add(sector.getSedescrif());
		}
		if (sector != null && sector.getSecodgrupo() != null) {
			where.append(" AND t1.SECODGRUPO = ?");
			params.add(sector.getSecodgrupo());
		}
		if (sector != null && sector.getSenombrea() != null) {
			where.append(" AND t1.SENOMBREA = ?");
			params.add(sector.getSenombrea());
		}
		if (sector != null && sector.getSedescria() != null) {
			where.append(" AND t1.SEDESCRIA = ?");
			params.add(sector.getSedescria());
		}
		if (sector != null && sector.getSenocoa() != null) {
			where.append(" AND t1.SENOCOA = ?");
			params.add(sector.getSenocoa());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Sector>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Sector sector) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.SECOL0= t2.L0CODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  SECTOR t1   ,  SECTOR_AGRUPADO t2  ");
		if (sector != null && sector.getSecodigo() != null) {
			where.append(" AND t1.SECODIGO = ?");
			params.add(sector.getSecodigo());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0codigo() != null) {
			where.append(" AND t2.L0CODIGO = ?");
			params.add(sector.getSectorAgrupado().getL0codigo());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombre() != null) {
			where.append(" AND t2.L0NOMBRE = ?");
			params.add(sector.getSectorAgrupado().getL0nombre());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombree() != null) {
			where.append(" AND t2.L0NOMBREE = ?");
			params.add(sector.getSectorAgrupado().getL0nombree());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombrei() != null) {
			where.append(" AND t2.L0NOMBREI = ?");
			params.add(sector.getSectorAgrupado().getL0nombrei());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombref() != null) {
			where.append(" AND t2.L0NOMBREF = ?");
			params.add(sector.getSectorAgrupado().getL0nombref());
		}
		if (sector != null && sector.getSenombre() != null) {
			where.append(" AND t1.SENOMBRE = ?");
			params.add(sector.getSenombre());
		}
		if (sector != null && sector.getSenoco() != null) {
			where.append(" AND t1.SENOCO = ?");
			params.add(sector.getSenoco());
		}
		if (sector != null && sector.getSedescri() != null) {
			where.append(" AND t1.SEDESCRI = ?");
			params.add(sector.getSedescri());
		}
		if (sector != null && sector.getSecose() != null) {
			where.append(" AND t1.SECOSE = ?");
			params.add(sector.getSecose());
		}
		if (sector != null && sector.getSenoco2() != null) {
			where.append(" AND t1.SENOCO2 = ?");
			params.add(sector.getSenoco2());
		}
		if (sector != null && sector.getSeinsel1() != null) {
			where.append(" AND t1.SEINSEL1 = ?");
			params.add(sector.getSeinsel1());
		}
		if (sector != null && sector.getSenombree() != null) {
			where.append(" AND t1.SENOMBREE = ?");
			params.add(sector.getSenombree());
		}
		if (sector != null && sector.getSenombrei() != null) {
			where.append(" AND t1.SENOMBREI = ?");
			params.add(sector.getSenombrei());
		}
		if (sector != null && sector.getSenombref() != null) {
			where.append(" AND t1.SENOMBREF = ?");
			params.add(sector.getSenombref());
		}
		if (sector != null && sector.getSenocoe() != null) {
			where.append(" AND t1.SENOCOE = ?");
			params.add(sector.getSenocoe());
		}
		if (sector != null && sector.getSenocoi() != null) {
			where.append(" AND t1.SENOCOI = ?");
			params.add(sector.getSenocoi());
		}
		if (sector != null && sector.getSenocof() != null) {
			where.append(" AND t1.SENOCOF = ?");
			params.add(sector.getSenocof());
		}
		if (sector != null && sector.getSedescrie() != null) {
			where.append(" AND t1.SEDESCRIE = ?");
			params.add(sector.getSedescrie());
		}
		if (sector != null && sector.getSedescrii() != null) {
			where.append(" AND t1.SEDESCRII = ?");
			params.add(sector.getSedescrii());
		}
		if (sector != null && sector.getSedescrif() != null) {
			where.append(" AND t1.SEDESCRIF = ?");
			params.add(sector.getSedescrif());
		}
		if (sector != null && sector.getSecodgrupo() != null) {
			where.append(" AND t1.SECODGRUPO = ?");
			params.add(sector.getSecodgrupo());
		}
		if (sector != null && sector.getSenombrea() != null) {
			where.append(" AND t1.SENOMBREA = ?");
			params.add(sector.getSenombrea());
		}
		if (sector != null && sector.getSedescria() != null) {
			where.append(" AND t1.SEDESCRIA = ?");
			params.add(sector.getSedescria());
		}
		if (sector != null && sector.getSenocoa() != null) {
			where.append(" AND t1.SENOCOA = ?");
			params.add(sector.getSenocoa());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Sector table using like.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sector> findAllLike(Sector sector, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.SECOL0= t2.L0CODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.SECODIGO SECODIGO,t1.SENOMBRE SENOMBRE,t1.SENOCO SENOCO,t1.SEDESCRI SEDESCRI,t1.SECOSE SECOSE,t1.SENOCO2 SENOCO2,t1.SEINSEL1 SEINSEL1,t1.SENOMBREE SENOMBREE,t1.SENOMBREI SENOMBREI,t1.SENOMBREF SENOMBREF,t1.SENOCOE SENOCOE,t1.SENOCOI SENOCOI,t1.SENOCOF SENOCOF,t1.SEDESCRIE SEDESCRIE,t1.SEDESCRII SEDESCRII,t1.SEDESCRIF SEDESCRIF,t1.SECODGRUPO SECODGRUPO,t1.SENOMBREA SENOMBREA,t1.SEDESCRIA SEDESCRIA,t1.SENOCOA SENOCOA,t2.L0CODIGO SECTORAGRUPADOL0CODIGO,t2.L0NOMBRE SECTORAGRUPADOL0NOMBRE,t2.L0NOMBREE SECTORAGRUPADOL0NOMBREE,t2.L0NOMBREI SECTORAGRUPADOL0NOMBREI,t2.L0NOMBREF SECTORAGRUPADOL0NOMBREF "
						+ "FROM SECTOR t1 ,SECTOR_AGRUPADO t2 ");

		if (sector != null && sector.getSecodigo() != null) {
			where.append(" AND UPPER(t1.SECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.SECODIGO IS NOT NULL");
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0codigo() != null) {
			where.append(" AND t2.L0CODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSectorAgrupado().getL0codigo() + "%");
			} else {
				params.add("%" + sector.getSectorAgrupado().getL0codigo() + "%");
			}
			where.append(" AND t2.L0CODIGO IS NOT NULL");
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombre() != null) {
			where.append(" AND UPPER(t2.L0NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSectorAgrupado().getL0nombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sector.getSectorAgrupado().getL0nombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.L0NOMBRE IS NOT NULL");
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombree() != null) {
			where.append(" AND UPPER(t2.L0NOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSectorAgrupado().getL0nombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sector.getSectorAgrupado().getL0nombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.L0NOMBREE IS NOT NULL");
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombrei() != null) {
			where.append(" AND UPPER(t2.L0NOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSectorAgrupado().getL0nombrei()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sector.getSectorAgrupado().getL0nombrei()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.L0NOMBREI IS NOT NULL");
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombref() != null) {
			where.append(" AND UPPER(t2.L0NOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSectorAgrupado().getL0nombref()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sector.getSectorAgrupado().getL0nombref()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.L0NOMBREF IS NOT NULL");
		}
		if (sector != null && sector.getSenombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.SENOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenombre().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ sector.getSenombre().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.SENOMBRE IS NOT NULL");
		}
		if (sector != null && sector.getSenoco() != null) {
			where.append(" AND UPPER(t1.SENOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenoco().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSenoco().toUpperCase() + "%");
			}
			where.append(" AND t1.SENOCO IS NOT NULL");
		}
		if (sector != null && sector.getSedescri() != null) {
			where.append(" AND UPPER(t1.SEDESCRI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSedescri().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSedescri().toUpperCase() + "%");
			}
			where.append(" AND t1.SEDESCRI IS NOT NULL");
		}
		if (sector != null && sector.getSecose() != null) {
			where.append(" AND UPPER(t1.SECOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSecose().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSecose().toUpperCase() + "%");
			}
			where.append(" AND t1.SECOSE IS NOT NULL");
		}
		if (sector != null && sector.getSenoco2() != null) {
			where.append(" AND UPPER(t1.SENOCO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenoco2().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSenoco2().toUpperCase() + "%");
			}
			where.append(" AND t1.SENOCO2 IS NOT NULL");
		}
		if (sector != null && sector.getSeinsel1() != null) {
			where.append(" AND UPPER(t1.SEINSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSeinsel1().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSeinsel1().toUpperCase() + "%");
			}
			where.append(" AND t1.SEINSEL1 IS NOT NULL");
		}
		if (sector != null && sector.getSenombree() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.SENOMBREE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenombree().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ sector.getSenombree().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.SENOMBREE IS NOT NULL");
		}
		if (sector != null && sector.getSenombrei() != null) {
			where.append(" AND UPPER(t1.SENOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenombrei().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSenombrei().toUpperCase() + "%");
			}
			where.append(" AND t1.SENOMBREI IS NOT NULL");
		}
		if (sector != null && sector.getSenombref() != null) {
			where.append(" AND UPPER(t1.SENOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenombref().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSenombref().toUpperCase() + "%");
			}
			where.append(" AND t1.SENOMBREF IS NOT NULL");
		}
		if (sector != null && sector.getSenocoe() != null) {
			where.append(" AND UPPER(t1.SENOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenocoe().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSenocoe().toUpperCase() + "%");
			}
			where.append(" AND t1.SENOCOE IS NOT NULL");
		}
		if (sector != null && sector.getSenocoi() != null) {
			where.append(" AND UPPER(t1.SENOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenocoi().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSenocoi().toUpperCase() + "%");
			}
			where.append(" AND t1.SENOCOI IS NOT NULL");
		}
		if (sector != null && sector.getSenocof() != null) {
			where.append(" AND UPPER(t1.SENOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenocof().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSenocof().toUpperCase() + "%");
			}
			where.append(" AND t1.SENOCOF IS NOT NULL");
		}
		if (sector != null && sector.getSedescrie() != null) {
			where.append(" AND UPPER(t1.SEDESCRIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSedescrie().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSedescrie().toUpperCase() + "%");
			}
			where.append(" AND t1.SEDESCRIE IS NOT NULL");
		}
		if (sector != null && sector.getSedescrii() != null) {
			where.append(" AND UPPER(t1.SEDESCRII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSedescrii().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSedescrii().toUpperCase() + "%");
			}
			where.append(" AND t1.SEDESCRII IS NOT NULL");
		}
		if (sector != null && sector.getSedescrif() != null) {
			where.append(" AND UPPER(t1.SEDESCRIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSedescrif().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSedescrif().toUpperCase() + "%");
			}
			where.append(" AND t1.SEDESCRIF IS NOT NULL");
		}
		if (sector != null && sector.getSecodgrupo() != null) {
			where.append(" AND UPPER(t1.SECODGRUPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSecodgrupo().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSecodgrupo().toUpperCase() + "%");
			}
			where.append(" AND t1.SECODGRUPO IS NOT NULL");
		}
		if (sector != null && sector.getSenombrea() != null) {
			where.append(" AND UPPER(t1.SENOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenombrea().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSenombrea().toUpperCase() + "%");
			}
			where.append(" AND t1.SENOMBREA IS NOT NULL");
		}
		if (sector != null && sector.getSedescria() != null) {
			where.append(" AND UPPER(t1.SEDESCRIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSedescria().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSedescria().toUpperCase() + "%");
			}
			where.append(" AND t1.SEDESCRIA IS NOT NULL");
		}
		if (sector != null && sector.getSenocoa() != null) {
			where.append(" AND UPPER(t1.SENOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenocoa().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSenocoa().toUpperCase() + "%");
			}
			where.append(" AND t1.SENOCOA IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Sector>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sector> findAllLikeSector(Sector sector, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.SECOL0= t2.L0CODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.SECODIGO SECODIGO,t1.SENOMBRE SENOMBRE,t1.SENOCO SENOCO,t1.SEDESCRI SEDESCRI,t1.SECOSE SECOSE,t1.SENOCO2 SENOCO2,t1.SEINSEL1 SEINSEL1,t1.SENOMBREE SENOMBREE,t1.SENOMBREI SENOMBREI,t1.SENOMBREF SENOMBREF,t1.SENOCOE SENOCOE,t1.SENOCOI SENOCOI,t1.SENOCOF SENOCOF,t1.SEDESCRIE SEDESCRIE,t1.SEDESCRII SEDESCRII,t1.SEDESCRIF SEDESCRIF,t1.SECODGRUPO SECODGRUPO,t1.SENOMBREA SENOMBREA,t1.SEDESCRIA SEDESCRIA,t1.SENOCOA SENOCOA,t2.L0CODIGO SECTORAGRUPADOL0CODIGO,t2.L0NOMBRE SECTORAGRUPADOL0NOMBRE,t2.L0NOMBREE SECTORAGRUPADOL0NOMBREE,t2.L0NOMBREI SECTORAGRUPADOL0NOMBREI,t2.L0NOMBREF SECTORAGRUPADOL0NOMBREF "
						+ "FROM SECTOR t1 ,SECTOR_AGRUPADO t2 ");

		if (sector != null && sector.getSecodigo() != null) {
			where.append(" AND UPPER(t1.SECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.SECODIGO IS NOT NULL");
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0codigo() != null) {
			where.append(" AND t2.L0CODIGO = ?");
			params.add(sector.getSectorAgrupado().getL0codigo());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombre() != null) {
			where.append(" AND t2.L0NOMBRE = ?");
			params.add(sector.getSectorAgrupado().getL0nombre());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombree() != null) {
			where.append(" AND t2.L0NOMBREE = ?");
			params.add(sector.getSectorAgrupado().getL0nombree());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombrei() != null) {
			where.append(" AND t2.L0NOMBREI = ?");
			params.add(sector.getSectorAgrupado().getL0nombrei());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombref() != null) {
			where.append(" AND t2.L0NOMBREF = ?");
			params.add(sector.getSectorAgrupado().getL0nombref());
		}
		if (sector != null && sector.getSenombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.SENOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenombre().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ sector.getSenombre().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.SENOMBRE IS NOT NULL");
		}
		if (sector != null && sector.getSenoco() != null) {
			where.append(" AND t1.SENOCO = ?");
			params.add(sector.getSenoco());
		}
		if (sector != null && sector.getSedescri() != null) {
			where.append(" AND t1.SEDESCRI = ?");
			params.add(sector.getSedescri());
		}
		if (sector != null && sector.getSecose() != null) {
			where.append(" AND t1.SECOSE = ?");
			params.add(sector.getSecose());
		}
		if (sector != null && sector.getSenoco2() != null) {
			where.append(" AND t1.SENOCO2 = ?");
			params.add(sector.getSenoco2());
		}
		if (sector != null && sector.getSeinsel1() != null) {
			where.append(" AND t1.SEINSEL1 = ?");
			params.add(sector.getSeinsel1());
		}
		if (sector != null && sector.getSenombree() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.SENOMBREE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenombree().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ sector.getSenombree().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.SENOMBREE IS NOT NULL");
		}
		if (sector != null && sector.getSenombrei() != null) {
			where.append(" AND UPPER(t1.SENOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenombrei().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSenombrei().toUpperCase() + "%");
			}
			where.append(" AND t1.SENOMBREI IS NOT NULL");
		}
		if (sector != null && sector.getSenombref() != null) {
			where.append(" AND UPPER(t1.SENOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenombref().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSenombref().toUpperCase() + "%");
			}
			where.append(" AND t1.SENOMBREF IS NOT NULL");
		}
		if (sector != null && sector.getSenocoe() != null) {
			where.append(" AND t1.SENOCOE = ?");
			params.add(sector.getSenocoe());
		}
		if (sector != null && sector.getSenocoi() != null) {
			where.append(" AND t1.SENOCOI = ?");
			params.add(sector.getSenocoi());
		}
		if (sector != null && sector.getSenocof() != null) {
			where.append(" AND t1.SENOCOF = ?");
			params.add(sector.getSenocof());
		}
		if (sector != null && sector.getSedescrie() != null) {
			where.append(" AND t1.SEDESCRIE = ?");
			params.add(sector.getSedescrie());
		}
		if (sector != null && sector.getSedescrii() != null) {
			where.append(" AND t1.SEDESCRII = ?");
			params.add(sector.getSedescrii());
		}
		if (sector != null && sector.getSedescrif() != null) {
			where.append(" AND t1.SEDESCRIF = ?");
			params.add(sector.getSedescrif());
		}
		if (sector != null && sector.getSecodgrupo() != null) {
			where.append(" AND t1.SECODGRUPO = ?");
			params.add(sector.getSecodgrupo());
		}
		if (sector != null && sector.getSenombrea() != null) {
			where.append(" AND t1.SENOMBREA = ?");
			params.add(sector.getSenombrea());
		}
		if (sector != null && sector.getSedescria() != null) {
			where.append(" AND t1.SEDESCRIA = ?");
			params.add(sector.getSedescria());
		}
		if (sector != null && sector.getSenocoa() != null) {
			where.append(" AND t1.SENOCOA = ?");
			params.add(sector.getSenocoa());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Sector>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeSectorCount(Sector sector, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.SECOL0= t2.L0CODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  SECTOR t1   ,  SECTOR_AGRUPADO t2  ");
		if (sector != null && sector.getSecodigo() != null) {
			where.append(" AND UPPER(t1.SECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.SECODIGO IS NOT NULL");
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0codigo() != null) {
			where.append(" AND t2.L0CODIGO = ?");
			params.add(sector.getSectorAgrupado().getL0codigo());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombre() != null) {
			where.append(" AND t2.L0NOMBRE = ?");
			params.add(sector.getSectorAgrupado().getL0nombre());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombree() != null) {
			where.append(" AND t2.L0NOMBREE = ?");
			params.add(sector.getSectorAgrupado().getL0nombree());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombrei() != null) {
			where.append(" AND t2.L0NOMBREI = ?");
			params.add(sector.getSectorAgrupado().getL0nombrei());
		}
		if (sector != null && sector.getSectorAgrupado() != null
				&& sector.getSectorAgrupado().getL0nombref() != null) {
			where.append(" AND t2.L0NOMBREF = ?");
			params.add(sector.getSectorAgrupado().getL0nombref());
		}
		if (sector != null && sector.getSenombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.SENOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenombre().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ sector.getSenombre().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.SENOMBRE IS NOT NULL");
		}
		if (sector != null && sector.getSenoco() != null) {
			where.append(" AND t1.SENOCO = ?");
			params.add(sector.getSenoco());
		}
		if (sector != null && sector.getSedescri() != null) {
			where.append(" AND t1.SEDESCRI = ?");
			params.add(sector.getSedescri());
		}
		if (sector != null && sector.getSecose() != null) {
			where.append(" AND t1.SECOSE = ?");
			params.add(sector.getSecose());
		}
		if (sector != null && sector.getSenoco2() != null) {
			where.append(" AND t1.SENOCO2 = ?");
			params.add(sector.getSenoco2());
		}
		if (sector != null && sector.getSeinsel1() != null) {
			where.append(" AND t1.SEINSEL1 = ?");
			params.add(sector.getSeinsel1());
		}
		if (sector != null && sector.getSenombree() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.SENOMBREE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenombree().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ sector.getSenombree().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.SENOMBREE IS NOT NULL");
		}
		if (sector != null && sector.getSenombrei() != null) {
			where.append(" AND UPPER(t1.SENOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenombrei().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSenombrei().toUpperCase() + "%");
			}
			where.append(" AND t1.SENOMBREI IS NOT NULL");
		}
		if (sector != null && sector.getSenombref() != null) {
			where.append(" AND UPPER(t1.SENOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sector.getSenombref().toUpperCase() + "%");
			} else {
				params.add("%" + sector.getSenombref().toUpperCase() + "%");
			}
			where.append(" AND t1.SENOMBREF IS NOT NULL");
		}
		if (sector != null && sector.getSenocoe() != null) {
			where.append(" AND t1.SENOCOE = ?");
			params.add(sector.getSenocoe());
		}
		if (sector != null && sector.getSenocoi() != null) {
			where.append(" AND t1.SENOCOI = ?");
			params.add(sector.getSenocoi());
		}
		if (sector != null && sector.getSenocof() != null) {
			where.append(" AND t1.SENOCOF = ?");
			params.add(sector.getSenocof());
		}
		if (sector != null && sector.getSedescrie() != null) {
			where.append(" AND t1.SEDESCRIE = ?");
			params.add(sector.getSedescrie());
		}
		if (sector != null && sector.getSedescrii() != null) {
			where.append(" AND t1.SEDESCRII = ?");
			params.add(sector.getSedescrii());
		}
		if (sector != null && sector.getSedescrif() != null) {
			where.append(" AND t1.SEDESCRIF = ?");
			params.add(sector.getSedescrif());
		}
		if (sector != null && sector.getSecodgrupo() != null) {
			where.append(" AND t1.SECODGRUPO = ?");
			params.add(sector.getSecodgrupo());
		}
		if (sector != null && sector.getSenombrea() != null) {
			where.append(" AND t1.SENOMBREA = ?");
			params.add(sector.getSenombrea());
		}
		if (sector != null && sector.getSedescria() != null) {
			where.append(" AND t1.SEDESCRIA = ?");
			params.add(sector.getSedescria());
		}
		if (sector != null && sector.getSenocoa() != null) {
			where.append(" AND t1.SENOCOA = ?");
			params.add(sector.getSenocoa());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
