package com.ejie.y41a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Sector;

/**
 * * SectorDao generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

public interface SectorDao {

	/**
	 * Inserts a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	Sector add(Sector sector);

	/**
	 * Updates a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	Sector update(Sector sector);

	/**
	 * Finds a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	Sector find(Sector sector);

	/**
	 * Finds a single row in the Sector table.
	 * 
	 * @param sector
	 *            Pagination
	 * @return Sector
	 */
	Sector findSectorSeleccionable(Sector sector);

	/**
	 * Deletes a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return
	 */
	void remove(Sector sector);

	/**
	 * Finds a List of rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sector> findAll(Sector sector, Pagination pagination);

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return List
	 */
	Long findAllCount(Sector sector);

	/**
	 * Finds rows in the Sector table using like.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sector> findAllLike(Sector sector, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Sector table using like.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sector> findAllLikeSector(Sector sector, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	Long findAllLikeSectorCount(Sector sector, Boolean startsWith);

}
