package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.SectorAgrupado;

/**
 *  * SectorAgrupadoDaoImpl generated by UDA, 01-feb-2012 17:10:36.
 *  
 */
 
@Repository
@Transactional
public class SectorAgrupadoDaoImpl implements SectorAgrupadoDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<SectorAgrupado> rwMap = new RowMapper<SectorAgrupado>() {
		public SectorAgrupado mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new SectorAgrupado(
               resultSet.getString("L0CODIGO"), resultSet.getString("L0NOMBRE"), resultSet.getString("L0NOMBREE"), resultSet.getString("L0NOMBREI"), resultSet.getString("L0NOMBREF")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the SectorAgrupado table.
     *
     * @param sectoragrupado Pagination
     * @return SectorAgrupado
     */
	public SectorAgrupado add(SectorAgrupado sectoragrupado) {

    	String query = "INSERT INTO SECTOR_AGRUPADO( L0CODIGO,L0NOMBRE,L0NOMBREE,L0NOMBREI,L0NOMBREF)"
        + "VALUES (?,?,?,?,?)";

		this.jdbcTemplate.update(query, sectoragrupado.getL0codigo(), sectoragrupado.getL0nombre(), sectoragrupado.getL0nombree(), sectoragrupado.getL0nombrei(), sectoragrupado.getL0nombref());
		return sectoragrupado;
	}

    /**
     * Updates a single row in the SectorAgrupado table.
     *
     * @param sectoragrupado Pagination
     * @return SectorAgrupado
     */
    public SectorAgrupado update(SectorAgrupado sectoragrupado) {
		String query = "UPDATE SECTOR_AGRUPADO SET L0NOMBRE=?,L0NOMBREE=?,L0NOMBREI=?,L0NOMBREF=? WHERE L0CODIGO=?";
		this.jdbcTemplate.update(query, sectoragrupado.getL0nombre(), sectoragrupado.getL0nombree(), sectoragrupado.getL0nombrei(), sectoragrupado.getL0nombref(), sectoragrupado.getL0codigo());
		return sectoragrupado;
	}

    /**
     * Finds a single row in the SectorAgrupado table.
     *
     * @param sectoragrupado Pagination
     * @return SectorAgrupado
     */
    @Transactional (readOnly = true)
    public SectorAgrupado find(SectorAgrupado sectoragrupado) {
		String query = "SELECT t1.L0CODIGO L0CODIGO, t1.L0NOMBRE L0NOMBRE, t1.L0NOMBREE L0NOMBREE, t1.L0NOMBREI L0NOMBREI, t1.L0NOMBREF L0NOMBREF " 
         + "FROM SECTOR_AGRUPADO t1  " 
         + "WHERE t1.L0CODIGO = ?    ";
		return (SectorAgrupado) this.jdbcTemplate.queryForObject(query, 
			rwMap , sectoragrupado.getL0codigo());	 
    }

    /**
     * Removes a single row in the SectorAgrupado table.
     *
     * @param sectoragrupado Pagination
     * @return
     */
    public void remove(SectorAgrupado sectoragrupado) {
		String query = "DELETE  FROM SECTOR_AGRUPADO WHERE L0CODIGO=?";
		this.jdbcTemplate.update(query, sectoragrupado.getL0codigo());
    	}
    
   /**
    * Finds a List of rows in the SectorAgrupado table.
    * 
    * @param sectoragrupado SectorAgrupado
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<SectorAgrupado> findAll(SectorAgrupado sectoragrupado, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.L0CODIGO L0CODIGO,t1.L0NOMBRE L0NOMBRE,t1.L0NOMBREE L0NOMBREE,t1.L0NOMBREI L0NOMBREI,t1.L0NOMBREF L0NOMBREF " 
			+ "FROM SECTOR_AGRUPADO t1 ");
		
		if (sectoragrupado  != null  && sectoragrupado.getL0codigo() != null ) {
			where.append(" AND t1.L0CODIGO = ?");
			params.add(sectoragrupado.getL0codigo());
		}
		if (sectoragrupado  != null  && sectoragrupado.getL0nombre() != null ) {
			where.append(" AND t1.L0NOMBRE = ?");
			params.add(sectoragrupado.getL0nombre());
		}
		if (sectoragrupado  != null  && sectoragrupado.getL0nombree() != null ) {
			where.append(" AND t1.L0NOMBREE = ?");
			params.add(sectoragrupado.getL0nombree());
		}
		if (sectoragrupado  != null  && sectoragrupado.getL0nombrei() != null ) {
			where.append(" AND t1.L0NOMBREI = ?");
			params.add(sectoragrupado.getL0nombrei());
		}
		if (sectoragrupado  != null  && sectoragrupado.getL0nombref() != null ) {
			where.append(" AND t1.L0NOMBREF = ?");
			params.add(sectoragrupado.getL0nombref());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<SectorAgrupado>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the SectorAgrupado table.
     * 
     * @param sectoragrupado SectorAgrupado
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(SectorAgrupado sectoragrupado) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  SECTOR_AGRUPADO t1  ");
		if (sectoragrupado  != null  && sectoragrupado.getL0codigo() != null ) {
			where.append(" AND t1.L0CODIGO = ?");
			params.add(sectoragrupado.getL0codigo());
		}
		if (sectoragrupado  != null  && sectoragrupado.getL0nombre() != null ) {
			where.append(" AND t1.L0NOMBRE = ?");
			params.add(sectoragrupado.getL0nombre());
		}
		if (sectoragrupado  != null  && sectoragrupado.getL0nombree() != null ) {
			where.append(" AND t1.L0NOMBREE = ?");
			params.add(sectoragrupado.getL0nombree());
		}
		if (sectoragrupado  != null  && sectoragrupado.getL0nombrei() != null ) {
			where.append(" AND t1.L0NOMBREI = ?");
			params.add(sectoragrupado.getL0nombrei());
		}
		if (sectoragrupado  != null  && sectoragrupado.getL0nombref() != null ) {
			where.append(" AND t1.L0NOMBREF = ?");
			params.add(sectoragrupado.getL0nombref());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the SectorAgrupado table using like.
     * 
     * @param sectoragrupado SectorAgrupado
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<SectorAgrupado> findAllLike(SectorAgrupado sectoragrupado, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.L0CODIGO L0CODIGO,t1.L0NOMBRE L0NOMBRE,t1.L0NOMBREE L0NOMBREE,t1.L0NOMBREI L0NOMBREI,t1.L0NOMBREF L0NOMBREF " 
        	+ "FROM SECTOR_AGRUPADO t1 ");
      	
		if (sectoragrupado  != null  && sectoragrupado.getL0codigo() != null ) {
			where.append(" AND UPPER(t1.L0CODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sectoragrupado.getL0codigo().toUpperCase()  +"%");
			}else{
				params.add("%"+sectoragrupado.getL0codigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.L0CODIGO IS NOT NULL");
        }
		if (sectoragrupado  != null  && sectoragrupado.getL0nombre() != null ) {
			where.append(" AND UPPER(t1.L0NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sectoragrupado.getL0nombre().toUpperCase()  +"%");
			}else{
				params.add("%"+sectoragrupado.getL0nombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.L0NOMBRE IS NOT NULL");
        }
		if (sectoragrupado  != null  && sectoragrupado.getL0nombree() != null ) {
			where.append(" AND UPPER(t1.L0NOMBREE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sectoragrupado.getL0nombree().toUpperCase()  +"%");
			}else{
				params.add("%"+sectoragrupado.getL0nombree().toUpperCase() +"%");
			}	
			where.append(" AND t1.L0NOMBREE IS NOT NULL");
        }
		if (sectoragrupado  != null  && sectoragrupado.getL0nombrei() != null ) {
			where.append(" AND UPPER(t1.L0NOMBREI) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sectoragrupado.getL0nombrei().toUpperCase()  +"%");
			}else{
				params.add("%"+sectoragrupado.getL0nombrei().toUpperCase() +"%");
			}	
			where.append(" AND t1.L0NOMBREI IS NOT NULL");
        }
		if (sectoragrupado  != null  && sectoragrupado.getL0nombref() != null ) {
			where.append(" AND UPPER(t1.L0NOMBREF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sectoragrupado.getL0nombref().toUpperCase()  +"%");
			}else{
				params.add("%"+sectoragrupado.getL0nombref().toUpperCase() +"%");
			}	
			where.append(" AND t1.L0NOMBREF IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<SectorAgrupado>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

