package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Sanexprel;
import com.ejie.y41a.model.TipoProcedimiento;

/**
 * SanexprelDaoImpl generated by UDA, 08-oct-2013 12:36:52.
 * 
 *  
 */

@Repository
@Transactional
public class SanexprelDaoImpl implements SanexprelDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Sanexprel> rwMap = new RowMapper<Sanexprel>() {
		public Sanexprel mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Sanexprel(resultSet.getString("RLID"),
					resultSet.getString("RLHDCODREL"),
					resultSet.getString("RLEXCODREL"),
					resultSet.getString("CODEXPCOMPLETO"),
					resultSet.getString("RLHDCODIGO"),
					resultSet.getString("RLESORIG"),
					resultSet.getString("MONOMBRE"),
					resultSet.getDate("FECHAINI"),
					resultSet.getDate("FECHAFIN"), new TipoProcedimiento(
							resultSet.getString("PCODIGO"),
							resultSet.getString("PNOMBRE"),
							resultSet.getString("PNOMBREE"), null),
					resultSet.getString("RLARBCODIGO"),
					resultSet.getString("RLARBCODREL"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Finds a List of rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanexprel> findAll(Sanexprel sanexprel, Pagination pagination) {

		StringBuilder query = new StringBuilder("");

		query.append("select RLID, RLEXCODIGO, RLEXCODREL, RLHDCODREL, RLHDCODIGO, RLARBCODREL, RLARBCODIGO, CODEXPCOMPLETO, RLESORIG, MONOMBRE, FECHAINI, FECHAFIN, PCODIGO, PNOMBRE, PNOMBREE "
				+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
				+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
				+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
				+ Y41aConstantes.TIPO_PROC_SANCIONES
				+ "'"
				+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
				+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
				+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
				+ Y41aConstantes.TIPO_PROC_SOLICITUDES + "'");
		query.append(" union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t2.SACOJA || '-' || t2.SANROR || '-' || t2.SANRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.SAFESOLI FECHAINI, t4.EXFECFIN AS FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE from SANEXPREL t1, SOLARB t2, CENSO_MONITOR t3, ARBEXP t4, TIPO_PROCEDIMIENTO t5 where t1.RLARBCODREL= t2.SACODIGO AND t2.SACODIGO = t4.EXCODIGO(+) AND t4.EXMOCODIGO = t3.MOCODIGO(+) AND t5.PCODIGO ='");
		query.append(Y41aConstantes.TIPO_PROC_ARBITRAJE);
		query.append("')");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapTratado(sanexprel);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Sanexprel>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanexprel entity
	 * 
	 * @param sanexprel
	 *            Sanexprel Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapTratado(Sanexprel sanexprel) {

		StringBuilder where = new StringBuilder(
				SanexprelDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanexprel != null && sanexprel.getRlhdcodigo() != null) {
			where.append(" AND RLHDCODIGO = ?");
			params.add(sanexprel.getRlhdcodigo());
		}

		if (sanexprel != null && sanexprel.getRlarbcodigo() != null) {
			where.append(" AND RLARBCODIGO = ?");
			params.add(sanexprel.getRlarbcodigo());
		}

		if (sanexprel != null && sanexprel.getRlhdcodrel() != null) {
			where.append(" AND RLHDCODREL = ?");
			params.add(sanexprel.getRlhdcodrel());
		}

		if (sanexprel != null && sanexprel.getRlarbcodrel() != null) {
			where.append(" AND RLARBCODREL = ?");
			params.add(sanexprel.getRlarbcodrel());
		}

		if (sanexprel != null && sanexprel.getRlesorig() != null) {
			where.append(" AND RLESORIG = ?");
			params.add(sanexprel.getRlesorig());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
