package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Consulta;
import com.ejie.y41a.model.Respuesta;
import com.ejie.y41a.model.RespuestaFile;
import com.ejie.y41a.model.TipoRespuesta;
import com.ejie.y41a.utils.jdbc.Y41aJdbcUtils;

/**
 * * RespuestaFileDaoImpl generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

@Repository
@Transactional
public class RespuestaFileDaoImpl implements RespuestaFileDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<RespuestaFile> rwMap = new RowMapper<RespuestaFile>() {
		public RespuestaFile mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new RespuestaFile(resultSet.getLong("Q3COFILE"),
					new Respuesta(resultSet.getString("RespuestaP9CODIGO"),
							resultSet.getDate("RespuestaP9FEANOT"), resultSet
									.getString("RespuestaP9INEMLUSU"),
							resultSet.getDate("RespuestaP9FERESP"), null,
							resultSet.getBigDecimal("RespuestaP9NUFILADJ"),
							new TipoRespuesta(resultSet
									.getString("RespuestaP9COP8"), null, null,
									null, null, null, null), new Consulta(
									resultSet.getString("RespuestaP9COCO"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null)),
					resultSet.getDate("Q3FECHA"),
					resultSet.getString("Q3NOFILE"),
					resultSet.getBlob("Q3DATAFILE"),
					resultSet.getInt("Q3SIZEFILE"),
					resultSet.getString("Q3TEDESFILE"),
					resultSet.getString("Q3CONTENTTYPEFILE"),
					resultSet.getString("Q3ENVIADOMAIL"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the RespuestaFile table.
	 * 
	 * @param respuestafile
	 *            Pagination
	 * @return RespuestaFile
	 */
	public RespuestaFile add(RespuestaFile respuestafile) {

		String query = "INSERT INTO RESPUESTA_FILE( Q3COFILE,Q3CORESP,Q3NOFILE,Q3DATAFILE,Q3SIZEFILE,Q3TEDESFILE,Q3CONTENTTYPEFILE,Q3FECHA,Q3ENVIADOMAIL)"
				+ "VALUES (?,?,?,?,?,?,?,?,?)";

		Object getRespuestaP9codigoAux = null;
		if (respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9codigo() != null) {
			getRespuestaP9codigoAux = respuestafile.getRespuesta()
					.getP9codigo();
		}
		this.jdbcTemplate.update(query, respuestafile.getQ3cofile(),
				getRespuestaP9codigoAux, respuestafile.getQ3nofile(),
				Y41aJdbcUtils.ConvertBlobToByte(respuestafile.getQ3datafile()),
				respuestafile.getQ3sizefile(), respuestafile.getQ3tedesfile(),
				respuestafile.getQ3contenttypefile(),
				respuestafile.getQ3fecha(), respuestafile.getQ3enviadomail());
		return respuestafile;
	}

	/**
	 * Updates a single row in the RespuestaFile table.
	 * 
	 * @param respuestafile
	 *            Pagination
	 * @return RespuestaFile
	 */
	public RespuestaFile update(RespuestaFile respuestafile) {
		String query = "UPDATE RESPUESTA_FILE SET Q3CORESP=?,Q3NOFILE=?,Q3DATAFILE=?,Q3SIZEFILE=?,Q3TEDESFILE=?,Q3CONTENTTYPEFILE=?, Q3FECHA=?,Q3ENVIADOMAIL=? WHERE Q3COFILE=?";
		Object getRespuestaP9codigoAux = null;
		if (respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9codigo() != null) {
			getRespuestaP9codigoAux = respuestafile.getRespuesta()
					.getP9codigo();
		}
		this.jdbcTemplate.update(query, getRespuestaP9codigoAux,
				respuestafile.getQ3nofile(),
				Y41aJdbcUtils.ConvertBlobToByte(respuestafile.getQ3datafile()),
				respuestafile.getQ3sizefile(), respuestafile.getQ3tedesfile(),
				respuestafile.getQ3contenttypefile(),
				respuestafile.getQ3fecha(), respuestafile.getQ3enviadomail(),
				respuestafile.getQ3cofile());
		return respuestafile;
	}

	/**
	 * Finds a single row in the RespuestaFile table.
	 * 
	 * @param respuestafile
	 *            Pagination
	 * @return RespuestaFile
	 */
	@Transactional(readOnly = true)
	public RespuestaFile find(RespuestaFile respuestafile) {
		String query = "SELECT t1.Q3COFILE Q3COFILE, t1.Q3NOFILE Q3NOFILE, t1.Q3DATAFILE Q3DATAFILE, t1.Q3SIZEFILE Q3SIZEFILE, t1.Q3TEDESFILE Q3TEDESFILE, t1.Q3CONTENTTYPEFILE Q3CONTENTTYPEFILE, t1.Q3FECHA Q3FECHA, t1.Q3ENVIADOMAIL Q3ENVIADOMAIL, t2.P9CODIGO RESPUESTAP9CODIGO, t2.P9FEANOT RESPUESTAP9FEANOT, t2.P9INEMLUSU RESPUESTAP9INEMLUSU, t2.P9FERESP RESPUESTAP9FERESP, t2.P9NUFILADJ RESPUESTAP9NUFILADJ, t2.P9COP8 RESPUESTAP9COP8, t2.P9COCO RESPUESTAP9COCO "
				+ "FROM RESPUESTA_FILE t1 , RESPUESTA t2  "
				+ "WHERE t1.Q3COFILE = ?   AND t1.Q3CORESP= t2.P9CODIGO(+)  ";
		return (RespuestaFile) this.jdbcTemplate.queryForObject(query, rwMap,
				respuestafile.getQ3cofile());
	}

	/**
	 * Removes a single row in the RespuestaFile table.
	 * 
	 * @param respuestafile
	 *            Pagination
	 * @return
	 */
	public void remove(RespuestaFile respuestafile) {
		String query = "DELETE  FROM RESPUESTA_FILE WHERE Q3COFILE=?";
		this.jdbcTemplate.update(query, respuestafile.getQ3cofile());
	}

	/**
	 * Removes a single row in the RespuestaFile table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return
	 */
	public void removeRespuestaFileConsulta(Consulta consulta) {
		String query = "DELETE FROM RESPUESTA_FILE WHERE Q3CORESP IN ( SELECT P9CODIGO FROM RESPUESTA WHERE P9COCO = ?) ";

		this.jdbcTemplate.update(query, consulta.getCocodigo());
	}

	/**
	 * Finds a List of rows in the RespuestaFile table.
	 * 
	 * @param respuestafile
	 *            RespuestaFile
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<RespuestaFile> findAll(RespuestaFile respuestafile,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.Q3CORESP= t2.P9CODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.Q3COFILE Q3COFILE,t1.Q3NOFILE Q3NOFILE, t1.Q3DATAFILE Q3DATAFILE,t1.Q3SIZEFILE Q3SIZEFILE,t1.Q3TEDESFILE Q3TEDESFILE, t1.Q3CONTENTTYPEFILE Q3CONTENTTYPEFILE, t1.Q3FECHA Q3FECHA, t1.Q3ENVIADOMAIL Q3ENVIADOMAIL, t2.P9CODIGO RESPUESTAP9CODIGO,t2.P9FEANOT RESPUESTAP9FEANOT,t2.P9INEMLUSU RESPUESTAP9INEMLUSU,t2.P9FERESP RESPUESTAP9FERESP,t2.P9NUFILADJ RESPUESTAP9NUFILADJ,t2.P9COP8 RESPUESTAP9COP8,t2.P9COCO RESPUESTAP9COCO "
						+ "FROM RESPUESTA_FILE t1 ,RESPUESTA t2 ");

		if (respuestafile != null && respuestafile.getQ3cofile() != null) {
			where.append(" AND t1.Q3COFILE = ?");
			params.add(respuestafile.getQ3cofile());
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9codigo() != null) {
			where.append(" AND t2.P9CODIGO = ?");
			params.add(respuestafile.getRespuesta().getP9codigo());
		}
		if (respuestafile != null
				&& respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getTipoRespuesta() != null
				&& respuestafile.getRespuesta().getTipoRespuesta()
						.getP8codigo() != null) {
			where.append(" AND t2.P9COP8 = ?");
			params.add(respuestafile.getRespuesta().getTipoRespuesta()
					.getP8codigo());
		}
		if (respuestafile != null
				&& respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getConsulta() != null
				&& respuestafile.getRespuesta().getConsulta().getCocodigo() != null) {
			where.append(" AND t2.P9COCO = ?");
			params.add(respuestafile.getRespuesta().getConsulta().getCocodigo());
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9feanot() != null) {
			where.append(" AND t2.P9FEANOT = ?");
			params.add(respuestafile.getRespuesta().getP9feanot());
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9inemlusu() != null) {
			where.append(" AND t2.P9INEMLUSU = ?");
			params.add(respuestafile.getRespuesta().getP9inemlusu());
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9feresp() != null) {
			where.append(" AND t2.P9FERESP = ?");
			params.add(respuestafile.getRespuesta().getP9feresp());
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9nufiladj() != null) {
			where.append(" AND t2.P9NUFILADJ = ?");
			params.add(respuestafile.getRespuesta().getP9nufiladj());
		}
		if (respuestafile != null && respuestafile.getQ3nofile() != null) {
			where.append(" AND t1.Q3NOFILE = ?");
			params.add(respuestafile.getQ3nofile());
		}
		if (respuestafile != null && respuestafile.getQ3sizefile() != null) {
			where.append(" AND t1.Q3SIZEFILE = ?");
			params.add(respuestafile.getQ3sizefile());
		}
		if (respuestafile != null && respuestafile.getQ3tedesfile() != null) {
			where.append(" AND t1.Q3TEDESFILE = ?");
			params.add(respuestafile.getQ3tedesfile());
		}
		if (respuestafile != null && respuestafile.getQ3enviadomail() != null) {
			where.append(" AND t1.Q3ENVIADOMAIL = ?");
			params.add(respuestafile.getQ3enviadomail());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<RespuestaFile>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the RespuestaFile table.
	 * 
	 * @param respuestafile
	 *            RespuestaFile
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(RespuestaFile respuestafile) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.Q3CORESP= t2.P9CODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  RESPUESTA_FILE t1   ,  RESPUESTA t2  ");
		if (respuestafile != null && respuestafile.getQ3cofile() != null) {
			where.append(" AND t1.Q3COFILE = ?");
			params.add(respuestafile.getQ3cofile());
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9codigo() != null) {
			where.append(" AND t2.P9CODIGO = ?");
			params.add(respuestafile.getRespuesta().getP9codigo());
		}
		if (respuestafile != null
				&& respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getTipoRespuesta() != null
				&& respuestafile.getRespuesta().getTipoRespuesta()
						.getP8codigo() != null) {
			where.append(" AND t2.P9COP8 = ?");
			params.add(respuestafile.getRespuesta().getTipoRespuesta()
					.getP8codigo());
		}
		if (respuestafile != null
				&& respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getConsulta() != null
				&& respuestafile.getRespuesta().getConsulta().getCocodigo() != null) {
			where.append(" AND t2.P9COCO = ?");
			params.add(respuestafile.getRespuesta().getConsulta().getCocodigo());
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9feanot() != null) {
			where.append(" AND t2.P9FEANOT = ?");
			params.add(respuestafile.getRespuesta().getP9feanot());
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9inemlusu() != null) {
			where.append(" AND t2.P9INEMLUSU = ?");
			params.add(respuestafile.getRespuesta().getP9inemlusu());
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9feresp() != null) {
			where.append(" AND t2.P9FERESP = ?");
			params.add(respuestafile.getRespuesta().getP9feresp());
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9nufiladj() != null) {
			where.append(" AND t2.P9NUFILADJ = ?");
			params.add(respuestafile.getRespuesta().getP9nufiladj());
		}
		if (respuestafile != null && respuestafile.getQ3nofile() != null) {
			where.append(" AND t1.Q3NOFILE = ?");
			params.add(respuestafile.getQ3nofile());
		}
		if (respuestafile != null && respuestafile.getQ3sizefile() != null) {
			where.append(" AND t1.Q3SIZEFILE = ?");
			params.add(respuestafile.getQ3sizefile());
		}
		if (respuestafile != null && respuestafile.getQ3tedesfile() != null) {
			where.append(" AND t1.Q3TEDESFILE = ?");
			params.add(respuestafile.getQ3tedesfile());
		}
		if (respuestafile != null && respuestafile.getQ3enviadomail() != null) {
			where.append(" AND t1.Q3ENVIADOMAIL = ?");
			params.add(respuestafile.getQ3enviadomail());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the RespuestaFile table using like.
	 * 
	 * @param respuestafile
	 *            RespuestaFile
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<RespuestaFile> findAllLike(RespuestaFile respuestafile,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.Q3CORESP= t2.P9CODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.Q3COFILE Q3COFILE,t1.Q3NOFILE Q3NOFILE,t1.Q3DATAFILE Q3DATAFILE,t1.Q3SIZEFILE Q3SIZEFILE,t1.Q3TEDESFILE Q3TEDESFILE, t1.Q3CONTENTTYPEFILE Q3CONTENTTYPEFILE,t1.Q3FECHA Q3FECHA, t1.Q3ENVIADOMAIL Q3ENVIADOMAIL, t2.P9CODIGO RESPUESTAP9CODIGO,t2.P9FEANOT RESPUESTAP9FEANOT,t2.P9INEMLUSU RESPUESTAP9INEMLUSU,t2.P9FERESP RESPUESTAP9FERESP,t2.P9TERES RESPUESTAP9TERES,t2.P9NUFILADJ RESPUESTAP9NUFILADJ,t2.P9COP8 RESPUESTAP9COP8,t2.P9COCO RESPUESTAP9COCO "
						+ "FROM RESPUESTA_FILE t1 ,RESPUESTA t2 ");

		if (respuestafile != null && respuestafile.getQ3cofile() != null) {
			where.append(" AND t1.Q3COFILE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuestafile.getQ3cofile() + "%");
			} else {
				params.add("%" + respuestafile.getQ3cofile() + "%");
			}
			where.append(" AND t1.Q3COFILE IS NOT NULL");
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9codigo() != null) {
			where.append(" AND t2.P9CODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuestafile.getRespuesta().getP9codigo() + "%");
			} else {
				params.add("%" + respuestafile.getRespuesta().getP9codigo()
						+ "%");
			}
			where.append(" AND t2.P9CODIGO IS NOT NULL");
		}
		if (respuestafile != null
				&& respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getTipoRespuesta() != null
				&& respuestafile.getRespuesta().getTipoRespuesta()
						.getP8codigo() != null) {
			where.append(" AND UPPER(t2.P9COP8) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuestafile.getRespuesta().getTipoRespuesta()
						.getP8codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuestafile.getRespuesta().getTipoRespuesta()
								.getP8codigo().toUpperCase() + "%");
			}
			where.append(" AND t2.P9COP8 IS NOT NULL");
		}
		if (respuestafile != null
				&& respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getConsulta() != null
				&& respuestafile.getRespuesta().getConsulta().getCocodigo() != null) {
			where.append(" AND UPPER(t2.P9COCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuestafile.getRespuesta().getConsulta()
						.getCocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuestafile.getRespuesta().getConsulta()
								.getCocodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.P9COCO IS NOT NULL");
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9feanot() != null) {
			where.append(" AND t2.P9FEANOT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuestafile.getRespuesta().getP9feanot() + "%");
			} else {
				params.add("%" + respuestafile.getRespuesta().getP9feanot()
						+ "%");
			}
			where.append(" AND t2.P9FEANOT IS NOT NULL");
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9inemlusu() != null) {
			where.append(" AND UPPER(t2.P9INEMLUSU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuestafile.getRespuesta().getP9inemlusu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuestafile.getRespuesta().getP9inemlusu()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.P9INEMLUSU IS NOT NULL");
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9feresp() != null) {
			where.append(" AND t2.P9FERESP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuestafile.getRespuesta().getP9feresp() + "%");
			} else {
				params.add("%" + respuestafile.getRespuesta().getP9feresp()
						+ "%");
			}
			where.append(" AND t2.P9FERESP IS NOT NULL");
		}
		if (respuestafile != null && respuestafile.getRespuesta() != null
				&& respuestafile.getRespuesta().getP9nufiladj() != null) {
			where.append(" AND t2.P9NUFILADJ like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuestafile.getRespuesta().getP9nufiladj() + "%");
			} else {
				params.add("%" + respuestafile.getRespuesta().getP9nufiladj()
						+ "%");
			}
			where.append(" AND t2.P9NUFILADJ IS NOT NULL");
		}
		if (respuestafile != null && respuestafile.getQ3nofile() != null) {
			where.append(" AND UPPER(t1.Q3NOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuestafile.getQ3nofile().toUpperCase() + "%");
			} else {
				params.add("%" + respuestafile.getQ3nofile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.Q3NOFILE IS NOT NULL");
		}
		if (respuestafile != null && respuestafile.getQ3sizefile() != null) {
			where.append(" AND t1.Q3SIZEFILE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuestafile.getQ3sizefile() + "%");
			} else {
				params.add("%" + respuestafile.getQ3sizefile() + "%");
			}
			where.append(" AND t1.Q3SIZEFILE IS NOT NULL");
		}
		if (respuestafile != null && respuestafile.getQ3tedesfile() != null) {
			where.append(" AND UPPER(t1.Q3TEDESFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuestafile.getQ3tedesfile().toUpperCase() + "%");
			} else {
				params.add("%" + respuestafile.getQ3tedesfile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.Q3TEDESFILE IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<RespuestaFile>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT SEQ_L21Q3T00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
