package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Consulta;
import com.ejie.y41a.model.FormaPresentacion;
import com.ejie.y41a.model.Motivo;
import com.ejie.y41a.model.Organismo;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.RangoEdad;
import com.ejie.y41a.model.Respuesta;
import com.ejie.y41a.model.TipoRespuesta;

/**
 * * RespuestaDaoImpl generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

@Repository
@Transactional
public class RespuestaDaoImpl implements RespuestaDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Respuesta> rwMap = new RowMapper<Respuesta>() {
		public Respuesta mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Respuesta(resultSet.getString("P9CODIGO"),
					resultSet.getDate("P9FEANOT"),
					resultSet.getString("P9INEMLUSU"),
					resultSet.getDate("P9FERESP"),
					resultSet.getString("P9TERES"),
					resultSet.getBigDecimal("P9NUFILADJ"), new TipoRespuesta(
							resultSet.getString("TipoRespuestaP8CODIGO"),
							resultSet.getString("TipoRespuestaP8NOMBRE"),
							resultSet.getString("TipoRespuestaP8NOMBREE"),
							resultSet.getString("TipoRespuestaP8TEDES"),
							resultSet.getString("TipoRespuestaP8TEDESE"),
							resultSet.getString("TipoRespuestaP8TEICO")),
					new Consulta(resultSet.getString("ConsultaCOCODIGO"),
							new Motivo(resultSet.getString("ConsultaCOCOTIR"),
									null, null, null), new Producto(resultSet
									.getString("ConsultaCOCOPS"), null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null), new RangoEdad(
									resultSet.getString("ConsultaCORANCOD"),
									null, null, null), new FormaPresentacion(
									resultSet.getString("ConsultaCOCOTFP"),
									null, null, null, null, null, null),
							new Organismo(
									resultSet.getString("ConsultaCOCOOR"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null),
							new CensoMonitor(resultSet
									.getString("ConsultaCOCOMO"), null, null,
									null, null, null, null, null, null, null,
									null, null), resultSet
									.getDate("ConsultaCOFECHA"), resultSet
									.getString("ConsultaCOCOSX"), resultSet
									.getString("ConsultaCONRAN"), resultSet
									.getString("ConsultaCOCOSE"), resultSet
									.getString("ConsultaCOTEXTO"), resultSet
									.getInt("ConsultaCONRREG"), resultSet
									.getString("ConsultaCONOCO"), resultSet
									.getString("ConsultaCONODIRCO"), resultSet
									.getString("ConsultaCONRCPCO"), resultSet
									.getString("ConsultaCOCOLOCO"), resultSet
									.getString("ConsultaCONOLOCO"), resultSet
									.getString("ConsultaCONOMUCO"), resultSet
									.getString("ConsultaCOCOPVCO"), resultSet
									.getString("ConsultaCOCOPACO"), resultSet
									.getString("ConsultaCONRTELCO"), resultSet
									.getString("ConsultaCONRFAXCO"), resultSet
									.getString("ConsultaCOCOEMCO"), resultSet
									.getDate("ConsultaCOFERES"), resultSet
									.getString("ConsultaCOINREENV"), resultSet
									.getString("ConsultaCOTERESP"), resultSet
									.getString("ConsultaCOCOTFPR"), resultSet
									.getString("ConsultaCOINL37"), resultSet
									.getLong("ConsultaCONRANRG"), resultSet
									.getString("ConsultaCOCOPRO"), resultSet
									.getString("ConsultaCOHDCODIGO"), resultSet
									.getString("ConsultaCOHORA"), resultSet
									.getDate("ConsultaCOFECHACONSUMIDOR"),
							resultSet.getString("ConsultaNORAPAISID"),
							resultSet.getString("ConsultaNOMBREPAIS"),
							resultSet.getString("ConsultaNORAPROVINCIAID"),
							resultSet.getString("ConsultaNOMBREPROVINCIA"),
							resultSet.getString("ConsultaNORAMUNICIPIOID"),
							resultSet.getString("ConsultaNOMBREMUNICIPIO"),
							resultSet.getString("ConsultaNORALOCALIDADID"),
							resultSet.getString("ConsultaNOMBRELOCALIDAD"),
							resultSet.getString("ConsultaNORACALLEID"),
							resultSet.getString("ConsultaNOMBRECALLE"),
							resultSet.getString("ConsultaNORACPID"), resultSet
									.getString("ConsultaNOMBRECP"), resultSet
									.getString("ConsultaNORAPORTALID"),
							resultSet.getString("ConsultaNOMBREPORTAL"),
							resultSet.getString("ConsultaCOINL21"), resultSet
									.getString("ConsultaCOSITUACION"),
							resultSet.getString("ConsultaNOMBREPISO"),
							resultSet.getString("ConsultaDIRECCION_NOCAPV"),
							null, null, null, null));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Pagination
	 * @return Respuesta
	 */
	public Respuesta add(Respuesta respuesta) {

		String query = "INSERT INTO RESPUESTA( P9CODIGO,P9COP8,P9COCO,P9FEANOT,P9INEMLUSU,P9FERESP,P9TERES,P9NUFILADJ)"
				+ "VALUES (?,?,?,?,?,?,?,?)";

		Object getTipoRespuestaP8codigoAux = null;
		if (respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8codigo() != null) {
			getTipoRespuestaP8codigoAux = respuesta.getTipoRespuesta()
					.getP8codigo();
		}
		Object getConsultaCocodigoAux = null;
		if (respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocodigo() != null) {
			getConsultaCocodigoAux = respuesta.getConsulta().getCocodigo();
		}
		this.jdbcTemplate.update(query, respuesta.getP9codigo(),
				getTipoRespuestaP8codigoAux, getConsultaCocodigoAux,
				respuesta.getP9feanot(), respuesta.getP9inemlusu(),
				respuesta.getP9feresp(), respuesta.getP9teres(),
				respuesta.getP9nufiladj());
		return respuesta;
	}

	/**
	 * Updates a single row in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Pagination
	 * @return Respuesta
	 */
	public Respuesta update(Respuesta respuesta) {
		String query = "UPDATE RESPUESTA SET P9COP8=?,P9COCO=?,P9FEANOT=?,P9INEMLUSU=?,P9FERESP=?,P9TERES=?,P9NUFILADJ=? WHERE P9CODIGO=?";
		Object getTipoRespuestaP8codigoAux = null;
		if (respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8codigo() != null) {
			getTipoRespuestaP8codigoAux = respuesta.getTipoRespuesta()
					.getP8codigo();
		}
		Object getConsultaCocodigoAux = null;
		if (respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocodigo() != null) {
			getConsultaCocodigoAux = respuesta.getConsulta().getCocodigo();
		}
		this.jdbcTemplate.update(query, getTipoRespuestaP8codigoAux,
				getConsultaCocodigoAux, respuesta.getP9feanot(),
				respuesta.getP9inemlusu(), respuesta.getP9feresp(),
				respuesta.getP9teres(), respuesta.getP9nufiladj(),
				respuesta.getP9codigo());
		return respuesta;
	}

	/**
	 * Finds a single row in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Pagination
	 * @return Respuesta
	 */
	@Transactional(readOnly = true)
	public Respuesta find(Respuesta respuesta) {
		String query = "SELECT t1.P9CODIGO P9CODIGO, t1.P9FEANOT P9FEANOT, t1.P9INEMLUSU P9INEMLUSU, t1.P9FERESP P9FERESP, t1.P9TERES P9TERES, t1.P9NUFILADJ P9NUFILADJ, t2.P8CODIGO TIPORESPUESTAP8CODIGO, t2.P8NOMBRE TIPORESPUESTAP8NOMBRE, t2.P8NOMBREE TIPORESPUESTAP8NOMBREE, t2.P8TEDES TIPORESPUESTAP8TEDES, t2.P8TEDESE TIPORESPUESTAP8TEDESE, t2.P8TEICO TIPORESPUESTAP8TEICO, t3.COCODIGO CONSULTACOCODIGO, t3.COFECHA CONSULTACOFECHA, t3.COCOSX CONSULTACOCOSX, t3.CONRAN CONSULTACONRAN, t3.COCOSE CONSULTACOCOSE, t3.COTEXTO CONSULTACOTEXTO, t3.CONRREG CONSULTACONRREG, t3.CONOCO CONSULTACONOCO, t3.CONODIRCO CONSULTACONODIRCO, t3.CONRCPCO CONSULTACONRCPCO, t3.COCOLOCO CONSULTACOCOLOCO, t3.CONOLOCO CONSULTACONOLOCO, t3.CONOMUCO CONSULTACONOMUCO, t3.COCOPVCO CONSULTACOCOPVCO, t3.COCOPACO CONSULTACOCOPACO, t3.CONRTELCO CONSULTACONRTELCO, t3.CONRFAXCO CONSULTACONRFAXCO, t3.COCOEMCO CONSULTACOCOEMCO, t3.COFERES CONSULTACOFERES, t3.COINREENV CONSULTACOINREENV, t3.COTERESP CONSULTACOTERESP, t3.COCOTFPR CONSULTACOCOTFPR, t3.COINL37 CONSULTACOINL37, t3.CONRANRG CONSULTACONRANRG, t3.COCOPRO CONSULTACOCOPRO, t3.COHDCODIGO CONSULTACOHDCODIGO, t3.COHORA CONSULTACOHORA, t3.COFECHACONSUMIDOR CONSULTACOFECHACONSUMIDOR, t3.NORA_PAIS_ID CONSULTANORAPAISID, t3.NOMBRE_PAIS CONSULTANOMBREPAIS, t3.NORA_PROVINCIA_ID CONSULTANORAPROVINCIAID, t3.NOMBRE_PROVINCIA CONSULTANOMBREPROVINCIA, t3.NORA_MUNICIPIO_ID CONSULTANORAMUNICIPIOID, t3.NOMBRE_MUNICIPIO CONSULTANOMBREMUNICIPIO, t3.NORA_LOCALIDAD_ID CONSULTANORALOCALIDADID, t3.NOMBRE_LOCALIDAD CONSULTANOMBRELOCALIDAD, t3.NORA_CALLE_ID CONSULTANORACALLEID, t3.NOMBRE_CALLE CONSULTANOMBRECALLE, t3.NORA_CP_ID CONSULTANORACPID, t3.NOMBRE_CP CONSULTANOMBRECP, t3.NORA_PORTAL_ID CONSULTANORAPORTALID, t3.NOMBRE_PORTAL CONSULTANOMBREPORTAL, t3.COINL21 CONSULTACOINL21, t3.COSITUACION CONSULTACOSITUACION, t3.NOMBRE_PISO ConsultaNOMBREPISO, t3.DIRECCION_NOCAPV ConsultaDIRECCION_NOCAPV, t3.COCOTIR CONSULTACOCOTIR, t3.COCOPS CONSULTACOCOPS, t3.CORANCOD CONSULTACORANCOD, t3.COCOTFP CONSULTACOCOTFP, t3.COCOOR CONSULTACOCOOR, t3.COCOMO CONSULTACOCOMO "
				+ "FROM RESPUESTA t1 , TIPO_RESPUESTA t2 , CONSULTA t3  "
				+ "WHERE t1.P9CODIGO = ?   AND t1.P9COP8= t2.P8CODIGO(+) AND t1.P9COCO= t3.COCODIGO(+)  ";
		return (Respuesta) this.jdbcTemplate.queryForObject(query, rwMap,
				respuesta.getP9codigo());
	}

	/**
	 * Finds a single row in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Pagination
	 * @return Respuesta
	 */
	@Transactional(readOnly = true)
	public Respuesta findRespuesta(Respuesta respuesta) {
		String query = "SELECT * FROM (SELECT t1.P9CODIGO P9CODIGO, t1.P9FEANOT P9FEANOT, t1.P9INEMLUSU P9INEMLUSU, t1.P9FERESP P9FERESP, t1.P9TERES P9TERES, t1.P9NUFILADJ P9NUFILADJ, t2.P8CODIGO TIPORESPUESTAP8CODIGO, t2.P8NOMBRE TIPORESPUESTAP8NOMBRE, t2.P8NOMBREE TIPORESPUESTAP8NOMBREE, t2.P8TEDES TIPORESPUESTAP8TEDES, t2.P8TEDESE TIPORESPUESTAP8TEDESE, t2.P8TEICO TIPORESPUESTAP8TEICO, t3.COCODIGO CONSULTACOCODIGO, t3.COFECHA CONSULTACOFECHA, t3.COCOSX CONSULTACOCOSX, t3.CONRAN CONSULTACONRAN, t3.COCOSE CONSULTACOCOSE, t3.COTEXTO CONSULTACOTEXTO, t3.CONRREG CONSULTACONRREG, t3.CONOCO CONSULTACONOCO, t3.CONODIRCO CONSULTACONODIRCO, t3.CONRCPCO CONSULTACONRCPCO, t3.COCOLOCO CONSULTACOCOLOCO, t3.CONOLOCO CONSULTACONOLOCO, t3.CONOMUCO CONSULTACONOMUCO, t3.COCOPVCO CONSULTACOCOPVCO, t3.COCOPACO CONSULTACOCOPACO, t3.CONRTELCO CONSULTACONRTELCO, t3.CONRFAXCO CONSULTACONRFAXCO, t3.COCOEMCO CONSULTACOCOEMCO, t3.COFERES CONSULTACOFERES, t3.COINREENV CONSULTACOINREENV, t3.COTERESP CONSULTACOTERESP, t3.COCOTFPR CONSULTACOCOTFPR, t3.COINL37 CONSULTACOINL37, t3.CONRANRG CONSULTACONRANRG, t3.COCOPRO CONSULTACOCOPRO, t3.COHDCODIGO CONSULTACOHDCODIGO, t3.COHORA CONSULTACOHORA, t3.COFECHACONSUMIDOR CONSULTACOFECHACONSUMIDOR, t3.NORA_PAIS_ID CONSULTANORAPAISID, t3.NOMBRE_PAIS CONSULTANOMBREPAIS, t3.NORA_PROVINCIA_ID CONSULTANORAPROVINCIAID, t3.NOMBRE_PROVINCIA CONSULTANOMBREPROVINCIA, t3.NORA_MUNICIPIO_ID CONSULTANORAMUNICIPIOID, t3.NOMBRE_MUNICIPIO CONSULTANOMBREMUNICIPIO, t3.NORA_LOCALIDAD_ID CONSULTANORALOCALIDADID, t3.NOMBRE_LOCALIDAD CONSULTANOMBRELOCALIDAD, t3.NORA_CALLE_ID CONSULTANORACALLEID, t3.NOMBRE_CALLE CONSULTANOMBRECALLE, t3.NORA_CP_ID CONSULTANORACPID, t3.NOMBRE_CP CONSULTANOMBRECP, t3.NORA_PORTAL_ID CONSULTANORAPORTALID, t3.NOMBRE_PORTAL CONSULTANOMBREPORTAL, t3.COINL21 CONSULTACOINL21, t3.COSITUACION CONSULTACOSITUACION, t3.NOMBRE_PISO ConsultaNOMBREPISO, t3.DIRECCION_NOCAPV ConsultaDIRECCION_NOCAPV, t3.COCOTIR CONSULTACOCOTIR, t3.COCOPS CONSULTACOCOPS, t3.CORANCOD CONSULTACORANCOD, t3.COCOTFP CONSULTACOCOTFP, t3.COCOOR CONSULTACOCOOR, t3.COCOMO CONSULTACOCOMO "
				+ "FROM RESPUESTA t1 , TIPO_RESPUESTA t2 , CONSULTA t3  "
				+ "WHERE t3.COCODIGO = ?   AND t1.P9COP8= t2.P8CODIGO(+) AND t1.P9COCO= t3.COCODIGO(+) ORDER BY P9FERESP DESC NULLS LAST) WHERE ROWNUM=1 ";
		return (Respuesta) this.jdbcTemplate.queryForObject(query, rwMap,
				respuesta.getConsulta().getCocodigo());
	}

	/**
	 * Removes a single row in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @return
	 */
	public void remove(Respuesta respuesta) {
		String query = "DELETE  FROM RESPUESTA WHERE P9CODIGO=?";
		this.jdbcTemplate.update(query, respuesta.getP9codigo());
	}

	/**
	 * Removes a single row in the Respuesta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return
	 */
	public void removeRespuestaConsulta(Consulta consulta) {
		String query = "DELETE  FROM RESPUESTA WHERE P9COCO=?";
		this.jdbcTemplate.update(query, consulta.getCocodigo());
	}

	/**
	 * Finds a List of rows in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Respuesta> findAll(Respuesta respuesta, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.P9COP8= t2.P8CODIGO(+) AND t1.P9COCO= t3.COCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.P9CODIGO P9CODIGO,t1.P9FEANOT P9FEANOT,t1.P9INEMLUSU P9INEMLUSU,t1.P9FERESP P9FERESP, t1.P9TERES P9TERES,t1.P9NUFILADJ P9NUFILADJ,t2.P8CODIGO TIPORESPUESTAP8CODIGO,t2.P8NOMBRE TIPORESPUESTAP8NOMBRE,t2.P8NOMBREE TIPORESPUESTAP8NOMBREE,t2.P8TEDES TIPORESPUESTAP8TEDES,t2.P8TEDESE TIPORESPUESTAP8TEDESE,t2.P8TEICO TIPORESPUESTAP8TEICO,t3.COCODIGO CONSULTACOCODIGO,t3.COFECHA CONSULTACOFECHA,t3.COCOSX CONSULTACOCOSX,t3.CONRAN CONSULTACONRAN,t3.COCOSE CONSULTACOCOSE,t3.COTEXTO CONSULTACOTEXTO,t3.CONRREG CONSULTACONRREG,t3.CONOCO CONSULTACONOCO,t3.CONODIRCO CONSULTACONODIRCO,t3.CONRCPCO CONSULTACONRCPCO,t3.COCOLOCO CONSULTACOCOLOCO,t3.CONOLOCO CONSULTACONOLOCO,t3.CONOMUCO CONSULTACONOMUCO,t3.COCOPVCO CONSULTACOCOPVCO,t3.COCOPACO CONSULTACOCOPACO,t3.CONRTELCO CONSULTACONRTELCO,t3.CONRFAXCO CONSULTACONRFAXCO,t3.COCOEMCO CONSULTACOCOEMCO,t3.COFERES CONSULTACOFERES,t3.COINREENV CONSULTACOINREENV,t3.COTERESP CONSULTACOTERESP,t3.COCOTFPR CONSULTACOCOTFPR,t3.COINL37 CONSULTACOINL37,t3.CONRANRG CONSULTACONRANRG,t3.COCOPRO CONSULTACOCOPRO,t3.COHDCODIGO CONSULTACOHDCODIGO,t3.COHORA CONSULTACOHORA,t3.COFECHACONSUMIDOR CONSULTACOFECHACONSUMIDOR,t3.NORA_PAIS_ID CONSULTANORAPAISID,t3.NOMBRE_PAIS CONSULTANOMBREPAIS,t3.NORA_PROVINCIA_ID CONSULTANORAPROVINCIAID,t3.NOMBRE_PROVINCIA CONSULTANOMBREPROVINCIA,t3.NORA_MUNICIPIO_ID CONSULTANORAMUNICIPIOID,t3.NOMBRE_MUNICIPIO CONSULTANOMBREMUNICIPIO,t3.NORA_LOCALIDAD_ID CONSULTANORALOCALIDADID,t3.NOMBRE_LOCALIDAD CONSULTANOMBRELOCALIDAD,t3.NORA_CALLE_ID CONSULTANORACALLEID,t3.NOMBRE_CALLE CONSULTANOMBRECALLE,t3.NORA_CP_ID CONSULTANORACPID,t3.NOMBRE_CP CONSULTANOMBRECP,t3.NORA_PORTAL_ID CONSULTANORAPORTALID,t3.NOMBRE_PORTAL CONSULTANOMBREPORTAL,t3.COINL21 CONSULTACOINL21,t3.COSITUACION CONSULTACOSITUACION, t3.NOMBRE_PISO ConsultaNOMBREPISO, t3.DIRECCION_NOCAPV ConsultaDIRECCION_NOCAPV, t3.COCOTIR CONSULTACOCOTIR,t3.COCOPS CONSULTACOCOPS,t3.CORANCOD CONSULTACORANCOD,t3.COCOTFP CONSULTACOCOTFP,t3.COCOOR CONSULTACOCOOR,t3.COCOMO CONSULTACOCOMO "
						+ "FROM RESPUESTA t1 ,TIPO_RESPUESTA t2 ,CONSULTA t3 ");

		if (respuesta != null && respuesta.getP9codigo() != null) {
			where.append(" AND t1.P9CODIGO = ?");
			params.add(respuesta.getP9codigo());
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8codigo() != null) {
			where.append(" AND t2.P8CODIGO = ?");
			params.add(respuesta.getTipoRespuesta().getP8codigo());
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8nombre() != null) {
			where.append(" AND t2.P8NOMBRE = ?");
			params.add(respuesta.getTipoRespuesta().getP8nombre());
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8nombree() != null) {
			where.append(" AND t2.P8NOMBREE = ?");
			params.add(respuesta.getTipoRespuesta().getP8nombree());
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8tedes() != null) {
			where.append(" AND t2.P8TEDES = ?");
			params.add(respuesta.getTipoRespuesta().getP8tedes());
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8tedese() != null) {
			where.append(" AND t2.P8TEDESE = ?");
			params.add(respuesta.getTipoRespuesta().getP8tedese());
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8teico() != null) {
			where.append(" AND t2.P8TEICO = ?");
			params.add(respuesta.getTipoRespuesta().getP8teico());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocodigo() != null) {
			where.append(" AND t3.COCODIGO = ?");
			params.add(respuesta.getConsulta().getCocodigo());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getMotivo() != null
				&& respuesta.getConsulta().getMotivo().getTircodigo() != null) {
			where.append(" AND t3.COCOTIR = ?");
			params.add(respuesta.getConsulta().getMotivo().getTircodigo());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getProducto() != null
				&& respuesta.getConsulta().getProducto().getPscodigo() != null) {
			where.append(" AND t3.COCOPS = ?");
			params.add(respuesta.getConsulta().getProducto().getPscodigo());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getRangoEdad() != null
				&& respuesta.getConsulta().getRangoEdad().getRancod() != null) {
			where.append(" AND t3.CORANCOD = ?");
			params.add(respuesta.getConsulta().getRangoEdad().getRancod());
		}
		if (respuesta != null
				&& respuesta.getConsulta() != null
				&& respuesta.getConsulta().getFormaPresentacion() != null
				&& respuesta.getConsulta().getFormaPresentacion()
						.getTfpcodigo() != null) {
			where.append(" AND t3.COCOTFP = ?");
			params.add(respuesta.getConsulta().getFormaPresentacion()
					.getTfpcodigo());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getOrganismo() != null
				&& respuesta.getConsulta().getOrganismo().getCodOrg() != null) {
			where.append(" AND t3.COCOOR = ?");
			params.add(respuesta.getConsulta().getOrganismo().getCodOrg());
		}
		if (respuesta != null
				&& respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCensoMonitor() != null
				&& respuesta.getConsulta().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t3.COCOMO = ?");
			params.add(respuesta.getConsulta().getCensoMonitor().getMocodigo());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCofecha() != null) {
			where.append(" AND t3.COFECHA = ?");
			params.add(respuesta.getConsulta().getCofecha());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocosx() != null) {
			where.append(" AND t3.COCOSX = ?");
			params.add(respuesta.getConsulta().getCocosx());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConran() != null) {
			where.append(" AND t3.CONRAN = ?");
			params.add(respuesta.getConsulta().getConran());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocose() != null) {
			where.append(" AND t3.COCOSE = ?");
			params.add(respuesta.getConsulta().getCocose());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCotexto() != null) {
			where.append(" AND t3.COTEXTO = ?");
			params.add(respuesta.getConsulta().getCotexto());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConrreg() != null) {
			where.append(" AND t3.CONRREG = ?");
			params.add(respuesta.getConsulta().getConrreg());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConoco() != null) {
			where.append(" AND t3.CONOCO = ?");
			params.add(respuesta.getConsulta().getConoco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConodirco() != null) {
			where.append(" AND t3.CONODIRCO = ?");
			params.add(respuesta.getConsulta().getConodirco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConrcpco() != null) {
			where.append(" AND t3.CONRCPCO = ?");
			params.add(respuesta.getConsulta().getConrcpco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocoloco() != null) {
			where.append(" AND t3.COCOLOCO = ?");
			params.add(respuesta.getConsulta().getCocoloco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConoloco() != null) {
			where.append(" AND t3.CONOLOCO = ?");
			params.add(respuesta.getConsulta().getConoloco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConomuco() != null) {
			where.append(" AND t3.CONOMUCO = ?");
			params.add(respuesta.getConsulta().getConomuco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocopvco() != null) {
			where.append(" AND t3.COCOPVCO = ?");
			params.add(respuesta.getConsulta().getCocopvco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocopaco() != null) {
			where.append(" AND t3.COCOPACO = ?");
			params.add(respuesta.getConsulta().getCocopaco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConrtelco() != null) {
			where.append(" AND t3.CONRTELCO = ?");
			params.add(respuesta.getConsulta().getConrtelco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConrfaxco() != null) {
			where.append(" AND t3.CONRFAXCO = ?");
			params.add(respuesta.getConsulta().getConrfaxco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocoemco() != null) {
			where.append(" AND t3.COCOEMCO = ?");
			params.add(respuesta.getConsulta().getCocoemco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoferes() != null) {
			where.append(" AND t3.COFERES = ?");
			params.add(respuesta.getConsulta().getCoferes());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoinreenv() != null) {
			where.append(" AND t3.COINREENV = ?");
			params.add(respuesta.getConsulta().getCoinreenv());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoteresp() != null) {
			where.append(" AND t3.COTERESP = ?");
			params.add(respuesta.getConsulta().getCoteresp());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocotfpr() != null) {
			where.append(" AND t3.COCOTFPR = ?");
			params.add(respuesta.getConsulta().getCocotfpr());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoinl37() != null) {
			where.append(" AND t3.COINL37 = ?");
			params.add(respuesta.getConsulta().getCoinl37());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConranrg() != null) {
			where.append(" AND t3.CONRANRG = ?");
			params.add(respuesta.getConsulta().getConranrg());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocopro() != null) {
			where.append(" AND t3.COCOPRO = ?");
			params.add(respuesta.getConsulta().getCocopro());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCohdcodigo() != null) {
			where.append(" AND t3.COHDCODIGO = ?");
			params.add(respuesta.getConsulta().getCohdcodigo());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCohora() != null) {
			where.append(" AND t3.COHORA = ?");
			params.add(respuesta.getConsulta().getCohora());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCofechaconsumidor() != null) {
			where.append(" AND t3.COFECHACONSUMIDOR = ?");
			params.add(respuesta.getConsulta().getCofechaconsumidor());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraPaisId() != null) {
			where.append(" AND t3.NORA_PAIS_ID = ?");
			params.add(respuesta.getConsulta().getNoraPaisId());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombrePais() != null) {
			where.append(" AND t3.NOMBRE_PAIS = ?");
			params.add(respuesta.getConsulta().getNombrePais());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraProvinciaId() != null) {
			where.append(" AND t3.NORA_PROVINCIA_ID = ?");
			params.add(respuesta.getConsulta().getNoraProvinciaId());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreProvincia() != null) {
			where.append(" AND t3.NOMBRE_PROVINCIA = ?");
			params.add(respuesta.getConsulta().getNombreProvincia());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraMunicipioId() != null) {
			where.append(" AND t3.NORA_MUNICIPIO_ID = ?");
			params.add(respuesta.getConsulta().getNoraMunicipioId());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreMunicipio() != null) {
			where.append(" AND t3.NOMBRE_MUNICIPIO = ?");
			params.add(respuesta.getConsulta().getNombreMunicipio());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraLocalidadId() != null) {
			where.append(" AND t3.NORA_LOCALIDAD_ID = ?");
			params.add(respuesta.getConsulta().getNoraLocalidadId());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreLocalidad() != null) {
			where.append(" AND t3.NOMBRE_LOCALIDAD = ?");
			params.add(respuesta.getConsulta().getNombreLocalidad());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraCalleId() != null) {
			where.append(" AND t3.NORA_CALLE_ID = ?");
			params.add(respuesta.getConsulta().getNoraCalleId());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreCalle() != null) {
			where.append(" AND t3.NOMBRE_CALLE = ?");
			params.add(respuesta.getConsulta().getNombreCalle());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraCpId() != null) {
			where.append(" AND t3.NORA_CP_ID = ?");
			params.add(respuesta.getConsulta().getNoraCpId());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreCp() != null) {
			where.append(" AND t3.NOMBRE_CP = ?");
			params.add(respuesta.getConsulta().getNombreCp());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraPortalId() != null) {
			where.append(" AND t3.NORA_PORTAL_ID = ?");
			params.add(respuesta.getConsulta().getNoraPortalId());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombrePortal() != null) {
			where.append(" AND t3.NOMBRE_PORTAL = ?");
			params.add(respuesta.getConsulta().getNombrePortal());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoinl21() != null) {
			where.append(" AND t3.COINL21 = ?");
			params.add(respuesta.getConsulta().getCoinl21());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCosituacion() != null) {
			where.append(" AND t3.COSITUACION = ?");
			params.add(respuesta.getConsulta().getCosituacion());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombrePiso() != null) {
			where.append(" AND t3.NOMBRE_PISO = ?");
			params.add(respuesta.getConsulta().getNombrePiso());
		}
		if (respuesta != null && respuesta.getP9feanot() != null) {
			where.append(" AND t1.P9FEANOT = ?");
			params.add(respuesta.getP9feanot());
		}
		if (respuesta != null && respuesta.getP9inemlusu() != null) {
			where.append(" AND t1.P9INEMLUSU = ?");
			params.add(respuesta.getP9inemlusu());
		}
		if (respuesta != null && respuesta.getP9feresp() != null) {
			where.append(" AND t1.P9FERESP = ?");
			params.add(respuesta.getP9feresp());
		}
		if (respuesta != null && respuesta.getP9nufiladj() != null) {
			where.append(" AND t1.P9NUFILADJ = ?");
			params.add(respuesta.getP9nufiladj());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Respuesta>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Respuesta respuesta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.P9COP8= t2.P8CODIGO(+) and t1.P9COCO= t3.COCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  RESPUESTA t1   ,  TIPO_RESPUESTA t2   ,  CONSULTA t3  ");
		if (respuesta != null && respuesta.getP9codigo() != null) {
			where.append(" AND t1.P9CODIGO = ?");
			params.add(respuesta.getP9codigo());
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8codigo() != null) {
			where.append(" AND t2.P8CODIGO = ?");
			params.add(respuesta.getTipoRespuesta().getP8codigo());
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8nombre() != null) {
			where.append(" AND t2.P8NOMBRE = ?");
			params.add(respuesta.getTipoRespuesta().getP8nombre());
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8nombree() != null) {
			where.append(" AND t2.P8NOMBREE = ?");
			params.add(respuesta.getTipoRespuesta().getP8nombree());
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8tedes() != null) {
			where.append(" AND t2.P8TEDES = ?");
			params.add(respuesta.getTipoRespuesta().getP8tedes());
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8tedese() != null) {
			where.append(" AND t2.P8TEDESE = ?");
			params.add(respuesta.getTipoRespuesta().getP8tedese());
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8teico() != null) {
			where.append(" AND t2.P8TEICO = ?");
			params.add(respuesta.getTipoRespuesta().getP8teico());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocodigo() != null) {
			where.append(" AND t3.COCODIGO = ?");
			params.add(respuesta.getConsulta().getCocodigo());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getMotivo() != null
				&& respuesta.getConsulta().getMotivo().getTircodigo() != null) {
			where.append(" AND t3.COCOTIR = ?");
			params.add(respuesta.getConsulta().getMotivo().getTircodigo());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getProducto() != null
				&& respuesta.getConsulta().getProducto().getPscodigo() != null) {
			where.append(" AND t3.COCOPS = ?");
			params.add(respuesta.getConsulta().getProducto().getPscodigo());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getRangoEdad() != null
				&& respuesta.getConsulta().getRangoEdad().getRancod() != null) {
			where.append(" AND t3.CORANCOD = ?");
			params.add(respuesta.getConsulta().getRangoEdad().getRancod());
		}
		if (respuesta != null
				&& respuesta.getConsulta() != null
				&& respuesta.getConsulta().getFormaPresentacion() != null
				&& respuesta.getConsulta().getFormaPresentacion()
						.getTfpcodigo() != null) {
			where.append(" AND t3.COCOTFP = ?");
			params.add(respuesta.getConsulta().getFormaPresentacion()
					.getTfpcodigo());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getOrganismo() != null
				&& respuesta.getConsulta().getOrganismo().getCodOrg() != null) {
			where.append(" AND t3.COCOOR = ?");
			params.add(respuesta.getConsulta().getOrganismo().getCodOrg());
		}
		if (respuesta != null
				&& respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCensoMonitor() != null
				&& respuesta.getConsulta().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t3.COCOMO = ?");
			params.add(respuesta.getConsulta().getCensoMonitor().getMocodigo());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCofecha() != null) {
			where.append(" AND t3.COFECHA = ?");
			params.add(respuesta.getConsulta().getCofecha());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocosx() != null) {
			where.append(" AND t3.COCOSX = ?");
			params.add(respuesta.getConsulta().getCocosx());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConran() != null) {
			where.append(" AND t3.CONRAN = ?");
			params.add(respuesta.getConsulta().getConran());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocose() != null) {
			where.append(" AND t3.COCOSE = ?");
			params.add(respuesta.getConsulta().getCocose());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCotexto() != null) {
			where.append(" AND t3.COTEXTO = ?");
			params.add(respuesta.getConsulta().getCotexto());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConrreg() != null) {
			where.append(" AND t3.CONRREG = ?");
			params.add(respuesta.getConsulta().getConrreg());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConoco() != null) {
			where.append(" AND t3.CONOCO = ?");
			params.add(respuesta.getConsulta().getConoco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConodirco() != null) {
			where.append(" AND t3.CONODIRCO = ?");
			params.add(respuesta.getConsulta().getConodirco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConrcpco() != null) {
			where.append(" AND t3.CONRCPCO = ?");
			params.add(respuesta.getConsulta().getConrcpco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocoloco() != null) {
			where.append(" AND t3.COCOLOCO = ?");
			params.add(respuesta.getConsulta().getCocoloco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConoloco() != null) {
			where.append(" AND t3.CONOLOCO = ?");
			params.add(respuesta.getConsulta().getConoloco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConomuco() != null) {
			where.append(" AND t3.CONOMUCO = ?");
			params.add(respuesta.getConsulta().getConomuco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocopvco() != null) {
			where.append(" AND t3.COCOPVCO = ?");
			params.add(respuesta.getConsulta().getCocopvco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocopaco() != null) {
			where.append(" AND t3.COCOPACO = ?");
			params.add(respuesta.getConsulta().getCocopaco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConrtelco() != null) {
			where.append(" AND t3.CONRTELCO = ?");
			params.add(respuesta.getConsulta().getConrtelco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConrfaxco() != null) {
			where.append(" AND t3.CONRFAXCO = ?");
			params.add(respuesta.getConsulta().getConrfaxco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocoemco() != null) {
			where.append(" AND t3.COCOEMCO = ?");
			params.add(respuesta.getConsulta().getCocoemco());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoferes() != null) {
			where.append(" AND t3.COFERES = ?");
			params.add(respuesta.getConsulta().getCoferes());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoinreenv() != null) {
			where.append(" AND t3.COINREENV = ?");
			params.add(respuesta.getConsulta().getCoinreenv());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoteresp() != null) {
			where.append(" AND t3.COTERESP = ?");
			params.add(respuesta.getConsulta().getCoteresp());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocotfpr() != null) {
			where.append(" AND t3.COCOTFPR = ?");
			params.add(respuesta.getConsulta().getCocotfpr());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoinl37() != null) {
			where.append(" AND t3.COINL37 = ?");
			params.add(respuesta.getConsulta().getCoinl37());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConranrg() != null) {
			where.append(" AND t3.CONRANRG = ?");
			params.add(respuesta.getConsulta().getConranrg());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocopro() != null) {
			where.append(" AND t3.COCOPRO = ?");
			params.add(respuesta.getConsulta().getCocopro());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCohdcodigo() != null) {
			where.append(" AND t3.COHDCODIGO = ?");
			params.add(respuesta.getConsulta().getCohdcodigo());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCohora() != null) {
			where.append(" AND t3.COHORA = ?");
			params.add(respuesta.getConsulta().getCohora());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCofechaconsumidor() != null) {
			where.append(" AND t3.COFECHACONSUMIDOR = ?");
			params.add(respuesta.getConsulta().getCofechaconsumidor());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraPaisId() != null) {
			where.append(" AND t3.NORA_PAIS_ID = ?");
			params.add(respuesta.getConsulta().getNoraPaisId());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombrePais() != null) {
			where.append(" AND t3.NOMBRE_PAIS = ?");
			params.add(respuesta.getConsulta().getNombrePais());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraProvinciaId() != null) {
			where.append(" AND t3.NORA_PROVINCIA_ID = ?");
			params.add(respuesta.getConsulta().getNoraProvinciaId());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreProvincia() != null) {
			where.append(" AND t3.NOMBRE_PROVINCIA = ?");
			params.add(respuesta.getConsulta().getNombreProvincia());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraMunicipioId() != null) {
			where.append(" AND t3.NORA_MUNICIPIO_ID = ?");
			params.add(respuesta.getConsulta().getNoraMunicipioId());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreMunicipio() != null) {
			where.append(" AND t3.NOMBRE_MUNICIPIO = ?");
			params.add(respuesta.getConsulta().getNombreMunicipio());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraLocalidadId() != null) {
			where.append(" AND t3.NORA_LOCALIDAD_ID = ?");
			params.add(respuesta.getConsulta().getNoraLocalidadId());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreLocalidad() != null) {
			where.append(" AND t3.NOMBRE_LOCALIDAD = ?");
			params.add(respuesta.getConsulta().getNombreLocalidad());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraCalleId() != null) {
			where.append(" AND t3.NORA_CALLE_ID = ?");
			params.add(respuesta.getConsulta().getNoraCalleId());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreCalle() != null) {
			where.append(" AND t3.NOMBRE_CALLE = ?");
			params.add(respuesta.getConsulta().getNombreCalle());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraCpId() != null) {
			where.append(" AND t3.NORA_CP_ID = ?");
			params.add(respuesta.getConsulta().getNoraCpId());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreCp() != null) {
			where.append(" AND t3.NOMBRE_CP = ?");
			params.add(respuesta.getConsulta().getNombreCp());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraPortalId() != null) {
			where.append(" AND t3.NORA_PORTAL_ID = ?");
			params.add(respuesta.getConsulta().getNoraPortalId());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombrePortal() != null) {
			where.append(" AND t3.NOMBRE_PORTAL = ?");
			params.add(respuesta.getConsulta().getNombrePortal());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoinl21() != null) {
			where.append(" AND t3.COINL21 = ?");
			params.add(respuesta.getConsulta().getCoinl21());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCosituacion() != null) {
			where.append(" AND t3.COSITUACION = ?");
			params.add(respuesta.getConsulta().getCosituacion());
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombrePiso() != null) {
			where.append(" AND t3.NOMBRE_PISO = ?");
			params.add(respuesta.getConsulta().getNombrePiso());
		}
		if (respuesta != null && respuesta.getP9feanot() != null) {
			where.append(" AND t1.P9FEANOT = ?");
			params.add(respuesta.getP9feanot());
		}
		if (respuesta != null && respuesta.getP9inemlusu() != null) {
			where.append(" AND t1.P9INEMLUSU = ?");
			params.add(respuesta.getP9inemlusu());
		}
		if (respuesta != null && respuesta.getP9feresp() != null) {
			where.append(" AND t1.P9FERESP = ?");
			params.add(respuesta.getP9feresp());
		}
		if (respuesta != null && respuesta.getP9nufiladj() != null) {
			where.append(" AND t1.P9NUFILADJ = ?");
			params.add(respuesta.getP9nufiladj());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Respuesta table using like.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Respuesta> findAllLike(Respuesta respuesta,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.P9COP8= t2.P8CODIGO(+) AND t1.P9COCO= t3.COCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.P9CODIGO P9CODIGO,t1.P9FEANOT P9FEANOT,t1.P9INEMLUSU P9INEMLUSU,t1.P9FERESP P9FERESP,t1.P9TERES P9TERES,t1.P9NUFILADJ P9NUFILADJ,t2.P8CODIGO TIPORESPUESTAP8CODIGO,t2.P8NOMBRE TIPORESPUESTAP8NOMBRE,t2.P8NOMBREE TIPORESPUESTAP8NOMBREE,t2.P8TEDES TIPORESPUESTAP8TEDES,t2.P8TEDESE TIPORESPUESTAP8TEDESE,t2.P8TEICO TIPORESPUESTAP8TEICO,t3.COCODIGO CONSULTACOCODIGO,t3.COFECHA CONSULTACOFECHA,t3.COCOSX CONSULTACOCOSX,t3.CONRAN CONSULTACONRAN,t3.COCOSE CONSULTACOCOSE,t3.COTEXTO CONSULTACOTEXTO,t3.CONRREG CONSULTACONRREG,t3.CONOCO CONSULTACONOCO,t3.CONODIRCO CONSULTACONODIRCO,t3.CONRCPCO CONSULTACONRCPCO,t3.COCOLOCO CONSULTACOCOLOCO,t3.CONOLOCO CONSULTACONOLOCO,t3.CONOMUCO CONSULTACONOMUCO,t3.COCOPVCO CONSULTACOCOPVCO,t3.COCOPACO CONSULTACOCOPACO,t3.CONRTELCO CONSULTACONRTELCO,t3.CONRFAXCO CONSULTACONRFAXCO,t3.COCOEMCO CONSULTACOCOEMCO,t3.COFERES CONSULTACOFERES,t3.COINREENV CONSULTACOINREENV,t3.COTERESP CONSULTACOTERESP,t3.COCOTFPR CONSULTACOCOTFPR,t3.COINL37 CONSULTACOINL37,t3.CONRANRG CONSULTACONRANRG,t3.COCOPRO CONSULTACOCOPRO,t3.COHDCODIGO CONSULTACOHDCODIGO,t3.COHORA CONSULTACOHORA,t3.COFECHACONSUMIDOR CONSULTACOFECHACONSUMIDOR,t3.NORA_PAIS_ID CONSULTANORAPAISID,t3.NOMBRE_PAIS CONSULTANOMBREPAIS,t3.NORA_PROVINCIA_ID CONSULTANORAPROVINCIAID,t3.NOMBRE_PROVINCIA CONSULTANOMBREPROVINCIA,t3.NORA_MUNICIPIO_ID CONSULTANORAMUNICIPIOID,t3.NOMBRE_MUNICIPIO CONSULTANOMBREMUNICIPIO,t3.NORA_LOCALIDAD_ID CONSULTANORALOCALIDADID,t3.NOMBRE_LOCALIDAD CONSULTANOMBRELOCALIDAD,t3.NORA_CALLE_ID CONSULTANORACALLEID,t3.NOMBRE_CALLE CONSULTANOMBRECALLE,t3.NORA_CP_ID CONSULTANORACPID,t3.NOMBRE_CP CONSULTANOMBRECP,t3.NORA_PORTAL_ID CONSULTANORAPORTALID,t3.NOMBRE_PORTAL CONSULTANOMBREPORTAL,t3.COINL21 CONSULTACOINL21,t3.COSITUACION CONSULTACOSITUACION,t3.NOMBRE_PISO ConsultaNOMBREPISO, t3.DIRECCION_NOCAPV ConsultaDIRECCION_NOCAPV, t3.COCOTIR CONSULTACOCOTIR,t3.COCOPS CONSULTACOCOPS,t3.CORANCOD CONSULTACORANCOD,t3.COCOTFP CONSULTACOCOTFP,t3.COCOOR CONSULTACOCOOR,t3.COCOMO CONSULTACOCOMO "
						+ "FROM RESPUESTA t1 ,TIPO_RESPUESTA t2 ,CONSULTA t3 ");

		if (respuesta != null && respuesta.getP9codigo() != null) {
			where.append(" AND UPPER(t1.P9CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getP9codigo().toUpperCase() + "%");
			} else {
				params.add("%" + respuesta.getP9codigo().toUpperCase() + "%");
			}
			where.append(" AND t1.P9CODIGO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8codigo() != null) {
			where.append(" AND t2.P8CODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getTipoRespuesta().getP8codigo() + "%");
			} else {
				params.add("%" + respuesta.getTipoRespuesta().getP8codigo()
						+ "%");
			}
			where.append(" AND t2.P8CODIGO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8nombre() != null) {
			where.append(" AND UPPER(t2.P8NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getTipoRespuesta().getP8nombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getTipoRespuesta().getP8nombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.P8NOMBRE IS NOT NULL");
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8nombree() != null) {
			where.append(" AND UPPER(t2.P8NOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getTipoRespuesta().getP8nombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getTipoRespuesta().getP8nombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.P8NOMBREE IS NOT NULL");
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8tedes() != null) {
			where.append(" AND UPPER(t2.P8TEDES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getTipoRespuesta().getP8tedes()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getTipoRespuesta().getP8tedes()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.P8TEDES IS NOT NULL");
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8tedese() != null) {
			where.append(" AND UPPER(t2.P8TEDESE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getTipoRespuesta().getP8tedese()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getTipoRespuesta().getP8tedese()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.P8TEDESE IS NOT NULL");
		}
		if (respuesta != null && respuesta.getTipoRespuesta() != null
				&& respuesta.getTipoRespuesta().getP8teico() != null) {
			where.append(" AND UPPER(t2.P8TEICO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getTipoRespuesta().getP8teico()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getTipoRespuesta().getP8teico()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.P8TEICO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocodigo() != null) {
			where.append(" AND t3.COCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCocodigo() + "%");
			} else {
				params.add("%" + respuesta.getConsulta().getCocodigo() + "%");
			}
			where.append(" AND t3.COCODIGO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getMotivo() != null
				&& respuesta.getConsulta().getMotivo().getTircodigo() != null) {
			where.append(" AND UPPER(t3.COCOTIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getMotivo().getTircodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getMotivo().getTircodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.COCOTIR IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getProducto() != null
				&& respuesta.getConsulta().getProducto().getPscodigo() != null) {
			where.append(" AND UPPER(t3.COCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getProducto().getPscodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getProducto().getPscodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.COCOPS IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getRangoEdad() != null
				&& respuesta.getConsulta().getRangoEdad().getRancod() != null) {
			where.append(" AND UPPER(t3.CORANCOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getRangoEdad().getRancod()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getRangoEdad().getRancod()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.CORANCOD IS NOT NULL");
		}
		if (respuesta != null
				&& respuesta.getConsulta() != null
				&& respuesta.getConsulta().getFormaPresentacion() != null
				&& respuesta.getConsulta().getFormaPresentacion()
						.getTfpcodigo() != null) {
			where.append(" AND UPPER(t3.COCOTFP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getFormaPresentacion()
						.getTfpcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getFormaPresentacion()
								.getTfpcodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.COCOTFP IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getOrganismo() != null
				&& respuesta.getConsulta().getOrganismo().getCodOrg() != null) {
			where.append(" AND UPPER(t3.COCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getOrganismo().getCodOrg()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getOrganismo().getCodOrg()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.COCOOR IS NOT NULL");
		}
		if (respuesta != null
				&& respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCensoMonitor() != null
				&& respuesta.getConsulta().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t3.COCOMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCensoMonitor()
						.getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCensoMonitor()
								.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.COCOMO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCofecha() != null) {
			where.append(" AND t3.COFECHA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCofecha() + "%");
			} else {
				params.add("%" + respuesta.getConsulta().getCofecha() + "%");
			}
			where.append(" AND t3.COFECHA IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocosx() != null) {
			where.append(" AND UPPER(t3.COCOSX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCocosx().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCocosx().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COCOSX IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConran() != null) {
			where.append(" AND UPPER(t3.CONRAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getConran().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getConran().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.CONRAN IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocose() != null) {
			where.append(" AND UPPER(t3.COCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCocose().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCocose().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COCOSE IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCotexto() != null) {
			where.append(" AND UPPER(t3.COTEXTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCotexto().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCotexto().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COTEXTO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConrreg() != null) {
			where.append(" AND t3.CONRREG like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getConrreg() + "%");
			} else {
				params.add("%" + respuesta.getConsulta().getConrreg() + "%");
			}
			where.append(" AND t3.CONRREG IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConoco() != null) {
			where.append(" AND UPPER(t3.CONOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getConoco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getConoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.CONOCO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConodirco() != null) {
			where.append(" AND UPPER(t3.CONODIRCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getConodirco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getConodirco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.CONODIRCO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConrcpco() != null) {
			where.append(" AND UPPER(t3.CONRCPCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getConrcpco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getConrcpco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.CONRCPCO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocoloco() != null) {
			where.append(" AND UPPER(t3.COCOLOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCocoloco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCocoloco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COCOLOCO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConoloco() != null) {
			where.append(" AND UPPER(t3.CONOLOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getConoloco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getConoloco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.CONOLOCO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConomuco() != null) {
			where.append(" AND UPPER(t3.CONOMUCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getConomuco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getConomuco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.CONOMUCO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocopvco() != null) {
			where.append(" AND UPPER(t3.COCOPVCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCocopvco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCocopvco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COCOPVCO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocopaco() != null) {
			where.append(" AND UPPER(t3.COCOPACO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCocopaco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCocopaco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COCOPACO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConrtelco() != null) {
			where.append(" AND UPPER(t3.CONRTELCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getConrtelco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getConrtelco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.CONRTELCO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConrfaxco() != null) {
			where.append(" AND UPPER(t3.CONRFAXCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getConrfaxco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getConrfaxco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.CONRFAXCO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocoemco() != null) {
			where.append(" AND UPPER(t3.COCOEMCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCocoemco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCocoemco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COCOEMCO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoferes() != null) {
			where.append(" AND t3.COFERES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCoferes() + "%");
			} else {
				params.add("%" + respuesta.getConsulta().getCoferes() + "%");
			}
			where.append(" AND t3.COFERES IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoinreenv() != null) {
			where.append(" AND UPPER(t3.COINREENV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCoinreenv().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCoinreenv().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COINREENV IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoteresp() != null) {
			where.append(" AND UPPER(t3.COTERESP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCoteresp().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCoteresp().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COTERESP IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocotfpr() != null) {
			where.append(" AND UPPER(t3.COCOTFPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCocotfpr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCocotfpr().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COCOTFPR IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoinl37() != null) {
			where.append(" AND UPPER(t3.COINL37) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCoinl37().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCoinl37().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COINL37 IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getConranrg() != null) {
			where.append(" AND t3.CONRANRG like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getConranrg() + "%");
			} else {
				params.add("%" + respuesta.getConsulta().getConranrg() + "%");
			}
			where.append(" AND t3.CONRANRG IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCocopro() != null) {
			where.append(" AND UPPER(t3.COCOPRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCocopro().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCocopro().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COCOPRO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCohdcodigo() != null) {
			where.append(" AND UPPER(t3.COHDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCohdcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCohdcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COHDCODIGO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCohora() != null) {
			where.append(" AND UPPER(t3.COHORA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCohora().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCohora().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COHORA IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCofechaconsumidor() != null) {
			where.append(" AND t3.COFECHACONSUMIDOR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCofechaconsumidor() + "%");
			} else {
				params.add("%" + respuesta.getConsulta().getCofechaconsumidor()
						+ "%");
			}
			where.append(" AND t3.COFECHACONSUMIDOR IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraPaisId() != null) {
			where.append(" AND UPPER(t3.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNoraPaisId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNoraPaisId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.NORA_PAIS_ID IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombrePais() != null) {
			where.append(" AND UPPER(t3.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNombrePais()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNombrePais().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.NOMBRE_PAIS IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t3.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNoraProvinciaId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNoraProvinciaId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreProvincia() != null) {
			where.append(" AND UPPER(t3.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNombreProvincia()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNombreProvincia()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t3.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNoraMunicipioId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNoraMunicipioId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreMunicipio() != null) {
			where.append(" AND UPPER(t3.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNombreMunicipio()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNombreMunicipio()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t3.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNoraLocalidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNoraLocalidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreLocalidad() != null) {
			where.append(" AND UPPER(t3.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNombreLocalidad()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNombreLocalidad()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraCalleId() != null) {
			where.append(" AND UPPER(t3.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNoraCalleId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNoraCalleId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NORA_CALLE_ID IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreCalle() != null) {
			where.append(" AND UPPER(t3.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNombreCalle()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNombreCalle()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NOMBRE_CALLE IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraCpId() != null) {
			where.append(" AND UPPER(t3.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNoraCpId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNoraCpId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.NORA_CP_ID IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombreCp() != null) {
			where.append(" AND UPPER(t3.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNombreCp().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNombreCp().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.NOMBRE_CP IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNoraPortalId() != null) {
			where.append(" AND UPPER(t3.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNoraPortalId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNoraPortalId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NORA_PORTAL_ID IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombrePortal() != null) {
			where.append(" AND UPPER(t3.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNombrePortal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNombrePortal()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NOMBRE_PORTAL IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCoinl21() != null) {
			where.append(" AND UPPER(t3.COINL21) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCoinl21().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCoinl21().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COINL21 IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getCosituacion() != null) {
			where.append(" AND UPPER(t3.COSITUACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getCosituacion()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getCosituacion()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.COSITUACION IS NOT NULL");
		}
		if (respuesta != null && respuesta.getConsulta() != null
				&& respuesta.getConsulta().getNombrePiso() != null) {
			where.append(" AND UPPER(t3.NOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getConsulta().getNombrePiso()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ respuesta.getConsulta().getNombrePiso().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.NOMBRE_PISO IS NOT NULL");
		}
		if (respuesta != null && respuesta.getP9feanot() != null) {
			where.append(" AND t1.P9FEANOT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getP9feanot() + "%");
			} else {
				params.add("%" + respuesta.getP9feanot() + "%");
			}
			where.append(" AND t1.P9FEANOT IS NOT NULL");
		}
		if (respuesta != null && respuesta.getP9inemlusu() != null) {
			where.append(" AND UPPER(t1.P9INEMLUSU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getP9inemlusu().toUpperCase() + "%");
			} else {
				params.add("%" + respuesta.getP9inemlusu().toUpperCase() + "%");
			}
			where.append(" AND t1.P9INEMLUSU IS NOT NULL");
		}
		if (respuesta != null && respuesta.getP9feresp() != null) {
			where.append(" AND t1.P9FERESP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getP9feresp() + "%");
			} else {
				params.add("%" + respuesta.getP9feresp() + "%");
			}
			where.append(" AND t1.P9FERESP IS NOT NULL");
		}
		if (respuesta != null && respuesta.getP9nufiladj() != null) {
			where.append(" AND t1.P9NUFILADJ like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(respuesta.getP9nufiladj() + "%");
			} else {
				params.add("%" + respuesta.getP9nufiladj() + "%");
			}
			where.append(" AND t1.P9NUFILADJ IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Respuesta>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
