package com.ejie.y41a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Consulta;
import com.ejie.y41a.model.Respuesta;

/**
 * * RespuestaDao generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

public interface RespuestaDao {

	/**
	 * Inserts a single row in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @return Respuesta
	 */
	Respuesta add(Respuesta respuesta);

	/**
	 * Updates a single row in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @return Respuesta
	 */
	Respuesta update(Respuesta respuesta);

	/**
	 * Finds a single row in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @return Respuesta
	 */
	Respuesta find(Respuesta respuesta);

	/**
	 * Finds a single row in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Pagination
	 * @return Respuesta
	 */
	Respuesta findRespuesta(Respuesta respuesta);

	/**
	 * Deletes a single row in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @return
	 */
	void remove(Respuesta respuesta);

	/**
	 * Removes a single row in the Respuesta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return
	 */
	public void removeRespuestaConsulta(Consulta consulta);

	/**
	 * Finds a List of rows in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Respuesta> findAll(Respuesta respuesta, Pagination pagination);

	/**
	 * Counts rows in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @return List
	 */
	Long findAllCount(Respuesta respuesta);

	/**
	 * Finds rows in the Respuesta table using like.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Respuesta> findAllLike(Respuesta respuesta, Pagination pagination,
			Boolean startsWith);
}
