package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.RangoEdad;

/**
 *  * RangoEdadDaoImpl generated by UDA, 01-feb-2012 17:10:36.
 *  
 */
 
@Repository
@Transactional
public class RangoEdadDaoImpl implements RangoEdadDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<RangoEdad> rwMap = new RowMapper<RangoEdad>() {
		public RangoEdad mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new RangoEdad(
               resultSet.getString("RANCOD"), resultSet.getString("RANDESC")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the RangoEdad table.
     *
     * @param rangoedad Pagination
     * @return RangoEdad
     */
	public RangoEdad add(RangoEdad rangoedad) {

    	String query = "INSERT INTO RANGO_EDAD( RANCOD,RANDESC)"
        + "VALUES (?,?)";

		this.jdbcTemplate.update(query, rangoedad.getRancod(), rangoedad.getRandesc());
		return rangoedad;
	}

    /**
     * Updates a single row in the RangoEdad table.
     *
     * @param rangoedad Pagination
     * @return RangoEdad
     */
    public RangoEdad update(RangoEdad rangoedad) {
		String query = "UPDATE RANGO_EDAD SET RANDESC=? WHERE RANCOD=?";
		this.jdbcTemplate.update(query, rangoedad.getRandesc(), rangoedad.getRancod());
		return rangoedad;
	}

    /**
     * Finds a single row in the RangoEdad table.
     *
     * @param rangoedad Pagination
     * @return RangoEdad
     */
    @Transactional (readOnly = true)
    public RangoEdad find(RangoEdad rangoedad) {
		String query = "SELECT t1.RANCOD RANCOD, t1.RANDESC RANDESC " 
         + "FROM RANGO_EDAD t1  " 
         + "WHERE t1.RANCOD = ?    ";
		return (RangoEdad) this.jdbcTemplate.queryForObject(query, 
			rwMap , rangoedad.getRancod());	 
    }

    /**
     * Removes a single row in the RangoEdad table.
     *
     * @param rangoedad Pagination
     * @return
     */
    public void remove(RangoEdad rangoedad) {
		String query = "DELETE  FROM RANGO_EDAD WHERE RANCOD=?";
		this.jdbcTemplate.update(query, rangoedad.getRancod());
    	}
    
   /**
    * Finds a List of rows in the RangoEdad table.
    * 
    * @param rangoedad RangoEdad
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<RangoEdad> findAll(RangoEdad rangoedad, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.RANCOD RANCOD,t1.RANDESC RANDESC " 
			+ "FROM RANGO_EDAD t1 ");
		
		if (rangoedad  != null  && rangoedad.getRancod() != null ) {
			where.append(" AND t1.RANCOD = ?");
			params.add(rangoedad.getRancod());
		}
		if (rangoedad  != null  && rangoedad.getRandesc() != null ) {
			where.append(" AND t1.RANDESC = ?");
			params.add(rangoedad.getRandesc());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<RangoEdad>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the RangoEdad table.
     * 
     * @param rangoedad RangoEdad
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(RangoEdad rangoedad) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  RANGO_EDAD t1  ");
		if (rangoedad  != null  && rangoedad.getRancod() != null ) {
			where.append(" AND t1.RANCOD = ?");
			params.add(rangoedad.getRancod());
		}
		if (rangoedad  != null  && rangoedad.getRandesc() != null ) {
			where.append(" AND t1.RANDESC = ?");
			params.add(rangoedad.getRandesc());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the RangoEdad table using like.
     * 
     * @param rangoedad RangoEdad
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<RangoEdad> findAllLike(RangoEdad rangoedad, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.RANCOD RANCOD,t1.RANDESC RANDESC " 
        	+ "FROM RANGO_EDAD t1 ");
      	
		if (rangoedad  != null  && rangoedad.getRancod() != null ) {
			where.append(" AND UPPER(t1.RANCOD) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(rangoedad.getRancod().toUpperCase()  +"%");
			}else{
				params.add("%"+rangoedad.getRancod().toUpperCase() +"%");
			}	
			where.append(" AND t1.RANCOD IS NOT NULL");
        }
		if (rangoedad  != null  && rangoedad.getRandesc() != null ) {
			where.append(" AND UPPER(t1.RANDESC) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(rangoedad.getRandesc().toUpperCase()  +"%");
			}else{
				params.add("%"+rangoedad.getRandesc().toUpperCase() +"%");
			}	
			where.append(" AND t1.RANDESC IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<RangoEdad>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

