package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Acta;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.AlertaRecib;
import com.ejie.y41a.model.CampahnaRecib;
import com.ejie.y41a.model.DenunciaRecib;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.ProtocoloDetalle;
import com.ejie.y41a.model.TipActuacion;
import com.ejie.y41a.model.TipPregProtoc;
import com.ejie.y41a.model.TipProtocolo;
import com.ejie.y41a.model.TipReqNormativo;
import com.ejie.y41a.model.TipmotActuacion;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Protocolo;

/**
 * * ProtocoloDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class ProtocoloDaoImpl implements ProtocoloDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Protocolo> rwMap = new RowMapper<Protocolo>() {
		public Protocolo mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Protocolo(
					resultSet.getString("PTCODIGO"),
					resultSet.getInt("PTNRPRTP"),
					resultSet.getString("PTCORETP"),
					new TipPregProtoc(resultSet
							.getString("TipPregProtocTRCODIGO"), resultSet
							.getLong("TipPregProtocTRNRTIPP"), resultSet
							.getString("TipPregProtocTRCOTIPP"), resultSet
							.getString("TipPregProtocTRDETIPP"), resultSet
							.getString("TipPregProtocTRINTI"), resultSet
							.getString("TipPregProtocTRINRE"), resultSet
							.getString("TipPregProtocTRREES"),
							new TipProtocolo(resultSet
									.getString("TipPregProtocTRCOTP"), null,
									null, null, null, null),
							new TipReqNormativo(resultSet
									.getString("TipPregProtocTRCOTTI"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null)),
					new Actuacion(
							resultSet.getString("ActuacionATCODIGO"),
							resultSet.getBigDecimal("ActuacionATNROR"),
							resultSet.getString("ActuacionATCOAV"),
							resultSet.getString("ActuacionATCOSE"),
							resultSet.getString("ActuacionATNOPRSE"),
							resultSet.getString("ActuacionATNOMAPS"),
							resultSet.getString("ActuacionATNOMOPS"),
							resultSet.getString("ActuacionATNRLOPS"),
							resultSet.getDate("ActuacionATFEDUMI"),
							resultSet.getString("ActuacionATINPRSE"),
							resultSet.getBigDecimal("ActuacionATCAUNEP"),
							resultSet.getString("ActuacionATTEINFO"),
							resultSet.getString("ActuacionATCOAT"),
							new TipProtocolo(resultSet
									.getString("ActuacionATCOTP"), null, null,
									null, null, null),
							new Acta(resultSet.getString("ActuacionATCOAC"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null),
							new CampahnaRecib(resultSet
									.getString("ActuacionATCOCM"), null, null,
									null, null, null, null),
							new Establecimiento(resultSet
									.getString("ActuacionATCOES"), null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null),
							new Producto(
									resultSet.getString("ActuacionATCOPS"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null),
							new DenunciaRecib(resultSet
									.getString("ActuacionATCOHD"), null, null,
									null, null, null, null),
							new AlertaRecib(resultSet
									.getString("ActuacionATCOAL"), null, null,
									null, null, null, null, null),
							new TipActuacion(resultSet
									.getString("ActuacionATCOTTA"), null, null),
							new TipmotActuacion(resultSet
									.getString("ActuacionATCOTMA"), null, null)));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Pagination
	 * @return Protocolo
	 */
	public Protocolo add(Protocolo protocolo) {

		String query = "INSERT INTO PROTOCOLO( PTCODIGO,PTCOTR,PTCOAT,PTNRPRTP,PTCORETP)"
				+ "VALUES (?,?,?,?,?)";

		Object getTipPregProtocTrcodigoAux = null;
		if (protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrcodigo() != null) {
			getTipPregProtocTrcodigoAux = protocolo.getTipPregProtoc()
					.getTrcodigo();
		}
		Object getActuacionAtcodigoAux = null;
		if (protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcodigo() != null) {
			getActuacionAtcodigoAux = protocolo.getActuacion().getAtcodigo();
		}
		this.jdbcTemplate.update(query, protocolo.getPtcodigo(),
				getTipPregProtocTrcodigoAux, getActuacionAtcodigoAux,
				protocolo.getPtnrprtp(), protocolo.getPtcoretp());
		return protocolo;
	}

	/**
	 * Updates a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Pagination
	 * @return Protocolo
	 */
	public Protocolo update(Protocolo protocolo) {
		String query = "UPDATE PROTOCOLO SET PTCOTR=?,PTCOAT=?,PTNRPRTP=?,PTCORETP=? WHERE PTCODIGO=?";
		Object getTipPregProtocTrcodigoAux = null;
		if (protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrcodigo() != null) {
			getTipPregProtocTrcodigoAux = protocolo.getTipPregProtoc()
					.getTrcodigo();
		}
		Object getActuacionAtcodigoAux = null;
		if (protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcodigo() != null) {
			getActuacionAtcodigoAux = protocolo.getActuacion().getAtcodigo();
		}
		this.jdbcTemplate.update(query, getTipPregProtocTrcodigoAux,
				getActuacionAtcodigoAux, protocolo.getPtnrprtp(),
				protocolo.getPtcoretp(), protocolo.getPtcodigo());
		return protocolo;
	}

	/**
	 * Finds a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Pagination
	 * @return Protocolo
	 */
	@Transactional(readOnly = true)
	public Protocolo find(Protocolo protocolo) {
		String query = "SELECT t1.PTCODIGO PTCODIGO, t1.PTNRPRTP PTNRPRTP, t1.PTCORETP PTCORETP, t2.TRCODIGO TIPPREGPROTOCTRCODIGO, t2.TRNRTIPP TIPPREGPROTOCTRNRTIPP, t2.TRCOTIPP TIPPREGPROTOCTRCOTIPP, t2.TRDETIPP TIPPREGPROTOCTRDETIPP, t2.TRINTI TIPPREGPROTOCTRINTI, t2.TRINRE TIPPREGPROTOCTRINRE, t2.TRREES TIPPREGPROTOCTRREES, t3.ATCODIGO ACTUACIONATCODIGO, t3.ATNROR ACTUACIONATNROR, t3.ATCOAV ACTUACIONATCOAV, t3.ATCOSE ACTUACIONATCOSE, t3.ATNOPRSE ACTUACIONATNOPRSE, t3.ATNOMAPS ACTUACIONATNOMAPS, t3.ATNOMOPS ACTUACIONATNOMOPS, t3.ATNRLOPS ACTUACIONATNRLOPS, t3.ATFEDUMI ACTUACIONATFEDUMI, t3.ATINPRSE ACTUACIONATINPRSE, t3.ATCAUNEP ACTUACIONATCAUNEP, t3.ATTEINFO ACTUACIONATTEINFO, t3.ATCOAT ACTUACIONATCOAT, t2.TRCOTP TIPPREGPROTOCTRCOTP, t2.TRCOTTI TIPPREGPROTOCTRCOTTI, t3.ATCOTP ACTUACIONATCOTP, t3.ATCOAC ACTUACIONATCOAC, t3.ATCOCM ACTUACIONATCOCM, t3.ATCOES ACTUACIONATCOES, t3.ATCOPS ACTUACIONATCOPS, t3.ATCOHD ACTUACIONATCOHD, t3.ATCOAL ACTUACIONATCOAL, t3.ATCOTTA ACTUACIONATCOTTA, t3.ATCOTMA ACTUACIONATCOTMA "
				+ "FROM PROTOCOLO t1 , TIP_PREG_PROTOC t2 , ACTUACION t3  "
				+ "WHERE t1.PTCODIGO = ?   AND t1.PTCOTR= t2.TRCODIGO(+) AND t1.PTCOAT= t3.ATCODIGO(+)  ";
		return (Protocolo) this.jdbcTemplate.queryForObject(query, rwMap,
				protocolo.getPtcodigo());
	}

	/**
	 * Removes a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Pagination
	 * @return
	 */
	public void remove(Protocolo protocolo) {
		String query = "DELETE  FROM PROTOCOLO WHERE PTCODIGO=?";
		this.jdbcTemplate.update(query, protocolo.getPtcodigo());
	}

	/**
	 * Removes a single row in the Protocolo table.
	 * 
	 * @param protocoloDetalle
	 *            ProtocoloDetalle
	 * @return
	 */
	public void removeProtocoloActuacion(ProtocoloDetalle protocoloDetalle) {
		String query = "DELETE  FROM PROTOCOLO WHERE PTCOAT=?";
		this.jdbcTemplate.update(query, protocoloDetalle.getAtcodigo());
	}

	/**
	 * Finds a List of rows in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Protocolo> findAll(Protocolo protocolo, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PTCOTR= t2.TRCODIGO(+) AND t1.PTCOAT= t3.ATCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PTCODIGO PTCODIGO,t1.PTNRPRTP PTNRPRTP,t1.PTCORETP PTCORETP,t2.TRCODIGO TIPPREGPROTOCTRCODIGO,t2.TRNRTIPP TIPPREGPROTOCTRNRTIPP,t2.TRCOTIPP TIPPREGPROTOCTRCOTIPP,t2.TRDETIPP TIPPREGPROTOCTRDETIPP,t2.TRINTI TIPPREGPROTOCTRINTI,t2.TRINRE TIPPREGPROTOCTRINRE,t2.TRREES TIPPREGPROTOCTRREES,t3.ATCODIGO ACTUACIONATCODIGO,t3.ATNROR ACTUACIONATNROR,t3.ATCOAV ACTUACIONATCOAV,t3.ATCOSE ACTUACIONATCOSE,t3.ATNOPRSE ACTUACIONATNOPRSE,t3.ATNOMAPS ACTUACIONATNOMAPS,t3.ATNOMOPS ACTUACIONATNOMOPS,t3.ATNRLOPS ACTUACIONATNRLOPS,t3.ATFEDUMI ACTUACIONATFEDUMI,t3.ATINPRSE ACTUACIONATINPRSE,t3.ATCAUNEP ACTUACIONATCAUNEP,t3.ATTEINFO ACTUACIONATTEINFO,t3.ATCOAT ACTUACIONATCOAT,t2.TRCOTP TIPPREGPROTOCTRCOTP,t2.TRCOTTI TIPPREGPROTOCTRCOTTI,t3.ATCOTP ACTUACIONATCOTP,t3.ATCOAC ACTUACIONATCOAC,t3.ATCOCM ACTUACIONATCOCM,t3.ATCOES ACTUACIONATCOES,t3.ATCOPS ACTUACIONATCOPS,t3.ATCOHD ACTUACIONATCOHD,t3.ATCOAL ACTUACIONATCOAL,t3.ATCOTTA ACTUACIONATCOTTA,t3.ATCOTMA ACTUACIONATCOTMA "
						+ "FROM PROTOCOLO t1 ,TIP_PREG_PROTOC t2 ,ACTUACION t3 ");

		if (protocolo != null && protocolo.getPtcodigo() != null) {
			where.append(" AND t1.PTCODIGO = ?");
			params.add(protocolo.getPtcodigo());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(protocolo.getTipPregProtoc().getTrcodigo());
		}
		if (protocolo != null
				&& protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTipProtocolo() != null
				&& protocolo.getTipPregProtoc().getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t2.TRCOTP = ?");
			params.add(protocolo.getTipPregProtoc().getTipProtocolo()
					.getTpcodigo());
		}
		if (protocolo != null
				&& protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTipReqNormativo() != null
				&& protocolo.getTipPregProtoc().getTipReqNormativo()
						.getTticodigo() != null) {
			where.append(" AND t2.TRCOTTI = ?");
			params.add(protocolo.getTipPregProtoc().getTipReqNormativo()
					.getTticodigo());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrnrtipp() != null) {
			where.append(" AND t2.TRNRTIPP = ?");
			params.add(protocolo.getTipPregProtoc().getTrnrtipp());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrcotipp() != null) {
			where.append(" AND t2.TRCOTIPP = ?");
			params.add(protocolo.getTipPregProtoc().getTrcotipp());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrdetipp() != null) {
			where.append(" AND t2.TRDETIPP = ?");
			params.add(protocolo.getTipPregProtoc().getTrdetipp());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrinti() != null) {
			where.append(" AND t2.TRINTI = ?");
			params.add(protocolo.getTipPregProtoc().getTrinti());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrinre() != null) {
			where.append(" AND t2.TRINRE = ?");
			params.add(protocolo.getTipPregProtoc().getTrinre());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrrees() != null) {
			where.append(" AND t2.TRREES = ?");
			params.add(protocolo.getTipPregProtoc().getTrrees());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcodigo() != null) {
			where.append(" AND t3.ATCODIGO = ?");
			params.add(protocolo.getActuacion().getAtcodigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getTipProtocolo() != null
				&& protocolo.getActuacion().getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t3.ATCOTP = ?");
			params.add(protocolo.getActuacion().getTipProtocolo().getTpcodigo());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getActa() != null
				&& protocolo.getActuacion().getActa().getAccodigo() != null) {
			where.append(" AND t3.ATCOAC = ?");
			params.add(protocolo.getActuacion().getActa().getAccodigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getCampahnaRecib() != null
				&& protocolo.getActuacion().getCampahnaRecib().getS4codigo() != null) {
			where.append(" AND t3.ATCOCM = ?");
			params.add(protocolo.getActuacion().getCampahnaRecib()
					.getS4codigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getEstablecimiento() != null
				&& protocolo.getActuacion().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t3.ATCOES = ?");
			params.add(protocolo.getActuacion().getEstablecimiento()
					.getEscodigo());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getProducto() != null
				&& protocolo.getActuacion().getProducto().getPscodigo() != null) {
			where.append(" AND t3.ATCOPS = ?");
			params.add(protocolo.getActuacion().getProducto().getPscodigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getDenunciaRecib() != null
				&& protocolo.getActuacion().getDenunciaRecib().getS6codigo() != null) {
			where.append(" AND t3.ATCOHD = ?");
			params.add(protocolo.getActuacion().getDenunciaRecib()
					.getS6codigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAlertaRecib() != null
				&& protocolo.getActuacion().getAlertaRecib().getS5codigo() != null) {
			where.append(" AND t3.ATCOAL = ?");
			params.add(protocolo.getActuacion().getAlertaRecib().getS5codigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getTipActuacion() != null
				&& protocolo.getActuacion().getTipActuacion().getTtacodigo() != null) {
			where.append(" AND t3.ATCOTTA = ?");
			params.add(protocolo.getActuacion().getTipActuacion()
					.getTtacodigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getTipmotActuacion() != null
				&& protocolo.getActuacion().getTipmotActuacion().getTmacodigo() != null) {
			where.append(" AND t3.ATCOTMA = ?");
			params.add(protocolo.getActuacion().getTipmotActuacion()
					.getTmacodigo());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnror() != null) {
			where.append(" AND t3.ATNROR = ?");
			params.add(protocolo.getActuacion().getAtnror());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcoav() != null) {
			where.append(" AND t3.ATCOAV = ?");
			params.add(protocolo.getActuacion().getAtcoav());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcose() != null) {
			where.append(" AND t3.ATCOSE = ?");
			params.add(protocolo.getActuacion().getAtcose());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnoprse() != null) {
			where.append(" AND t3.ATNOPRSE = ?");
			params.add(protocolo.getActuacion().getAtnoprse());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnomaps() != null) {
			where.append(" AND t3.ATNOMAPS = ?");
			params.add(protocolo.getActuacion().getAtnomaps());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnomops() != null) {
			where.append(" AND t3.ATNOMOPS = ?");
			params.add(protocolo.getActuacion().getAtnomops());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnrlops() != null) {
			where.append(" AND t3.ATNRLOPS = ?");
			params.add(protocolo.getActuacion().getAtnrlops());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtfedumi() != null) {
			where.append(" AND t3.ATFEDUMI = ?");
			params.add(protocolo.getActuacion().getAtfedumi());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtinprse() != null) {
			where.append(" AND t3.ATINPRSE = ?");
			params.add(protocolo.getActuacion().getAtinprse());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcaunep() != null) {
			where.append(" AND t3.ATCAUNEP = ?");
			params.add(protocolo.getActuacion().getAtcaunep());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtteinfo() != null) {
			where.append(" AND t3.ATTEINFO = ?");
			params.add(protocolo.getActuacion().getAtteinfo());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcoat() != null) {
			where.append(" AND t3.ATCOAT = ?");
			params.add(protocolo.getActuacion().getAtcoat());
		}
		if (protocolo != null && protocolo.getPtnrprtp() != null) {
			where.append(" AND t1.PTNRPRTP = ?");
			params.add(protocolo.getPtnrprtp());
		}
		if (protocolo != null && protocolo.getPtcoretp() != null) {
			where.append(" AND t1.PTCORETP = ?");
			params.add(protocolo.getPtcoretp());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Protocolo>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Protocolo> findAllProtocoloActuacionOrdenado(Protocolo protocolo) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  AND t2.TRCODIGO=t1.PTCOTR(+) AND t1.PTCOAT= t3.ATCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PTCODIGO PTCODIGO,t1.PTNRPRTP PTNRPRTP,t1.PTCORETP PTCORETP,t2.TRCODIGO TIPPREGPROTOCTRCODIGO,t2.TRNRTIPP TIPPREGPROTOCTRNRTIPP,t2.TRCOTIPP TIPPREGPROTOCTRCOTIPP,t2.TRDETIPP TIPPREGPROTOCTRDETIPP,t2.TRINTI TIPPREGPROTOCTRINTI,t2.TRINRE TIPPREGPROTOCTRINRE,t2.TRREES TIPPREGPROTOCTRREES,t3.ATCODIGO ACTUACIONATCODIGO,t3.ATNROR ACTUACIONATNROR,t3.ATCOAV ACTUACIONATCOAV,t3.ATCOSE ACTUACIONATCOSE,t3.ATNOPRSE ACTUACIONATNOPRSE,t3.ATNOMAPS ACTUACIONATNOMAPS,t3.ATNOMOPS ACTUACIONATNOMOPS,t3.ATNRLOPS ACTUACIONATNRLOPS,t3.ATFEDUMI ACTUACIONATFEDUMI,t3.ATINPRSE ACTUACIONATINPRSE,t3.ATCAUNEP ACTUACIONATCAUNEP,t3.ATCOAT ACTUACIONATCOAT,t2.TRCOTP TIPPREGPROTOCTRCOTP,t2.TRCOTTI TIPPREGPROTOCTRCOTTI,t3.ATCOTP ACTUACIONATCOTP,t3.ATCOAC ACTUACIONATCOAC,t3.ATCOCM ACTUACIONATCOCM,t3.ATCOES ACTUACIONATCOES,t3.ATCOPS ACTUACIONATCOPS,t3.ATCOHD ACTUACIONATCOHD,t3.ATCOAL ACTUACIONATCOAL,t3.ATCOTTA ACTUACIONATCOTTA,t3.ATCOTMA ACTUACIONATCOTMA "
						+ "FROM PROTOCOLO t1 ,TIP_PREG_PROTOC t2 ,ACTUACION t3 ");

		if (protocolo != null && protocolo.getPtcodigo() != null) {
			where.append(" AND t1.PTCODIGO = ?");
			params.add(protocolo.getPtcodigo());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(protocolo.getTipPregProtoc().getTrcodigo());
		}
		if (protocolo != null
				&& protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTipProtocolo() != null
				&& protocolo.getTipPregProtoc().getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t2.TRCOTP = ?");
			params.add(protocolo.getTipPregProtoc().getTipProtocolo()
					.getTpcodigo());
		}
		if (protocolo != null
				&& protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTipReqNormativo() != null
				&& protocolo.getTipPregProtoc().getTipReqNormativo()
						.getTticodigo() != null) {
			where.append(" AND t2.TRCOTTI = ?");
			params.add(protocolo.getTipPregProtoc().getTipReqNormativo()
					.getTticodigo());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrnrtipp() != null) {
			where.append(" AND t2.TRNRTIPP = ?");
			params.add(protocolo.getTipPregProtoc().getTrnrtipp());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrcotipp() != null) {
			where.append(" AND t2.TRCOTIPP = ?");
			params.add(protocolo.getTipPregProtoc().getTrcotipp());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrdetipp() != null) {
			where.append(" AND t2.TRDETIPP = ?");
			params.add(protocolo.getTipPregProtoc().getTrdetipp());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrinti() != null) {
			where.append(" AND t2.TRINTI = ?");
			params.add(protocolo.getTipPregProtoc().getTrinti());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrinre() != null) {
			where.append(" AND t2.TRINRE = ?");
			params.add(protocolo.getTipPregProtoc().getTrinre());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrrees() != null) {
			where.append(" AND t2.TRREES = ?");
			params.add(protocolo.getTipPregProtoc().getTrrees());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcodigo() != null) {
			where.append(" AND t3.ATCODIGO = ?");
			params.add(protocolo.getActuacion().getAtcodigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getTipProtocolo() != null
				&& protocolo.getActuacion().getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t3.ATCOTP = ?");
			params.add(protocolo.getActuacion().getTipProtocolo().getTpcodigo());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getActa() != null
				&& protocolo.getActuacion().getActa().getAccodigo() != null) {
			where.append(" AND t3.ATCOAC = ?");
			params.add(protocolo.getActuacion().getActa().getAccodigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getCampahnaRecib() != null
				&& protocolo.getActuacion().getCampahnaRecib().getS4codigo() != null) {
			where.append(" AND t3.ATCOCM = ?");
			params.add(protocolo.getActuacion().getCampahnaRecib()
					.getS4codigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getEstablecimiento() != null
				&& protocolo.getActuacion().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t3.ATCOES = ?");
			params.add(protocolo.getActuacion().getEstablecimiento()
					.getEscodigo());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getProducto() != null
				&& protocolo.getActuacion().getProducto().getPscodigo() != null) {
			where.append(" AND t3.ATCOPS = ?");
			params.add(protocolo.getActuacion().getProducto().getPscodigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getDenunciaRecib() != null
				&& protocolo.getActuacion().getDenunciaRecib().getS6codigo() != null) {
			where.append(" AND t3.ATCOHD = ?");
			params.add(protocolo.getActuacion().getDenunciaRecib()
					.getS6codigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAlertaRecib() != null
				&& protocolo.getActuacion().getAlertaRecib().getS5codigo() != null) {
			where.append(" AND t3.ATCOAL = ?");
			params.add(protocolo.getActuacion().getAlertaRecib().getS5codigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getTipActuacion() != null
				&& protocolo.getActuacion().getTipActuacion().getTtacodigo() != null) {
			where.append(" AND t3.ATCOTTA = ?");
			params.add(protocolo.getActuacion().getTipActuacion()
					.getTtacodigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getTipmotActuacion() != null
				&& protocolo.getActuacion().getTipmotActuacion().getTmacodigo() != null) {
			where.append(" AND t3.ATCOTMA = ?");
			params.add(protocolo.getActuacion().getTipmotActuacion()
					.getTmacodigo());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnror() != null) {
			where.append(" AND t3.ATNROR = ?");
			params.add(protocolo.getActuacion().getAtnror());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcoav() != null) {
			where.append(" AND t3.ATCOAV = ?");
			params.add(protocolo.getActuacion().getAtcoav());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcose() != null) {
			where.append(" AND t3.ATCOSE = ?");
			params.add(protocolo.getActuacion().getAtcose());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnoprse() != null) {
			where.append(" AND t3.ATNOPRSE = ?");
			params.add(protocolo.getActuacion().getAtnoprse());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnomaps() != null) {
			where.append(" AND t3.ATNOMAPS = ?");
			params.add(protocolo.getActuacion().getAtnomaps());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnomops() != null) {
			where.append(" AND t3.ATNOMOPS = ?");
			params.add(protocolo.getActuacion().getAtnomops());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnrlops() != null) {
			where.append(" AND t3.ATNRLOPS = ?");
			params.add(protocolo.getActuacion().getAtnrlops());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtfedumi() != null) {
			where.append(" AND t3.ATFEDUMI = ?");
			params.add(protocolo.getActuacion().getAtfedumi());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtinprse() != null) {
			where.append(" AND t3.ATINPRSE = ?");
			params.add(protocolo.getActuacion().getAtinprse());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcaunep() != null) {
			where.append(" AND t3.ATCAUNEP = ?");
			params.add(protocolo.getActuacion().getAtcaunep());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtteinfo() != null) {
			where.append(" AND t3.ATTEINFO = ?");
			params.add(protocolo.getActuacion().getAtteinfo());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcoat() != null) {
			where.append(" AND t3.ATCOAT = ?");
			params.add(protocolo.getActuacion().getAtcoat());
		}
		if (protocolo != null && protocolo.getPtnrprtp() != null) {
			where.append(" AND t1.PTNRPRTP = ?");
			params.add(protocolo.getPtnrprtp());
		}
		if (protocolo != null && protocolo.getPtcoretp() != null) {
			where.append(" AND t1.PTCORETP = ?");
			params.add(protocolo.getPtcoretp());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		order.append(" ORDER BY t2.TRNRTIPP");
		query.append(order);

		return (List<Protocolo>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<Protocolo>() {
					public Protocolo mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Protocolo(
								resultSet.getString("PTCODIGO"),
								resultSet.getInt("PTNRPRTP"),
								resultSet.getString("PTCORETP"),
								new TipPregProtoc(
										resultSet
												.getString("TipPregProtocTRCODIGO"),
										resultSet
												.getLong("TipPregProtocTRNRTIPP"),
										resultSet
												.getString("TipPregProtocTRCOTIPP"),
										resultSet
												.getString("TipPregProtocTRDETIPP"),
										resultSet
												.getString("TipPregProtocTRINTI"),
										resultSet
												.getString("TipPregProtocTRINRE"),
										resultSet
												.getString("TipPregProtocTRREES"),
										new TipProtocolo(
												resultSet
														.getString("TipPregProtocTRCOTP"),
												null, null, null, null, null),
										new TipReqNormativo(
												resultSet
														.getString("TipPregProtocTRCOTTI"),
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null)),
								new Actuacion(
										resultSet
												.getString("ActuacionATCODIGO"),
										resultSet
												.getBigDecimal("ActuacionATNROR"),
										resultSet.getString("ActuacionATCOAV"),
										resultSet.getString("ActuacionATCOSE"),
										resultSet
												.getString("ActuacionATNOPRSE"),
										resultSet
												.getString("ActuacionATNOMAPS"),
										resultSet
												.getString("ActuacionATNOMOPS"),
										resultSet
												.getString("ActuacionATNRLOPS"),
										resultSet.getDate("ActuacionATFEDUMI"),
										resultSet
												.getString("ActuacionATINPRSE"),
										resultSet
												.getBigDecimal("ActuacionATCAUNEP"),
										null, resultSet
												.getString("ActuacionATCOAT"),
										new TipProtocolo(resultSet
												.getString("ActuacionATCOTP"),
												null, null, null, null, null),
										new Acta(resultSet
												.getString("ActuacionATCOAC"),
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null),
										new CampahnaRecib(resultSet
												.getString("ActuacionATCOCM"),
												null, null, null, null, null,
												null),
										new Establecimiento(resultSet
												.getString("ActuacionATCOES"),
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null),
										new Producto(resultSet
												.getString("ActuacionATCOPS"),
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null,
												null, null, null, null, null),
										new DenunciaRecib(resultSet
												.getString("ActuacionATCOHD"),
												null, null, null, null, null,
												null),
										new AlertaRecib(resultSet
												.getString("ActuacionATCOAL"),
												null, null, null, null, null,
												null, null),
										new TipActuacion(resultSet
												.getString("ActuacionATCOTTA"),
												null, null),
										new TipmotActuacion(resultSet
												.getString("ActuacionATCOTMA"),
												null, null)));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Protocolo protocolo) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1   AND t2.TRCODIGO=t1.PTCOTR(+) and t1.PTCOAT= t3.ATCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  PROTOCOLO t1   ,  TIP_PREG_PROTOC t2   ,  ACTUACION t3  ");
		if (protocolo != null && protocolo.getPtcodigo() != null) {
			where.append(" AND t1.PTCODIGO = ?");
			params.add(protocolo.getPtcodigo());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(protocolo.getTipPregProtoc().getTrcodigo());
		}
		if (protocolo != null
				&& protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTipProtocolo() != null
				&& protocolo.getTipPregProtoc().getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t2.TRCOTP = ?");
			params.add(protocolo.getTipPregProtoc().getTipProtocolo()
					.getTpcodigo());
		}
		if (protocolo != null
				&& protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTipReqNormativo() != null
				&& protocolo.getTipPregProtoc().getTipReqNormativo()
						.getTticodigo() != null) {
			where.append(" AND t2.TRCOTTI = ?");
			params.add(protocolo.getTipPregProtoc().getTipReqNormativo()
					.getTticodigo());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrnrtipp() != null) {
			where.append(" AND t2.TRNRTIPP = ?");
			params.add(protocolo.getTipPregProtoc().getTrnrtipp());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrcotipp() != null) {
			where.append(" AND t2.TRCOTIPP = ?");
			params.add(protocolo.getTipPregProtoc().getTrcotipp());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrdetipp() != null) {
			where.append(" AND t2.TRDETIPP = ?");
			params.add(protocolo.getTipPregProtoc().getTrdetipp());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrinti() != null) {
			where.append(" AND t2.TRINTI = ?");
			params.add(protocolo.getTipPregProtoc().getTrinti());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrinre() != null) {
			where.append(" AND t2.TRINRE = ?");
			params.add(protocolo.getTipPregProtoc().getTrinre());
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrrees() != null) {
			where.append(" AND t2.TRREES = ?");
			params.add(protocolo.getTipPregProtoc().getTrrees());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcodigo() != null) {
			where.append(" AND t3.ATCODIGO = ?");
			params.add(protocolo.getActuacion().getAtcodigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getTipProtocolo() != null
				&& protocolo.getActuacion().getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t3.ATCOTP = ?");
			params.add(protocolo.getActuacion().getTipProtocolo().getTpcodigo());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getActa() != null
				&& protocolo.getActuacion().getActa().getAccodigo() != null) {
			where.append(" AND t3.ATCOAC = ?");
			params.add(protocolo.getActuacion().getActa().getAccodigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getCampahnaRecib() != null
				&& protocolo.getActuacion().getCampahnaRecib().getS4codigo() != null) {
			where.append(" AND t3.ATCOCM = ?");
			params.add(protocolo.getActuacion().getCampahnaRecib()
					.getS4codigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getEstablecimiento() != null
				&& protocolo.getActuacion().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t3.ATCOES = ?");
			params.add(protocolo.getActuacion().getEstablecimiento()
					.getEscodigo());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getProducto() != null
				&& protocolo.getActuacion().getProducto().getPscodigo() != null) {
			where.append(" AND t3.ATCOPS = ?");
			params.add(protocolo.getActuacion().getProducto().getPscodigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getDenunciaRecib() != null
				&& protocolo.getActuacion().getDenunciaRecib().getS6codigo() != null) {
			where.append(" AND t3.ATCOHD = ?");
			params.add(protocolo.getActuacion().getDenunciaRecib()
					.getS6codigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAlertaRecib() != null
				&& protocolo.getActuacion().getAlertaRecib().getS5codigo() != null) {
			where.append(" AND t3.ATCOAL = ?");
			params.add(protocolo.getActuacion().getAlertaRecib().getS5codigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getTipActuacion() != null
				&& protocolo.getActuacion().getTipActuacion().getTtacodigo() != null) {
			where.append(" AND t3.ATCOTTA = ?");
			params.add(protocolo.getActuacion().getTipActuacion()
					.getTtacodigo());
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getTipmotActuacion() != null
				&& protocolo.getActuacion().getTipmotActuacion().getTmacodigo() != null) {
			where.append(" AND t3.ATCOTMA = ?");
			params.add(protocolo.getActuacion().getTipmotActuacion()
					.getTmacodigo());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnror() != null) {
			where.append(" AND t3.ATNROR = ?");
			params.add(protocolo.getActuacion().getAtnror());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcoav() != null) {
			where.append(" AND t3.ATCOAV = ?");
			params.add(protocolo.getActuacion().getAtcoav());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcose() != null) {
			where.append(" AND t3.ATCOSE = ?");
			params.add(protocolo.getActuacion().getAtcose());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnoprse() != null) {
			where.append(" AND t3.ATNOPRSE = ?");
			params.add(protocolo.getActuacion().getAtnoprse());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnomaps() != null) {
			where.append(" AND t3.ATNOMAPS = ?");
			params.add(protocolo.getActuacion().getAtnomaps());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnomops() != null) {
			where.append(" AND t3.ATNOMOPS = ?");
			params.add(protocolo.getActuacion().getAtnomops());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnrlops() != null) {
			where.append(" AND t3.ATNRLOPS = ?");
			params.add(protocolo.getActuacion().getAtnrlops());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtfedumi() != null) {
			where.append(" AND t3.ATFEDUMI = ?");
			params.add(protocolo.getActuacion().getAtfedumi());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtinprse() != null) {
			where.append(" AND t3.ATINPRSE = ?");
			params.add(protocolo.getActuacion().getAtinprse());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcaunep() != null) {
			where.append(" AND t3.ATCAUNEP = ?");
			params.add(protocolo.getActuacion().getAtcaunep());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtteinfo() != null) {
			where.append(" AND t3.ATTEINFO = ?");
			params.add(protocolo.getActuacion().getAtteinfo());
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcoat() != null) {
			where.append(" AND t3.ATCOAT = ?");
			params.add(protocolo.getActuacion().getAtcoat());
		}
		if (protocolo != null && protocolo.getPtnrprtp() != null) {
			where.append(" AND t1.PTNRPRTP = ?");
			params.add(protocolo.getPtnrprtp());
		}
		if (protocolo != null && protocolo.getPtcoretp() != null) {
			where.append(" AND t1.PTCORETP = ?");
			params.add(protocolo.getPtcoretp());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Protocolo table using like.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Protocolo> findAllLike(Protocolo protocolo,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PTCOTR= t2.TRCODIGO(+) AND t1.PTCOAT= t3.ATCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PTCODIGO PTCODIGO,t1.PTNRPRTP PTNRPRTP,t1.PTCORETP PTCORETP,t2.TRCODIGO TIPPREGPROTOCTRCODIGO,t2.TRNRTIPP TIPPREGPROTOCTRNRTIPP,t2.TRCOTIPP TIPPREGPROTOCTRCOTIPP,t2.TRDETIPP TIPPREGPROTOCTRDETIPP,t2.TRINTI TIPPREGPROTOCTRINTI,t2.TRINRE TIPPREGPROTOCTRINRE,t2.TRREES TIPPREGPROTOCTRREES,t3.ATCODIGO ACTUACIONATCODIGO,t3.ATNROR ACTUACIONATNROR,t3.ATCOAV ACTUACIONATCOAV,t3.ATCOSE ACTUACIONATCOSE,t3.ATNOPRSE ACTUACIONATNOPRSE,t3.ATNOMAPS ACTUACIONATNOMAPS,t3.ATNOMOPS ACTUACIONATNOMOPS,t3.ATNRLOPS ACTUACIONATNRLOPS,t3.ATFEDUMI ACTUACIONATFEDUMI,t3.ATINPRSE ACTUACIONATINPRSE,t3.ATCAUNEP ACTUACIONATCAUNEP,t3.ATTEINFO ACTUACIONATTEINFO,t3.ATCOAT ACTUACIONATCOAT,t2.TRCOTP TIPPREGPROTOCTRCOTP,t2.TRCOTTI TIPPREGPROTOCTRCOTTI,t3.ATCOTP ACTUACIONATCOTP,t3.ATCOAC ACTUACIONATCOAC,t3.ATCOCM ACTUACIONATCOCM,t3.ATCOES ACTUACIONATCOES,t3.ATCOPS ACTUACIONATCOPS,t3.ATCOHD ACTUACIONATCOHD,t3.ATCOAL ACTUACIONATCOAL,t3.ATCOTTA ACTUACIONATCOTTA,t3.ATCOTMA ACTUACIONATCOTMA "
						+ "FROM PROTOCOLO t1 ,TIP_PREG_PROTOC t2 ,ACTUACION t3 ");

		if (protocolo != null && protocolo.getPtcodigo() != null) {
			where.append(" AND UPPER(t1.PTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getPtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + protocolo.getPtcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PTCODIGO IS NOT NULL");
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getTipPregProtoc().getTrcodigo() + "%");
			} else {
				params.add("%" + protocolo.getTipPregProtoc().getTrcodigo()
						+ "%");
			}
			where.append(" AND t2.TRCODIGO IS NOT NULL");
		}
		if (protocolo != null
				&& protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTipProtocolo() != null
				&& protocolo.getTipPregProtoc().getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND UPPER(t2.TRCOTP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getTipPregProtoc().getTipProtocolo()
						.getTpcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getTipPregProtoc().getTipProtocolo()
								.getTpcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TRCOTP IS NOT NULL");
		}
		if (protocolo != null
				&& protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTipReqNormativo() != null
				&& protocolo.getTipPregProtoc().getTipReqNormativo()
						.getTticodigo() != null) {
			where.append(" AND UPPER(t2.TRCOTTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getTipPregProtoc().getTipReqNormativo()
						.getTticodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getTipPregProtoc().getTipReqNormativo()
								.getTticodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TRCOTTI IS NOT NULL");
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrnrtipp() != null) {
			where.append(" AND t2.TRNRTIPP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getTipPregProtoc().getTrnrtipp() + "%");
			} else {
				params.add("%" + protocolo.getTipPregProtoc().getTrnrtipp()
						+ "%");
			}
			where.append(" AND t2.TRNRTIPP IS NOT NULL");
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrcotipp() != null) {
			where.append(" AND UPPER(t2.TRCOTIPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getTipPregProtoc().getTrcotipp()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getTipPregProtoc().getTrcotipp()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRCOTIPP IS NOT NULL");
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrdetipp() != null) {
			where.append(" AND UPPER(t2.TRDETIPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getTipPregProtoc().getTrdetipp()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getTipPregProtoc().getTrdetipp()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRDETIPP IS NOT NULL");
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrinti() != null) {
			where.append(" AND UPPER(t2.TRINTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getTipPregProtoc().getTrinti()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getTipPregProtoc().getTrinti()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRINTI IS NOT NULL");
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrinre() != null) {
			where.append(" AND UPPER(t2.TRINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getTipPregProtoc().getTrinre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getTipPregProtoc().getTrinre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRINRE IS NOT NULL");
		}
		if (protocolo != null && protocolo.getTipPregProtoc() != null
				&& protocolo.getTipPregProtoc().getTrrees() != null) {
			where.append(" AND UPPER(t2.TRREES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getTipPregProtoc().getTrrees()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getTipPregProtoc().getTrrees()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRREES IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcodigo() != null) {
			where.append(" AND t3.ATCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getAtcodigo() + "%");
			} else {
				params.add("%" + protocolo.getActuacion().getAtcodigo() + "%");
			}
			where.append(" AND t3.ATCODIGO IS NOT NULL");
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getTipProtocolo() != null
				&& protocolo.getActuacion().getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND UPPER(t3.ATCOTP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getTipProtocolo()
						.getTpcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getTipProtocolo()
								.getTpcodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.ATCOTP IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getActa() != null
				&& protocolo.getActuacion().getActa().getAccodigo() != null) {
			where.append(" AND UPPER(t3.ATCOAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getActa().getAccodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getActa().getAccodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ATCOAC IS NOT NULL");
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getCampahnaRecib() != null
				&& protocolo.getActuacion().getCampahnaRecib().getS4codigo() != null) {
			where.append(" AND UPPER(t3.ATCOCM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getCampahnaRecib()
						.getS4codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getCampahnaRecib()
								.getS4codigo().toUpperCase() + "%");
			}
			where.append(" AND t3.ATCOCM IS NOT NULL");
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getEstablecimiento() != null
				&& protocolo.getActuacion().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND UPPER(t3.ATCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getEstablecimiento()
						.getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getEstablecimiento()
								.getEscodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.ATCOES IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getProducto() != null
				&& protocolo.getActuacion().getProducto().getPscodigo() != null) {
			where.append(" AND UPPER(t3.ATCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getProducto().getPscodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getProducto().getPscodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ATCOPS IS NOT NULL");
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getDenunciaRecib() != null
				&& protocolo.getActuacion().getDenunciaRecib().getS6codigo() != null) {
			where.append(" AND UPPER(t3.ATCOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getDenunciaRecib()
						.getS6codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getDenunciaRecib()
								.getS6codigo().toUpperCase() + "%");
			}
			where.append(" AND t3.ATCOHD IS NOT NULL");
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAlertaRecib() != null
				&& protocolo.getActuacion().getAlertaRecib().getS5codigo() != null) {
			where.append(" AND UPPER(t3.ATCOAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getAlertaRecib()
						.getS5codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getAlertaRecib()
								.getS5codigo().toUpperCase() + "%");
			}
			where.append(" AND t3.ATCOAL IS NOT NULL");
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getTipActuacion() != null
				&& protocolo.getActuacion().getTipActuacion().getTtacodigo() != null) {
			where.append(" AND UPPER(t3.ATCOTTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getTipActuacion()
						.getTtacodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getTipActuacion()
								.getTtacodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.ATCOTTA IS NOT NULL");
		}
		if (protocolo != null
				&& protocolo.getActuacion() != null
				&& protocolo.getActuacion().getTipmotActuacion() != null
				&& protocolo.getActuacion().getTipmotActuacion().getTmacodigo() != null) {
			where.append(" AND UPPER(t3.ATCOTMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getTipmotActuacion()
						.getTmacodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getTipmotActuacion()
								.getTmacodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.ATCOTMA IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnror() != null) {
			where.append(" AND t3.ATNROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getAtnror() + "%");
			} else {
				params.add("%" + protocolo.getActuacion().getAtnror() + "%");
			}
			where.append(" AND t3.ATNROR IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcoav() != null) {
			where.append(" AND UPPER(t3.ATCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getAtcoav().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getAtcoav().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ATCOAV IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcose() != null) {
			where.append(" AND UPPER(t3.ATCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getAtcose().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getAtcose().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ATCOSE IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnoprse() != null) {
			where.append(" AND UPPER(t3.ATNOPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getAtnoprse().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getAtnoprse().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ATNOPRSE IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnomaps() != null) {
			where.append(" AND UPPER(t3.ATNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getAtnomaps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getAtnomaps().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ATNOMAPS IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnomops() != null) {
			where.append(" AND UPPER(t3.ATNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getAtnomops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getAtnomops().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ATNOMOPS IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtnrlops() != null) {
			where.append(" AND UPPER(t3.ATNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getAtnrlops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getAtnrlops().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ATNRLOPS IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtfedumi() != null) {
			where.append(" AND t3.ATFEDUMI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getAtfedumi() + "%");
			} else {
				params.add("%" + protocolo.getActuacion().getAtfedumi() + "%");
			}
			where.append(" AND t3.ATFEDUMI IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtinprse() != null) {
			where.append(" AND UPPER(t3.ATINPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getAtinprse().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getAtinprse().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ATINPRSE IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcaunep() != null) {
			where.append(" AND t3.ATCAUNEP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getAtcaunep() + "%");
			} else {
				params.add("%" + protocolo.getActuacion().getAtcaunep() + "%");
			}
			where.append(" AND t3.ATCAUNEP IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtteinfo() != null) {
			where.append(" AND UPPER(t3.ATTEINFO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getAtteinfo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getAtteinfo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ATTEINFO IS NOT NULL");
		}
		if (protocolo != null && protocolo.getActuacion() != null
				&& protocolo.getActuacion().getAtcoat() != null) {
			where.append(" AND UPPER(t3.ATCOAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getActuacion().getAtcoat().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ protocolo.getActuacion().getAtcoat().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ATCOAT IS NOT NULL");
		}
		if (protocolo != null && protocolo.getPtnrprtp() != null) {
			where.append(" AND t1.PTNRPRTP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getPtnrprtp() + "%");
			} else {
				params.add("%" + protocolo.getPtnrprtp() + "%");
			}
			where.append(" AND t1.PTNRPRTP IS NOT NULL");
		}
		if (protocolo != null && protocolo.getPtcoretp() != null) {
			where.append(" AND UPPER(t1.PTCORETP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocolo.getPtcoretp().toUpperCase() + "%");
			} else {
				params.add("%" + protocolo.getPtcoretp().toUpperCase() + "%");
			}
			where.append(" AND t1.PTCORETP IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Protocolo>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
