package com.ejie.y41a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Protocolo;
import com.ejie.y41a.model.ProtocoloDetalle;

/**
 * * ProtocoloDao generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

public interface ProtocoloDao {

	/**
	 * Inserts a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return Protocolo
	 */
	Protocolo add(Protocolo protocolo);

	/**
	 * Updates a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return Protocolo
	 */
	Protocolo update(Protocolo protocolo);

	/**
	 * Finds a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return Protocolo
	 */
	Protocolo find(Protocolo protocolo);

	/**
	 * Deletes a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return
	 */
	void remove(Protocolo protocolo);

	/**
	 * Removes a single row in the Protocolo table.
	 * 
	 * @param protocoloDetalle
	 *            ProtocoloDetalle
	 * @return
	 */
	void removeProtocoloActuacion(ProtocoloDetalle protocoloDetalle);

	/**
	 * Finds a List of rows in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Protocolo> findAll(Protocolo protocolo, Pagination pagination);

	/**
	 * Finds a List of rows in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return List
	 */
	List<Protocolo> findAllProtocoloActuacionOrdenado(Protocolo protocolo);

	/**
	 * Counts rows in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return List
	 */
	Long findAllCount(Protocolo protocolo);

	/**
	 * Finds rows in the Protocolo table using like.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Protocolo> findAllLike(Protocolo protocolo, Pagination pagination,
			Boolean startsWith);
}
