package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.ProdAgrupado;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Producto;

/**
 * * ProductoDaoImpl generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

@Repository
@Transactional
public class ProductoDaoImpl implements ProductoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Producto> rwMap = new RowMapper<Producto>() {
		public Producto mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Producto(resultSet.getString("PSCODIGO"),
					resultSet.getString("PSNOMBRE"),
					resultSet.getString("PSNOCO"),
					resultSet.getString("PSDESCRI"),
					resultSet.getString("PSCOSE"),
					resultSet.getString("PSNOMBREE"),
					resultSet.getString("PSNOMBREI"),
					resultSet.getString("PSNOMBREF"),
					resultSet.getString("PSNOMBREA"),
					resultSet.getString("PSNOCOE"),
					resultSet.getString("PSNOCOI"),
					resultSet.getString("PSNOCOF"),
					resultSet.getString("PSNOCOA"),
					resultSet.getString("PSDESCRIE"),
					resultSet.getString("PSDESCRII"),
					resultSet.getString("PSDESCRIF"),
					resultSet.getString("PSDESCRIA"),
					resultSet.getString("PSSEL1"),
					resultSet.getString("PSCOINC"), new ProdAgrupado(
							resultSet.getString("ProdAgrupadoE8CODIGO"),
							resultSet.getString("ProdAgrupadoE8NOMBRE")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Producto table.
	 * 
	 * @param producto
	 *            Pagination
	 * @return Producto
	 */
	public Producto add(Producto producto) {

		String query = "INSERT INTO PRODUCTO( PSCODIGO,PSCOE8,PSNOMBRE,PSNOCO,PSDESCRI,PSCOSE,PSNOMBREE,PSNOMBREI,PSNOMBREF,PSNOMBREA,PSNOCOE,PSNOCOI,PSNOCOF,PSNOCOA,PSDESCRIE,PSDESCRII,PSDESCRIF,PSDESCRIA,PSSEL1,PSCOINC)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getProdAgrupadoE8codigoAux = null;
		if (producto.getProdAgrupado() != null
				&& producto.getProdAgrupado().getE8codigo() != null) {
			getProdAgrupadoE8codigoAux = producto.getProdAgrupado()
					.getE8codigo();
		}
		this.jdbcTemplate.update(query, producto.getPscodigo(),
				getProdAgrupadoE8codigoAux, producto.getPsnombre(),
				producto.getPsnoco(), producto.getPsdescri(),
				producto.getPscose(), producto.getPsnombree(),
				producto.getPsnombrei(), producto.getPsnombref(),
				producto.getPsnombrea(), producto.getPsnocoe(),
				producto.getPsnocoi(), producto.getPsnocof(),
				producto.getPsnocoa(), producto.getPsdescrie(),
				producto.getPsdescrii(), producto.getPsdescrif(),
				producto.getPsdescria(), producto.getPssel1(),
				producto.getPscoinc());
		return producto;
	}

	/**
	 * Updates a single row in the Producto table.
	 * 
	 * @param producto
	 *            Pagination
	 * @return Producto
	 */
	public Producto update(Producto producto) {
		String query = "UPDATE PRODUCTO SET PSCOE8=?,PSNOMBRE=?,PSNOCO=?,PSDESCRI=?,PSCOSE=?,PSNOMBREE=?,PSNOMBREI=?,PSNOMBREF=?,PSNOMBREA=?,PSNOCOE=?,PSNOCOI=?,PSNOCOF=?,PSNOCOA=?,PSDESCRIE=?,PSDESCRII=?,PSDESCRIF=?,PSDESCRIA=?,PSSEL1=?,PSCOINC=? WHERE PSCODIGO=?";
		Object getProdAgrupadoE8codigoAux = null;
		if (producto.getProdAgrupado() != null
				&& producto.getProdAgrupado().getE8codigo() != null) {
			getProdAgrupadoE8codigoAux = producto.getProdAgrupado()
					.getE8codigo();
		}
		this.jdbcTemplate.update(query, getProdAgrupadoE8codigoAux,
				producto.getPsnombre(), producto.getPsnoco(),
				producto.getPsdescri(), producto.getPscose(),
				producto.getPsnombree(), producto.getPsnombrei(),
				producto.getPsnombref(), producto.getPsnombrea(),
				producto.getPsnocoe(), producto.getPsnocoi(),
				producto.getPsnocof(), producto.getPsnocoa(),
				producto.getPsdescrie(), producto.getPsdescrii(),
				producto.getPsdescrif(), producto.getPsdescria(),
				producto.getPssel1(), producto.getPscoinc(),
				producto.getPscodigo());
		return producto;
	}

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param producto
	 *            Pagination
	 * @return Producto
	 */
	@Transactional(readOnly = true)
	public Producto find(Producto producto) {
		String query = "SELECT t1.PSCODIGO PSCODIGO, t1.PSNOMBRE PSNOMBRE, t1.PSNOCO PSNOCO, t1.PSDESCRI PSDESCRI, t1.PSCOSE PSCOSE, t1.PSNOMBREE PSNOMBREE, t1.PSNOMBREI PSNOMBREI, t1.PSNOMBREF PSNOMBREF, t1.PSNOMBREA PSNOMBREA, t1.PSNOCOE PSNOCOE, t1.PSNOCOI PSNOCOI, t1.PSNOCOF PSNOCOF, t1.PSNOCOA PSNOCOA, t1.PSDESCRIE PSDESCRIE, t1.PSDESCRII PSDESCRII, t1.PSDESCRIF PSDESCRIF, t1.PSDESCRIA PSDESCRIA, t1.PSSEL1 PSSEL1, t1.PSCOINC PSCOINC, t2.E8CODIGO PRODAGRUPADOE8CODIGO, t2.E8NOMBRE PRODAGRUPADOE8NOMBRE "
				+ "FROM PRODUCTO t1 , PROD_AGRUPADO t2  "
				+ "WHERE t1.PSCODIGO = ?   AND t1.PSCOE8= t2.E8CODIGO(+)  ";
		return (Producto) this.jdbcTemplate.queryForObject(query, rwMap,
				producto.getPscodigo());
	}

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param producto
	 *            Pagination
	 * @return Producto
	 */
	@Transactional(readOnly = true)
	public Producto findProductoSeleccionable(Producto producto) {
		String query = "SELECT t1.PSCODIGO PSCODIGO, t1.PSNOMBRE PSNOMBRE, t1.PSNOCO PSNOCO, t1.PSDESCRI PSDESCRI, t1.PSCOSE PSCOSE, t1.PSNOMBREE PSNOMBREE, t1.PSNOMBREI PSNOMBREI, t1.PSNOMBREF PSNOMBREF, t1.PSNOMBREA PSNOMBREA, t1.PSNOCOE PSNOCOE, t1.PSNOCOI PSNOCOI, t1.PSNOCOF PSNOCOF, t1.PSNOCOA PSNOCOA, t1.PSDESCRIE PSDESCRIE, t1.PSDESCRII PSDESCRII, t1.PSDESCRIF PSDESCRIF, t1.PSDESCRIA PSDESCRIA, t1.PSSEL1 PSSEL1, t1.PSCOINC PSCOINC, t2.E8CODIGO PRODAGRUPADOE8CODIGO, t2.E8NOMBRE PRODAGRUPADOE8NOMBRE "
				+ "FROM PRODUCTO t1 , PROD_AGRUPADO t2  "
				+ "WHERE t1.PSCODIGO = ?   AND t1.PSCOE8= t2.E8CODIGO(+) AND t1.PSCOSE = ? ";
		return (Producto) this.jdbcTemplate.queryForObject(query, rwMap,
				producto.getPscodigo(), Y41aConstantes.ELEMENTO_SELECCIONABLE);

	}

	/**
	 * Removes a single row in the Producto table.
	 * 
	 * @param producto
	 *            Pagination
	 * @return
	 */
	public void remove(Producto producto) {
		String query = "DELETE  FROM PRODUCTO WHERE PSCODIGO=?";
		this.jdbcTemplate.update(query, producto.getPscodigo());
	}

	/**
	 * Finds a List of rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Producto> findAll(Producto producto, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PSCOE8= t2.E8CODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PSCODIGO PSCODIGO,t1.PSNOMBRE PSNOMBRE,t1.PSNOCO PSNOCO,t1.PSDESCRI PSDESCRI,t1.PSCOSE PSCOSE,t1.PSNOMBREE PSNOMBREE,t1.PSNOMBREI PSNOMBREI,t1.PSNOMBREF PSNOMBREF,t1.PSNOMBREA PSNOMBREA,t1.PSNOCOE PSNOCOE,t1.PSNOCOI PSNOCOI,t1.PSNOCOF PSNOCOF,t1.PSNOCOA PSNOCOA,t1.PSDESCRIE PSDESCRIE,t1.PSDESCRII PSDESCRII,t1.PSDESCRIF PSDESCRIF,t1.PSDESCRIA PSDESCRIA,t1.PSSEL1 PSSEL1,t1.PSCOINC PSCOINC,t2.E8CODIGO PRODAGRUPADOE8CODIGO,t2.E8NOMBRE PRODAGRUPADOE8NOMBRE "
						+ "FROM PRODUCTO t1 ,PROD_AGRUPADO t2 ");

		if (producto != null && producto.getPscodigo() != null) {
			where.append(" AND t1.PSCODIGO = ?");
			params.add(producto.getPscodigo());
		}
		if (producto != null && producto.getProdAgrupado() != null
				&& producto.getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t2.E8CODIGO = ?");
			params.add(producto.getProdAgrupado().getE8codigo());
		}
		if (producto != null && producto.getProdAgrupado() != null
				&& producto.getProdAgrupado().getE8nombre() != null) {
			where.append(" AND t2.E8NOMBRE = ?");
			params.add(producto.getProdAgrupado().getE8nombre());
		}
		if (producto != null && producto.getPsnombre() != null) {
			where.append(" AND t1.PSNOMBRE = ?");
			params.add(producto.getPsnombre());
		}
		if (producto != null && producto.getPsnoco() != null) {
			where.append(" AND t1.PSNOCO = ?");
			params.add(producto.getPsnoco());
		}
		if (producto != null && producto.getPsdescri() != null) {
			where.append(" AND t1.PSDESCRI = ?");
			params.add(producto.getPsdescri());
		}
		if (producto != null && producto.getPscose() != null) {
			where.append(" AND t1.PSCOSE = ?");
			params.add(producto.getPscose());
		}
		if (producto != null && producto.getPsnombree() != null) {
			where.append(" AND t1.PSNOMBREE = ?");
			params.add(producto.getPsnombree());
		}
		if (producto != null && producto.getPsnombrei() != null) {
			where.append(" AND t1.PSNOMBREI = ?");
			params.add(producto.getPsnombrei());
		}
		if (producto != null && producto.getPsnombref() != null) {
			where.append(" AND t1.PSNOMBREF = ?");
			params.add(producto.getPsnombref());
		}
		if (producto != null && producto.getPsnombrea() != null) {
			where.append(" AND t1.PSNOMBREA = ?");
			params.add(producto.getPsnombrea());
		}
		if (producto != null && producto.getPsnocoe() != null) {
			where.append(" AND t1.PSNOCOE = ?");
			params.add(producto.getPsnocoe());
		}
		if (producto != null && producto.getPsnocoi() != null) {
			where.append(" AND t1.PSNOCOI = ?");
			params.add(producto.getPsnocoi());
		}
		if (producto != null && producto.getPsnocof() != null) {
			where.append(" AND t1.PSNOCOF = ?");
			params.add(producto.getPsnocof());
		}
		if (producto != null && producto.getPsnocoa() != null) {
			where.append(" AND t1.PSNOCOA = ?");
			params.add(producto.getPsnocoa());
		}
		if (producto != null && producto.getPsdescrie() != null) {
			where.append(" AND t1.PSDESCRIE = ?");
			params.add(producto.getPsdescrie());
		}
		if (producto != null && producto.getPsdescrii() != null) {
			where.append(" AND t1.PSDESCRII = ?");
			params.add(producto.getPsdescrii());
		}
		if (producto != null && producto.getPsdescrif() != null) {
			where.append(" AND t1.PSDESCRIF = ?");
			params.add(producto.getPsdescrif());
		}
		if (producto != null && producto.getPsdescria() != null) {
			where.append(" AND t1.PSDESCRIA = ?");
			params.add(producto.getPsdescria());
		}
		if (producto != null && producto.getPssel1() != null) {
			where.append(" AND t1.PSSEL1 = ?");
			params.add(producto.getPssel1());
		}
		if (producto != null && producto.getPscoinc() != null) {
			where.append(" AND t1.PSCOINC = ?");
			params.add(producto.getPscoinc());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Producto>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Producto producto) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.PSCOE8= t2.E8CODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  PRODUCTO t1   ,  PROD_AGRUPADO t2  ");
		if (producto != null && producto.getPscodigo() != null) {
			where.append(" AND t1.PSCODIGO = ?");
			params.add(producto.getPscodigo());
		}
		if (producto != null && producto.getProdAgrupado() != null
				&& producto.getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t2.E8CODIGO = ?");
			params.add(producto.getProdAgrupado().getE8codigo());
		}
		if (producto != null && producto.getProdAgrupado() != null
				&& producto.getProdAgrupado().getE8nombre() != null) {
			where.append(" AND t2.E8NOMBRE = ?");
			params.add(producto.getProdAgrupado().getE8nombre());
		}
		if (producto != null && producto.getPsnombre() != null) {
			where.append(" AND t1.PSNOMBRE = ?");
			params.add(producto.getPsnombre());
		}
		if (producto != null && producto.getPsnoco() != null) {
			where.append(" AND t1.PSNOCO = ?");
			params.add(producto.getPsnoco());
		}
		if (producto != null && producto.getPsdescri() != null) {
			where.append(" AND t1.PSDESCRI = ?");
			params.add(producto.getPsdescri());
		}
		if (producto != null && producto.getPscose() != null) {
			where.append(" AND t1.PSCOSE = ?");
			params.add(producto.getPscose());
		}
		if (producto != null && producto.getPsnombree() != null) {
			where.append(" AND t1.PSNOMBREE = ?");
			params.add(producto.getPsnombree());
		}
		if (producto != null && producto.getPsnombrei() != null) {
			where.append(" AND t1.PSNOMBREI = ?");
			params.add(producto.getPsnombrei());
		}
		if (producto != null && producto.getPsnombref() != null) {
			where.append(" AND t1.PSNOMBREF = ?");
			params.add(producto.getPsnombref());
		}
		if (producto != null && producto.getPsnombrea() != null) {
			where.append(" AND t1.PSNOMBREA = ?");
			params.add(producto.getPsnombrea());
		}
		if (producto != null && producto.getPsnocoe() != null) {
			where.append(" AND t1.PSNOCOE = ?");
			params.add(producto.getPsnocoe());
		}
		if (producto != null && producto.getPsnocoi() != null) {
			where.append(" AND t1.PSNOCOI = ?");
			params.add(producto.getPsnocoi());
		}
		if (producto != null && producto.getPsnocof() != null) {
			where.append(" AND t1.PSNOCOF = ?");
			params.add(producto.getPsnocof());
		}
		if (producto != null && producto.getPsnocoa() != null) {
			where.append(" AND t1.PSNOCOA = ?");
			params.add(producto.getPsnocoa());
		}
		if (producto != null && producto.getPsdescrie() != null) {
			where.append(" AND t1.PSDESCRIE = ?");
			params.add(producto.getPsdescrie());
		}
		if (producto != null && producto.getPsdescrii() != null) {
			where.append(" AND t1.PSDESCRII = ?");
			params.add(producto.getPsdescrii());
		}
		if (producto != null && producto.getPsdescrif() != null) {
			where.append(" AND t1.PSDESCRIF = ?");
			params.add(producto.getPsdescrif());
		}
		if (producto != null && producto.getPsdescria() != null) {
			where.append(" AND t1.PSDESCRIA = ?");
			params.add(producto.getPsdescria());
		}
		if (producto != null && producto.getPssel1() != null) {
			where.append(" AND t1.PSSEL1 = ?");
			params.add(producto.getPssel1());
		}
		if (producto != null && producto.getPscoinc() != null) {
			where.append(" AND t1.PSCOINC = ?");
			params.add(producto.getPscoinc());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Producto> findAllLike(Producto producto, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PSCOE8= t2.E8CODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PSCODIGO PSCODIGO,t1.PSNOMBRE PSNOMBRE,t1.PSNOCO PSNOCO,t1.PSDESCRI PSDESCRI,t1.PSCOSE PSCOSE,t1.PSNOMBREE PSNOMBREE,t1.PSNOMBREI PSNOMBREI,t1.PSNOMBREF PSNOMBREF,t1.PSNOMBREA PSNOMBREA,t1.PSNOCOE PSNOCOE,t1.PSNOCOI PSNOCOI,t1.PSNOCOF PSNOCOF,t1.PSNOCOA PSNOCOA,t1.PSDESCRIE PSDESCRIE,t1.PSDESCRII PSDESCRII,t1.PSDESCRIF PSDESCRIF,t1.PSDESCRIA PSDESCRIA,t1.PSSEL1 PSSEL1,t1.PSCOINC PSCOINC,t2.E8CODIGO PRODAGRUPADOE8CODIGO,t2.E8NOMBRE PRODAGRUPADOE8NOMBRE "
						+ "FROM PRODUCTO t1 ,PROD_AGRUPADO t2 ");

		if (producto != null && producto.getPscodigo() != null) {
			where.append(" AND UPPER(t1.PSCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPscodigo().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPscodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PSCODIGO IS NOT NULL");
		}
		if (producto != null && producto.getProdAgrupado() != null
				&& producto.getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t2.E8CODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getProdAgrupado().getE8codigo() + "%");
			} else {
				params.add("%" + producto.getProdAgrupado().getE8codigo() + "%");
			}
			where.append(" AND t2.E8CODIGO IS NOT NULL");
		}
		if (producto != null && producto.getProdAgrupado() != null
				&& producto.getProdAgrupado().getE8nombre() != null) {
			where.append(" AND UPPER(t2.E8NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getProdAgrupado().getE8nombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ producto.getProdAgrupado().getE8nombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.E8NOMBRE IS NOT NULL");
		}
		if (producto != null && producto.getPsnombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.PSNOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombre().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ producto.getPsnombre().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.PSNOMBRE IS NOT NULL");
		}
		if (producto != null && producto.getPsnoco() != null) {
			where.append(" AND UPPER(t1.PSNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnoco().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnoco().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOCO IS NOT NULL");
		}
		if (producto != null && producto.getPsdescri() != null) {
			where.append(" AND UPPER(t1.PSDESCRI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsdescri().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsdescri().toUpperCase() + "%");
			}
			where.append(" AND t1.PSDESCRI IS NOT NULL");
		}
		if (producto != null && producto.getPscose() != null) {
			where.append(" AND UPPER(t1.PSCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPscose().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPscose().toUpperCase() + "%");
			}
			where.append(" AND t1.PSCOSE IS NOT NULL");
		}
		if (producto != null && producto.getPsnombree() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.PSNOMBREE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombree().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ producto.getPsnombree().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.PSNOMBREE IS NOT NULL");
		}
		if (producto != null && producto.getPsnombrei() != null) {
			where.append(" AND UPPER(t1.PSNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombrei().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnombrei().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOMBREI IS NOT NULL");
		}
		if (producto != null && producto.getPsnombref() != null) {
			where.append(" AND UPPER(t1.PSNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombref().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnombref().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOMBREF IS NOT NULL");
		}
		if (producto != null && producto.getPsnombrea() != null) {
			where.append(" AND UPPER(t1.PSNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombrea().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnombrea().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOMBREA IS NOT NULL");
		}
		if (producto != null && producto.getPsnocoe() != null) {
			where.append(" AND UPPER(t1.PSNOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnocoe().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnocoe().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOCOE IS NOT NULL");
		}
		if (producto != null && producto.getPsnocoi() != null) {
			where.append(" AND UPPER(t1.PSNOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnocoi().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnocoi().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOCOI IS NOT NULL");
		}
		if (producto != null && producto.getPsnocof() != null) {
			where.append(" AND UPPER(t1.PSNOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnocof().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnocof().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOCOF IS NOT NULL");
		}
		if (producto != null && producto.getPsnocoa() != null) {
			where.append(" AND UPPER(t1.PSNOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnocoa().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnocoa().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOCOA IS NOT NULL");
		}
		if (producto != null && producto.getPsdescrie() != null) {
			where.append(" AND UPPER(t1.PSDESCRIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsdescrie().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsdescrie().toUpperCase() + "%");
			}
			where.append(" AND t1.PSDESCRIE IS NOT NULL");
		}
		if (producto != null && producto.getPsdescrii() != null) {
			where.append(" AND UPPER(t1.PSDESCRII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsdescrii().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsdescrii().toUpperCase() + "%");
			}
			where.append(" AND t1.PSDESCRII IS NOT NULL");
		}
		if (producto != null && producto.getPsdescrif() != null) {
			where.append(" AND UPPER(t1.PSDESCRIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsdescrif().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsdescrif().toUpperCase() + "%");
			}
			where.append(" AND t1.PSDESCRIF IS NOT NULL");
		}
		if (producto != null && producto.getPsdescria() != null) {
			where.append(" AND UPPER(t1.PSDESCRIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsdescria().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsdescria().toUpperCase() + "%");
			}
			where.append(" AND t1.PSDESCRIA IS NOT NULL");
		}
		if (producto != null && producto.getPssel1() != null) {
			where.append(" AND UPPER(t1.PSSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPssel1().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPssel1().toUpperCase() + "%");
			}
			where.append(" AND t1.PSSEL1 IS NOT NULL");
		}
		if (producto != null && producto.getPscoinc() != null) {
			where.append(" AND UPPER(t1.PSCOINC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPscoinc().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPscoinc().toUpperCase() + "%");
			}
			where.append(" AND t1.PSCOINC IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Producto>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Producto producto, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.PSCOE8= t2.E8CODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  PRODUCTO t1   ,  PROD_AGRUPADO t2  ");
		if (producto != null && producto.getPscodigo() != null) {
			where.append(" AND UPPER(t1.PSCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPscodigo().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPscodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PSCODIGO IS NOT NULL");
		}
		if (producto != null && producto.getProdAgrupado() != null
				&& producto.getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t2.E8CODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getProdAgrupado().getE8codigo() + "%");
			} else {
				params.add("%" + producto.getProdAgrupado().getE8codigo() + "%");
			}
			where.append(" AND t2.E8CODIGO IS NOT NULL");
		}
		if (producto != null && producto.getProdAgrupado() != null
				&& producto.getProdAgrupado().getE8nombre() != null) {
			where.append(" AND UPPER(t2.E8NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getProdAgrupado().getE8nombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ producto.getProdAgrupado().getE8nombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.E8NOMBRE IS NOT NULL");
		}
		if (producto != null && producto.getPsnombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.PSNOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombre().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ producto.getPsnombre().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.PSNOMBRE IS NOT NULL");
		}
		if (producto != null && producto.getPsnoco() != null) {
			where.append(" AND UPPER(t1.PSNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnoco().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnoco().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOCO IS NOT NULL");
		}
		if (producto != null && producto.getPsdescri() != null) {
			where.append(" AND UPPER(t1.PSDESCRI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsdescri().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsdescri().toUpperCase() + "%");
			}
			where.append(" AND t1.PSDESCRI IS NOT NULL");
		}
		if (producto != null && producto.getPscose() != null) {
			where.append(" AND UPPER(t1.PSCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPscose().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPscose().toUpperCase() + "%");
			}
			where.append(" AND t1.PSCOSE IS NOT NULL");
		}
		if (producto != null && producto.getPsnombree() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.PSNOMBREE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombree().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ producto.getPsnombree().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.PSNOMBREE IS NOT NULL");
		}
		if (producto != null && producto.getPsnombrei() != null) {
			where.append(" AND UPPER(t1.PSNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombrei().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnombrei().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOMBREI IS NOT NULL");
		}
		if (producto != null && producto.getPsnombref() != null) {
			where.append(" AND UPPER(t1.PSNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombref().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnombref().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOMBREF IS NOT NULL");
		}
		if (producto != null && producto.getPsnombrea() != null) {
			where.append(" AND UPPER(t1.PSNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombrea().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnombrea().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOMBREA IS NOT NULL");
		}
		if (producto != null && producto.getPsnocoe() != null) {
			where.append(" AND UPPER(t1.PSNOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnocoe().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnocoe().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOCOE IS NOT NULL");
		}
		if (producto != null && producto.getPsnocoi() != null) {
			where.append(" AND UPPER(t1.PSNOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnocoi().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnocoi().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOCOI IS NOT NULL");
		}
		if (producto != null && producto.getPsnocof() != null) {
			where.append(" AND UPPER(t1.PSNOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnocof().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnocof().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOCOF IS NOT NULL");
		}
		if (producto != null && producto.getPsnocoa() != null) {
			where.append(" AND UPPER(t1.PSNOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnocoa().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnocoa().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOCOA IS NOT NULL");
		}
		if (producto != null && producto.getPsdescrie() != null) {
			where.append(" AND UPPER(t1.PSDESCRIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsdescrie().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsdescrie().toUpperCase() + "%");
			}
			where.append(" AND t1.PSDESCRIE IS NOT NULL");
		}
		if (producto != null && producto.getPsdescrii() != null) {
			where.append(" AND UPPER(t1.PSDESCRII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsdescrii().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsdescrii().toUpperCase() + "%");
			}
			where.append(" AND t1.PSDESCRII IS NOT NULL");
		}
		if (producto != null && producto.getPsdescrif() != null) {
			where.append(" AND UPPER(t1.PSDESCRIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsdescrif().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsdescrif().toUpperCase() + "%");
			}
			where.append(" AND t1.PSDESCRIF IS NOT NULL");
		}
		if (producto != null && producto.getPsdescria() != null) {
			where.append(" AND UPPER(t1.PSDESCRIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsdescria().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsdescria().toUpperCase() + "%");
			}
			where.append(" AND t1.PSDESCRIA IS NOT NULL");
		}
		if (producto != null && producto.getPssel1() != null) {
			where.append(" AND UPPER(t1.PSSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPssel1().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPssel1().toUpperCase() + "%");
			}
			where.append(" AND t1.PSSEL1 IS NOT NULL");
		}
		if (producto != null && producto.getPscoinc() != null) {
			where.append(" AND UPPER(t1.PSCOINC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPscoinc().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPscoinc().toUpperCase() + "%");
			}
			where.append(" AND t1.PSCOINC IS NOT NULL");
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Producto> findAllLikeProducto(Producto producto,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PSCOE8= t2.E8CODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PSCODIGO PSCODIGO,t1.PSNOMBRE PSNOMBRE,t1.PSNOCO PSNOCO,t1.PSDESCRI PSDESCRI,t1.PSCOSE PSCOSE,t1.PSNOMBREE PSNOMBREE,t1.PSNOMBREI PSNOMBREI,t1.PSNOMBREF PSNOMBREF,t1.PSNOMBREA PSNOMBREA,t1.PSNOCOE PSNOCOE,t1.PSNOCOI PSNOCOI,t1.PSNOCOF PSNOCOF,t1.PSNOCOA PSNOCOA,t1.PSDESCRIE PSDESCRIE,t1.PSDESCRII PSDESCRII,t1.PSDESCRIF PSDESCRIF,t1.PSDESCRIA PSDESCRIA,t1.PSSEL1 PSSEL1,t1.PSCOINC PSCOINC,t2.E8CODIGO PRODAGRUPADOE8CODIGO,t2.E8NOMBRE PRODAGRUPADOE8NOMBRE "
						+ "FROM PRODUCTO t1 ,PROD_AGRUPADO t2 ");

		if (producto != null && producto.getPscodigo() != null) {
			where.append(" AND UPPER(t1.PSCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPscodigo().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPscodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PSCODIGO IS NOT NULL");
		}
		if (producto != null && producto.getProdAgrupado() != null
				&& producto.getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t2.E8CODIGO = ?");
			params.add(producto.getProdAgrupado().getE8codigo());
		}
		if (producto != null && producto.getProdAgrupado() != null
				&& producto.getProdAgrupado().getE8nombre() != null) {
			where.append(" AND t2.E8NOMBRE = ?");
			params.add(producto.getProdAgrupado().getE8nombre());
		}
		if (producto != null && producto.getPsnombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.PSNOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombre().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ producto.getPsnombre().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.PSNOMBRE IS NOT NULL");
		}
		if (producto != null && producto.getPsnoco() != null) {
			where.append(" AND t1.PSNOCO = ?");
			params.add(producto.getPsnoco());
		}
		if (producto != null && producto.getPsdescri() != null) {
			where.append(" AND t1.PSDESCRI = ?");
			params.add(producto.getPsdescri());
		}
		if (producto != null && producto.getPscose() != null) {
			where.append(" AND t1.PSCOSE = ?");
			params.add(producto.getPscose());
		}
		if (producto != null && producto.getPsnombree() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.PSNOMBREE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombree().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ producto.getPsnombree().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.PSNOMBREE IS NOT NULL");
		}
		if (producto != null && producto.getPsnombrei() != null) {
			where.append(" AND UPPER(t1.PSNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombrei().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnombrei().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOMBREI IS NOT NULL");
		}
		if (producto != null && producto.getPsnombref() != null) {
			where.append(" AND UPPER(t1.PSNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombref().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnombref().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOMBREF IS NOT NULL");
		}
		if (producto != null && producto.getPsnombrea() != null) {
			where.append(" AND UPPER(t1.PSNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombrea().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnombrea().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOMBREA IS NOT NULL");
		}
		if (producto != null && producto.getPsnocoe() != null) {
			where.append(" AND t1.PSNOCOE = ?");
			params.add(producto.getPsnocoe());
		}
		if (producto != null && producto.getPsnocoi() != null) {
			where.append(" AND t1.PSNOCOI = ?");
			params.add(producto.getPsnocoi());
		}
		if (producto != null && producto.getPsnocof() != null) {
			where.append(" AND t1.PSNOCOF = ?");
			params.add(producto.getPsnocof());
		}
		if (producto != null && producto.getPsnocoa() != null) {
			where.append(" AND t1.PSNOCOA = ?");
			params.add(producto.getPsnocoa());
		}
		if (producto != null && producto.getPsdescrie() != null) {
			where.append(" AND t1.PSDESCRIE = ?");
			params.add(producto.getPsdescrie());
		}
		if (producto != null && producto.getPsdescrii() != null) {
			where.append(" AND t1.PSDESCRII = ?");
			params.add(producto.getPsdescrii());
		}
		if (producto != null && producto.getPsdescrif() != null) {
			where.append(" AND t1.PSDESCRIF = ?");
			params.add(producto.getPsdescrif());
		}
		if (producto != null && producto.getPsdescria() != null) {
			where.append(" AND t1.PSDESCRIA = ?");
			params.add(producto.getPsdescria());
		}
		if (producto != null && producto.getPssel1() != null) {
			where.append(" AND t1.PSSEL1 = ?");
			params.add(producto.getPssel1());
		}
		if (producto != null && producto.getPscoinc() != null) {
			where.append(" AND t1.PSCOINC = ?");
			params.add(producto.getPscoinc());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Producto>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeProductoCount(Producto producto, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.PSCOE8= t2.E8CODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  PRODUCTO t1   ,  PROD_AGRUPADO t2  ");
		if (producto != null && producto.getPscodigo() != null) {
			where.append(" AND UPPER(t1.PSCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPscodigo().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPscodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PSCODIGO IS NOT NULL");
		}
		if (producto != null && producto.getProdAgrupado() != null
				&& producto.getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t2.E8CODIGO = ?");
			params.add(producto.getProdAgrupado().getE8codigo());
		}
		if (producto != null && producto.getProdAgrupado() != null
				&& producto.getProdAgrupado().getE8nombre() != null) {
			where.append(" AND t2.E8NOMBRE = ?");
			params.add(producto.getProdAgrupado().getE8nombre());
		}
		if (producto != null && producto.getPsnombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.PSNOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombre().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ producto.getPsnombre().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.PSNOMBRE IS NOT NULL");
		}
		if (producto != null && producto.getPsnoco() != null) {
			where.append(" AND t1.PSNOCO = ?");
			params.add(producto.getPsnoco());
		}
		if (producto != null && producto.getPsdescri() != null) {
			where.append(" AND t1.PSDESCRI = ?");
			params.add(producto.getPsdescri());
		}
		if (producto != null && producto.getPscose() != null) {
			where.append(" AND t1.PSCOSE = ?");
			params.add(producto.getPscose());
		}
		if (producto != null && producto.getPsnombree() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.PSNOMBREE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombree().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ producto.getPsnombree().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.PSNOMBREE IS NOT NULL");
		}
		if (producto != null && producto.getPsnombrei() != null) {
			where.append(" AND UPPER(t1.PSNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombrei().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnombrei().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOMBREI IS NOT NULL");
		}
		if (producto != null && producto.getPsnombref() != null) {
			where.append(" AND UPPER(t1.PSNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombref().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnombref().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOMBREF IS NOT NULL");
		}
		if (producto != null && producto.getPsnombrea() != null) {
			where.append(" AND UPPER(t1.PSNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getPsnombrea().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getPsnombrea().toUpperCase() + "%");
			}
			where.append(" AND t1.PSNOMBREA IS NOT NULL");
		}
		if (producto != null && producto.getPsnocoe() != null) {
			where.append(" AND t1.PSNOCOE = ?");
			params.add(producto.getPsnocoe());
		}
		if (producto != null && producto.getPsnocoi() != null) {
			where.append(" AND t1.PSNOCOI = ?");
			params.add(producto.getPsnocoi());
		}
		if (producto != null && producto.getPsnocof() != null) {
			where.append(" AND t1.PSNOCOF = ?");
			params.add(producto.getPsnocof());
		}
		if (producto != null && producto.getPsnocoa() != null) {
			where.append(" AND t1.PSNOCOA = ?");
			params.add(producto.getPsnocoa());
		}
		if (producto != null && producto.getPsdescrie() != null) {
			where.append(" AND t1.PSDESCRIE = ?");
			params.add(producto.getPsdescrie());
		}
		if (producto != null && producto.getPsdescrii() != null) {
			where.append(" AND t1.PSDESCRII = ?");
			params.add(producto.getPsdescrii());
		}
		if (producto != null && producto.getPsdescrif() != null) {
			where.append(" AND t1.PSDESCRIF = ?");
			params.add(producto.getPsdescrif());
		}
		if (producto != null && producto.getPsdescria() != null) {
			where.append(" AND t1.PSDESCRIA = ?");
			params.add(producto.getPsdescria());
		}
		if (producto != null && producto.getPssel1() != null) {
			where.append(" AND t1.PSSEL1 = ?");
			params.add(producto.getPssel1());
		}
		if (producto != null && producto.getPscoinc() != null) {
			where.append(" AND t1.PSCOINC = ?");
			params.add(producto.getPscoinc());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
