package com.ejie.y41a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Producto;

/**
 * * ProductoDao generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

public interface ProductoDao {

	/**
	 * Inserts a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto add(Producto producto);

	/**
	 * Updates a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto update(Producto producto);

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto find(Producto producto);

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param producto
	 *            Pagination
	 * @return Producto
	 */
	Producto findProductoSeleccionable(Producto producto);

	/**
	 * Deletes a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return
	 */
	void remove(Producto producto);

	/**
	 * Finds a List of rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Producto> findAll(Producto producto, Pagination pagination);

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return List
	 */
	Long findAllCount(Producto producto);

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Producto> findAllLike(Producto producto, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	Long findAllLikeCount(Producto producto, Boolean startsWith);

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Producto> findAllLikeProducto(Producto producto,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	Long findAllLikeProductoCount(Producto producto, Boolean startsWith);

}
