package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Motivo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.ProdAgrupado;

/**
 *  * ProdAgrupadoDaoImpl generated by UDA, 01-feb-2012 17:10:36.
 *  
 */
 
@Repository
@Transactional
public class ProdAgrupadoDaoImpl implements ProdAgrupadoDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<ProdAgrupado> rwMap = new RowMapper<ProdAgrupado>() {
		public ProdAgrupado mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new ProdAgrupado(
               resultSet.getString("E8CODIGO"), resultSet.getString("E8NOMBRE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the ProdAgrupado table.
     *
     * @param prodagrupado Pagination
     * @return ProdAgrupado
     */
	public ProdAgrupado add(ProdAgrupado prodagrupado) {

    	String query = "INSERT INTO PROD_AGRUPADO( E8CODIGO,E8NOMBRE)"
        + "VALUES (?,?)";

		this.jdbcTemplate.update(query, prodagrupado.getE8codigo(), prodagrupado.getE8nombre());
		return prodagrupado;
	}

    /**
     * Updates a single row in the ProdAgrupado table.
     *
     * @param prodagrupado Pagination
     * @return ProdAgrupado
     */
    public ProdAgrupado update(ProdAgrupado prodagrupado) {
		String query = "UPDATE PROD_AGRUPADO SET E8NOMBRE=? WHERE E8CODIGO=?";
		this.jdbcTemplate.update(query, prodagrupado.getE8nombre(), prodagrupado.getE8codigo());
		return prodagrupado;
	}

    /**
     * Finds a single row in the ProdAgrupado table.
     *
     * @param prodagrupado Pagination
     * @return ProdAgrupado
     */
    @Transactional (readOnly = true)
    public ProdAgrupado find(ProdAgrupado prodagrupado) {
		String query = "SELECT t1.E8CODIGO E8CODIGO, t1.E8NOMBRE E8NOMBRE " 
         + "FROM PROD_AGRUPADO t1  " 
         + "WHERE t1.E8CODIGO = ?    ";
		return (ProdAgrupado) this.jdbcTemplate.queryForObject(query, 
			rwMap , prodagrupado.getE8codigo());	 
    }

    /**
     * Removes a single row in the ProdAgrupado table.
     *
     * @param prodagrupado Pagination
     * @return
     */
    public void remove(ProdAgrupado prodagrupado) {
		String query = "DELETE  FROM PROD_AGRUPADO WHERE E8CODIGO=?";
		this.jdbcTemplate.update(query, prodagrupado.getE8codigo());
    	}
    
   /**
    * Finds a List of rows in the ProdAgrupado table.
    * 
    * @param prodagrupado ProdAgrupado
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<ProdAgrupado> findAll(ProdAgrupado prodagrupado, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.E8CODIGO E8CODIGO,t1.E8NOMBRE E8NOMBRE " 
			+ "FROM PROD_AGRUPADO t1 ");
		
		if (prodagrupado  != null  && prodagrupado.getE8codigo() != null ) {
			where.append(" AND t1.E8CODIGO = ?");
			params.add(prodagrupado.getE8codigo());
		}
		if (prodagrupado  != null  && prodagrupado.getE8nombre() != null ) {
			where.append(" AND t1.E8NOMBRE = ?");
			params.add(prodagrupado.getE8nombre());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<ProdAgrupado>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the ProdAgrupado table.
     * 
     * @param prodagrupado ProdAgrupado
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(ProdAgrupado prodagrupado) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  PROD_AGRUPADO t1  ");
		if (prodagrupado  != null  && prodagrupado.getE8codigo() != null ) {
			where.append(" AND t1.E8CODIGO = ?");
			params.add(prodagrupado.getE8codigo());
		}
		if (prodagrupado  != null  && prodagrupado.getE8nombre() != null ) {
			where.append(" AND t1.E8NOMBRE = ?");
			params.add(prodagrupado.getE8nombre());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the ProdAgrupado table using like.
     * 
     * @param prodagrupado ProdAgrupado
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<ProdAgrupado> findAllLike(ProdAgrupado prodagrupado, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.E8CODIGO E8CODIGO,t1.E8NOMBRE E8NOMBRE " 
        	+ "FROM PROD_AGRUPADO t1 ");
      	
		if (prodagrupado  != null  && prodagrupado.getE8codigo() != null ) {
			where.append(" AND UPPER(t1.E8CODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(prodagrupado.getE8codigo().toUpperCase()  +"%");
			}else{
				params.add("%"+prodagrupado.getE8codigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.E8CODIGO IS NOT NULL");
        }
		if (prodagrupado  != null  && prodagrupado.getE8nombre() != null ) {
			where.append(" AND UPPER(t1.E8NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(prodagrupado.getE8nombre().toUpperCase()  +"%");
			}else{
				params.add("%"+prodagrupado.getE8nombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.E8NOMBRE IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<ProdAgrupado>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
	/**
     * Inserts a single row in the ProdMotivo table.
     * 
     * @param prodagrupado  ProdAgrupado
     * @return ProdAgrupado 
     */
 	public ProdAgrupado addProdMotivo (ProdAgrupado prodagrupado) {
     	String query = "INSERT INTO L21Q9T00 " 
     		+ "( Q9COE8,Q9COTIR) " 
     		+ " values (?, ?)";

		List<Motivo> auxiliarMotivo = prodagrupado.getMotivos();
		Iterator<Motivo> it =  auxiliarMotivo.iterator();
		while (it.hasNext()) {
			Motivo	motivo = (Motivo) it.next();
			this.jdbcTemplate.update(query, prodagrupado.getE8codigo(), motivo.getTircodigo());
		}
		return prodagrupado;	
	}

    /**
     * Deletes a single row in the ProdMotivo table.
     *
     * @param prodagrupado ProdAgrupado
     * @return
     */
    public  void removeProdMotivo(ProdAgrupado prodagrupado) {
		String query = "DELETE  FROM L21Q9T00 "
			+ " WHERE Q9COE8=? AND Q9COTIR=?" ;
		List<Motivo> auxiliarMotivo = prodagrupado.getMotivos();
		Iterator<Motivo> it =  auxiliarMotivo.iterator();
		while (it.hasNext()) {
			Motivo	motivo = (Motivo) it.next();
		    this.jdbcTemplate.update(query, prodagrupado.getE8codigo(), motivo.getTircodigo());	
		}
	}
	
    /**
     * Find a single row in the findProdMotivo Many To Many relationship.
     *
     * @param prodagrupado ProdAgrupado
     * @param  motivo Motivo
     * @param pagination Pagination
     * @return ProdAgrupado
     */
    @Transactional (readOnly = true)	
    public ProdAgrupado findProdMotivo(ProdAgrupado prodagrupado, Motivo motivo, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		
		where.append("where t1.Q9COTIR = t2.TIRCODIGO AND t1.Q9COE8=?");
		
		params.add(prodagrupado.getE8codigo());
		
		if (motivo.getTircodigo() != null) {
			where.append(" AND t2.TIRCODIGO = ?");
			params.add(motivo.getTircodigo());
		}	
		if (motivo.getTirnombre() != null) {
			where.append(" AND t2.TIRNOMBRE = ?");
			params.add(motivo.getTirnombre());
		}	
		
		StringBuffer query =  new StringBuffer("SELECT t2.Tircodigo TIRCODIGO, t2.TIRNOMBRE TIRNOMBRE FROM L21q9t00 t1,L21Q8T00 t2  ");
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" order by " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
      	}	
		List<Motivo> listaHijo =  this.jdbcTemplate.query(query.toString(),
			new RowMapper<Motivo>() {
         		public Motivo mapRow(ResultSet resultSet, int rowNum)
           				throws SQLException {		
             		return new Motivo(
				resultSet.getString("TIRCODIGO"), resultSet.getString("TIRNOMBRE"), null, null
				);
			}
		} , params.toArray() );	
		prodagrupado.setMotivos(listaHijo);
		return prodagrupado;
	}

    /**
     * Counts rows in the ProdMotivo table.
     * 
     * @param prodagrupado ProdAgrupado
     * @param  motivo Motivo
     * @return Long
     */
	@Transactional (readOnly = true)	
    public Long findProdMotivoCount(ProdAgrupado prodagrupado, Motivo motivo) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.Q9COTIR = t2.TIRCODIGO AND t1.Q9COE8=?");
		
		params.add(prodagrupado.getE8codigo());
		
		if (motivo.getTircodigo() != null) {
			where.append(" AND t2.TIRCODIGO = ?");
			params.add(motivo.getTircodigo());
		}	
		if (motivo.getTirnombre() != null) {
			where.append(" AND t2.TIRNOMBRE = ?");
			params.add(motivo.getTirnombre());
		}	

		StringBuffer query =  new StringBuffer("SELECT count(1) FROM L21q9t00 t1,L21Q8T00 t2  ");
		query.append(where);	
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
    }
}

