package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.FichasSolicitudes;
import com.ejie.y41a.model.PlantillasFichasSolicitudes;
import com.ejie.y41a.utils.jdbc.Y41aJdbcUtils;

/**
 * * PlantillasFichasSolicitudesDaoImpl generated by UDA, 26-ene-2016 17:53:34.
 * 
 *  
 */

@Repository
@Transactional
public class PlantillasFichasSolicitudesDaoImpl implements
		PlantillasFichasSolicitudesDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<PlantillasFichasSolicitudes> rwMap = new RowMapper<PlantillasFichasSolicitudes>() {
		public PlantillasFichasSolicitudes mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {
			return new PlantillasFichasSolicitudes(
					resultSet.getString("PFCODIGO"),
					resultSet.getString("PFCOOR"),
					resultSet.getString("PFNOMBRE"),
					resultSet.getBlob("PFPLANTILLA"),
					resultSet.getDate("PFULTMODIFICACION"),
					resultSet.getString("PFCONTENTTYPEFILE"),
					resultSet.getString("PFNOFILE"),
					resultSet.getInt("PFSIZEFILE"), new FichasSolicitudes(
							resultSet.getString("FichasSolicitudesFICODIGO"),
							resultSet.getString("FichasSolicitudesFINOMBRE"),
							resultSet.getString("FichasSolicitudesFINOMBREE")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the PlantillasFichasSolicitudes table.
	 * 
	 * @param plantillasfichassolicitudes
	 *            Pagination
	 * @return PlantillasFichasSolicitudes
	 */
	public PlantillasFichasSolicitudes add(
			PlantillasFichasSolicitudes plantillasfichassolicitudes) {

		String query = "INSERT INTO PLANTILLAS_FICHAS_SOLICITUDES( PFCODIGO,PFCODFI,PFCOOR,PFNOMBRE,PFPLANTILLA,PFULTMODIFICACION,PFCONTENTTYPEFILE,PFNOFILE,PFSIZEFILE)"
				+ "VALUES (?,?,?,?,?,?,?,?,?)";

		Object getFichasSolicitudesFicodigoAux = null;
		if (plantillasfichassolicitudes.getFichasSolicitudes() != null
				&& plantillasfichassolicitudes.getFichasSolicitudes()
						.getFicodigo() != null) {
			getFichasSolicitudesFicodigoAux = plantillasfichassolicitudes
					.getFichasSolicitudes().getFicodigo();
		}
		byte[] plantilla = null;
		if (plantillasfichassolicitudes.getPfplantilla() != null) {
			plantilla = Y41aJdbcUtils
					.ConvertBlobToByte(plantillasfichassolicitudes
							.getPfplantilla());
		}
		this.jdbcTemplate.update(query,
				plantillasfichassolicitudes.getPfcodigo(),
				getFichasSolicitudesFicodigoAux,
				plantillasfichassolicitudes.getPfcoor(),
				plantillasfichassolicitudes.getPfnombre(), plantilla,
				plantillasfichassolicitudes.getPfultmodificacion(),
				plantillasfichassolicitudes.getPfcontenttypefile(),
				plantillasfichassolicitudes.getPfnofile(),
				plantillasfichassolicitudes.getPfsizefile());
		return plantillasfichassolicitudes;
	}

	/**
	 * Updates a single row in the PlantillasFichasSolicitudes table.
	 * 
	 * @param plantillasfichassolicitudes
	 *            Pagination
	 * @return PlantillasFichasSolicitudes
	 */
	public PlantillasFichasSolicitudes update(
			PlantillasFichasSolicitudes plantillasfichassolicitudes) {
		String query = "UPDATE PLANTILLAS_FICHAS_SOLICITUDES SET PFCODFI=?,PFCOOR=?,PFNOMBRE=?,PFPLANTILLA=?,PFULTMODIFICACION=?,PFCONTENTTYPEFILE=?,PFNOFILE=?,PFSIZEFILE=? WHERE PFCODIGO=?";
		Object getFichasSolicitudesFicodigoAux = null;
		if (plantillasfichassolicitudes.getFichasSolicitudes() != null
				&& plantillasfichassolicitudes.getFichasSolicitudes()
						.getFicodigo() != null) {
			getFichasSolicitudesFicodigoAux = plantillasfichassolicitudes
					.getFichasSolicitudes().getFicodigo();
		}
		this.jdbcTemplate.update(query, getFichasSolicitudesFicodigoAux,
				plantillasfichassolicitudes.getPfcoor(),
				plantillasfichassolicitudes.getPfnombre(),
				plantillasfichassolicitudes.getPfplantilla(),
				plantillasfichassolicitudes.getPfultmodificacion(),
				plantillasfichassolicitudes.getPfcontenttypefile(),
				plantillasfichassolicitudes.getPfnofile(),
				plantillasfichassolicitudes.getPfsizefile(),
				plantillasfichassolicitudes.getPfcodigo());
		return plantillasfichassolicitudes;
	}

	/**
	 * Finds a single row in the PlantillasFichasSolicitudes table. No se
	 * recupera la columna pfplantilla (blob)
	 * 
	 * @param plantillasfichassolicitudes
	 *            PlantillasFichasSolicitudes
	 * @return PlantillasFichasSolicitudes
	 */
	@Transactional(readOnly = true)
	public PlantillasFichasSolicitudes find(
			PlantillasFichasSolicitudes plantillasfichassolicitudes) {
		String query = "SELECT t1.PFCODIGO PFCODIGO, t1.PFCOOR PFCOOR, t1.PFNOMBRE PFNOMBRE, t1.PFPLANTILLA PFPLANTILLA, t1.PFULTMODIFICACION PFULTMODIFICACION, t1.PFCONTENTTYPEFILE PFCONTENTTYPEFILE, t1.PFNOFILE PFNOFILE, t1.PFSIZEFILE PFSIZEFILE, t2.FICODIGO FICHASSOLICITUDESFICODIGO, t2.FINOMBRE FICHASSOLICITUDESFINOMBRE, t2.FINOMBREE FICHASSOLICITUDESFINOMBREE "
				+ "FROM PLANTILLAS_FICHAS_SOLICITUDES t1 , FICHAS_SOLICITUDES t2  "
				+ "WHERE t1.PFCODIGO = ?   AND t1.PFCODFI= t2.FICODIGO(+)  ";
		return (PlantillasFichasSolicitudes) this.jdbcTemplate.queryForObject(
				query, rwMap, plantillasfichassolicitudes.getPfcodigo());
	}

	/**
	 * Finds a List of rows in the PlantillasFichasSolicitudes table.
	 * 
	 * @param plantillasfichassolicitudes
	 *            PlantillasFichasSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlantillasFichasSolicitudes> findAll(
			PlantillasFichasSolicitudes plantillasfichassolicitudes,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PFCODFI= t2.FICODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PFCODIGO PFCODIGO,t1.PFCOOR PFCOOR,t1.PFNOMBRE PFNOMBRE, t1.PFPLANTILLA PFPLANTILLA,t1.PFULTMODIFICACION PFULTMODIFICACION,t1.PFCONTENTTYPEFILE PFCONTENTTYPEFILE,t1.PFNOFILE PFNOFILE,t1.PFSIZEFILE PFSIZEFILE,t2.FICODIGO FICHASSOLICITUDESFICODIGO,t2.FINOMBRE FICHASSOLICITUDESFINOMBRE,t2.FINOMBREE FICHASSOLICITUDESFINOMBREE "
						+ "FROM PLANTILLAS_FICHAS_SOLICITUDES t1 ,FICHAS_SOLICITUDES t2 ");

		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getPfcodigo() != null) {
			where.append(" AND t1.PFCODIGO = ?");
			params.add(plantillasfichassolicitudes.getPfcodigo());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getFichasSolicitudes() != null
				&& plantillasfichassolicitudes.getFichasSolicitudes()
						.getFicodigo() != null) {
			where.append(" AND t2.FICODIGO = ?");
			params.add(plantillasfichassolicitudes.getFichasSolicitudes()
					.getFicodigo());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getFichasSolicitudes() != null
				&& plantillasfichassolicitudes.getFichasSolicitudes()
						.getFinombre() != null) {
			where.append(" AND t2.FINOMBRE = ?");
			params.add(plantillasfichassolicitudes.getFichasSolicitudes()
					.getFinombre());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getFichasSolicitudes() != null
				&& plantillasfichassolicitudes.getFichasSolicitudes()
						.getFinombree() != null) {
			where.append(" AND t2.FINOMBREE = ?");
			params.add(plantillasfichassolicitudes.getFichasSolicitudes()
					.getFinombree());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getPfcoor() != null) {
			where.append(" AND t1.PFCOOR = ?");
			params.add(plantillasfichassolicitudes.getPfcoor());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getPfnombre() != null) {
			where.append(" AND t1.PFNOMBRE = ?");
			params.add(plantillasfichassolicitudes.getPfnombre());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getPfultmodificacion() != null) {
			where.append(" AND t1.PFULTMODIFICACION = ?");
			params.add(plantillasfichassolicitudes.getPfultmodificacion());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getPfcontenttypefile() != null) {
			where.append(" AND t1.PFCONTENTTYPEFILE = ?");
			params.add(plantillasfichassolicitudes.getPfcontenttypefile());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getPfnofile() != null) {
			where.append(" AND t1.PFNOFILE = ?");
			params.add(plantillasfichassolicitudes.getPfnofile());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getPfsizefile() != null) {
			where.append(" AND t1.PFSIZEFILE = ?");
			params.add(plantillasfichassolicitudes.getPfsizefile());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<PlantillasFichasSolicitudes>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the PlantillasFichasSolicitudes table.
	 * 
	 * @param plantillasfichassolicitudes
	 *            PlantillasFichasSolicitudes
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(
			PlantillasFichasSolicitudes plantillasfichassolicitudes) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.PFCODFI= t2.FICODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  PLANTILLAS_FICHAS_SOLICITUDES t1   ,  FICHAS_SOLICITUDES t2  ");
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getPfcodigo() != null) {
			where.append(" AND t1.PFCODIGO = ?");
			params.add(plantillasfichassolicitudes.getPfcodigo());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getFichasSolicitudes() != null
				&& plantillasfichassolicitudes.getFichasSolicitudes()
						.getFicodigo() != null) {
			where.append(" AND t2.FICODIGO = ?");
			params.add(plantillasfichassolicitudes.getFichasSolicitudes()
					.getFicodigo());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getFichasSolicitudes() != null
				&& plantillasfichassolicitudes.getFichasSolicitudes()
						.getFinombre() != null) {
			where.append(" AND t2.FINOMBRE = ?");
			params.add(plantillasfichassolicitudes.getFichasSolicitudes()
					.getFinombre());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getFichasSolicitudes() != null
				&& plantillasfichassolicitudes.getFichasSolicitudes()
						.getFinombree() != null) {
			where.append(" AND t2.FINOMBREE = ?");
			params.add(plantillasfichassolicitudes.getFichasSolicitudes()
					.getFinombree());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getPfcoor() != null) {
			where.append(" AND t1.PFCOOR = ?");
			params.add(plantillasfichassolicitudes.getPfcoor());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getPfnombre() != null) {
			where.append(" AND t1.PFNOMBRE = ?");
			params.add(plantillasfichassolicitudes.getPfnombre());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getPfultmodificacion() != null) {
			where.append(" AND t1.PFULTMODIFICACION = ?");
			params.add(plantillasfichassolicitudes.getPfultmodificacion());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getPfcontenttypefile() != null) {
			where.append(" AND t1.PFCONTENTTYPEFILE = ?");
			params.add(plantillasfichassolicitudes.getPfcontenttypefile());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getPfnofile() != null) {
			where.append(" AND t1.PFNOFILE = ?");
			params.add(plantillasfichassolicitudes.getPfnofile());
		}
		if (plantillasfichassolicitudes != null
				&& plantillasfichassolicitudes.getPfsizefile() != null) {
			where.append(" AND t1.PFSIZEFILE = ?");
			params.add(plantillasfichassolicitudes.getPfsizefile());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Actualiza el fichero binario y sus datos de la plantilla
	 * 
	 * @param plantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes
	 * @return PlantillasFichasSolicitudes
	 */
	public PlantillasFichasSolicitudes updatePlantilla(
			PlantillasFichasSolicitudes plantillasFichasSolicitudes) {
		String query = "UPDATE PLANTILLAS_FICHAS_SOLICITUDES SET PFNOMBRE=?,PFPLANTILLA=?,PFULTMODIFICACION=?,PFCONTENTTYPEFILE=?,PFNOFILE=?,PFSIZEFILE=? WHERE PFCODFI=? AND PFCOOR = ?";
		Object getFichaFicodigoAux = null;
		if (plantillasFichasSolicitudes.getFichasSolicitudes() != null
				&& plantillasFichasSolicitudes.getFichasSolicitudes()
						.getFicodigo() != null) {
			getFichaFicodigoAux = plantillasFichasSolicitudes
					.getFichasSolicitudes().getFicodigo();
		}
		byte[] plantilla = null;
		if (plantillasFichasSolicitudes.getPfplantilla() != null) {
			plantilla = Y41aJdbcUtils
					.ConvertBlobToByte(plantillasFichasSolicitudes
							.getPfplantilla());
		}
		this.jdbcTemplate.update(query,
				plantillasFichasSolicitudes.getPfnombre(), plantilla,
				plantillasFichasSolicitudes.getPfultmodificacion(),
				plantillasFichasSolicitudes.getPfcontenttypefile(),
				plantillasFichasSolicitudes.getPfnofile(),
				plantillasFichasSolicitudes.getPfsizefile(),
				getFichaFicodigoAux, plantillasFichasSolicitudes.getPfcoor());
		return plantillasFichasSolicitudes;
	}
}
