package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Inspecciones;
import com.ejie.y41a.model.PlantillaIns;
import com.ejie.y41a.utils.jdbc.Y41aJdbcUtils;

/**
 * * PlantillaInsDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class PlantillaInsDaoImpl implements PlantillaInsDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<PlantillaIns> rwMap = new RowMapper<PlantillaIns>() {
		public PlantillaIns mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new PlantillaIns(resultSet.getString("PLINSCODIGO"),
					resultSet.getString("PLINSCOOR"),
					resultSet.getString("PLINSNOMBRE"),
					resultSet.getBlob("PLINSPLANTILLA"),
					resultSet.getString("PLINSCONTENTTYPEFILE"),
					resultSet.getString("PLINSNOFILE"),
					resultSet.getInt("PLINSSIZEFILE"),
					resultSet.getDate("PLINSULTMODIFICACION"),
					new Inspecciones(resultSet
							.getString("InspeccionesINSCODCARTA"), resultSet
							.getString("InspeccionesINSNOMBRE"), resultSet
							.getString("InspeccionesINSNOMBREE"), resultSet
							.getDate("InspeccionesINSBAJA")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the PlantillaIns table.
	 * 
	 * @param plantillains
	 *            Pagination
	 * @return PlantillaIns
	 */
	public PlantillaIns add(PlantillaIns plantillains) {

		String query = "INSERT INTO PLANTILLA_INS( PLINSCODIGO,PLINSCODCARTA,PLINSCOOR,PLINSNOMBRE,PLINSPLANTILLA,PLINSCONTENTTYPEFILE,PLINSNOFILE,PLINSSIZEFILE,PLINSULTMODIFICACION)"
				+ "VALUES (?,?,?,?,?,?,?,?,?)";

		Object getInspeccionesInscodcartaAux = null;
		if (plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInscodcarta() != null) {
			getInspeccionesInscodcartaAux = plantillains.getInspecciones()
					.getInscodcarta();
		}

		byte[] plantilla = null;
		if (plantillains.getPlinsplantilla() != null) {
			plantilla = Y41aJdbcUtils.ConvertBlobToByte(plantillains
					.getPlinsplantilla());
		}
		this.jdbcTemplate.update(query, plantillains.getPlinscodigo(),
				getInspeccionesInscodcartaAux, plantillains.getPlinscoor(),
				plantillains.getPlinsnombre(), plantilla,
				plantillains.getPlinscontenttypefile(),
				plantillains.getPlinsnofile(), plantillains.getPlinssizefile(),
				plantillains.getPlinsultmodificacion());
		return plantillains;
	}

	/**
	 * Updates a single row in the PlantillaIns table.
	 * 
	 * @param plantillains
	 *            Pagination
	 * @return PlantillaIns
	 */
	public PlantillaIns update(PlantillaIns plantillains) {
		String query = "UPDATE PLANTILLA_INS SET PLINSCODCARTA=?,PLINSCOOR=?,PLINSNOMBRE=?,PLINSPLANTILLA=?,PLINSCONTENTTYPEFILE=?,PLINSNOFILE=?,PLINSSIZEFILE=?,PLINSULTMODIFICACION=? WHERE PLINSCODIGO=?";
		Object getInspeccionesInscodcartaAux = null;
		if (plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInscodcarta() != null) {
			getInspeccionesInscodcartaAux = plantillains.getInspecciones()
					.getInscodcarta();
		}
		this.jdbcTemplate.update(query, plantillains.getPlinsnombre(),
				plantillains.getPlinsplantilla(),
				plantillains.getPlinscontenttypefile(),
				plantillains.getPlinsnofile(), plantillains.getPlinssizefile(),
				plantillains.getPlinsultmodificacion(),
				plantillains.getPlinscodigo(), getInspeccionesInscodcartaAux,
				plantillains.getPlinscoor());
		return plantillains;
	}

	/**
	 * Updates a single row in the PlantillaIns table.
	 * 
	 * @param plantillains
	 *            Pagination
	 * @return PlantillaIns
	 */
	public PlantillaIns updatePlantilla(PlantillaIns plantillains) {
		String query = "UPDATE PLANTILLA_INS SET PLINSNOMBRE=?,PLINSPLANTILLA=?,PLINSCONTENTTYPEFILE=?,PLINSNOFILE=?,PLINSSIZEFILE=?,PLINSULTMODIFICACION=? WHERE PLINSCODCARTA=? AND PLINSCOOR = ?";
		Object getInspeccionesInscodcartaAux = null;
		if (plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInscodcarta() != null) {
			getInspeccionesInscodcartaAux = plantillains.getInspecciones()
					.getInscodcarta();
		}
		byte[] plantilla = null;
		if (plantillains.getPlinsplantilla() != null) {
			plantilla = Y41aJdbcUtils.ConvertBlobToByte(plantillains
					.getPlinsplantilla());
		}
		this.jdbcTemplate.update(query, plantillains.getPlinsnombre(),
				plantilla, plantillains.getPlinscontenttypefile(),
				plantillains.getPlinsnofile(), plantillains.getPlinssizefile(),
				plantillains.getPlinsultmodificacion(),
				getInspeccionesInscodcartaAux, plantillains.getPlinscoor());
		return plantillains;
	}

	/**
	 * Finds a single row in the PlantillaIns table.
	 * 
	 * @param plantillains
	 *            Pagination
	 * @return PlantillaIns
	 */
	@Transactional(readOnly = true)
	public PlantillaIns find(PlantillaIns plantillains) {
		String query = "SELECT t1.PLINSCODIGO PLINSCODIGO, t1.PLINSCOOR PLINSCOOR, t1.PLINSNOMBRE PLINSNOMBRE, t1.PLINSPLANTILLA PLINSPLANTILLA, t1.PLINSCONTENTTYPEFILE PLINSCONTENTTYPEFILE, t1.PLINSNOFILE PLINSNOFILE, t1.PLINSSIZEFILE PLINSSIZEFILE, t1.PLINSULTMODIFICACION PLINSULTMODIFICACION, t2.INSCODCARTA INSPECCIONESINSCODCARTA, t2.INSNOMBRE INSPECCIONESINSNOMBRE, t2.INSNOMBREE INSPECCIONESINSNOMBREE, t2.INSBAJA INSPECCIONESINSBAJA "
				+ "FROM PLANTILLA_INS t1 , INSPECCIONES t2  "
				+ "WHERE t1.PLINSCODIGO = ?   AND t1.PLINSCODCARTA= t2.INSCODCARTA(+)  ";
		return (PlantillaIns) this.jdbcTemplate.queryForObject(query, rwMap,
				plantillains.getPlinscodigo());
	}

	/**
	 * Finds a single row in the PlantillaIns table.
	 * 
	 * @param plantillains
	 *            Pagination
	 * @return PlantillaIns
	 */
	@Transactional(readOnly = true)
	public PlantillaIns findPlantillaIns(PlantillaIns plantillains) {
		String query = "SELECT t1.PLINSCODIGO PLINSCODIGO, t1.PLINSCOOR PLINSCOOR, t1.PLINSNOMBRE PLINSNOMBRE, t1.PLINSPLANTILLA PLINSPLANTILLA, t1.PLINSCONTENTTYPEFILE PLINSCONTENTTYPEFILE, t1.PLINSNOFILE PLINSNOFILE, t1.PLINSSIZEFILE PLINSSIZEFILE, t1.PLINSULTMODIFICACION PLINSULTMODIFICACION, t2.INSCODCARTA INSPECCIONESINSCODCARTA, t2.INSNOMBRE INSPECCIONESINSNOMBRE, t2.INSNOMBREE INSPECCIONESINSNOMBREE, t2.INSBAJA INSPECCIONESINSBAJA "
				+ "FROM PLANTILLA_INS t1 , INSPECCIONES t2  "
				+ "WHERE t2.INSCODCARTA = ?  AND t1.PLINSCOOR=? AND t1.PLINSCODCARTA= t2.INSCODCARTA(+)  ";
		return (PlantillaIns) this.jdbcTemplate.queryForObject(query, rwMap,
				plantillains.getInspecciones().getInscodcarta(),
				plantillains.getPlinscoor());
	}

	/**
	 * Removes a single row in the PlantillaIns table.
	 * 
	 * @param plantillains
	 *            Pagination
	 * @return
	 */
	public void remove(PlantillaIns plantillains) {
		String query = "DELETE  FROM PLANTILLA_INS WHERE PLINSCODIGO=?";
		this.jdbcTemplate.update(query, plantillains.getPlinscodigo());
	}

	/**
	 * Finds a List of rows in the PlantillaIns table.
	 * 
	 * @param plantillains
	 *            PlantillaIns
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlantillaIns> findAll(PlantillaIns plantillains,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PLINSCODCARTA= t2.INSCODCARTA(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PLINSCODIGO PLINSCODIGO,t1.PLINSCOOR PLINSCOOR,t1.PLINSNOMBRE PLINSNOMBRE, t1.PLINSPLANTILLA PLINSPLANTILLA,t1.PLINSCONTENTTYPEFILE PLINSCONTENTTYPEFILE,t1.PLINSNOFILE PLINSNOFILE,t1.PLINSSIZEFILE PLINSSIZEFILE,t1.PLINSULTMODIFICACION PLINSULTMODIFICACION,t2.INSCODCARTA INSPECCIONESINSCODCARTA,t2.INSNOMBRE INSPECCIONESINSNOMBRE,t2.INSNOMBREE INSPECCIONESINSNOMBREE,t2.INSBAJA INSPECCIONESINSBAJA "
						+ "FROM PLANTILLA_INS t1 ,INSPECCIONES t2 ");

		if (plantillains != null && plantillains.getPlinscodigo() != null) {
			where.append(" AND t1.PLINSCODIGO = ?");
			params.add(plantillains.getPlinscodigo());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInscodcarta() != null) {
			where.append(" AND t2.INSCODCARTA = ?");
			params.add(plantillains.getInspecciones().getInscodcarta());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsnombre() != null) {
			where.append(" AND t2.INSNOMBRE = ?");
			params.add(plantillains.getInspecciones().getInsnombre());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsnombree() != null) {
			where.append(" AND t2.INSNOMBREE = ?");
			params.add(plantillains.getInspecciones().getInsnombree());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsbaja() != null) {
			where.append(" AND t2.INSBAJA = ?");
			params.add(plantillains.getInspecciones().getInsbaja());
		}
		if (plantillains != null && plantillains.getPlinscoor() != null) {
			where.append(" AND t1.PLINSCOOR = ?");
			params.add(plantillains.getPlinscoor());
		}
		if (plantillains != null && plantillains.getPlinsnombre() != null) {
			where.append(" AND t1.PLINSNOMBRE = ?");
			params.add(plantillains.getPlinsnombre());
		}
		if (plantillains != null
				&& plantillains.getPlinscontenttypefile() != null) {
			where.append(" AND t1.PLINSCONTENTTYPEFILE = ?");
			params.add(plantillains.getPlinscontenttypefile());
		}
		if (plantillains != null && plantillains.getPlinsnofile() != null) {
			where.append(" AND t1.PLINSNOFILE = ?");
			params.add(plantillains.getPlinsnofile());
		}
		if (plantillains != null && plantillains.getPlinssizefile() != null) {
			where.append(" AND t1.PLINSSIZEFILE = ?");
			params.add(plantillains.getPlinssizefile());
		}
		if (plantillains != null
				&& plantillains.getPlinsultmodificacion() != null) {
			where.append(" AND t1.PLINSULTMODIFICACION = ?");
			params.add(plantillains.getPlinsultmodificacion());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<PlantillaIns>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the PlantillaIns table.
	 * 
	 * @param plantillains
	 *            PlantillaIns
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlantillaIns> findAllIns(PlantillaIns plantillains,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PLINSCODCARTA= t2.INSCODCARTA(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PLINSCODIGO PLINSCODIGO,t1.PLINSCOOR PLINSCOOR,t1.PLINSNOMBRE PLINSNOMBRE, t1.PLINSPLANTILLA PLINSPLANTILLA,t1.PLINSCONTENTTYPEFILE PLINSCONTENTTYPEFILE,t1.PLINSNOFILE PLINSNOFILE,t1.PLINSSIZEFILE PLINSSIZEFILE,t1.PLINSULTMODIFICACION PLINSULTMODIFICACION,t2.INSCODCARTA INSPECCIONESINSCODCARTA,t2.INSNOMBRE INSPECCIONESINSNOMBRE,t2.INSNOMBREE INSPECCIONESINSNOMBREE,t2.INSBAJA INSPECCIONESINSBAJA "
						+ "FROM PLANTILLA_INS t1 ,INSPECCIONES t2 ");

		if (plantillains != null && plantillains.getPlinscodigo() != null) {
			where.append(" AND t1.PLINSCODIGO = ?");
			params.add(plantillains.getPlinscodigo());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInscodcarta() != null) {
			where.append(" AND t2.INSCODCARTA = ?");
			params.add(plantillains.getInspecciones().getInscodcarta());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsnombre() != null) {
			where.append(" AND t2.INSNOMBRE = ?");
			params.add(plantillains.getInspecciones().getInsnombre());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsnombree() != null) {
			where.append(" AND t2.INSNOMBREE = ?");
			params.add(plantillains.getInspecciones().getInsnombree());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsbaja() != null) {
			where.append(" AND t2.INSBAJA = ?");
			params.add(plantillains.getInspecciones().getInsbaja());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsbaja() == null) {
			where.append(" AND t2.INSBAJA IS NULL");
		}
		if (plantillains != null && plantillains.getPlinscoor() != null) {
			where.append(" AND t1.PLINSCOOR = ?");
			params.add(plantillains.getPlinscoor());
		}
		if (plantillains != null && plantillains.getPlinsnombre() != null) {
			where.append(" AND t1.PLINSNOMBRE = ?");
			params.add(plantillains.getPlinsnombre());
		}
		if (plantillains != null
				&& plantillains.getPlinscontenttypefile() != null) {
			where.append(" AND t1.PLINSCONTENTTYPEFILE = ?");
			params.add(plantillains.getPlinscontenttypefile());
		}
		if (plantillains != null && plantillains.getPlinsnofile() != null) {
			where.append(" AND t1.PLINSNOFILE = ?");
			params.add(plantillains.getPlinsnofile());
		}
		if (plantillains != null && plantillains.getPlinssizefile() != null) {
			where.append(" AND t1.PLINSSIZEFILE = ?");
			params.add(plantillains.getPlinssizefile());
		}
		if (plantillains != null
				&& plantillains.getPlinsultmodificacion() != null) {
			where.append(" AND t1.PLINSULTMODIFICACION = ?");
			params.add(plantillains.getPlinsultmodificacion());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<PlantillaIns>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the PlantillaIns table.
	 * 
	 * @param plantillains
	 *            PlantillaIns
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(PlantillaIns plantillains) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.PLINSCODCARTA= t2.INSCODCARTA(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  PLANTILLA_INS t1   ,  INSPECCIONES t2  ");
		if (plantillains != null && plantillains.getPlinscodigo() != null) {
			where.append(" AND t1.PLINSCODIGO = ?");
			params.add(plantillains.getPlinscodigo());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInscodcarta() != null) {
			where.append(" AND t2.INSCODCARTA = ?");
			params.add(plantillains.getInspecciones().getInscodcarta());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsnombre() != null) {
			where.append(" AND t2.INSNOMBRE = ?");
			params.add(plantillains.getInspecciones().getInsnombre());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsnombree() != null) {
			where.append(" AND t2.INSNOMBREE = ?");
			params.add(plantillains.getInspecciones().getInsnombree());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsbaja() != null) {
			where.append(" AND t2.INSBAJA = ?");
			params.add(plantillains.getInspecciones().getInsbaja());
		}
		if (plantillains != null && plantillains.getPlinscoor() != null) {
			where.append(" AND t1.PLINSCOOR = ?");
			params.add(plantillains.getPlinscoor());
		}
		if (plantillains != null && plantillains.getPlinsnombre() != null) {
			where.append(" AND t1.PLINSNOMBRE = ?");
			params.add(plantillains.getPlinsnombre());
		}
		if (plantillains != null
				&& plantillains.getPlinscontenttypefile() != null) {
			where.append(" AND t1.PLINSCONTENTTYPEFILE = ?");
			params.add(plantillains.getPlinscontenttypefile());
		}
		if (plantillains != null && plantillains.getPlinsnofile() != null) {
			where.append(" AND t1.PLINSNOFILE = ?");
			params.add(plantillains.getPlinsnofile());
		}
		if (plantillains != null && plantillains.getPlinssizefile() != null) {
			where.append(" AND t1.PLINSSIZEFILE = ?");
			params.add(plantillains.getPlinssizefile());
		}
		if (plantillains != null
				&& plantillains.getPlinsultmodificacion() != null) {
			where.append(" AND t1.PLINSULTMODIFICACION = ?");
			params.add(plantillains.getPlinsultmodificacion());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the PlantillaIns table.
	 * 
	 * @param plantillains
	 *            PlantillaIns
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCountInspeccion(PlantillaIns plantillains) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.PLINSCODCARTA= t2.INSCODCARTA(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  PLANTILLA_INS t1   ,  INSPECCIONES t2  ");
		if (plantillains != null && plantillains.getPlinscodigo() != null) {
			where.append(" AND t1.PLINSCODIGO = ?");
			params.add(plantillains.getPlinscodigo());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInscodcarta() != null) {
			where.append(" AND t2.INSCODCARTA = ?");
			params.add(plantillains.getInspecciones().getInscodcarta());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsnombre() != null) {
			where.append(" AND t2.INSNOMBRE = ?");
			params.add(plantillains.getInspecciones().getInsnombre());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsnombree() != null) {
			where.append(" AND t2.INSNOMBREE = ?");
			params.add(plantillains.getInspecciones().getInsnombree());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsbaja() != null) {
			where.append(" AND t2.INSBAJA = ?");
			params.add(plantillains.getInspecciones().getInsbaja());
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsbaja() == null) {
			where.append(" AND t2.INSBAJA IS NULL");
		}
		if (plantillains != null && plantillains.getPlinscoor() != null) {
			where.append(" AND t1.PLINSCOOR = ?");
			params.add(plantillains.getPlinscoor());
		}
		if (plantillains != null && plantillains.getPlinsnombre() != null) {
			where.append(" AND t1.PLINSNOMBRE = ?");
			params.add(plantillains.getPlinsnombre());
		}
		if (plantillains != null
				&& plantillains.getPlinscontenttypefile() != null) {
			where.append(" AND t1.PLINSCONTENTTYPEFILE = ?");
			params.add(plantillains.getPlinscontenttypefile());
		}
		if (plantillains != null && plantillains.getPlinsnofile() != null) {
			where.append(" AND t1.PLINSNOFILE = ?");
			params.add(plantillains.getPlinsnofile());
		}
		if (plantillains != null && plantillains.getPlinssizefile() != null) {
			where.append(" AND t1.PLINSSIZEFILE = ?");
			params.add(plantillains.getPlinssizefile());
		}
		if (plantillains != null
				&& plantillains.getPlinsultmodificacion() != null) {
			where.append(" AND t1.PLINSULTMODIFICACION = ?");
			params.add(plantillains.getPlinsultmodificacion());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the PlantillaIns table using like.
	 * 
	 * @param plantillains
	 *            PlantillaIns
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlantillaIns> findAllLike(PlantillaIns plantillains,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PLINSCODCARTA= t2.INSCODCARTA(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PLINSCODIGO PLINSCODIGO,t1.PLINSCOOR PLINSCOOR,t1.PLINSNOMBRE PLINSNOMBRE, t1.PLINSPLANTILLA PLINSPLANTILLA,t1.PLINSCONTENTTYPEFILE PLINSCONTENTTYPEFILE,t1.PLINSNOFILE PLINSNOFILE,t1.PLINSSIZEFILE PLINSSIZEFILE,t1.PLINSULTMODIFICACION PLINSULTMODIFICACION,t2.INSCODCARTA INSPECCIONESINSCODCARTA,t2.INSNOMBRE INSPECCIONESINSNOMBRE,t2.INSNOMBREE INSPECCIONESINSNOMBREE,t2.INSBAJA INSPECCIONESINSBAJA "
						+ "FROM PLANTILLA_INS t1 ,INSPECCIONES t2 ");

		if (plantillains != null && plantillains.getPlinscodigo() != null) {
			where.append(" AND UPPER(t1.PLINSCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillains.getPlinscodigo().toUpperCase() + "%");
			} else {
				params.add("%" + plantillains.getPlinscodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PLINSCODIGO IS NOT NULL");
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInscodcarta() != null) {
			where.append(" AND t2.INSCODCARTA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillains.getInspecciones().getInscodcarta()
						+ "%");
			} else {
				params.add("%"
						+ plantillains.getInspecciones().getInscodcarta() + "%");
			}
			where.append(" AND t2.INSCODCARTA IS NOT NULL");
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsnombre() != null) {
			where.append(" AND UPPER(t2.INSNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillains.getInspecciones().getInsnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ plantillains.getInspecciones().getInsnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.INSNOMBRE IS NOT NULL");
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsnombree() != null) {
			where.append(" AND UPPER(t2.INSNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillains.getInspecciones().getInsnombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ plantillains.getInspecciones().getInsnombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.INSNOMBREE IS NOT NULL");
		}
		if (plantillains != null && plantillains.getInspecciones() != null
				&& plantillains.getInspecciones().getInsbaja() != null) {
			where.append(" AND t2.INSBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillains.getInspecciones().getInsbaja() + "%");
			} else {
				params.add("%" + plantillains.getInspecciones().getInsbaja()
						+ "%");
			}
			where.append(" AND t2.INSBAJA IS NOT NULL");
		}
		if (plantillains != null && plantillains.getPlinscoor() != null) {
			where.append(" AND UPPER(t1.PLINSCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillains.getPlinscoor().toUpperCase() + "%");
			} else {
				params.add("%" + plantillains.getPlinscoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PLINSCOOR IS NOT NULL");
		}
		if (plantillains != null && plantillains.getPlinsnombre() != null) {
			where.append(" AND UPPER(t1.PLINSNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillains.getPlinsnombre().toUpperCase() + "%");
			} else {
				params.add("%" + plantillains.getPlinsnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PLINSNOMBRE IS NOT NULL");
		}
		if (plantillains != null
				&& plantillains.getPlinscontenttypefile() != null) {
			where.append(" AND UPPER(t1.PLINSCONTENTTYPEFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillains.getPlinscontenttypefile().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ plantillains.getPlinscontenttypefile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PLINSCONTENTTYPEFILE IS NOT NULL");
		}
		if (plantillains != null && plantillains.getPlinsnofile() != null) {
			where.append(" AND UPPER(t1.PLINSNOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillains.getPlinsnofile().toUpperCase() + "%");
			} else {
				params.add("%" + plantillains.getPlinsnofile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PLINSNOFILE IS NOT NULL");
		}
		if (plantillains != null && plantillains.getPlinssizefile() != null) {
			where.append(" AND t1.PLINSSIZEFILE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillains.getPlinssizefile() + "%");
			} else {
				params.add("%" + plantillains.getPlinssizefile() + "%");
			}
			where.append(" AND t1.PLINSSIZEFILE IS NOT NULL");
		}
		if (plantillains != null
				&& plantillains.getPlinsultmodificacion() != null) {
			where.append(" AND t1.PLINSULTMODIFICACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillains.getPlinsultmodificacion() + "%");
			} else {
				params.add("%" + plantillains.getPlinsultmodificacion() + "%");
			}
			where.append(" AND t1.PLINSULTMODIFICACION IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<PlantillaIns>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the PlantillaTramite table.
	 * 
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlantillaIns> findAllInspecciones() {
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT distinct t1.PLINSCOOR PLINSCOOR "
						+ "FROM PLANTILLA_INS t1 ");

		return (List<PlantillaIns>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<PlantillaIns>() {
					public PlantillaIns mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new PlantillaIns(null, resultSet
								.getString("PLINSCOOR"), null, null, null,
								null, null, null, null);

					}
				}, params.toArray());
	}
}
