package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Decision;
import com.ejie.y41a.model.PlantillaDecision;
import com.ejie.y41a.utils.jdbc.Y41aJdbcUtils;

/**
 * * PlantillaDecisionDaoImpl generated by UDA, 05-mar-2012 9:11:42.
 * 
 *  
 */

@Repository
@Transactional
public class PlantillaDecisionDaoImpl implements PlantillaDecisionDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<PlantillaDecision> rwMap = new RowMapper<PlantillaDecision>() {
		public PlantillaDecision mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new PlantillaDecision(resultSet.getString("PDCODIGO"),
					resultSet.getString("PDCOOR"),
					resultSet.getString("PDNOMBRE"),
					resultSet.getString("PDNOMBREE"),
					resultSet.getBlob("PDPLANTILLA"), null,
					resultSet.getDate("PDULTMODIFICACION"),
					resultSet.getString("PDCONTENTTYPEFILE"),
					resultSet.getString("PDNOFILE"),
					resultSet.getInt("PDSIZEFILE"),
					resultSet.getString("PDCONTENTTYPEFILEE"),
					resultSet.getString("PDNOFILEE"),
					resultSet.getInt("PDSIZEFILEE"), new Decision(
							resultSet.getString("DecisionDECODIGO"),
							resultSet.getString("DecisionDENOMBRE"),
							resultSet.getString("DecisionDENOMBREE"),
							resultSet.getDate("DecisionDEBAJA")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            Pagination
	 * @return PlantillaDecision
	 */
	public PlantillaDecision add(PlantillaDecision plantilladecision) {

		String query = "INSERT INTO PLANTILLA_DECISION( PDCODIGO,PDCODDEC,PDCOOR,PDNOMBRE,PDNOMBREE,PDPLANTILLA,PDPLANTILLAE,PDULTMODIFICACION,PDCONTENTTYPEFILE,PDNOFILE,PDSIZEFILE,PDCONTENTTYPEFILEE,PDNOFILEE,PDSIZEFILEE)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getDecisionDecodigoAux = null;
		if (plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDecodigo() != null) {
			getDecisionDecodigoAux = plantilladecision.getDecision()
					.getDecodigo();
		}
		byte[] plantilla = null;
		if (plantilladecision.getPdplantilla() != null) {
			plantilla = Y41aJdbcUtils.ConvertBlobToByte(plantilladecision
					.getPdplantilla());
		}
		this.jdbcTemplate.update(query, plantilladecision.getPdcodigo(),
				getDecisionDecodigoAux, plantilladecision.getPdcoor(),
				plantilladecision.getPdnombre(),
				plantilladecision.getPdnombree(), plantilla,
				plantilladecision.getPdplantillae(),
				plantilladecision.getPdultmodificacion(),
				plantilladecision.getPdcontenttypefile(),
				plantilladecision.getPdnofile(),
				plantilladecision.getPdsizefile(),
				plantilladecision.getPdcontenttypefilee(),
				plantilladecision.getPdnofilee(),
				plantilladecision.getPdsizefilee());
		return plantilladecision;
	}

	/**
	 * Updates a single row in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            Pagination
	 * @return PlantillaDecision
	 */
	public PlantillaDecision update(PlantillaDecision plantilladecision) {
		String query = "UPDATE PLANTILLA_DECISION SET PDCODDEC=?,PDCOOR=?,PDNOMBRE=?,PDNOMBREE=?,PDPLANTILLA=?,PDPLANTILLAE=?,PDULTMODIFICACION=?,PDCONTENTTYPEFILE=?,PDNOFILE=?,PDSIZEFILE=?,PDCONTENTTYPEFILEE=?,PDNOFILEE=?,PDSIZEFILEE=? WHERE PDCODIGO=?";
		Object getDecisionDecodigoAux = null;
		if (plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDecodigo() != null) {
			getDecisionDecodigoAux = plantilladecision.getDecision()
					.getDecodigo();
		}
		byte[] plantilla = null;
		if (plantilladecision.getPdplantilla() != null) {
			plantilla = Y41aJdbcUtils.ConvertBlobToByte(plantilladecision
					.getPdplantilla());
		}
		this.jdbcTemplate.update(query, getDecisionDecodigoAux,
				plantilladecision.getPdcoor(), plantilladecision.getPdnombre(),
				plantilladecision.getPdnombree(), plantilla,
				Y41aJdbcUtils.ConvertBlobToByte(plantilladecision
						.getPdplantillae()), plantilladecision
						.getPdultmodificacion(), plantilladecision
						.getPdcontenttypefile(), plantilladecision
						.getPdnofile(), plantilladecision.getPdsizefile(),
				plantilladecision.getPdcontenttypefilee(), plantilladecision
						.getPdnofilee(), plantilladecision.getPdsizefilee(),
				plantilladecision.getPdcodigo());
		return plantilladecision;
	}

	/**
	 * Updates a single row in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            Pagination
	 * @return PlantillaDecision
	 */
	public PlantillaDecision updateDecision(PlantillaDecision plantilladecision) {
		String query = "UPDATE PLANTILLA_DECISION SET PDNOMBRE=?,PDPLANTILLA=?,PDULTMODIFICACION=?,PDCONTENTTYPEFILE=?,PDNOFILE=?,PDSIZEFILE=? WHERE PDCODDEC=? AND PDCOOR = ?";
		Object getDecisionDecodigoAux = null;
		if (plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDecodigo() != null) {
			getDecisionDecodigoAux = plantilladecision.getDecision()
					.getDecodigo();
		}
		byte[] plantilla = null;
		if (plantilladecision.getPdplantilla() != null) {
			plantilla = Y41aJdbcUtils.ConvertBlobToByte(plantilladecision
					.getPdplantilla());
		}
		this.jdbcTemplate.update(query, plantilladecision.getPdnombre(),
				plantilla, plantilladecision.getPdultmodificacion(),
				plantilladecision.getPdcontenttypefile(),
				plantilladecision.getPdnofile(),
				plantilladecision.getPdsizefile(), getDecisionDecodigoAux,
				plantilladecision.getPdcoor());
		return plantilladecision;
	}

	/**
	 * Finds a single row in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            Pagination
	 * @return PlantillaDecision
	 */
	@Transactional(readOnly = true)
	public PlantillaDecision find(PlantillaDecision plantilladecision) {
		String query = "SELECT t1.PDCODIGO PDCODIGO, t1.PDCOOR PDCOOR, t1.PDNOMBRE PDNOMBRE, t1.PDNOMBREE PDNOMBREE, t1.PDPLANTILLA PDPLANTILLA, t1.PDULTMODIFICACION PDULTMODIFICACION, t1.PDCONTENTTYPEFILE PDCONTENTTYPEFILE, t1.PDNOFILE PDNOFILE, t1.PDSIZEFILE PDSIZEFILE, t1.PDCONTENTTYPEFILEE PDCONTENTTYPEFILEE, t1.PDNOFILEE PDNOFILEE, t1.PDSIZEFILEE PDSIZEFILEE, t2.DECODIGO DECISIONDECODIGO, t2.DENOMBRE DECISIONDENOMBRE, t2.DENOMBREE DECISIONDENOMBREE, t2.DEBAJA DECISIONDEBAJA "
				+ "FROM PLANTILLA_DECISION t1 , DECISION t2  "
				+ "WHERE t1.PDCODIGO = ?   AND t1.PDCODDEC= t2.DECODIGO(+)  ";
		return (PlantillaDecision) this.jdbcTemplate.queryForObject(query,
				rwMap, plantilladecision.getPdcodigo());
	}

	/**
	 * Finds a single row in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            Pagination
	 * @return PlantillaDecision
	 */
	@Transactional(readOnly = true)
	public PlantillaDecision findPlantillaDecision(
			PlantillaDecision plantilladecision) {
		String query = "SELECT t1.PDCODIGO PDCODIGO, t1.PDCOOR PDCOOR, t1.PDNOMBRE PDNOMBRE, t1.PDNOMBREE PDNOMBREE, t1.PDPLANTILLA PDPLANTILLA, t1.PDULTMODIFICACION PDULTMODIFICACION, t1.PDCONTENTTYPEFILE PDCONTENTTYPEFILE, t1.PDNOFILE PDNOFILE, t1.PDSIZEFILE PDSIZEFILE, t1.PDCONTENTTYPEFILEE PDCONTENTTYPEFILEE, t1.PDNOFILEE PDNOFILEE, t1.PDSIZEFILEE PDSIZEFILEE, t2.DECODIGO DECISIONDECODIGO, t2.DENOMBRE DECISIONDENOMBRE, t2.DENOMBREE DECISIONDENOMBREE, t2.DEBAJA DECISIONDEBAJA "
				+ "FROM PLANTILLA_DECISION t1 , DECISION t2  "
				+ "WHERE t2.DECODIGO = ?  AND t1.PDCOOR = ? AND t1.PDCODDEC= t2.DECODIGO(+)  ";
		return (PlantillaDecision) this.jdbcTemplate.queryForObject(query,
				rwMap, plantilladecision.getDecision().getDecodigo(),
				plantilladecision.getPdcoor());
	}

	/**
	 * Removes a single row in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            Pagination
	 * @return
	 */
	public void remove(PlantillaDecision plantilladecision) {
		String query = "DELETE  FROM PLANTILLA_DECISION WHERE PDCODIGO=?";
		this.jdbcTemplate.update(query, plantilladecision.getPdcodigo());
	}

	/**
	 * Finds a List of rows in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlantillaDecision> findAll(PlantillaDecision plantilladecision,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PDCODDEC= t2.DECODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PDCODIGO PDCODIGO,t1.PDCOOR PDCOOR,t1.PDNOMBRE PDNOMBRE,t1.PDNOMBREE PDNOMBREE, t1.PDPLANTILLA PDPLANTILLA,t1.PDULTMODIFICACION PDULTMODIFICACION,t1.PDCONTENTTYPEFILE PDCONTENTTYPEFILE,t1.PDNOFILE PDNOFILE,t1.PDSIZEFILE PDSIZEFILE,t1.PDCONTENTTYPEFILEE PDCONTENTTYPEFILEE,t1.PDNOFILEE PDNOFILEE,t1.PDSIZEFILEE PDSIZEFILEE,t2.DECODIGO DECISIONDECODIGO,t2.DENOMBRE DECISIONDENOMBRE,t2.DENOMBREE DECISIONDENOMBREE,t2.DEBAJA DECISIONDEBAJA "
						+ "FROM PLANTILLA_DECISION t1 ,DECISION t2 ");

		where.append(" AND t2.ISKONTSUMONET = ? ");
		params.add(Y41aConstantes.SI);

		if (plantilladecision != null
				&& plantilladecision.getPdcodigo() != null) {
			where.append(" AND t1.PDCODIGO = ?");
			params.add(plantilladecision.getPdcodigo());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDecodigo() != null) {
			where.append(" AND t2.DECODIGO = ?");
			params.add(plantilladecision.getDecision().getDecodigo());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDenombre() != null) {
			where.append(" AND t2.DENOMBRE = ?");
			params.add(plantilladecision.getDecision().getDenombre());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDenombree() != null) {
			where.append(" AND t2.DENOMBREE = ?");
			params.add(plantilladecision.getDecision().getDenombree());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDebaja() != null) {
			where.append(" AND t2.DEBAJA = ?");
			params.add(plantilladecision.getDecision().getDebaja());
		}
		if (plantilladecision != null && plantilladecision.getPdcoor() != null) {
			where.append(" AND t1.PDCOOR = ?");
			params.add(plantilladecision.getPdcoor());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnombre() != null) {
			where.append(" AND t1.PDNOMBRE = ?");
			params.add(plantilladecision.getPdnombre());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnombree() != null) {
			where.append(" AND t1.PDNOMBREE = ?");
			params.add(plantilladecision.getPdnombree());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdultmodificacion() != null) {
			where.append(" AND t1.PDULTMODIFICACION = ?");
			params.add(plantilladecision.getPdultmodificacion());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdcontenttypefile() != null) {
			where.append(" AND t1.PDCONTENTTYPEFILE = ?");
			params.add(plantilladecision.getPdcontenttypefile());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnofile() != null) {
			where.append(" AND t1.PDNOFILE = ?");
			params.add(plantilladecision.getPdnofile());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdsizefile() != null) {
			where.append(" AND t1.PDSIZEFILE = ?");
			params.add(plantilladecision.getPdsizefile());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdcontenttypefilee() != null) {
			where.append(" AND t1.PDCONTENTTYPEFILEE = ?");
			params.add(plantilladecision.getPdcontenttypefilee());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnofilee() != null) {
			where.append(" AND t1.PDNOFILEE = ?");
			params.add(plantilladecision.getPdnofilee());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdsizefilee() != null) {
			where.append(" AND t1.PDSIZEFILEE = ?");
			params.add(plantilladecision.getPdsizefilee());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<PlantillaDecision>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(PlantillaDecision plantilladecision) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.PDCODDEC= t2.DECODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  PLANTILLA_DECISION t1   ,  DECISION t2  ");

		where.append(" AND t2.ISKONTSUMONET = ? ");
		params.add(Y41aConstantes.SI);

		if (plantilladecision != null
				&& plantilladecision.getPdcodigo() != null) {
			where.append(" AND t1.PDCODIGO = ?");
			params.add(plantilladecision.getPdcodigo());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDecodigo() != null) {
			where.append(" AND t2.DECODIGO = ?");
			params.add(plantilladecision.getDecision().getDecodigo());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDenombre() != null) {
			where.append(" AND t2.DENOMBRE = ?");
			params.add(plantilladecision.getDecision().getDenombre());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDenombree() != null) {
			where.append(" AND t2.DENOMBREE = ?");
			params.add(plantilladecision.getDecision().getDenombree());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDebaja() != null) {
			where.append(" AND t2.DEBAJA = ?");
			params.add(plantilladecision.getDecision().getDebaja());
		}
		if (plantilladecision != null && plantilladecision.getPdcoor() != null) {
			where.append(" AND t1.PDCOOR = ?");
			params.add(plantilladecision.getPdcoor());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnombre() != null) {
			where.append(" AND t1.PDNOMBRE = ?");
			params.add(plantilladecision.getPdnombre());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnombree() != null) {
			where.append(" AND t1.PDNOMBREE = ?");
			params.add(plantilladecision.getPdnombree());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdultmodificacion() != null) {
			where.append(" AND t1.PDULTMODIFICACION = ?");
			params.add(plantilladecision.getPdultmodificacion());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdcontenttypefile() != null) {
			where.append(" AND t1.PDCONTENTTYPEFILE = ?");
			params.add(plantilladecision.getPdcontenttypefile());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnofile() != null) {
			where.append(" AND t1.PDNOFILE = ?");
			params.add(plantilladecision.getPdnofile());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdsizefile() != null) {
			where.append(" AND t1.PDSIZEFILE = ?");
			params.add(plantilladecision.getPdsizefile());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdcontenttypefilee() != null) {
			where.append(" AND t1.PDCONTENTTYPEFILEE = ?");
			params.add(plantilladecision.getPdcontenttypefilee());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnofilee() != null) {
			where.append(" AND t1.PDNOFILEE = ?");
			params.add(plantilladecision.getPdnofilee());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdsizefilee() != null) {
			where.append(" AND t1.PDSIZEFILEE = ?");
			params.add(plantilladecision.getPdsizefilee());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlantillaDecision> findAllDecision(
			PlantillaDecision plantilladecision, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PDCODDEC= t2.DECODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PDCODIGO PDCODIGO,t1.PDCOOR PDCOOR,t1.PDNOMBRE PDNOMBRE,t1.PDNOMBREE PDNOMBREE, t1.PDPLANTILLA PDPLANTILLA,t1.PDULTMODIFICACION PDULTMODIFICACION,t1.PDCONTENTTYPEFILE PDCONTENTTYPEFILE,t1.PDNOFILE PDNOFILE,t1.PDSIZEFILE PDSIZEFILE,t1.PDCONTENTTYPEFILEE PDCONTENTTYPEFILEE,t1.PDNOFILEE PDNOFILEE,t1.PDSIZEFILEE PDSIZEFILEE,t2.DECODIGO DECISIONDECODIGO,t2.DENOMBRE DECISIONDENOMBRE,t2.DENOMBREE DECISIONDENOMBREE,t2.DEBAJA DECISIONDEBAJA "
						+ "FROM PLANTILLA_DECISION t1 ,DECISION t2 ");

		where.append(" AND t2.ISKONTSUMONET = ? ");
		params.add(Y41aConstantes.SI);

		if (plantilladecision != null
				&& plantilladecision.getPdcodigo() != null) {
			where.append(" AND t1.PDCODIGO = ?");
			params.add(plantilladecision.getPdcodigo());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDecodigo() != null) {
			where.append(" AND t2.DECODIGO = ?");
			params.add(plantilladecision.getDecision().getDecodigo());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDenombre() != null) {
			where.append(" AND t2.DENOMBRE = ?");
			params.add(plantilladecision.getDecision().getDenombre());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDenombree() != null) {
			where.append(" AND t2.DENOMBREE = ?");
			params.add(plantilladecision.getDecision().getDenombree());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDebaja() != null) {
			where.append(" AND t2.DEBAJA = ?");
			params.add(plantilladecision.getDecision().getDebaja());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDebaja() == null) {
			where.append(" AND t2.DEBAJA IS NULL ");
		}
		if (plantilladecision != null && plantilladecision.getPdcoor() != null) {
			where.append(" AND t1.PDCOOR = ?");
			params.add(plantilladecision.getPdcoor());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnombre() != null) {
			where.append(" AND t1.PDNOMBRE = ?");
			params.add(plantilladecision.getPdnombre());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnombree() != null) {
			where.append(" AND t1.PDNOMBREE = ?");
			params.add(plantilladecision.getPdnombree());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdultmodificacion() != null) {
			where.append(" AND t1.PDULTMODIFICACION = ?");
			params.add(plantilladecision.getPdultmodificacion());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdcontenttypefile() != null) {
			where.append(" AND t1.PDCONTENTTYPEFILE = ?");
			params.add(plantilladecision.getPdcontenttypefile());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnofile() != null) {
			where.append(" AND t1.PDNOFILE = ?");
			params.add(plantilladecision.getPdnofile());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdsizefile() != null) {
			where.append(" AND t1.PDSIZEFILE = ?");
			params.add(plantilladecision.getPdsizefile());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdcontenttypefilee() != null) {
			where.append(" AND t1.PDCONTENTTYPEFILEE = ?");
			params.add(plantilladecision.getPdcontenttypefilee());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnofilee() != null) {
			where.append(" AND t1.PDNOFILEE = ?");
			params.add(plantilladecision.getPdnofilee());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdsizefilee() != null) {
			where.append(" AND t1.PDSIZEFILEE = ?");
			params.add(plantilladecision.getPdsizefilee());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<PlantillaDecision>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDecisionCount(PlantillaDecision plantilladecision) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.PDCODDEC= t2.DECODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  PLANTILLA_DECISION t1   ,  DECISION t2  ");

		where.append(" AND t2.ISKONTSUMONET = ? ");
		params.add(Y41aConstantes.SI);

		if (plantilladecision != null
				&& plantilladecision.getPdcodigo() != null) {
			where.append(" AND t1.PDCODIGO = ?");
			params.add(plantilladecision.getPdcodigo());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDecodigo() != null) {
			where.append(" AND t2.DECODIGO = ?");
			params.add(plantilladecision.getDecision().getDecodigo());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDenombre() != null) {
			where.append(" AND t2.DENOMBRE = ?");
			params.add(plantilladecision.getDecision().getDenombre());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDenombree() != null) {
			where.append(" AND t2.DENOMBREE = ?");
			params.add(plantilladecision.getDecision().getDenombree());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDebaja() != null) {
			where.append(" AND t2.DEBAJA = ?");
			params.add(plantilladecision.getDecision().getDebaja());
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDebaja() == null) {
			where.append(" AND t2.DEBAJA IS NULL ");
		}
		if (plantilladecision != null && plantilladecision.getPdcoor() != null) {
			where.append(" AND t1.PDCOOR = ?");
			params.add(plantilladecision.getPdcoor());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnombre() != null) {
			where.append(" AND t1.PDNOMBRE = ?");
			params.add(plantilladecision.getPdnombre());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnombree() != null) {
			where.append(" AND t1.PDNOMBREE = ?");
			params.add(plantilladecision.getPdnombree());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdultmodificacion() != null) {
			where.append(" AND t1.PDULTMODIFICACION = ?");
			params.add(plantilladecision.getPdultmodificacion());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdcontenttypefile() != null) {
			where.append(" AND t1.PDCONTENTTYPEFILE = ?");
			params.add(plantilladecision.getPdcontenttypefile());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnofile() != null) {
			where.append(" AND t1.PDNOFILE = ?");
			params.add(plantilladecision.getPdnofile());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdsizefile() != null) {
			where.append(" AND t1.PDSIZEFILE = ?");
			params.add(plantilladecision.getPdsizefile());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdcontenttypefilee() != null) {
			where.append(" AND t1.PDCONTENTTYPEFILEE = ?");
			params.add(plantilladecision.getPdcontenttypefilee());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnofilee() != null) {
			where.append(" AND t1.PDNOFILEE = ?");
			params.add(plantilladecision.getPdnofilee());
		}
		if (plantilladecision != null
				&& plantilladecision.getPdsizefilee() != null) {
			where.append(" AND t1.PDSIZEFILEE = ?");
			params.add(plantilladecision.getPdsizefilee());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the PlantillaDecision table using like.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlantillaDecision> findAllLike(
			PlantillaDecision plantilladecision, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PDCODDEC= t2.DECODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PDCODIGO PDCODIGO,t1.PDCOOR PDCOOR,t1.PDNOMBRE PDNOMBRE,t1.PDNOMBREE PDNOMBREE, t1.PDPLANTILLA PDPLANTILLA,t1.PDULTMODIFICACION PDULTMODIFICACION,t1.PDCONTENTTYPEFILE PDCONTENTTYPEFILE,t1.PDNOFILE PDNOFILE,t1.PDSIZEFILE PDSIZEFILE,t1.PDCONTENTTYPEFILEE PDCONTENTTYPEFILEE,t1.PDNOFILEE PDNOFILEE,t1.PDSIZEFILEE PDSIZEFILEE,t2.DECODIGO DECISIONDECODIGO,t2.DENOMBRE DECISIONDENOMBRE,t2.DENOMBREE DECISIONDENOMBREE,t2.DEBAJA DECISIONDEBAJA "
						+ "FROM PLANTILLA_DECISION t1 ,DECISION t2 ");

		where.append(" AND t2.ISKONTSUMONET = ? ");
		params.add(Y41aConstantes.SI);

		if (plantilladecision != null
				&& plantilladecision.getPdcodigo() != null) {
			where.append(" AND UPPER(t1.PDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getPdcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + plantilladecision.getPdcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PDCODIGO IS NOT NULL");
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDecodigo() != null) {
			where.append(" AND t2.DECODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getDecision().getDecodigo() + "%");
			} else {
				params.add("%" + plantilladecision.getDecision().getDecodigo()
						+ "%");
			}
			where.append(" AND t2.DECODIGO IS NOT NULL");
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDenombre() != null) {
			where.append(" AND UPPER(t2.DENOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getDecision().getDenombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ plantilladecision.getDecision().getDenombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.DENOMBRE IS NOT NULL");
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDenombree() != null) {
			where.append(" AND UPPER(t2.DENOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getDecision().getDenombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ plantilladecision.getDecision().getDenombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.DENOMBREE IS NOT NULL");
		}
		if (plantilladecision != null
				&& plantilladecision.getDecision() != null
				&& plantilladecision.getDecision().getDebaja() != null) {
			where.append(" AND t2.DEBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getDecision().getDebaja() + "%");
			} else {
				params.add("%" + plantilladecision.getDecision().getDebaja()
						+ "%");
			}
			where.append(" AND t2.DEBAJA IS NOT NULL");
		}
		if (plantilladecision != null && plantilladecision.getPdcoor() != null) {
			where.append(" AND UPPER(t1.PDCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getPdcoor().toUpperCase() + "%");
			} else {
				params.add("%" + plantilladecision.getPdcoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PDCOOR IS NOT NULL");
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnombre() != null) {
			where.append(" AND UPPER(t1.PDNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getPdnombre().toUpperCase() + "%");
			} else {
				params.add("%" + plantilladecision.getPdnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PDNOMBRE IS NOT NULL");
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnombree() != null) {
			where.append(" AND UPPER(t1.PDNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getPdnombree().toUpperCase() + "%");
			} else {
				params.add("%" + plantilladecision.getPdnombree().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PDNOMBREE IS NOT NULL");
		}
		if (plantilladecision != null
				&& plantilladecision.getPdultmodificacion() != null) {
			where.append(" AND t1.PDULTMODIFICACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getPdultmodificacion() + "%");
			} else {
				params.add("%" + plantilladecision.getPdultmodificacion() + "%");
			}
			where.append(" AND t1.PDULTMODIFICACION IS NOT NULL");
		}
		if (plantilladecision != null
				&& plantilladecision.getPdcontenttypefile() != null) {
			where.append(" AND UPPER(t1.PDCONTENTTYPEFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getPdcontenttypefile()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ plantilladecision.getPdcontenttypefile()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.PDCONTENTTYPEFILE IS NOT NULL");
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnofile() != null) {
			where.append(" AND UPPER(t1.PDNOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getPdnofile().toUpperCase() + "%");
			} else {
				params.add("%" + plantilladecision.getPdnofile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PDNOFILE IS NOT NULL");
		}
		if (plantilladecision != null
				&& plantilladecision.getPdsizefile() != null) {
			where.append(" AND t1.PDSIZEFILE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getPdsizefile() + "%");
			} else {
				params.add("%" + plantilladecision.getPdsizefile() + "%");
			}
			where.append(" AND t1.PDSIZEFILE IS NOT NULL");
		}
		if (plantilladecision != null
				&& plantilladecision.getPdcontenttypefilee() != null) {
			where.append(" AND UPPER(t1.PDCONTENTTYPEFILEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getPdcontenttypefilee()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ plantilladecision.getPdcontenttypefilee()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.PDCONTENTTYPEFILEE IS NOT NULL");
		}
		if (plantilladecision != null
				&& plantilladecision.getPdnofilee() != null) {
			where.append(" AND UPPER(t1.PDNOFILEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getPdnofilee().toUpperCase() + "%");
			} else {
				params.add("%" + plantilladecision.getPdnofilee().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PDNOFILEE IS NOT NULL");
		}
		if (plantilladecision != null
				&& plantilladecision.getPdsizefilee() != null) {
			where.append(" AND t1.PDSIZEFILEE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantilladecision.getPdsizefilee() + "%");
			} else {
				params.add("%" + plantilladecision.getPdsizefilee() + "%");
			}
			where.append(" AND t1.PDSIZEFILEE IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<PlantillaDecision>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the PlantillaDecision table.
	 * 
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlantillaDecision> findAllOrganismos() {
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT distinct t1.PDCOOR PDCOOR "
						+ "FROM PLANTILLA_DECISION t1 ");

		return (List<PlantillaDecision>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<PlantillaDecision>() {
					public PlantillaDecision mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new PlantillaDecision(null, resultSet
								.getString("PDCOOR"), null, null, null, null,
								null, null, null, null, null, null, null, null);
					}
				}, params.toArray());
	}
}
