package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Parametros;

/**
 * ParametrosDaoImpl generated by UDA, 11-feb-2014 13:33:50.
 * 
 *  
 */

@Repository
@Transactional
public class ParametrosDaoImpl implements ParametrosDao {
	private JdbcTemplate jdbcTemplate;

	private RowMapper<Parametros> rwMap = new RowMapper<Parametros>() {
		public Parametros mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Parametros(resultSet.getString("PARAMETRO"),
					resultSet.getString("VALOR"),
					resultSet.getString("DESCRIPCIONES"),
					resultSet.getString("DESCRIPCIONEU"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the PARAMETROS table.
	 * 
	 * @param PARAMETROS
	 *            Pagination
	 * @return parametros
	 */
	// public Parametros add(Parametros parametros) {
	// String query =
	// "INSERT INTO PARAMETROS (PARAMETRO, VALOR, DESCRIPCIONES, DESCRIPCIONEU) VALUES (?,?,?,?)";
	// this.jdbcTemplate.update(query, parametros.getParametro(),
	// parametros.getValor(), parametros.getDescripciones(),
	// parametros.getDescripcioneu());
	// return parametros;
	// }

	/**
	 * Updates a single row in the PARAMETROS table.
	 * 
	 * @param PARAMETROS
	 *            Pagination
	 * @return parametros
	 */
	// public Parametros update(Parametros parametros) {
	// String query =
	// "UPDATE PARAMETROS SET VALOR=?, DESCRIPCIONES=?, DESCRIPCIONEU=? WHERE PARAMETRO=?";
	// this.jdbcTemplate.update(query, parametros.getValor(),
	// parametros.getDescripciones(), parametros.getDescripcioneu(),
	// parametros.getParametro());
	// return parametros;
	// }

	/**
	 * Finds a single row in the PARAMETROS table.
	 * 
	 * @param PARAMETROS
	 *            Pagination
	 * @return parametros
	 */
	@Transactional(readOnly = true)
	public Parametros find(Parametros parametros) {
		String query = "SELECT t1.PARAMETRO PARAMETRO, t1.VALOR VALOR,t1.DESCRIPCIONES DESCRIPCIONES, t1.DESCRIPCIONEU DESCRIPCIONEU FROM PARAMETROS t1  WHERE t1.PARAMETRO = ?  ";

		List<Parametros> parametrosList = this.jdbcTemplate.query(query,
				this.rwMap, parametros.getParametro());
		return (Parametros) DataAccessUtils.uniqueResult(parametrosList);
	}

	/**
	 * Removes a single row in the PARAMETROS table.
	 * 
	 * @param PARAMETROS
	 *            Pagination
	 * @return
	 */
	// public void remove(Parametros parametros) {
	// String query = "DELETE FROM PARAMETROS WHERE PARAMETRO=?";
	// this.jdbcTemplate.update(query, parametros.getParametro());
	// }

	/**
	 * Finds a List of rows in the PARAMETROS table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	// @Transactional(readOnly = true)
	// public List<Parametros> findAll(Parametros parametros, Pagination
	// pagination) {
	// StringBuffer query = new StringBuffer(
	// "SELECT  t1.PARAMETRO PARAMETRO,t1.VALOR VALOR,t1.DESCRIPCIONES DESCRIPCIONES, t1.DESCRIPCIONEU DESCRIPCIONEU ");
	// query.append("FROM PARAMETROS t1 ");
	//
	// // Where clause & Params
	// Map<String, ?> mapaWhere = this.getWhereMap(parametros);
	// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
	// where.append(mapaWhere.get("query"));
	// query.append(where);
	//
	// List<?> params = (List<?>) mapaWhere.get("params");
	//
	// StringBuilder order = new StringBuilder(3000);
	// if (pagination != null) {
	// if (pagination.getSort() != null) {
	// order.append(" ORDER BY " + pagination.getSort() + " "
	// + pagination.getAscDsc());
	// query.append(order);
	// }
	// query = new StringBuffer(PaginationManager.getQueryLimits(
	// pagination, query.toString()));
	// }
	//
	// return (List<Parametros>) this.jdbcTemplate.query(query.toString(),
	// this.rwMap, params.toArray());
	// }

	/**
	 * Counts rows in the PARAMETROS table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @return Long
	 */
	// @Transactional(readOnly = true)
	// public Long findAllCount(Parametros parametros) {
	// StringBuilder query = new StringBuilder(
	// "SELECT COUNT(1) FROM PARAMETROS t1 ");
	//
	// // Where clause & Params
	// Map<String, ?> mapaWhere = this.getWhereMap(parametros);
	// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
	// where.append(mapaWhere.get("query"));
	// query.append(where);
	//
	// List<?> params = (List<?>) mapaWhere.get("params");
	//
	// return this.jdbcTemplate.queryForLong(query.toString(),
	// params.toArray());
	// }

	/**
	 * Finds rows in the PARAMETROS table using like.
	 * 
	 * @param Parametros
	 *            parametros
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	// @Transactional(readOnly = true)
	// public List<Parametros> findAllLike(Parametros parametros,
	// Pagination pagination, Boolean startsWith) {
	// StringBuffer query = new StringBuffer(
	// "SELECT  t1.PARAMETRO PARAMETRO,t1.VALOR VALOR,t1.DESCRIPCIONES DESCRIPCIONES, t1.DESCRIPCIONEU DESCRIPCIONEU ");
	// query.append("FROM PARAMETROS t1 ");
	//
	// // Where clause & Params
	// Map<String, ?> mapaWhere = this.getWhereLikeMap(parametros, startsWith);
	// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
	// where.append(mapaWhere.get("query"));
	// query.append(where);
	//
	// List<?> params = (List<?>) mapaWhere.get("params");
	//
	// StringBuffer order = new StringBuffer(3000);
	// if (pagination != null) {
	// if (pagination.getSort() != null) {
	// order.append(" ORDER BY " + pagination.getSort() + " "
	// + pagination.getAscDsc());
	// query.append(order);
	// }
	// query = new StringBuffer(PaginationManager.getQueryLimits(
	// pagination, query.toString()));
	// }
	//
	// return (List<Parametros>) this.jdbcTemplate.query(query.toString(),
	// this.rwMap, params.toArray());
	// }

	/**
	 * Counts rows in the PARAMETROS table using like.
	 * 
	 * @param Parametros
	 *            parametros
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	// @Transactional(readOnly = true)
	// public Long findAllLikeCount(Parametros parametros, Boolean startsWith) {
	// StringBuilder query = new StringBuilder(
	// "SELECT COUNT(1) FROM PARAMETROS t1 ");
	//
	// // Where clause & Params
	// Map<String, ?> mapaWhere = this.getWhereLikeMap(parametros, startsWith);
	// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
	// where.append(mapaWhere.get("query"));
	// query.append(where);
	//
	// List<?> params = (List<?>) mapaWhere.get("params");
	//
	// return this.jdbcTemplate.queryForLong(query.toString(),
	// params.toArray());
	// }

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the PARAMETROS entity
	 * 
	 * @param Parametros
	 *            parametros Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	// private Map<String, ?> getWhereMap(Parametros parametros) {
	//
	// StringBuilder where = new StringBuilder(
	// ParametrosDaoImpl.STRING_BUILDER_INIT);
	// List<Object> params = new ArrayList<Object>();
	//
	// if (parametros != null && parametros.getParametro() != null) {
	// where.append(" AND t1.PARAMETRO = ?");
	// params.add(parametros.getParametro());
	// }
	// if (parametros != null && parametros.getValor() != null) {
	// where.append(" AND t1.VALOR = ?");
	// params.add(parametros.getValor());
	// }
	// if (parametros != null && parametros.getDescripciones() != null) {
	// where.append(" AND t1.DESCRIPCIONES = ?");
	// params.add(parametros.getDescripciones());
	// }
	// if (parametros != null && parametros.getDescripcioneu() != null) {
	// where.append(" AND t1.DESCRIPCIONEU = ?");
	// params.add(parametros.getDescripcioneu());
	// }
	//
	// Map<String, Object> mapWhere = new HashMap<String, Object>();
	// mapWhere.put("query", where);
	// mapWhere.put("params", params);
	//
	// return mapWhere;
	// }

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the PARAMETROS entity
	 * 
	 * @param Parametros
	 *            parametros Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	// private Map<String, ?> getWhereLikeMap(Parametros parametros,
	// Boolean startsWith) {
	//
	// StringBuilder where = new StringBuilder(
	// ParametrosDaoImpl.STRING_BUILDER_INIT);
	// List<Object> params = new ArrayList<Object>();
	//
	// if (parametros != null && parametros.getParametro() != null) {
	// where.append(" AND UPPER(t1.PARAMETRO) like ? ESCAPE  '\\'");
	// if (startsWith) {
	// params.add(parametros.getParametro().toUpperCase() + "%");
	// } else {
	// params.add("%" + parametros.getParametro().toUpperCase() + "%");
	// }
	// where.append(" AND t1.PARAMETRO IS NOT NULL");
	// }
	// if (parametros != null && parametros.getValor() != null) {
	// where.append(" AND UPPER(t1.VALOR) like ? ESCAPE  '\\'");
	// if (startsWith) {
	// params.add(parametros.getValor().toUpperCase() + "%");
	// } else {
	// params.add("%" + parametros.getValor().toUpperCase() + "%");
	// }
	// where.append(" AND t1.VALOR IS NOT NULL");
	// }
	// if (parametros != null && parametros.getDescripciones() != null) {
	// where.append(" AND TRANSLATE(UPPER(t1.DESCRIPCIONES),'�����','AEIOU') like ? ESCAPE  '\\'");
	// if (startsWith) {
	// params.add(parametros.getDescripciones().toUpperCase()
	// .replaceAll("�", "A").replaceAll("�", "E")
	// .replaceAll("�", "I").replaceAll("�", "O")
	// .replaceAll("�", "U")
	// + "%");
	// } else {
	// params.add("%"
	// + parametros.getDescripciones().toUpperCase()
	// .replaceAll("�", "A").replaceAll("�", "E")
	// .replaceAll("�", "I").replaceAll("�", "O")
	// .replaceAll("�", "U") + "%");
	// }
	// where.append(" AND t1.DESCRIPCIONES IS NOT NULL");
	// }
	// if (parametros != null && parametros.getDescripcioneu() != null) {
	// where.append(" AND TRANSLATE(UPPER(t1.DESCRIPCIONEU),'�����','AEIOU') like ? ESCAPE  '\\'");
	// if (startsWith) {
	// params.add(parametros.getDescripcioneu().toUpperCase()
	// .replaceAll("�", "A").replaceAll("�", "E")
	// .replaceAll("�", "I").replaceAll("�", "O")
	// .replaceAll("�", "U")
	// + "%");
	// } else {
	// params.add("%"
	// + parametros.getDescripcioneu().toUpperCase()
	// .replaceAll("�", "A").replaceAll("�", "E")
	// .replaceAll("�", "I").replaceAll("�", "O")
	// .replaceAll("�", "U") + "%");
	// }
	// where.append(" AND t1.DESCRIPCIONEU IS NOT NULL");
	// }
	// Map<String, Object> mapWhere = new HashMap<String, Object>();
	// mapWhere.put("query", where);
	// mapWhere.put("params", params);
	//
	// return mapWhere;
	// }

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
