package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Pais;

/**
 *  * PaisDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 *  
 */
 
@Repository
@Transactional
public class PaisDaoImpl implements PaisDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Pais> rwMap = new RowMapper<Pais>() {
		public Pais mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Pais(
               resultSet.getString("PACODIGO"), resultSet.getString("PACOAL2"), resultSet.getString("PACOAL3"), resultSet.getString("PANOMBRE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Pais table.
     *
     * @param pais Pagination
     * @return Pais
     */
	public Pais add(Pais pais) {

    	String query = "INSERT INTO PAIS( PACODIGO,PACOAL2,PACOAL3,PANOMBRE)"
        + "VALUES (?,?,?,?)";

		this.jdbcTemplate.update(query, pais.getPacodigo(), pais.getPacoal2(), pais.getPacoal3(), pais.getPanombre());
		return pais;
	}

    /**
     * Updates a single row in the Pais table.
     *
     * @param pais Pagination
     * @return Pais
     */
    public Pais update(Pais pais) {
		String query = "UPDATE PAIS SET PACOAL2=?,PACOAL3=?,PANOMBRE=? WHERE PACODIGO=?";
		this.jdbcTemplate.update(query, pais.getPacoal2(), pais.getPacoal3(), pais.getPanombre(), pais.getPacodigo());
		return pais;
	}

    /**
     * Finds a single row in the Pais table.
     *
     * @param pais Pagination
     * @return Pais
     */
    @Transactional (readOnly = true)
    public Pais find(Pais pais) {
		String query = "SELECT t1.PACODIGO PACODIGO, t1.PACOAL2 PACOAL2, t1.PACOAL3 PACOAL3, t1.PANOMBRE PANOMBRE " 
         + "FROM PAIS t1  " 
         + "WHERE t1.PACODIGO = ?    ";
		return (Pais) this.jdbcTemplate.queryForObject(query, 
			rwMap , pais.getPacodigo());	 
    }

    /**
     * Removes a single row in the Pais table.
     *
     * @param pais Pagination
     * @return
     */
    public void remove(Pais pais) {
		String query = "DELETE  FROM PAIS WHERE PACODIGO=?";
		this.jdbcTemplate.update(query, pais.getPacodigo());
    	}
    
   /**
    * Finds a List of rows in the Pais table.
    * 
    * @param pais Pais
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Pais> findAll(Pais pais, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.PACODIGO PACODIGO,t1.PACOAL2 PACOAL2,t1.PACOAL3 PACOAL3,t1.PANOMBRE PANOMBRE " 
			+ "FROM PAIS t1 ");
		
		if (pais  != null  && pais.getPacodigo() != null ) {
			where.append(" AND t1.PACODIGO = ?");
			params.add(pais.getPacodigo());
		}
		if (pais  != null  && pais.getPacoal2() != null ) {
			where.append(" AND t1.PACOAL2 = ?");
			params.add(pais.getPacoal2());
		}
		if (pais  != null  && pais.getPacoal3() != null ) {
			where.append(" AND t1.PACOAL3 = ?");
			params.add(pais.getPacoal3());
		}
		if (pais  != null  && pais.getPanombre() != null ) {
			where.append(" AND t1.PANOMBRE = ?");
			params.add(pais.getPanombre());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<Pais>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Pais table.
     * 
     * @param pais Pais
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Pais pais) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  PAIS t1  ");
		if (pais  != null  && pais.getPacodigo() != null ) {
			where.append(" AND t1.PACODIGO = ?");
			params.add(pais.getPacodigo());
		}
		if (pais  != null  && pais.getPacoal2() != null ) {
			where.append(" AND t1.PACOAL2 = ?");
			params.add(pais.getPacoal2());
		}
		if (pais  != null  && pais.getPacoal3() != null ) {
			where.append(" AND t1.PACOAL3 = ?");
			params.add(pais.getPacoal3());
		}
		if (pais  != null  && pais.getPanombre() != null ) {
			where.append(" AND t1.PANOMBRE = ?");
			params.add(pais.getPanombre());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Pais table using like.
     * 
     * @param pais Pais
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Pais> findAllLike(Pais pais, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.PACODIGO PACODIGO,t1.PACOAL2 PACOAL2,t1.PACOAL3 PACOAL3,t1.PANOMBRE PANOMBRE " 
        	+ "FROM PAIS t1 ");
      	
		if (pais  != null  && pais.getPacodigo() != null ) {
			where.append(" AND UPPER(t1.PACODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(pais.getPacodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+pais.getPacodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.PACODIGO IS NOT NULL");
        }
		if (pais  != null  && pais.getPacoal2() != null ) {
			where.append(" AND UPPER(t1.PACOAL2) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(pais.getPacoal2().toUpperCase()  +"%");
			}else{
				params.add("%"+pais.getPacoal2().toUpperCase() +"%");
			}	
			where.append(" AND t1.PACOAL2 IS NOT NULL");
        }
		if (pais  != null  && pais.getPacoal3() != null ) {
			where.append(" AND UPPER(t1.PACOAL3) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(pais.getPacoal3().toUpperCase()  +"%");
			}else{
				params.add("%"+pais.getPacoal3().toUpperCase() +"%");
			}	
			where.append(" AND t1.PACOAL3 IS NOT NULL");
        }
		if (pais  != null  && pais.getPanombre() != null ) {
			where.append(" AND UPPER(t1.PANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(pais.getPanombre().toUpperCase()  +"%");
			}else{
				params.add("%"+pais.getPanombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.PANOMBRE IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<Pais>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

