package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.OriProdAlerta;

/**
 *  * OriProdAlertaDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 *  
 */
 
@Repository
@Transactional
public class OriProdAlertaDaoImpl implements OriProdAlertaDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<OriProdAlerta> rwMap = new RowMapper<OriProdAlerta>() {
		public OriProdAlerta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new OriProdAlerta(
               resultSet.getString("TOMCODIGO"), resultSet.getString("TOMNOMBRE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the OriProdAlerta table.
     *
     * @param oriprodalerta Pagination
     * @return OriProdAlerta
     */
	public OriProdAlerta add(OriProdAlerta oriprodalerta) {

    	String query = "INSERT INTO ORI_PROD_ALERTA( TOMCODIGO,TOMNOMBRE)"
        + "VALUES (?,?)";

		this.jdbcTemplate.update(query, oriprodalerta.getTomcodigo(), oriprodalerta.getTomnombre());
		return oriprodalerta;
	}

    /**
     * Updates a single row in the OriProdAlerta table.
     *
     * @param oriprodalerta Pagination
     * @return OriProdAlerta
     */
    public OriProdAlerta update(OriProdAlerta oriprodalerta) {
		String query = "UPDATE ORI_PROD_ALERTA SET TOMNOMBRE=? WHERE TOMCODIGO=?";
		this.jdbcTemplate.update(query, oriprodalerta.getTomnombre(), oriprodalerta.getTomcodigo());
		return oriprodalerta;
	}

    /**
     * Finds a single row in the OriProdAlerta table.
     *
     * @param oriprodalerta Pagination
     * @return OriProdAlerta
     */
    @Transactional (readOnly = true)
    public OriProdAlerta find(OriProdAlerta oriprodalerta) {
		String query = "SELECT t1.TOMCODIGO TOMCODIGO, t1.TOMNOMBRE TOMNOMBRE " 
         + "FROM ORI_PROD_ALERTA t1  " 
         + "WHERE t1.TOMCODIGO = ?    ";
		return (OriProdAlerta) this.jdbcTemplate.queryForObject(query, 
			rwMap , oriprodalerta.getTomcodigo());	 
    }

    /**
     * Removes a single row in the OriProdAlerta table.
     *
     * @param oriprodalerta Pagination
     * @return
     */
    public void remove(OriProdAlerta oriprodalerta) {
		String query = "DELETE  FROM ORI_PROD_ALERTA WHERE TOMCODIGO=?";
		this.jdbcTemplate.update(query, oriprodalerta.getTomcodigo());
    	}
    
   /**
    * Finds a List of rows in the OriProdAlerta table.
    * 
    * @param oriprodalerta OriProdAlerta
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<OriProdAlerta> findAll(OriProdAlerta oriprodalerta, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TOMCODIGO TOMCODIGO,t1.TOMNOMBRE TOMNOMBRE " 
			+ "FROM ORI_PROD_ALERTA t1 ");
		
		if (oriprodalerta  != null  && oriprodalerta.getTomcodigo() != null ) {
			where.append(" AND t1.TOMCODIGO = ?");
			params.add(oriprodalerta.getTomcodigo());
		}
		if (oriprodalerta  != null  && oriprodalerta.getTomnombre() != null ) {
			where.append(" AND t1.TOMNOMBRE = ?");
			params.add(oriprodalerta.getTomnombre());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<OriProdAlerta>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the OriProdAlerta table.
     * 
     * @param oriprodalerta OriProdAlerta
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(OriProdAlerta oriprodalerta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORI_PROD_ALERTA t1  ");
		if (oriprodalerta  != null  && oriprodalerta.getTomcodigo() != null ) {
			where.append(" AND t1.TOMCODIGO = ?");
			params.add(oriprodalerta.getTomcodigo());
		}
		if (oriprodalerta  != null  && oriprodalerta.getTomnombre() != null ) {
			where.append(" AND t1.TOMNOMBRE = ?");
			params.add(oriprodalerta.getTomnombre());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the OriProdAlerta table using like.
     * 
     * @param oriprodalerta OriProdAlerta
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<OriProdAlerta> findAllLike(OriProdAlerta oriprodalerta, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TOMCODIGO TOMCODIGO,t1.TOMNOMBRE TOMNOMBRE " 
        	+ "FROM ORI_PROD_ALERTA t1 ");
      	
		if (oriprodalerta  != null  && oriprodalerta.getTomcodigo() != null ) {
			where.append(" AND UPPER(t1.TOMCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(oriprodalerta.getTomcodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+oriprodalerta.getTomcodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.TOMCODIGO IS NOT NULL");
        }
		if (oriprodalerta  != null  && oriprodalerta.getTomnombre() != null ) {
			where.append(" AND UPPER(t1.TOMNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(oriprodalerta.getTomnombre().toUpperCase()  +"%");
			}else{
				params.add("%"+oriprodalerta.getTomnombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.TOMNOMBRE IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<OriProdAlerta>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

